# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.dashboard import DashboardManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-dashboard
# USAGE
    python grafana_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DashboardManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.grafana.begin_update(
        resource_group_name="myResourceGroup",
        workspace_name="myWorkspace",
        request_body_parameters={
            "properties": {
                "apiKey": "Enabled",
                "deterministicOutboundIP": "Enabled",
                "enterpriseConfigurations": {"marketplaceAutoRenew": "Enabled", "marketplacePlanId": "myPlanId"},
                "grafanaConfigurations": {
                    "security": {"csrfAlwaysCheck": False},
                    "smtp": {
                        "enabled": True,
                        "fromAddress": "test@sendemail.com",
                        "fromName": "emailsender",
                        "host": "smtp.sendemail.com:587",
                        "password": "<password>",
                        "skipVerify": True,
                        "startTLSPolicy": "OpportunisticStartTLS",
                        "user": "username",
                    },
                    "snapshots": {"externalEnabled": True},
                    "unifiedAlertingScreenshots": {"captureEnabled": False},
                    "users": {"editorsCanAdmin": True, "viewersCanEdit": True},
                },
                "grafanaIntegrations": {
                    "azureMonitorWorkspaceIntegrations": [
                        {
                            "azureMonitorWorkspaceResourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"
                        }
                    ]
                },
                "grafanaMajorVersion": "9",
                "grafanaPlugins": {"sample-plugin-id": {}},
            },
            "sku": {"name": "Standard"},
            "tags": {"Environment": "Dev 2"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2024-11-01-preview/Grafana_Update.json
if __name__ == "__main__":
    main()
