# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.web import WebSiteManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebSiteManagementStaticSitesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WebSiteManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_preview_workflow(self, resource_group):
        response = self.client.static_sites.preview_workflow(
            location="str",
            static_sites_workflow_preview_request={
                "branch": "str",
                "buildProperties": {
                    "apiBuildCommand": "str",
                    "apiLocation": "str",
                    "appArtifactLocation": "str",
                    "appBuildCommand": "str",
                    "appLocation": "str",
                    "githubActionSecretNameOverride": "str",
                    "outputLocation": "str",
                    "skipGithubActionWorkflowGeneration": bool,
                },
                "id": "str",
                "kind": "str",
                "name": "str",
                "repositoryUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list(self, resource_group):
        response = self.client.static_sites.list(
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_static_sites_by_resource_group(self, resource_group):
        response = self.client.static_sites.get_static_sites_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_static_site(self, resource_group):
        response = self.client.static_sites.get_static_site(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_create_or_update_static_site(self, resource_group):
        response = self.client.static_sites.begin_create_or_update_static_site(
            resource_group_name=resource_group.name,
            name="str",
            static_site_envelope={
                "location": "str",
                "allowConfigFileUpdates": bool,
                "branch": "str",
                "buildProperties": {
                    "apiBuildCommand": "str",
                    "apiLocation": "str",
                    "appArtifactLocation": "str",
                    "appBuildCommand": "str",
                    "appLocation": "str",
                    "githubActionSecretNameOverride": "str",
                    "outputLocation": "str",
                    "skipGithubActionWorkflowGeneration": bool,
                },
                "contentDistributionEndpoint": "str",
                "customDomains": ["str"],
                "databaseConnections": [
                    {
                        "configurationFiles": [{"contents": "str", "fileName": "str", "type": "str"}],
                        "connectionIdentity": "str",
                        "name": "str",
                        "region": "str",
                        "resourceId": "str",
                    }
                ],
                "defaultHostname": "str",
                "enterpriseGradeCdnStatus": "str",
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "linkedBackends": [
                    {
                        "backendResourceId": "str",
                        "createdOn": "2020-02-20 00:00:00",
                        "provisioningState": "str",
                        "region": "str",
                    }
                ],
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "error": {
                            "code": "str",
                            "details": [...],
                            "extendedCode": "str",
                            "innerErrors": [...],
                            "message": "str",
                            "messageTemplate": "str",
                            "parameters": ["str"],
                            "target": "str",
                        },
                        "id": "str",
                        "identity": {
                            "principalId": "str",
                            "tenantId": "str",
                            "type": "str",
                            "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                        },
                        "location": "str",
                        "name": "str",
                        "plan": {
                            "name": "str",
                            "product": "str",
                            "promotionCode": "str",
                            "publisher": "str",
                            "version": "str",
                        },
                        "properties": {
                            "id": "str",
                            "ipAddresses": ["str"],
                            "kind": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "type": "str",
                        },
                        "sku": {
                            "capabilities": [{"name": "str", "reason": "str", "value": "str"}],
                            "capacity": 0,
                            "family": "str",
                            "locations": ["str"],
                            "name": "str",
                            "size": "str",
                            "skuCapacity": {
                                "default": 0,
                                "elasticMaximum": 0,
                                "maximum": 0,
                                "minimum": 0,
                                "scaleType": "str",
                            },
                            "tier": "str",
                        },
                        "status": "str",
                        "tags": {"str": "str"},
                        "type": "str",
                        "zones": ["str"],
                    }
                ],
                "provider": "str",
                "publicNetworkAccess": "str",
                "repositoryToken": "str",
                "repositoryUrl": "str",
                "sku": {
                    "capabilities": [{"name": "str", "reason": "str", "value": "str"}],
                    "capacity": 0,
                    "family": "str",
                    "locations": ["str"],
                    "name": "str",
                    "size": "str",
                    "skuCapacity": {"default": 0, "elasticMaximum": 0, "maximum": 0, "minimum": 0, "scaleType": "str"},
                    "tier": "str",
                },
                "stagingEnvironmentPolicy": "str",
                "tags": {"str": "str"},
                "templateProperties": {
                    "description": "str",
                    "isPrivate": bool,
                    "owner": "str",
                    "repositoryName": "str",
                    "templateRepositoryUrl": "str",
                },
                "type": "str",
                "userProvidedFunctionApps": [
                    {
                        "createdOn": "2020-02-20 00:00:00",
                        "functionAppRegion": "str",
                        "functionAppResourceId": "str",
                        "id": "str",
                        "kind": "str",
                        "name": "str",
                        "type": "str",
                    }
                ],
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_delete_static_site(self, resource_group):
        response = self.client.static_sites.begin_delete_static_site(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_update_static_site(self, resource_group):
        response = self.client.static_sites.update_static_site(
            resource_group_name=resource_group.name,
            name="str",
            static_site_envelope={
                "allowConfigFileUpdates": bool,
                "branch": "str",
                "buildProperties": {
                    "apiBuildCommand": "str",
                    "apiLocation": "str",
                    "appArtifactLocation": "str",
                    "appBuildCommand": "str",
                    "appLocation": "str",
                    "githubActionSecretNameOverride": "str",
                    "outputLocation": "str",
                    "skipGithubActionWorkflowGeneration": bool,
                },
                "contentDistributionEndpoint": "str",
                "customDomains": ["str"],
                "databaseConnections": [
                    {
                        "configurationFiles": [{"contents": "str", "fileName": "str", "type": "str"}],
                        "connectionIdentity": "str",
                        "name": "str",
                        "region": "str",
                        "resourceId": "str",
                    }
                ],
                "defaultHostname": "str",
                "enterpriseGradeCdnStatus": "str",
                "id": "str",
                "keyVaultReferenceIdentity": "str",
                "kind": "str",
                "linkedBackends": [
                    {
                        "backendResourceId": "str",
                        "createdOn": "2020-02-20 00:00:00",
                        "provisioningState": "str",
                        "region": "str",
                    }
                ],
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "error": {
                            "code": "str",
                            "details": [...],
                            "extendedCode": "str",
                            "innerErrors": [...],
                            "message": "str",
                            "messageTemplate": "str",
                            "parameters": ["str"],
                            "target": "str",
                        },
                        "id": "str",
                        "identity": {
                            "principalId": "str",
                            "tenantId": "str",
                            "type": "str",
                            "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                        },
                        "location": "str",
                        "name": "str",
                        "plan": {
                            "name": "str",
                            "product": "str",
                            "promotionCode": "str",
                            "publisher": "str",
                            "version": "str",
                        },
                        "properties": {
                            "id": "str",
                            "ipAddresses": ["str"],
                            "kind": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "type": "str",
                        },
                        "sku": {
                            "capabilities": [{"name": "str", "reason": "str", "value": "str"}],
                            "capacity": 0,
                            "family": "str",
                            "locations": ["str"],
                            "name": "str",
                            "size": "str",
                            "skuCapacity": {
                                "default": 0,
                                "elasticMaximum": 0,
                                "maximum": 0,
                                "minimum": 0,
                                "scaleType": "str",
                            },
                            "tier": "str",
                        },
                        "status": "str",
                        "tags": {"str": "str"},
                        "type": "str",
                        "zones": ["str"],
                    }
                ],
                "provider": "str",
                "publicNetworkAccess": "str",
                "repositoryToken": "str",
                "repositoryUrl": "str",
                "stagingEnvironmentPolicy": "str",
                "templateProperties": {
                    "description": "str",
                    "isPrivate": bool,
                    "owner": "str",
                    "repositoryName": "str",
                    "templateRepositoryUrl": "str",
                },
                "type": "str",
                "userProvidedFunctionApps": [
                    {
                        "createdOn": "2020-02-20 00:00:00",
                        "functionAppRegion": "str",
                        "functionAppResourceId": "str",
                        "id": "str",
                        "kind": "str",
                        "name": "str",
                        "type": "str",
                    }
                ],
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_users(self, resource_group):
        response = self.client.static_sites.list_static_site_users(
            resource_group_name=resource_group.name,
            name="str",
            authprovider="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_delete_static_site_user(self, resource_group):
        response = self.client.static_sites.delete_static_site_user(
            resource_group_name=resource_group.name,
            name="str",
            authprovider="str",
            userid="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_update_static_site_user(self, resource_group):
        response = self.client.static_sites.update_static_site_user(
            resource_group_name=resource_group.name,
            name="str",
            authprovider="str",
            userid="str",
            static_site_user_envelope={
                "displayName": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "provider": "str",
                "roles": "str",
                "type": "str",
                "userId": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_static_site_builds(self, resource_group):
        response = self.client.static_sites.get_static_site_builds(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_static_site_build(self, resource_group):
        response = self.client.static_sites.get_static_site_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_delete_static_site_build(self, resource_group):
        response = self.client.static_sites.begin_delete_static_site_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_create_or_update_static_site_build_app_settings(self, resource_group):
        response = self.client.static_sites.create_or_update_static_site_build_app_settings(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            app_settings={"id": "str", "kind": "str", "name": "str", "properties": {"str": "str"}, "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_create_or_update_static_site_build_function_app_settings(self, resource_group):
        response = self.client.static_sites.create_or_update_static_site_build_function_app_settings(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            app_settings={"id": "str", "kind": "str", "name": "str", "properties": {"str": "str"}, "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_build_database_connections(self, resource_group):
        response = self.client.static_sites.get_build_database_connections(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_build_database_connection(self, resource_group):
        response = self.client.static_sites.get_build_database_connection(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            database_connection_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_create_or_update_build_database_connection(self, resource_group):
        response = self.client.static_sites.create_or_update_build_database_connection(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            database_connection_name="str",
            database_connection_request_envelope={
                "configurationFiles": [{"contents": "str", "fileName": "str", "type": "str"}],
                "connectionIdentity": "str",
                "connectionString": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "region": "str",
                "resourceId": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_delete_build_database_connection(self, resource_group):
        response = self.client.static_sites.delete_build_database_connection(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            database_connection_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_update_build_database_connection(self, resource_group):
        response = self.client.static_sites.update_build_database_connection(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            database_connection_name="str",
            database_connection_request_envelope={
                "connectionIdentity": "str",
                "connectionString": "str",
                "region": "str",
                "resourceId": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_build_database_connection_with_details(self, resource_group):
        response = self.client.static_sites.get_build_database_connection_with_details(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            database_connection_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_build_functions(self, resource_group):
        response = self.client.static_sites.list_static_site_build_functions(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_build_app_settings(self, resource_group):
        response = self.client.static_sites.list_static_site_build_app_settings(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_build_function_app_settings(self, resource_group):
        response = self.client.static_sites.list_static_site_build_function_app_settings(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_build_database_connections_with_details(self, resource_group):
        response = self.client.static_sites.get_build_database_connections_with_details(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_user_provided_function_apps_for_static_site_build(self, resource_group):
        response = self.client.static_sites.get_user_provided_function_apps_for_static_site_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_user_provided_function_app_for_static_site_build(self, resource_group):
        response = self.client.static_sites.get_user_provided_function_app_for_static_site_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            function_app_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_register_user_provided_function_app_with_static_site_build(self, resource_group):
        response = self.client.static_sites.begin_register_user_provided_function_app_with_static_site_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            function_app_name="str",
            static_site_user_provided_function_envelope={
                "createdOn": "2020-02-20 00:00:00",
                "functionAppRegion": "str",
                "functionAppResourceId": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_detach_user_provided_function_app_from_static_site_build(self, resource_group):
        response = self.client.static_sites.detach_user_provided_function_app_from_static_site_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            function_app_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_create_zip_deployment_for_static_site_build(self, resource_group):
        response = self.client.static_sites.begin_create_zip_deployment_for_static_site_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            static_site_zip_deployment_envelope={
                "apiZipUrl": "str",
                "appZipUrl": "str",
                "deploymentTitle": "str",
                "functionLanguage": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "provider": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_create_or_update_static_site_app_settings(self, resource_group):
        response = self.client.static_sites.create_or_update_static_site_app_settings(
            resource_group_name=resource_group.name,
            name="str",
            app_settings={"id": "str", "kind": "str", "name": "str", "properties": {"str": "str"}, "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_basic_auth(self, resource_group):
        response = self.client.static_sites.list_basic_auth(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_basic_auth(self, resource_group):
        response = self.client.static_sites.get_basic_auth(
            resource_group_name=resource_group.name,
            name="str",
            basic_auth_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_create_or_update_basic_auth(self, resource_group):
        response = self.client.static_sites.create_or_update_basic_auth(
            resource_group_name=resource_group.name,
            name="str",
            basic_auth_name="str",
            basic_auth_envelope={
                "applicableEnvironmentsMode": "str",
                "environments": ["str"],
                "id": "str",
                "kind": "str",
                "name": "str",
                "password": "str",
                "secretState": "str",
                "secretUrl": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_create_or_update_static_site_function_app_settings(self, resource_group):
        response = self.client.static_sites.create_or_update_static_site_function_app_settings(
            resource_group_name=resource_group.name,
            name="str",
            app_settings={"id": "str", "kind": "str", "name": "str", "properties": {"str": "str"}, "type": "str"},
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_create_user_roles_invitation_link(self, resource_group):
        response = self.client.static_sites.create_user_roles_invitation_link(
            resource_group_name=resource_group.name,
            name="str",
            static_site_user_roles_invitation_envelope={
                "domain": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "numHoursToExpiration": 0,
                "provider": "str",
                "roles": "str",
                "type": "str",
                "userDetails": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_custom_domains(self, resource_group):
        response = self.client.static_sites.list_static_site_custom_domains(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_static_site_custom_domain(self, resource_group):
        response = self.client.static_sites.get_static_site_custom_domain(
            resource_group_name=resource_group.name,
            name="str",
            domain_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_create_or_update_static_site_custom_domain(self, resource_group):
        response = self.client.static_sites.begin_create_or_update_static_site_custom_domain(
            resource_group_name=resource_group.name,
            name="str",
            domain_name="str",
            static_site_custom_domain_request_properties_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
                "validationMethod": "cname-delegation",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_delete_static_site_custom_domain(self, resource_group):
        response = self.client.static_sites.begin_delete_static_site_custom_domain(
            resource_group_name=resource_group.name,
            name="str",
            domain_name="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_validate_custom_domain_can_be_added_to_static_site(self, resource_group):
        response = self.client.static_sites.begin_validate_custom_domain_can_be_added_to_static_site(
            resource_group_name=resource_group.name,
            name="str",
            domain_name="str",
            static_site_custom_domain_request_properties_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
                "validationMethod": "cname-delegation",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_database_connections(self, resource_group):
        response = self.client.static_sites.get_database_connections(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_database_connection(self, resource_group):
        response = self.client.static_sites.get_database_connection(
            resource_group_name=resource_group.name,
            name="str",
            database_connection_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_create_or_update_database_connection(self, resource_group):
        response = self.client.static_sites.create_or_update_database_connection(
            resource_group_name=resource_group.name,
            name="str",
            database_connection_name="str",
            database_connection_request_envelope={
                "configurationFiles": [{"contents": "str", "fileName": "str", "type": "str"}],
                "connectionIdentity": "str",
                "connectionString": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "region": "str",
                "resourceId": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_delete_database_connection(self, resource_group):
        response = self.client.static_sites.delete_database_connection(
            resource_group_name=resource_group.name,
            name="str",
            database_connection_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_update_database_connection(self, resource_group):
        response = self.client.static_sites.update_database_connection(
            resource_group_name=resource_group.name,
            name="str",
            database_connection_name="str",
            database_connection_request_envelope={
                "connectionIdentity": "str",
                "connectionString": "str",
                "region": "str",
                "resourceId": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_database_connection_with_details(self, resource_group):
        response = self.client.static_sites.get_database_connection_with_details(
            resource_group_name=resource_group.name,
            name="str",
            database_connection_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_detach_static_site(self, resource_group):
        response = self.client.static_sites.begin_detach_static_site(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_functions(self, resource_group):
        response = self.client.static_sites.list_static_site_functions(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_app_settings(self, resource_group):
        response = self.client.static_sites.list_static_site_app_settings(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_configured_roles(self, resource_group):
        response = self.client.static_sites.list_static_site_configured_roles(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_function_app_settings(self, resource_group):
        response = self.client.static_sites.list_static_site_function_app_settings(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_list_static_site_secrets(self, resource_group):
        response = self.client.static_sites.list_static_site_secrets(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_private_endpoint_connection_list(self, resource_group):
        response = self.client.static_sites.get_private_endpoint_connection_list(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_private_endpoint_connection(self, resource_group):
        response = self.client.static_sites.get_private_endpoint_connection(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_approve_or_reject_private_endpoint_connection(self, resource_group):
        response = self.client.static_sites.begin_approve_or_reject_private_endpoint_connection(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            private_endpoint_wrapper={
                "id": "str",
                "ipAddresses": ["str"],
                "kind": "str",
                "name": "str",
                "privateEndpoint": {"id": "str"},
                "privateLinkServiceConnectionState": {"actionsRequired": "str", "description": "str", "status": "str"},
                "provisioningState": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_delete_private_endpoint_connection(self, resource_group):
        response = self.client.static_sites.begin_delete_private_endpoint_connection(
            resource_group_name=resource_group.name,
            name="str",
            private_endpoint_connection_name="str",
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_private_link_resources(self, resource_group):
        response = self.client.static_sites.get_private_link_resources(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_reset_static_site_api_key(self, resource_group):
        response = self.client.static_sites.reset_static_site_api_key(
            resource_group_name=resource_group.name,
            name="str",
            reset_properties_envelope={
                "id": "str",
                "kind": "str",
                "name": "str",
                "repositoryToken": "str",
                "shouldUpdateRepository": bool,
                "type": "str",
            },
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_database_connections_with_details(self, resource_group):
        response = self.client.static_sites.get_database_connections_with_details(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_user_provided_function_apps_for_static_site(self, resource_group):
        response = self.client.static_sites.get_user_provided_function_apps_for_static_site(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_user_provided_function_app_for_static_site(self, resource_group):
        response = self.client.static_sites.get_user_provided_function_app_for_static_site(
            resource_group_name=resource_group.name,
            name="str",
            function_app_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_register_user_provided_function_app_with_static_site(self, resource_group):
        response = self.client.static_sites.begin_register_user_provided_function_app_with_static_site(
            resource_group_name=resource_group.name,
            name="str",
            function_app_name="str",
            static_site_user_provided_function_envelope={
                "createdOn": "2020-02-20 00:00:00",
                "functionAppRegion": "str",
                "functionAppResourceId": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_detach_user_provided_function_app_from_static_site(self, resource_group):
        response = self.client.static_sites.detach_user_provided_function_app_from_static_site(
            resource_group_name=resource_group.name,
            name="str",
            function_app_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_create_zip_deployment_for_static_site(self, resource_group):
        response = self.client.static_sites.begin_create_zip_deployment_for_static_site(
            resource_group_name=resource_group.name,
            name="str",
            static_site_zip_deployment_envelope={
                "apiZipUrl": "str",
                "appZipUrl": "str",
                "deploymentTitle": "str",
                "functionLanguage": "str",
                "id": "str",
                "kind": "str",
                "name": "str",
                "provider": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_validate_backend(self, resource_group):
        response = self.client.static_sites.begin_validate_backend(
            resource_group_name=resource_group.name,
            name="str",
            linked_backend_name="str",
            static_site_linked_backend_envelope={
                "backendResourceId": "str",
                "createdOn": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "name": "str",
                "provisioningState": "str",
                "region": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_validate_backend_for_build(self, resource_group):
        response = self.client.static_sites.begin_validate_backend_for_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            linked_backend_name="str",
            static_site_linked_backend_envelope={
                "backendResourceId": "str",
                "createdOn": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "name": "str",
                "provisioningState": "str",
                "region": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_linked_backends(self, resource_group):
        response = self.client.static_sites.get_linked_backends(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_linked_backends_for_build(self, resource_group):
        response = self.client.static_sites.get_linked_backends_for_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            api_version="2024-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_linked_backend(self, resource_group):
        response = self.client.static_sites.get_linked_backend(
            resource_group_name=resource_group.name,
            name="str",
            linked_backend_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_link_backend(self, resource_group):
        response = self.client.static_sites.begin_link_backend(
            resource_group_name=resource_group.name,
            name="str",
            linked_backend_name="str",
            static_site_linked_backend_envelope={
                "backendResourceId": "str",
                "createdOn": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "name": "str",
                "provisioningState": "str",
                "region": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_unlink_backend(self, resource_group):
        response = self.client.static_sites.unlink_backend(
            resource_group_name=resource_group.name,
            name="str",
            linked_backend_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_get_linked_backend_for_build(self, resource_group):
        response = self.client.static_sites.get_linked_backend_for_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            linked_backend_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_begin_link_backend_to_build(self, resource_group):
        response = self.client.static_sites.begin_link_backend_to_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            linked_backend_name="str",
            static_site_linked_backend_envelope={
                "backendResourceId": "str",
                "createdOn": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "name": "str",
                "provisioningState": "str",
                "region": "str",
                "type": "str",
            },
            api_version="2024-11-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_static_sites_unlink_backend_from_build(self, resource_group):
        response = self.client.static_sites.unlink_backend_from_build(
            resource_group_name=resource_group.name,
            name="str",
            environment_name="str",
            linked_backend_name="str",
            api_version="2024-11-01",
        )

        # please add some check logic here by yourself
        # ...
