# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Actions(_serialization.Model):
    """Actions to invoke when the alert fires.

    :ivar action_groups: Action Group resource Ids to invoke when the alert fires.
    :vartype action_groups: list[str]
    :ivar custom_properties: The properties of an alert payload.
    :vartype custom_properties: dict[str, str]
    """

    _attribute_map = {
        "action_groups": {"key": "actionGroups", "type": "[str]"},
        "custom_properties": {"key": "customProperties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        action_groups: Optional[List[str]] = None,
        custom_properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_groups: Action Group resource Ids to invoke when the alert fires.
        :paramtype action_groups: list[str]
        :keyword custom_properties: The properties of an alert payload.
        :paramtype custom_properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.action_groups = action_groups
        self.custom_properties = custom_properties


class Condition(_serialization.Model):
    """A condition of the scheduled query rule.

    :ivar query: Log query alert.
    :vartype query: str
    :ivar time_aggregation: Aggregation type. Relevant and required only for rules of the kind
     LogAlert. Known values are: "Count", "Average", "Minimum", "Maximum", and "Total".
    :vartype time_aggregation: str or
     ~azure.mgmt.monitor.v2022_08_01_preview.models.TimeAggregation
    :ivar metric_measure_column: The column containing the metric measure number. Relevant only for
     rules of the kind LogAlert.
    :vartype metric_measure_column: str
    :ivar resource_id_column: The column containing the resource id. The content of the column must
     be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
    :vartype resource_id_column: str
    :ivar dimensions: List of Dimensions conditions.
    :vartype dimensions: list[~azure.mgmt.monitor.v2022_08_01_preview.models.Dimension]
    :ivar operator: The criteria operator. Relevant and required only for rules of the kind
     LogAlert. Known values are: "Equals", "GreaterThan", "GreaterThanOrEqual", "LessThan", and
     "LessThanOrEqual".
    :vartype operator: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.ConditionOperator
    :ivar threshold: the criteria threshold value that activates the alert. Relevant and required
     only for rules of the kind LogAlert.
    :vartype threshold: float
    :ivar failing_periods: The minimum number of violations required within the selected lookback
     time window required to raise an alert. Relevant only for rules of the kind LogAlert.
    :vartype failing_periods:
     ~azure.mgmt.monitor.v2022_08_01_preview.models.ConditionFailingPeriods
    :ivar metric_name: The name of the metric to be sent. Relevant and required only for rules of
     the kind LogToMetric.
    :vartype metric_name: str
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
        "metric_measure_column": {"key": "metricMeasureColumn", "type": "str"},
        "resource_id_column": {"key": "resourceIdColumn", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "operator": {"key": "operator", "type": "str"},
        "threshold": {"key": "threshold", "type": "float"},
        "failing_periods": {"key": "failingPeriods", "type": "ConditionFailingPeriods"},
        "metric_name": {"key": "metricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        time_aggregation: Optional[Union[str, "_models.TimeAggregation"]] = None,
        metric_measure_column: Optional[str] = None,
        resource_id_column: Optional[str] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        operator: Optional[Union[str, "_models.ConditionOperator"]] = None,
        threshold: Optional[float] = None,
        failing_periods: Optional["_models.ConditionFailingPeriods"] = None,
        metric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query: Log query alert.
        :paramtype query: str
        :keyword time_aggregation: Aggregation type. Relevant and required only for rules of the kind
         LogAlert. Known values are: "Count", "Average", "Minimum", "Maximum", and "Total".
        :paramtype time_aggregation: str or
         ~azure.mgmt.monitor.v2022_08_01_preview.models.TimeAggregation
        :keyword metric_measure_column: The column containing the metric measure number. Relevant only
         for rules of the kind LogAlert.
        :paramtype metric_measure_column: str
        :keyword resource_id_column: The column containing the resource id. The content of the column
         must be a uri formatted as resource id. Relevant only for rules of the kind LogAlert.
        :paramtype resource_id_column: str
        :keyword dimensions: List of Dimensions conditions.
        :paramtype dimensions: list[~azure.mgmt.monitor.v2022_08_01_preview.models.Dimension]
        :keyword operator: The criteria operator. Relevant and required only for rules of the kind
         LogAlert. Known values are: "Equals", "GreaterThan", "GreaterThanOrEqual", "LessThan", and
         "LessThanOrEqual".
        :paramtype operator: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.ConditionOperator
        :keyword threshold: the criteria threshold value that activates the alert. Relevant and
         required only for rules of the kind LogAlert.
        :paramtype threshold: float
        :keyword failing_periods: The minimum number of violations required within the selected
         lookback time window required to raise an alert. Relevant only for rules of the kind LogAlert.
        :paramtype failing_periods:
         ~azure.mgmt.monitor.v2022_08_01_preview.models.ConditionFailingPeriods
        :keyword metric_name: The name of the metric to be sent. Relevant and required only for rules
         of the kind LogToMetric.
        :paramtype metric_name: str
        """
        super().__init__(**kwargs)
        self.query = query
        self.time_aggregation = time_aggregation
        self.metric_measure_column = metric_measure_column
        self.resource_id_column = resource_id_column
        self.dimensions = dimensions
        self.operator = operator
        self.threshold = threshold
        self.failing_periods = failing_periods
        self.metric_name = metric_name


class ConditionFailingPeriods(_serialization.Model):
    """The minimum number of violations required within the selected lookback time window required to
    raise an alert. Relevant only for rules of the kind LogAlert.

    :ivar number_of_evaluation_periods: The number of aggregated lookback points. The lookback time
     window is calculated based on the aggregation granularity (windowSize) and the selected number
     of aggregated points. Default value is 1.
    :vartype number_of_evaluation_periods: int
    :ivar min_failing_periods_to_alert: The number of violations to trigger an alert. Should be
     smaller or equal to numberOfEvaluationPeriods. Default value is 1.
    :vartype min_failing_periods_to_alert: int
    """

    _attribute_map = {
        "number_of_evaluation_periods": {"key": "numberOfEvaluationPeriods", "type": "int"},
        "min_failing_periods_to_alert": {"key": "minFailingPeriodsToAlert", "type": "int"},
    }

    def __init__(
        self, *, number_of_evaluation_periods: int = 1, min_failing_periods_to_alert: int = 1, **kwargs: Any
    ) -> None:
        """
        :keyword number_of_evaluation_periods: The number of aggregated lookback points. The lookback
         time window is calculated based on the aggregation granularity (windowSize) and the selected
         number of aggregated points. Default value is 1.
        :paramtype number_of_evaluation_periods: int
        :keyword min_failing_periods_to_alert: The number of violations to trigger an alert. Should be
         smaller or equal to numberOfEvaluationPeriods. Default value is 1.
        :paramtype min_failing_periods_to_alert: int
        """
        super().__init__(**kwargs)
        self.number_of_evaluation_periods = number_of_evaluation_periods
        self.min_failing_periods_to_alert = min_failing_periods_to_alert


class Dimension(_serialization.Model):
    """Dimension splitting and filtering definition.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the dimension. Required.
    :vartype name: str
    :ivar operator: Operator for dimension values. Required. Known values are: "Include" and
     "Exclude".
    :vartype operator: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.DimensionOperator
    :ivar values: List of dimension values. Required.
    :vartype values: list[str]
    """

    _validation = {
        "name": {"required": True},
        "operator": {"required": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(
        self, *, name: str, operator: Union[str, "_models.DimensionOperator"], values: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the dimension. Required.
        :paramtype name: str
        :keyword operator: Operator for dimension values. Required. Known values are: "Include" and
         "Exclude".
        :paramtype operator: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.DimensionOperator
        :keyword values: List of dimension values. Required.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class ErrorContract(_serialization.Model):
    """Describes the format of Error response.

    :ivar error: The error details.
    :vartype error: ~azure.mgmt.monitor.v2022_08_01_preview.models.ErrorResponseDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error details.
        :paramtype error: ~azure.mgmt.monitor.v2022_08_01_preview.models.ErrorResponseDetails
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponseDetails(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.monitor.v2022_08_01_preview.models.ErrorResponseDetails]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.monitor.v2022_08_01_preview.models.ErrorResponseAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseDetails]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorResponseAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity. Required. Known values are: "SystemAssigned",
     "UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.IdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.monitor.v2022_08_01_preview.models.UserIdentityProperties]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentityProperties}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.IdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserIdentityProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. Required. Known values are: "SystemAssigned",
         "UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.IdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.monitor.v2022_08_01_preview.models.UserIdentityProperties]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class RuleResolveConfiguration(_serialization.Model):
    """TBD. Relevant only for rules of the kind LogAlert.

    :ivar auto_resolved: The flag that indicates whether or not to auto resolve a fired alert.
    :vartype auto_resolved: bool
    :ivar time_to_resolve: The duration a rule must evaluate as healthy before the fired alert is
     automatically resolved represented in ISO 8601 duration format.
    :vartype time_to_resolve: ~datetime.timedelta
    """

    _attribute_map = {
        "auto_resolved": {"key": "autoResolved", "type": "bool"},
        "time_to_resolve": {"key": "timeToResolve", "type": "duration"},
    }

    def __init__(
        self,
        *,
        auto_resolved: Optional[bool] = None,
        time_to_resolve: Optional[datetime.timedelta] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_resolved: The flag that indicates whether or not to auto resolve a fired alert.
        :paramtype auto_resolved: bool
        :keyword time_to_resolve: The duration a rule must evaluate as healthy before the fired alert
         is automatically resolved represented in ISO 8601 duration format.
        :paramtype time_to_resolve: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.auto_resolved = auto_resolved
        self.time_to_resolve = time_to_resolve


class ScheduledQueryRuleCriteria(_serialization.Model):
    """The rule criteria that defines the conditions of the scheduled query rule.

    :ivar all_of: A list of conditions to evaluate against the specified scopes.
    :vartype all_of: list[~azure.mgmt.monitor.v2022_08_01_preview.models.Condition]
    """

    _attribute_map = {
        "all_of": {"key": "allOf", "type": "[Condition]"},
    }

    def __init__(self, *, all_of: Optional[List["_models.Condition"]] = None, **kwargs: Any) -> None:
        """
        :keyword all_of: A list of conditions to evaluate against the specified scopes.
        :paramtype all_of: list[~azure.mgmt.monitor.v2022_08_01_preview.models.Condition]
        """
        super().__init__(**kwargs)
        self.all_of = all_of


class ScheduledQueryRuleResource(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The scheduled query rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.monitor.v2022_08_01_preview.models.Identity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar kind: Indicates the type of scheduled query rule. The default is LogAlert. Known values
     are: "LogAlert" and "LogToMetric".
    :vartype kind: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.Kind
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :ivar system_data: SystemData of ScheduledQueryRule.
    :vartype system_data: ~azure.mgmt.monitor.v2022_08_01_preview.models.SystemData
    :ivar created_with_api_version: The api-version used when creating this alert rule.
    :vartype created_with_api_version: str
    :ivar is_legacy_log_analytics_rule: True if alert rule is legacy Log Analytic rule.
    :vartype is_legacy_log_analytics_rule: bool
    :ivar description: The description of the scheduled query rule.
    :vartype description: str
    :ivar display_name: The display name of the alert rule.
    :vartype display_name: str
    :ivar severity: Severity of the alert. Should be an integer between [0-4]. Value of 0 is
     severest. Relevant and required only for rules of the kind LogAlert. Known values are: 0, 1, 2,
     3, and 4.
    :vartype severity: int or ~azure.mgmt.monitor.v2022_08_01_preview.models.AlertSeverity
    :ivar enabled: The flag which indicates whether this scheduled query rule is enabled. Value
     should be true or false.
    :vartype enabled: bool
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or
     ~azure.mgmt.monitor.v2022_08_01_preview.models.PublicNetworkAccess
    :ivar scopes: The list of resource id's that this scheduled query rule is scoped to.
    :vartype scopes: list[str]
    :ivar evaluation_frequency: How often the scheduled query rule is evaluated represented in ISO
     8601 duration format. Relevant and required only for rules of the kind LogAlert.
    :vartype evaluation_frequency: ~datetime.timedelta
    :ivar window_size: The period of time (in ISO 8601 duration format) on which the Alert query
     will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
    :vartype window_size: ~datetime.timedelta
    :ivar override_query_time_range: If specified then overrides the query time range (default is
     WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
    :vartype override_query_time_range: ~datetime.timedelta
    :ivar target_resource_types: List of resource type of the target resource(s) on which the alert
     is created/updated. For example if the scope is a resource group and targetResourceTypes is
     Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual
     machine in the resource group which meet the alert criteria. Relevant only for rules of the
     kind LogAlert.
    :vartype target_resource_types: list[str]
    :ivar criteria: The rule criteria that defines the conditions of the scheduled query rule.
    :vartype criteria: ~azure.mgmt.monitor.v2022_08_01_preview.models.ScheduledQueryRuleCriteria
    :ivar mute_actions_duration: Mute actions for the chosen period of time (in ISO 8601 duration
     format) after the alert is fired. Relevant only for rules of the kind LogAlert.
    :vartype mute_actions_duration: ~datetime.timedelta
    :ivar actions: Actions to invoke when the alert fires.
    :vartype actions: ~azure.mgmt.monitor.v2022_08_01_preview.models.Actions
    :ivar is_workspace_alerts_storage_configured: The flag which indicates whether this scheduled
     query rule has been configured to be stored in the customer's storage. The default is false.
    :vartype is_workspace_alerts_storage_configured: bool
    :ivar check_workspace_alerts_storage_configured: The flag which indicates whether this
     scheduled query rule should be stored in the customer's storage. The default is false. Relevant
     only for rules of the kind LogAlert.
    :vartype check_workspace_alerts_storage_configured: bool
    :ivar skip_query_validation: The flag which indicates whether the provided query should be
     validated or not. The default is false. Relevant only for rules of the kind LogAlert.
    :vartype skip_query_validation: bool
    :ivar auto_mitigate: The flag that indicates whether the alert should be automatically resolved
     or not. The default is true. Relevant only for rules of the kind LogAlert.
    :vartype auto_mitigate: bool
    :ivar rule_resolve_configuration: Defines the configuration for resolving fired alerts.
     Relevant only for rules of the kind LogAlert.
    :vartype rule_resolve_configuration:
     ~azure.mgmt.monitor.v2022_08_01_preview.models.RuleResolveConfiguration
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "created_with_api_version": {"readonly": True},
        "is_legacy_log_analytics_rule": {"readonly": True},
        "is_workspace_alerts_storage_configured": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created_with_api_version": {"key": "properties.createdWithApiVersion", "type": "str"},
        "is_legacy_log_analytics_rule": {"key": "properties.isLegacyLogAnalyticsRule", "type": "bool"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "severity": {"key": "properties.severity", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "evaluation_frequency": {"key": "properties.evaluationFrequency", "type": "duration"},
        "window_size": {"key": "properties.windowSize", "type": "duration"},
        "override_query_time_range": {"key": "properties.overrideQueryTimeRange", "type": "duration"},
        "target_resource_types": {"key": "properties.targetResourceTypes", "type": "[str]"},
        "criteria": {"key": "properties.criteria", "type": "ScheduledQueryRuleCriteria"},
        "mute_actions_duration": {"key": "properties.muteActionsDuration", "type": "duration"},
        "actions": {"key": "properties.actions", "type": "Actions"},
        "is_workspace_alerts_storage_configured": {
            "key": "properties.isWorkspaceAlertsStorageConfigured",
            "type": "bool",
        },
        "check_workspace_alerts_storage_configured": {
            "key": "properties.checkWorkspaceAlertsStorageConfigured",
            "type": "bool",
        },
        "skip_query_validation": {"key": "properties.skipQueryValidation", "type": "bool"},
        "auto_mitigate": {"key": "properties.autoMitigate", "type": "bool"},
        "rule_resolve_configuration": {
            "key": "properties.ruleResolveConfiguration",
            "type": "RuleResolveConfiguration",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        identity: Optional["_models.Identity"] = None,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        severity: Optional[Union[int, "_models.AlertSeverity"]] = None,
        enabled: Optional[bool] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        scopes: Optional[List[str]] = None,
        evaluation_frequency: Optional[datetime.timedelta] = None,
        window_size: Optional[datetime.timedelta] = None,
        override_query_time_range: Optional[datetime.timedelta] = None,
        target_resource_types: Optional[List[str]] = None,
        criteria: Optional["_models.ScheduledQueryRuleCriteria"] = None,
        mute_actions_duration: Optional[datetime.timedelta] = None,
        actions: Optional["_models.Actions"] = None,
        check_workspace_alerts_storage_configured: Optional[bool] = None,
        skip_query_validation: Optional[bool] = None,
        auto_mitigate: Optional[bool] = None,
        rule_resolve_configuration: Optional["_models.RuleResolveConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.monitor.v2022_08_01_preview.models.Identity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword kind: Indicates the type of scheduled query rule. The default is LogAlert. Known
         values are: "LogAlert" and "LogToMetric".
        :paramtype kind: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.Kind
        :keyword description: The description of the scheduled query rule.
        :paramtype description: str
        :keyword display_name: The display name of the alert rule.
        :paramtype display_name: str
        :keyword severity: Severity of the alert. Should be an integer between [0-4]. Value of 0 is
         severest. Relevant and required only for rules of the kind LogAlert. Known values are: 0, 1, 2,
         3, and 4.
        :paramtype severity: int or ~azure.mgmt.monitor.v2022_08_01_preview.models.AlertSeverity
        :keyword enabled: The flag which indicates whether this scheduled query rule is enabled. Value
         should be true or false.
        :paramtype enabled: bool
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or
         ~azure.mgmt.monitor.v2022_08_01_preview.models.PublicNetworkAccess
        :keyword scopes: The list of resource id's that this scheduled query rule is scoped to.
        :paramtype scopes: list[str]
        :keyword evaluation_frequency: How often the scheduled query rule is evaluated represented in
         ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
        :paramtype evaluation_frequency: ~datetime.timedelta
        :keyword window_size: The period of time (in ISO 8601 duration format) on which the Alert query
         will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
        :paramtype window_size: ~datetime.timedelta
        :keyword override_query_time_range: If specified then overrides the query time range (default
         is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
        :paramtype override_query_time_range: ~datetime.timedelta
        :keyword target_resource_types: List of resource type of the target resource(s) on which the
         alert is created/updated. For example if the scope is a resource group and targetResourceTypes
         is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual
         machine in the resource group which meet the alert criteria. Relevant only for rules of the
         kind LogAlert.
        :paramtype target_resource_types: list[str]
        :keyword criteria: The rule criteria that defines the conditions of the scheduled query rule.
        :paramtype criteria: ~azure.mgmt.monitor.v2022_08_01_preview.models.ScheduledQueryRuleCriteria
        :keyword mute_actions_duration: Mute actions for the chosen period of time (in ISO 8601
         duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
        :paramtype mute_actions_duration: ~datetime.timedelta
        :keyword actions: Actions to invoke when the alert fires.
        :paramtype actions: ~azure.mgmt.monitor.v2022_08_01_preview.models.Actions
        :keyword check_workspace_alerts_storage_configured: The flag which indicates whether this
         scheduled query rule should be stored in the customer's storage. The default is false. Relevant
         only for rules of the kind LogAlert.
        :paramtype check_workspace_alerts_storage_configured: bool
        :keyword skip_query_validation: The flag which indicates whether the provided query should be
         validated or not. The default is false. Relevant only for rules of the kind LogAlert.
        :paramtype skip_query_validation: bool
        :keyword auto_mitigate: The flag that indicates whether the alert should be automatically
         resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
        :paramtype auto_mitigate: bool
        :keyword rule_resolve_configuration: Defines the configuration for resolving fired alerts.
         Relevant only for rules of the kind LogAlert.
        :paramtype rule_resolve_configuration:
         ~azure.mgmt.monitor.v2022_08_01_preview.models.RuleResolveConfiguration
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.identity = identity
        self.tags = tags
        self.location = location
        self.kind = kind
        self.etag = None
        self.system_data = None
        self.created_with_api_version = None
        self.is_legacy_log_analytics_rule = None
        self.description = description
        self.display_name = display_name
        self.severity = severity
        self.enabled = enabled
        self.public_network_access = public_network_access
        self.scopes = scopes
        self.evaluation_frequency = evaluation_frequency
        self.window_size = window_size
        self.override_query_time_range = override_query_time_range
        self.target_resource_types = target_resource_types
        self.criteria = criteria
        self.mute_actions_duration = mute_actions_duration
        self.actions = actions
        self.is_workspace_alerts_storage_configured = None
        self.check_workspace_alerts_storage_configured = check_workspace_alerts_storage_configured
        self.skip_query_validation = skip_query_validation
        self.auto_mitigate = auto_mitigate
        self.rule_resolve_configuration = rule_resolve_configuration


class ScheduledQueryRuleResourceCollection(_serialization.Model):
    """Represents a collection of scheduled query rule resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The values for the scheduled query rule resources.
    :vartype value: list[~azure.mgmt.monitor.v2022_08_01_preview.models.ScheduledQueryRuleResource]
    :ivar next_link: Provides the link to retrieve the next set of elements.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ScheduledQueryRuleResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ScheduledQueryRuleResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The values for the scheduled query rule resources.
        :paramtype value:
         list[~azure.mgmt.monitor.v2022_08_01_preview.models.ScheduledQueryRuleResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ScheduledQueryRuleResourcePatch(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The scheduled query rule resource for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.monitor.v2022_08_01_preview.models.Identity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar created_with_api_version: The api-version used when creating this alert rule.
    :vartype created_with_api_version: str
    :ivar is_legacy_log_analytics_rule: True if alert rule is legacy Log Analytic rule.
    :vartype is_legacy_log_analytics_rule: bool
    :ivar description: The description of the scheduled query rule.
    :vartype description: str
    :ivar display_name: The display name of the alert rule.
    :vartype display_name: str
    :ivar severity: Severity of the alert. Should be an integer between [0-4]. Value of 0 is
     severest. Relevant and required only for rules of the kind LogAlert. Known values are: 0, 1, 2,
     3, and 4.
    :vartype severity: int or ~azure.mgmt.monitor.v2022_08_01_preview.models.AlertSeverity
    :ivar enabled: The flag which indicates whether this scheduled query rule is enabled. Value
     should be true or false.
    :vartype enabled: bool
    :ivar public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or
     ~azure.mgmt.monitor.v2022_08_01_preview.models.PublicNetworkAccess
    :ivar scopes: The list of resource id's that this scheduled query rule is scoped to.
    :vartype scopes: list[str]
    :ivar evaluation_frequency: How often the scheduled query rule is evaluated represented in ISO
     8601 duration format. Relevant and required only for rules of the kind LogAlert.
    :vartype evaluation_frequency: ~datetime.timedelta
    :ivar window_size: The period of time (in ISO 8601 duration format) on which the Alert query
     will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
    :vartype window_size: ~datetime.timedelta
    :ivar override_query_time_range: If specified then overrides the query time range (default is
     WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
    :vartype override_query_time_range: ~datetime.timedelta
    :ivar target_resource_types: List of resource type of the target resource(s) on which the alert
     is created/updated. For example if the scope is a resource group and targetResourceTypes is
     Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual
     machine in the resource group which meet the alert criteria. Relevant only for rules of the
     kind LogAlert.
    :vartype target_resource_types: list[str]
    :ivar criteria: The rule criteria that defines the conditions of the scheduled query rule.
    :vartype criteria: ~azure.mgmt.monitor.v2022_08_01_preview.models.ScheduledQueryRuleCriteria
    :ivar mute_actions_duration: Mute actions for the chosen period of time (in ISO 8601 duration
     format) after the alert is fired. Relevant only for rules of the kind LogAlert.
    :vartype mute_actions_duration: ~datetime.timedelta
    :ivar actions: Actions to invoke when the alert fires.
    :vartype actions: ~azure.mgmt.monitor.v2022_08_01_preview.models.Actions
    :ivar is_workspace_alerts_storage_configured: The flag which indicates whether this scheduled
     query rule has been configured to be stored in the customer's storage. The default is false.
    :vartype is_workspace_alerts_storage_configured: bool
    :ivar check_workspace_alerts_storage_configured: The flag which indicates whether this
     scheduled query rule should be stored in the customer's storage. The default is false. Relevant
     only for rules of the kind LogAlert.
    :vartype check_workspace_alerts_storage_configured: bool
    :ivar skip_query_validation: The flag which indicates whether the provided query should be
     validated or not. The default is false. Relevant only for rules of the kind LogAlert.
    :vartype skip_query_validation: bool
    :ivar auto_mitigate: The flag that indicates whether the alert should be automatically resolved
     or not. The default is true. Relevant only for rules of the kind LogAlert.
    :vartype auto_mitigate: bool
    :ivar rule_resolve_configuration: Defines the configuration for resolving fired alerts.
     Relevant only for rules of the kind LogAlert.
    :vartype rule_resolve_configuration:
     ~azure.mgmt.monitor.v2022_08_01_preview.models.RuleResolveConfiguration
    """

    _validation = {
        "created_with_api_version": {"readonly": True},
        "is_legacy_log_analytics_rule": {"readonly": True},
        "is_workspace_alerts_storage_configured": {"readonly": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "Identity"},
        "tags": {"key": "tags", "type": "{str}"},
        "created_with_api_version": {"key": "properties.createdWithApiVersion", "type": "str"},
        "is_legacy_log_analytics_rule": {"key": "properties.isLegacyLogAnalyticsRule", "type": "bool"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "severity": {"key": "properties.severity", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "evaluation_frequency": {"key": "properties.evaluationFrequency", "type": "duration"},
        "window_size": {"key": "properties.windowSize", "type": "duration"},
        "override_query_time_range": {"key": "properties.overrideQueryTimeRange", "type": "duration"},
        "target_resource_types": {"key": "properties.targetResourceTypes", "type": "[str]"},
        "criteria": {"key": "properties.criteria", "type": "ScheduledQueryRuleCriteria"},
        "mute_actions_duration": {"key": "properties.muteActionsDuration", "type": "duration"},
        "actions": {"key": "properties.actions", "type": "Actions"},
        "is_workspace_alerts_storage_configured": {
            "key": "properties.isWorkspaceAlertsStorageConfigured",
            "type": "bool",
        },
        "check_workspace_alerts_storage_configured": {
            "key": "properties.checkWorkspaceAlertsStorageConfigured",
            "type": "bool",
        },
        "skip_query_validation": {"key": "properties.skipQueryValidation", "type": "bool"},
        "auto_mitigate": {"key": "properties.autoMitigate", "type": "bool"},
        "rule_resolve_configuration": {
            "key": "properties.ruleResolveConfiguration",
            "type": "RuleResolveConfiguration",
        },
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.Identity"] = None,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        display_name: Optional[str] = None,
        severity: Optional[Union[int, "_models.AlertSeverity"]] = None,
        enabled: Optional[bool] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        scopes: Optional[List[str]] = None,
        evaluation_frequency: Optional[datetime.timedelta] = None,
        window_size: Optional[datetime.timedelta] = None,
        override_query_time_range: Optional[datetime.timedelta] = None,
        target_resource_types: Optional[List[str]] = None,
        criteria: Optional["_models.ScheduledQueryRuleCriteria"] = None,
        mute_actions_duration: Optional[datetime.timedelta] = None,
        actions: Optional["_models.Actions"] = None,
        check_workspace_alerts_storage_configured: Optional[bool] = None,
        skip_query_validation: Optional[bool] = None,
        auto_mitigate: Optional[bool] = None,
        rule_resolve_configuration: Optional["_models.RuleResolveConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.monitor.v2022_08_01_preview.models.Identity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of the scheduled query rule.
        :paramtype description: str
        :keyword display_name: The display name of the alert rule.
        :paramtype display_name: str
        :keyword severity: Severity of the alert. Should be an integer between [0-4]. Value of 0 is
         severest. Relevant and required only for rules of the kind LogAlert. Known values are: 0, 1, 2,
         3, and 4.
        :paramtype severity: int or ~azure.mgmt.monitor.v2022_08_01_preview.models.AlertSeverity
        :keyword enabled: The flag which indicates whether this scheduled query rule is enabled. Value
         should be true or false.
        :paramtype enabled: bool
        :keyword public_network_access: This determines if traffic is allowed over public network. By
         default it is enabled. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or
         ~azure.mgmt.monitor.v2022_08_01_preview.models.PublicNetworkAccess
        :keyword scopes: The list of resource id's that this scheduled query rule is scoped to.
        :paramtype scopes: list[str]
        :keyword evaluation_frequency: How often the scheduled query rule is evaluated represented in
         ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert.
        :paramtype evaluation_frequency: ~datetime.timedelta
        :keyword window_size: The period of time (in ISO 8601 duration format) on which the Alert query
         will be executed (bin size). Relevant and required only for rules of the kind LogAlert.
        :paramtype window_size: ~datetime.timedelta
        :keyword override_query_time_range: If specified then overrides the query time range (default
         is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert.
        :paramtype override_query_time_range: ~datetime.timedelta
        :keyword target_resource_types: List of resource type of the target resource(s) on which the
         alert is created/updated. For example if the scope is a resource group and targetResourceTypes
         is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual
         machine in the resource group which meet the alert criteria. Relevant only for rules of the
         kind LogAlert.
        :paramtype target_resource_types: list[str]
        :keyword criteria: The rule criteria that defines the conditions of the scheduled query rule.
        :paramtype criteria: ~azure.mgmt.monitor.v2022_08_01_preview.models.ScheduledQueryRuleCriteria
        :keyword mute_actions_duration: Mute actions for the chosen period of time (in ISO 8601
         duration format) after the alert is fired. Relevant only for rules of the kind LogAlert.
        :paramtype mute_actions_duration: ~datetime.timedelta
        :keyword actions: Actions to invoke when the alert fires.
        :paramtype actions: ~azure.mgmt.monitor.v2022_08_01_preview.models.Actions
        :keyword check_workspace_alerts_storage_configured: The flag which indicates whether this
         scheduled query rule should be stored in the customer's storage. The default is false. Relevant
         only for rules of the kind LogAlert.
        :paramtype check_workspace_alerts_storage_configured: bool
        :keyword skip_query_validation: The flag which indicates whether the provided query should be
         validated or not. The default is false. Relevant only for rules of the kind LogAlert.
        :paramtype skip_query_validation: bool
        :keyword auto_mitigate: The flag that indicates whether the alert should be automatically
         resolved or not. The default is true. Relevant only for rules of the kind LogAlert.
        :paramtype auto_mitigate: bool
        :keyword rule_resolve_configuration: Defines the configuration for resolving fired alerts.
         Relevant only for rules of the kind LogAlert.
        :paramtype rule_resolve_configuration:
         ~azure.mgmt.monitor.v2022_08_01_preview.models.RuleResolveConfiguration
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.created_with_api_version = None
        self.is_legacy_log_analytics_rule = None
        self.description = description
        self.display_name = display_name
        self.severity = severity
        self.enabled = enabled
        self.public_network_access = public_network_access
        self.scopes = scopes
        self.evaluation_frequency = evaluation_frequency
        self.window_size = window_size
        self.override_query_time_range = override_query_time_range
        self.target_resource_types = target_resource_types
        self.criteria = criteria
        self.mute_actions_duration = mute_actions_duration
        self.actions = actions
        self.is_workspace_alerts_storage_configured = None
        self.check_workspace_alerts_storage_configured = check_workspace_alerts_storage_configured
        self.skip_query_validation = skip_query_validation
        self.auto_mitigate = auto_mitigate
        self.rule_resolve_configuration = rule_resolve_configuration


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.monitor.v2022_08_01_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.monitor.v2022_08_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.monitor.v2022_08_01_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserIdentityProperties(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
