# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import AzureCommunicationCallAutomationServiceMixinABC, _format_url_section

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_azure_communication_call_automation_service_create_call_request(
    *, repeatability_request_id: Optional[str] = None, repeatability_first_sent: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_azure_communication_call_automation_service_answer_call_request(
    *, repeatability_request_id: Optional[str] = None, repeatability_first_sent: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections:answer"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_azure_communication_call_automation_service_redirect_call_request(
    *, repeatability_request_id: Optional[str] = None, repeatability_first_sent: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections:redirect"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_azure_communication_call_automation_service_reject_call_request(
    *, repeatability_request_id: Optional[str] = None, repeatability_first_sent: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections:reject"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_get_call_request(call_connection_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_hangup_call_request(call_connection_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_terminate_call_request(
    call_connection_id: str,
    *,
    repeatability_request_id: Optional[str] = None,
    repeatability_first_sent: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}:terminate"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_transfer_to_participant_request(
    call_connection_id: str,
    *,
    repeatability_request_id: Optional[str] = None,
    repeatability_first_sent: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}:transferToParticipant"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_get_participants_request(call_connection_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}/participants"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_add_participant_request(
    call_connection_id: str,
    *,
    repeatability_request_id: Optional[str] = None,
    repeatability_first_sent: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}/participants:add"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_remove_participant_request(
    call_connection_id: str,
    *,
    repeatability_request_id: Optional[str] = None,
    repeatability_first_sent: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}/participants:remove"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_mute_request(
    call_connection_id: str,
    *,
    repeatability_request_id: Optional[str] = None,
    repeatability_first_sent: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}/participants:mute"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_unmute_request(
    call_connection_id: str,
    *,
    repeatability_request_id: Optional[str] = None,
    repeatability_first_sent: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}/participants:unmute"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_connection_get_participant_request(
    call_connection_id: str, participant_raw_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}/participants/{participantRawId}"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
        "participantRawId": _SERIALIZER.url("participant_raw_id", participant_raw_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_media_play_request(call_connection_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}:play"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_media_cancel_all_media_operations_request(call_connection_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}:cancelAllMediaOperations"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_media_recognize_request(call_connection_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}:recognize"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_media_start_continuous_dtmf_recognition_request(call_connection_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}:startContinuousDtmfRecognition"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_media_stop_continuous_dtmf_recognition_request(call_connection_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}:stopContinuousDtmfRecognition"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_media_send_dtmf_request(call_connection_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/callConnections/{callConnectionId}:sendDtmf"
    path_format_arguments = {
        "callConnectionId": _SERIALIZER.url("call_connection_id", call_connection_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_recording_start_recording_request(
    *, repeatability_request_id: Optional[str] = None, repeatability_first_sent: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/recordings"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if repeatability_request_id is not None:
        _headers["Repeatability-Request-ID"] = _SERIALIZER.header(
            "repeatability_request_id", repeatability_request_id, "str"
        )
    if repeatability_first_sent is not None:
        _headers["Repeatability-First-Sent"] = _SERIALIZER.header(
            "repeatability_first_sent", repeatability_first_sent, "str"
        )
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_recording_get_recording_properties_request(recording_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/recordings/{recordingId}"
    path_format_arguments = {
        "recordingId": _SERIALIZER.url("recording_id", recording_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_recording_stop_recording_request(recording_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/recordings/{recordingId}"
    path_format_arguments = {
        "recordingId": _SERIALIZER.url("recording_id", recording_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_recording_pause_recording_request(recording_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/recordings/{recordingId}:pause"
    path_format_arguments = {
        "recordingId": _SERIALIZER.url("recording_id", recording_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_call_recording_resume_recording_request(recording_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-01-15-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/calling/recordings/{recordingId}:resume"
    path_format_arguments = {
        "recordingId": _SERIALIZER.url("recording_id", recording_id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class AzureCommunicationCallAutomationServiceOperationsMixin(AzureCommunicationCallAutomationServiceMixinABC):
    @overload
    def create_call(
        self,
        create_call_request: _models.CreateCallRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CallConnectionProperties:
        """Create an outbound call.

        Create an outbound call.

        :param create_call_request: The create call request. Required.
        :type create_call_request: ~azure.communication.callautomation.models.CreateCallRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CallConnectionProperties
        :rtype: ~azure.communication.callautomation.models.CallConnectionProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_call(
        self,
        create_call_request: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CallConnectionProperties:
        """Create an outbound call.

        Create an outbound call.

        :param create_call_request: The create call request. Required.
        :type create_call_request: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CallConnectionProperties
        :rtype: ~azure.communication.callautomation.models.CallConnectionProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_call(
        self,
        create_call_request: Union[_models.CreateCallRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CallConnectionProperties:
        """Create an outbound call.

        Create an outbound call.

        :param create_call_request: The create call request. Is either a CreateCallRequest type or a IO
         type. Required.
        :type create_call_request: ~azure.communication.callautomation.models.CreateCallRequest or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: CallConnectionProperties
        :rtype: ~azure.communication.callautomation.models.CallConnectionProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CallConnectionProperties] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(create_call_request, (IOBase, bytes)):
            _content = create_call_request
        else:
            _json = self._serialize.body(create_call_request, "CreateCallRequest")

        request = build_azure_communication_call_automation_service_create_call_request(
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CallConnectionProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def answer_call(
        self,
        answer_call_request: _models.AnswerCallRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CallConnectionProperties:
        """Answer a Call.

        Answer a call using the IncomingCallContext from Event Grid.

        :param answer_call_request: The answer call request. Required.
        :type answer_call_request: ~azure.communication.callautomation.models.AnswerCallRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CallConnectionProperties
        :rtype: ~azure.communication.callautomation.models.CallConnectionProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def answer_call(
        self,
        answer_call_request: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CallConnectionProperties:
        """Answer a Call.

        Answer a call using the IncomingCallContext from Event Grid.

        :param answer_call_request: The answer call request. Required.
        :type answer_call_request: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CallConnectionProperties
        :rtype: ~azure.communication.callautomation.models.CallConnectionProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def answer_call(
        self,
        answer_call_request: Union[_models.AnswerCallRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CallConnectionProperties:
        """Answer a Call.

        Answer a call using the IncomingCallContext from Event Grid.

        :param answer_call_request: The answer call request. Is either a AnswerCallRequest type or a IO
         type. Required.
        :type answer_call_request: ~azure.communication.callautomation.models.AnswerCallRequest or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: CallConnectionProperties
        :rtype: ~azure.communication.callautomation.models.CallConnectionProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CallConnectionProperties] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(answer_call_request, (IOBase, bytes)):
            _content = answer_call_request
        else:
            _json = self._serialize.body(answer_call_request, "AnswerCallRequest")

        request = build_azure_communication_call_automation_service_answer_call_request(
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CallConnectionProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def redirect_call(  # pylint: disable=inconsistent-return-statements
        self,
        redirect_call_request: _models.RedirectCallRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Redirect a call.

        Redirect a call.

        :param redirect_call_request: The redirect call request. Required.
        :type redirect_call_request: ~azure.communication.callautomation.models.RedirectCallRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def redirect_call(  # pylint: disable=inconsistent-return-statements
        self,
        redirect_call_request: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Redirect a call.

        Redirect a call.

        :param redirect_call_request: The redirect call request. Required.
        :type redirect_call_request: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def redirect_call(  # pylint: disable=inconsistent-return-statements
        self,
        redirect_call_request: Union[_models.RedirectCallRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Redirect a call.

        Redirect a call.

        :param redirect_call_request: The redirect call request. Is either a RedirectCallRequest type
         or a IO type. Required.
        :type redirect_call_request: ~azure.communication.callautomation.models.RedirectCallRequest or
         IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(redirect_call_request, (IOBase, bytes)):
            _content = redirect_call_request
        else:
            _json = self._serialize.body(redirect_call_request, "RedirectCallRequest")

        request = build_azure_communication_call_automation_service_redirect_call_request(
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def reject_call(  # pylint: disable=inconsistent-return-statements
        self,
        reject_call_request: _models.RejectCallRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Reject the call.

        Reject the call.

        :param reject_call_request: The reject call request. Required.
        :type reject_call_request: ~azure.communication.callautomation.models.RejectCallRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def reject_call(  # pylint: disable=inconsistent-return-statements
        self,
        reject_call_request: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Reject the call.

        Reject the call.

        :param reject_call_request: The reject call request. Required.
        :type reject_call_request: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def reject_call(  # pylint: disable=inconsistent-return-statements
        self,
        reject_call_request: Union[_models.RejectCallRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Reject the call.

        Reject the call.

        :param reject_call_request: The reject call request. Is either a RejectCallRequest type or a IO
         type. Required.
        :type reject_call_request: ~azure.communication.callautomation.models.RejectCallRequest or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(reject_call_request, (IOBase, bytes)):
            _content = reject_call_request
        else:
            _json = self._serialize.body(reject_call_request, "RejectCallRequest")

        request = build_azure_communication_call_automation_service_reject_call_request(
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})


class CallConnectionOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.communication.callautomation.AzureCommunicationCallAutomationService`'s
        :attr:`call_connection` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get_call(self, call_connection_id: str, **kwargs: Any) -> _models.CallConnectionProperties:
        """Get call connection.

        Get call connection.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :return: CallConnectionProperties
        :rtype: ~azure.communication.callautomation.models.CallConnectionProperties
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CallConnectionProperties] = kwargs.pop("cls", None)

        request = build_call_connection_get_call_request(
            call_connection_id=call_connection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CallConnectionProperties", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def hangup_call(  # pylint: disable=inconsistent-return-statements
        self, call_connection_id: str, **kwargs: Any
    ) -> None:
        """Hangup the call.

        Hangup the call.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_call_connection_hangup_call_request(
            call_connection_id=call_connection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def terminate_call(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Terminate a call using CallConnectionId.

        Terminate a call using CallConnectionId.

        :param call_connection_id: The terminate call request. Required.
        :type call_connection_id: str
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_call_connection_terminate_call_request(
            call_connection_id=call_connection_id,
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def transfer_to_participant(
        self,
        call_connection_id: str,
        transfer_to_participant_request: _models.TransferToParticipantRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TransferCallResponse:
        """Transfer the call to a participant.

        Transfer the call to a participant.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param transfer_to_participant_request: The transfer to participant request. Required.
        :type transfer_to_participant_request:
         ~azure.communication.callautomation.models.TransferToParticipantRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TransferCallResponse
        :rtype: ~azure.communication.callautomation.models.TransferCallResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def transfer_to_participant(
        self,
        call_connection_id: str,
        transfer_to_participant_request: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TransferCallResponse:
        """Transfer the call to a participant.

        Transfer the call to a participant.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param transfer_to_participant_request: The transfer to participant request. Required.
        :type transfer_to_participant_request: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TransferCallResponse
        :rtype: ~azure.communication.callautomation.models.TransferCallResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def transfer_to_participant(
        self,
        call_connection_id: str,
        transfer_to_participant_request: Union[_models.TransferToParticipantRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TransferCallResponse:
        """Transfer the call to a participant.

        Transfer the call to a participant.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param transfer_to_participant_request: The transfer to participant request. Is either a
         TransferToParticipantRequest type or a IO type. Required.
        :type transfer_to_participant_request:
         ~azure.communication.callautomation.models.TransferToParticipantRequest or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: TransferCallResponse
        :rtype: ~azure.communication.callautomation.models.TransferCallResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TransferCallResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(transfer_to_participant_request, (IOBase, bytes)):
            _content = transfer_to_participant_request
        else:
            _json = self._serialize.body(transfer_to_participant_request, "TransferToParticipantRequest")

        request = build_call_connection_transfer_to_participant_request(
            call_connection_id=call_connection_id,
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("TransferCallResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def get_participants(self, call_connection_id: str, **kwargs: Any) -> _models.GetParticipantsResponse:
        """Get participants from a call.

        Get participants from a call.

        :param call_connection_id: The call connection Id. Required.
        :type call_connection_id: str
        :return: GetParticipantsResponse
        :rtype: ~azure.communication.callautomation.models.GetParticipantsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GetParticipantsResponse] = kwargs.pop("cls", None)

        request = build_call_connection_get_participants_request(
            call_connection_id=call_connection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("GetParticipantsResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def add_participant(
        self,
        call_connection_id: str,
        add_participant_request: _models.AddParticipantRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddParticipantResponse:
        """Add participants to the call.

        Add participants to the call.

        :param call_connection_id: The call connection Id. Required.
        :type call_connection_id: str
        :param add_participant_request: Required.
        :type add_participant_request: ~azure.communication.callautomation.models.AddParticipantRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddParticipantResponse
        :rtype: ~azure.communication.callautomation.models.AddParticipantResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def add_participant(
        self,
        call_connection_id: str,
        add_participant_request: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AddParticipantResponse:
        """Add participants to the call.

        Add participants to the call.

        :param call_connection_id: The call connection Id. Required.
        :type call_connection_id: str
        :param add_participant_request: Required.
        :type add_participant_request: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AddParticipantResponse
        :rtype: ~azure.communication.callautomation.models.AddParticipantResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def add_participant(
        self,
        call_connection_id: str,
        add_participant_request: Union[_models.AddParticipantRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AddParticipantResponse:
        """Add participants to the call.

        Add participants to the call.

        :param call_connection_id: The call connection Id. Required.
        :type call_connection_id: str
        :param add_participant_request: Is either a AddParticipantRequest type or a IO type. Required.
        :type add_participant_request: ~azure.communication.callautomation.models.AddParticipantRequest
         or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: AddParticipantResponse
        :rtype: ~azure.communication.callautomation.models.AddParticipantResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AddParticipantResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(add_participant_request, (IOBase, bytes)):
            _content = add_participant_request
        else:
            _json = self._serialize.body(add_participant_request, "AddParticipantRequest")

        request = build_call_connection_add_participant_request(
            call_connection_id=call_connection_id,
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("AddParticipantResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def remove_participant(
        self,
        call_connection_id: str,
        remove_participant_request: _models.RemoveParticipantRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RemoveParticipantResponse:
        """Remove participant from the call using identifier.

        Remove participant from the call using identifier.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param remove_participant_request: The participant to be removed from the call. Required.
        :type remove_participant_request:
         ~azure.communication.callautomation.models.RemoveParticipantRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RemoveParticipantResponse
        :rtype: ~azure.communication.callautomation.models.RemoveParticipantResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def remove_participant(
        self,
        call_connection_id: str,
        remove_participant_request: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RemoveParticipantResponse:
        """Remove participant from the call using identifier.

        Remove participant from the call using identifier.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param remove_participant_request: The participant to be removed from the call. Required.
        :type remove_participant_request: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RemoveParticipantResponse
        :rtype: ~azure.communication.callautomation.models.RemoveParticipantResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def remove_participant(
        self,
        call_connection_id: str,
        remove_participant_request: Union[_models.RemoveParticipantRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> _models.RemoveParticipantResponse:
        """Remove participant from the call using identifier.

        Remove participant from the call using identifier.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param remove_participant_request: The participant to be removed from the call. Is either a
         RemoveParticipantRequest type or a IO type. Required.
        :type remove_participant_request:
         ~azure.communication.callautomation.models.RemoveParticipantRequest or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: RemoveParticipantResponse
        :rtype: ~azure.communication.callautomation.models.RemoveParticipantResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RemoveParticipantResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(remove_participant_request, (IOBase, bytes)):
            _content = remove_participant_request
        else:
            _json = self._serialize.body(remove_participant_request, "RemoveParticipantRequest")

        request = build_call_connection_remove_participant_request(
            call_connection_id=call_connection_id,
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RemoveParticipantResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def mute(
        self,
        call_connection_id: str,
        mute_participants_request: _models.MuteParticipantsRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.MuteParticipantsResponse:
        """Mute participants from the call using identifier.

        Mute participants from the call using identifier.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param mute_participants_request: The participants to be muted from the call. Required.
        :type mute_participants_request:
         ~azure.communication.callautomation.models.MuteParticipantsRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: MuteParticipantsResponse
        :rtype: ~azure.communication.callautomation.models.MuteParticipantsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def mute(
        self,
        call_connection_id: str,
        mute_participants_request: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.MuteParticipantsResponse:
        """Mute participants from the call using identifier.

        Mute participants from the call using identifier.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param mute_participants_request: The participants to be muted from the call. Required.
        :type mute_participants_request: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: MuteParticipantsResponse
        :rtype: ~azure.communication.callautomation.models.MuteParticipantsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def mute(
        self,
        call_connection_id: str,
        mute_participants_request: Union[_models.MuteParticipantsRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> _models.MuteParticipantsResponse:
        """Mute participants from the call using identifier.

        Mute participants from the call using identifier.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param mute_participants_request: The participants to be muted from the call. Is either a
         MuteParticipantsRequest type or a IO type. Required.
        :type mute_participants_request:
         ~azure.communication.callautomation.models.MuteParticipantsRequest or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: MuteParticipantsResponse
        :rtype: ~azure.communication.callautomation.models.MuteParticipantsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MuteParticipantsResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(mute_participants_request, (IOBase, bytes)):
            _content = mute_participants_request
        else:
            _json = self._serialize.body(mute_participants_request, "MuteParticipantsRequest")

        request = build_call_connection_mute_request(
            call_connection_id=call_connection_id,
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("MuteParticipantsResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def unmute(
        self,
        call_connection_id: str,
        unmute_participants_request: _models.UnmuteParticipantsRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UnmuteParticipantsResponse:
        """Unmute participants from the call using identifier.

        Unmute participants from the call using identifier.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param unmute_participants_request: The participants to be unmuted from the call. Required.
        :type unmute_participants_request:
         ~azure.communication.callautomation.models.UnmuteParticipantsRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UnmuteParticipantsResponse
        :rtype: ~azure.communication.callautomation.models.UnmuteParticipantsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def unmute(
        self,
        call_connection_id: str,
        unmute_participants_request: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UnmuteParticipantsResponse:
        """Unmute participants from the call using identifier.

        Unmute participants from the call using identifier.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param unmute_participants_request: The participants to be unmuted from the call. Required.
        :type unmute_participants_request: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UnmuteParticipantsResponse
        :rtype: ~azure.communication.callautomation.models.UnmuteParticipantsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def unmute(
        self,
        call_connection_id: str,
        unmute_participants_request: Union[_models.UnmuteParticipantsRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> _models.UnmuteParticipantsResponse:
        """Unmute participants from the call using identifier.

        Unmute participants from the call using identifier.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param unmute_participants_request: The participants to be unmuted from the call. Is either a
         UnmuteParticipantsRequest type or a IO type. Required.
        :type unmute_participants_request:
         ~azure.communication.callautomation.models.UnmuteParticipantsRequest or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: UnmuteParticipantsResponse
        :rtype: ~azure.communication.callautomation.models.UnmuteParticipantsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.UnmuteParticipantsResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(unmute_participants_request, (IOBase, bytes)):
            _content = unmute_participants_request
        else:
            _json = self._serialize.body(unmute_participants_request, "UnmuteParticipantsRequest")

        request = build_call_connection_unmute_request(
            call_connection_id=call_connection_id,
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("UnmuteParticipantsResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def get_participant(
        self, call_connection_id: str, participant_raw_id: str, **kwargs: Any
    ) -> _models.CallParticipant:
        """Get participant from a call.

        Get participant from a call.

        :param call_connection_id: The call connection Id. Required.
        :type call_connection_id: str
        :param participant_raw_id: Raw id of the participant to retrieve. Required.
        :type participant_raw_id: str
        :return: CallParticipant
        :rtype: ~azure.communication.callautomation.models.CallParticipant
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CallParticipant] = kwargs.pop("cls", None)

        request = build_call_connection_get_participant_request(
            call_connection_id=call_connection_id,
            participant_raw_id=participant_raw_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("CallParticipant", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized


class CallMediaOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.communication.callautomation.AzureCommunicationCallAutomationService`'s
        :attr:`call_media` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def play(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        play_request: _models.PlayRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Plays audio to participants in the call.

        Plays audio to participants in the call.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param play_request: play request payload. Required.
        :type play_request: ~azure.communication.callautomation.models.PlayRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def play(  # pylint: disable=inconsistent-return-statements
        self, call_connection_id: str, play_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Plays audio to participants in the call.

        Plays audio to participants in the call.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param play_request: play request payload. Required.
        :type play_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def play(  # pylint: disable=inconsistent-return-statements
        self, call_connection_id: str, play_request: Union[_models.PlayRequest, IO], **kwargs: Any
    ) -> None:
        """Plays audio to participants in the call.

        Plays audio to participants in the call.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param play_request: play request payload. Is either a PlayRequest type or a IO type. Required.
        :type play_request: ~azure.communication.callautomation.models.PlayRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(play_request, (IOBase, bytes)):
            _content = play_request
        else:
            _json = self._serialize.body(play_request, "PlayRequest")

        request = build_call_media_play_request(
            call_connection_id=call_connection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def cancel_all_media_operations(  # pylint: disable=inconsistent-return-statements
        self, call_connection_id: str, **kwargs: Any
    ) -> None:
        """Cancel all media operations in a call.

        Cancel all media operations in a call.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_call_media_cancel_all_media_operations_request(
            call_connection_id=call_connection_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def recognize(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        recognize_request: _models.RecognizeRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Recognize media from call.

        Recognize media from call.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param recognize_request: The media recognize request. Required.
        :type recognize_request: ~azure.communication.callautomation.models.RecognizeRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def recognize(  # pylint: disable=inconsistent-return-statements
        self, call_connection_id: str, recognize_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Recognize media from call.

        Recognize media from call.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param recognize_request: The media recognize request. Required.
        :type recognize_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def recognize(  # pylint: disable=inconsistent-return-statements
        self, call_connection_id: str, recognize_request: Union[_models.RecognizeRequest, IO], **kwargs: Any
    ) -> None:
        """Recognize media from call.

        Recognize media from call.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param recognize_request: The media recognize request. Is either a RecognizeRequest type or a
         IO type. Required.
        :type recognize_request: ~azure.communication.callautomation.models.RecognizeRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(recognize_request, (IOBase, bytes)):
            _content = recognize_request
        else:
            _json = self._serialize.body(recognize_request, "RecognizeRequest")

        request = build_call_media_recognize_request(
            call_connection_id=call_connection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def start_continuous_dtmf_recognition(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        continuous_dtmf_recognition_request: _models.ContinuousDtmfRecognitionRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Start continuous Dtmf recognition by subscribing to tones.

        Start continuous Dtmf recognition by subscribing to tones.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param continuous_dtmf_recognition_request: The continuous recognize request. Required.
        :type continuous_dtmf_recognition_request:
         ~azure.communication.callautomation.models.ContinuousDtmfRecognitionRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def start_continuous_dtmf_recognition(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        continuous_dtmf_recognition_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Start continuous Dtmf recognition by subscribing to tones.

        Start continuous Dtmf recognition by subscribing to tones.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param continuous_dtmf_recognition_request: The continuous recognize request. Required.
        :type continuous_dtmf_recognition_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def start_continuous_dtmf_recognition(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        continuous_dtmf_recognition_request: Union[_models.ContinuousDtmfRecognitionRequest, IO],
        **kwargs: Any
    ) -> None:
        """Start continuous Dtmf recognition by subscribing to tones.

        Start continuous Dtmf recognition by subscribing to tones.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param continuous_dtmf_recognition_request: The continuous recognize request. Is either a
         ContinuousDtmfRecognitionRequest type or a IO type. Required.
        :type continuous_dtmf_recognition_request:
         ~azure.communication.callautomation.models.ContinuousDtmfRecognitionRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(continuous_dtmf_recognition_request, (IOBase, bytes)):
            _content = continuous_dtmf_recognition_request
        else:
            _json = self._serialize.body(continuous_dtmf_recognition_request, "ContinuousDtmfRecognitionRequest")

        request = build_call_media_start_continuous_dtmf_recognition_request(
            call_connection_id=call_connection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def stop_continuous_dtmf_recognition(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        continuous_dtmf_recognition_request: _models.ContinuousDtmfRecognitionRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Stop continuous Dtmf recognition by unsubscribing to tones.

        Stop continuous Dtmf recognition by unsubscribing to tones.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param continuous_dtmf_recognition_request: The continuous recognize request. Required.
        :type continuous_dtmf_recognition_request:
         ~azure.communication.callautomation.models.ContinuousDtmfRecognitionRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def stop_continuous_dtmf_recognition(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        continuous_dtmf_recognition_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Stop continuous Dtmf recognition by unsubscribing to tones.

        Stop continuous Dtmf recognition by unsubscribing to tones.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param continuous_dtmf_recognition_request: The continuous recognize request. Required.
        :type continuous_dtmf_recognition_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def stop_continuous_dtmf_recognition(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        continuous_dtmf_recognition_request: Union[_models.ContinuousDtmfRecognitionRequest, IO],
        **kwargs: Any
    ) -> None:
        """Stop continuous Dtmf recognition by unsubscribing to tones.

        Stop continuous Dtmf recognition by unsubscribing to tones.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param continuous_dtmf_recognition_request: The continuous recognize request. Is either a
         ContinuousDtmfRecognitionRequest type or a IO type. Required.
        :type continuous_dtmf_recognition_request:
         ~azure.communication.callautomation.models.ContinuousDtmfRecognitionRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(continuous_dtmf_recognition_request, (IOBase, bytes)):
            _content = continuous_dtmf_recognition_request
        else:
            _json = self._serialize.body(continuous_dtmf_recognition_request, "ContinuousDtmfRecognitionRequest")

        request = build_call_media_stop_continuous_dtmf_recognition_request(
            call_connection_id=call_connection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def send_dtmf(  # pylint: disable=inconsistent-return-statements
        self,
        call_connection_id: str,
        send_dtmf_request: _models.SendDtmfRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Send dtmf tones.

        Send dtmf tones.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param send_dtmf_request: The send dtmf request. Required.
        :type send_dtmf_request: ~azure.communication.callautomation.models.SendDtmfRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def send_dtmf(  # pylint: disable=inconsistent-return-statements
        self, call_connection_id: str, send_dtmf_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Send dtmf tones.

        Send dtmf tones.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param send_dtmf_request: The send dtmf request. Required.
        :type send_dtmf_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def send_dtmf(  # pylint: disable=inconsistent-return-statements
        self, call_connection_id: str, send_dtmf_request: Union[_models.SendDtmfRequest, IO], **kwargs: Any
    ) -> None:
        """Send dtmf tones.

        Send dtmf tones.

        :param call_connection_id: The call connection id. Required.
        :type call_connection_id: str
        :param send_dtmf_request: The send dtmf request. Is either a SendDtmfRequest type or a IO type.
         Required.
        :type send_dtmf_request: ~azure.communication.callautomation.models.SendDtmfRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(send_dtmf_request, (IOBase, bytes)):
            _content = send_dtmf_request
        else:
            _json = self._serialize.body(send_dtmf_request, "SendDtmfRequest")

        request = build_call_media_send_dtmf_request(
            call_connection_id=call_connection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})


class CallRecordingOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.communication.callautomation.AzureCommunicationCallAutomationService`'s
        :attr:`call_recording` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def start_recording(
        self,
        start_call_recording: _models.StartCallRecordingRequest,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RecordingStateResponse:
        """Start recording the call.

        Start recording the call.

        :param start_call_recording: The request body of start call recording request. Required.
        :type start_call_recording:
         ~azure.communication.callautomation.models.StartCallRecordingRequest
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RecordingStateResponse
        :rtype: ~azure.communication.callautomation.models.RecordingStateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def start_recording(
        self,
        start_call_recording: IO,
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RecordingStateResponse:
        """Start recording the call.

        Start recording the call.

        :param start_call_recording: The request body of start call recording request. Required.
        :type start_call_recording: IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RecordingStateResponse
        :rtype: ~azure.communication.callautomation.models.RecordingStateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def start_recording(
        self,
        start_call_recording: Union[_models.StartCallRecordingRequest, IO],
        *,
        repeatability_request_id: Optional[str] = None,
        repeatability_first_sent: Optional[str] = None,
        **kwargs: Any
    ) -> _models.RecordingStateResponse:
        """Start recording the call.

        Start recording the call.

        :param start_call_recording: The request body of start call recording request. Is either a
         StartCallRecordingRequest type or a IO type. Required.
        :type start_call_recording:
         ~azure.communication.callautomation.models.StartCallRecordingRequest or IO
        :keyword repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated unique identifier for the request. It is a version 4 (random)
         UUID. Default value is None.
        :paramtype repeatability_request_id: str
        :keyword repeatability_first_sent: If Repeatability-Request-ID header is specified, then
         Repeatability-First-Sent header must also be specified. The value should be the date and time
         at which the request was first created, expressed using the IMF-fixdate form of HTTP-date.
         Example: Sun, 06 Nov 1994 08:49:37 GMT. Default value is None.
        :paramtype repeatability_first_sent: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: RecordingStateResponse
        :rtype: ~azure.communication.callautomation.models.RecordingStateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RecordingStateResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(start_call_recording, (IOBase, bytes)):
            _content = start_call_recording
        else:
            _json = self._serialize.body(start_call_recording, "StartCallRecordingRequest")

        request = build_call_recording_start_recording_request(
            repeatability_request_id=repeatability_request_id,
            repeatability_first_sent=repeatability_first_sent,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RecordingStateResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def get_recording_properties(self, recording_id: str, **kwargs: Any) -> _models.RecordingStateResponse:
        """Get call recording properties.

        Get call recording properties.

        :param recording_id: The recording id. Required.
        :type recording_id: str
        :return: RecordingStateResponse
        :rtype: ~azure.communication.callautomation.models.RecordingStateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RecordingStateResponse] = kwargs.pop("cls", None)

        request = build_call_recording_get_recording_properties_request(
            recording_id=recording_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RecordingStateResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def stop_recording(  # pylint: disable=inconsistent-return-statements
        self, recording_id: str, **kwargs: Any
    ) -> None:
        """Stop recording the call.

        Stop recording the call.

        :param recording_id: The recording id. Required.
        :type recording_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_call_recording_stop_recording_request(
            recording_id=recording_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def pause_recording(  # pylint: disable=inconsistent-return-statements
        self, recording_id: str, **kwargs: Any
    ) -> None:
        """Pause recording the call.

        Pause recording the call.

        :param recording_id: The recording id. Required.
        :type recording_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_call_recording_pause_recording_request(
            recording_id=recording_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def resume_recording(  # pylint: disable=inconsistent-return-statements
        self, recording_id: str, **kwargs: Any
    ) -> None:
        """Resume recording the call.

        Resume recording the call.

        :param recording_id: The recording id. Required.
        :type recording_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_call_recording_resume_recording_request(
            recording_id=recording_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})
