# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._app_service_certificate_orders_operations import (
    build_create_or_update_certificate_request,
    build_create_or_update_request,
    build_delete_certificate_request,
    build_delete_request,
    build_get_certificate_request,
    build_get_request,
    build_list_by_resource_group_request,
    build_list_certificates_request,
    build_list_request,
    build_reissue_request,
    build_renew_request,
    build_resend_email_request,
    build_resend_request_emails_request,
    build_retrieve_certificate_actions_request,
    build_retrieve_certificate_email_history_request,
    build_retrieve_site_seal_request,
    build_update_certificate_request,
    build_update_request,
    build_validate_purchase_information_request,
    build_verify_domain_ownership_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AppServiceCertificateOrdersOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.web.v2015_08_01.aio.WebSiteManagementClient`'s
        :attr:`app_service_certificate_orders` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.AppServiceCertificateOrder"]:
        """List all certificate orders in a subscription.

        List all certificate orders in a subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AppServiceCertificateOrder or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[_models.AppServiceCertificateOrderCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AppServiceCertificateOrderCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/certificateOrders"
    }

    @overload
    async def validate_purchase_information(  # pylint: disable=inconsistent-return-statements
        self,
        app_service_certificate_order: _models.AppServiceCertificateOrder,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Validate information for a certificate order.

        Validate information for a certificate order.

        :param app_service_certificate_order: Information for a certificate order. Required.
        :type app_service_certificate_order:
         ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def validate_purchase_information(  # pylint: disable=inconsistent-return-statements
        self, app_service_certificate_order: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Validate information for a certificate order.

        Validate information for a certificate order.

        :param app_service_certificate_order: Information for a certificate order. Required.
        :type app_service_certificate_order: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def validate_purchase_information(  # pylint: disable=inconsistent-return-statements
        self, app_service_certificate_order: Union[_models.AppServiceCertificateOrder, IO], **kwargs: Any
    ) -> None:
        """Validate information for a certificate order.

        Validate information for a certificate order.

        :param app_service_certificate_order: Information for a certificate order. Is either a
         AppServiceCertificateOrder type or a IO type. Required.
        :type app_service_certificate_order:
         ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_service_certificate_order, (IO, bytes)):
            _content = app_service_certificate_order
        else:
            _json = self._serialize.body(app_service_certificate_order, "AppServiceCertificateOrder")

        request = build_validate_purchase_information_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.validate_purchase_information.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    validate_purchase_information.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/validateCertificateRegistrationInformation"
    }

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.AppServiceCertificateOrder"]:
        """Get certificate orders in a resource group.

        Get certificate orders in a resource group.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AppServiceCertificateOrder or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[_models.AppServiceCertificateOrderCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AppServiceCertificateOrderCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders"
    }

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, certificate_order_name: str, **kwargs: Any
    ) -> _models.AppServiceCertificateOrder:
        """Get a certificate order.

        Get a certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order.. Required.
        :type certificate_order_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServiceCertificateOrder or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[_models.AppServiceCertificateOrder] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AppServiceCertificateOrder", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}"
    }

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        certificate_distinguished_name: Union[_models.AppServiceCertificateOrder, IO],
        **kwargs: Any
    ) -> _models.AppServiceCertificateOrder:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppServiceCertificateOrder] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(certificate_distinguished_name, (IO, bytes)):
            _content = certificate_distinguished_name
        else:
            _json = self._serialize.body(certificate_distinguished_name, "AppServiceCertificateOrder")

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_or_update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("AppServiceCertificateOrder", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("AppServiceCertificateOrder", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _create_or_update_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}"
    }

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        certificate_distinguished_name: _models.AppServiceCertificateOrder,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AppServiceCertificateOrder]:
        """Create or update a certificate purchase order.

        Create or update a certificate purchase order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param certificate_distinguished_name: Distinguished name to use for the certificate order.
         Required.
        :type certificate_distinguished_name:
         ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AppServiceCertificateOrder or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        certificate_distinguished_name: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AppServiceCertificateOrder]:
        """Create or update a certificate purchase order.

        Create or update a certificate purchase order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param certificate_distinguished_name: Distinguished name to use for the certificate order.
         Required.
        :type certificate_distinguished_name: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AppServiceCertificateOrder or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        certificate_distinguished_name: Union[_models.AppServiceCertificateOrder, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AppServiceCertificateOrder]:
        """Create or update a certificate purchase order.

        Create or update a certificate purchase order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param certificate_distinguished_name: Distinguished name to use for the certificate order. Is
         either a AppServiceCertificateOrder type or a IO type. Required.
        :type certificate_distinguished_name:
         ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AppServiceCertificateOrder or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppServiceCertificateOrder] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                certificate_order_name=certificate_order_name,
                certificate_distinguished_name=certificate_distinguished_name,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("AppServiceCertificateOrder", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_or_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}"
    }

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, certificate_order_name: str, **kwargs: Any
    ) -> None:
        """Delete an existing certificate order.

        Delete an existing certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}"
    }

    @overload
    async def update(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        certificate_distinguished_name: _models.AppServiceCertificateOrderPatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppServiceCertificateOrder:
        """Create or update a certificate purchase order.

        Create or update a certificate purchase order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param certificate_distinguished_name: Distinguished name to use for the certificate order.
         Required.
        :type certificate_distinguished_name:
         ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrderPatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServiceCertificateOrder or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        certificate_distinguished_name: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppServiceCertificateOrder:
        """Create or update a certificate purchase order.

        Create or update a certificate purchase order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param certificate_distinguished_name: Distinguished name to use for the certificate order.
         Required.
        :type certificate_distinguished_name: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServiceCertificateOrder or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        certificate_distinguished_name: Union[_models.AppServiceCertificateOrderPatchResource, IO],
        **kwargs: Any
    ) -> _models.AppServiceCertificateOrder:
        """Create or update a certificate purchase order.

        Create or update a certificate purchase order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param certificate_distinguished_name: Distinguished name to use for the certificate order. Is
         either a AppServiceCertificateOrderPatchResource type or a IO type. Required.
        :type certificate_distinguished_name:
         ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrderPatchResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServiceCertificateOrder or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppServiceCertificateOrder] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(certificate_distinguished_name, (IO, bytes)):
            _content = certificate_distinguished_name
        else:
            _json = self._serialize.body(certificate_distinguished_name, "AppServiceCertificateOrderPatchResource")

        request = build_update_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("AppServiceCertificateOrder", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("AppServiceCertificateOrder", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}"
    }

    @distributed_trace
    def list_certificates(
        self, resource_group_name: str, certificate_order_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.AppServiceCertificateResource"]:
        """List all certificates associated with a certificate order.

        List all certificates associated with a certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AppServiceCertificateResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[_models.AppServiceCertificateCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_certificates_request(
                    resource_group_name=resource_group_name,
                    certificate_order_name=certificate_order_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_certificates.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AppServiceCertificateCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_certificates.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates"
    }

    @distributed_trace_async
    async def get_certificate(
        self, resource_group_name: str, certificate_order_name: str, name: str, **kwargs: Any
    ) -> _models.AppServiceCertificateResource:
        """Get the certificate associated with a certificate order.

        Get the certificate associated with a certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name: Name of the certificate. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServiceCertificateResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[_models.AppServiceCertificateResource] = kwargs.pop("cls", None)

        request = build_get_certificate_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AppServiceCertificateResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_certificate.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}"
    }

    async def _create_or_update_certificate_initial(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name: str,
        key_vault_certificate: Union[_models.AppServiceCertificateResource, IO],
        **kwargs: Any
    ) -> _models.AppServiceCertificateResource:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppServiceCertificateResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(key_vault_certificate, (IO, bytes)):
            _content = key_vault_certificate
        else:
            _json = self._serialize.body(key_vault_certificate, "AppServiceCertificateResource")

        request = build_create_or_update_certificate_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_or_update_certificate_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("AppServiceCertificateResource", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("AppServiceCertificateResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _create_or_update_certificate_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}"
    }

    @overload
    async def begin_create_or_update_certificate(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name: str,
        key_vault_certificate: _models.AppServiceCertificateResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AppServiceCertificateResource]:
        """Creates or updates a certificate and associates with key vault secret.

        Creates or updates a certificate and associates with key vault secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name: Name of the certificate. Required.
        :type name: str
        :param key_vault_certificate: Key vault certificate resource Id. Required.
        :type key_vault_certificate: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AppServiceCertificateResource or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_certificate(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name: str,
        key_vault_certificate: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AppServiceCertificateResource]:
        """Creates or updates a certificate and associates with key vault secret.

        Creates or updates a certificate and associates with key vault secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name: Name of the certificate. Required.
        :type name: str
        :param key_vault_certificate: Key vault certificate resource Id. Required.
        :type key_vault_certificate: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AppServiceCertificateResource or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update_certificate(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name: str,
        key_vault_certificate: Union[_models.AppServiceCertificateResource, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AppServiceCertificateResource]:
        """Creates or updates a certificate and associates with key vault secret.

        Creates or updates a certificate and associates with key vault secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name: Name of the certificate. Required.
        :type name: str
        :param key_vault_certificate: Key vault certificate resource Id. Is either a
         AppServiceCertificateResource type or a IO type. Required.
        :type key_vault_certificate: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource
         or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either AppServiceCertificateResource or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppServiceCertificateResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_certificate_initial(
                resource_group_name=resource_group_name,
                certificate_order_name=certificate_order_name,
                name=name,
                key_vault_certificate=key_vault_certificate,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("AppServiceCertificateResource", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_or_update_certificate.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}"
    }

    @distributed_trace_async
    async def delete_certificate(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, certificate_order_name: str, name: str, **kwargs: Any
    ) -> None:
        """Delete the certificate associated with a certificate order.

        Delete the certificate associated with a certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name: Name of the certificate. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_certificate_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_certificate.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}"
    }

    @overload
    async def update_certificate(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name: str,
        key_vault_certificate: _models.AppServiceCertificatePatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppServiceCertificateResource:
        """Creates or updates a certificate and associates with key vault secret.

        Creates or updates a certificate and associates with key vault secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name: Name of the certificate. Required.
        :type name: str
        :param key_vault_certificate: Key vault certificate resource Id. Required.
        :type key_vault_certificate:
         ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificatePatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServiceCertificateResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_certificate(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name: str,
        key_vault_certificate: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppServiceCertificateResource:
        """Creates or updates a certificate and associates with key vault secret.

        Creates or updates a certificate and associates with key vault secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name: Name of the certificate. Required.
        :type name: str
        :param key_vault_certificate: Key vault certificate resource Id. Required.
        :type key_vault_certificate: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServiceCertificateResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_certificate(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name: str,
        key_vault_certificate: Union[_models.AppServiceCertificatePatchResource, IO],
        **kwargs: Any
    ) -> _models.AppServiceCertificateResource:
        """Creates or updates a certificate and associates with key vault secret.

        Creates or updates a certificate and associates with key vault secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name: Name of the certificate. Required.
        :type name: str
        :param key_vault_certificate: Key vault certificate resource Id. Is either a
         AppServiceCertificatePatchResource type or a IO type. Required.
        :type key_vault_certificate:
         ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificatePatchResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppServiceCertificateResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppServiceCertificateResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(key_vault_certificate, (IO, bytes)):
            _content = key_vault_certificate
        else:
            _json = self._serialize.body(key_vault_certificate, "AppServiceCertificatePatchResource")

        request = build_update_certificate_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("AppServiceCertificateResource", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("AppServiceCertificateResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    update_certificate.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}"
    }

    @overload
    async def reissue(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        certificate_order_name: str,
        reissue_certificate_order_request: _models.ReissueCertificateOrderRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Reissue an existing certificate order.

        Reissue an existing certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param reissue_certificate_order_request: Parameters for the reissue. Required.
        :type reissue_certificate_order_request:
         ~azure.mgmt.web.v2015_08_01.models.ReissueCertificateOrderRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def reissue(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        certificate_order_name: str,
        reissue_certificate_order_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Reissue an existing certificate order.

        Reissue an existing certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param reissue_certificate_order_request: Parameters for the reissue. Required.
        :type reissue_certificate_order_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def reissue(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        certificate_order_name: str,
        reissue_certificate_order_request: Union[_models.ReissueCertificateOrderRequest, IO],
        **kwargs: Any
    ) -> None:
        """Reissue an existing certificate order.

        Reissue an existing certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param reissue_certificate_order_request: Parameters for the reissue. Is either a
         ReissueCertificateOrderRequest type or a IO type. Required.
        :type reissue_certificate_order_request:
         ~azure.mgmt.web.v2015_08_01.models.ReissueCertificateOrderRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(reissue_certificate_order_request, (IO, bytes)):
            _content = reissue_certificate_order_request
        else:
            _json = self._serialize.body(reissue_certificate_order_request, "ReissueCertificateOrderRequest")

        request = build_reissue_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.reissue.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    reissue.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/reissue"
    }

    @overload
    async def renew(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        certificate_order_name: str,
        renew_certificate_order_request: _models.RenewCertificateOrderRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Renew an existing certificate order.

        Renew an existing certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param renew_certificate_order_request: Renew parameters. Required.
        :type renew_certificate_order_request:
         ~azure.mgmt.web.v2015_08_01.models.RenewCertificateOrderRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def renew(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        certificate_order_name: str,
        renew_certificate_order_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Renew an existing certificate order.

        Renew an existing certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param renew_certificate_order_request: Renew parameters. Required.
        :type renew_certificate_order_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def renew(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        certificate_order_name: str,
        renew_certificate_order_request: Union[_models.RenewCertificateOrderRequest, IO],
        **kwargs: Any
    ) -> None:
        """Renew an existing certificate order.

        Renew an existing certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param renew_certificate_order_request: Renew parameters. Is either a
         RenewCertificateOrderRequest type or a IO type. Required.
        :type renew_certificate_order_request:
         ~azure.mgmt.web.v2015_08_01.models.RenewCertificateOrderRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(renew_certificate_order_request, (IO, bytes)):
            _content = renew_certificate_order_request
        else:
            _json = self._serialize.body(renew_certificate_order_request, "RenewCertificateOrderRequest")

        request = build_renew_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.renew.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    renew.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/renew"
    }

    @distributed_trace_async
    async def resend_email(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, certificate_order_name: str, **kwargs: Any
    ) -> None:
        """Resend certificate email.

        Resend certificate email.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_resend_email_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.resend_email.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    resend_email.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendEmail"
    }

    @overload
    async def resend_request_emails(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name_identifier: _models.NameIdentifier,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Verify domain ownership for this certificate order.

        Verify domain ownership for this certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name_identifier: Email address. Required.
        :type name_identifier: ~azure.mgmt.web.v2015_08_01.models.NameIdentifier
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def resend_request_emails(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name_identifier: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Verify domain ownership for this certificate order.

        Verify domain ownership for this certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name_identifier: Email address. Required.
        :type name_identifier: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def resend_request_emails(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        certificate_order_name: str,
        name_identifier: Union[_models.NameIdentifier, IO],
        **kwargs: Any
    ) -> None:
        """Verify domain ownership for this certificate order.

        Verify domain ownership for this certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param name_identifier: Email address. Is either a NameIdentifier type or a IO type. Required.
        :type name_identifier: ~azure.mgmt.web.v2015_08_01.models.NameIdentifier or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(name_identifier, (IO, bytes)):
            _content = name_identifier
        else:
            _json = self._serialize.body(name_identifier, "NameIdentifier")

        request = build_resend_request_emails_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.resend_request_emails.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    resend_request_emails.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendRequestEmails"
    }

    @overload
    async def retrieve_site_seal(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        site_seal_request: _models.SiteSealRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteSeal:
        """Verify domain ownership for this certificate order.

        Verify domain ownership for this certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param site_seal_request: Site seal request. Required.
        :type site_seal_request: ~azure.mgmt.web.v2015_08_01.models.SiteSealRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteSeal or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.SiteSeal
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def retrieve_site_seal(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        site_seal_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteSeal:
        """Verify domain ownership for this certificate order.

        Verify domain ownership for this certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param site_seal_request: Site seal request. Required.
        :type site_seal_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteSeal or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.SiteSeal
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def retrieve_site_seal(
        self,
        resource_group_name: str,
        certificate_order_name: str,
        site_seal_request: Union[_models.SiteSealRequest, IO],
        **kwargs: Any
    ) -> _models.SiteSeal:
        """Verify domain ownership for this certificate order.

        Verify domain ownership for this certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :param site_seal_request: Site seal request. Is either a SiteSealRequest type or a IO type.
         Required.
        :type site_seal_request: ~azure.mgmt.web.v2015_08_01.models.SiteSealRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteSeal or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2015_08_01.models.SiteSeal
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteSeal] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_seal_request, (IO, bytes)):
            _content = site_seal_request
        else:
            _json = self._serialize.body(site_seal_request, "SiteSealRequest")

        request = build_retrieve_site_seal_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.retrieve_site_seal.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteSeal", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    retrieve_site_seal.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/retrieveSiteSeal"
    }

    @distributed_trace_async
    async def verify_domain_ownership(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, certificate_order_name: str, **kwargs: Any
    ) -> None:
        """Verify domain ownership for this certificate order.

        Verify domain ownership for this certificate order.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param certificate_order_name: Name of the certificate order. Required.
        :type certificate_order_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_verify_domain_ownership_request(
            resource_group_name=resource_group_name,
            certificate_order_name=certificate_order_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.verify_domain_ownership.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    verify_domain_ownership.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/verifyDomainOwnership"
    }

    @distributed_trace_async
    async def retrieve_certificate_actions(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> List[_models.CertificateOrderAction]:
        """Retrieve the list of certificate actions.

        Retrieve the list of certificate actions.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the certificate order. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of CertificateOrderAction or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2015_08_01.models.CertificateOrderAction]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[List[_models.CertificateOrderAction]] = kwargs.pop("cls", None)

        request = build_retrieve_certificate_actions_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.retrieve_certificate_actions.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[CertificateOrderAction]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    retrieve_certificate_actions.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions"
    }

    @distributed_trace_async
    async def retrieve_certificate_email_history(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> List[_models.CertificateEmail]:
        """Retrieve email history.

        Retrieve email history.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the certificate order. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of CertificateEmail or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2015_08_01.models.CertificateEmail]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2015-08-01"] = kwargs.pop("api_version", _params.pop("api-version", "2015-08-01"))
        cls: ClsType[List[_models.CertificateEmail]] = kwargs.pop("cls", None)

        request = build_retrieve_certificate_email_history_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.retrieve_certificate_email_history.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[CertificateEmail]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    retrieve_certificate_email_history.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory"
    }
