# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class Operation(Model):
    """Microsoft.Resources operation.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: The object that represents the operation.
    :type display:
     ~azure.mgmt.resource.links.v2016_09_01.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """The object that represents the operation.

    :param provider: Service provider: Microsoft.Resources
    :type provider: str
    :param resource: Resource on which the operation is performed: Profile,
     endpoint, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class ResourceLink(Model):
    """The resource link.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The fully qualified ID of the resource link.
    :vartype id: str
    :ivar name: The name of the resource link.
    :vartype name: str
    :ivar type: The resource link object.
    :vartype type: object
    :param properties: Properties for resource link.
    :type properties:
     ~azure.mgmt.resource.links.v2016_09_01.models.ResourceLinkProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'object'},
        'properties': {'key': 'properties', 'type': 'ResourceLinkProperties'},
    }

    def __init__(self, **kwargs):
        super(ResourceLink, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = kwargs.get('properties', None)


class ResourceLinkFilter(Model):
    """Resource link filter.

    All required parameters must be populated in order to send to Azure.

    :param target_id: Required. The ID of the target resource.
    :type target_id: str
    """

    _validation = {
        'target_id': {'required': True},
    }

    _attribute_map = {
        'target_id': {'key': 'targetId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceLinkFilter, self).__init__(**kwargs)
        self.target_id = kwargs.get('target_id', None)


class ResourceLinkProperties(Model):
    """The resource link properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar source_id: The fully qualified ID of the source resource in the
     link.
    :vartype source_id: str
    :param target_id: Required. The fully qualified ID of the target resource
     in the link.
    :type target_id: str
    :param notes: Notes about the resource link.
    :type notes: str
    """

    _validation = {
        'source_id': {'readonly': True},
        'target_id': {'required': True},
    }

    _attribute_map = {
        'source_id': {'key': 'sourceId', 'type': 'str'},
        'target_id': {'key': 'targetId', 'type': 'str'},
        'notes': {'key': 'notes', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceLinkProperties, self).__init__(**kwargs)
        self.source_id = None
        self.target_id = kwargs.get('target_id', None)
        self.notes = kwargs.get('notes', None)
