# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OpenIdAuthenticationSettingsContract(Model):
    """API OAuth2 Authentication settings details.

    :param openid_provider_id: OAuth authorization server identifier.
    :type openid_provider_id: str
    :param bearer_token_sending_methods: How to send token to the server.
    :type bearer_token_sending_methods: list[str or
     ~azure.mgmt.apimanagement.models.BearerTokenSendingMethods]
    """

    _attribute_map = {
        'openid_provider_id': {'key': 'openidProviderId', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'bearerTokenSendingMethods', 'type': '[str]'},
    }

    def __init__(self, *, openid_provider_id: str=None, bearer_token_sending_methods=None, **kwargs) -> None:
        super(OpenIdAuthenticationSettingsContract, self).__init__(**kwargs)
        self.openid_provider_id = openid_provider_id
        self.bearer_token_sending_methods = bearer_token_sending_methods
