/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class WithParam
extends GeneralVariable {
    int parameterId;
    boolean typeChecked = false;

    public void setParameterId(int id) {
        this.parameterId = id;
    }

    public void setTypeChecked(boolean checked) {
        this.typeChecked = checked;
    }

    public int getParameterId() {
        return this.parameterId;
    }

    public int getInstructionNameCode() {
        return 206;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return null;
    }

    public static void simplify(WithParam[] params, ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < params.length; ++i) {
            Expression select = params[i].getSelectExpression();
            if (select == null) continue;
            params[i].setSelectExpression(visitor.simplify(select));
        }
    }

    public static void typeCheck(WithParam[] params, ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int i = 0; i < params.length; ++i) {
            Expression select = params[i].getSelectExpression();
            if (select == null) continue;
            params[i].setSelectExpression(visitor.typeCheck(select, contextItemType));
        }
    }

    public static void optimize(ExpressionVisitor visitor, WithParam[] params, ItemType contextItemType) throws XPathException {
        for (int i = 0; i < params.length; ++i) {
            visitor.optimize(params[i], contextItemType);
        }
    }

    public static void promoteParams(Expression parent, WithParam[] params, PromotionOffer offer) throws XPathException {
        for (int i = 0; i < params.length; ++i) {
            Expression select = params[i].getSelectExpression();
            if (select == null) continue;
            params[i].setSelectExpression(select.promote(offer, parent));
        }
    }

    public static WithParam[] copy(WithParam[] params) {
        WithParam[] result = new WithParam[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = new WithParam();
            result[i].parameterId = params[i].parameterId;
            result[i].slotNumber = params[i].slotNumber;
            result[i].typeChecked = params[i].typeChecked;
            result[i].select = params[i].select.copy();
            result[i].requiredType = params[i].requiredType;
            result[i].variableQName = params[i].variableQName;
        }
        return result;
    }

    public static void getXPathExpressions(WithParam[] params, List list) {
        if (params != null) {
            list.addAll(Arrays.asList(params));
        }
    }

    public static void displayExpressions(WithParam[] params, ExpressionPresenter out) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                out.startElement("withParam");
                out.emitAttribute("name", params[i].getVariableQName().getDisplayName());
                params[i].getSelectExpression().explain(out);
                out.endElement();
            }
        }
    }

    public static boolean replaceXPathExpression(WithParam[] params, Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < params.length; ++i) {
            boolean f = params[i].replaceSubExpression(original, replacement);
            found |= f;
        }
        return found;
    }

    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        throw new UnsupportedOperationException();
    }

    public boolean isTypeChecked() {
        return this.typeChecked;
    }
}

