/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class Floor
extends Function {
    public String getName() {
        return "floor";
    }

    public int getDataType() {
        return 2;
    }

    public Expression simplify() throws XPathException {
        this.checkArgumentCount(1, 1);
        this.argument[0] = this.argument[0].simplify();
        if (this.argument[0] instanceof Value) {
            return this.evaluate(null);
        }
        return this;
    }

    public double evaluateAsNumber(Context context) throws XPathException {
        return Math.floor(this.argument[0].evaluateAsNumber(context));
    }

    public Value evaluate(Context context) throws XPathException {
        return new NumericValue(this.evaluateAsNumber(context));
    }

    public int getDependencies() {
        return this.argument[0].getDependencies();
    }

    public Expression reduce(int n, Context context) throws XPathException {
        Floor floor = new Floor();
        floor.addArgument(this.argument[0].reduce(n, context));
        floor.setStaticContext(this.getStaticContext());
        return floor.simplify();
    }
}

