/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.config.XProcConfigurer;
import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.functions.BaseURI;
import com.xmlcalabash.functions.Cwd;
import com.xmlcalabash.functions.IterationPosition;
import com.xmlcalabash.functions.IterationSize;
import com.xmlcalabash.functions.ResolveURI;
import com.xmlcalabash.functions.StepAvailable;
import com.xmlcalabash.functions.SystemProperty;
import com.xmlcalabash.functions.ValueAvailable;
import com.xmlcalabash.functions.VersionAvailable;
import com.xmlcalabash.functions.XPathVersionAvailable;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Parser;
import com.xmlcalabash.model.PipelineLibrary;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XLibrary;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XRootStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.DefaultXProcConfigurer;
import com.xmlcalabash.util.DefaultXProcMessageListener;
import com.xmlcalabash.util.StepErrorListener;
import com.xmlcalabash.util.URIUtils;
import com.xmlcalabash.util.XProcURIResolver;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.httpclient.Cookie;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XProcRuntime {
    protected Logger logger = Logger.getLogger("com.xmlcalabash");
    private Processor processor = null;
    private Parser parser = null;
    private XProcURIResolver uriResolver = null;
    private XProcConfiguration config = null;
    private Vector<XStep> reported = new Vector();
    private QName errorCode = null;
    private XdmNode errorNode = null;
    private String errorMessage = null;
    private Hashtable<QName, DeclareStep> declaredSteps = new Hashtable();
    private DeclareStep pipeline = null;
    private XPipeline xpipeline = null;
    private Vector<Throwable> errors = null;
    private static String episode = null;
    private Hashtable<String, Vector<XdmNode>> collections = null;
    private URI staticBaseURI = null;
    private boolean allowGeneralExpressions = true;
    private boolean allowXPointerOnText = true;
    private boolean transparentJSON = false;
    private String jsonFlavor = "marklogic";
    private boolean useXslt10 = false;
    private XProcData xprocData = null;
    private Logger log = null;
    private XProcMessageListener msgListener = null;
    private PipelineLibrary standardLibrary = null;
    private XLibrary xStandardLibrary = null;
    private Hashtable<String, Vector<Cookie>> cookieHash = new Hashtable();
    private XProcConfigurer configurer = null;
    private String htmlParser = null;

    public XProcRuntime(XProcConfiguration config) {
        this.config = config;
        this.processor = config.getProcessor();
        if (config.xprocConfigurer != null) {
            try {
                String className = config.xprocConfigurer;
                Constructor<?> constructor = Class.forName(className).getConstructor(XProcRuntime.class);
                this.configurer = (XProcConfigurer)constructor.newInstance(this);
            }
            catch (Exception e) {
                throw new XProcException(e);
            }
        } else {
            this.configurer = new DefaultXProcConfigurer(this);
        }
        this.xprocData = new XProcData(this);
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new Cwd(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new BaseURI(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new ResolveURI(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new SystemProperty(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new StepAvailable(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new IterationSize(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new IterationPosition(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new ValueAvailable(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new VersionAvailable(this));
        this.processor.registerExtensionFunction((ExtensionFunctionDefinition)new XPathVersionAvailable(this));
        this.log = Logger.getLogger(this.getClass().getName());
        Configuration saxonConfig = this.processor.getUnderlyingConfiguration();
        this.uriResolver = new XProcURIResolver(this);
        saxonConfig.setURIResolver((URIResolver)this.uriResolver);
        this.staticBaseURI = URIUtils.cwdAsURI();
        try {
            if (config.uriResolver != null) {
                this.uriResolver.setUnderlyingURIResolver((URIResolver)Class.forName(config.uriResolver).newInstance());
            }
            if (config.entityResolver != null) {
                this.uriResolver.setUnderlyingEntityResolver((EntityResolver)Class.forName(config.entityResolver).newInstance());
            }
            this.msgListener = config.errorListener != null ? (XProcMessageListener)Class.forName(config.errorListener).newInstance() : new DefaultXProcMessageListener();
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
        this.processor.getUnderlyingConfiguration().setURIResolver((URIResolver)this.uriResolver);
        StepErrorListener errListener = new StepErrorListener(this);
        saxonConfig.setErrorListener((ErrorListener)errListener);
        this.allowGeneralExpressions = config.extensionValues;
        this.allowXPointerOnText = config.xpointerOnText;
        this.transparentJSON = config.transparentJSON;
        this.jsonFlavor = config.jsonFlavor;
        this.useXslt10 = config.useXslt10;
        for (String className : config.extensionFunctions) {
            try {
                ExtensionFunctionDefinition def = (ExtensionFunctionDefinition)Class.forName(className).newInstance();
                this.finer(null, null, "Instantiated: " + className);
                this.processor.registerExtensionFunction(def);
            }
            catch (NoClassDefFoundError ncdfe) {
                this.finer(null, null, "Failed to instantiate extension function: " + className);
            }
            catch (Exception e) {
                this.finer(null, null, "Failed to instantiate extension function: " + className);
            }
        }
        this.htmlParser = config.htmlParser;
        this.reset();
    }

    public XProcRuntime(XProcRuntime runtime) {
        this.processor = runtime.processor;
        this.parser = runtime.parser;
        this.uriResolver = runtime.uriResolver;
        this.config = runtime.config;
        this.staticBaseURI = runtime.staticBaseURI;
        this.useXslt10 = runtime.useXslt10;
        this.log = runtime.log;
        this.msgListener = runtime.msgListener;
        this.standardLibrary = runtime.standardLibrary;
        this.xStandardLibrary = runtime.xStandardLibrary;
        this.cookieHash = runtime.cookieHash;
        this.configurer = runtime.configurer;
        this.allowGeneralExpressions = runtime.allowGeneralExpressions;
        this.allowXPointerOnText = runtime.allowXPointerOnText;
        this.transparentJSON = runtime.transparentJSON;
        this.jsonFlavor = runtime.jsonFlavor;
    }

    public XProcConfigurer getConfigurer() {
        return this.configurer;
    }

    public void setConfigurer(XProcConfigurer configurer) {
        this.configurer = configurer;
    }

    public XProcData getXProcData() {
        return this.xprocData;
    }

    public boolean getDebug() {
        return this.config.debug;
    }

    public URI getStaticBaseURI() {
        return this.staticBaseURI;
    }

    public String getSendmailHost() {
        return this.config.mailHost;
    }

    public String getSendmailPort() {
        return this.config.mailPort;
    }

    public String getSendmailUsername() {
        return this.config.mailUser;
    }

    public String getSendmailPassword() {
        return this.config.mailPass;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver.setUnderlyingURIResolver(resolver);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.uriResolver.setUnderlyingEntityResolver(resolver);
    }

    public XProcURIResolver getResolver() {
        return this.uriResolver;
    }

    public XProcMessageListener getMessageListener() {
        return this.msgListener;
    }

    public void setMessageListener(XProcMessageListener listener) {
        this.msgListener = listener;
    }

    public void setCollection(URI href, Vector<XdmNode> docs) {
        if (this.collections == null) {
            this.collections = new Hashtable();
        }
        this.collections.put(href.toASCIIString(), docs);
    }

    public Vector<XdmNode> getCollection(URI href) {
        if (this.collections == null) {
            return null;
        }
        if (this.collections.containsKey(href.toASCIIString())) {
            return this.collections.get(href.toASCIIString());
        }
        return null;
    }

    public boolean getSafeMode() {
        return this.config.safeMode;
    }

    public boolean getAllowGeneralExpressions() {
        return this.allowGeneralExpressions;
    }

    public boolean getAllowXPointerOnText() {
        return this.allowXPointerOnText;
    }

    public boolean transparentJSON() {
        return this.transparentJSON;
    }

    public String jsonFlavor() {
        return this.jsonFlavor;
    }

    public String htmlParser() {
        return this.htmlParser;
    }

    public boolean getUseXslt10Processor() {
        return this.useXslt10;
    }

    public void cache(XdmNode doc, URI baseURI) {
        this.uriResolver.cache(doc, baseURI);
    }

    public XProcConfiguration getConfiguration() {
        return this.config;
    }

    public Parser getParser() {
        return this.parser;
    }

    public String getEpisode() {
        if (episode == null) {
            MessageDigest digest = null;
            GregorianCalendar calendar = new GregorianCalendar();
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw XProcException.dynamicError(36);
            }
            byte[] hash = digest.digest(calendar.toString().getBytes());
            episode = "CB";
            for (byte b : hash) {
                episode = episode + Integer.toHexString(b & 0xFF);
            }
        }
        return episode;
    }

    public String getLanguage() {
        return Locale.getDefault().toString().replace('_', '-');
    }

    public String getProductName() {
        return "XML Calabash";
    }

    public String getProductVersion() {
        return XProcConstants.XPROC_VERSION;
    }

    public String getVendor() {
        return "Norman Walsh";
    }

    public String getVendorURI() {
        return "http://xmlcalabash.com/";
    }

    public String getXProcVersion() {
        return "1.0";
    }

    public String getXPathVersion() {
        return "2.0";
    }

    public boolean getPSVISupported() {
        return this.config.schemaAware;
    }

    public XLibrary getStandardLibrary() {
        if (this.xStandardLibrary == null) {
            this.xStandardLibrary = new XLibrary(this, this.standardLibrary);
            if (this.errorCode != null) {
                throw new XProcException(this.errorCode, this.errorMessage);
            }
        }
        return this.xStandardLibrary;
    }

    private void reset() {
        this.reported = new Vector();
        this.errorCode = null;
        this.errorMessage = null;
        this.declaredSteps = new Hashtable();
        this.pipeline = null;
        this.xpipeline = null;
        this.errors = null;
        episode = null;
        this.collections = null;
        this.cookieHash = new Hashtable();
        this.xprocData = new XProcData(this);
        this.parser = new Parser(this);
        try {
            this.standardLibrary = this.parser.loadStandardLibrary();
            if (this.errorCode != null) {
                throw new XProcException(this.errorCode, this.errorMessage);
            }
        }
        catch (FileNotFoundException ex) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)ex);
        }
        catch (URISyntaxException ex) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)ex);
        }
        catch (SaxonApiException ex) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)ex);
        }
    }

    public XPipeline load(String pipelineURI) throws SaxonApiException {
        for (String map : this.config.loaders.keySet()) {
            boolean data = map.startsWith("data:");
            String pattern = map.substring(5);
            if (!pipelineURI.matches(pattern)) continue;
            return this.runPipelineLoader(pipelineURI, this.config.loaders.get(map), data);
        }
        try {
            return this._load(pipelineURI);
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
    }

    private XPipeline _load(String pipelineURI) throws SaxonApiException {
        this.reset();
        this.configurer.getXMLCalabashConfigurer().configRuntime(this);
        this.pipeline = this.parser.loadPipeline(pipelineURI);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XRootStep root = new XRootStep(this);
        DeclareStep decl = this.pipeline.getDeclaration();
        decl.setup();
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorNode, this.errorMessage);
        }
        this.xpipeline = new XPipeline(this, this.pipeline, root);
        this.xpipeline.instantiate(decl);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return this.xpipeline;
    }

    public XPipeline use(XdmNode p_pipeline) throws SaxonApiException {
        try {
            return this._use(p_pipeline);
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
    }

    private XPipeline _use(XdmNode p_pipeline) throws SaxonApiException {
        this.reset();
        this.configurer.getXMLCalabashConfigurer().configRuntime(this);
        this.pipeline = this.parser.usePipeline(p_pipeline);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XRootStep root = new XRootStep(this);
        DeclareStep decl = this.pipeline.getDeclaration();
        decl.setup();
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        this.xpipeline = new XPipeline(this, this.pipeline, root);
        this.xpipeline.instantiate(decl);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return this.xpipeline;
    }

    public XLibrary loadLibrary(String libraryURI) throws SaxonApiException {
        for (String map : this.config.loaders.keySet()) {
            boolean data = map.startsWith("data:");
            String pattern = map.substring(5);
            if (!libraryURI.matches(pattern)) continue;
            return this.runLibraryLoader(libraryURI, this.config.loaders.get(map), data);
        }
        try {
            return this._loadLibrary(libraryURI);
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
    }

    private XLibrary _loadLibrary(String libraryURI) throws SaxonApiException {
        PipelineLibrary plibrary = this.parser.loadLibrary(libraryURI);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XLibrary xlibrary = new XLibrary(this, plibrary);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return xlibrary;
    }

    public XLibrary useLibrary(XdmNode library) throws SaxonApiException {
        try {
            return this._useLibrary(library);
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
    }

    private XLibrary _useLibrary(XdmNode library) throws SaxonApiException {
        PipelineLibrary plibrary = this.parser.useLibrary(library);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        XLibrary xlibrary = new XLibrary(this, plibrary);
        if (this.errorCode != null) {
            throw new XProcException(this.errorCode, this.errorMessage);
        }
        return xlibrary;
    }

    private XPipeline runPipelineLoader(String pipelineURI, String loaderURI, boolean data) throws SaxonApiException {
        XdmNode pipeDoc = this.runLoader(pipelineURI, loaderURI, data);
        return this.use(pipeDoc);
    }

    private XLibrary runLibraryLoader(String pipelineURI, String loaderURI, boolean data) throws SaxonApiException {
        XdmNode libDoc = this.runLoader(pipelineURI, loaderURI, data);
        return this.useLibrary(libDoc);
    }

    private XdmNode runLoader(String pipelineURI, String loaderURI, boolean data) throws SaxonApiException {
        XPipeline loader = null;
        try {
            loader = this._load(loaderURI);
        }
        catch (SaxonApiException sae) {
            this.error(sae);
            throw sae;
        }
        catch (XProcException xe) {
            this.error(xe);
            throw xe;
        }
        XdmNode pipeDoc = null;
        if (data) {
            ReadableData rdata = new ReadableData(this, XProcConstants.c_result, this.getStaticBaseURI().resolve(pipelineURI).toASCIIString(), "text/plain");
            pipeDoc = rdata.read();
        } else {
            pipeDoc = this.parse(pipelineURI, this.getStaticBaseURI().toASCIIString());
        }
        loader.clearInputs("source");
        loader.writeTo("source", pipeDoc);
        loader.run();
        ReadablePipe xformed = loader.readFrom("result");
        pipeDoc = xformed.read();
        this.reset();
        return pipeDoc;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public XdmNode parse(String uri, String base) {
        return this.parse(uri, base, false);
    }

    public XdmNode parse(String uri, String base, boolean validate) {
        return this.uriResolver.parse(uri, base, validate);
    }

    public XdmNode parse(InputSource isource) {
        return this.uriResolver.parse(isource);
    }

    public void declareStep(QName name, DeclareStep step) {
        if (this.declaredSteps.containsKey(name)) {
            throw new XProcException((Step)step, "Duplicate declaration for " + name);
        }
        this.declaredSteps.put(name, step);
    }

    public DeclareStep getBuiltinDeclaration(QName name) {
        if (this.declaredSteps.containsKey(name)) {
            return this.declaredSteps.get(name);
        }
        throw XProcException.staticError(44, null, "Unexpected step name: " + name);
    }

    public void clearCookies(String key) {
        if (this.cookieHash.containsKey(key)) {
            this.cookieHash.get(key).clear();
        }
    }

    public void addCookie(String key, Cookie cookie) {
        if (!this.cookieHash.containsKey(key)) {
            this.cookieHash.put(key, new Vector());
        }
        this.cookieHash.get(key).add(cookie);
    }

    public Vector<Cookie> getCookies(String key) {
        if (this.cookieHash.containsKey(key)) {
            return this.cookieHash.get(key);
        }
        return new Vector<Cookie>();
    }

    public QName getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void error(XProcRunnable step, XdmNode node, String message, QName code) {
        if (this.errorCode == null) {
            this.errorCode = code;
            this.errorNode = node;
            this.errorMessage = message;
        }
        this.msgListener.error(step, node, message, code);
    }

    public void error(Throwable error) {
        this.msgListener.error(error);
    }

    public void warning(XProcRunnable step, XdmNode node, String message) {
        this.msgListener.warning(step, node, message);
    }

    public void warning(Throwable error) {
        this.msgListener.warning(error);
    }

    public void info(XProcRunnable step, XdmNode node, String message) {
        this.msgListener.info(step, node, message);
    }

    public void fine(XProcRunnable step, XdmNode node, String message) {
        this.msgListener.fine(step, node, message);
    }

    public void finer(XProcRunnable step, XdmNode node, String message) {
        this.msgListener.finer(step, node, message);
    }

    public void finest(XProcRunnable step, XdmNode node, String message) {
        this.msgListener.finest(step, node, message);
    }

    public void reportStep(XStep step) {
        this.reported.add(step);
    }

    public void start(XPipeline pipe) {
    }

    public void finish(XPipeline pipe) {
    }
}

