/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.URIUtils;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class MakeAbsoluteURIs
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("", "match");
    private static final QName _base_uri = new QName("", "base-uri");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private URI setBaseURI = null;

    public MakeAbsoluteURIs(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode xdmNode = this.source.read();
        RuntimeValue runtimeValue = this.getOption(_base_uri);
        if (runtimeValue != null) {
            this.setBaseURI = runtimeValue.getBaseURI().resolve(runtimeValue.getString());
        }
        this.finest(xdmNode, "Making URIs absolute against: " + this.setBaseURI);
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(xdmNode, this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addStartElement(xdmNode);
        this.matcher.addAttributes(xdmNode);
        String string = xdmNode.getStringValue();
        string = URIUtils.encode(string);
        URI uRI = this.setBaseURI == null ? xdmNode.getBaseURI() : this.setBaseURI;
        String string2 = uRI.resolve(string).toString();
        this.matcher.addText(string2);
        return false;
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        String string = xdmNode.getStringValue();
        string = URIUtils.encode(string);
        URI uRI = this.setBaseURI == null ? xdmNode.getBaseURI() : this.setBaseURI;
        String string2 = uRI.resolve(string).toString();
        this.matcher.addAttribute(xdmNode, string2);
    }
}

