/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fa;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.ar.ArabicLetterTokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersianAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private final Set<?> stoptable;
    public static final String STOPWORDS_COMMENT = "#";
    private final Version matchVersion;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public PersianAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public PersianAnalyzer(Version matchVersion, Set<?> stopwords) {
        this.stoptable = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stopwords));
        this.matchVersion = matchVersion;
    }

    public PersianAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((String[])stopwords));
    }

    public PersianAnalyzer(Version matchVersion, Hashtable<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    public PersianAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((File)stopwords, (String)STOPWORDS_COMMENT));
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new ArabicLetterTokenizer(reader);
        result = new LowerCaseFilter((TokenStream)result);
        result = new ArabicNormalizationFilter((TokenStream)result);
        result = new PersianNormalizationFilter((TokenStream)result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stoptable);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new ArabicLetterTokenizer(reader);
            streams.result = new LowerCaseFilter((TokenStream)streams.source);
            streams.result = new ArabicNormalizationFilter(streams.result);
            streams.result = new PersianNormalizationFilter(streams.result);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.result, this.stoptable);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Set<String> loadDefaultStopWordSet() throws IOException {
            InputStream stream = PersianAnalyzer.class.getResourceAsStream(PersianAnalyzer.DEFAULT_STOPWORD_FILE);
            try {
                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                Set<String> set = Collections.unmodifiableSet(WordlistLoader.getWordSet((Reader)reader, (String)PersianAnalyzer.STOPWORDS_COMMENT));
                return set;
            }
            finally {
                stream.close();
            }
        }

        static {
            try {
                DEFAULT_STOP_SET = DefaultSetHolder.loadDefaultStopWordSet();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

