/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.SequenceType;

public class ResolveURI
extends ExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", "http://www.w3.org/ns/xproc", "resolve-uri");
    private ThreadLocal<XProcRuntime> tl_runtime = new ThreadLocal<XProcRuntime>(){

        @Override
        protected synchronized XProcRuntime initialValue() {
            return null;
        }
    };

    protected ResolveURI() {
    }

    public ResolveURI(XProcRuntime runtime) {
        this.tl_runtime.set(runtime);
    }

    public StructuredQName getFunctionQName() {
        return funcname;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.OPTIONAL_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ATOMIC;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ResolveURICall();
    }

    private class ResolveURICall
    extends ExtensionFunctionCall {
        private ResolveURICall() {
        }

        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            SequenceIterator iter = arguments[0];
            String relativeURI = iter.next().getStringValue();
            XProcRuntime runtime = (XProcRuntime)ResolveURI.this.tl_runtime.get();
            XStep step = runtime.getXProcData().getStep();
            if (step != null && !(step instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            String baseURI = null;
            if (arguments.length > 1) {
                iter = arguments[1];
                baseURI = iter.next().getStringValue();
            } else {
                baseURI = runtime.getStaticBaseURI().toASCIIString();
                try {
                    Item item = context.getContextItem();
                    baseURI = ((TinyDocumentImpl)item).getBaseURI();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                URI abs = net.sf.saxon.functions.ResolveURI.makeAbsolute((String)relativeURI, (String)baseURI);
                String resolvedURI = abs.toASCIIString();
                return SingletonIterator.makeIterator((Item)new AnyURIValue((CharSequence)resolvedURI));
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
        }
    }
}

