/* Generated by wayland-scanner 1.23.1 */

#ifndef PRESENTATION_TIME_ENUM_PROTOCOL_H
#define PRESENTATION_TIME_ENUM_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef WP_PRESENTATION_ERROR_ENUM
#define WP_PRESENTATION_ERROR_ENUM
/**
 * @ingroup iface_wp_presentation
 * fatal presentation errors
 *
 * These fatal protocol errors may be emitted in response to
 * illegal presentation requests.
 */
enum wp_presentation_error {
	/**
	 * invalid value in tv_nsec
	 */
	WP_PRESENTATION_ERROR_INVALID_TIMESTAMP = 0,
	/**
	 * invalid flag
	 */
	WP_PRESENTATION_ERROR_INVALID_FLAG = 1,
};
#endif /* WP_PRESENTATION_ERROR_ENUM */

#ifndef WP_PRESENTATION_FEEDBACK_KIND_ENUM
#define WP_PRESENTATION_FEEDBACK_KIND_ENUM
/**
 * @ingroup iface_wp_presentation_feedback
 * bitmask of flags in presented event
 *
 * These flags provide information about how the presentation of
 * the related content update was done. The intent is to help
 * clients assess the reliability of the feedback and the visual
 * quality with respect to possible tearing and timings.
 */
enum wp_presentation_feedback_kind {
	/**
	 * presentation was vsync'd
	 *
	 * The presentation was synchronized to the "vertical retrace" by
	 * the display hardware such that tearing does not happen. Relying
	 * on software scheduling is not acceptable for this flag. If
	 * presentation is done by a copy to the active frontbuffer, then
	 * it must guarantee that tearing cannot happen.
	 */
	WP_PRESENTATION_FEEDBACK_KIND_VSYNC = 0x1,
	/**
	 * hardware provided the presentation timestamp
	 *
	 * The display hardware provided measurements that the hardware
	 * driver converted into a presentation timestamp. Sampling a clock
	 * in software is not acceptable for this flag.
	 */
	WP_PRESENTATION_FEEDBACK_KIND_HW_CLOCK = 0x2,
	/**
	 * hardware signalled the start of the presentation
	 *
	 * The display hardware signalled that it started using the new
	 * image content. The opposite of this is e.g. a timer being used
	 * to guess when the display hardware has switched to the new image
	 * content.
	 */
	WP_PRESENTATION_FEEDBACK_KIND_HW_COMPLETION = 0x4,
	/**
	 * presentation was done zero-copy
	 *
	 * The presentation of this update was done zero-copy. This means
	 * the buffer from the client was given to display hardware as is,
	 * without copying it. Compositing with OpenGL counts as copying,
	 * even if textured directly from the client buffer. Possible
	 * zero-copy cases include direct scanout of a fullscreen surface
	 * and a surface on a hardware overlay.
	 */
	WP_PRESENTATION_FEEDBACK_KIND_ZERO_COPY = 0x8,
};
#endif /* WP_PRESENTATION_FEEDBACK_KIND_ENUM */

#ifdef  __cplusplus
}
#endif

#endif
