/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class ObjectValue
extends AtomicValue {
    private Object value;
    private static final ExternalObjectType objectType = new ExternalObjectType(Object.class);

    public ObjectValue() {
        this.typeLabel = objectType;
    }

    public ObjectValue(Object object) {
        this.value = object;
        this.typeLabel = new ExternalObjectType(object.getClass());
    }

    public ObjectValue(Object object, ExternalObjectType type) {
        this.value = object;
        this.typeLabel = type;
    }

    public void setValue(Object value) {
        this.value = value;
        this.typeLabel = new ExternalObjectType(value.getClass());
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        ObjectValue v = new ObjectValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.typeLabel.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            if (th == null) {
                throw new NullPointerException("No TypeHierarchy supplied");
            }
            Configuration config = th.getConfiguration();
            this.typeLabel = new ExternalObjectType(this.value.getClass(), config);
        }
        return this.typeLabel;
    }

    public String displayTypeName() {
        return "java-type:" + this.value.getClass().getName();
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, ConversionRules rules) {
        switch (requiredType.getPrimitiveType()) {
            case 285: 
            case 632: {
                return this;
            }
            case 514: {
                return BooleanValue.get(this.value != null && this.value.toString().length() > 0);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        return new StringValue(this.getStringValue()).convertPrimitive(requiredType, validate, rules);
    }

    public CharSequence getPrimitiveStringValue() {
        return this.value == null ? "" : this.value.toString();
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.value != null;
    }

    public Object getObject() {
        return this.value;
    }

    public Comparable getSchemaComparable() {
        throw new UnsupportedOperationException("External objects cannot be compared according to XML Schema rules");
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return ordered ? null : this;
    }

    public boolean equals(Object other) {
        return other instanceof ObjectValue && this.value.equals(((ObjectValue)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

