/*
  Graphical IDF Wizard
  Copyright (C) 1998,1999,2002,2005,2010 David Martnez Oliveira

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <unistd.h>
#include <gtk/gtk.h>

#include <edma.h>

/* App Forms */
#include "generalform.h"
#include "propform.h"
#include "metform.h"
#include "inhform.h"
#include "prefform.h"
#include "filemake.h"

/* Constants */
#define COPYRIGHT "(c) David Martnez Oliveira"

/* Function prtotypes */
int my_main (int argc,char *argv[]);
int ScriptTableInit();


/* Global vars */
OBJID     id2;
CLASSID   cId = -1;
EChar     ProjectName[200];
EChar     CurrentDir[200];

GeneralWidgets     ggw;
PropertyWidgets    gpw;
MethodWidgets      gmw;
InheritanceWidgets giw;
PrefWidgets        gfw;

/*
** GNOME stuff
** 
*/
void 
about_callback (GtkWidget *widget, gpointer data)
{

  GtkAboutDialog *aboutdlg = NULL;
  const gchar *authors[] = {
    "David Martinez Oliviera",
    NULL
  };

  aboutdlg = (GtkAboutDialog*) gtk_about_dialog_new ();
  gtk_about_dialog_set_name (aboutdlg, "Graphical IDF Wizard");
  gtk_about_dialog_set_version (aboutdlg, "0.6.3");
  //gtk_about_dialog_set_license (aboutdlg, "GPL");
  gtk_about_dialog_set_website (aboutdlg, "http://www.gnu.org/software/edma/");
  gtk_about_dialog_set_comments (aboutdlg, 	
				 "Graphical IDF Wizard allows you to generate "
				 "class interfaces and other required files for "
				 "building classes. Works with GNU EDMA 0.9.2 "
				 "or later");
  gtk_about_dialog_set_authors (aboutdlg, authors);

  gtk_dialog_run ((GtkDialog*)aboutdlg);

  gtk_widget_destroy ((GtkWidget*)aboutdlg); 

}

/* Callback function for main window delete event. Always allows delete. */
int 
delete_callback (GtkWidget *widget, gpointer data)
{
   return FALSE;
}

/* Callback function for main window destroy. Exits gtk_main_loop. */
void 
exit_callback (GtkWidget *widget, gpointer data)
{
    gtk_main_quit ();
}

void 
file_ok_sel (GtkWidget *w, GtkWidget *fs)
{
  const gchar   *fname;
  EChar   hole[100];
  OBJID   parser;
  EChar   buf[500], name[200], type[200], access[200];
  EPChar  aux, aux1;
  EUint32 i, ne, n, m_static, m_abstract;

  fname = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  g_print ("IDF FIle: %s\n", fname);

  /* We have a IDF FIle */
  /* We create the IDF parser */
  parser = edma_new_obj ("EDMAIDF_PARSER");
  edma_met3 (parser, "Open", fname);
  edma_met3 (parser, "GetClassName", buf);
  g_print ("ClassName : %s\n", buf);
  GeneralSetClassName (&ggw, buf);

  edma_met3 (parser, "GetNameSpace", buf);
  g_print ("NameSpace : %s\n", buf);
  GeneralSetNameSpace (&ggw, buf);

  edma_met3 (parser, "GetMajorVersion", &n);
  GeneralSetMajorVersion (&ggw, n);

  edma_met3 (parser, "GetMinorVersion", &n);
  GeneralSetMinorVersion (&ggw, n);  

  edma_met3 (parser, "GetModuleName", buf);
  g_print ("ClassName : %s\n", buf);
  GeneralSetModuleName (&ggw, buf);

  /* Adding property info */
  PropInit (&gpw);
  edma_met3 (parser, "GetNProp", &n);
  g_print ("\nProcessing %d properties\n", n);
  for (i = 0; i < n; i++)
    {
      edma_met3 (parser, "GetPropName",   i, name);
      edma_met3 (parser, "GetPropType",   i, type);
      edma_met3 (parser, "GetPropAccess", i, access);
      edma_met3 (parser, "GetPropNElems", i, &ne);

      PropSet (&gpw, name, type, access, ne);
    }

  /* Adding method info */
  MetInit (&gmw);
  edma_met3 (parser, "GetNMet", &n);
  g_print ("\nProcessing %d properties\n", n);
  for (i = 0; i < n; i++)
    {
      edma_met3 (parser, "GetMetName",      i, name);
      edma_met3 (parser, "GetMetSignature", i, type);
      edma_met3 (parser, "IsMetVirtual",    i, &ne);
      edma_met3 (parser, "IsMetStatic",     i, &m_static);
      edma_met3 (parser, "IsMetAbstract",   i, &m_abstract);

      /* FIXME: We must to change EDMAIDF_PARSER*/
      MetSet (&gmw, name, type, ne, m_abstract, m_static);
    }

  /* Inheritance information */
  InhInit (&giw);
  memset (buf, 0, 500);
  edma_met3 (parser, "GetSCList", buf);
  n = 0;
  if (strlen (buf) != 0)
    {
      for (i = 0; i < strlen (buf); i++)
	if (buf[i] == ',')
	  n++;
      g_print ("Located %d superclasses", n + 1);
      aux1 = aux = buf;
      
      for (i = 0; i < n; i++)
	{
	  aux = strchr (aux1, ',');
	  *aux = 0;
	  InhSet (&giw, aux1);
	  aux1 = aux + 1;
	  g_print ("SC:%s", aux1);
	}
      InhSet (&giw, aux1);
    }
  
  edma_met3 (parser, "Close");
  g_print ("\nIDF File successfuly loaded");    

  edma_free_obj (parser);
  gtk_widget_destroy (fs);

}

void 
destroy (GtkWidget *widget, GtkWidget *fs)
{
  g_print ("\n Destroying File Selector");
  g_print ("\n");
  gtk_widget_destroy (widget);
}

/* Callback function for defining GNOME/GTK menus. */
void 
dummy_callback (GtkWidget *widget, gpointer data)
{
  
}

void 
new_callback (GtkWidget *widget, gpointer data)
{

  GeneralSetClassName  (&ggw, "");
  GeneralSetModuleName (&ggw, "");
  PropInit (&gpw);
  MetInit  (&gmw);
  InhInit  (&giw);
}

void 
open_callback (GtkWidget *widget, gpointer data)
{
  GtkWidget *fs;
  
  
  fs = gtk_file_selection_new ("Open IDF File");

  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_sel, fs );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);
}

/* Menus Ops. */
int 
make_file_name (char *temp)
{
  ESint32  v, vv;
  EChar    version[10];

  GeneralGetClassName (&ggw, temp);
  v =  GeneralGetMajorVersion (&ggw);
  vv = GeneralGetMinorVersion (&ggw);
  if ((v != 0) || (vv !=0))
  {
    sprintf (version, "_%d_%d", v, vv);
    strcat (temp, version);
  }
  return  0;
}


void 
make_idf_file (GtkWidget *widget, gpointer data)
{
  GtkWidget *fs;
  ESint32   v, vv;
  EChar     temp[256], version[10];

  fs = gtk_file_selection_new ("Save IDF File");

  make_file_name (temp);
  strcat (temp,".idf");

  gtk_file_selection_set_filename (GTK_FILE_SELECTION(fs), temp);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) save_idf_file, fs );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);
}

void 
make_ines_file (GtkWidget *widget, gpointer data)
{
  GtkWidget *fs;
  EChar     temp[256];

  fs = gtk_file_selection_new ("Save INES File");

  make_file_name(temp);
  strcat (temp,".ines");


  gtk_file_selection_set_filename (GTK_FILE_SELECTION(fs), temp);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) save_ines_file, fs );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);
  
}

void 
make_c_file (GtkWidget *widget, gpointer data)
{
  GtkWidget *fs;
  EChar     temp[256];

  fs=gtk_file_selection_new ("Save INES File");

  make_file_name (temp);
  strcat (temp, "_imp.c"); 
  
  gtk_file_selection_set_filename (GTK_FILE_SELECTION(fs), temp);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) save_imp_file, fs );


  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);

}


void 
make_make_file (GtkWidget *widget, gpointer data)
{
  GtkWidget *fs;
  EChar     temp[256];

  fs = gtk_file_selection_new ("Save INES File");

  make_file_name (temp);
  strcat (temp, ".mk");

  gtk_file_selection_set_filename (GTK_FILE_SELECTION(fs), temp);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) save_make_file, fs );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);

}

void 
make_doc_file (GtkWidget *widget, gpointer data)
{
  GtkWidget *fs;
  EChar     temp[256];


  fs = gtk_file_selection_new ("Save INES File");

  make_file_name (temp);
  strcat (temp, ".sgml");

  gtk_file_selection_set_filename (GTK_FILE_SELECTION(fs), temp);
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) save_doc_file, fs );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
			     "clicked", (GtkSignalFunc) destroy,
			     GTK_OBJECT (fs));
  gtk_widget_show (fs);

}

/* Builds Gnomish main menu in the application window (app) */


static GtkItemFactoryEntry menu_items[] = {
  { "/_File",         NULL,         NULL,           0, "<Branch>" },
  { "/File/_New",     "<control>N", new_callback,    0, "<StockItem>", GTK_STOCK_NEW },
  { "/File/_Open",    "<control>O", open_callback,    0, "<StockItem>", GTK_STOCK_OPEN },
  //  { "/File/_Save",    "<control>S", print_hello,    0, "<StockItem>", GTK_STOCK_SAVE },
  //  { "/File/Save _As", NULL,         NULL,           0, "<Item>" },
  { "/File/sep1",                 NULL,         NULL,           0, "<Separator>" },
  { "/File/_Quit",                "<CTRL>Q", exit_callback, 0, "<StockItem>", GTK_STOCK_QUIT },
  { "/_Make",                     NULL,         NULL,           0, "<Branch>" },
  { "/Make/tear",                 NULL,         NULL,           0, "<Tearoff>" },
  { "/Make/Interface",            NULL,         make_idf_file,  0, "<Item>" },
  { "/Make/Implementation Skel",  NULL,         make_c_file,    0, "<Item>" },
  { "/Make/Makefile Skel",        NULL,         make_make_file,    0, "<Item>" },
  //  { "/Make/Documentation Skel",   NULL,         make_doc_file,    0, "<Item>" },
  { "/Make/INES Instalation desc",NULL,         make_ines_file,    0, "<Item>" },

  { "/_Help",         NULL,         NULL,           0, "<LastBranch>" },
  { "/_Help/About",   NULL,         about_callback,           0, "<Item>" },
};

static gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

GtkWidget*
create_main_menu (GtkWidget *app)
{
  GtkWidget      *main_vbox, *menubar;
  GtkItemFactory *item_factory;
  GtkAccelGroup  *accel_group;

  

  /* Make an accelerator group (shortcut keys) */
  accel_group = gtk_accel_group_new ();

  /* Make an ItemFactory (that makes a menubar) */
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
                                       accel_group);

  /* This function generates the menu items. Pass the item factory,
     the number of items in the array, the array itself, and any
     callback data for the the menu items. */
  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);

  /* Attach the new accelerator group to the window. */
  gtk_window_add_accel_group (GTK_WINDOW (app), accel_group);

  /* Finally, return the actual menu bar created by the item factory. */
  return gtk_item_factory_get_widget (item_factory, "<main>");


   return;
}


/* Helper functions */
void 
close_application( GtkWidget *widget, gpointer data )
{
       gtk_main_quit();
}

int
main(int argc,char *argv[])
{
 
  /* Initialize EDMA System */
  EDMAInit();

  my_main(argc,argv);
  return 0;
}


int 
my_main(int argc,char *argv[])
{
  EUint32   i;
  GtkWidget *app;
  GtkWidget *note, *menubar, *main_vbox;
  GtkWidget *swindow,*swindow1,*swindow2;
  GtkWidget *window;
  GtkWidget *hpan;
  GtkWidget *vpan;
  GtkWidget *prop_box;
  GtkWidget *met_box;
  GtkWidget *class_list;
  GtkWidget *label1,*label2;
  GtkWidget *label,*edit,*combo,*aux;
  GList     *sos = NULL;
  GList     *lang = NULL;
  GList     *machines = NULL;
  GList     *proxies = NULL;
  GList     *parsers = NULL;
  GList     *types = NULL;
  GList     *acc = NULL;

#if 0
  gnome_init ("GIDFWizard", NULL, argc, argv);
  app = gnome_app_new ("GIDFWizard", "EDMA IDFWizard Gnomized");
#endif
  gtk_init (&argc, &argv);
  app = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_realize (app);
  
  /* Connect window signals */
  gtk_signal_connect (GTK_OBJECT (app), "delete_event",
		      GTK_SIGNAL_FUNC (delete_callback), NULL);
  gtk_signal_connect (GTK_OBJECT (app), "destroy",
		      GTK_SIGNAL_FUNC (exit_callback), NULL);  

  /* Make a vbox to put the main menu */
  main_vbox = gtk_vbox_new (FALSE, 1);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 1);
  gtk_container_add (GTK_CONTAINER (app), main_vbox);

  menubar = create_main_menu (app);

  /* Pack it all together */
  gtk_box_pack_start (GTK_BOX (main_vbox), menubar, FALSE, TRUE, 0);
  gtk_widget_show_all (app);

  
  window = gtk_vbox_new (FALSE,FALSE);   
  gtk_box_pack_start (GTK_BOX (main_vbox), window, FALSE, TRUE, 0);
  //gtk_container_add (GTK_CONTAINER(app), window);
  gtk_container_add (GTK_CONTAINER(app), main_vbox);
  //gnome_app_set_contents (GNOME_APP(app), window);
  note = gtk_notebook_new();
  
  gtk_container_add (GTK_CONTAINER(window), note);

  printf ("[DEBUG] Creating General Form\n");
  InitGeneralForm (&ggw);
  ggw.build_form  (&ggw, note);

  printf ("[DEBUG] Creating Properties Form\n");
  InitPropForm   (&gpw);
  gpw.build_form (&gpw, note);

  printf ("[DEBUG] Creating Methods Form\n");
  InitMetForm    (&gmw);
  gmw.build_form (&gmw, note);

  printf ("[DEBUG] Creating Inheritance Form\n");
  InitInhForm     (&giw);
  giw.build_form (&giw, note);

  printf ("[DEBUG] Creating Preferences Form\n");
  InitPrefForm   (&gfw);
  gfw.build_form (&gfw, note);
  
  /* Properties related controls */
  
  gtk_notebook_set_page (GTK_NOTEBOOK(note), 0);
  
  gtk_widget_show (note);
  gtk_widget_show (window);
  gtk_widget_show (app);
  
  gtk_main ();
  printf ("\nAll Done!!");
  EDMAEnd ();
  printf ("\nEDMA unloaded\n");
  return 0;
}
