
 /****************************************************************************
 *                       THIS FILE WAS GENERATED                             *
 * Script: common/generate_packets.py                                        *
 * Input:  common/packets.def                                                *
 *                       DO NOT CHANGE THIS FILE                             *
 ****************************************************************************/


#ifdef HAVE_CONFIG_H
#include <fc_config.h>
#endif

#include <string.h>

/* utility */
#include "bitvector.h"
#include "capability.h"
#include "genhash.h"
#include "log.h"
#include "mem.h"
#include "support.h"

/* common */
#include "capstr.h"
#include "connection.h"
#include "dataio.h"
#include "game.h"

#include "packets.h"

static genhash_val_t hash_const(const void *vkey)
{
  return 0;
}

static bool cmp_const(const void *vkey1, const void *vkey2)
{
  return TRUE;
}

void delta_stats_report(void) {}

void delta_stats_reset(void) {}

void *get_packet_from_connection_helper(struct connection *pc,
    enum packet_type type)
{
  switch (type) {

  case PACKET_PROCESSING_STARTED:
    return receive_packet_processing_started(pc);

  case PACKET_PROCESSING_FINISHED:
    return receive_packet_processing_finished(pc);

  case PACKET_SERVER_JOIN_REQ:
    return receive_packet_server_join_req(pc);

  case PACKET_SERVER_JOIN_REPLY:
    return receive_packet_server_join_reply(pc);

  case PACKET_AUTHENTICATION_REQ:
    return receive_packet_authentication_req(pc);

  case PACKET_AUTHENTICATION_REPLY:
    return receive_packet_authentication_reply(pc);

  case PACKET_SERVER_SHUTDOWN:
    return receive_packet_server_shutdown(pc);

  case PACKET_NATION_SELECT_REQ:
    return receive_packet_nation_select_req(pc);

  case PACKET_PLAYER_READY:
    return receive_packet_player_ready(pc);

  case PACKET_ENDGAME_REPORT:
    return receive_packet_endgame_report(pc);

  case PACKET_ENDGAME_PLAYER:
    return receive_packet_endgame_player(pc);

  case PACKET_TILE_INFO:
    return receive_packet_tile_info(pc);

  case PACKET_GAME_INFO:
    return receive_packet_game_info(pc);

  case PACKET_MAP_INFO:
    return receive_packet_map_info(pc);

  case PACKET_NUKE_TILE_INFO:
    return receive_packet_nuke_tile_info(pc);

  case PACKET_TEAM_NAME_INFO:
    return receive_packet_team_name_info(pc);

  case PACKET_CHAT_MSG:
    return receive_packet_chat_msg(pc);

  case PACKET_CHAT_MSG_REQ:
    return receive_packet_chat_msg_req(pc);

  case PACKET_CONNECT_MSG:
    return receive_packet_connect_msg(pc);

  case PACKET_CITY_REMOVE:
    return receive_packet_city_remove(pc);

  case PACKET_CITY_INFO:
    return receive_packet_city_info(pc);

  case PACKET_CITY_SHORT_INFO:
    return receive_packet_city_short_info(pc);

  case PACKET_CITY_SELL:
    return receive_packet_city_sell(pc);

  case PACKET_CITY_BUY:
    return receive_packet_city_buy(pc);

  case PACKET_CITY_CHANGE:
    return receive_packet_city_change(pc);

  case PACKET_CITY_WORKLIST:
    return receive_packet_city_worklist(pc);

  case PACKET_CITY_MAKE_SPECIALIST:
    return receive_packet_city_make_specialist(pc);

  case PACKET_CITY_MAKE_WORKER:
    return receive_packet_city_make_worker(pc);

  case PACKET_CITY_CHANGE_SPECIALIST:
    return receive_packet_city_change_specialist(pc);

  case PACKET_CITY_RENAME:
    return receive_packet_city_rename(pc);

  case PACKET_CITY_OPTIONS_REQ:
    return receive_packet_city_options_req(pc);

  case PACKET_CITY_REFRESH:
    return receive_packet_city_refresh(pc);

  case PACKET_CITY_NAME_SUGGESTION_REQ:
    return receive_packet_city_name_suggestion_req(pc);

  case PACKET_CITY_NAME_SUGGESTION_INFO:
    return receive_packet_city_name_suggestion_info(pc);

  case PACKET_CITY_SABOTAGE_LIST:
    return receive_packet_city_sabotage_list(pc);

  case PACKET_PLAYER_REMOVE:
    return receive_packet_player_remove(pc);

  case PACKET_PLAYER_INFO:
    return receive_packet_player_info(pc);

  case PACKET_PLAYER_PHASE_DONE:
    return receive_packet_player_phase_done(pc);

  case PACKET_PLAYER_RATES:
    return receive_packet_player_rates(pc);

  case PACKET_PLAYER_CHANGE_GOVERNMENT:
    return receive_packet_player_change_government(pc);

  case PACKET_PLAYER_RESEARCH:
    return receive_packet_player_research(pc);

  case PACKET_PLAYER_TECH_GOAL:
    return receive_packet_player_tech_goal(pc);

  case PACKET_TECH_GAINED:
    return receive_packet_tech_gained(pc);

  case PACKET_PLAYER_ATTRIBUTE_BLOCK:
    return receive_packet_player_attribute_block(pc);

  case PACKET_PLAYER_ATTRIBUTE_CHUNK:
    return receive_packet_player_attribute_chunk(pc);

  case PACKET_PLAYER_DIPLSTATE:
    return receive_packet_player_diplstate(pc);

  case PACKET_UNIT_REMOVE:
    return receive_packet_unit_remove(pc);

  case PACKET_UNIT_INFO:
    return receive_packet_unit_info(pc);

  case PACKET_UNIT_SHORT_INFO:
    return receive_packet_unit_short_info(pc);

  case PACKET_UNIT_COMBAT_INFO:
    return receive_packet_unit_combat_info(pc);

  case PACKET_UNIT_MOVE:
    return receive_packet_unit_move(pc);

  case PACKET_UNIT_BUILD_CITY:
    return receive_packet_unit_build_city(pc);

  case PACKET_UNIT_DISBAND:
    return receive_packet_unit_disband(pc);

  case PACKET_UNIT_CHANGE_HOMECITY:
    return receive_packet_unit_change_homecity(pc);

  case PACKET_UNIT_ESTABLISH_TRADE:
    return receive_packet_unit_establish_trade(pc);

  case PACKET_UNIT_BATTLEGROUP:
    return receive_packet_unit_battlegroup(pc);

  case PACKET_UNIT_HELP_BUILD_WONDER:
    return receive_packet_unit_help_build_wonder(pc);

  case PACKET_UNIT_ORDERS:
    return receive_packet_unit_orders(pc);

  case PACKET_UNIT_AUTOSETTLERS:
    return receive_packet_unit_autosettlers(pc);

  case PACKET_UNIT_LOAD:
    return receive_packet_unit_load(pc);

  case PACKET_UNIT_UNLOAD:
    return receive_packet_unit_unload(pc);

  case PACKET_UNIT_UPGRADE:
    return receive_packet_unit_upgrade(pc);

  case PACKET_UNIT_NUKE:
    return receive_packet_unit_nuke(pc);

  case PACKET_UNIT_PARADROP_TO:
    return receive_packet_unit_paradrop_to(pc);

  case PACKET_UNIT_AIRLIFT:
    return receive_packet_unit_airlift(pc);

  case PACKET_UNIT_DIPLOMAT_QUERY:
    return receive_packet_unit_diplomat_query(pc);

  case PACKET_UNIT_TYPE_UPGRADE:
    return receive_packet_unit_type_upgrade(pc);

  case PACKET_UNIT_DIPLOMAT_ACTION:
    return receive_packet_unit_diplomat_action(pc);

  case PACKET_UNIT_DIPLOMAT_ANSWER:
    return receive_packet_unit_diplomat_answer(pc);

  case PACKET_UNIT_CHANGE_ACTIVITY:
    return receive_packet_unit_change_activity(pc);

  case PACKET_UNIT_CHANGE_ACTIVITY_BASE:
    return receive_packet_unit_change_activity_base(pc);

  case PACKET_UNIT_CHANGE_ACTIVITY_ROAD:
    return receive_packet_unit_change_activity_road(pc);

  case PACKET_DIPLOMACY_INIT_MEETING_REQ:
    return receive_packet_diplomacy_init_meeting_req(pc);

  case PACKET_DIPLOMACY_INIT_MEETING:
    return receive_packet_diplomacy_init_meeting(pc);

  case PACKET_DIPLOMACY_CANCEL_MEETING_REQ:
    return receive_packet_diplomacy_cancel_meeting_req(pc);

  case PACKET_DIPLOMACY_CANCEL_MEETING:
    return receive_packet_diplomacy_cancel_meeting(pc);

  case PACKET_DIPLOMACY_CREATE_CLAUSE_REQ:
    return receive_packet_diplomacy_create_clause_req(pc);

  case PACKET_DIPLOMACY_CREATE_CLAUSE:
    return receive_packet_diplomacy_create_clause(pc);

  case PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ:
    return receive_packet_diplomacy_remove_clause_req(pc);

  case PACKET_DIPLOMACY_REMOVE_CLAUSE:
    return receive_packet_diplomacy_remove_clause(pc);

  case PACKET_DIPLOMACY_ACCEPT_TREATY_REQ:
    return receive_packet_diplomacy_accept_treaty_req(pc);

  case PACKET_DIPLOMACY_ACCEPT_TREATY:
    return receive_packet_diplomacy_accept_treaty(pc);

  case PACKET_DIPLOMACY_CANCEL_PACT:
    return receive_packet_diplomacy_cancel_pact(pc);

  case PACKET_PAGE_MSG_OLD:
    return receive_packet_page_msg_old(pc);

  case PACKET_PAGE_MSG_NEW:
    return receive_packet_page_msg_new(pc);

  case PACKET_PAGE_MSG_PART:
    return receive_packet_page_msg_part(pc);

  case PACKET_REPORT_REQ:
    return receive_packet_report_req(pc);

  case PACKET_CONN_INFO:
    return receive_packet_conn_info(pc);

  case PACKET_CONN_PING_INFO:
    return receive_packet_conn_ping_info(pc);

  case PACKET_CONN_PING:
    return receive_packet_conn_ping(pc);

  case PACKET_CONN_PONG:
    return receive_packet_conn_pong(pc);

  case PACKET_CLIENT_INFO:
    return receive_packet_client_info(pc);

  case PACKET_END_PHASE:
    return receive_packet_end_phase(pc);

  case PACKET_START_PHASE:
    return receive_packet_start_phase(pc);

  case PACKET_NEW_YEAR:
    return receive_packet_new_year(pc);

  case PACKET_BEGIN_TURN:
    return receive_packet_begin_turn(pc);

  case PACKET_END_TURN:
    return receive_packet_end_turn(pc);

  case PACKET_FREEZE_CLIENT:
    return receive_packet_freeze_client(pc);

  case PACKET_THAW_CLIENT:
    return receive_packet_thaw_client(pc);

  case PACKET_SPACESHIP_LAUNCH:
    return receive_packet_spaceship_launch(pc);

  case PACKET_SPACESHIP_PLACE:
    return receive_packet_spaceship_place(pc);

  case PACKET_SPACESHIP_INFO:
    return receive_packet_spaceship_info(pc);

  case PACKET_RULESET_UNIT:
    return receive_packet_ruleset_unit(pc);

  case PACKET_RULESET_UNIT_BONUS:
    return receive_packet_ruleset_unit_bonus(pc);

  case PACKET_RULESET_UNIT_FLAG:
    return receive_packet_ruleset_unit_flag(pc);

  case PACKET_RULESET_GAME:
    return receive_packet_ruleset_game(pc);

  case PACKET_RULESET_SPECIALIST:
    return receive_packet_ruleset_specialist(pc);

  case PACKET_RULESET_GOVERNMENT_RULER_TITLE:
    return receive_packet_ruleset_government_ruler_title(pc);

  case PACKET_RULESET_TECH:
    return receive_packet_ruleset_tech(pc);

  case PACKET_RULESET_TECH_FLAG:
    return receive_packet_ruleset_tech_flag(pc);

  case PACKET_RULESET_GOVERNMENT:
    return receive_packet_ruleset_government(pc);

  case PACKET_RULESET_TERRAIN_CONTROL:
    return receive_packet_ruleset_terrain_control(pc);

  case PACKET_RULESETS_READY:
    return receive_packet_rulesets_ready(pc);

  case PACKET_RULESET_NATION_SETS:
    return receive_packet_ruleset_nation_sets(pc);

  case PACKET_RULESET_NATION_GROUPS:
    return receive_packet_ruleset_nation_groups(pc);

  case PACKET_RULESET_NATION:
    return receive_packet_ruleset_nation(pc);

  case PACKET_NATION_AVAILABILITY:
    return receive_packet_nation_availability(pc);

  case PACKET_RULESET_CITY:
    return receive_packet_ruleset_city(pc);

  case PACKET_RULESET_BUILDING:
    return receive_packet_ruleset_building(pc);

  case PACKET_RULESET_TERRAIN:
    return receive_packet_ruleset_terrain(pc);

  case PACKET_RULESET_TERRAIN_FLAG:
    return receive_packet_ruleset_terrain_flag(pc);

  case PACKET_RULESET_UNIT_CLASS:
    return receive_packet_ruleset_unit_class(pc);

  case PACKET_RULESET_BASE:
    return receive_packet_ruleset_base(pc);

  case PACKET_RULESET_ROAD:
    return receive_packet_ruleset_road(pc);

  case PACKET_RULESET_DISASTER:
    return receive_packet_ruleset_disaster(pc);

  case PACKET_RULESET_TRADE:
    return receive_packet_ruleset_trade(pc);

  case PACKET_RULESET_CONTROL:
    return receive_packet_ruleset_control(pc);

  case PACKET_SINGLE_WANT_HACK_REQ:
    return receive_packet_single_want_hack_req(pc);

  case PACKET_SINGLE_WANT_HACK_REPLY:
    return receive_packet_single_want_hack_reply(pc);

  case PACKET_RULESET_CHOICES:
    return receive_packet_ruleset_choices(pc);

  case PACKET_GAME_LOAD:
    return receive_packet_game_load(pc);

  case PACKET_SERVER_SETTING_CONTROL:
    return receive_packet_server_setting_control(pc);

  case PACKET_SERVER_SETTING_CONST:
    return receive_packet_server_setting_const(pc);

  case PACKET_SERVER_SETTING_BOOL:
    return receive_packet_server_setting_bool(pc);

  case PACKET_SERVER_SETTING_INT:
    return receive_packet_server_setting_int(pc);

  case PACKET_SERVER_SETTING_STR:
    return receive_packet_server_setting_str(pc);

  case PACKET_SERVER_SETTING_ENUM:
    return receive_packet_server_setting_enum(pc);

  case PACKET_SERVER_SETTING_BITWISE:
    return receive_packet_server_setting_bitwise(pc);

  case PACKET_RULESET_EFFECT:
    return receive_packet_ruleset_effect(pc);

  case PACKET_RULESET_EFFECT_REQ:
    return receive_packet_ruleset_effect_req(pc);

  case PACKET_RULESET_RESOURCE:
    return receive_packet_ruleset_resource(pc);

  case PACKET_SCENARIO_INFO:
    return receive_packet_scenario_info(pc);

  case PACKET_SAVE_SCENARIO:
    return receive_packet_save_scenario(pc);

  case PACKET_VOTE_NEW:
    return receive_packet_vote_new(pc);

  case PACKET_VOTE_UPDATE:
    return receive_packet_vote_update(pc);

  case PACKET_VOTE_REMOVE:
    return receive_packet_vote_remove(pc);

  case PACKET_VOTE_RESOLVE:
    return receive_packet_vote_resolve(pc);

  case PACKET_VOTE_SUBMIT:
    return receive_packet_vote_submit(pc);

  case PACKET_EDIT_MODE:
    return receive_packet_edit_mode(pc);

  case PACKET_EDIT_RECALCULATE_BORDERS:
    return receive_packet_edit_recalculate_borders(pc);

  case PACKET_EDIT_CHECK_TILES:
    return receive_packet_edit_check_tiles(pc);

  case PACKET_EDIT_TOGGLE_FOGOFWAR:
    return receive_packet_edit_toggle_fogofwar(pc);

  case PACKET_EDIT_TILE_TERRAIN:
    return receive_packet_edit_tile_terrain(pc);

  case PACKET_EDIT_TILE_RESOURCE:
    return receive_packet_edit_tile_resource(pc);

  case PACKET_EDIT_TILE_SPECIAL:
    return receive_packet_edit_tile_special(pc);

  case PACKET_EDIT_TILE_BASE:
    return receive_packet_edit_tile_base(pc);

  case PACKET_EDIT_TILE_ROAD:
    return receive_packet_edit_tile_road(pc);

  case PACKET_EDIT_STARTPOS:
    return receive_packet_edit_startpos(pc);

  case PACKET_EDIT_STARTPOS_FULL:
    return receive_packet_edit_startpos_full(pc);

  case PACKET_EDIT_TILE:
    return receive_packet_edit_tile(pc);

  case PACKET_EDIT_UNIT_CREATE:
    return receive_packet_edit_unit_create(pc);

  case PACKET_EDIT_UNIT_REMOVE:
    return receive_packet_edit_unit_remove(pc);

  case PACKET_EDIT_UNIT_REMOVE_BY_ID:
    return receive_packet_edit_unit_remove_by_id(pc);

  case PACKET_EDIT_UNIT:
    return receive_packet_edit_unit(pc);

  case PACKET_EDIT_CITY_CREATE:
    return receive_packet_edit_city_create(pc);

  case PACKET_EDIT_CITY_REMOVE:
    return receive_packet_edit_city_remove(pc);

  case PACKET_EDIT_CITY:
    return receive_packet_edit_city(pc);

  case PACKET_EDIT_PLAYER_CREATE:
    return receive_packet_edit_player_create(pc);

  case PACKET_EDIT_PLAYER_REMOVE:
    return receive_packet_edit_player_remove(pc);

  case PACKET_EDIT_PLAYER:
    return receive_packet_edit_player(pc);

  case PACKET_EDIT_PLAYER_VISION:
    return receive_packet_edit_player_vision(pc);

  case PACKET_EDIT_GAME:
    return receive_packet_edit_game(pc);

  case PACKET_EDIT_OBJECT_CREATED:
    return receive_packet_edit_object_created(pc);

  default:
    log_packet("unknown packet type %d received from %s",
               type, conn_description(pc));
    return NULL;
  };
}

const char *packet_name(enum packet_type type)
{
  switch (type) {

  case PACKET_PROCESSING_STARTED:
    return "PACKET_PROCESSING_STARTED";

  case PACKET_PROCESSING_FINISHED:
    return "PACKET_PROCESSING_FINISHED";

  case PACKET_SERVER_JOIN_REQ:
    return "PACKET_SERVER_JOIN_REQ";

  case PACKET_SERVER_JOIN_REPLY:
    return "PACKET_SERVER_JOIN_REPLY";

  case PACKET_AUTHENTICATION_REQ:
    return "PACKET_AUTHENTICATION_REQ";

  case PACKET_AUTHENTICATION_REPLY:
    return "PACKET_AUTHENTICATION_REPLY";

  case PACKET_SERVER_SHUTDOWN:
    return "PACKET_SERVER_SHUTDOWN";

  case PACKET_NATION_SELECT_REQ:
    return "PACKET_NATION_SELECT_REQ";

  case PACKET_PLAYER_READY:
    return "PACKET_PLAYER_READY";

  case PACKET_ENDGAME_REPORT:
    return "PACKET_ENDGAME_REPORT";

  case PACKET_ENDGAME_PLAYER:
    return "PACKET_ENDGAME_PLAYER";

  case PACKET_TILE_INFO:
    return "PACKET_TILE_INFO";

  case PACKET_GAME_INFO:
    return "PACKET_GAME_INFO";

  case PACKET_MAP_INFO:
    return "PACKET_MAP_INFO";

  case PACKET_NUKE_TILE_INFO:
    return "PACKET_NUKE_TILE_INFO";

  case PACKET_TEAM_NAME_INFO:
    return "PACKET_TEAM_NAME_INFO";

  case PACKET_CHAT_MSG:
    return "PACKET_CHAT_MSG";

  case PACKET_CHAT_MSG_REQ:
    return "PACKET_CHAT_MSG_REQ";

  case PACKET_CONNECT_MSG:
    return "PACKET_CONNECT_MSG";

  case PACKET_CITY_REMOVE:
    return "PACKET_CITY_REMOVE";

  case PACKET_CITY_INFO:
    return "PACKET_CITY_INFO";

  case PACKET_CITY_SHORT_INFO:
    return "PACKET_CITY_SHORT_INFO";

  case PACKET_CITY_SELL:
    return "PACKET_CITY_SELL";

  case PACKET_CITY_BUY:
    return "PACKET_CITY_BUY";

  case PACKET_CITY_CHANGE:
    return "PACKET_CITY_CHANGE";

  case PACKET_CITY_WORKLIST:
    return "PACKET_CITY_WORKLIST";

  case PACKET_CITY_MAKE_SPECIALIST:
    return "PACKET_CITY_MAKE_SPECIALIST";

  case PACKET_CITY_MAKE_WORKER:
    return "PACKET_CITY_MAKE_WORKER";

  case PACKET_CITY_CHANGE_SPECIALIST:
    return "PACKET_CITY_CHANGE_SPECIALIST";

  case PACKET_CITY_RENAME:
    return "PACKET_CITY_RENAME";

  case PACKET_CITY_OPTIONS_REQ:
    return "PACKET_CITY_OPTIONS_REQ";

  case PACKET_CITY_REFRESH:
    return "PACKET_CITY_REFRESH";

  case PACKET_CITY_NAME_SUGGESTION_REQ:
    return "PACKET_CITY_NAME_SUGGESTION_REQ";

  case PACKET_CITY_NAME_SUGGESTION_INFO:
    return "PACKET_CITY_NAME_SUGGESTION_INFO";

  case PACKET_CITY_SABOTAGE_LIST:
    return "PACKET_CITY_SABOTAGE_LIST";

  case PACKET_PLAYER_REMOVE:
    return "PACKET_PLAYER_REMOVE";

  case PACKET_PLAYER_INFO:
    return "PACKET_PLAYER_INFO";

  case PACKET_PLAYER_PHASE_DONE:
    return "PACKET_PLAYER_PHASE_DONE";

  case PACKET_PLAYER_RATES:
    return "PACKET_PLAYER_RATES";

  case PACKET_PLAYER_CHANGE_GOVERNMENT:
    return "PACKET_PLAYER_CHANGE_GOVERNMENT";

  case PACKET_PLAYER_RESEARCH:
    return "PACKET_PLAYER_RESEARCH";

  case PACKET_PLAYER_TECH_GOAL:
    return "PACKET_PLAYER_TECH_GOAL";

  case PACKET_TECH_GAINED:
    return "PACKET_TECH_GAINED";

  case PACKET_PLAYER_ATTRIBUTE_BLOCK:
    return "PACKET_PLAYER_ATTRIBUTE_BLOCK";

  case PACKET_PLAYER_ATTRIBUTE_CHUNK:
    return "PACKET_PLAYER_ATTRIBUTE_CHUNK";

  case PACKET_PLAYER_DIPLSTATE:
    return "PACKET_PLAYER_DIPLSTATE";

  case PACKET_UNIT_REMOVE:
    return "PACKET_UNIT_REMOVE";

  case PACKET_UNIT_INFO:
    return "PACKET_UNIT_INFO";

  case PACKET_UNIT_SHORT_INFO:
    return "PACKET_UNIT_SHORT_INFO";

  case PACKET_UNIT_COMBAT_INFO:
    return "PACKET_UNIT_COMBAT_INFO";

  case PACKET_UNIT_MOVE:
    return "PACKET_UNIT_MOVE";

  case PACKET_UNIT_BUILD_CITY:
    return "PACKET_UNIT_BUILD_CITY";

  case PACKET_UNIT_DISBAND:
    return "PACKET_UNIT_DISBAND";

  case PACKET_UNIT_CHANGE_HOMECITY:
    return "PACKET_UNIT_CHANGE_HOMECITY";

  case PACKET_UNIT_ESTABLISH_TRADE:
    return "PACKET_UNIT_ESTABLISH_TRADE";

  case PACKET_UNIT_BATTLEGROUP:
    return "PACKET_UNIT_BATTLEGROUP";

  case PACKET_UNIT_HELP_BUILD_WONDER:
    return "PACKET_UNIT_HELP_BUILD_WONDER";

  case PACKET_UNIT_ORDERS:
    return "PACKET_UNIT_ORDERS";

  case PACKET_UNIT_AUTOSETTLERS:
    return "PACKET_UNIT_AUTOSETTLERS";

  case PACKET_UNIT_LOAD:
    return "PACKET_UNIT_LOAD";

  case PACKET_UNIT_UNLOAD:
    return "PACKET_UNIT_UNLOAD";

  case PACKET_UNIT_UPGRADE:
    return "PACKET_UNIT_UPGRADE";

  case PACKET_UNIT_NUKE:
    return "PACKET_UNIT_NUKE";

  case PACKET_UNIT_PARADROP_TO:
    return "PACKET_UNIT_PARADROP_TO";

  case PACKET_UNIT_AIRLIFT:
    return "PACKET_UNIT_AIRLIFT";

  case PACKET_UNIT_DIPLOMAT_QUERY:
    return "PACKET_UNIT_DIPLOMAT_QUERY";

  case PACKET_UNIT_TYPE_UPGRADE:
    return "PACKET_UNIT_TYPE_UPGRADE";

  case PACKET_UNIT_DIPLOMAT_ACTION:
    return "PACKET_UNIT_DIPLOMAT_ACTION";

  case PACKET_UNIT_DIPLOMAT_ANSWER:
    return "PACKET_UNIT_DIPLOMAT_ANSWER";

  case PACKET_UNIT_CHANGE_ACTIVITY:
    return "PACKET_UNIT_CHANGE_ACTIVITY";

  case PACKET_UNIT_CHANGE_ACTIVITY_BASE:
    return "PACKET_UNIT_CHANGE_ACTIVITY_BASE";

  case PACKET_UNIT_CHANGE_ACTIVITY_ROAD:
    return "PACKET_UNIT_CHANGE_ACTIVITY_ROAD";

  case PACKET_DIPLOMACY_INIT_MEETING_REQ:
    return "PACKET_DIPLOMACY_INIT_MEETING_REQ";

  case PACKET_DIPLOMACY_INIT_MEETING:
    return "PACKET_DIPLOMACY_INIT_MEETING";

  case PACKET_DIPLOMACY_CANCEL_MEETING_REQ:
    return "PACKET_DIPLOMACY_CANCEL_MEETING_REQ";

  case PACKET_DIPLOMACY_CANCEL_MEETING:
    return "PACKET_DIPLOMACY_CANCEL_MEETING";

  case PACKET_DIPLOMACY_CREATE_CLAUSE_REQ:
    return "PACKET_DIPLOMACY_CREATE_CLAUSE_REQ";

  case PACKET_DIPLOMACY_CREATE_CLAUSE:
    return "PACKET_DIPLOMACY_CREATE_CLAUSE";

  case PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ:
    return "PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ";

  case PACKET_DIPLOMACY_REMOVE_CLAUSE:
    return "PACKET_DIPLOMACY_REMOVE_CLAUSE";

  case PACKET_DIPLOMACY_ACCEPT_TREATY_REQ:
    return "PACKET_DIPLOMACY_ACCEPT_TREATY_REQ";

  case PACKET_DIPLOMACY_ACCEPT_TREATY:
    return "PACKET_DIPLOMACY_ACCEPT_TREATY";

  case PACKET_DIPLOMACY_CANCEL_PACT:
    return "PACKET_DIPLOMACY_CANCEL_PACT";

  case PACKET_PAGE_MSG_OLD:
    return "PACKET_PAGE_MSG_OLD";

  case PACKET_PAGE_MSG_NEW:
    return "PACKET_PAGE_MSG_NEW";

  case PACKET_PAGE_MSG_PART:
    return "PACKET_PAGE_MSG_PART";

  case PACKET_REPORT_REQ:
    return "PACKET_REPORT_REQ";

  case PACKET_CONN_INFO:
    return "PACKET_CONN_INFO";

  case PACKET_CONN_PING_INFO:
    return "PACKET_CONN_PING_INFO";

  case PACKET_CONN_PING:
    return "PACKET_CONN_PING";

  case PACKET_CONN_PONG:
    return "PACKET_CONN_PONG";

  case PACKET_CLIENT_INFO:
    return "PACKET_CLIENT_INFO";

  case PACKET_END_PHASE:
    return "PACKET_END_PHASE";

  case PACKET_START_PHASE:
    return "PACKET_START_PHASE";

  case PACKET_NEW_YEAR:
    return "PACKET_NEW_YEAR";

  case PACKET_BEGIN_TURN:
    return "PACKET_BEGIN_TURN";

  case PACKET_END_TURN:
    return "PACKET_END_TURN";

  case PACKET_FREEZE_CLIENT:
    return "PACKET_FREEZE_CLIENT";

  case PACKET_THAW_CLIENT:
    return "PACKET_THAW_CLIENT";

  case PACKET_SPACESHIP_LAUNCH:
    return "PACKET_SPACESHIP_LAUNCH";

  case PACKET_SPACESHIP_PLACE:
    return "PACKET_SPACESHIP_PLACE";

  case PACKET_SPACESHIP_INFO:
    return "PACKET_SPACESHIP_INFO";

  case PACKET_RULESET_UNIT:
    return "PACKET_RULESET_UNIT";

  case PACKET_RULESET_UNIT_BONUS:
    return "PACKET_RULESET_UNIT_BONUS";

  case PACKET_RULESET_UNIT_FLAG:
    return "PACKET_RULESET_UNIT_FLAG";

  case PACKET_RULESET_GAME:
    return "PACKET_RULESET_GAME";

  case PACKET_RULESET_SPECIALIST:
    return "PACKET_RULESET_SPECIALIST";

  case PACKET_RULESET_GOVERNMENT_RULER_TITLE:
    return "PACKET_RULESET_GOVERNMENT_RULER_TITLE";

  case PACKET_RULESET_TECH:
    return "PACKET_RULESET_TECH";

  case PACKET_RULESET_TECH_FLAG:
    return "PACKET_RULESET_TECH_FLAG";

  case PACKET_RULESET_GOVERNMENT:
    return "PACKET_RULESET_GOVERNMENT";

  case PACKET_RULESET_TERRAIN_CONTROL:
    return "PACKET_RULESET_TERRAIN_CONTROL";

  case PACKET_RULESETS_READY:
    return "PACKET_RULESETS_READY";

  case PACKET_RULESET_NATION_SETS:
    return "PACKET_RULESET_NATION_SETS";

  case PACKET_RULESET_NATION_GROUPS:
    return "PACKET_RULESET_NATION_GROUPS";

  case PACKET_RULESET_NATION:
    return "PACKET_RULESET_NATION";

  case PACKET_NATION_AVAILABILITY:
    return "PACKET_NATION_AVAILABILITY";

  case PACKET_RULESET_CITY:
    return "PACKET_RULESET_CITY";

  case PACKET_RULESET_BUILDING:
    return "PACKET_RULESET_BUILDING";

  case PACKET_RULESET_TERRAIN:
    return "PACKET_RULESET_TERRAIN";

  case PACKET_RULESET_TERRAIN_FLAG:
    return "PACKET_RULESET_TERRAIN_FLAG";

  case PACKET_RULESET_UNIT_CLASS:
    return "PACKET_RULESET_UNIT_CLASS";

  case PACKET_RULESET_BASE:
    return "PACKET_RULESET_BASE";

  case PACKET_RULESET_ROAD:
    return "PACKET_RULESET_ROAD";

  case PACKET_RULESET_DISASTER:
    return "PACKET_RULESET_DISASTER";

  case PACKET_RULESET_TRADE:
    return "PACKET_RULESET_TRADE";

  case PACKET_RULESET_CONTROL:
    return "PACKET_RULESET_CONTROL";

  case PACKET_SINGLE_WANT_HACK_REQ:
    return "PACKET_SINGLE_WANT_HACK_REQ";

  case PACKET_SINGLE_WANT_HACK_REPLY:
    return "PACKET_SINGLE_WANT_HACK_REPLY";

  case PACKET_RULESET_CHOICES:
    return "PACKET_RULESET_CHOICES";

  case PACKET_GAME_LOAD:
    return "PACKET_GAME_LOAD";

  case PACKET_SERVER_SETTING_CONTROL:
    return "PACKET_SERVER_SETTING_CONTROL";

  case PACKET_SERVER_SETTING_CONST:
    return "PACKET_SERVER_SETTING_CONST";

  case PACKET_SERVER_SETTING_BOOL:
    return "PACKET_SERVER_SETTING_BOOL";

  case PACKET_SERVER_SETTING_INT:
    return "PACKET_SERVER_SETTING_INT";

  case PACKET_SERVER_SETTING_STR:
    return "PACKET_SERVER_SETTING_STR";

  case PACKET_SERVER_SETTING_ENUM:
    return "PACKET_SERVER_SETTING_ENUM";

  case PACKET_SERVER_SETTING_BITWISE:
    return "PACKET_SERVER_SETTING_BITWISE";

  case PACKET_RULESET_EFFECT:
    return "PACKET_RULESET_EFFECT";

  case PACKET_RULESET_EFFECT_REQ:
    return "PACKET_RULESET_EFFECT_REQ";

  case PACKET_RULESET_RESOURCE:
    return "PACKET_RULESET_RESOURCE";

  case PACKET_SCENARIO_INFO:
    return "PACKET_SCENARIO_INFO";

  case PACKET_SAVE_SCENARIO:
    return "PACKET_SAVE_SCENARIO";

  case PACKET_VOTE_NEW:
    return "PACKET_VOTE_NEW";

  case PACKET_VOTE_UPDATE:
    return "PACKET_VOTE_UPDATE";

  case PACKET_VOTE_REMOVE:
    return "PACKET_VOTE_REMOVE";

  case PACKET_VOTE_RESOLVE:
    return "PACKET_VOTE_RESOLVE";

  case PACKET_VOTE_SUBMIT:
    return "PACKET_VOTE_SUBMIT";

  case PACKET_EDIT_MODE:
    return "PACKET_EDIT_MODE";

  case PACKET_EDIT_RECALCULATE_BORDERS:
    return "PACKET_EDIT_RECALCULATE_BORDERS";

  case PACKET_EDIT_CHECK_TILES:
    return "PACKET_EDIT_CHECK_TILES";

  case PACKET_EDIT_TOGGLE_FOGOFWAR:
    return "PACKET_EDIT_TOGGLE_FOGOFWAR";

  case PACKET_EDIT_TILE_TERRAIN:
    return "PACKET_EDIT_TILE_TERRAIN";

  case PACKET_EDIT_TILE_RESOURCE:
    return "PACKET_EDIT_TILE_RESOURCE";

  case PACKET_EDIT_TILE_SPECIAL:
    return "PACKET_EDIT_TILE_SPECIAL";

  case PACKET_EDIT_TILE_BASE:
    return "PACKET_EDIT_TILE_BASE";

  case PACKET_EDIT_TILE_ROAD:
    return "PACKET_EDIT_TILE_ROAD";

  case PACKET_EDIT_STARTPOS:
    return "PACKET_EDIT_STARTPOS";

  case PACKET_EDIT_STARTPOS_FULL:
    return "PACKET_EDIT_STARTPOS_FULL";

  case PACKET_EDIT_TILE:
    return "PACKET_EDIT_TILE";

  case PACKET_EDIT_UNIT_CREATE:
    return "PACKET_EDIT_UNIT_CREATE";

  case PACKET_EDIT_UNIT_REMOVE:
    return "PACKET_EDIT_UNIT_REMOVE";

  case PACKET_EDIT_UNIT_REMOVE_BY_ID:
    return "PACKET_EDIT_UNIT_REMOVE_BY_ID";

  case PACKET_EDIT_UNIT:
    return "PACKET_EDIT_UNIT";

  case PACKET_EDIT_CITY_CREATE:
    return "PACKET_EDIT_CITY_CREATE";

  case PACKET_EDIT_CITY_REMOVE:
    return "PACKET_EDIT_CITY_REMOVE";

  case PACKET_EDIT_CITY:
    return "PACKET_EDIT_CITY";

  case PACKET_EDIT_PLAYER_CREATE:
    return "PACKET_EDIT_PLAYER_CREATE";

  case PACKET_EDIT_PLAYER_REMOVE:
    return "PACKET_EDIT_PLAYER_REMOVE";

  case PACKET_EDIT_PLAYER:
    return "PACKET_EDIT_PLAYER";

  case PACKET_EDIT_PLAYER_VISION:
    return "PACKET_EDIT_PLAYER_VISION";

  case PACKET_EDIT_GAME:
    return "PACKET_EDIT_GAME";

  case PACKET_EDIT_OBJECT_CREATED:
    return "PACKET_EDIT_OBJECT_CREATED";

  default:
    return "unknown";
  }
}

bool packet_has_game_info_flag(enum packet_type type)
{
  switch (type) {

  case PACKET_PROCESSING_STARTED:
    return FALSE;

  case PACKET_PROCESSING_FINISHED:
    return FALSE;

  case PACKET_SERVER_JOIN_REQ:
    return FALSE;

  case PACKET_SERVER_JOIN_REPLY:
    return FALSE;

  case PACKET_AUTHENTICATION_REQ:
    return FALSE;

  case PACKET_AUTHENTICATION_REPLY:
    return FALSE;

  case PACKET_SERVER_SHUTDOWN:
    return FALSE;

  case PACKET_NATION_SELECT_REQ:
    return FALSE;

  case PACKET_PLAYER_READY:
    return FALSE;

  case PACKET_ENDGAME_REPORT:
    return FALSE;

  case PACKET_ENDGAME_PLAYER:
    return FALSE;

  case PACKET_TILE_INFO:
    return TRUE;

  case PACKET_GAME_INFO:
    return FALSE;

  case PACKET_MAP_INFO:
    return FALSE;

  case PACKET_NUKE_TILE_INFO:
    return FALSE;

  case PACKET_TEAM_NAME_INFO:
    return FALSE;

  case PACKET_CHAT_MSG:
    return FALSE;

  case PACKET_CHAT_MSG_REQ:
    return FALSE;

  case PACKET_CONNECT_MSG:
    return FALSE;

  case PACKET_CITY_REMOVE:
    return FALSE;

  case PACKET_CITY_INFO:
    return TRUE;

  case PACKET_CITY_SHORT_INFO:
    return TRUE;

  case PACKET_CITY_SELL:
    return FALSE;

  case PACKET_CITY_BUY:
    return FALSE;

  case PACKET_CITY_CHANGE:
    return FALSE;

  case PACKET_CITY_WORKLIST:
    return FALSE;

  case PACKET_CITY_MAKE_SPECIALIST:
    return FALSE;

  case PACKET_CITY_MAKE_WORKER:
    return FALSE;

  case PACKET_CITY_CHANGE_SPECIALIST:
    return FALSE;

  case PACKET_CITY_RENAME:
    return FALSE;

  case PACKET_CITY_OPTIONS_REQ:
    return FALSE;

  case PACKET_CITY_REFRESH:
    return FALSE;

  case PACKET_CITY_NAME_SUGGESTION_REQ:
    return FALSE;

  case PACKET_CITY_NAME_SUGGESTION_INFO:
    return FALSE;

  case PACKET_CITY_SABOTAGE_LIST:
    return FALSE;

  case PACKET_PLAYER_REMOVE:
    return FALSE;

  case PACKET_PLAYER_INFO:
    return FALSE;

  case PACKET_PLAYER_PHASE_DONE:
    return FALSE;

  case PACKET_PLAYER_RATES:
    return FALSE;

  case PACKET_PLAYER_CHANGE_GOVERNMENT:
    return FALSE;

  case PACKET_PLAYER_RESEARCH:
    return FALSE;

  case PACKET_PLAYER_TECH_GOAL:
    return FALSE;

  case PACKET_TECH_GAINED:
    return FALSE;

  case PACKET_PLAYER_ATTRIBUTE_BLOCK:
    return FALSE;

  case PACKET_PLAYER_ATTRIBUTE_CHUNK:
    return FALSE;

  case PACKET_PLAYER_DIPLSTATE:
    return FALSE;

  case PACKET_UNIT_REMOVE:
    return FALSE;

  case PACKET_UNIT_INFO:
    return TRUE;

  case PACKET_UNIT_SHORT_INFO:
    return TRUE;

  case PACKET_UNIT_COMBAT_INFO:
    return FALSE;

  case PACKET_UNIT_MOVE:
    return FALSE;

  case PACKET_UNIT_BUILD_CITY:
    return FALSE;

  case PACKET_UNIT_DISBAND:
    return FALSE;

  case PACKET_UNIT_CHANGE_HOMECITY:
    return FALSE;

  case PACKET_UNIT_ESTABLISH_TRADE:
    return FALSE;

  case PACKET_UNIT_BATTLEGROUP:
    return FALSE;

  case PACKET_UNIT_HELP_BUILD_WONDER:
    return FALSE;

  case PACKET_UNIT_ORDERS:
    return FALSE;

  case PACKET_UNIT_AUTOSETTLERS:
    return FALSE;

  case PACKET_UNIT_LOAD:
    return FALSE;

  case PACKET_UNIT_UNLOAD:
    return FALSE;

  case PACKET_UNIT_UPGRADE:
    return FALSE;

  case PACKET_UNIT_NUKE:
    return FALSE;

  case PACKET_UNIT_PARADROP_TO:
    return FALSE;

  case PACKET_UNIT_AIRLIFT:
    return FALSE;

  case PACKET_UNIT_DIPLOMAT_QUERY:
    return FALSE;

  case PACKET_UNIT_TYPE_UPGRADE:
    return FALSE;

  case PACKET_UNIT_DIPLOMAT_ACTION:
    return FALSE;

  case PACKET_UNIT_DIPLOMAT_ANSWER:
    return FALSE;

  case PACKET_UNIT_CHANGE_ACTIVITY:
    return FALSE;

  case PACKET_UNIT_CHANGE_ACTIVITY_BASE:
    return FALSE;

  case PACKET_UNIT_CHANGE_ACTIVITY_ROAD:
    return FALSE;

  case PACKET_DIPLOMACY_INIT_MEETING_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_INIT_MEETING:
    return FALSE;

  case PACKET_DIPLOMACY_CANCEL_MEETING_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_CANCEL_MEETING:
    return FALSE;

  case PACKET_DIPLOMACY_CREATE_CLAUSE_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_CREATE_CLAUSE:
    return FALSE;

  case PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_REMOVE_CLAUSE:
    return FALSE;

  case PACKET_DIPLOMACY_ACCEPT_TREATY_REQ:
    return FALSE;

  case PACKET_DIPLOMACY_ACCEPT_TREATY:
    return FALSE;

  case PACKET_DIPLOMACY_CANCEL_PACT:
    return FALSE;

  case PACKET_PAGE_MSG_OLD:
    return FALSE;

  case PACKET_PAGE_MSG_NEW:
    return FALSE;

  case PACKET_PAGE_MSG_PART:
    return FALSE;

  case PACKET_REPORT_REQ:
    return FALSE;

  case PACKET_CONN_INFO:
    return FALSE;

  case PACKET_CONN_PING_INFO:
    return FALSE;

  case PACKET_CONN_PING:
    return FALSE;

  case PACKET_CONN_PONG:
    return FALSE;

  case PACKET_CLIENT_INFO:
    return FALSE;

  case PACKET_END_PHASE:
    return FALSE;

  case PACKET_START_PHASE:
    return FALSE;

  case PACKET_NEW_YEAR:
    return FALSE;

  case PACKET_BEGIN_TURN:
    return FALSE;

  case PACKET_END_TURN:
    return FALSE;

  case PACKET_FREEZE_CLIENT:
    return FALSE;

  case PACKET_THAW_CLIENT:
    return FALSE;

  case PACKET_SPACESHIP_LAUNCH:
    return FALSE;

  case PACKET_SPACESHIP_PLACE:
    return FALSE;

  case PACKET_SPACESHIP_INFO:
    return FALSE;

  case PACKET_RULESET_UNIT:
    return FALSE;

  case PACKET_RULESET_UNIT_BONUS:
    return FALSE;

  case PACKET_RULESET_UNIT_FLAG:
    return FALSE;

  case PACKET_RULESET_GAME:
    return FALSE;

  case PACKET_RULESET_SPECIALIST:
    return FALSE;

  case PACKET_RULESET_GOVERNMENT_RULER_TITLE:
    return FALSE;

  case PACKET_RULESET_TECH:
    return FALSE;

  case PACKET_RULESET_TECH_FLAG:
    return FALSE;

  case PACKET_RULESET_GOVERNMENT:
    return FALSE;

  case PACKET_RULESET_TERRAIN_CONTROL:
    return FALSE;

  case PACKET_RULESETS_READY:
    return FALSE;

  case PACKET_RULESET_NATION_SETS:
    return FALSE;

  case PACKET_RULESET_NATION_GROUPS:
    return FALSE;

  case PACKET_RULESET_NATION:
    return FALSE;

  case PACKET_NATION_AVAILABILITY:
    return FALSE;

  case PACKET_RULESET_CITY:
    return FALSE;

  case PACKET_RULESET_BUILDING:
    return FALSE;

  case PACKET_RULESET_TERRAIN:
    return FALSE;

  case PACKET_RULESET_TERRAIN_FLAG:
    return FALSE;

  case PACKET_RULESET_UNIT_CLASS:
    return FALSE;

  case PACKET_RULESET_BASE:
    return FALSE;

  case PACKET_RULESET_ROAD:
    return FALSE;

  case PACKET_RULESET_DISASTER:
    return FALSE;

  case PACKET_RULESET_TRADE:
    return FALSE;

  case PACKET_RULESET_CONTROL:
    return FALSE;

  case PACKET_SINGLE_WANT_HACK_REQ:
    return FALSE;

  case PACKET_SINGLE_WANT_HACK_REPLY:
    return FALSE;

  case PACKET_RULESET_CHOICES:
    return FALSE;

  case PACKET_GAME_LOAD:
    return FALSE;

  case PACKET_SERVER_SETTING_CONTROL:
    return FALSE;

  case PACKET_SERVER_SETTING_CONST:
    return FALSE;

  case PACKET_SERVER_SETTING_BOOL:
    return FALSE;

  case PACKET_SERVER_SETTING_INT:
    return FALSE;

  case PACKET_SERVER_SETTING_STR:
    return FALSE;

  case PACKET_SERVER_SETTING_ENUM:
    return FALSE;

  case PACKET_SERVER_SETTING_BITWISE:
    return FALSE;

  case PACKET_RULESET_EFFECT:
    return FALSE;

  case PACKET_RULESET_EFFECT_REQ:
    return FALSE;

  case PACKET_RULESET_RESOURCE:
    return FALSE;

  case PACKET_SCENARIO_INFO:
    return FALSE;

  case PACKET_SAVE_SCENARIO:
    return FALSE;

  case PACKET_VOTE_NEW:
    return FALSE;

  case PACKET_VOTE_UPDATE:
    return FALSE;

  case PACKET_VOTE_REMOVE:
    return FALSE;

  case PACKET_VOTE_RESOLVE:
    return FALSE;

  case PACKET_VOTE_SUBMIT:
    return FALSE;

  case PACKET_EDIT_MODE:
    return FALSE;

  case PACKET_EDIT_RECALCULATE_BORDERS:
    return FALSE;

  case PACKET_EDIT_CHECK_TILES:
    return FALSE;

  case PACKET_EDIT_TOGGLE_FOGOFWAR:
    return FALSE;

  case PACKET_EDIT_TILE_TERRAIN:
    return FALSE;

  case PACKET_EDIT_TILE_RESOURCE:
    return FALSE;

  case PACKET_EDIT_TILE_SPECIAL:
    return FALSE;

  case PACKET_EDIT_TILE_BASE:
    return FALSE;

  case PACKET_EDIT_TILE_ROAD:
    return FALSE;

  case PACKET_EDIT_STARTPOS:
    return FALSE;

  case PACKET_EDIT_STARTPOS_FULL:
    return FALSE;

  case PACKET_EDIT_TILE:
    return FALSE;

  case PACKET_EDIT_UNIT_CREATE:
    return FALSE;

  case PACKET_EDIT_UNIT_REMOVE:
    return FALSE;

  case PACKET_EDIT_UNIT_REMOVE_BY_ID:
    return FALSE;

  case PACKET_EDIT_UNIT:
    return FALSE;

  case PACKET_EDIT_CITY_CREATE:
    return FALSE;

  case PACKET_EDIT_CITY_REMOVE:
    return FALSE;

  case PACKET_EDIT_CITY:
    return FALSE;

  case PACKET_EDIT_PLAYER_CREATE:
    return FALSE;

  case PACKET_EDIT_PLAYER_REMOVE:
    return FALSE;

  case PACKET_EDIT_PLAYER:
    return FALSE;

  case PACKET_EDIT_PLAYER_VISION:
    return FALSE;

  case PACKET_EDIT_GAME:
    return FALSE;

  case PACKET_EDIT_OBJECT_CREATED:
    return FALSE;

  default:
    return FALSE;
  }
}

static struct packet_processing_started *receive_packet_processing_started_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_processing_started, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_processing_started_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_processing_started_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PROCESSING_STARTED);

  log_packet_detailed("packet_processing_started_100: sending info about ()");
  SEND_PACKET_END(PACKET_PROCESSING_STARTED);
}

static void ensure_valid_variant_packet_processing_started(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PROCESSING_STARTED] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PROCESSING_STARTED variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PROCESSING_STARTED] = variant;
}

struct packet_processing_started *receive_packet_processing_started(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_processing_started at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_processing_started(pc);

  switch(pc->phs.variant[PACKET_PROCESSING_STARTED]) {
  case 100:
    return receive_packet_processing_started_100(pc);
  default:
    log_debug("Unknown PACKET_PROCESSING_STARTED variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_processing_started(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_processing_started from the client.");
  }
  ensure_valid_variant_packet_processing_started(pc);

  switch(pc->phs.variant[PACKET_PROCESSING_STARTED]) {

  case 100:
    return send_packet_processing_started_100(pc);
  default:
    log_debug("Unknown PACKET_PROCESSING_STARTED variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_processing_finished *receive_packet_processing_finished_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_processing_finished, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_processing_finished_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_processing_finished_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PROCESSING_FINISHED);

  log_packet_detailed("packet_processing_finished_100: sending info about ()");
  SEND_PACKET_END(PACKET_PROCESSING_FINISHED);
}

static void ensure_valid_variant_packet_processing_finished(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PROCESSING_FINISHED] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PROCESSING_FINISHED variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PROCESSING_FINISHED] = variant;
}

struct packet_processing_finished *receive_packet_processing_finished(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_processing_finished at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_processing_finished(pc);

  switch(pc->phs.variant[PACKET_PROCESSING_FINISHED]) {
  case 100:
    return receive_packet_processing_finished_100(pc);
  default:
    log_debug("Unknown PACKET_PROCESSING_FINISHED variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_processing_finished(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_processing_finished from the client.");
  }
  ensure_valid_variant_packet_processing_finished(pc);

  switch(pc->phs.variant[PACKET_PROCESSING_FINISHED]) {

  case 100:
    return send_packet_processing_finished_100(pc);
  default:
    log_debug("Unknown PACKET_PROCESSING_FINISHED variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_server_join_req *receive_packet_server_join_req_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_server_join_req, real_packet);
  if (!dio_get_string(&din, real_packet->username, sizeof(real_packet->username))) {
    RECEIVE_PACKET_FIELD_ERROR(username);
  }
  if (!dio_get_string(&din, real_packet->capability, sizeof(real_packet->capability))) {
    RECEIVE_PACKET_FIELD_ERROR(capability);
  }
  if (!dio_get_string(&din, real_packet->version_label, sizeof(real_packet->version_label))) {
    RECEIVE_PACKET_FIELD_ERROR(version_label);
  }
  if (!dio_get_uint32(&din, &real_packet->major_version)) {
    RECEIVE_PACKET_FIELD_ERROR(major_version);
  }
  if (!dio_get_uint32(&din, &real_packet->minor_version)) {
    RECEIVE_PACKET_FIELD_ERROR(minor_version);
  }
  if (!dio_get_uint32(&din, &real_packet->patch_version)) {
    RECEIVE_PACKET_FIELD_ERROR(patch_version);
  }

  log_packet_detailed("packet_server_join_req_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_join_req_100(struct connection *pc, const struct packet_server_join_req *packet)
{
  const struct packet_server_join_req *real_packet = packet;
  SEND_PACKET_START(PACKET_SERVER_JOIN_REQ);

  log_packet_detailed("packet_server_join_req_100: sending info about ()");

  dio_put_string(&dout, real_packet->username);
  dio_put_string(&dout, real_packet->capability);
  dio_put_string(&dout, real_packet->version_label);
  dio_put_uint32(&dout, real_packet->major_version);
  dio_put_uint32(&dout, real_packet->minor_version);
  dio_put_uint32(&dout, real_packet->patch_version);

  SEND_PACKET_END(PACKET_SERVER_JOIN_REQ);
}

static void ensure_valid_variant_packet_server_join_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_JOIN_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_JOIN_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_JOIN_REQ] = variant;
}

struct packet_server_join_req *receive_packet_server_join_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_server_join_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_server_join_req(pc);

  switch(pc->phs.variant[PACKET_SERVER_JOIN_REQ]) {
  case 100:
    return receive_packet_server_join_req_100(pc);
  default:
    log_debug("Unknown PACKET_SERVER_JOIN_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_join_req(struct connection *pc, const struct packet_server_join_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_server_join_req from the server.");
  }
  ensure_valid_variant_packet_server_join_req(pc);

  switch(pc->phs.variant[PACKET_SERVER_JOIN_REQ]) {

  case 100:
    return send_packet_server_join_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_JOIN_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_server_join_req(struct connection *pc, const char *username, const char *capability, const char *version_label, int major_version, int minor_version, int patch_version)
{
  struct packet_server_join_req packet, *real_packet = &packet;

  sz_strlcpy(real_packet->username, username);
  sz_strlcpy(real_packet->capability, capability);
  sz_strlcpy(real_packet->version_label, version_label);
  real_packet->major_version = major_version;
  real_packet->minor_version = minor_version;
  real_packet->patch_version = patch_version;
  
  return send_packet_server_join_req(pc, real_packet);
}

static struct packet_server_join_reply *receive_packet_server_join_reply_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_server_join_reply, real_packet);
  if (!dio_get_bool8(&din, &real_packet->you_can_join)) {
    RECEIVE_PACKET_FIELD_ERROR(you_can_join);
  }
  if (!dio_get_string(&din, real_packet->message, sizeof(real_packet->message))) {
    RECEIVE_PACKET_FIELD_ERROR(message);
  }
  if (!dio_get_string(&din, real_packet->capability, sizeof(real_packet->capability))) {
    RECEIVE_PACKET_FIELD_ERROR(capability);
  }
  if (!dio_get_string(&din, real_packet->challenge_file, sizeof(real_packet->challenge_file))) {
    RECEIVE_PACKET_FIELD_ERROR(challenge_file);
  }
  if (!dio_get_sint16(&din, &real_packet->conn_id)) {
    RECEIVE_PACKET_FIELD_ERROR(conn_id);
  }

  log_packet_detailed("packet_server_join_reply_100: got info about ()");
  post_receive_packet_server_join_reply(pc, real_packet);
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_join_reply_100(struct connection *pc, const struct packet_server_join_reply *packet)
{
  const struct packet_server_join_reply *real_packet = packet;
  SEND_PACKET_START(PACKET_SERVER_JOIN_REPLY);

  log_packet_detailed("packet_server_join_reply_100: sending info about ()");

  dio_put_bool8(&dout, real_packet->you_can_join);
  dio_put_string(&dout, real_packet->message);
  dio_put_string(&dout, real_packet->capability);
  dio_put_string(&dout, real_packet->challenge_file);
  dio_put_sint16(&dout, real_packet->conn_id);

  post_send_packet_server_join_reply(pc, real_packet);
  SEND_PACKET_END(PACKET_SERVER_JOIN_REPLY);
}

static void ensure_valid_variant_packet_server_join_reply(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_JOIN_REPLY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_JOIN_REPLY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_JOIN_REPLY] = variant;
}

struct packet_server_join_reply *receive_packet_server_join_reply(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_server_join_reply at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_server_join_reply(pc);

  switch(pc->phs.variant[PACKET_SERVER_JOIN_REPLY]) {
  case 100:
    return receive_packet_server_join_reply_100(pc);
  default:
    log_debug("Unknown PACKET_SERVER_JOIN_REPLY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_join_reply(struct connection *pc, const struct packet_server_join_reply *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_join_reply from the client.");
  }
  ensure_valid_variant_packet_server_join_reply(pc);

  switch(pc->phs.variant[PACKET_SERVER_JOIN_REPLY]) {

  case 100:
    return send_packet_server_join_reply_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SERVER_JOIN_REPLY variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_authentication_req_100 hash_const

#define cmp_packet_authentication_req_100 cmp_const

BV_DEFINE(packet_authentication_req_100_fields, 2);

static struct packet_authentication_req *receive_packet_authentication_req_100(struct connection *pc)
{
  packet_authentication_req_100_fields fields;
  struct packet_authentication_req *old;
  struct genhash **hash = pc->phs.received + PACKET_AUTHENTICATION_REQ;
  RECEIVE_PACKET_START(packet_authentication_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_authentication_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_req_100, cmp_packet_authentication_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'message'");
    if (!dio_get_string(&din, real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_authentication_req_100(struct connection *pc, const struct packet_authentication_req *packet)
{
  const struct packet_authentication_req *real_packet = packet;
  packet_authentication_req_100_fields fields;
  struct packet_authentication_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_AUTHENTICATION_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_AUTHENTICATION_REQ);

  log_packet_detailed("packet_authentication_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_req_100, cmp_packet_authentication_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'message' has changed");
    dio_put_string(&dout, real_packet->message);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_AUTHENTICATION_REQ);
}

static void ensure_valid_variant_packet_authentication_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_AUTHENTICATION_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_AUTHENTICATION_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_AUTHENTICATION_REQ] = variant;
}

struct packet_authentication_req *receive_packet_authentication_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_authentication_req at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_authentication_req(pc);

  switch(pc->phs.variant[PACKET_AUTHENTICATION_REQ]) {
  case 100:
    return receive_packet_authentication_req_100(pc);
  default:
    log_debug("Unknown PACKET_AUTHENTICATION_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_authentication_req(struct connection *pc, const struct packet_authentication_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_authentication_req from the client.");
  }
  ensure_valid_variant_packet_authentication_req(pc);

  switch(pc->phs.variant[PACKET_AUTHENTICATION_REQ]) {

  case 100:
    return send_packet_authentication_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_AUTHENTICATION_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_authentication_req(struct connection *pc, enum authentication_type type, const char *message)
{
  struct packet_authentication_req packet, *real_packet = &packet;

  real_packet->type = type;
  sz_strlcpy(real_packet->message, message);
  
  return send_packet_authentication_req(pc, real_packet);
}

#define hash_packet_authentication_reply_100 hash_const

#define cmp_packet_authentication_reply_100 cmp_const

BV_DEFINE(packet_authentication_reply_100_fields, 1);

static struct packet_authentication_reply *receive_packet_authentication_reply_100(struct connection *pc)
{
  packet_authentication_reply_100_fields fields;
  struct packet_authentication_reply *old;
  struct genhash **hash = pc->phs.received + PACKET_AUTHENTICATION_REPLY;
  RECEIVE_PACKET_START(packet_authentication_reply, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_authentication_reply_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_reply_100, cmp_packet_authentication_reply_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'password'");
    if (!dio_get_string(&din, real_packet->password, sizeof(real_packet->password))) {
      RECEIVE_PACKET_FIELD_ERROR(password);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_authentication_reply_100(struct connection *pc, const struct packet_authentication_reply *packet)
{
  const struct packet_authentication_reply *real_packet = packet;
  packet_authentication_reply_100_fields fields;
  struct packet_authentication_reply *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_AUTHENTICATION_REPLY;
  int different = 0;
  SEND_PACKET_START(PACKET_AUTHENTICATION_REPLY);

  log_packet_detailed("packet_authentication_reply_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_authentication_reply_100, cmp_packet_authentication_reply_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->password, real_packet->password) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'password' has changed");
    dio_put_string(&dout, real_packet->password);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_AUTHENTICATION_REPLY);
}

static void ensure_valid_variant_packet_authentication_reply(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_AUTHENTICATION_REPLY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_AUTHENTICATION_REPLY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_AUTHENTICATION_REPLY] = variant;
}

struct packet_authentication_reply *receive_packet_authentication_reply(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_authentication_reply at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_authentication_reply(pc);

  switch(pc->phs.variant[PACKET_AUTHENTICATION_REPLY]) {
  case 100:
    return receive_packet_authentication_reply_100(pc);
  default:
    log_debug("Unknown PACKET_AUTHENTICATION_REPLY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_authentication_reply(struct connection *pc, const struct packet_authentication_reply *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_authentication_reply from the server.");
  }
  ensure_valid_variant_packet_authentication_reply(pc);

  switch(pc->phs.variant[PACKET_AUTHENTICATION_REPLY]) {

  case 100:
    return send_packet_authentication_reply_100(pc, packet);
  default:
    log_debug("Unknown PACKET_AUTHENTICATION_REPLY variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_server_shutdown *receive_packet_server_shutdown_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_server_shutdown, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_server_shutdown_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_server_shutdown_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_SERVER_SHUTDOWN);

  log_packet_detailed("packet_server_shutdown_100: sending info about ()");
  SEND_PACKET_END(PACKET_SERVER_SHUTDOWN);
}

static void ensure_valid_variant_packet_server_shutdown(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SERVER_SHUTDOWN] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SERVER_SHUTDOWN variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SERVER_SHUTDOWN] = variant;
}

struct packet_server_shutdown *receive_packet_server_shutdown(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_server_shutdown at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_server_shutdown(pc);

  switch(pc->phs.variant[PACKET_SERVER_SHUTDOWN]) {
  case 100:
    return receive_packet_server_shutdown_100(pc);
  default:
    log_debug("Unknown PACKET_SERVER_SHUTDOWN variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_server_shutdown(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_server_shutdown from the client.");
  }
  ensure_valid_variant_packet_server_shutdown(pc);

  switch(pc->phs.variant[PACKET_SERVER_SHUTDOWN]) {

  case 100:
    return send_packet_server_shutdown_100(pc);
  default:
    log_debug("Unknown PACKET_SERVER_SHUTDOWN variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_server_shutdown(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_server_shutdown(pconn);
  } conn_list_iterate_end;
}

#define hash_packet_nation_select_req_100 hash_const

#define cmp_packet_nation_select_req_100 cmp_const

BV_DEFINE(packet_nation_select_req_100_fields, 5);

static struct packet_nation_select_req *receive_packet_nation_select_req_100(struct connection *pc)
{
  packet_nation_select_req_100_fields fields;
  struct packet_nation_select_req *old;
  struct genhash **hash = pc->phs.received + PACKET_NATION_SELECT_REQ;
  RECEIVE_PACKET_START(packet_nation_select_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_nation_select_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_select_req_100, cmp_packet_nation_select_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'player_no'");
    if (!dio_get_sint8(&din, &real_packet->player_no)) {
      RECEIVE_PACKET_FIELD_ERROR(player_no);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nation_no'");
    {
      int readin;
      
      if (!dio_get_sint16(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(nation_no);
      }
      real_packet->nation_no = readin;
    }
  }
  real_packet->is_male = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'city_style'");
    if (!dio_get_uint8(&din, &real_packet->city_style)) {
      RECEIVE_PACKET_FIELD_ERROR(city_style);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nation_select_req_100(struct connection *pc, const struct packet_nation_select_req *packet)
{
  const struct packet_nation_select_req *real_packet = packet;
  packet_nation_select_req_100_fields fields;
  struct packet_nation_select_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NATION_SELECT_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_NATION_SELECT_REQ);

  log_packet_detailed("packet_nation_select_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_select_req_100, cmp_packet_nation_select_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->player_no != real_packet->player_no);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nation_no != real_packet->nation_no);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->is_male != real_packet->is_male);
  if(differ) {
    different++;
  }
  if (packet->is_male) {
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->city_style != real_packet->city_style);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'player_no' has changed");
    dio_put_sint8(&dout, real_packet->player_no);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nation_no' has changed");
    dio_put_sint16(&dout, real_packet->nation_no);
  }
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'city_style' has changed");
    dio_put_uint8(&dout, real_packet->city_style);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_NATION_SELECT_REQ);
}

static void ensure_valid_variant_packet_nation_select_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_NATION_SELECT_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_NATION_SELECT_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_NATION_SELECT_REQ] = variant;
}

struct packet_nation_select_req *receive_packet_nation_select_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_nation_select_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_nation_select_req(pc);

  switch(pc->phs.variant[PACKET_NATION_SELECT_REQ]) {
  case 100:
    return receive_packet_nation_select_req_100(pc);
  default:
    log_debug("Unknown PACKET_NATION_SELECT_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_nation_select_req(struct connection *pc, const struct packet_nation_select_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_nation_select_req from the server.");
  }
  ensure_valid_variant_packet_nation_select_req(pc);

  switch(pc->phs.variant[PACKET_NATION_SELECT_REQ]) {

  case 100:
    return send_packet_nation_select_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_NATION_SELECT_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_nation_select_req(struct connection *pc, int player_no, Nation_type_id nation_no, bool is_male, const char *name, int city_style)
{
  struct packet_nation_select_req packet, *real_packet = &packet;

  real_packet->player_no = player_no;
  real_packet->nation_no = nation_no;
  real_packet->is_male = is_male;
  sz_strlcpy(real_packet->name, name);
  real_packet->city_style = city_style;
  
  return send_packet_nation_select_req(pc, real_packet);
}

#define hash_packet_player_ready_100 hash_const

#define cmp_packet_player_ready_100 cmp_const

BV_DEFINE(packet_player_ready_100_fields, 2);

static struct packet_player_ready *receive_packet_player_ready_100(struct connection *pc)
{
  packet_player_ready_100_fields fields;
  struct packet_player_ready *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_READY;
  RECEIVE_PACKET_START(packet_player_ready, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_ready_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_ready_100, cmp_packet_player_ready_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'player_no'");
    if (!dio_get_sint8(&din, &real_packet->player_no)) {
      RECEIVE_PACKET_FIELD_ERROR(player_no);
    }
  }
  real_packet->is_ready = BV_ISSET(fields, 1);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_ready_100(struct connection *pc, const struct packet_player_ready *packet)
{
  const struct packet_player_ready *real_packet = packet;
  packet_player_ready_100_fields fields;
  struct packet_player_ready *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_READY;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_READY);

  log_packet_detailed("packet_player_ready_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_ready_100, cmp_packet_player_ready_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->player_no != real_packet->player_no);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->is_ready != real_packet->is_ready);
  if(differ) {
    different++;
  }
  if (packet->is_ready) {
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'player_no' has changed");
    dio_put_sint8(&dout, real_packet->player_no);
  }
  /* field 1 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_READY);
}

static void ensure_valid_variant_packet_player_ready(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_READY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_READY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_READY] = variant;
}

struct packet_player_ready *receive_packet_player_ready(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_player_ready at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_player_ready(pc);

  switch(pc->phs.variant[PACKET_PLAYER_READY]) {
  case 100:
    return receive_packet_player_ready_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_READY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_ready(struct connection *pc, const struct packet_player_ready *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_ready from the server.");
  }
  ensure_valid_variant_packet_player_ready(pc);

  switch(pc->phs.variant[PACKET_PLAYER_READY]) {

  case 100:
    return send_packet_player_ready_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_READY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_ready(struct connection *pc, int player_no, bool is_ready)
{
  struct packet_player_ready packet, *real_packet = &packet;

  real_packet->player_no = player_no;
  real_packet->is_ready = is_ready;
  
  return send_packet_player_ready(pc, real_packet);
}

static struct packet_endgame_report *receive_packet_endgame_report_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_endgame_report, real_packet);
  if (!dio_get_uint8(&din, &real_packet->category_num)) {
    RECEIVE_PACKET_FIELD_ERROR(category_num);
  }
  
  {
    int i;
  
    if (real_packet->category_num > 32) {
      RECEIVE_PACKET_FIELD_ERROR(category_name, ": truncation array");
    }
    for (i = 0; i < real_packet->category_num; i++) {
      if (!dio_get_string(&din, real_packet->category_name[i], sizeof(real_packet->category_name[i]))) {
        RECEIVE_PACKET_FIELD_ERROR(category_name);
      }
    }
  }
  if (!dio_get_uint8(&din, &real_packet->player_num)) {
    RECEIVE_PACKET_FIELD_ERROR(player_num);
  }

  log_packet_detailed("packet_endgame_report_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_endgame_report_100(struct connection *pc, const struct packet_endgame_report *packet)
{
  const struct packet_endgame_report *real_packet = packet;
  SEND_PACKET_START(PACKET_ENDGAME_REPORT);

  log_packet_detailed("packet_endgame_report_100: sending info about ()");

  dio_put_uint8(&dout, real_packet->category_num);

    {
      int i;

      for (i = 0; i < real_packet->category_num; i++) {
        dio_put_string(&dout, real_packet->category_name[i]);
      }
    } 
  dio_put_uint8(&dout, real_packet->player_num);

  SEND_PACKET_END(PACKET_ENDGAME_REPORT);
}

static void ensure_valid_variant_packet_endgame_report(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_ENDGAME_REPORT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_ENDGAME_REPORT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_ENDGAME_REPORT] = variant;
}

struct packet_endgame_report *receive_packet_endgame_report(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_endgame_report at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_endgame_report(pc);

  switch(pc->phs.variant[PACKET_ENDGAME_REPORT]) {
  case 100:
    return receive_packet_endgame_report_100(pc);
  default:
    log_debug("Unknown PACKET_ENDGAME_REPORT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_endgame_report(struct connection *pc, const struct packet_endgame_report *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_endgame_report from the client.");
  }
  ensure_valid_variant_packet_endgame_report(pc);

  switch(pc->phs.variant[PACKET_ENDGAME_REPORT]) {

  case 100:
    return send_packet_endgame_report_100(pc, packet);
  default:
    log_debug("Unknown PACKET_ENDGAME_REPORT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_endgame_report(struct conn_list *dest, const struct packet_endgame_report *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_endgame_report(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_endgame_player *receive_packet_endgame_player_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_endgame_player, real_packet);
  if (!dio_get_uint8(&din, &real_packet->category_num)) {
    RECEIVE_PACKET_FIELD_ERROR(category_num);
  }
  if (!dio_get_sint8(&din, &real_packet->player_id)) {
    RECEIVE_PACKET_FIELD_ERROR(player_id);
  }
  if (!dio_get_uint16(&din, &real_packet->score)) {
    RECEIVE_PACKET_FIELD_ERROR(score);
  }
  
  {
    int i;
  
    if (real_packet->category_num > 32) {
      RECEIVE_PACKET_FIELD_ERROR(category_score, ": truncation array");
    }
    for (i = 0; i < real_packet->category_num; i++) {
      if (!dio_get_uint32(&din, &real_packet->category_score[i])) {
        RECEIVE_PACKET_FIELD_ERROR(category_score);
      }
    }
  }

  log_packet_detailed("packet_endgame_player_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_endgame_player_100(struct connection *pc, const struct packet_endgame_player *packet)
{
  const struct packet_endgame_player *real_packet = packet;
  SEND_PACKET_START(PACKET_ENDGAME_PLAYER);

  log_packet_detailed("packet_endgame_player_100: sending info about ()");

  dio_put_uint8(&dout, real_packet->category_num);
  dio_put_sint8(&dout, real_packet->player_id);
  dio_put_uint16(&dout, real_packet->score);

    {
      int i;

      for (i = 0; i < real_packet->category_num; i++) {
        dio_put_uint32(&dout, real_packet->category_score[i]);
      }
    } 

  SEND_PACKET_END(PACKET_ENDGAME_PLAYER);
}

static void ensure_valid_variant_packet_endgame_player(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_ENDGAME_PLAYER] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_ENDGAME_PLAYER variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_ENDGAME_PLAYER] = variant;
}

struct packet_endgame_player *receive_packet_endgame_player(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_endgame_player at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_endgame_player(pc);

  switch(pc->phs.variant[PACKET_ENDGAME_PLAYER]) {
  case 100:
    return receive_packet_endgame_player_100(pc);
  default:
    log_debug("Unknown PACKET_ENDGAME_PLAYER variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_endgame_player(struct connection *pc, const struct packet_endgame_player *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_endgame_player from the client.");
  }
  ensure_valid_variant_packet_endgame_player(pc);

  switch(pc->phs.variant[PACKET_ENDGAME_PLAYER]) {

  case 100:
    return send_packet_endgame_player_100(pc, packet);
  default:
    log_debug("Unknown PACKET_ENDGAME_PLAYER variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_endgame_player(struct conn_list *dest, const struct packet_endgame_player *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_endgame_player(pconn, packet);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_tile_info_100(const void *vkey)
{
  const struct packet_tile_info *key = (const struct packet_tile_info *) vkey;

  return key->tile;
}

static bool cmp_packet_tile_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_tile_info *key1 = (const struct packet_tile_info *) vkey1;
  const struct packet_tile_info *key2 = (const struct packet_tile_info *) vkey2;

  return key1->tile == key2->tile;
}

BV_DEFINE(packet_tile_info_100_fields, 11);

static struct packet_tile_info *receive_packet_tile_info_100(struct connection *pc)
{
  packet_tile_info_100_fields fields;
  struct packet_tile_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TILE_INFO;
  RECEIVE_PACKET_START(packet_tile_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_sint32(&din, &real_packet->tile)) {
    RECEIVE_PACKET_FIELD_ERROR(tile);
  }

  log_packet_detailed("packet_tile_info_100: got info about (%d)",
    real_packet->tile);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_100, cmp_packet_tile_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int tile = real_packet->tile;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->tile = tile;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'continent'");
    {
      int readin;
      
      if (!dio_get_sint16(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(continent);
      }
      real_packet->continent = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'known'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(known);
      }
      real_packet->known = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'owner'");
    if (!dio_get_sint8(&din, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'worked'");
    if (!dio_get_uint16(&din, &real_packet->worked)) {
      RECEIVE_PACKET_FIELD_ERROR(worked);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'terrain'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(terrain);
      }
      real_packet->terrain = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'resource'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(resource);
      }
      real_packet->resource = readin;
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'special'");
    
    {
      int i;
    
      for (i = 0; i < S_LAST; i++) {
        if (!dio_get_bool8(&din, &real_packet->special[i])) {
          RECEIVE_PACKET_FIELD_ERROR(special);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'bases'");
    if (!DIO_BV_GET(&din, real_packet->bases)) {
      RECEIVE_PACKET_FIELD_ERROR(bases);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'roads'");
    if (!DIO_BV_GET(&din, real_packet->roads)) {
      RECEIVE_PACKET_FIELD_ERROR(roads);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'spec_sprite'");
    if (!dio_get_string(&din, real_packet->spec_sprite, sizeof(real_packet->spec_sprite))) {
      RECEIVE_PACKET_FIELD_ERROR(spec_sprite);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'label'");
    if (!dio_get_string(&din, real_packet->label, sizeof(real_packet->label))) {
      RECEIVE_PACKET_FIELD_ERROR(label);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_tile_info_100(struct connection *pc, const struct packet_tile_info *packet)
{
  const struct packet_tile_info *real_packet = packet;
  packet_tile_info_100_fields fields;
  struct packet_tile_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TILE_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_TILE_INFO);

  log_packet_detailed("packet_tile_info_100: sending info about (%d)",
    real_packet->tile);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tile_info_100, cmp_packet_tile_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->continent != real_packet->continent);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->known != real_packet->known);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->worked != real_packet->worked);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->terrain != real_packet->terrain);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->resource != real_packet->resource);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (S_LAST != S_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < S_LAST; i++) {
          if (old->special[i] != real_packet->special[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->bases, real_packet->bases);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = !BV_ARE_EQUAL(old->roads, real_packet->roads);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->spec_sprite, real_packet->spec_sprite) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->label, real_packet->label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_sint32(&dout, real_packet->tile);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'continent' has changed");
    dio_put_sint16(&dout, real_packet->continent);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'known' has changed");
    dio_put_uint8(&dout, real_packet->known);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'worked' has changed");
    dio_put_uint16(&dout, real_packet->worked);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'terrain' has changed");
    dio_put_uint8(&dout, real_packet->terrain);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'resource' has changed");
    dio_put_uint8(&dout, real_packet->resource);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'special' has changed");
  
    {
      int i;

      for (i = 0; i < S_LAST; i++) {
        dio_put_bool8(&dout, real_packet->special[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'bases' has changed");
  DIO_BV_PUT(&dout, packet->bases);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'roads' has changed");
  DIO_BV_PUT(&dout, packet->roads);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'spec_sprite' has changed");
    dio_put_string(&dout, real_packet->spec_sprite);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'label' has changed");
    dio_put_string(&dout, real_packet->label);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_TILE_INFO);
}

static void ensure_valid_variant_packet_tile_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_TILE_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_TILE_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_TILE_INFO] = variant;
}

struct packet_tile_info *receive_packet_tile_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_tile_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_tile_info(pc);

  switch(pc->phs.variant[PACKET_TILE_INFO]) {
  case 100:
    return receive_packet_tile_info_100(pc);
  default:
    log_debug("Unknown PACKET_TILE_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_tile_info(struct connection *pc, const struct packet_tile_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_tile_info from the client.");
  }
  ensure_valid_variant_packet_tile_info(pc);

  switch(pc->phs.variant[PACKET_TILE_INFO]) {

  case 100:
    return send_packet_tile_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_TILE_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_tile_info(struct conn_list *dest, const struct packet_tile_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_tile_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_game_info_100 hash_const

#define cmp_packet_game_info_100 cmp_const

BV_DEFINE(packet_game_info_100_fields, 90);

static struct packet_game_info *receive_packet_game_info_100(struct connection *pc)
{
  packet_game_info_100_fields fields;
  struct packet_game_info *old;
  struct genhash **hash = pc->phs.received + PACKET_GAME_INFO;
  RECEIVE_PACKET_START(packet_game_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_game_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_100, cmp_packet_game_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'add_to_size_limit'");
    if (!dio_get_uint8(&din, &real_packet->add_to_size_limit)) {
      RECEIVE_PACKET_FIELD_ERROR(add_to_size_limit);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'aifill'");
    if (!dio_get_uint8(&din, &real_packet->aifill)) {
      RECEIVE_PACKET_FIELD_ERROR(aifill);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'airlifting_style'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(airlifting_style);
      }
      real_packet->airlifting_style = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'angrycitizen'");
    if (!dio_get_uint8(&din, &real_packet->angrycitizen)) {
      RECEIVE_PACKET_FIELD_ERROR(angrycitizen);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'base_pollution'");
    if (!dio_get_sint16(&din, &real_packet->base_pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(base_pollution);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'base_tech_cost'");
    if (!dio_get_uint8(&din, &real_packet->base_tech_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(base_tech_cost);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'border_city_radius_sq'");
    if (!dio_get_uint8(&din, &real_packet->border_city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(border_city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'border_size_effect'");
    if (!dio_get_uint8(&din, &real_packet->border_size_effect)) {
      RECEIVE_PACKET_FIELD_ERROR(border_size_effect);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'borders'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(borders);
      }
      real_packet->borders = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'base_bribe_cost'");
    if (!dio_get_uint32(&din, &real_packet->base_bribe_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(base_bribe_cost);
    }
  }
  real_packet->calendar_skip_0 = BV_ISSET(fields, 10);
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'celebratesize'");
    if (!dio_get_uint8(&din, &real_packet->celebratesize)) {
      RECEIVE_PACKET_FIELD_ERROR(celebratesize);
    }
  }
  real_packet->changable_tax = BV_ISSET(fields, 12);
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'pop_report_zeroes'");
    if (!dio_get_uint8(&din, &real_packet->pop_report_zeroes)) {
      RECEIVE_PACKET_FIELD_ERROR(pop_report_zeroes);
    }
  }
  real_packet->citizen_nationality = BV_ISSET(fields, 14);
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'citizen_convert_speed'");
    if (!dio_get_uint16(&din, &real_packet->citizen_convert_speed)) {
      RECEIVE_PACKET_FIELD_ERROR(citizen_convert_speed);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'citizen_partisans_pct'");
    if (!dio_get_uint8(&din, &real_packet->citizen_partisans_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(citizen_partisans_pct);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'citymindist'");
    if (!dio_get_uint8(&din, &real_packet->citymindist)) {
      RECEIVE_PACKET_FIELD_ERROR(citymindist);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'cooling'");
    if (!dio_get_uint32(&din, &real_packet->cooling)) {
      RECEIVE_PACKET_FIELD_ERROR(cooling);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'coolinglevel'");
    if (!dio_get_uint32(&din, &real_packet->coolinglevel)) {
      RECEIVE_PACKET_FIELD_ERROR(coolinglevel);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'diplomacy'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(diplomacy);
      }
      real_packet->diplomacy = readin;
    }
  }
  real_packet->fogofwar = BV_ISSET(fields, 21);
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'food_cost'");
    if (!dio_get_uint8(&din, &real_packet->food_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(food_cost);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'foodbox'");
    if (!dio_get_uint32(&din, &real_packet->foodbox)) {
      RECEIVE_PACKET_FIELD_ERROR(foodbox);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'forced_gold'");
    if (!dio_get_uint8(&din, &real_packet->forced_gold)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_gold);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'forced_luxury'");
    if (!dio_get_uint8(&din, &real_packet->forced_luxury)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_luxury);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'forced_science'");
    if (!dio_get_uint8(&din, &real_packet->forced_science)) {
      RECEIVE_PACKET_FIELD_ERROR(forced_science);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'fulltradesize'");
    if (!dio_get_uint8(&din, &real_packet->fulltradesize)) {
      RECEIVE_PACKET_FIELD_ERROR(fulltradesize);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'global_advances'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        RECEIVE_PACKET_FIELD_ERROR(global_advances);
      }
      if (i == 255) {
        break;
      }
      if (i > A_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(global_advances,
                                   ": unexpected value %d "
                                   "(> A_LAST) in array diff",
                                   i);
      } else {
        if (!dio_get_bool8(&din, &real_packet->global_advances[i])) {
          RECEIVE_PACKET_FIELD_ERROR(global_advances);
        }
      }
    }
  }
  real_packet->global_warming = BV_ISSET(fields, 29);
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'globalwarming'");
    if (!dio_get_uint32(&din, &real_packet->globalwarming)) {
      RECEIVE_PACKET_FIELD_ERROR(globalwarming);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'gold'");
    if (!dio_get_uint32(&din, &real_packet->gold)) {
      RECEIVE_PACKET_FIELD_ERROR(gold);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'gold_upkeep_style'");
    if (!dio_get_uint8(&din, &real_packet->gold_upkeep_style)) {
      RECEIVE_PACKET_FIELD_ERROR(gold_upkeep_style);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'government_during_revolution_id'");
    if (!dio_get_uint8(&din, &real_packet->government_during_revolution_id)) {
      RECEIVE_PACKET_FIELD_ERROR(government_during_revolution_id);
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'granary_food_inc'");
    if (!dio_get_uint8(&din, &real_packet->granary_food_inc)) {
      RECEIVE_PACKET_FIELD_ERROR(granary_food_inc);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'granary_food_ini'");
    
    {
      int i;
    
      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        if (!dio_get_uint8(&din, &real_packet->granary_food_ini[i])) {
          RECEIVE_PACKET_FIELD_ERROR(granary_food_ini);
        }
      }
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'granary_num_inis'");
    if (!dio_get_uint8(&din, &real_packet->granary_num_inis)) {
      RECEIVE_PACKET_FIELD_ERROR(granary_num_inis);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'great_wonder_owners'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners);
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners,
                                   ": unexpected value %d "
                                   "(> B_LAST) in array diff",
                                   i);
      } else {
        if (!dio_get_sint8(&din, &real_packet->great_wonder_owners[i])) {
          RECEIVE_PACKET_FIELD_ERROR(great_wonder_owners);
        }
      }
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'happy_cost'");
    if (!dio_get_uint8(&din, &real_packet->happy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(happy_cost);
    }
  }
  real_packet->happyborders = BV_ISSET(fields, 39);
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  got field 'heating'");
    if (!dio_get_uint32(&din, &real_packet->heating)) {
      RECEIVE_PACKET_FIELD_ERROR(heating);
    }
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'illness_base_factor'");
    if (!dio_get_uint8(&din, &real_packet->illness_base_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_base_factor);
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'illness_min_size'");
    if (!dio_get_uint8(&din, &real_packet->illness_min_size)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_min_size);
    }
  }
  real_packet->illness_on = BV_ISSET(fields, 43);
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'illness_pollution_factor'");
    if (!dio_get_uint8(&din, &real_packet->illness_pollution_factor)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_pollution_factor);
    }
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'illness_trade_infection'");
    if (!dio_get_uint8(&din, &real_packet->illness_trade_infection)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade_infection);
    }
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  got field 'init_city_radius_sq'");
    if (!dio_get_uint8(&din, &real_packet->init_city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(init_city_radius_sq);
    }
  }
  real_packet->is_edit_mode = BV_ISSET(fields, 47);
  real_packet->is_new_game = BV_ISSET(fields, 48);
  real_packet->killcitizen = BV_ISSET(fields, 49);
  real_packet->killstack = BV_ISSET(fields, 50);
  if (BV_ISSET(fields, 51)) {
    log_packet_detailed("  got field 'min_city_center_output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->min_city_center_output[i])) {
          RECEIVE_PACKET_FIELD_ERROR(min_city_center_output);
        }
      }
    }
  }
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  got field 'negative_year_label'");
    if (!dio_get_string(&din, real_packet->negative_year_label, sizeof(real_packet->negative_year_label))) {
      RECEIVE_PACKET_FIELD_ERROR(negative_year_label);
    }
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  got field 'notradesize'");
    if (!dio_get_uint8(&din, &real_packet->notradesize)) {
      RECEIVE_PACKET_FIELD_ERROR(notradesize);
    }
  }
  real_packet->nuclear_winter = BV_ISSET(fields, 54);
  if (BV_ISSET(fields, 55)) {
    log_packet_detailed("  got field 'nuclearwinter'");
    if (!dio_get_uint32(&din, &real_packet->nuclearwinter)) {
      RECEIVE_PACKET_FIELD_ERROR(nuclearwinter);
    }
  }
  if (BV_ISSET(fields, 56)) {
    log_packet_detailed("  got field 'phase'");
    if (!dio_get_sint16(&din, &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }
  if (BV_ISSET(fields, 57)) {
    log_packet_detailed("  got field 'phase_mode'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(phase_mode);
      }
      real_packet->phase_mode = readin;
    }
  }
  real_packet->pillage_select = BV_ISSET(fields, 58);
  if (BV_ISSET(fields, 59)) {
    log_packet_detailed("  got field 'positive_year_label'");
    if (!dio_get_string(&din, real_packet->positive_year_label, sizeof(real_packet->positive_year_label))) {
      RECEIVE_PACKET_FIELD_ERROR(positive_year_label);
    }
  }
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  got field 'rapturedelay'");
    if (!dio_get_uint8(&din, &real_packet->rapturedelay)) {
      RECEIVE_PACKET_FIELD_ERROR(rapturedelay);
    }
  }
  if (BV_ISSET(fields, 61)) {
    log_packet_detailed("  got field 'disasters'");
    if (!dio_get_uint16(&din, &real_packet->disasters)) {
      RECEIVE_PACKET_FIELD_ERROR(disasters);
    }
  }
  real_packet->restrictinfra = BV_ISSET(fields, 62);
  real_packet->unreachable_protects = BV_ISSET(fields, 63);
  if (BV_ISSET(fields, 64)) {
    log_packet_detailed("  got field 'sciencebox'");
    if (!dio_get_uint32(&din, &real_packet->sciencebox)) {
      RECEIVE_PACKET_FIELD_ERROR(sciencebox);
    }
  }
  if (BV_ISSET(fields, 65)) {
    log_packet_detailed("  got field 'seconds_to_phasedone'");
    if (!dio_get_sfloat(&din, &real_packet->seconds_to_phasedone, 100)) {
      RECEIVE_PACKET_FIELD_ERROR(seconds_to_phasedone);
    }
  }
  if (BV_ISSET(fields, 66)) {
    log_packet_detailed("  got field 'shieldbox'");
    if (!dio_get_uint32(&din, &real_packet->shieldbox)) {
      RECEIVE_PACKET_FIELD_ERROR(shieldbox);
    }
  }
  if (BV_ISSET(fields, 67)) {
    log_packet_detailed("  got field 'skill_level'");
    if (!dio_get_uint32(&din, &real_packet->skill_level)) {
      RECEIVE_PACKET_FIELD_ERROR(skill_level);
    }
  }
  real_packet->slow_invasions = BV_ISSET(fields, 68);
  real_packet->spacerace = BV_ISSET(fields, 69);
  real_packet->team_pooled_research = BV_ISSET(fields, 70);
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  got field 'tech'");
    if (!dio_get_uint32(&din, &real_packet->tech)) {
      RECEIVE_PACKET_FIELD_ERROR(tech);
    }
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  got field 'tech_cost_style'");
    if (!dio_get_uint8(&din, &real_packet->tech_cost_style)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_cost_style);
    }
  }
  if (BV_ISSET(fields, 73)) {
    log_packet_detailed("  got field 'tech_leakage'");
    if (!dio_get_uint8(&din, &real_packet->tech_leakage)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_leakage);
    }
  }
  if (BV_ISSET(fields, 74)) {
    log_packet_detailed("  got field 'tech_upkeep_divider'");
    if (!dio_get_uint16(&din, &real_packet->tech_upkeep_divider)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_divider);
    }
  }
  if (BV_ISSET(fields, 75)) {
    log_packet_detailed("  got field 'tech_upkeep_style'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(tech_upkeep_style);
      }
      real_packet->tech_upkeep_style = readin;
    }
  }
  if (BV_ISSET(fields, 76)) {
    log_packet_detailed("  got field 'free_tech_method'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(free_tech_method);
      }
      real_packet->free_tech_method = readin;
    }
  }
  if (BV_ISSET(fields, 77)) {
    log_packet_detailed("  got field 'gameloss_style'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gameloss_style);
      }
      real_packet->gameloss_style = readin;
    }
  }
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  got field 'timeout'");
    if (!dio_get_uint32(&din, &real_packet->timeout)) {
      RECEIVE_PACKET_FIELD_ERROR(timeout);
    }
  }
  real_packet->tired_attack = BV_ISSET(fields, 79);
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  got field 'trademindist'");
    if (!dio_get_uint16(&din, &real_packet->trademindist)) {
      RECEIVE_PACKET_FIELD_ERROR(trademindist);
    }
  }
  real_packet->trading_city = BV_ISSET(fields, 81);
  real_packet->trading_gold = BV_ISSET(fields, 82);
  real_packet->trading_tech = BV_ISSET(fields, 83);
  if (BV_ISSET(fields, 84)) {
    log_packet_detailed("  got field 'turn'");
    if (!dio_get_sint16(&din, &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }
  if (BV_ISSET(fields, 85)) {
    log_packet_detailed("  got field 'warminglevel'");
    if (!dio_get_uint32(&din, &real_packet->warminglevel)) {
      RECEIVE_PACKET_FIELD_ERROR(warminglevel);
    }
  }
  if (BV_ISSET(fields, 86)) {
    log_packet_detailed("  got field 'year'");
    if (!dio_get_sint16(&din, &real_packet->year)) {
      RECEIVE_PACKET_FIELD_ERROR(year);
    }
  }
  real_packet->year_0_hack = BV_ISSET(fields, 87);
  real_packet->civil_war_enabled = BV_ISSET(fields, 88);
  real_packet->paradrop_to_transport = BV_ISSET(fields, 89);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_game_info_100(struct connection *pc, const struct packet_game_info *packet)
{
  const struct packet_game_info *real_packet = packet;
  packet_game_info_100_fields fields;
  struct packet_game_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_GAME_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_GAME_INFO);

  log_packet_detailed("packet_game_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_game_info_100, cmp_packet_game_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->add_to_size_limit != real_packet->add_to_size_limit);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->aifill != real_packet->aifill);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->airlifting_style != real_packet->airlifting_style);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->angrycitizen != real_packet->angrycitizen);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->base_pollution != real_packet->base_pollution);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->base_tech_cost != real_packet->base_tech_cost);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->border_city_radius_sq != real_packet->border_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->border_size_effect != real_packet->border_size_effect);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->borders != real_packet->borders);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->base_bribe_cost != real_packet->base_bribe_cost);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->calendar_skip_0 != real_packet->calendar_skip_0);
  if(differ) {
    different++;
  }
  if (packet->calendar_skip_0) {
    BV_SET(fields, 10);
  }

  differ = (old->celebratesize != real_packet->celebratesize);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->changable_tax != real_packet->changable_tax);
  if(differ) {
    different++;
  }
  if (packet->changable_tax) {
    BV_SET(fields, 12);
  }

  differ = (old->pop_report_zeroes != real_packet->pop_report_zeroes);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->citizen_nationality != real_packet->citizen_nationality);
  if(differ) {
    different++;
  }
  if (packet->citizen_nationality) {
    BV_SET(fields, 14);
  }

  differ = (old->citizen_convert_speed != real_packet->citizen_convert_speed);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->citizen_partisans_pct != real_packet->citizen_partisans_pct);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->citymindist != real_packet->citymindist);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->cooling != real_packet->cooling);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->coolinglevel != real_packet->coolinglevel);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->diplomacy != real_packet->diplomacy);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->fogofwar != real_packet->fogofwar);
  if(differ) {
    different++;
  }
  if (packet->fogofwar) {
    BV_SET(fields, 21);
  }

  differ = (old->food_cost != real_packet->food_cost);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->foodbox != real_packet->foodbox);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->forced_gold != real_packet->forced_gold);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->forced_luxury != real_packet->forced_luxury);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->forced_science != real_packet->forced_science);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->fulltradesize != real_packet->fulltradesize);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }


    {
      differ = (A_LAST != A_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < A_LAST; i++) {
          if (old->global_advances[i] != real_packet->global_advances[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->global_warming != real_packet->global_warming);
  if(differ) {
    different++;
  }
  if (packet->global_warming) {
    BV_SET(fields, 29);
  }

  differ = (old->globalwarming != real_packet->globalwarming);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->gold_upkeep_style != real_packet->gold_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->government_during_revolution_id != real_packet->government_during_revolution_id);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->granary_food_inc != real_packet->granary_food_inc);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }


    {
      differ = (MAX_GRANARY_INIS != MAX_GRANARY_INIS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_GRANARY_INIS; i++) {
          if (old->granary_food_ini[i] != real_packet->granary_food_ini[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->granary_num_inis != real_packet->granary_num_inis);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = (old->happyborders != real_packet->happyborders);
  if(differ) {
    different++;
  }
  if (packet->happyborders) {
    BV_SET(fields, 39);
  }

  differ = (old->heating != real_packet->heating);
  if (differ) {
    different++;
    BV_SET(fields, 40);
  }

  differ = (old->illness_base_factor != real_packet->illness_base_factor);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = (old->illness_min_size != real_packet->illness_min_size);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = (old->illness_on != real_packet->illness_on);
  if(differ) {
    different++;
  }
  if (packet->illness_on) {
    BV_SET(fields, 43);
  }

  differ = (old->illness_pollution_factor != real_packet->illness_pollution_factor);
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }

  differ = (old->illness_trade_infection != real_packet->illness_trade_infection);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }

  differ = (old->init_city_radius_sq != real_packet->init_city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 46);
  }

  differ = (old->is_edit_mode != real_packet->is_edit_mode);
  if(differ) {
    different++;
  }
  if (packet->is_edit_mode) {
    BV_SET(fields, 47);
  }

  differ = (old->is_new_game != real_packet->is_new_game);
  if(differ) {
    different++;
  }
  if (packet->is_new_game) {
    BV_SET(fields, 48);
  }

  differ = (old->killcitizen != real_packet->killcitizen);
  if(differ) {
    different++;
  }
  if (packet->killcitizen) {
    BV_SET(fields, 49);
  }

  differ = (old->killstack != real_packet->killstack);
  if(differ) {
    different++;
  }
  if (packet->killstack) {
    BV_SET(fields, 50);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->min_city_center_output[i] != real_packet->min_city_center_output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 51);
  }

  differ = (strcmp(old->negative_year_label, real_packet->negative_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 52);
  }

  differ = (old->notradesize != real_packet->notradesize);
  if (differ) {
    different++;
    BV_SET(fields, 53);
  }

  differ = (old->nuclear_winter != real_packet->nuclear_winter);
  if(differ) {
    different++;
  }
  if (packet->nuclear_winter) {
    BV_SET(fields, 54);
  }

  differ = (old->nuclearwinter != real_packet->nuclearwinter);
  if (differ) {
    different++;
    BV_SET(fields, 55);
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 56);
  }

  differ = (old->phase_mode != real_packet->phase_mode);
  if (differ) {
    different++;
    BV_SET(fields, 57);
  }

  differ = (old->pillage_select != real_packet->pillage_select);
  if(differ) {
    different++;
  }
  if (packet->pillage_select) {
    BV_SET(fields, 58);
  }

  differ = (strcmp(old->positive_year_label, real_packet->positive_year_label) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 59);
  }

  differ = (old->rapturedelay != real_packet->rapturedelay);
  if (differ) {
    different++;
    BV_SET(fields, 60);
  }

  differ = (old->disasters != real_packet->disasters);
  if (differ) {
    different++;
    BV_SET(fields, 61);
  }

  differ = (old->restrictinfra != real_packet->restrictinfra);
  if(differ) {
    different++;
  }
  if (packet->restrictinfra) {
    BV_SET(fields, 62);
  }

  differ = (old->unreachable_protects != real_packet->unreachable_protects);
  if(differ) {
    different++;
  }
  if (packet->unreachable_protects) {
    BV_SET(fields, 63);
  }

  differ = (old->sciencebox != real_packet->sciencebox);
  if (differ) {
    different++;
    BV_SET(fields, 64);
  }

  differ = (old->seconds_to_phasedone != real_packet->seconds_to_phasedone);
  if (differ) {
    different++;
    BV_SET(fields, 65);
  }

  differ = (old->shieldbox != real_packet->shieldbox);
  if (differ) {
    different++;
    BV_SET(fields, 66);
  }

  differ = (old->skill_level != real_packet->skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 67);
  }

  differ = (old->slow_invasions != real_packet->slow_invasions);
  if(differ) {
    different++;
  }
  if (packet->slow_invasions) {
    BV_SET(fields, 68);
  }

  differ = (old->spacerace != real_packet->spacerace);
  if(differ) {
    different++;
  }
  if (packet->spacerace) {
    BV_SET(fields, 69);
  }

  differ = (old->team_pooled_research != real_packet->team_pooled_research);
  if(differ) {
    different++;
  }
  if (packet->team_pooled_research) {
    BV_SET(fields, 70);
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 71);
  }

  differ = (old->tech_cost_style != real_packet->tech_cost_style);
  if (differ) {
    different++;
    BV_SET(fields, 72);
  }

  differ = (old->tech_leakage != real_packet->tech_leakage);
  if (differ) {
    different++;
    BV_SET(fields, 73);
  }

  differ = (old->tech_upkeep_divider != real_packet->tech_upkeep_divider);
  if (differ) {
    different++;
    BV_SET(fields, 74);
  }

  differ = (old->tech_upkeep_style != real_packet->tech_upkeep_style);
  if (differ) {
    different++;
    BV_SET(fields, 75);
  }

  differ = (old->free_tech_method != real_packet->free_tech_method);
  if (differ) {
    different++;
    BV_SET(fields, 76);
  }

  differ = (old->gameloss_style != real_packet->gameloss_style);
  if (differ) {
    different++;
    BV_SET(fields, 77);
  }

  differ = (old->timeout != real_packet->timeout);
  if (differ) {
    different++;
    BV_SET(fields, 78);
  }

  differ = (old->tired_attack != real_packet->tired_attack);
  if(differ) {
    different++;
  }
  if (packet->tired_attack) {
    BV_SET(fields, 79);
  }

  differ = (old->trademindist != real_packet->trademindist);
  if (differ) {
    different++;
    BV_SET(fields, 80);
  }

  differ = (old->trading_city != real_packet->trading_city);
  if(differ) {
    different++;
  }
  if (packet->trading_city) {
    BV_SET(fields, 81);
  }

  differ = (old->trading_gold != real_packet->trading_gold);
  if(differ) {
    different++;
  }
  if (packet->trading_gold) {
    BV_SET(fields, 82);
  }

  differ = (old->trading_tech != real_packet->trading_tech);
  if(differ) {
    different++;
  }
  if (packet->trading_tech) {
    BV_SET(fields, 83);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 84);
  }

  differ = (old->warminglevel != real_packet->warminglevel);
  if (differ) {
    different++;
    BV_SET(fields, 85);
  }

  differ = (old->year != real_packet->year);
  if (differ) {
    different++;
    BV_SET(fields, 86);
  }

  differ = (old->year_0_hack != real_packet->year_0_hack);
  if(differ) {
    different++;
  }
  if (packet->year_0_hack) {
    BV_SET(fields, 87);
  }

  differ = (old->civil_war_enabled != real_packet->civil_war_enabled);
  if(differ) {
    different++;
  }
  if (packet->civil_war_enabled) {
    BV_SET(fields, 88);
  }

  differ = (old->paradrop_to_transport != real_packet->paradrop_to_transport);
  if(differ) {
    different++;
  }
  if (packet->paradrop_to_transport) {
    BV_SET(fields, 89);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'add_to_size_limit' has changed");
    dio_put_uint8(&dout, real_packet->add_to_size_limit);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'aifill' has changed");
    dio_put_uint8(&dout, real_packet->aifill);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'airlifting_style' has changed");
    dio_put_uint8(&dout, real_packet->airlifting_style);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'angrycitizen' has changed");
    dio_put_uint8(&dout, real_packet->angrycitizen);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'base_pollution' has changed");
    dio_put_sint16(&dout, real_packet->base_pollution);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'base_tech_cost' has changed");
    dio_put_uint8(&dout, real_packet->base_tech_cost);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'border_city_radius_sq' has changed");
    dio_put_uint8(&dout, real_packet->border_city_radius_sq);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'border_size_effect' has changed");
    dio_put_uint8(&dout, real_packet->border_size_effect);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'borders' has changed");
    dio_put_uint8(&dout, real_packet->borders);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'base_bribe_cost' has changed");
    dio_put_uint32(&dout, real_packet->base_bribe_cost);
  }
  /* field 10 is folded into the header */
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'celebratesize' has changed");
    dio_put_uint8(&dout, real_packet->celebratesize);
  }
  /* field 12 is folded into the header */
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'pop_report_zeroes' has changed");
    dio_put_uint8(&dout, real_packet->pop_report_zeroes);
  }
  /* field 14 is folded into the header */
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'citizen_convert_speed' has changed");
    dio_put_uint16(&dout, real_packet->citizen_convert_speed);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'citizen_partisans_pct' has changed");
    dio_put_uint8(&dout, real_packet->citizen_partisans_pct);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'citymindist' has changed");
    dio_put_uint8(&dout, real_packet->citymindist);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'cooling' has changed");
    dio_put_uint32(&dout, real_packet->cooling);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'coolinglevel' has changed");
    dio_put_uint32(&dout, real_packet->coolinglevel);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'diplomacy' has changed");
    dio_put_uint8(&dout, real_packet->diplomacy);
  }
  /* field 21 is folded into the header */
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'food_cost' has changed");
    dio_put_uint8(&dout, real_packet->food_cost);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'foodbox' has changed");
    dio_put_uint32(&dout, real_packet->foodbox);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'forced_gold' has changed");
    dio_put_uint8(&dout, real_packet->forced_gold);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'forced_luxury' has changed");
    dio_put_uint8(&dout, real_packet->forced_luxury);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'forced_science' has changed");
    dio_put_uint8(&dout, real_packet->forced_science);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'fulltradesize' has changed");
    dio_put_uint8(&dout, real_packet->fulltradesize);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'global_advances' has changed");
  
    {
      int i;

      fc_assert(A_LAST < 255);

      for (i = 0; i < A_LAST; i++) {
        if(old->global_advances[i] != real_packet->global_advances[i]) {
          dio_put_uint8(&dout, i);
          dio_put_bool8(&dout, real_packet->global_advances[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  /* field 29 is folded into the header */
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'globalwarming' has changed");
    dio_put_uint32(&dout, real_packet->globalwarming);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'gold' has changed");
    dio_put_uint32(&dout, real_packet->gold);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'gold_upkeep_style' has changed");
    dio_put_uint8(&dout, real_packet->gold_upkeep_style);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'government_during_revolution_id' has changed");
    dio_put_uint8(&dout, real_packet->government_during_revolution_id);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'granary_food_inc' has changed");
    dio_put_uint8(&dout, real_packet->granary_food_inc);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'granary_food_ini' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_GRANARY_INIS; i++) {
        dio_put_uint8(&dout, real_packet->granary_food_ini[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'granary_num_inis' has changed");
    dio_put_uint8(&dout, real_packet->granary_num_inis);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'great_wonder_owners' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->great_wonder_owners[i] != real_packet->great_wonder_owners[i]) {
          dio_put_uint8(&dout, i);
          dio_put_sint8(&dout, real_packet->great_wonder_owners[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'happy_cost' has changed");
    dio_put_uint8(&dout, real_packet->happy_cost);
  }
  /* field 39 is folded into the header */
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  field 'heating' has changed");
    dio_put_uint32(&dout, real_packet->heating);
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'illness_base_factor' has changed");
    dio_put_uint8(&dout, real_packet->illness_base_factor);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'illness_min_size' has changed");
    dio_put_uint8(&dout, real_packet->illness_min_size);
  }
  /* field 43 is folded into the header */
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'illness_pollution_factor' has changed");
    dio_put_uint8(&dout, real_packet->illness_pollution_factor);
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'illness_trade_infection' has changed");
    dio_put_uint8(&dout, real_packet->illness_trade_infection);
  }
  if (BV_ISSET(fields, 46)) {
    log_packet_detailed("  field 'init_city_radius_sq' has changed");
    dio_put_uint8(&dout, real_packet->init_city_radius_sq);
  }
  /* field 47 is folded into the header */
  /* field 48 is folded into the header */
  /* field 49 is folded into the header */
  /* field 50 is folded into the header */
  if (BV_ISSET(fields, 51)) {
    log_packet_detailed("  field 'min_city_center_output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->min_city_center_output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 52)) {
    log_packet_detailed("  field 'negative_year_label' has changed");
    dio_put_string(&dout, real_packet->negative_year_label);
  }
  if (BV_ISSET(fields, 53)) {
    log_packet_detailed("  field 'notradesize' has changed");
    dio_put_uint8(&dout, real_packet->notradesize);
  }
  /* field 54 is folded into the header */
  if (BV_ISSET(fields, 55)) {
    log_packet_detailed("  field 'nuclearwinter' has changed");
    dio_put_uint32(&dout, real_packet->nuclearwinter);
  }
  if (BV_ISSET(fields, 56)) {
    log_packet_detailed("  field 'phase' has changed");
    dio_put_sint16(&dout, real_packet->phase);
  }
  if (BV_ISSET(fields, 57)) {
    log_packet_detailed("  field 'phase_mode' has changed");
    dio_put_uint8(&dout, real_packet->phase_mode);
  }
  /* field 58 is folded into the header */
  if (BV_ISSET(fields, 59)) {
    log_packet_detailed("  field 'positive_year_label' has changed");
    dio_put_string(&dout, real_packet->positive_year_label);
  }
  if (BV_ISSET(fields, 60)) {
    log_packet_detailed("  field 'rapturedelay' has changed");
    dio_put_uint8(&dout, real_packet->rapturedelay);
  }
  if (BV_ISSET(fields, 61)) {
    log_packet_detailed("  field 'disasters' has changed");
    dio_put_uint16(&dout, real_packet->disasters);
  }
  /* field 62 is folded into the header */
  /* field 63 is folded into the header */
  if (BV_ISSET(fields, 64)) {
    log_packet_detailed("  field 'sciencebox' has changed");
    dio_put_uint32(&dout, real_packet->sciencebox);
  }
  if (BV_ISSET(fields, 65)) {
    log_packet_detailed("  field 'seconds_to_phasedone' has changed");
    dio_put_sfloat(&dout, real_packet->seconds_to_phasedone, 100);
  }
  if (BV_ISSET(fields, 66)) {
    log_packet_detailed("  field 'shieldbox' has changed");
    dio_put_uint32(&dout, real_packet->shieldbox);
  }
  if (BV_ISSET(fields, 67)) {
    log_packet_detailed("  field 'skill_level' has changed");
    dio_put_uint32(&dout, real_packet->skill_level);
  }
  /* field 68 is folded into the header */
  /* field 69 is folded into the header */
  /* field 70 is folded into the header */
  if (BV_ISSET(fields, 71)) {
    log_packet_detailed("  field 'tech' has changed");
    dio_put_uint32(&dout, real_packet->tech);
  }
  if (BV_ISSET(fields, 72)) {
    log_packet_detailed("  field 'tech_cost_style' has changed");
    dio_put_uint8(&dout, real_packet->tech_cost_style);
  }
  if (BV_ISSET(fields, 73)) {
    log_packet_detailed("  field 'tech_leakage' has changed");
    dio_put_uint8(&dout, real_packet->tech_leakage);
  }
  if (BV_ISSET(fields, 74)) {
    log_packet_detailed("  field 'tech_upkeep_divider' has changed");
    dio_put_uint16(&dout, real_packet->tech_upkeep_divider);
  }
  if (BV_ISSET(fields, 75)) {
    log_packet_detailed("  field 'tech_upkeep_style' has changed");
    dio_put_uint8(&dout, real_packet->tech_upkeep_style);
  }
  if (BV_ISSET(fields, 76)) {
    log_packet_detailed("  field 'free_tech_method' has changed");
    dio_put_uint8(&dout, real_packet->free_tech_method);
  }
  if (BV_ISSET(fields, 77)) {
    log_packet_detailed("  field 'gameloss_style' has changed");
    dio_put_uint8(&dout, real_packet->gameloss_style);
  }
  if (BV_ISSET(fields, 78)) {
    log_packet_detailed("  field 'timeout' has changed");
    dio_put_uint32(&dout, real_packet->timeout);
  }
  /* field 79 is folded into the header */
  if (BV_ISSET(fields, 80)) {
    log_packet_detailed("  field 'trademindist' has changed");
    dio_put_uint16(&dout, real_packet->trademindist);
  }
  /* field 81 is folded into the header */
  /* field 82 is folded into the header */
  /* field 83 is folded into the header */
  if (BV_ISSET(fields, 84)) {
    log_packet_detailed("  field 'turn' has changed");
    dio_put_sint16(&dout, real_packet->turn);
  }
  if (BV_ISSET(fields, 85)) {
    log_packet_detailed("  field 'warminglevel' has changed");
    dio_put_uint32(&dout, real_packet->warminglevel);
  }
  if (BV_ISSET(fields, 86)) {
    log_packet_detailed("  field 'year' has changed");
    dio_put_sint16(&dout, real_packet->year);
  }
  /* field 87 is folded into the header */
  /* field 88 is folded into the header */
  /* field 89 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_GAME_INFO);
}

static void ensure_valid_variant_packet_game_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_GAME_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_GAME_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_GAME_INFO] = variant;
}

struct packet_game_info *receive_packet_game_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_game_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_game_info(pc);

  switch(pc->phs.variant[PACKET_GAME_INFO]) {
  case 100:
    return receive_packet_game_info_100(pc);
  default:
    log_debug("Unknown PACKET_GAME_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_game_info(struct connection *pc, const struct packet_game_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_game_info from the client.");
  }
  ensure_valid_variant_packet_game_info(pc);

  switch(pc->phs.variant[PACKET_GAME_INFO]) {

  case 100:
    return send_packet_game_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_GAME_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_map_info_100 hash_const

#define cmp_packet_map_info_100 cmp_const

BV_DEFINE(packet_map_info_100_fields, 3);

static struct packet_map_info *receive_packet_map_info_100(struct connection *pc)
{
  packet_map_info_100_fields fields;
  struct packet_map_info *old;
  struct genhash **hash = pc->phs.received + PACKET_MAP_INFO;
  RECEIVE_PACKET_START(packet_map_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_map_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_map_info_100, cmp_packet_map_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'xsize'");
    if (!dio_get_uint16(&din, &real_packet->xsize)) {
      RECEIVE_PACKET_FIELD_ERROR(xsize);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'ysize'");
    if (!dio_get_uint16(&din, &real_packet->ysize)) {
      RECEIVE_PACKET_FIELD_ERROR(ysize);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'topology_id'");
    if (!dio_get_uint8(&din, &real_packet->topology_id)) {
      RECEIVE_PACKET_FIELD_ERROR(topology_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_map_info_100(struct connection *pc, const struct packet_map_info *packet)
{
  const struct packet_map_info *real_packet = packet;
  packet_map_info_100_fields fields;
  struct packet_map_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_MAP_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_MAP_INFO);

  log_packet_detailed("packet_map_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_map_info_100, cmp_packet_map_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->xsize != real_packet->xsize);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->ysize != real_packet->ysize);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->topology_id != real_packet->topology_id);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'xsize' has changed");
    dio_put_uint16(&dout, real_packet->xsize);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'ysize' has changed");
    dio_put_uint16(&dout, real_packet->ysize);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'topology_id' has changed");
    dio_put_uint8(&dout, real_packet->topology_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_MAP_INFO);
}

static void ensure_valid_variant_packet_map_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_MAP_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_MAP_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_MAP_INFO] = variant;
}

struct packet_map_info *receive_packet_map_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_map_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_map_info(pc);

  switch(pc->phs.variant[PACKET_MAP_INFO]) {
  case 100:
    return receive_packet_map_info_100(pc);
  default:
    log_debug("Unknown PACKET_MAP_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_map_info(struct connection *pc, const struct packet_map_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_map_info from the client.");
  }
  ensure_valid_variant_packet_map_info(pc);

  switch(pc->phs.variant[PACKET_MAP_INFO]) {

  case 100:
    return send_packet_map_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_MAP_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_map_info(struct conn_list *dest, const struct packet_map_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_map_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_nuke_tile_info_100 hash_const

#define cmp_packet_nuke_tile_info_100 cmp_const

BV_DEFINE(packet_nuke_tile_info_100_fields, 1);

static struct packet_nuke_tile_info *receive_packet_nuke_tile_info_100(struct connection *pc)
{
  packet_nuke_tile_info_100_fields fields;
  struct packet_nuke_tile_info *old;
  struct genhash **hash = pc->phs.received + PACKET_NUKE_TILE_INFO;
  RECEIVE_PACKET_START(packet_nuke_tile_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_nuke_tile_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nuke_tile_info_100, cmp_packet_nuke_tile_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    if (!dio_get_sint32(&din, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nuke_tile_info_100(struct connection *pc, const struct packet_nuke_tile_info *packet)
{
  const struct packet_nuke_tile_info *real_packet = packet;
  packet_nuke_tile_info_100_fields fields;
  struct packet_nuke_tile_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NUKE_TILE_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_NUKE_TILE_INFO);

  log_packet_detailed("packet_nuke_tile_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nuke_tile_info_100, cmp_packet_nuke_tile_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_NUKE_TILE_INFO);
}

static void ensure_valid_variant_packet_nuke_tile_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_NUKE_TILE_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_NUKE_TILE_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_NUKE_TILE_INFO] = variant;
}

struct packet_nuke_tile_info *receive_packet_nuke_tile_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_nuke_tile_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_nuke_tile_info(pc);

  switch(pc->phs.variant[PACKET_NUKE_TILE_INFO]) {
  case 100:
    return receive_packet_nuke_tile_info_100(pc);
  default:
    log_debug("Unknown PACKET_NUKE_TILE_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_nuke_tile_info(struct connection *pc, const struct packet_nuke_tile_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_nuke_tile_info from the client.");
  }
  ensure_valid_variant_packet_nuke_tile_info(pc);

  switch(pc->phs.variant[PACKET_NUKE_TILE_INFO]) {

  case 100:
    return send_packet_nuke_tile_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_NUKE_TILE_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_nuke_tile_info(struct conn_list *dest, const struct packet_nuke_tile_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_nuke_tile_info(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_nuke_tile_info(struct connection *pc, int tile)
{
  struct packet_nuke_tile_info packet, *real_packet = &packet;

  real_packet->tile = tile;
  
  return send_packet_nuke_tile_info(pc, real_packet);
}

void dlsend_packet_nuke_tile_info(struct conn_list *dest, int tile)
{
  struct packet_nuke_tile_info packet, *real_packet = &packet;

  real_packet->tile = tile;
  
  lsend_packet_nuke_tile_info(dest, real_packet);
}

static genhash_val_t hash_packet_team_name_info_100(const void *vkey)
{
  const struct packet_team_name_info *key = (const struct packet_team_name_info *) vkey;

  return key->team_id;
}

static bool cmp_packet_team_name_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_team_name_info *key1 = (const struct packet_team_name_info *) vkey1;
  const struct packet_team_name_info *key2 = (const struct packet_team_name_info *) vkey2;

  return key1->team_id == key2->team_id;
}

BV_DEFINE(packet_team_name_info_100_fields, 1);

static struct packet_team_name_info *receive_packet_team_name_info_100(struct connection *pc)
{
  packet_team_name_info_100_fields fields;
  struct packet_team_name_info *old;
  struct genhash **hash = pc->phs.received + PACKET_TEAM_NAME_INFO;
  RECEIVE_PACKET_START(packet_team_name_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_uint8(&din, &real_packet->team_id)) {
    RECEIVE_PACKET_FIELD_ERROR(team_id);
  }

  log_packet_detailed("packet_team_name_info_100: got info about (%d)",
    real_packet->team_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_team_name_info_100, cmp_packet_team_name_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int team_id = real_packet->team_id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->team_id = team_id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'team_name'");
    if (!dio_get_string(&din, real_packet->team_name, sizeof(real_packet->team_name))) {
      RECEIVE_PACKET_FIELD_ERROR(team_name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_team_name_info_100(struct connection *pc, const struct packet_team_name_info *packet)
{
  const struct packet_team_name_info *real_packet = packet;
  packet_team_name_info_100_fields fields;
  struct packet_team_name_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TEAM_NAME_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_TEAM_NAME_INFO);

  log_packet_detailed("packet_team_name_info_100: sending info about (%d)",
    real_packet->team_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_team_name_info_100, cmp_packet_team_name_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->team_name, real_packet->team_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_uint8(&dout, real_packet->team_id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'team_name' has changed");
    dio_put_string(&dout, real_packet->team_name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_TEAM_NAME_INFO);
}

static void ensure_valid_variant_packet_team_name_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_TEAM_NAME_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_TEAM_NAME_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_TEAM_NAME_INFO] = variant;
}

struct packet_team_name_info *receive_packet_team_name_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_team_name_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_team_name_info(pc);

  switch(pc->phs.variant[PACKET_TEAM_NAME_INFO]) {
  case 100:
    return receive_packet_team_name_info_100(pc);
  default:
    log_debug("Unknown PACKET_TEAM_NAME_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_team_name_info(struct connection *pc, const struct packet_team_name_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_team_name_info from the client.");
  }
  ensure_valid_variant_packet_team_name_info(pc);

  switch(pc->phs.variant[PACKET_TEAM_NAME_INFO]) {

  case 100:
    return send_packet_team_name_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_TEAM_NAME_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_team_name_info(struct conn_list *dest, const struct packet_team_name_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_team_name_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_chat_msg_100 hash_const

#define cmp_packet_chat_msg_100 cmp_const

BV_DEFINE(packet_chat_msg_100_fields, 4);

static struct packet_chat_msg *receive_packet_chat_msg_100(struct connection *pc)
{
  packet_chat_msg_100_fields fields;
  struct packet_chat_msg *old;
  struct genhash **hash = pc->phs.received + PACKET_CHAT_MSG;
  RECEIVE_PACKET_START(packet_chat_msg, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_chat_msg_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_100, cmp_packet_chat_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    if (!dio_get_string(&din, real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    if (!dio_get_sint32(&din, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'event'");
    {
      int readin;
      
      if (!dio_get_sint16(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(event);
      }
      real_packet->event = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'conn_id'");
    if (!dio_get_sint16(&din, &real_packet->conn_id)) {
      RECEIVE_PACKET_FIELD_ERROR(conn_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_chat_msg_100(struct connection *pc, const struct packet_chat_msg *packet)
{
  const struct packet_chat_msg *real_packet = packet;
  packet_chat_msg_100_fields fields;
  struct packet_chat_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CHAT_MSG;
  int different = 0;
  SEND_PACKET_START(PACKET_CHAT_MSG);

  log_packet_detailed("packet_chat_msg_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_100, cmp_packet_chat_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->conn_id != real_packet->conn_id);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    dio_put_string(&dout, real_packet->message);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'event' has changed");
    dio_put_sint16(&dout, real_packet->event);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'conn_id' has changed");
    dio_put_sint16(&dout, real_packet->conn_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CHAT_MSG);
}

static void ensure_valid_variant_packet_chat_msg(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CHAT_MSG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CHAT_MSG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CHAT_MSG] = variant;
}

struct packet_chat_msg *receive_packet_chat_msg(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_chat_msg at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_chat_msg(pc);

  switch(pc->phs.variant[PACKET_CHAT_MSG]) {
  case 100:
    return receive_packet_chat_msg_100(pc);
  default:
    log_debug("Unknown PACKET_CHAT_MSG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_chat_msg(struct connection *pc, const struct packet_chat_msg *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_chat_msg from the client.");
  }
  ensure_valid_variant_packet_chat_msg(pc);

  switch(pc->phs.variant[PACKET_CHAT_MSG]) {

  case 100:
    return send_packet_chat_msg_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CHAT_MSG variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_chat_msg(struct conn_list *dest, const struct packet_chat_msg *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_chat_msg(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_chat_msg_req_100 hash_const

#define cmp_packet_chat_msg_req_100 cmp_const

BV_DEFINE(packet_chat_msg_req_100_fields, 1);

static struct packet_chat_msg_req *receive_packet_chat_msg_req_100(struct connection *pc)
{
  packet_chat_msg_req_100_fields fields;
  struct packet_chat_msg_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CHAT_MSG_REQ;
  RECEIVE_PACKET_START(packet_chat_msg_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_chat_msg_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_req_100, cmp_packet_chat_msg_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    if (!dio_get_string(&din, real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_chat_msg_req_100(struct connection *pc, const struct packet_chat_msg_req *packet)
{
  const struct packet_chat_msg_req *real_packet = packet;
  packet_chat_msg_req_100_fields fields;
  struct packet_chat_msg_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CHAT_MSG_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_CHAT_MSG_REQ);

  log_packet_detailed("packet_chat_msg_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_chat_msg_req_100, cmp_packet_chat_msg_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    dio_put_string(&dout, real_packet->message);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CHAT_MSG_REQ);
}

static void ensure_valid_variant_packet_chat_msg_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CHAT_MSG_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CHAT_MSG_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CHAT_MSG_REQ] = variant;
}

struct packet_chat_msg_req *receive_packet_chat_msg_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_chat_msg_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_chat_msg_req(pc);

  switch(pc->phs.variant[PACKET_CHAT_MSG_REQ]) {
  case 100:
    return receive_packet_chat_msg_req_100(pc);
  default:
    log_debug("Unknown PACKET_CHAT_MSG_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_chat_msg_req(struct connection *pc, const struct packet_chat_msg_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_chat_msg_req from the server.");
  }
  ensure_valid_variant_packet_chat_msg_req(pc);

  switch(pc->phs.variant[PACKET_CHAT_MSG_REQ]) {

  case 100:
    return send_packet_chat_msg_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CHAT_MSG_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_chat_msg_req(struct connection *pc, const char *message)
{
  struct packet_chat_msg_req packet, *real_packet = &packet;

  sz_strlcpy(real_packet->message, message);
  
  return send_packet_chat_msg_req(pc, real_packet);
}

#define hash_packet_connect_msg_100 hash_const

#define cmp_packet_connect_msg_100 cmp_const

BV_DEFINE(packet_connect_msg_100_fields, 1);

static struct packet_connect_msg *receive_packet_connect_msg_100(struct connection *pc)
{
  packet_connect_msg_100_fields fields;
  struct packet_connect_msg *old;
  struct genhash **hash = pc->phs.received + PACKET_CONNECT_MSG;
  RECEIVE_PACKET_START(packet_connect_msg, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_connect_msg_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_connect_msg_100, cmp_packet_connect_msg_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'message'");
    if (!dio_get_string(&din, real_packet->message, sizeof(real_packet->message))) {
      RECEIVE_PACKET_FIELD_ERROR(message);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_connect_msg_100(struct connection *pc, const struct packet_connect_msg *packet)
{
  const struct packet_connect_msg *real_packet = packet;
  packet_connect_msg_100_fields fields;
  struct packet_connect_msg *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONNECT_MSG;
  int different = 0;
  SEND_PACKET_START(PACKET_CONNECT_MSG);

  log_packet_detailed("packet_connect_msg_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_connect_msg_100, cmp_packet_connect_msg_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->message, real_packet->message) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'message' has changed");
    dio_put_string(&dout, real_packet->message);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CONNECT_MSG);
}

static void ensure_valid_variant_packet_connect_msg(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONNECT_MSG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONNECT_MSG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONNECT_MSG] = variant;
}

struct packet_connect_msg *receive_packet_connect_msg(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_connect_msg at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_connect_msg(pc);

  switch(pc->phs.variant[PACKET_CONNECT_MSG]) {
  case 100:
    return receive_packet_connect_msg_100(pc);
  default:
    log_debug("Unknown PACKET_CONNECT_MSG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_connect_msg(struct connection *pc, const struct packet_connect_msg *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_connect_msg from the client.");
  }
  ensure_valid_variant_packet_connect_msg(pc);

  switch(pc->phs.variant[PACKET_CONNECT_MSG]) {

  case 100:
    return send_packet_connect_msg_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CONNECT_MSG variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_connect_msg(struct connection *pc, const char *message)
{
  struct packet_connect_msg packet, *real_packet = &packet;

  sz_strlcpy(real_packet->message, message);
  
  return send_packet_connect_msg(pc, real_packet);
}

#define hash_packet_city_remove_100 hash_const

#define cmp_packet_city_remove_100 cmp_const

BV_DEFINE(packet_city_remove_100_fields, 1);

static struct packet_city_remove *receive_packet_city_remove_100(struct connection *pc)
{
  packet_city_remove_100_fields fields;
  struct packet_city_remove *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_REMOVE;
  RECEIVE_PACKET_START(packet_city_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_100, cmp_packet_city_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_remove_100(struct connection *pc, const struct packet_city_remove *packet)
{
  const struct packet_city_remove *real_packet = packet;
  packet_city_remove_100_fields fields;
  struct packet_city_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_REMOVE);

  log_packet_detailed("packet_city_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_remove_100, cmp_packet_city_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_CITY_REMOVE);
}

static void ensure_valid_variant_packet_city_remove(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_REMOVE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_REMOVE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_REMOVE] = variant;
}

struct packet_city_remove *receive_packet_city_remove(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_city_remove at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_city_remove(pc);

  switch(pc->phs.variant[PACKET_CITY_REMOVE]) {
  case 100:
    return receive_packet_city_remove_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_REMOVE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_remove(struct connection *pc, const struct packet_city_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_remove from the client.");
  }
  ensure_valid_variant_packet_city_remove(pc);

  switch(pc->phs.variant[PACKET_CITY_REMOVE]) {

  case 100:
    return send_packet_city_remove_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_REMOVE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_remove(struct conn_list *dest, const struct packet_city_remove *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_remove(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_city_remove(struct connection *pc, int city_id)
{
  struct packet_city_remove packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  return send_packet_city_remove(pc, real_packet);
}

void dlsend_packet_city_remove(struct conn_list *dest, int city_id)
{
  struct packet_city_remove packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  lsend_packet_city_remove(dest, real_packet);
}

static genhash_val_t hash_packet_city_info_100(const void *vkey)
{
  const struct packet_city_info *key = (const struct packet_city_info *) vkey;

  return key->id;
}

static bool cmp_packet_city_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_city_info *key1 = (const struct packet_city_info *) vkey1;
  const struct packet_city_info *key2 = (const struct packet_city_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_city_info_100_fields, 46);

static struct packet_city_info *receive_packet_city_info_100(struct connection *pc)
{
  packet_city_info_100_fields fields;
  struct packet_city_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_INFO;
  RECEIVE_PACKET_START(packet_city_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_uint16(&din, &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_city_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_100, cmp_packet_city_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    if (!dio_get_sint32(&din, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'owner'");
    if (!dio_get_sint8(&din, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'size'");
    if (!dio_get_uint8(&din, &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'city_radius_sq'");
    if (!dio_get_uint8(&din, &real_packet->city_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(city_radius_sq);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'ppl_happy'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->ppl_happy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_happy);
        }
      }
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'ppl_content'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->ppl_content[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_content);
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'ppl_unhappy'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->ppl_unhappy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_unhappy);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'ppl_angry'");
    
    {
      int i;
    
      for (i = 0; i < FEELING_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->ppl_angry[i])) {
          RECEIVE_PACKET_FIELD_ERROR(ppl_angry);
        }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'specialists_size'");
    if (!dio_get_uint8(&din, &real_packet->specialists_size)) {
      RECEIVE_PACKET_FIELD_ERROR(specialists_size);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'specialists'");
    
    {
      int i;
    
      if (real_packet->specialists_size > SP_MAX) {
        RECEIVE_PACKET_FIELD_ERROR(specialists, ": truncation array");
      }
      for (i = 0; i < real_packet->specialists_size; i++) {
        if (!dio_get_uint8(&din, &real_packet->specialists[i])) {
          RECEIVE_PACKET_FIELD_ERROR(specialists);
        }
      }
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'nationalities_count'");
    if (!dio_get_uint8(&din, &real_packet->nationalities_count)) {
      RECEIVE_PACKET_FIELD_ERROR(nationalities_count);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'nation_id'");
    
    {
      int i;
    
      if (real_packet->nationalities_count > MAX_NUM_PLAYER_SLOTS) {
        RECEIVE_PACKET_FIELD_ERROR(nation_id, ": truncation array");
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
        if (!dio_get_sint8(&din, &real_packet->nation_id[i])) {
          RECEIVE_PACKET_FIELD_ERROR(nation_id);
        }
      }
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'nation_citizens'");
    
    {
      int i;
    
      if (real_packet->nationalities_count > MAX_NUM_PLAYER_SLOTS) {
        RECEIVE_PACKET_FIELD_ERROR(nation_citizens, ": truncation array");
      }
      for (i = 0; i < real_packet->nationalities_count; i++) {
        if (!dio_get_uint8(&din, &real_packet->nation_citizens[i])) {
          RECEIVE_PACKET_FIELD_ERROR(nation_citizens);
        }
      }
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'surplus'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_sint16(&din, &real_packet->surplus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(surplus);
        }
      }
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'waste'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint16(&din, &real_packet->waste[i])) {
          RECEIVE_PACKET_FIELD_ERROR(waste);
        }
      }
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'unhappy_penalty'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_sint16(&din, &real_packet->unhappy_penalty[i])) {
          RECEIVE_PACKET_FIELD_ERROR(unhappy_penalty);
        }
      }
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'prod'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint16(&din, &real_packet->prod[i])) {
          RECEIVE_PACKET_FIELD_ERROR(prod);
        }
      }
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'citizen_base'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_sint16(&din, &real_packet->citizen_base[i])) {
          RECEIVE_PACKET_FIELD_ERROR(citizen_base);
        }
      }
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'usage'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_sint16(&din, &real_packet->usage[i])) {
          RECEIVE_PACKET_FIELD_ERROR(usage);
        }
      }
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'food_stock'");
    if (!dio_get_uint16(&din, &real_packet->food_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(food_stock);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'shield_stock'");
    if (!dio_get_uint16(&din, &real_packet->shield_stock)) {
      RECEIVE_PACKET_FIELD_ERROR(shield_stock);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'trade'");
    
    {
      int i;
    
      for (i = 0; i < MAX_TRADE_ROUTES; i++) {
        if (!dio_get_uint16(&din, &real_packet->trade[i])) {
          RECEIVE_PACKET_FIELD_ERROR(trade);
        }
      }
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'trade_value'");
    
    {
      int i;
    
      for (i = 0; i < MAX_TRADE_ROUTES; i++) {
        if (!dio_get_uint8(&din, &real_packet->trade_value[i])) {
          RECEIVE_PACKET_FIELD_ERROR(trade_value);
        }
      }
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'pollution'");
    if (!dio_get_uint16(&din, &real_packet->pollution)) {
      RECEIVE_PACKET_FIELD_ERROR(pollution);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'illness_trade'");
    if (!dio_get_uint16(&din, &real_packet->illness_trade)) {
      RECEIVE_PACKET_FIELD_ERROR(illness_trade);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'production_kind'");
    if (!dio_get_uint8(&din, &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'production_value'");
    if (!dio_get_uint8(&din, &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'turn_founded'");
    if (!dio_get_sint16(&din, &real_packet->turn_founded)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_founded);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'turn_last_built'");
    if (!dio_get_sint16(&din, &real_packet->turn_last_built)) {
      RECEIVE_PACKET_FIELD_ERROR(turn_last_built);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'changed_from_kind'");
    if (!dio_get_uint8(&din, &real_packet->changed_from_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_kind);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'changed_from_value'");
    if (!dio_get_uint8(&din, &real_packet->changed_from_value)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_value);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'before_change_shields'");
    if (!dio_get_uint16(&din, &real_packet->before_change_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(before_change_shields);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'disbanded_shields'");
    if (!dio_get_uint16(&din, &real_packet->disbanded_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(disbanded_shields);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'caravan_shields'");
    if (!dio_get_uint16(&din, &real_packet->caravan_shields)) {
      RECEIVE_PACKET_FIELD_ERROR(caravan_shields);
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'last_turns_shield_surplus'");
    if (!dio_get_uint16(&din, &real_packet->last_turns_shield_surplus)) {
      RECEIVE_PACKET_FIELD_ERROR(last_turns_shield_surplus);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'airlift'");
    if (!dio_get_uint8(&din, &real_packet->airlift)) {
      RECEIVE_PACKET_FIELD_ERROR(airlift);
    }
  }
  real_packet->did_buy = BV_ISSET(fields, 36);
  real_packet->did_sell = BV_ISSET(fields, 37);
  real_packet->was_happy = BV_ISSET(fields, 38);
  real_packet->diplomat_investigate = BV_ISSET(fields, 39);
  real_packet->walls = BV_ISSET(fields, 40);
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'city_image'");
    if (!dio_get_sint8(&din, &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'worklist'");
    if (!dio_get_worklist(&din, &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'improvements'");
    if (!DIO_BV_GET(&din, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  got field 'city_options'");
    if (!DIO_BV_GET(&din, real_packet->city_options)) {
      RECEIVE_PACKET_FIELD_ERROR(city_options);
    }
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_info_100(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  const struct packet_city_info *real_packet = packet;
  packet_city_info_100_fields fields;
  struct packet_city_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_INFO;
  int different = force_to_send;
  SEND_PACKET_START(PACKET_CITY_INFO);

  log_packet_detailed("packet_city_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_info_100, cmp_packet_city_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->city_radius_sq != real_packet->city_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_happy[i] != real_packet->ppl_happy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_content[i] != real_packet->ppl_content[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_unhappy[i] != real_packet->ppl_unhappy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (FEELING_LAST != FEELING_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < FEELING_LAST; i++) {
          if (old->ppl_angry[i] != real_packet->ppl_angry[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->specialists_size != real_packet->specialists_size);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = (old->specialists_size != real_packet->specialists_size);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->specialists_size; i++) {
          if (old->specialists[i] != real_packet->specialists[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->nationalities_count != real_packet->nationalities_count);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_id[i] != real_packet->nation_id[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


    {
      differ = (old->nationalities_count != real_packet->nationalities_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nationalities_count; i++) {
          if (old->nation_citizens[i] != real_packet->nation_citizens[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->surplus[i] != real_packet->surplus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->waste[i] != real_packet->waste[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->unhappy_penalty[i] != real_packet->unhappy_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->prod[i] != real_packet->prod[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->citizen_base[i] != real_packet->citizen_base[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->usage[i] != real_packet->usage[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->food_stock != real_packet->food_stock);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->shield_stock != real_packet->shield_stock);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }


    {
      differ = (MAX_TRADE_ROUTES != MAX_TRADE_ROUTES);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_TRADE_ROUTES; i++) {
          if (old->trade[i] != real_packet->trade[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }


    {
      differ = (MAX_TRADE_ROUTES != MAX_TRADE_ROUTES);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_TRADE_ROUTES; i++) {
          if (old->trade_value[i] != real_packet->trade_value[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->pollution != real_packet->pollution);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->illness_trade != real_packet->illness_trade);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->turn_founded != real_packet->turn_founded);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->turn_last_built != real_packet->turn_last_built);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->changed_from_kind != real_packet->changed_from_kind);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->changed_from_value != real_packet->changed_from_value);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->before_change_shields != real_packet->before_change_shields);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->disbanded_shields != real_packet->disbanded_shields);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = (old->caravan_shields != real_packet->caravan_shields);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->last_turns_shield_surplus != real_packet->last_turns_shield_surplus);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->airlift != real_packet->airlift);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->did_buy != real_packet->did_buy);
  if(differ) {
    different++;
  }
  if (packet->did_buy) {
    BV_SET(fields, 36);
  }

  differ = (old->did_sell != real_packet->did_sell);
  if(differ) {
    different++;
  }
  if (packet->did_sell) {
    BV_SET(fields, 37);
  }

  differ = (old->was_happy != real_packet->was_happy);
  if(differ) {
    different++;
  }
  if (packet->was_happy) {
    BV_SET(fields, 38);
  }

  differ = (old->diplomat_investigate != real_packet->diplomat_investigate);
  if(differ) {
    different++;
  }
  if (packet->diplomat_investigate) {
    BV_SET(fields, 39);
  }

  differ = (old->walls != real_packet->walls);
  if(differ) {
    different++;
  }
  if (packet->walls) {
    BV_SET(fields, 40);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }

  differ = !BV_ARE_EQUAL(old->city_options, real_packet->city_options);
  if (differ) {
    different++;
    BV_SET(fields, 44);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 45);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'size' has changed");
    dio_put_uint8(&dout, real_packet->size);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'city_radius_sq' has changed");
    dio_put_uint8(&dout, real_packet->city_radius_sq);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'ppl_happy' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_happy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'ppl_content' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_content[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'ppl_unhappy' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_unhappy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'ppl_angry' has changed");
  
    {
      int i;

      for (i = 0; i < FEELING_LAST; i++) {
        dio_put_uint8(&dout, real_packet->ppl_angry[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'specialists_size' has changed");
    dio_put_uint8(&dout, real_packet->specialists_size);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'specialists' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->specialists_size; i++) {
        dio_put_uint8(&dout, real_packet->specialists[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'nationalities_count' has changed");
    dio_put_uint8(&dout, real_packet->nationalities_count);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'nation_id' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nationalities_count; i++) {
        dio_put_sint8(&dout, real_packet->nation_id[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'nation_citizens' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nationalities_count; i++) {
        dio_put_uint8(&dout, real_packet->nation_citizens[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'surplus' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->surplus[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'waste' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->waste[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'unhappy_penalty' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->unhappy_penalty[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'prod' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->prod[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'citizen_base' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->citizen_base[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'usage' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_sint16(&dout, real_packet->usage[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'food_stock' has changed");
    dio_put_uint16(&dout, real_packet->food_stock);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'shield_stock' has changed");
    dio_put_uint16(&dout, real_packet->shield_stock);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'trade' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_TRADE_ROUTES; i++) {
        dio_put_uint16(&dout, real_packet->trade[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'trade_value' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_TRADE_ROUTES; i++) {
        dio_put_uint8(&dout, real_packet->trade_value[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'pollution' has changed");
    dio_put_uint16(&dout, real_packet->pollution);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'illness_trade' has changed");
    dio_put_uint16(&dout, real_packet->illness_trade);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'production_kind' has changed");
    dio_put_uint8(&dout, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'production_value' has changed");
    dio_put_uint8(&dout, real_packet->production_value);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'turn_founded' has changed");
    dio_put_sint16(&dout, real_packet->turn_founded);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'turn_last_built' has changed");
    dio_put_sint16(&dout, real_packet->turn_last_built);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'changed_from_kind' has changed");
    dio_put_uint8(&dout, real_packet->changed_from_kind);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'changed_from_value' has changed");
    dio_put_uint8(&dout, real_packet->changed_from_value);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'before_change_shields' has changed");
    dio_put_uint16(&dout, real_packet->before_change_shields);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'disbanded_shields' has changed");
    dio_put_uint16(&dout, real_packet->disbanded_shields);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'caravan_shields' has changed");
    dio_put_uint16(&dout, real_packet->caravan_shields);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'last_turns_shield_surplus' has changed");
    dio_put_uint16(&dout, real_packet->last_turns_shield_surplus);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'airlift' has changed");
    dio_put_uint8(&dout, real_packet->airlift);
  }
  /* field 36 is folded into the header */
  /* field 37 is folded into the header */
  /* field 38 is folded into the header */
  /* field 39 is folded into the header */
  /* field 40 is folded into the header */
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'city_image' has changed");
    dio_put_sint8(&dout, real_packet->city_image);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'worklist' has changed");
    dio_put_worklist(&dout, &real_packet->worklist);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'improvements' has changed");
  DIO_BV_PUT(&dout, packet->improvements);
  }
  if (BV_ISSET(fields, 44)) {
    log_packet_detailed("  field 'city_options' has changed");
  DIO_BV_PUT(&dout, packet->city_options);
  }
  if (BV_ISSET(fields, 45)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_CITY_INFO);
}

static void ensure_valid_variant_packet_city_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_INFO] = variant;
}

struct packet_city_info *receive_packet_city_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_city_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_city_info(pc);

  switch(pc->phs.variant[PACKET_CITY_INFO]) {
  case 100:
    return receive_packet_city_info_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_info(struct connection *pc, const struct packet_city_info *packet, bool force_to_send)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_info from the client.");
  }
  ensure_valid_variant_packet_city_info(pc);

  switch(pc->phs.variant[PACKET_CITY_INFO]) {

  case 100:
    return send_packet_city_info_100(pc, packet, force_to_send);
  default:
    log_debug("Unknown PACKET_CITY_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_info(struct conn_list *dest, const struct packet_city_info *packet, bool force_to_send)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_info(pconn, packet, force_to_send);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_city_short_info_100(const void *vkey)
{
  const struct packet_city_short_info *key = (const struct packet_city_short_info *) vkey;

  return key->id;
}

static bool cmp_packet_city_short_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_city_short_info *key1 = (const struct packet_city_short_info *) vkey1;
  const struct packet_city_short_info *key2 = (const struct packet_city_short_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_city_short_info_100_fields, 10);

static struct packet_city_short_info *receive_packet_city_short_info_100(struct connection *pc)
{
  packet_city_short_info_100_fields fields;
  struct packet_city_short_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SHORT_INFO;
  RECEIVE_PACKET_START(packet_city_short_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_uint16(&din, &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_city_short_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_100, cmp_packet_city_short_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tile'");
    if (!dio_get_sint32(&din, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'owner'");
    if (!dio_get_sint8(&din, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'size'");
    if (!dio_get_uint8(&din, &real_packet->size)) {
      RECEIVE_PACKET_FIELD_ERROR(size);
    }
  }
  real_packet->occupied = BV_ISSET(fields, 3);
  real_packet->walls = BV_ISSET(fields, 4);
  real_packet->happy = BV_ISSET(fields, 5);
  real_packet->unhappy = BV_ISSET(fields, 6);
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'city_image'");
    if (!dio_get_sint8(&din, &real_packet->city_image)) {
      RECEIVE_PACKET_FIELD_ERROR(city_image);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'improvements'");
    if (!DIO_BV_GET(&din, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_short_info_100(struct connection *pc, const struct packet_city_short_info *packet)
{
  const struct packet_city_short_info *real_packet = packet;
  packet_city_short_info_100_fields fields;
  struct packet_city_short_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SHORT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_SHORT_INFO);

  log_packet_detailed("packet_city_short_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_short_info_100, cmp_packet_city_short_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->size != real_packet->size);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 3);
  }

  differ = (old->walls != real_packet->walls);
  if(differ) {
    different++;
  }
  if (packet->walls) {
    BV_SET(fields, 4);
  }

  differ = (old->happy != real_packet->happy);
  if(differ) {
    different++;
  }
  if (packet->happy) {
    BV_SET(fields, 5);
  }

  differ = (old->unhappy != real_packet->unhappy);
  if(differ) {
    different++;
  }
  if (packet->unhappy) {
    BV_SET(fields, 6);
  }

  differ = (old->city_image != real_packet->city_image);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'size' has changed");
    dio_put_uint8(&dout, real_packet->size);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  /* field 5 is folded into the header */
  /* field 6 is folded into the header */
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'city_image' has changed");
    dio_put_sint8(&dout, real_packet->city_image);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'improvements' has changed");
  DIO_BV_PUT(&dout, packet->improvements);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_CITY_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_CITY_SHORT_INFO);
}

static void ensure_valid_variant_packet_city_short_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_SHORT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_SHORT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_SHORT_INFO] = variant;
}

struct packet_city_short_info *receive_packet_city_short_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_city_short_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_city_short_info(pc);

  switch(pc->phs.variant[PACKET_CITY_SHORT_INFO]) {
  case 100:
    return receive_packet_city_short_info_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_SHORT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_short_info(struct connection *pc, const struct packet_city_short_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_short_info from the client.");
  }
  ensure_valid_variant_packet_city_short_info(pc);

  switch(pc->phs.variant[PACKET_CITY_SHORT_INFO]) {

  case 100:
    return send_packet_city_short_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_SHORT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_short_info(struct conn_list *dest, const struct packet_city_short_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_short_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_city_sell_100 hash_const

#define cmp_packet_city_sell_100 cmp_const

BV_DEFINE(packet_city_sell_100_fields, 2);

static struct packet_city_sell *receive_packet_city_sell_100(struct connection *pc)
{
  packet_city_sell_100_fields fields;
  struct packet_city_sell *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SELL;
  RECEIVE_PACKET_START(packet_city_sell, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_sell_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_100, cmp_packet_city_sell_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'build_id'");
    if (!dio_get_uint8(&din, &real_packet->build_id)) {
      RECEIVE_PACKET_FIELD_ERROR(build_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sell_100(struct connection *pc, const struct packet_city_sell *packet)
{
  const struct packet_city_sell *real_packet = packet;
  packet_city_sell_100_fields fields;
  struct packet_city_sell *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SELL;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_SELL);

  log_packet_detailed("packet_city_sell_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sell_100, cmp_packet_city_sell_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->build_id != real_packet->build_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'build_id' has changed");
    dio_put_uint8(&dout, real_packet->build_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_SELL);
}

static void ensure_valid_variant_packet_city_sell(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_SELL] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_SELL variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_SELL] = variant;
}

struct packet_city_sell *receive_packet_city_sell(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_sell at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_sell(pc);

  switch(pc->phs.variant[PACKET_CITY_SELL]) {
  case 100:
    return receive_packet_city_sell_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_SELL variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_sell(struct connection *pc, const struct packet_city_sell *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_sell from the server.");
  }
  ensure_valid_variant_packet_city_sell(pc);

  switch(pc->phs.variant[PACKET_CITY_SELL]) {

  case 100:
    return send_packet_city_sell_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_SELL variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_sell(struct connection *pc, int city_id, int build_id)
{
  struct packet_city_sell packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->build_id = build_id;
  
  return send_packet_city_sell(pc, real_packet);
}

#define hash_packet_city_buy_100 hash_const

#define cmp_packet_city_buy_100 cmp_const

BV_DEFINE(packet_city_buy_100_fields, 1);

static struct packet_city_buy *receive_packet_city_buy_100(struct connection *pc)
{
  packet_city_buy_100_fields fields;
  struct packet_city_buy *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_BUY;
  RECEIVE_PACKET_START(packet_city_buy, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_buy_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_100, cmp_packet_city_buy_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_buy_100(struct connection *pc, const struct packet_city_buy *packet)
{
  const struct packet_city_buy *real_packet = packet;
  packet_city_buy_100_fields fields;
  struct packet_city_buy *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_BUY;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_BUY);

  log_packet_detailed("packet_city_buy_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_buy_100, cmp_packet_city_buy_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_BUY);
}

static void ensure_valid_variant_packet_city_buy(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_BUY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_BUY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_BUY] = variant;
}

struct packet_city_buy *receive_packet_city_buy(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_buy at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_buy(pc);

  switch(pc->phs.variant[PACKET_CITY_BUY]) {
  case 100:
    return receive_packet_city_buy_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_BUY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_buy(struct connection *pc, const struct packet_city_buy *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_buy from the server.");
  }
  ensure_valid_variant_packet_city_buy(pc);

  switch(pc->phs.variant[PACKET_CITY_BUY]) {

  case 100:
    return send_packet_city_buy_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_BUY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_buy(struct connection *pc, int city_id)
{
  struct packet_city_buy packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  return send_packet_city_buy(pc, real_packet);
}

#define hash_packet_city_change_100 hash_const

#define cmp_packet_city_change_100 cmp_const

BV_DEFINE(packet_city_change_100_fields, 3);

static struct packet_city_change *receive_packet_city_change_100(struct connection *pc)
{
  packet_city_change_100_fields fields;
  struct packet_city_change *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_CHANGE;
  RECEIVE_PACKET_START(packet_city_change, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_change_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_100, cmp_packet_city_change_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'production_kind'");
    if (!dio_get_uint8(&din, &real_packet->production_kind)) {
      RECEIVE_PACKET_FIELD_ERROR(production_kind);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'production_value'");
    if (!dio_get_uint8(&din, &real_packet->production_value)) {
      RECEIVE_PACKET_FIELD_ERROR(production_value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_100(struct connection *pc, const struct packet_city_change *packet)
{
  const struct packet_city_change *real_packet = packet;
  packet_city_change_100_fields fields;
  struct packet_city_change *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_CHANGE);

  log_packet_detailed("packet_city_change_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_100, cmp_packet_city_change_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->production_kind != real_packet->production_kind);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->production_value != real_packet->production_value);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'production_kind' has changed");
    dio_put_uint8(&dout, real_packet->production_kind);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'production_value' has changed");
    dio_put_uint8(&dout, real_packet->production_value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_CHANGE);
}

static void ensure_valid_variant_packet_city_change(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_CHANGE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_CHANGE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_CHANGE] = variant;
}

struct packet_city_change *receive_packet_city_change(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_change at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_change(pc);

  switch(pc->phs.variant[PACKET_CITY_CHANGE]) {
  case 100:
    return receive_packet_city_change_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_CHANGE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_change(struct connection *pc, const struct packet_city_change *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_change from the server.");
  }
  ensure_valid_variant_packet_city_change(pc);

  switch(pc->phs.variant[PACKET_CITY_CHANGE]) {

  case 100:
    return send_packet_city_change_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_CHANGE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_change(struct connection *pc, int city_id, int production_kind, int production_value)
{
  struct packet_city_change packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->production_kind = production_kind;
  real_packet->production_value = production_value;
  
  return send_packet_city_change(pc, real_packet);
}

#define hash_packet_city_worklist_100 hash_const

#define cmp_packet_city_worklist_100 cmp_const

BV_DEFINE(packet_city_worklist_100_fields, 2);

static struct packet_city_worklist *receive_packet_city_worklist_100(struct connection *pc)
{
  packet_city_worklist_100_fields fields;
  struct packet_city_worklist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_WORKLIST;
  RECEIVE_PACKET_START(packet_city_worklist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_worklist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_100, cmp_packet_city_worklist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worklist'");
    if (!dio_get_worklist(&din, &real_packet->worklist)) {
      RECEIVE_PACKET_FIELD_ERROR(worklist);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_worklist_100(struct connection *pc, const struct packet_city_worklist *packet)
{
  const struct packet_city_worklist *real_packet = packet;
  packet_city_worklist_100_fields fields;
  struct packet_city_worklist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_WORKLIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_WORKLIST);

  log_packet_detailed("packet_city_worklist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_worklist_100, cmp_packet_city_worklist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = !are_worklists_equal(&old->worklist, &real_packet->worklist);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worklist' has changed");
    dio_put_worklist(&dout, &real_packet->worklist);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_WORKLIST);
}

static void ensure_valid_variant_packet_city_worklist(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_WORKLIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_WORKLIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_WORKLIST] = variant;
}

struct packet_city_worklist *receive_packet_city_worklist(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_worklist at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_worklist(pc);

  switch(pc->phs.variant[PACKET_CITY_WORKLIST]) {
  case 100:
    return receive_packet_city_worklist_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_WORKLIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_worklist(struct connection *pc, const struct packet_city_worklist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_worklist from the server.");
  }
  ensure_valid_variant_packet_city_worklist(pc);

  switch(pc->phs.variant[PACKET_CITY_WORKLIST]) {

  case 100:
    return send_packet_city_worklist_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_WORKLIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_worklist(struct connection *pc, int city_id, const struct worklist *worklist)
{
  struct packet_city_worklist packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  worklist_copy(&real_packet->worklist, worklist);
  
  return send_packet_city_worklist(pc, real_packet);
}

#define hash_packet_city_make_specialist_100 hash_const

#define cmp_packet_city_make_specialist_100 cmp_const

BV_DEFINE(packet_city_make_specialist_100_fields, 3);

static struct packet_city_make_specialist *receive_packet_city_make_specialist_100(struct connection *pc)
{
  packet_city_make_specialist_100_fields fields;
  struct packet_city_make_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_MAKE_SPECIALIST;
  RECEIVE_PACKET_START(packet_city_make_specialist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_make_specialist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_100, cmp_packet_city_make_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worker_x'");
    if (!dio_get_uint8(&din, &real_packet->worker_x)) {
      RECEIVE_PACKET_FIELD_ERROR(worker_x);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'worker_y'");
    if (!dio_get_uint8(&din, &real_packet->worker_y)) {
      RECEIVE_PACKET_FIELD_ERROR(worker_y);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_specialist_100(struct connection *pc, const struct packet_city_make_specialist *packet)
{
  const struct packet_city_make_specialist *real_packet = packet;
  packet_city_make_specialist_100_fields fields;
  struct packet_city_make_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_SPECIALIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_MAKE_SPECIALIST);

  log_packet_detailed("packet_city_make_specialist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_specialist_100, cmp_packet_city_make_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->worker_x != real_packet->worker_x);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->worker_y != real_packet->worker_y);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worker_x' has changed");
    dio_put_uint8(&dout, real_packet->worker_x);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'worker_y' has changed");
    dio_put_uint8(&dout, real_packet->worker_y);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_MAKE_SPECIALIST);
}

static void ensure_valid_variant_packet_city_make_specialist(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_MAKE_SPECIALIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_MAKE_SPECIALIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_MAKE_SPECIALIST] = variant;
}

struct packet_city_make_specialist *receive_packet_city_make_specialist(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_make_specialist at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_make_specialist(pc);

  switch(pc->phs.variant[PACKET_CITY_MAKE_SPECIALIST]) {
  case 100:
    return receive_packet_city_make_specialist_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_MAKE_SPECIALIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_make_specialist(struct connection *pc, const struct packet_city_make_specialist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_make_specialist from the server.");
  }
  ensure_valid_variant_packet_city_make_specialist(pc);

  switch(pc->phs.variant[PACKET_CITY_MAKE_SPECIALIST]) {

  case 100:
    return send_packet_city_make_specialist_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_MAKE_SPECIALIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_make_specialist(struct connection *pc, int city_id, int worker_x, int worker_y)
{
  struct packet_city_make_specialist packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->worker_x = worker_x;
  real_packet->worker_y = worker_y;
  
  return send_packet_city_make_specialist(pc, real_packet);
}

#define hash_packet_city_make_worker_100 hash_const

#define cmp_packet_city_make_worker_100 cmp_const

BV_DEFINE(packet_city_make_worker_100_fields, 3);

static struct packet_city_make_worker *receive_packet_city_make_worker_100(struct connection *pc)
{
  packet_city_make_worker_100_fields fields;
  struct packet_city_make_worker *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_MAKE_WORKER;
  RECEIVE_PACKET_START(packet_city_make_worker, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_make_worker_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_100, cmp_packet_city_make_worker_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'worker_x'");
    if (!dio_get_uint8(&din, &real_packet->worker_x)) {
      RECEIVE_PACKET_FIELD_ERROR(worker_x);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'worker_y'");
    if (!dio_get_uint8(&din, &real_packet->worker_y)) {
      RECEIVE_PACKET_FIELD_ERROR(worker_y);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_make_worker_100(struct connection *pc, const struct packet_city_make_worker *packet)
{
  const struct packet_city_make_worker *real_packet = packet;
  packet_city_make_worker_100_fields fields;
  struct packet_city_make_worker *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_MAKE_WORKER;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_MAKE_WORKER);

  log_packet_detailed("packet_city_make_worker_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_make_worker_100, cmp_packet_city_make_worker_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->worker_x != real_packet->worker_x);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->worker_y != real_packet->worker_y);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'worker_x' has changed");
    dio_put_uint8(&dout, real_packet->worker_x);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'worker_y' has changed");
    dio_put_uint8(&dout, real_packet->worker_y);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_MAKE_WORKER);
}

static void ensure_valid_variant_packet_city_make_worker(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_MAKE_WORKER] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_MAKE_WORKER variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_MAKE_WORKER] = variant;
}

struct packet_city_make_worker *receive_packet_city_make_worker(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_make_worker at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_make_worker(pc);

  switch(pc->phs.variant[PACKET_CITY_MAKE_WORKER]) {
  case 100:
    return receive_packet_city_make_worker_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_MAKE_WORKER variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_make_worker(struct connection *pc, const struct packet_city_make_worker *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_make_worker from the server.");
  }
  ensure_valid_variant_packet_city_make_worker(pc);

  switch(pc->phs.variant[PACKET_CITY_MAKE_WORKER]) {

  case 100:
    return send_packet_city_make_worker_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_MAKE_WORKER variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_make_worker(struct connection *pc, int city_id, int worker_x, int worker_y)
{
  struct packet_city_make_worker packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->worker_x = worker_x;
  real_packet->worker_y = worker_y;
  
  return send_packet_city_make_worker(pc, real_packet);
}

#define hash_packet_city_change_specialist_100 hash_const

#define cmp_packet_city_change_specialist_100 cmp_const

BV_DEFINE(packet_city_change_specialist_100_fields, 3);

static struct packet_city_change_specialist *receive_packet_city_change_specialist_100(struct connection *pc)
{
  packet_city_change_specialist_100_fields fields;
  struct packet_city_change_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_CHANGE_SPECIALIST;
  RECEIVE_PACKET_START(packet_city_change_specialist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_change_specialist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_100, cmp_packet_city_change_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'from'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(from);
      }
      real_packet->from = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'to'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(to);
      }
      real_packet->to = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_change_specialist_100(struct connection *pc, const struct packet_city_change_specialist *packet)
{
  const struct packet_city_change_specialist *real_packet = packet;
  packet_city_change_specialist_100_fields fields;
  struct packet_city_change_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_CHANGE_SPECIALIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_CHANGE_SPECIALIST);

  log_packet_detailed("packet_city_change_specialist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_change_specialist_100, cmp_packet_city_change_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->from != real_packet->from);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->to != real_packet->to);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'from' has changed");
    dio_put_uint8(&dout, real_packet->from);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'to' has changed");
    dio_put_uint8(&dout, real_packet->to);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_CHANGE_SPECIALIST);
}

static void ensure_valid_variant_packet_city_change_specialist(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_CHANGE_SPECIALIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_CHANGE_SPECIALIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_CHANGE_SPECIALIST] = variant;
}

struct packet_city_change_specialist *receive_packet_city_change_specialist(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_change_specialist at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_change_specialist(pc);

  switch(pc->phs.variant[PACKET_CITY_CHANGE_SPECIALIST]) {
  case 100:
    return receive_packet_city_change_specialist_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_CHANGE_SPECIALIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_change_specialist(struct connection *pc, const struct packet_city_change_specialist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_change_specialist from the server.");
  }
  ensure_valid_variant_packet_city_change_specialist(pc);

  switch(pc->phs.variant[PACKET_CITY_CHANGE_SPECIALIST]) {

  case 100:
    return send_packet_city_change_specialist_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_CHANGE_SPECIALIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_change_specialist(struct connection *pc, int city_id, Specialist_type_id from, Specialist_type_id to)
{
  struct packet_city_change_specialist packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->from = from;
  real_packet->to = to;
  
  return send_packet_city_change_specialist(pc, real_packet);
}

#define hash_packet_city_rename_100 hash_const

#define cmp_packet_city_rename_100 cmp_const

BV_DEFINE(packet_city_rename_100_fields, 2);

static struct packet_city_rename *receive_packet_city_rename_100(struct connection *pc)
{
  packet_city_rename_100_fields fields;
  struct packet_city_rename *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_RENAME;
  RECEIVE_PACKET_START(packet_city_rename, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_rename_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_100, cmp_packet_city_rename_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_rename_100(struct connection *pc, const struct packet_city_rename *packet)
{
  const struct packet_city_rename *real_packet = packet;
  packet_city_rename_100_fields fields;
  struct packet_city_rename *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_RENAME;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_RENAME);

  log_packet_detailed("packet_city_rename_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_rename_100, cmp_packet_city_rename_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_RENAME);
}

static void ensure_valid_variant_packet_city_rename(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_RENAME] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_RENAME variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_RENAME] = variant;
}

struct packet_city_rename *receive_packet_city_rename(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_rename at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_rename(pc);

  switch(pc->phs.variant[PACKET_CITY_RENAME]) {
  case 100:
    return receive_packet_city_rename_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_RENAME variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_rename(struct connection *pc, const struct packet_city_rename *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_rename from the server.");
  }
  ensure_valid_variant_packet_city_rename(pc);

  switch(pc->phs.variant[PACKET_CITY_RENAME]) {

  case 100:
    return send_packet_city_rename_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_RENAME variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_rename(struct connection *pc, int city_id, const char *name)
{
  struct packet_city_rename packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_city_rename(pc, real_packet);
}

#define hash_packet_city_options_req_100 hash_const

#define cmp_packet_city_options_req_100 cmp_const

BV_DEFINE(packet_city_options_req_100_fields, 2);

static struct packet_city_options_req *receive_packet_city_options_req_100(struct connection *pc)
{
  packet_city_options_req_100_fields fields;
  struct packet_city_options_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_OPTIONS_REQ;
  RECEIVE_PACKET_START(packet_city_options_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_options_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_100, cmp_packet_city_options_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'options'");
    if (!DIO_BV_GET(&din, real_packet->options)) {
      RECEIVE_PACKET_FIELD_ERROR(options);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_options_req_100(struct connection *pc, const struct packet_city_options_req *packet)
{
  const struct packet_city_options_req *real_packet = packet;
  packet_city_options_req_100_fields fields;
  struct packet_city_options_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_OPTIONS_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_OPTIONS_REQ);

  log_packet_detailed("packet_city_options_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_options_req_100, cmp_packet_city_options_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = !BV_ARE_EQUAL(old->options, real_packet->options);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'options' has changed");
  DIO_BV_PUT(&dout, packet->options);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_OPTIONS_REQ);
}

static void ensure_valid_variant_packet_city_options_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_OPTIONS_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_OPTIONS_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_OPTIONS_REQ] = variant;
}

struct packet_city_options_req *receive_packet_city_options_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_options_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_options_req(pc);

  switch(pc->phs.variant[PACKET_CITY_OPTIONS_REQ]) {
  case 100:
    return receive_packet_city_options_req_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_OPTIONS_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_options_req(struct connection *pc, const struct packet_city_options_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_options_req from the server.");
  }
  ensure_valid_variant_packet_city_options_req(pc);

  switch(pc->phs.variant[PACKET_CITY_OPTIONS_REQ]) {

  case 100:
    return send_packet_city_options_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_OPTIONS_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_options_req(struct connection *pc, int city_id, bv_city_options options)
{
  struct packet_city_options_req packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  real_packet->options = options;
  
  return send_packet_city_options_req(pc, real_packet);
}

#define hash_packet_city_refresh_100 hash_const

#define cmp_packet_city_refresh_100 cmp_const

BV_DEFINE(packet_city_refresh_100_fields, 1);

static struct packet_city_refresh *receive_packet_city_refresh_100(struct connection *pc)
{
  packet_city_refresh_100_fields fields;
  struct packet_city_refresh *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_REFRESH;
  RECEIVE_PACKET_START(packet_city_refresh, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_refresh_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_100, cmp_packet_city_refresh_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_refresh_100(struct connection *pc, const struct packet_city_refresh *packet)
{
  const struct packet_city_refresh *real_packet = packet;
  packet_city_refresh_100_fields fields;
  struct packet_city_refresh *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_REFRESH;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_REFRESH);

  log_packet_detailed("packet_city_refresh_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_refresh_100, cmp_packet_city_refresh_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_REFRESH);
}

static void ensure_valid_variant_packet_city_refresh(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_REFRESH] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_REFRESH variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_REFRESH] = variant;
}

struct packet_city_refresh *receive_packet_city_refresh(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_refresh at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_refresh(pc);

  switch(pc->phs.variant[PACKET_CITY_REFRESH]) {
  case 100:
    return receive_packet_city_refresh_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_REFRESH variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_refresh(struct connection *pc, const struct packet_city_refresh *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_refresh from the server.");
  }
  ensure_valid_variant_packet_city_refresh(pc);

  switch(pc->phs.variant[PACKET_CITY_REFRESH]) {

  case 100:
    return send_packet_city_refresh_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_REFRESH variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_refresh(struct connection *pc, int city_id)
{
  struct packet_city_refresh packet, *real_packet = &packet;

  real_packet->city_id = city_id;
  
  return send_packet_city_refresh(pc, real_packet);
}

#define hash_packet_city_name_suggestion_req_100 hash_const

#define cmp_packet_city_name_suggestion_req_100 cmp_const

BV_DEFINE(packet_city_name_suggestion_req_100_fields, 1);

static struct packet_city_name_suggestion_req *receive_packet_city_name_suggestion_req_100(struct connection *pc)
{
  packet_city_name_suggestion_req_100_fields fields;
  struct packet_city_name_suggestion_req *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NAME_SUGGESTION_REQ;
  RECEIVE_PACKET_START(packet_city_name_suggestion_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_name_suggestion_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_100, cmp_packet_city_name_suggestion_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_req_100(struct connection *pc, const struct packet_city_name_suggestion_req *packet)
{
  const struct packet_city_name_suggestion_req *real_packet = packet;
  packet_city_name_suggestion_req_100_fields fields;
  struct packet_city_name_suggestion_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_REQ);

  log_packet_detailed("packet_city_name_suggestion_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_req_100, cmp_packet_city_name_suggestion_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_NAME_SUGGESTION_REQ);
}

static void ensure_valid_variant_packet_city_name_suggestion_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_NAME_SUGGESTION_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_REQ] = variant;
}

struct packet_city_name_suggestion_req *receive_packet_city_name_suggestion_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_city_name_suggestion_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_city_name_suggestion_req(pc);

  switch(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_REQ]) {
  case 100:
    return receive_packet_city_name_suggestion_req_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_NAME_SUGGESTION_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_name_suggestion_req(struct connection *pc, const struct packet_city_name_suggestion_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_city_name_suggestion_req from the server.");
  }
  ensure_valid_variant_packet_city_name_suggestion_req(pc);

  switch(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_REQ]) {

  case 100:
    return send_packet_city_name_suggestion_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_NAME_SUGGESTION_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_city_name_suggestion_req(struct connection *pc, int unit_id)
{
  struct packet_city_name_suggestion_req packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_city_name_suggestion_req(pc, real_packet);
}

#define hash_packet_city_name_suggestion_info_100 hash_const

#define cmp_packet_city_name_suggestion_info_100 cmp_const

BV_DEFINE(packet_city_name_suggestion_info_100_fields, 2);

static struct packet_city_name_suggestion_info *receive_packet_city_name_suggestion_info_100(struct connection *pc)
{
  packet_city_name_suggestion_info_100_fields fields;
  struct packet_city_name_suggestion_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_NAME_SUGGESTION_INFO;
  RECEIVE_PACKET_START(packet_city_name_suggestion_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_name_suggestion_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_100, cmp_packet_city_name_suggestion_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_name_suggestion_info_100(struct connection *pc, const struct packet_city_name_suggestion_info *packet)
{
  const struct packet_city_name_suggestion_info *real_packet = packet;
  packet_city_name_suggestion_info_100_fields fields;
  struct packet_city_name_suggestion_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_NAME_SUGGESTION_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_NAME_SUGGESTION_INFO);

  log_packet_detailed("packet_city_name_suggestion_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_name_suggestion_info_100, cmp_packet_city_name_suggestion_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_NAME_SUGGESTION_INFO);
}

static void ensure_valid_variant_packet_city_name_suggestion_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_NAME_SUGGESTION_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_INFO] = variant;
}

struct packet_city_name_suggestion_info *receive_packet_city_name_suggestion_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_city_name_suggestion_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_city_name_suggestion_info(pc);

  switch(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_INFO]) {
  case 100:
    return receive_packet_city_name_suggestion_info_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_NAME_SUGGESTION_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_name_suggestion_info(struct connection *pc, const struct packet_city_name_suggestion_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_name_suggestion_info from the client.");
  }
  ensure_valid_variant_packet_city_name_suggestion_info(pc);

  switch(pc->phs.variant[PACKET_CITY_NAME_SUGGESTION_INFO]) {

  case 100:
    return send_packet_city_name_suggestion_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_NAME_SUGGESTION_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_name_suggestion_info(struct conn_list *dest, const struct packet_city_name_suggestion_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_name_suggestion_info(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_city_name_suggestion_info(struct connection *pc, int unit_id, const char *name)
{
  struct packet_city_name_suggestion_info packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_city_name_suggestion_info(pc, real_packet);
}

void dlsend_packet_city_name_suggestion_info(struct conn_list *dest, int unit_id, const char *name)
{
  struct packet_city_name_suggestion_info packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  sz_strlcpy(real_packet->name, name);
  
  lsend_packet_city_name_suggestion_info(dest, real_packet);
}

#define hash_packet_city_sabotage_list_100 hash_const

#define cmp_packet_city_sabotage_list_100 cmp_const

BV_DEFINE(packet_city_sabotage_list_100_fields, 3);

static struct packet_city_sabotage_list *receive_packet_city_sabotage_list_100(struct connection *pc)
{
  packet_city_sabotage_list_100_fields fields;
  struct packet_city_sabotage_list *old;
  struct genhash **hash = pc->phs.received + PACKET_CITY_SABOTAGE_LIST;
  RECEIVE_PACKET_START(packet_city_sabotage_list, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_city_sabotage_list_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_100, cmp_packet_city_sabotage_list_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    if (!dio_get_uint16(&din, &real_packet->diplomat_id)) {
      RECEIVE_PACKET_FIELD_ERROR(diplomat_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'improvements'");
    if (!DIO_BV_GET(&din, real_packet->improvements)) {
      RECEIVE_PACKET_FIELD_ERROR(improvements);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_city_sabotage_list_100(struct connection *pc, const struct packet_city_sabotage_list *packet)
{
  const struct packet_city_sabotage_list *real_packet = packet;
  packet_city_sabotage_list_100_fields fields;
  struct packet_city_sabotage_list *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CITY_SABOTAGE_LIST;
  int different = 0;
  SEND_PACKET_START(PACKET_CITY_SABOTAGE_LIST);

  log_packet_detailed("packet_city_sabotage_list_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_city_sabotage_list_100, cmp_packet_city_sabotage_list_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = !BV_ARE_EQUAL(old->improvements, real_packet->improvements);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    dio_put_uint16(&dout, real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'improvements' has changed");
  DIO_BV_PUT(&dout, packet->improvements);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CITY_SABOTAGE_LIST);
}

static void ensure_valid_variant_packet_city_sabotage_list(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CITY_SABOTAGE_LIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CITY_SABOTAGE_LIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CITY_SABOTAGE_LIST] = variant;
}

struct packet_city_sabotage_list *receive_packet_city_sabotage_list(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_city_sabotage_list at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_city_sabotage_list(pc);

  switch(pc->phs.variant[PACKET_CITY_SABOTAGE_LIST]) {
  case 100:
    return receive_packet_city_sabotage_list_100(pc);
  default:
    log_debug("Unknown PACKET_CITY_SABOTAGE_LIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_city_sabotage_list(struct connection *pc, const struct packet_city_sabotage_list *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_city_sabotage_list from the client.");
  }
  ensure_valid_variant_packet_city_sabotage_list(pc);

  switch(pc->phs.variant[PACKET_CITY_SABOTAGE_LIST]) {

  case 100:
    return send_packet_city_sabotage_list_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CITY_SABOTAGE_LIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_city_sabotage_list(struct conn_list *dest, const struct packet_city_sabotage_list *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_city_sabotage_list(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_player_remove_100 hash_const

#define cmp_packet_player_remove_100 cmp_const

BV_DEFINE(packet_player_remove_100_fields, 1);

static struct packet_player_remove *receive_packet_player_remove_100(struct connection *pc)
{
  packet_player_remove_100_fields fields;
  struct packet_player_remove *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_REMOVE;
  RECEIVE_PACKET_START(packet_player_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_remove_100, cmp_packet_player_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'playerno'");
    if (!dio_get_sint8(&din, &real_packet->playerno)) {
      RECEIVE_PACKET_FIELD_ERROR(playerno);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_PLAYER_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_remove_100(struct connection *pc, const struct packet_player_remove *packet)
{
  const struct packet_player_remove *real_packet = packet;
  packet_player_remove_100_fields fields;
  struct packet_player_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_REMOVE);

  log_packet_detailed("packet_player_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_remove_100, cmp_packet_player_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->playerno != real_packet->playerno);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'playerno' has changed");
    dio_put_sint8(&dout, real_packet->playerno);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_PLAYER_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_PLAYER_REMOVE);
}

static void ensure_valid_variant_packet_player_remove(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_REMOVE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_REMOVE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_REMOVE] = variant;
}

struct packet_player_remove *receive_packet_player_remove(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_player_remove at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_player_remove(pc);

  switch(pc->phs.variant[PACKET_PLAYER_REMOVE]) {
  case 100:
    return receive_packet_player_remove_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_REMOVE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_remove(struct connection *pc, const struct packet_player_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_player_remove from the client.");
  }
  ensure_valid_variant_packet_player_remove(pc);

  switch(pc->phs.variant[PACKET_PLAYER_REMOVE]) {

  case 100:
    return send_packet_player_remove_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_REMOVE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_remove(struct connection *pc, int playerno)
{
  struct packet_player_remove packet, *real_packet = &packet;

  real_packet->playerno = playerno;
  
  return send_packet_player_remove(pc, real_packet);
}

static genhash_val_t hash_packet_player_info_100(const void *vkey)
{
  const struct packet_player_info *key = (const struct packet_player_info *) vkey;

  return key->playerno;
}

static bool cmp_packet_player_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_player_info *key1 = (const struct packet_player_info *) vkey1;
  const struct packet_player_info *key2 = (const struct packet_player_info *) vkey2;

  return key1->playerno == key2->playerno;
}

BV_DEFINE(packet_player_info_100_fields, 40);

static struct packet_player_info *receive_packet_player_info_100(struct connection *pc)
{
  packet_player_info_100_fields fields;
  struct packet_player_info *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_INFO;
  RECEIVE_PACKET_START(packet_player_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_sint8(&din, &real_packet->playerno)) {
    RECEIVE_PACKET_FIELD_ERROR(playerno);
  }

  log_packet_detailed("packet_player_info_100: got info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_100, cmp_packet_player_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int playerno = real_packet->playerno;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->playerno = playerno;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'username'");
    if (!dio_get_string(&din, real_packet->username, sizeof(real_packet->username))) {
      RECEIVE_PACKET_FIELD_ERROR(username);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'score'");
    if (!dio_get_uint32(&din, &real_packet->score)) {
      RECEIVE_PACKET_FIELD_ERROR(score);
    }
  }
  real_packet->is_male = BV_ISSET(fields, 3);
  real_packet->was_created = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'government'");
    if (!dio_get_uint8(&din, &real_packet->government)) {
      RECEIVE_PACKET_FIELD_ERROR(government);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'target_government'");
    if (!dio_get_uint8(&din, &real_packet->target_government)) {
      RECEIVE_PACKET_FIELD_ERROR(target_government);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'real_embassy'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        if (!dio_get_bool8(&din, &real_packet->real_embassy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(real_embassy);
        }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'city_style'");
    if (!dio_get_uint8(&din, &real_packet->city_style)) {
      RECEIVE_PACKET_FIELD_ERROR(city_style);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'nation'");
    {
      int readin;
      
      if (!dio_get_sint16(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(nation);
      }
      real_packet->nation = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'team'");
    if (!dio_get_uint8(&din, &real_packet->team)) {
      RECEIVE_PACKET_FIELD_ERROR(team);
    }
  }
  real_packet->is_ready = BV_ISSET(fields, 11);
  real_packet->phase_done = BV_ISSET(fields, 12);
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'nturns_idle'");
    if (!dio_get_sint16(&din, &real_packet->nturns_idle)) {
      RECEIVE_PACKET_FIELD_ERROR(nturns_idle);
    }
  }
  real_packet->is_alive = BV_ISSET(fields, 14);
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'gold'");
    if (!dio_get_uint32(&din, &real_packet->gold)) {
      RECEIVE_PACKET_FIELD_ERROR(gold);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'tax'");
    if (!dio_get_uint8(&din, &real_packet->tax)) {
      RECEIVE_PACKET_FIELD_ERROR(tax);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'science'");
    if (!dio_get_uint8(&din, &real_packet->science)) {
      RECEIVE_PACKET_FIELD_ERROR(science);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'luxury'");
    if (!dio_get_uint8(&din, &real_packet->luxury)) {
      RECEIVE_PACKET_FIELD_ERROR(luxury);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'bulbs_prod'");
    if (!dio_get_sint32(&din, &real_packet->bulbs_prod)) {
      RECEIVE_PACKET_FIELD_ERROR(bulbs_prod);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'bulbs_researched'");
    if (!dio_get_uint32(&din, &real_packet->bulbs_researched)) {
      RECEIVE_PACKET_FIELD_ERROR(bulbs_researched);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'techs_researched'");
    if (!dio_get_uint32(&din, &real_packet->techs_researched)) {
      RECEIVE_PACKET_FIELD_ERROR(techs_researched);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'researching'");
    if (!dio_get_uint8(&din, &real_packet->researching)) {
      RECEIVE_PACKET_FIELD_ERROR(researching);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'researching_cost'");
    if (!dio_get_uint32(&din, &real_packet->researching_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(researching_cost);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'science_cost'");
    if (!dio_get_uint16(&din, &real_packet->science_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(science_cost);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'future_tech'");
    if (!dio_get_uint16(&din, &real_packet->future_tech)) {
      RECEIVE_PACKET_FIELD_ERROR(future_tech);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'tech_goal'");
    if (!dio_get_uint8(&din, &real_packet->tech_goal)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_goal);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'tech_upkeep'");
    if (!dio_get_uint16(&din, &real_packet->tech_upkeep)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_upkeep);
    }
  }
  real_packet->is_connected = BV_ISSET(fields, 28);
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'revolution_finishes'");
    if (!dio_get_sint16(&din, &real_packet->revolution_finishes)) {
      RECEIVE_PACKET_FIELD_ERROR(revolution_finishes);
    }
  }
  real_packet->ai = BV_ISSET(fields, 30);
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'ai_skill_level'");
    if (!dio_get_uint8(&din, &real_packet->ai_skill_level)) {
      RECEIVE_PACKET_FIELD_ERROR(ai_skill_level);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'barbarian_type'");
    if (!dio_get_uint8(&din, &real_packet->barbarian_type)) {
      RECEIVE_PACKET_FIELD_ERROR(barbarian_type);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'gives_shared_vision'");
    if (!DIO_BV_GET(&din, real_packet->gives_shared_vision)) {
      RECEIVE_PACKET_FIELD_ERROR(gives_shared_vision);
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'inventions'");
    if (!dio_get_string(&din, real_packet->inventions, sizeof(real_packet->inventions))) {
      RECEIVE_PACKET_FIELD_ERROR(inventions);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'love'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        if (!dio_get_sint16(&din, &real_packet->love[i])) {
          RECEIVE_PACKET_FIELD_ERROR(love);
        }
      }
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'color_red'");
    if (!dio_get_uint8(&din, &real_packet->color_red)) {
      RECEIVE_PACKET_FIELD_ERROR(color_red);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'color_green'");
    if (!dio_get_uint8(&din, &real_packet->color_green)) {
      RECEIVE_PACKET_FIELD_ERROR(color_green);
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'color_blue'");
    if (!dio_get_uint8(&din, &real_packet->color_blue)) {
      RECEIVE_PACKET_FIELD_ERROR(color_blue);
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'wonders'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        RECEIVE_PACKET_FIELD_ERROR(wonders);
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(wonders,
                                   ": unexpected value %d "
                                   "(> B_LAST) in array diff",
                                   i);
      } else {
        if (!dio_get_sint32(&din, &real_packet->wonders[i])) {
          RECEIVE_PACKET_FIELD_ERROR(wonders);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_info_100(struct connection *pc, const struct packet_player_info *packet)
{
  const struct packet_player_info *real_packet = packet;
  packet_player_info_100_fields fields;
  struct packet_player_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_INFO);

  log_packet_detailed("packet_player_info_100: sending info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_100, cmp_packet_player_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->username, real_packet->username) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->score != real_packet->score);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->is_male != real_packet->is_male);
  if(differ) {
    different++;
  }
  if (packet->is_male) {
    BV_SET(fields, 3);
  }

  differ = (old->was_created != real_packet->was_created);
  if(differ) {
    different++;
  }
  if (packet->was_created) {
    BV_SET(fields, 4);
  }

  differ = (old->government != real_packet->government);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->target_government != real_packet->target_government);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->real_embassy[i] != real_packet->real_embassy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->city_style != real_packet->city_style);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->nation != real_packet->nation);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->team != real_packet->team);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->is_ready != real_packet->is_ready);
  if(differ) {
    different++;
  }
  if (packet->is_ready) {
    BV_SET(fields, 11);
  }

  differ = (old->phase_done != real_packet->phase_done);
  if(differ) {
    different++;
  }
  if (packet->phase_done) {
    BV_SET(fields, 12);
  }

  differ = (old->nturns_idle != real_packet->nturns_idle);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->is_alive != real_packet->is_alive);
  if(differ) {
    different++;
  }
  if (packet->is_alive) {
    BV_SET(fields, 14);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->tax != real_packet->tax);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->science != real_packet->science);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->luxury != real_packet->luxury);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->bulbs_prod != real_packet->bulbs_prod);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->bulbs_researched != real_packet->bulbs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->techs_researched != real_packet->techs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->researching != real_packet->researching);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->researching_cost != real_packet->researching_cost);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->science_cost != real_packet->science_cost);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->future_tech != real_packet->future_tech);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->tech_goal != real_packet->tech_goal);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->tech_upkeep != real_packet->tech_upkeep);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->is_connected != real_packet->is_connected);
  if(differ) {
    different++;
  }
  if (packet->is_connected) {
    BV_SET(fields, 28);
  }

  differ = (old->revolution_finishes != real_packet->revolution_finishes);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 30);
  }

  differ = (old->ai_skill_level != real_packet->ai_skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->barbarian_type != real_packet->barbarian_type);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }

  differ = !BV_ARE_EQUAL(old->gives_shared_vision, real_packet->gives_shared_vision);
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (strcmp(old->inventions, real_packet->inventions) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->love[i] != real_packet->love[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->color_red != real_packet->color_red);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = (old->color_green != real_packet->color_green);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = (old->color_blue != real_packet->color_blue);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->wonders[i] != real_packet->wonders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_sint8(&dout, real_packet->playerno);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'username' has changed");
    dio_put_string(&dout, real_packet->username);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'score' has changed");
    dio_put_uint32(&dout, real_packet->score);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'government' has changed");
    dio_put_uint8(&dout, real_packet->government);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'target_government' has changed");
    dio_put_uint8(&dout, real_packet->target_government);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'real_embassy' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_bool8(&dout, real_packet->real_embassy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'city_style' has changed");
    dio_put_uint8(&dout, real_packet->city_style);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'nation' has changed");
    dio_put_sint16(&dout, real_packet->nation);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'team' has changed");
    dio_put_uint8(&dout, real_packet->team);
  }
  /* field 11 is folded into the header */
  /* field 12 is folded into the header */
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'nturns_idle' has changed");
    dio_put_sint16(&dout, real_packet->nturns_idle);
  }
  /* field 14 is folded into the header */
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'gold' has changed");
    dio_put_uint32(&dout, real_packet->gold);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'tax' has changed");
    dio_put_uint8(&dout, real_packet->tax);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'science' has changed");
    dio_put_uint8(&dout, real_packet->science);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'luxury' has changed");
    dio_put_uint8(&dout, real_packet->luxury);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'bulbs_prod' has changed");
    dio_put_sint32(&dout, real_packet->bulbs_prod);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'bulbs_researched' has changed");
    dio_put_uint32(&dout, real_packet->bulbs_researched);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'techs_researched' has changed");
    dio_put_uint32(&dout, real_packet->techs_researched);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'researching' has changed");
    dio_put_uint8(&dout, real_packet->researching);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'researching_cost' has changed");
    dio_put_uint32(&dout, real_packet->researching_cost);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'science_cost' has changed");
    dio_put_uint16(&dout, real_packet->science_cost);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'future_tech' has changed");
    dio_put_uint16(&dout, real_packet->future_tech);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'tech_goal' has changed");
    dio_put_uint8(&dout, real_packet->tech_goal);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'tech_upkeep' has changed");
    dio_put_uint16(&dout, real_packet->tech_upkeep);
  }
  /* field 28 is folded into the header */
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'revolution_finishes' has changed");
    dio_put_sint16(&dout, real_packet->revolution_finishes);
  }
  /* field 30 is folded into the header */
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'ai_skill_level' has changed");
    dio_put_uint8(&dout, real_packet->ai_skill_level);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'barbarian_type' has changed");
    dio_put_uint8(&dout, real_packet->barbarian_type);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'gives_shared_vision' has changed");
  DIO_BV_PUT(&dout, packet->gives_shared_vision);
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'inventions' has changed");
    dio_put_string(&dout, real_packet->inventions);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'love' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_sint16(&dout, real_packet->love[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'color_red' has changed");
    dio_put_uint8(&dout, real_packet->color_red);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'color_green' has changed");
    dio_put_uint8(&dout, real_packet->color_green);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'color_blue' has changed");
    dio_put_uint8(&dout, real_packet->color_blue);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'wonders' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->wonders[i] != real_packet->wonders[i]) {
          dio_put_uint8(&dout, i);
          dio_put_sint32(&dout, real_packet->wonders[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_INFO);
}

static genhash_val_t hash_packet_player_info_101(const void *vkey)
{
  const struct packet_player_info *key = (const struct packet_player_info *) vkey;

  return key->playerno;
}

static bool cmp_packet_player_info_101(const void *vkey1, const void *vkey2)
{
  const struct packet_player_info *key1 = (const struct packet_player_info *) vkey1;
  const struct packet_player_info *key2 = (const struct packet_player_info *) vkey2;

  return key1->playerno == key2->playerno;
}

BV_DEFINE(packet_player_info_101_fields, 38);

static struct packet_player_info *receive_packet_player_info_101(struct connection *pc)
{
  packet_player_info_101_fields fields;
  struct packet_player_info *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_INFO;
  RECEIVE_PACKET_START(packet_player_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_sint8(&din, &real_packet->playerno)) {
    RECEIVE_PACKET_FIELD_ERROR(playerno);
  }

  log_packet_detailed("packet_player_info_101: got info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_101, cmp_packet_player_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int playerno = real_packet->playerno;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->playerno = playerno;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'username'");
    if (!dio_get_string(&din, real_packet->username, sizeof(real_packet->username))) {
      RECEIVE_PACKET_FIELD_ERROR(username);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'score'");
    if (!dio_get_uint32(&din, &real_packet->score)) {
      RECEIVE_PACKET_FIELD_ERROR(score);
    }
  }
  real_packet->is_male = BV_ISSET(fields, 3);
  real_packet->was_created = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'government'");
    if (!dio_get_uint8(&din, &real_packet->government)) {
      RECEIVE_PACKET_FIELD_ERROR(government);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'target_government'");
    if (!dio_get_uint8(&din, &real_packet->target_government)) {
      RECEIVE_PACKET_FIELD_ERROR(target_government);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'real_embassy'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        if (!dio_get_bool8(&din, &real_packet->real_embassy[i])) {
          RECEIVE_PACKET_FIELD_ERROR(real_embassy);
        }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'city_style'");
    if (!dio_get_uint8(&din, &real_packet->city_style)) {
      RECEIVE_PACKET_FIELD_ERROR(city_style);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'nation'");
    {
      int readin;
      
      if (!dio_get_sint16(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(nation);
      }
      real_packet->nation = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'team'");
    if (!dio_get_uint8(&din, &real_packet->team)) {
      RECEIVE_PACKET_FIELD_ERROR(team);
    }
  }
  real_packet->is_ready = BV_ISSET(fields, 11);
  real_packet->phase_done = BV_ISSET(fields, 12);
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'nturns_idle'");
    if (!dio_get_sint16(&din, &real_packet->nturns_idle)) {
      RECEIVE_PACKET_FIELD_ERROR(nturns_idle);
    }
  }
  real_packet->is_alive = BV_ISSET(fields, 14);
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'gold'");
    if (!dio_get_uint32(&din, &real_packet->gold)) {
      RECEIVE_PACKET_FIELD_ERROR(gold);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'tax'");
    if (!dio_get_uint8(&din, &real_packet->tax)) {
      RECEIVE_PACKET_FIELD_ERROR(tax);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'science'");
    if (!dio_get_uint8(&din, &real_packet->science)) {
      RECEIVE_PACKET_FIELD_ERROR(science);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'luxury'");
    if (!dio_get_uint8(&din, &real_packet->luxury)) {
      RECEIVE_PACKET_FIELD_ERROR(luxury);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'bulbs_prod'");
    if (!dio_get_sint32(&din, &real_packet->bulbs_prod)) {
      RECEIVE_PACKET_FIELD_ERROR(bulbs_prod);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'bulbs_researched'");
    if (!dio_get_uint32(&din, &real_packet->bulbs_researched)) {
      RECEIVE_PACKET_FIELD_ERROR(bulbs_researched);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'techs_researched'");
    if (!dio_get_uint32(&din, &real_packet->techs_researched)) {
      RECEIVE_PACKET_FIELD_ERROR(techs_researched);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'researching'");
    if (!dio_get_uint8(&din, &real_packet->researching)) {
      RECEIVE_PACKET_FIELD_ERROR(researching);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'science_cost'");
    if (!dio_get_uint16(&din, &real_packet->science_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(science_cost);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'future_tech'");
    if (!dio_get_uint16(&din, &real_packet->future_tech)) {
      RECEIVE_PACKET_FIELD_ERROR(future_tech);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'tech_goal'");
    if (!dio_get_uint8(&din, &real_packet->tech_goal)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_goal);
    }
  }
  real_packet->is_connected = BV_ISSET(fields, 26);
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'revolution_finishes'");
    if (!dio_get_sint16(&din, &real_packet->revolution_finishes)) {
      RECEIVE_PACKET_FIELD_ERROR(revolution_finishes);
    }
  }
  real_packet->ai = BV_ISSET(fields, 28);
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'ai_skill_level'");
    if (!dio_get_uint8(&din, &real_packet->ai_skill_level)) {
      RECEIVE_PACKET_FIELD_ERROR(ai_skill_level);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'barbarian_type'");
    if (!dio_get_uint8(&din, &real_packet->barbarian_type)) {
      RECEIVE_PACKET_FIELD_ERROR(barbarian_type);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'gives_shared_vision'");
    if (!DIO_BV_GET(&din, real_packet->gives_shared_vision)) {
      RECEIVE_PACKET_FIELD_ERROR(gives_shared_vision);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'inventions'");
    if (!dio_get_string(&din, real_packet->inventions, sizeof(real_packet->inventions))) {
      RECEIVE_PACKET_FIELD_ERROR(inventions);
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'love'");
    
    {
      int i;
    
      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        if (!dio_get_sint16(&din, &real_packet->love[i])) {
          RECEIVE_PACKET_FIELD_ERROR(love);
        }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'color_red'");
    if (!dio_get_uint8(&din, &real_packet->color_red)) {
      RECEIVE_PACKET_FIELD_ERROR(color_red);
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'color_green'");
    if (!dio_get_uint8(&din, &real_packet->color_green)) {
      RECEIVE_PACKET_FIELD_ERROR(color_green);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'color_blue'");
    if (!dio_get_uint8(&din, &real_packet->color_blue)) {
      RECEIVE_PACKET_FIELD_ERROR(color_blue);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'wonders'");
    
    for (;;) {
      int i;
    
      if (!dio_get_uint8(&din, &i)) {
        RECEIVE_PACKET_FIELD_ERROR(wonders);
      }
      if (i == 255) {
        break;
      }
      if (i > B_LAST) {
        RECEIVE_PACKET_FIELD_ERROR(wonders,
                                   ": unexpected value %d "
                                   "(> B_LAST) in array diff",
                                   i);
      } else {
        if (!dio_get_sint32(&din, &real_packet->wonders[i])) {
          RECEIVE_PACKET_FIELD_ERROR(wonders);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_info_101(struct connection *pc, const struct packet_player_info *packet)
{
  const struct packet_player_info *real_packet = packet;
  packet_player_info_101_fields fields;
  struct packet_player_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_INFO);

  log_packet_detailed("packet_player_info_101: sending info about (%d)",
    real_packet->playerno);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_info_101, cmp_packet_player_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->username, real_packet->username) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->score != real_packet->score);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->is_male != real_packet->is_male);
  if(differ) {
    different++;
  }
  if (packet->is_male) {
    BV_SET(fields, 3);
  }

  differ = (old->was_created != real_packet->was_created);
  if(differ) {
    different++;
  }
  if (packet->was_created) {
    BV_SET(fields, 4);
  }

  differ = (old->government != real_packet->government);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->target_government != real_packet->target_government);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->real_embassy[i] != real_packet->real_embassy[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->city_style != real_packet->city_style);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->nation != real_packet->nation);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->team != real_packet->team);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->is_ready != real_packet->is_ready);
  if(differ) {
    different++;
  }
  if (packet->is_ready) {
    BV_SET(fields, 11);
  }

  differ = (old->phase_done != real_packet->phase_done);
  if(differ) {
    different++;
  }
  if (packet->phase_done) {
    BV_SET(fields, 12);
  }

  differ = (old->nturns_idle != real_packet->nturns_idle);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->is_alive != real_packet->is_alive);
  if(differ) {
    different++;
  }
  if (packet->is_alive) {
    BV_SET(fields, 14);
  }

  differ = (old->gold != real_packet->gold);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->tax != real_packet->tax);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->science != real_packet->science);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->luxury != real_packet->luxury);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->bulbs_prod != real_packet->bulbs_prod);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->bulbs_researched != real_packet->bulbs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->techs_researched != real_packet->techs_researched);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->researching != real_packet->researching);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->science_cost != real_packet->science_cost);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->future_tech != real_packet->future_tech);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->tech_goal != real_packet->tech_goal);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->is_connected != real_packet->is_connected);
  if(differ) {
    different++;
  }
  if (packet->is_connected) {
    BV_SET(fields, 26);
  }

  differ = (old->revolution_finishes != real_packet->revolution_finishes);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 28);
  }

  differ = (old->ai_skill_level != real_packet->ai_skill_level);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->barbarian_type != real_packet->barbarian_type);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = !BV_ARE_EQUAL(old->gives_shared_vision, real_packet->gives_shared_vision);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (strcmp(old->inventions, real_packet->inventions) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (MAX_NUM_PLAYER_SLOTS != MAX_NUM_PLAYER_SLOTS);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
          if (old->love[i] != real_packet->love[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }

  differ = (old->color_red != real_packet->color_red);
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->color_green != real_packet->color_green);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->color_blue != real_packet->color_blue);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }


    {
      differ = (B_LAST != B_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < B_LAST; i++) {
          if (old->wonders[i] != real_packet->wonders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_sint8(&dout, real_packet->playerno);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'username' has changed");
    dio_put_string(&dout, real_packet->username);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'score' has changed");
    dio_put_uint32(&dout, real_packet->score);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'government' has changed");
    dio_put_uint8(&dout, real_packet->government);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'target_government' has changed");
    dio_put_uint8(&dout, real_packet->target_government);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'real_embassy' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_bool8(&dout, real_packet->real_embassy[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'city_style' has changed");
    dio_put_uint8(&dout, real_packet->city_style);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'nation' has changed");
    dio_put_sint16(&dout, real_packet->nation);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'team' has changed");
    dio_put_uint8(&dout, real_packet->team);
  }
  /* field 11 is folded into the header */
  /* field 12 is folded into the header */
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'nturns_idle' has changed");
    dio_put_sint16(&dout, real_packet->nturns_idle);
  }
  /* field 14 is folded into the header */
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'gold' has changed");
    dio_put_uint32(&dout, real_packet->gold);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'tax' has changed");
    dio_put_uint8(&dout, real_packet->tax);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'science' has changed");
    dio_put_uint8(&dout, real_packet->science);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'luxury' has changed");
    dio_put_uint8(&dout, real_packet->luxury);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'bulbs_prod' has changed");
    dio_put_sint32(&dout, real_packet->bulbs_prod);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'bulbs_researched' has changed");
    dio_put_uint32(&dout, real_packet->bulbs_researched);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'techs_researched' has changed");
    dio_put_uint32(&dout, real_packet->techs_researched);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'researching' has changed");
    dio_put_uint8(&dout, real_packet->researching);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'science_cost' has changed");
    dio_put_uint16(&dout, real_packet->science_cost);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'future_tech' has changed");
    dio_put_uint16(&dout, real_packet->future_tech);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'tech_goal' has changed");
    dio_put_uint8(&dout, real_packet->tech_goal);
  }
  /* field 26 is folded into the header */
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'revolution_finishes' has changed");
    dio_put_sint16(&dout, real_packet->revolution_finishes);
  }
  /* field 28 is folded into the header */
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'ai_skill_level' has changed");
    dio_put_uint8(&dout, real_packet->ai_skill_level);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'barbarian_type' has changed");
    dio_put_uint8(&dout, real_packet->barbarian_type);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'gives_shared_vision' has changed");
  DIO_BV_PUT(&dout, packet->gives_shared_vision);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'inventions' has changed");
    dio_put_string(&dout, real_packet->inventions);
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'love' has changed");
  
    {
      int i;

      for (i = 0; i < MAX_NUM_PLAYER_SLOTS; i++) {
        dio_put_sint16(&dout, real_packet->love[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'color_red' has changed");
    dio_put_uint8(&dout, real_packet->color_red);
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'color_green' has changed");
    dio_put_uint8(&dout, real_packet->color_green);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'color_blue' has changed");
    dio_put_uint8(&dout, real_packet->color_blue);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'wonders' has changed");
  
    {
      int i;

      fc_assert(B_LAST < 255);

      for (i = 0; i < B_LAST; i++) {
        if(old->wonders[i] != real_packet->wonders[i]) {
          dio_put_uint8(&dout, i);
          dio_put_sint32(&dout, real_packet->wonders[i]);
        }
      }
      dio_put_uint8(&dout, 255);
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_INFO);
}

static void ensure_valid_variant_packet_player_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if((has_capability("tech_cost", pc->capability) && has_capability("tech_cost", our_capability))) {
    variant = 100;
  } else if(!(has_capability("tech_cost", pc->capability) && has_capability("tech_cost", our_capability))) {
    variant = 101;
  } else {
    log_error("Unknown PACKET_PLAYER_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  log_packet_detailed("packet_player_info: using variant=%d cap=%s", variant, pc->capability);
  pc->phs.variant[PACKET_PLAYER_INFO] = variant;
}

struct packet_player_info *receive_packet_player_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_player_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_player_info(pc);

  switch(pc->phs.variant[PACKET_PLAYER_INFO]) {
  case 100:
    return receive_packet_player_info_100(pc);
  case 101:
    return receive_packet_player_info_101(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_info(struct connection *pc, const struct packet_player_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_player_info from the client.");
  }
  ensure_valid_variant_packet_player_info(pc);

  switch(pc->phs.variant[PACKET_PLAYER_INFO]) {

  case 100:
    return send_packet_player_info_100(pc, packet);
  case 101:
    return send_packet_player_info_101(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_player_phase_done_100 hash_const

#define cmp_packet_player_phase_done_100 cmp_const

BV_DEFINE(packet_player_phase_done_100_fields, 1);

static struct packet_player_phase_done *receive_packet_player_phase_done_100(struct connection *pc)
{
  packet_player_phase_done_100_fields fields;
  struct packet_player_phase_done *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_PHASE_DONE;
  RECEIVE_PACKET_START(packet_player_phase_done, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_phase_done_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_phase_done_100, cmp_packet_player_phase_done_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'turn'");
    if (!dio_get_sint16(&din, &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_phase_done_100(struct connection *pc, const struct packet_player_phase_done *packet)
{
  const struct packet_player_phase_done *real_packet = packet;
  packet_player_phase_done_100_fields fields;
  struct packet_player_phase_done *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_PHASE_DONE;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_PHASE_DONE);

  log_packet_detailed("packet_player_phase_done_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_phase_done_100, cmp_packet_player_phase_done_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'turn' has changed");
    dio_put_sint16(&dout, real_packet->turn);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_PHASE_DONE);
}

static void ensure_valid_variant_packet_player_phase_done(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_PHASE_DONE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_PHASE_DONE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_PHASE_DONE] = variant;
}

struct packet_player_phase_done *receive_packet_player_phase_done(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_player_phase_done at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_player_phase_done(pc);

  switch(pc->phs.variant[PACKET_PLAYER_PHASE_DONE]) {
  case 100:
    return receive_packet_player_phase_done_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_PHASE_DONE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_phase_done(struct connection *pc, const struct packet_player_phase_done *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_phase_done from the server.");
  }
  ensure_valid_variant_packet_player_phase_done(pc);

  switch(pc->phs.variant[PACKET_PLAYER_PHASE_DONE]) {

  case 100:
    return send_packet_player_phase_done_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_PHASE_DONE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_phase_done(struct connection *pc, int turn)
{
  struct packet_player_phase_done packet, *real_packet = &packet;

  real_packet->turn = turn;
  
  return send_packet_player_phase_done(pc, real_packet);
}

#define hash_packet_player_rates_100 hash_const

#define cmp_packet_player_rates_100 cmp_const

BV_DEFINE(packet_player_rates_100_fields, 3);

static struct packet_player_rates *receive_packet_player_rates_100(struct connection *pc)
{
  packet_player_rates_100_fields fields;
  struct packet_player_rates *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_RATES;
  RECEIVE_PACKET_START(packet_player_rates, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_rates_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_rates_100, cmp_packet_player_rates_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tax'");
    if (!dio_get_uint8(&din, &real_packet->tax)) {
      RECEIVE_PACKET_FIELD_ERROR(tax);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'luxury'");
    if (!dio_get_uint8(&din, &real_packet->luxury)) {
      RECEIVE_PACKET_FIELD_ERROR(luxury);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'science'");
    if (!dio_get_uint8(&din, &real_packet->science)) {
      RECEIVE_PACKET_FIELD_ERROR(science);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_rates_100(struct connection *pc, const struct packet_player_rates *packet)
{
  const struct packet_player_rates *real_packet = packet;
  packet_player_rates_100_fields fields;
  struct packet_player_rates *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_RATES;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_RATES);

  log_packet_detailed("packet_player_rates_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_rates_100, cmp_packet_player_rates_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tax != real_packet->tax);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->luxury != real_packet->luxury);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->science != real_packet->science);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tax' has changed");
    dio_put_uint8(&dout, real_packet->tax);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'luxury' has changed");
    dio_put_uint8(&dout, real_packet->luxury);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'science' has changed");
    dio_put_uint8(&dout, real_packet->science);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_RATES);
}

static void ensure_valid_variant_packet_player_rates(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_RATES] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_RATES variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_RATES] = variant;
}

struct packet_player_rates *receive_packet_player_rates(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_player_rates at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_player_rates(pc);

  switch(pc->phs.variant[PACKET_PLAYER_RATES]) {
  case 100:
    return receive_packet_player_rates_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_RATES variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_rates(struct connection *pc, const struct packet_player_rates *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_rates from the server.");
  }
  ensure_valid_variant_packet_player_rates(pc);

  switch(pc->phs.variant[PACKET_PLAYER_RATES]) {

  case 100:
    return send_packet_player_rates_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_RATES variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_rates(struct connection *pc, int tax, int luxury, int science)
{
  struct packet_player_rates packet, *real_packet = &packet;

  real_packet->tax = tax;
  real_packet->luxury = luxury;
  real_packet->science = science;
  
  return send_packet_player_rates(pc, real_packet);
}

#define hash_packet_player_change_government_100 hash_const

#define cmp_packet_player_change_government_100 cmp_const

BV_DEFINE(packet_player_change_government_100_fields, 1);

static struct packet_player_change_government *receive_packet_player_change_government_100(struct connection *pc)
{
  packet_player_change_government_100_fields fields;
  struct packet_player_change_government *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_CHANGE_GOVERNMENT;
  RECEIVE_PACKET_START(packet_player_change_government, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_change_government_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_change_government_100, cmp_packet_player_change_government_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'government'");
    if (!dio_get_uint8(&din, &real_packet->government)) {
      RECEIVE_PACKET_FIELD_ERROR(government);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_change_government_100(struct connection *pc, const struct packet_player_change_government *packet)
{
  const struct packet_player_change_government *real_packet = packet;
  packet_player_change_government_100_fields fields;
  struct packet_player_change_government *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_CHANGE_GOVERNMENT;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_CHANGE_GOVERNMENT);

  log_packet_detailed("packet_player_change_government_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_change_government_100, cmp_packet_player_change_government_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->government != real_packet->government);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'government' has changed");
    dio_put_uint8(&dout, real_packet->government);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_CHANGE_GOVERNMENT);
}

static void ensure_valid_variant_packet_player_change_government(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_CHANGE_GOVERNMENT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_CHANGE_GOVERNMENT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_CHANGE_GOVERNMENT] = variant;
}

struct packet_player_change_government *receive_packet_player_change_government(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_player_change_government at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_player_change_government(pc);

  switch(pc->phs.variant[PACKET_PLAYER_CHANGE_GOVERNMENT]) {
  case 100:
    return receive_packet_player_change_government_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_CHANGE_GOVERNMENT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_change_government(struct connection *pc, const struct packet_player_change_government *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_change_government from the server.");
  }
  ensure_valid_variant_packet_player_change_government(pc);

  switch(pc->phs.variant[PACKET_PLAYER_CHANGE_GOVERNMENT]) {

  case 100:
    return send_packet_player_change_government_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_CHANGE_GOVERNMENT variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_change_government(struct connection *pc, int government)
{
  struct packet_player_change_government packet, *real_packet = &packet;

  real_packet->government = government;
  
  return send_packet_player_change_government(pc, real_packet);
}

#define hash_packet_player_research_100 hash_const

#define cmp_packet_player_research_100 cmp_const

BV_DEFINE(packet_player_research_100_fields, 1);

static struct packet_player_research *receive_packet_player_research_100(struct connection *pc)
{
  packet_player_research_100_fields fields;
  struct packet_player_research *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_RESEARCH;
  RECEIVE_PACKET_START(packet_player_research, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_research_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_research_100, cmp_packet_player_research_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tech'");
    if (!dio_get_uint8(&din, &real_packet->tech)) {
      RECEIVE_PACKET_FIELD_ERROR(tech);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_research_100(struct connection *pc, const struct packet_player_research *packet)
{
  const struct packet_player_research *real_packet = packet;
  packet_player_research_100_fields fields;
  struct packet_player_research *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_RESEARCH;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_RESEARCH);

  log_packet_detailed("packet_player_research_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_research_100, cmp_packet_player_research_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tech' has changed");
    dio_put_uint8(&dout, real_packet->tech);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_RESEARCH);
}

static void ensure_valid_variant_packet_player_research(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_RESEARCH] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_RESEARCH variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_RESEARCH] = variant;
}

struct packet_player_research *receive_packet_player_research(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_player_research at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_player_research(pc);

  switch(pc->phs.variant[PACKET_PLAYER_RESEARCH]) {
  case 100:
    return receive_packet_player_research_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_RESEARCH variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_research(struct connection *pc, const struct packet_player_research *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_research from the server.");
  }
  ensure_valid_variant_packet_player_research(pc);

  switch(pc->phs.variant[PACKET_PLAYER_RESEARCH]) {

  case 100:
    return send_packet_player_research_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_RESEARCH variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_research(struct connection *pc, int tech)
{
  struct packet_player_research packet, *real_packet = &packet;

  real_packet->tech = tech;
  
  return send_packet_player_research(pc, real_packet);
}

#define hash_packet_player_tech_goal_100 hash_const

#define cmp_packet_player_tech_goal_100 cmp_const

BV_DEFINE(packet_player_tech_goal_100_fields, 1);

static struct packet_player_tech_goal *receive_packet_player_tech_goal_100(struct connection *pc)
{
  packet_player_tech_goal_100_fields fields;
  struct packet_player_tech_goal *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_TECH_GOAL;
  RECEIVE_PACKET_START(packet_player_tech_goal, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_player_tech_goal_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_tech_goal_100, cmp_packet_player_tech_goal_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tech'");
    if (!dio_get_uint8(&din, &real_packet->tech)) {
      RECEIVE_PACKET_FIELD_ERROR(tech);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_tech_goal_100(struct connection *pc, const struct packet_player_tech_goal *packet)
{
  const struct packet_player_tech_goal *real_packet = packet;
  packet_player_tech_goal_100_fields fields;
  struct packet_player_tech_goal *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_TECH_GOAL;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_TECH_GOAL);

  log_packet_detailed("packet_player_tech_goal_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_tech_goal_100, cmp_packet_player_tech_goal_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tech' has changed");
    dio_put_uint8(&dout, real_packet->tech);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_TECH_GOAL);
}

static void ensure_valid_variant_packet_player_tech_goal(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_TECH_GOAL] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_TECH_GOAL variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_TECH_GOAL] = variant;
}

struct packet_player_tech_goal *receive_packet_player_tech_goal(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_player_tech_goal at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_player_tech_goal(pc);

  switch(pc->phs.variant[PACKET_PLAYER_TECH_GOAL]) {
  case 100:
    return receive_packet_player_tech_goal_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_TECH_GOAL variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_tech_goal(struct connection *pc, const struct packet_player_tech_goal *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_tech_goal from the server.");
  }
  ensure_valid_variant_packet_player_tech_goal(pc);

  switch(pc->phs.variant[PACKET_PLAYER_TECH_GOAL]) {

  case 100:
    return send_packet_player_tech_goal_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_TECH_GOAL variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_player_tech_goal(struct connection *pc, int tech)
{
  struct packet_player_tech_goal packet, *real_packet = &packet;

  real_packet->tech = tech;
  
  return send_packet_player_tech_goal(pc, real_packet);
}

#define hash_packet_tech_gained_100 hash_const

#define cmp_packet_tech_gained_100 cmp_const

BV_DEFINE(packet_tech_gained_100_fields, 1);

static struct packet_tech_gained *receive_packet_tech_gained_100(struct connection *pc)
{
  packet_tech_gained_100_fields fields;
  struct packet_tech_gained *old;
  struct genhash **hash = pc->phs.received + PACKET_TECH_GAINED;
  RECEIVE_PACKET_START(packet_tech_gained, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_tech_gained_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tech_gained_100, cmp_packet_tech_gained_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'tech'");
    if (!dio_get_uint8(&din, &real_packet->tech)) {
      RECEIVE_PACKET_FIELD_ERROR(tech);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_tech_gained_100(struct connection *pc, const struct packet_tech_gained *packet)
{
  const struct packet_tech_gained *real_packet = packet;
  packet_tech_gained_100_fields fields;
  struct packet_tech_gained *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_TECH_GAINED;
  int different = 0;
  SEND_PACKET_START(PACKET_TECH_GAINED);

  log_packet_detailed("packet_tech_gained_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_tech_gained_100, cmp_packet_tech_gained_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->tech != real_packet->tech);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'tech' has changed");
    dio_put_uint8(&dout, real_packet->tech);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_TECH_GAINED);
}

static void ensure_valid_variant_packet_tech_gained(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_TECH_GAINED] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_TECH_GAINED variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_TECH_GAINED] = variant;
}

struct packet_tech_gained *receive_packet_tech_gained(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_tech_gained at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_tech_gained(pc);

  switch(pc->phs.variant[PACKET_TECH_GAINED]) {
  case 100:
    return receive_packet_tech_gained_100(pc);
  default:
    log_debug("Unknown PACKET_TECH_GAINED variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_tech_gained(struct connection *pc, const struct packet_tech_gained *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_tech_gained from the client.");
  }
  ensure_valid_variant_packet_tech_gained(pc);

  switch(pc->phs.variant[PACKET_TECH_GAINED]) {

  case 100:
    return send_packet_tech_gained_100(pc, packet);
  default:
    log_debug("Unknown PACKET_TECH_GAINED variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_tech_gained(struct connection *pc, int tech)
{
  struct packet_tech_gained packet, *real_packet = &packet;

  real_packet->tech = tech;
  
  return send_packet_tech_gained(pc, real_packet);
}

static struct packet_player_attribute_block *receive_packet_player_attribute_block_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_player_attribute_block, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_player_attribute_block_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_attribute_block_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_PLAYER_ATTRIBUTE_BLOCK);

  log_packet_detailed("packet_player_attribute_block_100: sending info about ()");
  SEND_PACKET_END(PACKET_PLAYER_ATTRIBUTE_BLOCK);
}

static void ensure_valid_variant_packet_player_attribute_block(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_BLOCK] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_ATTRIBUTE_BLOCK variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_BLOCK] = variant;
}

struct packet_player_attribute_block *receive_packet_player_attribute_block(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_player_attribute_block at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_player_attribute_block(pc);

  switch(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_BLOCK]) {
  case 100:
    return receive_packet_player_attribute_block_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_ATTRIBUTE_BLOCK variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_attribute_block(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_player_attribute_block from the server.");
  }
  ensure_valid_variant_packet_player_attribute_block(pc);

  switch(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_BLOCK]) {

  case 100:
    return send_packet_player_attribute_block_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_ATTRIBUTE_BLOCK variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_player_attribute_chunk_100(const void *vkey)
{
  const struct packet_player_attribute_chunk *key = (const struct packet_player_attribute_chunk *) vkey;

  return key->offset;
}

static bool cmp_packet_player_attribute_chunk_100(const void *vkey1, const void *vkey2)
{
  const struct packet_player_attribute_chunk *key1 = (const struct packet_player_attribute_chunk *) vkey1;
  const struct packet_player_attribute_chunk *key2 = (const struct packet_player_attribute_chunk *) vkey2;

  return key1->offset == key2->offset;
}

BV_DEFINE(packet_player_attribute_chunk_100_fields, 3);

static struct packet_player_attribute_chunk *receive_packet_player_attribute_chunk_100(struct connection *pc)
{
  packet_player_attribute_chunk_100_fields fields;
  struct packet_player_attribute_chunk *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_ATTRIBUTE_CHUNK;
  RECEIVE_PACKET_START(packet_player_attribute_chunk, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_uint32(&din, &real_packet->offset)) {
    RECEIVE_PACKET_FIELD_ERROR(offset);
  }

  log_packet_detailed("packet_player_attribute_chunk_100: got info about (%d)",
    real_packet->offset);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_attribute_chunk_100, cmp_packet_player_attribute_chunk_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int offset = real_packet->offset;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->offset = offset;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'total_length'");
    if (!dio_get_uint32(&din, &real_packet->total_length)) {
      RECEIVE_PACKET_FIELD_ERROR(total_length);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'chunk_length'");
    if (!dio_get_uint32(&din, &real_packet->chunk_length)) {
      RECEIVE_PACKET_FIELD_ERROR(chunk_length);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'data'");
    
      if (real_packet->chunk_length > ATTRIBUTE_CHUNK_SIZE) {
        RECEIVE_PACKET_FIELD_ERROR(data, ": truncation array");
      }
      if (!dio_get_memory(&din, real_packet->data, real_packet->chunk_length)){
        RECEIVE_PACKET_FIELD_ERROR(data);
      }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_attribute_chunk_100(struct connection *pc, const struct packet_player_attribute_chunk *packet)
{
  const struct packet_player_attribute_chunk *real_packet = packet;
  packet_player_attribute_chunk_100_fields fields;
  struct packet_player_attribute_chunk *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_ATTRIBUTE_CHUNK;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_ATTRIBUTE_CHUNK);

  log_packet_detailed("packet_player_attribute_chunk_100: sending info about (%d)",
    real_packet->offset);

  {
    struct packet_player_attribute_chunk *tmp = fc_malloc(sizeof(*tmp));

    *tmp = *packet;
    pre_send_packet_player_attribute_chunk(pc, tmp);
    real_packet = tmp;
  }

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_attribute_chunk_100, cmp_packet_player_attribute_chunk_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->total_length != real_packet->total_length);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->chunk_length != real_packet->chunk_length);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (memcmp(old->data, real_packet->data, ATTRIBUTE_CHUNK_SIZE) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_uint32(&dout, real_packet->offset);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'total_length' has changed");
    dio_put_uint32(&dout, real_packet->total_length);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'chunk_length' has changed");
    dio_put_uint32(&dout, real_packet->chunk_length);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'data' has changed");
    dio_put_memory(&dout, &real_packet->data, real_packet->chunk_length);
  }

  *old = *real_packet;

  if (real_packet != packet) {
    free((void *) real_packet);
  }
  SEND_PACKET_END(PACKET_PLAYER_ATTRIBUTE_CHUNK);
}

static void ensure_valid_variant_packet_player_attribute_chunk(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_CHUNK] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_ATTRIBUTE_CHUNK variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_CHUNK] = variant;
}

struct packet_player_attribute_chunk *receive_packet_player_attribute_chunk(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  ensure_valid_variant_packet_player_attribute_chunk(pc);

  switch(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_CHUNK]) {
  case 100:
    return receive_packet_player_attribute_chunk_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_ATTRIBUTE_CHUNK variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_attribute_chunk(struct connection *pc, const struct packet_player_attribute_chunk *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  ensure_valid_variant_packet_player_attribute_chunk(pc);

  switch(pc->phs.variant[PACKET_PLAYER_ATTRIBUTE_CHUNK]) {

  case 100:
    return send_packet_player_attribute_chunk_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_ATTRIBUTE_CHUNK variant for connection %s", conn_description(pc));
    return -1;
  }
}
static genhash_val_t hash_packet_player_diplstate_100(const void *vkey)
{
  const struct packet_player_diplstate *key = (const struct packet_player_diplstate *) vkey;

  return key->diplstate_id;
}

static bool cmp_packet_player_diplstate_100(const void *vkey1, const void *vkey2)
{
  const struct packet_player_diplstate *key1 = (const struct packet_player_diplstate *) vkey1;
  const struct packet_player_diplstate *key2 = (const struct packet_player_diplstate *) vkey2;

  return key1->diplstate_id == key2->diplstate_id;
}

BV_DEFINE(packet_player_diplstate_100_fields, 6);

static struct packet_player_diplstate *receive_packet_player_diplstate_100(struct connection *pc)
{
  packet_player_diplstate_100_fields fields;
  struct packet_player_diplstate *old;
  struct genhash **hash = pc->phs.received + PACKET_PLAYER_DIPLSTATE;
  RECEIVE_PACKET_START(packet_player_diplstate, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_uint32(&din, &real_packet->diplstate_id)) {
    RECEIVE_PACKET_FIELD_ERROR(diplstate_id);
  }

  log_packet_detailed("packet_player_diplstate_100: got info about (%d)",
    real_packet->diplstate_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_diplstate_100, cmp_packet_player_diplstate_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int diplstate_id = real_packet->diplstate_id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->diplstate_id = diplstate_id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'plr1'");
    if (!dio_get_sint8(&din, &real_packet->plr1)) {
      RECEIVE_PACKET_FIELD_ERROR(plr1);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'plr2'");
    if (!dio_get_sint8(&din, &real_packet->plr2)) {
      RECEIVE_PACKET_FIELD_ERROR(plr2);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    if (!dio_get_uint8(&din, &real_packet->type)) {
      RECEIVE_PACKET_FIELD_ERROR(type);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'turns_left'");
    if (!dio_get_uint16(&din, &real_packet->turns_left)) {
      RECEIVE_PACKET_FIELD_ERROR(turns_left);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'has_reason_to_cancel'");
    if (!dio_get_uint8(&din, &real_packet->has_reason_to_cancel)) {
      RECEIVE_PACKET_FIELD_ERROR(has_reason_to_cancel);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'contact_turns_left'");
    if (!dio_get_uint16(&din, &real_packet->contact_turns_left)) {
      RECEIVE_PACKET_FIELD_ERROR(contact_turns_left);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_player_diplstate_100(struct connection *pc, const struct packet_player_diplstate *packet)
{
  const struct packet_player_diplstate *real_packet = packet;
  packet_player_diplstate_100_fields fields;
  struct packet_player_diplstate *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PLAYER_DIPLSTATE;
  int different = 0;
  SEND_PACKET_START(PACKET_PLAYER_DIPLSTATE);

  log_packet_detailed("packet_player_diplstate_100: sending info about (%d)",
    real_packet->diplstate_id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_player_diplstate_100, cmp_packet_player_diplstate_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->plr1 != real_packet->plr1);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->plr2 != real_packet->plr2);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->turns_left != real_packet->turns_left);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->has_reason_to_cancel != real_packet->has_reason_to_cancel);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->contact_turns_left != real_packet->contact_turns_left);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_uint32(&dout, real_packet->diplstate_id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'plr1' has changed");
    dio_put_sint8(&dout, real_packet->plr1);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'plr2' has changed");
    dio_put_sint8(&dout, real_packet->plr2);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'turns_left' has changed");
    dio_put_uint16(&dout, real_packet->turns_left);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'has_reason_to_cancel' has changed");
    dio_put_uint8(&dout, real_packet->has_reason_to_cancel);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'contact_turns_left' has changed");
    dio_put_uint16(&dout, real_packet->contact_turns_left);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PLAYER_DIPLSTATE);
}

static void ensure_valid_variant_packet_player_diplstate(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PLAYER_DIPLSTATE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PLAYER_DIPLSTATE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PLAYER_DIPLSTATE] = variant;
}

struct packet_player_diplstate *receive_packet_player_diplstate(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_player_diplstate at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_player_diplstate(pc);

  switch(pc->phs.variant[PACKET_PLAYER_DIPLSTATE]) {
  case 100:
    return receive_packet_player_diplstate_100(pc);
  default:
    log_debug("Unknown PACKET_PLAYER_DIPLSTATE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_player_diplstate(struct connection *pc, const struct packet_player_diplstate *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_player_diplstate from the client.");
  }
  ensure_valid_variant_packet_player_diplstate(pc);

  switch(pc->phs.variant[PACKET_PLAYER_DIPLSTATE]) {

  case 100:
    return send_packet_player_diplstate_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PLAYER_DIPLSTATE variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_unit_remove_100 hash_const

#define cmp_packet_unit_remove_100 cmp_const

BV_DEFINE(packet_unit_remove_100_fields, 1);

static struct packet_unit_remove *receive_packet_unit_remove_100(struct connection *pc)
{
  packet_unit_remove_100_fields fields;
  struct packet_unit_remove *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_REMOVE;
  RECEIVE_PACKET_START(packet_unit_remove, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_remove_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_remove_100, cmp_packet_unit_remove_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_remove_100(struct connection *pc, const struct packet_unit_remove *packet)
{
  const struct packet_unit_remove *real_packet = packet;
  packet_unit_remove_100_fields fields;
  struct packet_unit_remove *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_REMOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_REMOVE);

  log_packet_detailed("packet_unit_remove_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_remove_100, cmp_packet_unit_remove_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }

  hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_UNIT_REMOVE);
}

static void ensure_valid_variant_packet_unit_remove(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_REMOVE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_REMOVE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_REMOVE] = variant;
}

struct packet_unit_remove *receive_packet_unit_remove(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_unit_remove at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_remove(pc);

  switch(pc->phs.variant[PACKET_UNIT_REMOVE]) {
  case 100:
    return receive_packet_unit_remove_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_REMOVE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_remove(struct connection *pc, const struct packet_unit_remove *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_remove from the client.");
  }
  ensure_valid_variant_packet_unit_remove(pc);

  switch(pc->phs.variant[PACKET_UNIT_REMOVE]) {

  case 100:
    return send_packet_unit_remove_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_REMOVE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_remove(struct conn_list *dest, const struct packet_unit_remove *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_remove(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_unit_remove(struct connection *pc, int unit_id)
{
  struct packet_unit_remove packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_remove(pc, real_packet);
}

void dlsend_packet_unit_remove(struct conn_list *dest, int unit_id)
{
  struct packet_unit_remove packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  lsend_packet_unit_remove(dest, real_packet);
}

static genhash_val_t hash_packet_unit_info_100(const void *vkey)
{
  const struct packet_unit_info *key = (const struct packet_unit_info *) vkey;

  return key->id;
}

static bool cmp_packet_unit_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_unit_info *key1 = (const struct packet_unit_info *) vkey1;
  const struct packet_unit_info *key2 = (const struct packet_unit_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_unit_info_100_fields, 39);

static struct packet_unit_info *receive_packet_unit_info_100(struct connection *pc)
{
  packet_unit_info_100_fields fields;
  struct packet_unit_info *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_INFO;
  RECEIVE_PACKET_START(packet_unit_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_uint16(&din, &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_unit_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_100, cmp_packet_unit_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'owner'");
    if (!dio_get_sint8(&din, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nationality'");
    if (!dio_get_sint8(&din, &real_packet->nationality)) {
      RECEIVE_PACKET_FIELD_ERROR(nationality);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'tile'");
    if (!dio_get_sint32(&din, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'facing'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(facing);
      }
      real_packet->facing = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'homecity'");
    if (!dio_get_uint16(&din, &real_packet->homecity)) {
      RECEIVE_PACKET_FIELD_ERROR(homecity);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'upkeep'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->upkeep[i])) {
          RECEIVE_PACKET_FIELD_ERROR(upkeep);
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'veteran'");
    if (!dio_get_uint8(&din, &real_packet->veteran)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran);
    }
  }
  real_packet->ai = BV_ISSET(fields, 7);
  real_packet->paradropped = BV_ISSET(fields, 8);
  real_packet->occupied = BV_ISSET(fields, 9);
  real_packet->transported = BV_ISSET(fields, 10);
  real_packet->done_moving = BV_ISSET(fields, 11);
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'transported_by'");
    if (!dio_get_uint16(&din, &real_packet->transported_by)) {
      RECEIVE_PACKET_FIELD_ERROR(transported_by);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'movesleft_new'");
    if (!dio_get_uint16(&din, &real_packet->movesleft_new)) {
      RECEIVE_PACKET_FIELD_ERROR(movesleft_new);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'hp'");
    if (!dio_get_uint8(&din, &real_packet->hp)) {
      RECEIVE_PACKET_FIELD_ERROR(hp);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'fuel'");
    if (!dio_get_uint8(&din, &real_packet->fuel)) {
      RECEIVE_PACKET_FIELD_ERROR(fuel);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'activity_count'");
    if (!dio_get_uint16(&din, &real_packet->activity_count)) {
      RECEIVE_PACKET_FIELD_ERROR(activity_count);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'changed_from_count'");
    if (!dio_get_uint16(&din, &real_packet->changed_from_count)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_count);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'goto_tile'");
    if (!dio_get_sint32(&din, &real_packet->goto_tile)) {
      RECEIVE_PACKET_FIELD_ERROR(goto_tile);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'activity_tgt_spe'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_tgt_spe);
      }
      real_packet->activity_tgt_spe = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'activity_tgt_base'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_tgt_base);
      }
      real_packet->activity_tgt_base = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'activity_tgt_road'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_tgt_road);
      }
      real_packet->activity_tgt_road = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'changed_from'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(changed_from);
      }
      real_packet->changed_from = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'changed_from_tgt_spe'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(changed_from_tgt_spe);
      }
      real_packet->changed_from_tgt_spe = readin;
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'changed_from_tgt_base'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(changed_from_tgt_base);
      }
      real_packet->changed_from_tgt_base = readin;
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'changed_from_tgt_road'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(changed_from_tgt_road);
      }
      real_packet->changed_from_tgt_road = readin;
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'battlegroup'");
    if (!dio_get_sint8(&din, &real_packet->battlegroup)) {
      RECEIVE_PACKET_FIELD_ERROR(battlegroup);
    }
  }
  real_packet->has_orders = BV_ISSET(fields, 29);
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'orders_length'");
    if (!dio_get_uint16(&din, &real_packet->orders_length)) {
      RECEIVE_PACKET_FIELD_ERROR(orders_length);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'orders_index'");
    if (!dio_get_uint16(&din, &real_packet->orders_index)) {
      RECEIVE_PACKET_FIELD_ERROR(orders_index);
    }
  }
  real_packet->orders_repeat = BV_ISSET(fields, 32);
  real_packet->orders_vigilant = BV_ISSET(fields, 33);
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'orders'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_uint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders);
          }
          real_packet->orders[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'orders_dirs'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_dirs, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_sint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_dirs);
          }
          real_packet->orders_dirs[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'orders_activities'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_activities, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_uint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_activities);
          }
          real_packet->orders_activities[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'orders_bases'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_bases, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_sint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_bases);
          }
          real_packet->orders_bases[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'orders_roads'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_roads, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_sint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_roads);
          }
          real_packet->orders_roads[i] = readin;
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_info_100(struct connection *pc, const struct packet_unit_info *packet)
{
  const struct packet_unit_info *real_packet = packet;
  packet_unit_info_100_fields fields;
  struct packet_unit_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_INFO);

  log_packet_detailed("packet_unit_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_100, cmp_packet_unit_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nationality != real_packet->nationality);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->facing != real_packet->facing);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->homecity != real_packet->homecity);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->upkeep[i] != real_packet->upkeep[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->veteran != real_packet->veteran);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 7);
  }

  differ = (old->paradropped != real_packet->paradropped);
  if(differ) {
    different++;
  }
  if (packet->paradropped) {
    BV_SET(fields, 8);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 9);
  }

  differ = (old->transported != real_packet->transported);
  if(differ) {
    different++;
  }
  if (packet->transported) {
    BV_SET(fields, 10);
  }

  differ = (old->done_moving != real_packet->done_moving);
  if(differ) {
    different++;
  }
  if (packet->done_moving) {
    BV_SET(fields, 11);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->transported_by != real_packet->transported_by);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->movesleft_new != real_packet->movesleft_new);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->activity_count != real_packet->activity_count);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->changed_from_count != real_packet->changed_from_count);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->goto_tile != real_packet->goto_tile);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->activity_tgt_spe != real_packet->activity_tgt_spe);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->activity_tgt_base != real_packet->activity_tgt_base);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->activity_tgt_road != real_packet->activity_tgt_road);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->changed_from != real_packet->changed_from);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->changed_from_tgt_spe != real_packet->changed_from_tgt_spe);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->changed_from_tgt_base != real_packet->changed_from_tgt_base);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->changed_from_tgt_road != real_packet->changed_from_tgt_road);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->battlegroup != real_packet->battlegroup);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->has_orders != real_packet->has_orders);
  if(differ) {
    different++;
  }
  if (packet->has_orders) {
    BV_SET(fields, 29);
  }

  differ = (old->orders_length != real_packet->orders_length);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->orders_index != real_packet->orders_index);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->orders_repeat != real_packet->orders_repeat);
  if(differ) {
    different++;
  }
  if (packet->orders_repeat) {
    BV_SET(fields, 32);
  }

  differ = (old->orders_vigilant != real_packet->orders_vigilant);
  if(differ) {
    different++;
  }
  if (packet->orders_vigilant) {
    BV_SET(fields, 33);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders[i] != real_packet->orders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_dirs[i] != real_packet->orders_dirs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_activities[i] != real_packet->orders_activities[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_bases[i] != real_packet->orders_bases[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_roads[i] != real_packet->orders_roads[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nationality' has changed");
    dio_put_sint8(&dout, real_packet->nationality);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'facing' has changed");
    dio_put_sint8(&dout, real_packet->facing);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'homecity' has changed");
    dio_put_uint16(&dout, real_packet->homecity);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'upkeep' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->upkeep[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'veteran' has changed");
    dio_put_uint8(&dout, real_packet->veteran);
  }
  /* field 7 is folded into the header */
  /* field 8 is folded into the header */
  /* field 9 is folded into the header */
  /* field 10 is folded into the header */
  /* field 11 is folded into the header */
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'transported_by' has changed");
    dio_put_uint16(&dout, real_packet->transported_by);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'movesleft_new' has changed");
    dio_put_uint16(&dout, real_packet->movesleft_new);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'hp' has changed");
    dio_put_uint8(&dout, real_packet->hp);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'fuel' has changed");
    dio_put_uint8(&dout, real_packet->fuel);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'activity_count' has changed");
    dio_put_uint16(&dout, real_packet->activity_count);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'changed_from_count' has changed");
    dio_put_uint16(&dout, real_packet->changed_from_count);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'goto_tile' has changed");
    dio_put_sint32(&dout, real_packet->goto_tile);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'activity_tgt_spe' has changed");
    dio_put_uint8(&dout, real_packet->activity_tgt_spe);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'activity_tgt_base' has changed");
    dio_put_sint8(&dout, real_packet->activity_tgt_base);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'activity_tgt_road' has changed");
    dio_put_sint8(&dout, real_packet->activity_tgt_road);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'changed_from' has changed");
    dio_put_uint8(&dout, real_packet->changed_from);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'changed_from_tgt_spe' has changed");
    dio_put_uint8(&dout, real_packet->changed_from_tgt_spe);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'changed_from_tgt_base' has changed");
    dio_put_sint8(&dout, real_packet->changed_from_tgt_base);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'changed_from_tgt_road' has changed");
    dio_put_sint8(&dout, real_packet->changed_from_tgt_road);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'battlegroup' has changed");
    dio_put_sint8(&dout, real_packet->battlegroup);
  }
  /* field 29 is folded into the header */
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'orders_length' has changed");
    dio_put_uint16(&dout, real_packet->orders_length);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'orders_index' has changed");
    dio_put_uint16(&dout, real_packet->orders_index);
  }
  /* field 32 is folded into the header */
  /* field 33 is folded into the header */
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'orders' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'orders_dirs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_dirs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'orders_activities' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders_activities[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'orders_bases' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_bases[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'orders_roads' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_roads[i]);
      }
    } 
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_UNIT_INFO);
}

static genhash_val_t hash_packet_unit_info_101(const void *vkey)
{
  const struct packet_unit_info *key = (const struct packet_unit_info *) vkey;

  return key->id;
}

static bool cmp_packet_unit_info_101(const void *vkey1, const void *vkey2)
{
  const struct packet_unit_info *key1 = (const struct packet_unit_info *) vkey1;
  const struct packet_unit_info *key2 = (const struct packet_unit_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_unit_info_101_fields, 39);

static struct packet_unit_info *receive_packet_unit_info_101(struct connection *pc)
{
  packet_unit_info_101_fields fields;
  struct packet_unit_info *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_INFO;
  RECEIVE_PACKET_START(packet_unit_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_uint16(&din, &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_unit_info_101: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_101, cmp_packet_unit_info_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'owner'");
    if (!dio_get_sint8(&din, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nationality'");
    if (!dio_get_sint8(&din, &real_packet->nationality)) {
      RECEIVE_PACKET_FIELD_ERROR(nationality);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'tile'");
    if (!dio_get_sint32(&din, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'facing'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(facing);
      }
      real_packet->facing = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'homecity'");
    if (!dio_get_uint16(&din, &real_packet->homecity)) {
      RECEIVE_PACKET_FIELD_ERROR(homecity);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'upkeep'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->upkeep[i])) {
          RECEIVE_PACKET_FIELD_ERROR(upkeep);
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'veteran'");
    if (!dio_get_uint8(&din, &real_packet->veteran)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran);
    }
  }
  real_packet->ai = BV_ISSET(fields, 7);
  real_packet->paradropped = BV_ISSET(fields, 8);
  real_packet->occupied = BV_ISSET(fields, 9);
  real_packet->transported = BV_ISSET(fields, 10);
  real_packet->done_moving = BV_ISSET(fields, 11);
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'transported_by'");
    if (!dio_get_uint16(&din, &real_packet->transported_by)) {
      RECEIVE_PACKET_FIELD_ERROR(transported_by);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'movesleft_old'");
    if (!dio_get_uint8(&din, &real_packet->movesleft_old)) {
      RECEIVE_PACKET_FIELD_ERROR(movesleft_old);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'hp'");
    if (!dio_get_uint8(&din, &real_packet->hp)) {
      RECEIVE_PACKET_FIELD_ERROR(hp);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'fuel'");
    if (!dio_get_uint8(&din, &real_packet->fuel)) {
      RECEIVE_PACKET_FIELD_ERROR(fuel);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'activity_count'");
    if (!dio_get_uint16(&din, &real_packet->activity_count)) {
      RECEIVE_PACKET_FIELD_ERROR(activity_count);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'changed_from_count'");
    if (!dio_get_uint16(&din, &real_packet->changed_from_count)) {
      RECEIVE_PACKET_FIELD_ERROR(changed_from_count);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'goto_tile'");
    if (!dio_get_sint32(&din, &real_packet->goto_tile)) {
      RECEIVE_PACKET_FIELD_ERROR(goto_tile);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'activity_tgt_spe'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_tgt_spe);
      }
      real_packet->activity_tgt_spe = readin;
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'activity_tgt_base'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_tgt_base);
      }
      real_packet->activity_tgt_base = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'activity_tgt_road'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_tgt_road);
      }
      real_packet->activity_tgt_road = readin;
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'changed_from'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(changed_from);
      }
      real_packet->changed_from = readin;
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'changed_from_tgt_spe'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(changed_from_tgt_spe);
      }
      real_packet->changed_from_tgt_spe = readin;
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'changed_from_tgt_base'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(changed_from_tgt_base);
      }
      real_packet->changed_from_tgt_base = readin;
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'changed_from_tgt_road'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(changed_from_tgt_road);
      }
      real_packet->changed_from_tgt_road = readin;
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'battlegroup'");
    if (!dio_get_sint8(&din, &real_packet->battlegroup)) {
      RECEIVE_PACKET_FIELD_ERROR(battlegroup);
    }
  }
  real_packet->has_orders = BV_ISSET(fields, 29);
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'orders_length'");
    if (!dio_get_uint16(&din, &real_packet->orders_length)) {
      RECEIVE_PACKET_FIELD_ERROR(orders_length);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'orders_index'");
    if (!dio_get_uint16(&din, &real_packet->orders_index)) {
      RECEIVE_PACKET_FIELD_ERROR(orders_index);
    }
  }
  real_packet->orders_repeat = BV_ISSET(fields, 32);
  real_packet->orders_vigilant = BV_ISSET(fields, 33);
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'orders'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_uint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders);
          }
          real_packet->orders[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'orders_dirs'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_dirs, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_sint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_dirs);
          }
          real_packet->orders_dirs[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'orders_activities'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_activities, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_uint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_activities);
          }
          real_packet->orders_activities[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'orders_bases'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_bases, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_sint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_bases);
          }
          real_packet->orders_bases[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'orders_roads'");
    
    {
      int i;
    
      if (real_packet->orders_length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders_roads, ": truncation array");
      }
      for (i = 0; i < real_packet->orders_length; i++) {
        {
          int readin;
      
          if (!dio_get_sint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders_roads);
          }
          real_packet->orders_roads[i] = readin;
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_info_101(struct connection *pc, const struct packet_unit_info *packet)
{
  const struct packet_unit_info *real_packet = packet;
  packet_unit_info_101_fields fields;
  struct packet_unit_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_INFO);

  log_packet_detailed("packet_unit_info_101: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_info_101, cmp_packet_unit_info_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nationality != real_packet->nationality);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->facing != real_packet->facing);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->homecity != real_packet->homecity);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->upkeep[i] != real_packet->upkeep[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->veteran != real_packet->veteran);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->ai != real_packet->ai);
  if(differ) {
    different++;
  }
  if (packet->ai) {
    BV_SET(fields, 7);
  }

  differ = (old->paradropped != real_packet->paradropped);
  if(differ) {
    different++;
  }
  if (packet->paradropped) {
    BV_SET(fields, 8);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 9);
  }

  differ = (old->transported != real_packet->transported);
  if(differ) {
    different++;
  }
  if (packet->transported) {
    BV_SET(fields, 10);
  }

  differ = (old->done_moving != real_packet->done_moving);
  if(differ) {
    different++;
  }
  if (packet->done_moving) {
    BV_SET(fields, 11);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->transported_by != real_packet->transported_by);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->movesleft_old != real_packet->movesleft_old);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->activity_count != real_packet->activity_count);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->changed_from_count != real_packet->changed_from_count);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->goto_tile != real_packet->goto_tile);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->activity_tgt_spe != real_packet->activity_tgt_spe);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->activity_tgt_base != real_packet->activity_tgt_base);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->activity_tgt_road != real_packet->activity_tgt_road);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->changed_from != real_packet->changed_from);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->changed_from_tgt_spe != real_packet->changed_from_tgt_spe);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->changed_from_tgt_base != real_packet->changed_from_tgt_base);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->changed_from_tgt_road != real_packet->changed_from_tgt_road);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->battlegroup != real_packet->battlegroup);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->has_orders != real_packet->has_orders);
  if(differ) {
    different++;
  }
  if (packet->has_orders) {
    BV_SET(fields, 29);
  }

  differ = (old->orders_length != real_packet->orders_length);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->orders_index != real_packet->orders_index);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }

  differ = (old->orders_repeat != real_packet->orders_repeat);
  if(differ) {
    different++;
  }
  if (packet->orders_repeat) {
    BV_SET(fields, 32);
  }

  differ = (old->orders_vigilant != real_packet->orders_vigilant);
  if(differ) {
    different++;
  }
  if (packet->orders_vigilant) {
    BV_SET(fields, 33);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders[i] != real_packet->orders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_dirs[i] != real_packet->orders_dirs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_activities[i] != real_packet->orders_activities[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_bases[i] != real_packet->orders_bases[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }


    {
      differ = (old->orders_length != real_packet->orders_length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->orders_length; i++) {
          if (old->orders_roads[i] != real_packet->orders_roads[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nationality' has changed");
    dio_put_sint8(&dout, real_packet->nationality);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'facing' has changed");
    dio_put_sint8(&dout, real_packet->facing);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'homecity' has changed");
    dio_put_uint16(&dout, real_packet->homecity);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'upkeep' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->upkeep[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'veteran' has changed");
    dio_put_uint8(&dout, real_packet->veteran);
  }
  /* field 7 is folded into the header */
  /* field 8 is folded into the header */
  /* field 9 is folded into the header */
  /* field 10 is folded into the header */
  /* field 11 is folded into the header */
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'transported_by' has changed");
    dio_put_uint16(&dout, real_packet->transported_by);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'movesleft_old' has changed");
    dio_put_uint8(&dout, real_packet->movesleft_old);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'hp' has changed");
    dio_put_uint8(&dout, real_packet->hp);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'fuel' has changed");
    dio_put_uint8(&dout, real_packet->fuel);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'activity_count' has changed");
    dio_put_uint16(&dout, real_packet->activity_count);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'changed_from_count' has changed");
    dio_put_uint16(&dout, real_packet->changed_from_count);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'goto_tile' has changed");
    dio_put_sint32(&dout, real_packet->goto_tile);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'activity_tgt_spe' has changed");
    dio_put_uint8(&dout, real_packet->activity_tgt_spe);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'activity_tgt_base' has changed");
    dio_put_sint8(&dout, real_packet->activity_tgt_base);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'activity_tgt_road' has changed");
    dio_put_sint8(&dout, real_packet->activity_tgt_road);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'changed_from' has changed");
    dio_put_uint8(&dout, real_packet->changed_from);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'changed_from_tgt_spe' has changed");
    dio_put_uint8(&dout, real_packet->changed_from_tgt_spe);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'changed_from_tgt_base' has changed");
    dio_put_sint8(&dout, real_packet->changed_from_tgt_base);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'changed_from_tgt_road' has changed");
    dio_put_sint8(&dout, real_packet->changed_from_tgt_road);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'battlegroup' has changed");
    dio_put_sint8(&dout, real_packet->battlegroup);
  }
  /* field 29 is folded into the header */
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'orders_length' has changed");
    dio_put_uint16(&dout, real_packet->orders_length);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'orders_index' has changed");
    dio_put_uint16(&dout, real_packet->orders_index);
  }
  /* field 32 is folded into the header */
  /* field 33 is folded into the header */
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'orders' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'orders_dirs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_dirs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'orders_activities' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_uint8(&dout, real_packet->orders_activities[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'orders_bases' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_bases[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'orders_roads' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->orders_length; i++) {
        dio_put_sint8(&dout, real_packet->orders_roads[i]);
      }
    } 
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_UNIT_INFO);
}

static void ensure_valid_variant_packet_unit_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if((has_capability("extended_move_rate", pc->capability) && has_capability("extended_move_rate", our_capability))) {
    variant = 100;
  } else if(!(has_capability("extended_move_rate", pc->capability) && has_capability("extended_move_rate", our_capability))) {
    variant = 101;
  } else {
    log_error("Unknown PACKET_UNIT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  log_packet_detailed("packet_unit_info: using variant=%d cap=%s", variant, pc->capability);
  pc->phs.variant[PACKET_UNIT_INFO] = variant;
}

struct packet_unit_info *receive_packet_unit_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_unit_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_INFO]) {
  case 100:
    return receive_packet_unit_info_100(pc);
  case 101:
    return receive_packet_unit_info_101(pc);
  default:
    log_debug("Unknown PACKET_UNIT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_info(struct connection *pc, const struct packet_unit_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_info from the client.");
  }
  ensure_valid_variant_packet_unit_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_INFO]) {

  case 100:
    return send_packet_unit_info_100(pc, packet);
  case 101:
    return send_packet_unit_info_101(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_info(struct conn_list *dest, const struct packet_unit_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_info(pconn, packet);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_unit_short_info_100(const void *vkey)
{
  const struct packet_unit_short_info *key = (const struct packet_unit_short_info *) vkey;

  return key->id;
}

static bool cmp_packet_unit_short_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_unit_short_info *key1 = (const struct packet_unit_short_info *) vkey1;
  const struct packet_unit_short_info *key2 = (const struct packet_unit_short_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_unit_short_info_100_fields, 16);

static struct packet_unit_short_info *receive_packet_unit_short_info_100(struct connection *pc)
{
  packet_unit_short_info_100_fields fields;
  struct packet_unit_short_info *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_SHORT_INFO;
  RECEIVE_PACKET_START(packet_unit_short_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_uint16(&din, &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_unit_short_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_short_info_100, cmp_packet_unit_short_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'owner'");
    if (!dio_get_sint8(&din, &real_packet->owner)) {
      RECEIVE_PACKET_FIELD_ERROR(owner);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    if (!dio_get_sint32(&din, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'facing'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(facing);
      }
      real_packet->facing = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'veteran'");
    if (!dio_get_uint8(&din, &real_packet->veteran)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran);
    }
  }
  real_packet->occupied = BV_ISSET(fields, 5);
  real_packet->goes_out_of_sight = BV_ISSET(fields, 6);
  real_packet->transported = BV_ISSET(fields, 7);
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'hp'");
    if (!dio_get_uint8(&din, &real_packet->hp)) {
      RECEIVE_PACKET_FIELD_ERROR(hp);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'activity'");
    if (!dio_get_uint8(&din, &real_packet->activity)) {
      RECEIVE_PACKET_FIELD_ERROR(activity);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'activity_tgt_base'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_tgt_base);
      }
      real_packet->activity_tgt_base = readin;
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'activity_tgt_road'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_tgt_road);
      }
      real_packet->activity_tgt_road = readin;
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'transported_by'");
    if (!dio_get_uint16(&din, &real_packet->transported_by)) {
      RECEIVE_PACKET_FIELD_ERROR(transported_by);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'packet_use'");
    if (!dio_get_uint8(&din, &real_packet->packet_use)) {
      RECEIVE_PACKET_FIELD_ERROR(packet_use);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'info_city_id'");
    if (!dio_get_uint16(&din, &real_packet->info_city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(info_city_id);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'serial_num'");
    if (!dio_get_uint16(&din, &real_packet->serial_num)) {
      RECEIVE_PACKET_FIELD_ERROR(serial_num);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }

  hash = pc->phs.received + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_short_info_100(struct connection *pc, const struct packet_unit_short_info *packet)
{
  const struct packet_unit_short_info *real_packet = packet;
  packet_unit_short_info_100_fields fields;
  struct packet_unit_short_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_SHORT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_SHORT_INFO);

  log_packet_detailed("packet_unit_short_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_short_info_100, cmp_packet_unit_short_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->owner != real_packet->owner);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->facing != real_packet->facing);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->veteran != real_packet->veteran);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->occupied != real_packet->occupied);
  if(differ) {
    different++;
  }
  if (packet->occupied) {
    BV_SET(fields, 5);
  }

  differ = (old->goes_out_of_sight != real_packet->goes_out_of_sight);
  if(differ) {
    different++;
  }
  if (packet->goes_out_of_sight) {
    BV_SET(fields, 6);
  }

  differ = (old->transported != real_packet->transported);
  if(differ) {
    different++;
  }
  if (packet->transported) {
    BV_SET(fields, 7);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->activity_tgt_base != real_packet->activity_tgt_base);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->activity_tgt_road != real_packet->activity_tgt_road);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->transported_by != real_packet->transported_by);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->packet_use != real_packet->packet_use);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->info_city_id != real_packet->info_city_id);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->serial_num != real_packet->serial_num);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_uint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'owner' has changed");
    dio_put_sint8(&dout, real_packet->owner);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'facing' has changed");
    dio_put_sint8(&dout, real_packet->facing);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'veteran' has changed");
    dio_put_uint8(&dout, real_packet->veteran);
  }
  /* field 5 is folded into the header */
  /* field 6 is folded into the header */
  /* field 7 is folded into the header */
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'hp' has changed");
    dio_put_uint8(&dout, real_packet->hp);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'activity_tgt_base' has changed");
    dio_put_sint8(&dout, real_packet->activity_tgt_base);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'activity_tgt_road' has changed");
    dio_put_sint8(&dout, real_packet->activity_tgt_road);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'transported_by' has changed");
    dio_put_uint16(&dout, real_packet->transported_by);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'packet_use' has changed");
    dio_put_uint8(&dout, real_packet->packet_use);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'info_city_id' has changed");
    dio_put_uint16(&dout, real_packet->info_city_id);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'serial_num' has changed");
    dio_put_uint16(&dout, real_packet->serial_num);
  }

  *old = *real_packet;

  hash = pc->phs.sent + PACKET_UNIT_INFO;
  if (NULL != *hash) {
    genhash_remove(*hash, real_packet);
  }
  SEND_PACKET_END(PACKET_UNIT_SHORT_INFO);
}

static void ensure_valid_variant_packet_unit_short_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_SHORT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_SHORT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_SHORT_INFO] = variant;
}

struct packet_unit_short_info *receive_packet_unit_short_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_unit_short_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_short_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_SHORT_INFO]) {
  case 100:
    return receive_packet_unit_short_info_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_SHORT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_short_info(struct connection *pc, const struct packet_unit_short_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_short_info from the client.");
  }
  ensure_valid_variant_packet_unit_short_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_SHORT_INFO]) {

  case 100:
    return send_packet_unit_short_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_SHORT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_short_info(struct conn_list *dest, const struct packet_unit_short_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_short_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_unit_combat_info_100 hash_const

#define cmp_packet_unit_combat_info_100 cmp_const

BV_DEFINE(packet_unit_combat_info_100_fields, 5);

static struct packet_unit_combat_info *receive_packet_unit_combat_info_100(struct connection *pc)
{
  packet_unit_combat_info_100_fields fields;
  struct packet_unit_combat_info *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_COMBAT_INFO;
  RECEIVE_PACKET_START(packet_unit_combat_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_combat_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_combat_info_100, cmp_packet_unit_combat_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'attacker_unit_id'");
    if (!dio_get_uint16(&din, &real_packet->attacker_unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(attacker_unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'defender_unit_id'");
    if (!dio_get_uint16(&din, &real_packet->defender_unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(defender_unit_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'attacker_hp'");
    if (!dio_get_uint8(&din, &real_packet->attacker_hp)) {
      RECEIVE_PACKET_FIELD_ERROR(attacker_hp);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'defender_hp'");
    if (!dio_get_uint8(&din, &real_packet->defender_hp)) {
      RECEIVE_PACKET_FIELD_ERROR(defender_hp);
    }
  }
  real_packet->make_winner_veteran = BV_ISSET(fields, 4);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_combat_info_100(struct connection *pc, const struct packet_unit_combat_info *packet)
{
  const struct packet_unit_combat_info *real_packet = packet;
  packet_unit_combat_info_100_fields fields;
  struct packet_unit_combat_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_COMBAT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_COMBAT_INFO);

  log_packet_detailed("packet_unit_combat_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_combat_info_100, cmp_packet_unit_combat_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->attacker_unit_id != real_packet->attacker_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->defender_unit_id != real_packet->defender_unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->attacker_hp != real_packet->attacker_hp);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->defender_hp != real_packet->defender_hp);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->make_winner_veteran != real_packet->make_winner_veteran);
  if(differ) {
    different++;
  }
  if (packet->make_winner_veteran) {
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'attacker_unit_id' has changed");
    dio_put_uint16(&dout, real_packet->attacker_unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'defender_unit_id' has changed");
    dio_put_uint16(&dout, real_packet->defender_unit_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'attacker_hp' has changed");
    dio_put_uint8(&dout, real_packet->attacker_hp);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'defender_hp' has changed");
    dio_put_uint8(&dout, real_packet->defender_hp);
  }
  /* field 4 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_COMBAT_INFO);
}

static void ensure_valid_variant_packet_unit_combat_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_COMBAT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_COMBAT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_COMBAT_INFO] = variant;
}

struct packet_unit_combat_info *receive_packet_unit_combat_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_unit_combat_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_combat_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_COMBAT_INFO]) {
  case 100:
    return receive_packet_unit_combat_info_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_COMBAT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_combat_info(struct connection *pc, const struct packet_unit_combat_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_combat_info from the client.");
  }
  ensure_valid_variant_packet_unit_combat_info(pc);

  switch(pc->phs.variant[PACKET_UNIT_COMBAT_INFO]) {

  case 100:
    return send_packet_unit_combat_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_COMBAT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_combat_info(struct conn_list *dest, const struct packet_unit_combat_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_combat_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_unit_move_100 hash_const

#define cmp_packet_unit_move_100 cmp_const

BV_DEFINE(packet_unit_move_100_fields, 2);

static struct packet_unit_move *receive_packet_unit_move_100(struct connection *pc)
{
  packet_unit_move_100_fields fields;
  struct packet_unit_move *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_MOVE;
  RECEIVE_PACKET_START(packet_unit_move, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_move_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_move_100, cmp_packet_unit_move_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    if (!dio_get_sint32(&din, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_move_100(struct connection *pc, const struct packet_unit_move *packet)
{
  const struct packet_unit_move *real_packet = packet;
  packet_unit_move_100_fields fields;
  struct packet_unit_move *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_MOVE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_MOVE);

  log_packet_detailed("packet_unit_move_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_move_100, cmp_packet_unit_move_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_MOVE);
}

static void ensure_valid_variant_packet_unit_move(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_MOVE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_MOVE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_MOVE] = variant;
}

struct packet_unit_move *receive_packet_unit_move(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_move at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_move(pc);

  switch(pc->phs.variant[PACKET_UNIT_MOVE]) {
  case 100:
    return receive_packet_unit_move_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_MOVE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_move(struct connection *pc, const struct packet_unit_move *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_move from the server.");
  }
  ensure_valid_variant_packet_unit_move(pc);

  switch(pc->phs.variant[PACKET_UNIT_MOVE]) {

  case 100:
    return send_packet_unit_move_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_MOVE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_move(struct connection *pc, int unit_id, int tile)
{
  struct packet_unit_move packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->tile = tile;
  
  return send_packet_unit_move(pc, real_packet);
}

#define hash_packet_unit_build_city_100 hash_const

#define cmp_packet_unit_build_city_100 cmp_const

BV_DEFINE(packet_unit_build_city_100_fields, 2);

static struct packet_unit_build_city *receive_packet_unit_build_city_100(struct connection *pc)
{
  packet_unit_build_city_100_fields fields;
  struct packet_unit_build_city *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_BUILD_CITY;
  RECEIVE_PACKET_START(packet_unit_build_city, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_build_city_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_build_city_100, cmp_packet_unit_build_city_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_build_city_100(struct connection *pc, const struct packet_unit_build_city *packet)
{
  const struct packet_unit_build_city *real_packet = packet;
  packet_unit_build_city_100_fields fields;
  struct packet_unit_build_city *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_BUILD_CITY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_BUILD_CITY);

  log_packet_detailed("packet_unit_build_city_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_build_city_100, cmp_packet_unit_build_city_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_BUILD_CITY);
}

static void ensure_valid_variant_packet_unit_build_city(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_BUILD_CITY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_BUILD_CITY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_BUILD_CITY] = variant;
}

struct packet_unit_build_city *receive_packet_unit_build_city(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_build_city at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_build_city(pc);

  switch(pc->phs.variant[PACKET_UNIT_BUILD_CITY]) {
  case 100:
    return receive_packet_unit_build_city_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_BUILD_CITY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_build_city(struct connection *pc, const struct packet_unit_build_city *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_build_city from the server.");
  }
  ensure_valid_variant_packet_unit_build_city(pc);

  switch(pc->phs.variant[PACKET_UNIT_BUILD_CITY]) {

  case 100:
    return send_packet_unit_build_city_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_BUILD_CITY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_build_city(struct connection *pc, int unit_id, const char *name)
{
  struct packet_unit_build_city packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  sz_strlcpy(real_packet->name, name);
  
  return send_packet_unit_build_city(pc, real_packet);
}

#define hash_packet_unit_disband_100 hash_const

#define cmp_packet_unit_disband_100 cmp_const

BV_DEFINE(packet_unit_disband_100_fields, 1);

static struct packet_unit_disband *receive_packet_unit_disband_100(struct connection *pc)
{
  packet_unit_disband_100_fields fields;
  struct packet_unit_disband *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_DISBAND;
  RECEIVE_PACKET_START(packet_unit_disband, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_disband_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_disband_100, cmp_packet_unit_disband_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_disband_100(struct connection *pc, const struct packet_unit_disband *packet)
{
  const struct packet_unit_disband *real_packet = packet;
  packet_unit_disband_100_fields fields;
  struct packet_unit_disband *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DISBAND;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DISBAND);

  log_packet_detailed("packet_unit_disband_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_disband_100, cmp_packet_unit_disband_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_DISBAND);
}

static void ensure_valid_variant_packet_unit_disband(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_DISBAND] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_DISBAND variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_DISBAND] = variant;
}

struct packet_unit_disband *receive_packet_unit_disband(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_disband at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_disband(pc);

  switch(pc->phs.variant[PACKET_UNIT_DISBAND]) {
  case 100:
    return receive_packet_unit_disband_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_DISBAND variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_disband(struct connection *pc, const struct packet_unit_disband *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_disband from the server.");
  }
  ensure_valid_variant_packet_unit_disband(pc);

  switch(pc->phs.variant[PACKET_UNIT_DISBAND]) {

  case 100:
    return send_packet_unit_disband_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_DISBAND variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_disband(struct connection *pc, int unit_id)
{
  struct packet_unit_disband packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_disband(pc, real_packet);
}

#define hash_packet_unit_change_homecity_100 hash_const

#define cmp_packet_unit_change_homecity_100 cmp_const

BV_DEFINE(packet_unit_change_homecity_100_fields, 2);

static struct packet_unit_change_homecity *receive_packet_unit_change_homecity_100(struct connection *pc)
{
  packet_unit_change_homecity_100_fields fields;
  struct packet_unit_change_homecity *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_CHANGE_HOMECITY;
  RECEIVE_PACKET_START(packet_unit_change_homecity, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_change_homecity_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_homecity_100, cmp_packet_unit_change_homecity_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_change_homecity_100(struct connection *pc, const struct packet_unit_change_homecity *packet)
{
  const struct packet_unit_change_homecity *real_packet = packet;
  packet_unit_change_homecity_100_fields fields;
  struct packet_unit_change_homecity *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_CHANGE_HOMECITY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_CHANGE_HOMECITY);

  log_packet_detailed("packet_unit_change_homecity_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_homecity_100, cmp_packet_unit_change_homecity_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_CHANGE_HOMECITY);
}

static void ensure_valid_variant_packet_unit_change_homecity(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_CHANGE_HOMECITY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_CHANGE_HOMECITY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_CHANGE_HOMECITY] = variant;
}

struct packet_unit_change_homecity *receive_packet_unit_change_homecity(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_change_homecity at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_change_homecity(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_HOMECITY]) {
  case 100:
    return receive_packet_unit_change_homecity_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_HOMECITY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_change_homecity(struct connection *pc, const struct packet_unit_change_homecity *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_change_homecity from the server.");
  }
  ensure_valid_variant_packet_unit_change_homecity(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_HOMECITY]) {

  case 100:
    return send_packet_unit_change_homecity_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_HOMECITY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_change_homecity(struct connection *pc, int unit_id, int city_id)
{
  struct packet_unit_change_homecity packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->city_id = city_id;
  
  return send_packet_unit_change_homecity(pc, real_packet);
}

#define hash_packet_unit_establish_trade_100 hash_const

#define cmp_packet_unit_establish_trade_100 cmp_const

BV_DEFINE(packet_unit_establish_trade_100_fields, 1);

static struct packet_unit_establish_trade *receive_packet_unit_establish_trade_100(struct connection *pc)
{
  packet_unit_establish_trade_100_fields fields;
  struct packet_unit_establish_trade *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_ESTABLISH_TRADE;
  RECEIVE_PACKET_START(packet_unit_establish_trade, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_establish_trade_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_establish_trade_100, cmp_packet_unit_establish_trade_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_establish_trade_100(struct connection *pc, const struct packet_unit_establish_trade *packet)
{
  const struct packet_unit_establish_trade *real_packet = packet;
  packet_unit_establish_trade_100_fields fields;
  struct packet_unit_establish_trade *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_ESTABLISH_TRADE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_ESTABLISH_TRADE);

  log_packet_detailed("packet_unit_establish_trade_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_establish_trade_100, cmp_packet_unit_establish_trade_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_ESTABLISH_TRADE);
}

static void ensure_valid_variant_packet_unit_establish_trade(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_ESTABLISH_TRADE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_ESTABLISH_TRADE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_ESTABLISH_TRADE] = variant;
}

struct packet_unit_establish_trade *receive_packet_unit_establish_trade(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_establish_trade at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_establish_trade(pc);

  switch(pc->phs.variant[PACKET_UNIT_ESTABLISH_TRADE]) {
  case 100:
    return receive_packet_unit_establish_trade_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_ESTABLISH_TRADE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_establish_trade(struct connection *pc, const struct packet_unit_establish_trade *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_establish_trade from the server.");
  }
  ensure_valid_variant_packet_unit_establish_trade(pc);

  switch(pc->phs.variant[PACKET_UNIT_ESTABLISH_TRADE]) {

  case 100:
    return send_packet_unit_establish_trade_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_ESTABLISH_TRADE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_establish_trade(struct connection *pc, int unit_id)
{
  struct packet_unit_establish_trade packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_establish_trade(pc, real_packet);
}

#define hash_packet_unit_battlegroup_100 hash_const

#define cmp_packet_unit_battlegroup_100 cmp_const

BV_DEFINE(packet_unit_battlegroup_100_fields, 2);

static struct packet_unit_battlegroup *receive_packet_unit_battlegroup_100(struct connection *pc)
{
  packet_unit_battlegroup_100_fields fields;
  struct packet_unit_battlegroup *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_BATTLEGROUP;
  RECEIVE_PACKET_START(packet_unit_battlegroup, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_battlegroup_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_battlegroup_100, cmp_packet_unit_battlegroup_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'battlegroup'");
    if (!dio_get_sint8(&din, &real_packet->battlegroup)) {
      RECEIVE_PACKET_FIELD_ERROR(battlegroup);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_battlegroup_100(struct connection *pc, const struct packet_unit_battlegroup *packet)
{
  const struct packet_unit_battlegroup *real_packet = packet;
  packet_unit_battlegroup_100_fields fields;
  struct packet_unit_battlegroup *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_BATTLEGROUP;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_BATTLEGROUP);

  log_packet_detailed("packet_unit_battlegroup_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_battlegroup_100, cmp_packet_unit_battlegroup_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->battlegroup != real_packet->battlegroup);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'battlegroup' has changed");
    dio_put_sint8(&dout, real_packet->battlegroup);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_BATTLEGROUP);
}

static void ensure_valid_variant_packet_unit_battlegroup(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_BATTLEGROUP] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_BATTLEGROUP variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_BATTLEGROUP] = variant;
}

struct packet_unit_battlegroup *receive_packet_unit_battlegroup(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_battlegroup at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_battlegroup(pc);

  switch(pc->phs.variant[PACKET_UNIT_BATTLEGROUP]) {
  case 100:
    return receive_packet_unit_battlegroup_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_BATTLEGROUP variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_battlegroup(struct connection *pc, const struct packet_unit_battlegroup *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_battlegroup from the server.");
  }
  ensure_valid_variant_packet_unit_battlegroup(pc);

  switch(pc->phs.variant[PACKET_UNIT_BATTLEGROUP]) {

  case 100:
    return send_packet_unit_battlegroup_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_BATTLEGROUP variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_battlegroup(struct connection *pc, int unit_id, int battlegroup)
{
  struct packet_unit_battlegroup packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->battlegroup = battlegroup;
  
  return send_packet_unit_battlegroup(pc, real_packet);
}

#define hash_packet_unit_help_build_wonder_100 hash_const

#define cmp_packet_unit_help_build_wonder_100 cmp_const

BV_DEFINE(packet_unit_help_build_wonder_100_fields, 1);

static struct packet_unit_help_build_wonder *receive_packet_unit_help_build_wonder_100(struct connection *pc)
{
  packet_unit_help_build_wonder_100_fields fields;
  struct packet_unit_help_build_wonder *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_HELP_BUILD_WONDER;
  RECEIVE_PACKET_START(packet_unit_help_build_wonder, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_help_build_wonder_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_help_build_wonder_100, cmp_packet_unit_help_build_wonder_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_help_build_wonder_100(struct connection *pc, const struct packet_unit_help_build_wonder *packet)
{
  const struct packet_unit_help_build_wonder *real_packet = packet;
  packet_unit_help_build_wonder_100_fields fields;
  struct packet_unit_help_build_wonder *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_HELP_BUILD_WONDER;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_HELP_BUILD_WONDER);

  log_packet_detailed("packet_unit_help_build_wonder_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_help_build_wonder_100, cmp_packet_unit_help_build_wonder_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_HELP_BUILD_WONDER);
}

static void ensure_valid_variant_packet_unit_help_build_wonder(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_HELP_BUILD_WONDER] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_HELP_BUILD_WONDER variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_HELP_BUILD_WONDER] = variant;
}

struct packet_unit_help_build_wonder *receive_packet_unit_help_build_wonder(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_help_build_wonder at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_help_build_wonder(pc);

  switch(pc->phs.variant[PACKET_UNIT_HELP_BUILD_WONDER]) {
  case 100:
    return receive_packet_unit_help_build_wonder_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_HELP_BUILD_WONDER variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_help_build_wonder(struct connection *pc, const struct packet_unit_help_build_wonder *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_help_build_wonder from the server.");
  }
  ensure_valid_variant_packet_unit_help_build_wonder(pc);

  switch(pc->phs.variant[PACKET_UNIT_HELP_BUILD_WONDER]) {

  case 100:
    return send_packet_unit_help_build_wonder_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_HELP_BUILD_WONDER variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_help_build_wonder(struct connection *pc, int unit_id)
{
  struct packet_unit_help_build_wonder packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_help_build_wonder(pc, real_packet);
}

#define hash_packet_unit_orders_100 hash_const

#define cmp_packet_unit_orders_100 cmp_const

BV_DEFINE(packet_unit_orders_100_fields, 11);

static struct packet_unit_orders *receive_packet_unit_orders_100(struct connection *pc)
{
  packet_unit_orders_100_fields fields;
  struct packet_unit_orders *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_ORDERS;
  RECEIVE_PACKET_START(packet_unit_orders, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_orders_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_orders_100, cmp_packet_unit_orders_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'src_tile'");
    if (!dio_get_sint32(&din, &real_packet->src_tile)) {
      RECEIVE_PACKET_FIELD_ERROR(src_tile);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'length'");
    if (!dio_get_uint16(&din, &real_packet->length)) {
      RECEIVE_PACKET_FIELD_ERROR(length);
    }
  }
  real_packet->repeat = BV_ISSET(fields, 3);
  real_packet->vigilant = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'orders'");
    
    {
      int i;
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(orders, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
        {
          int readin;
      
          if (!dio_get_uint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(orders);
          }
          real_packet->orders[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'dir'");
    
    {
      int i;
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(dir, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
        {
          int readin;
      
          if (!dio_get_sint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(dir);
          }
          real_packet->dir[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'activity'");
    
    {
      int i;
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(activity, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
        {
          int readin;
      
          if (!dio_get_uint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(activity);
          }
          real_packet->activity[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'base'");
    
    {
      int i;
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(base, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
        {
          int readin;
      
          if (!dio_get_sint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(base);
          }
          real_packet->base[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'road'");
    
    {
      int i;
    
      if (real_packet->length > MAX_LEN_ROUTE) {
        RECEIVE_PACKET_FIELD_ERROR(road, ": truncation array");
      }
      for (i = 0; i < real_packet->length; i++) {
        {
          int readin;
      
          if (!dio_get_sint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(road);
          }
          real_packet->road[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'dest_tile'");
    if (!dio_get_sint32(&din, &real_packet->dest_tile)) {
      RECEIVE_PACKET_FIELD_ERROR(dest_tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_orders_100(struct connection *pc, const struct packet_unit_orders *packet)
{
  const struct packet_unit_orders *real_packet = packet;
  packet_unit_orders_100_fields fields;
  struct packet_unit_orders *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_ORDERS;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_ORDERS);

  log_packet_detailed("packet_unit_orders_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_orders_100, cmp_packet_unit_orders_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->src_tile != real_packet->src_tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->length != real_packet->length);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->repeat != real_packet->repeat);
  if(differ) {
    different++;
  }
  if (packet->repeat) {
    BV_SET(fields, 3);
  }

  differ = (old->vigilant != real_packet->vigilant);
  if(differ) {
    different++;
  }
  if (packet->vigilant) {
    BV_SET(fields, 4);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->orders[i] != real_packet->orders[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->dir[i] != real_packet->dir[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->activity[i] != real_packet->activity[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->base[i] != real_packet->base[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = (old->length != real_packet->length);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->length; i++) {
          if (old->road[i] != real_packet->road[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->dest_tile != real_packet->dest_tile);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'src_tile' has changed");
    dio_put_sint32(&dout, real_packet->src_tile);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'length' has changed");
    dio_put_uint16(&dout, real_packet->length);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'orders' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_uint8(&dout, real_packet->orders[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'dir' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_sint8(&dout, real_packet->dir[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'activity' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_uint8(&dout, real_packet->activity[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'base' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_sint8(&dout, real_packet->base[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'road' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->length; i++) {
        dio_put_sint8(&dout, real_packet->road[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'dest_tile' has changed");
    dio_put_sint32(&dout, real_packet->dest_tile);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_ORDERS);
}

static void ensure_valid_variant_packet_unit_orders(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_ORDERS] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_ORDERS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_ORDERS] = variant;
}

struct packet_unit_orders *receive_packet_unit_orders(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_orders at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_orders(pc);

  switch(pc->phs.variant[PACKET_UNIT_ORDERS]) {
  case 100:
    return receive_packet_unit_orders_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_ORDERS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_orders(struct connection *pc, const struct packet_unit_orders *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_orders from the server.");
  }
  ensure_valid_variant_packet_unit_orders(pc);

  switch(pc->phs.variant[PACKET_UNIT_ORDERS]) {

  case 100:
    return send_packet_unit_orders_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_ORDERS variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_unit_autosettlers_100 hash_const

#define cmp_packet_unit_autosettlers_100 cmp_const

BV_DEFINE(packet_unit_autosettlers_100_fields, 1);

static struct packet_unit_autosettlers *receive_packet_unit_autosettlers_100(struct connection *pc)
{
  packet_unit_autosettlers_100_fields fields;
  struct packet_unit_autosettlers *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_AUTOSETTLERS;
  RECEIVE_PACKET_START(packet_unit_autosettlers, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_autosettlers_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_autosettlers_100, cmp_packet_unit_autosettlers_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_autosettlers_100(struct connection *pc, const struct packet_unit_autosettlers *packet)
{
  const struct packet_unit_autosettlers *real_packet = packet;
  packet_unit_autosettlers_100_fields fields;
  struct packet_unit_autosettlers *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_AUTOSETTLERS;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_AUTOSETTLERS);

  log_packet_detailed("packet_unit_autosettlers_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_autosettlers_100, cmp_packet_unit_autosettlers_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_AUTOSETTLERS);
}

static void ensure_valid_variant_packet_unit_autosettlers(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_AUTOSETTLERS] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_AUTOSETTLERS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_AUTOSETTLERS] = variant;
}

struct packet_unit_autosettlers *receive_packet_unit_autosettlers(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_autosettlers at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_autosettlers(pc);

  switch(pc->phs.variant[PACKET_UNIT_AUTOSETTLERS]) {
  case 100:
    return receive_packet_unit_autosettlers_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_AUTOSETTLERS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_autosettlers(struct connection *pc, const struct packet_unit_autosettlers *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_autosettlers from the server.");
  }
  ensure_valid_variant_packet_unit_autosettlers(pc);

  switch(pc->phs.variant[PACKET_UNIT_AUTOSETTLERS]) {

  case 100:
    return send_packet_unit_autosettlers_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_AUTOSETTLERS variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_autosettlers(struct connection *pc, int unit_id)
{
  struct packet_unit_autosettlers packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_autosettlers(pc, real_packet);
}

#define hash_packet_unit_load_100 hash_const

#define cmp_packet_unit_load_100 cmp_const

BV_DEFINE(packet_unit_load_100_fields, 2);

static struct packet_unit_load *receive_packet_unit_load_100(struct connection *pc)
{
  packet_unit_load_100_fields fields;
  struct packet_unit_load *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_LOAD;
  RECEIVE_PACKET_START(packet_unit_load, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_load_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_load_100, cmp_packet_unit_load_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'cargo_id'");
    if (!dio_get_uint16(&din, &real_packet->cargo_id)) {
      RECEIVE_PACKET_FIELD_ERROR(cargo_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'transporter_id'");
    if (!dio_get_uint16(&din, &real_packet->transporter_id)) {
      RECEIVE_PACKET_FIELD_ERROR(transporter_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_load_100(struct connection *pc, const struct packet_unit_load *packet)
{
  const struct packet_unit_load *real_packet = packet;
  packet_unit_load_100_fields fields;
  struct packet_unit_load *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_LOAD;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_LOAD);

  log_packet_detailed("packet_unit_load_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_load_100, cmp_packet_unit_load_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->cargo_id != real_packet->cargo_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->transporter_id != real_packet->transporter_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'cargo_id' has changed");
    dio_put_uint16(&dout, real_packet->cargo_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'transporter_id' has changed");
    dio_put_uint16(&dout, real_packet->transporter_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_LOAD);
}

static void ensure_valid_variant_packet_unit_load(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_LOAD] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_LOAD variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_LOAD] = variant;
}

struct packet_unit_load *receive_packet_unit_load(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_load at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_load(pc);

  switch(pc->phs.variant[PACKET_UNIT_LOAD]) {
  case 100:
    return receive_packet_unit_load_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_LOAD variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_load(struct connection *pc, const struct packet_unit_load *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_load from the server.");
  }
  ensure_valid_variant_packet_unit_load(pc);

  switch(pc->phs.variant[PACKET_UNIT_LOAD]) {

  case 100:
    return send_packet_unit_load_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_LOAD variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_load(struct connection *pc, int cargo_id, int transporter_id)
{
  struct packet_unit_load packet, *real_packet = &packet;

  real_packet->cargo_id = cargo_id;
  real_packet->transporter_id = transporter_id;
  
  return send_packet_unit_load(pc, real_packet);
}

#define hash_packet_unit_unload_100 hash_const

#define cmp_packet_unit_unload_100 cmp_const

BV_DEFINE(packet_unit_unload_100_fields, 2);

static struct packet_unit_unload *receive_packet_unit_unload_100(struct connection *pc)
{
  packet_unit_unload_100_fields fields;
  struct packet_unit_unload *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_UNLOAD;
  RECEIVE_PACKET_START(packet_unit_unload, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_unload_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_unload_100, cmp_packet_unit_unload_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'cargo_id'");
    if (!dio_get_uint16(&din, &real_packet->cargo_id)) {
      RECEIVE_PACKET_FIELD_ERROR(cargo_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'transporter_id'");
    if (!dio_get_uint16(&din, &real_packet->transporter_id)) {
      RECEIVE_PACKET_FIELD_ERROR(transporter_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_unload_100(struct connection *pc, const struct packet_unit_unload *packet)
{
  const struct packet_unit_unload *real_packet = packet;
  packet_unit_unload_100_fields fields;
  struct packet_unit_unload *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_UNLOAD;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_UNLOAD);

  log_packet_detailed("packet_unit_unload_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_unload_100, cmp_packet_unit_unload_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->cargo_id != real_packet->cargo_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->transporter_id != real_packet->transporter_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'cargo_id' has changed");
    dio_put_uint16(&dout, real_packet->cargo_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'transporter_id' has changed");
    dio_put_uint16(&dout, real_packet->transporter_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_UNLOAD);
}

static void ensure_valid_variant_packet_unit_unload(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_UNLOAD] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_UNLOAD variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_UNLOAD] = variant;
}

struct packet_unit_unload *receive_packet_unit_unload(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_unload at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_unload(pc);

  switch(pc->phs.variant[PACKET_UNIT_UNLOAD]) {
  case 100:
    return receive_packet_unit_unload_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_UNLOAD variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_unload(struct connection *pc, const struct packet_unit_unload *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_unload from the server.");
  }
  ensure_valid_variant_packet_unit_unload(pc);

  switch(pc->phs.variant[PACKET_UNIT_UNLOAD]) {

  case 100:
    return send_packet_unit_unload_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_UNLOAD variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_unload(struct connection *pc, int cargo_id, int transporter_id)
{
  struct packet_unit_unload packet, *real_packet = &packet;

  real_packet->cargo_id = cargo_id;
  real_packet->transporter_id = transporter_id;
  
  return send_packet_unit_unload(pc, real_packet);
}

#define hash_packet_unit_upgrade_100 hash_const

#define cmp_packet_unit_upgrade_100 cmp_const

BV_DEFINE(packet_unit_upgrade_100_fields, 1);

static struct packet_unit_upgrade *receive_packet_unit_upgrade_100(struct connection *pc)
{
  packet_unit_upgrade_100_fields fields;
  struct packet_unit_upgrade *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_UPGRADE;
  RECEIVE_PACKET_START(packet_unit_upgrade, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_upgrade_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_upgrade_100, cmp_packet_unit_upgrade_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_upgrade_100(struct connection *pc, const struct packet_unit_upgrade *packet)
{
  const struct packet_unit_upgrade *real_packet = packet;
  packet_unit_upgrade_100_fields fields;
  struct packet_unit_upgrade *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_UPGRADE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_UPGRADE);

  log_packet_detailed("packet_unit_upgrade_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_upgrade_100, cmp_packet_unit_upgrade_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_UPGRADE);
}

static void ensure_valid_variant_packet_unit_upgrade(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_UPGRADE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_UPGRADE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_UPGRADE] = variant;
}

struct packet_unit_upgrade *receive_packet_unit_upgrade(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_upgrade at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_upgrade(pc);

  switch(pc->phs.variant[PACKET_UNIT_UPGRADE]) {
  case 100:
    return receive_packet_unit_upgrade_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_UPGRADE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_upgrade(struct connection *pc, const struct packet_unit_upgrade *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_upgrade from the server.");
  }
  ensure_valid_variant_packet_unit_upgrade(pc);

  switch(pc->phs.variant[PACKET_UNIT_UPGRADE]) {

  case 100:
    return send_packet_unit_upgrade_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_UPGRADE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_upgrade(struct connection *pc, int unit_id)
{
  struct packet_unit_upgrade packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_upgrade(pc, real_packet);
}

#define hash_packet_unit_nuke_100 hash_const

#define cmp_packet_unit_nuke_100 cmp_const

BV_DEFINE(packet_unit_nuke_100_fields, 1);

static struct packet_unit_nuke *receive_packet_unit_nuke_100(struct connection *pc)
{
  packet_unit_nuke_100_fields fields;
  struct packet_unit_nuke *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_NUKE;
  RECEIVE_PACKET_START(packet_unit_nuke, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_nuke_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_nuke_100, cmp_packet_unit_nuke_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_nuke_100(struct connection *pc, const struct packet_unit_nuke *packet)
{
  const struct packet_unit_nuke *real_packet = packet;
  packet_unit_nuke_100_fields fields;
  struct packet_unit_nuke *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_NUKE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_NUKE);

  log_packet_detailed("packet_unit_nuke_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_nuke_100, cmp_packet_unit_nuke_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_NUKE);
}

static void ensure_valid_variant_packet_unit_nuke(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_NUKE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_NUKE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_NUKE] = variant;
}

struct packet_unit_nuke *receive_packet_unit_nuke(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_nuke at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_nuke(pc);

  switch(pc->phs.variant[PACKET_UNIT_NUKE]) {
  case 100:
    return receive_packet_unit_nuke_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_NUKE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_nuke(struct connection *pc, const struct packet_unit_nuke *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_nuke from the server.");
  }
  ensure_valid_variant_packet_unit_nuke(pc);

  switch(pc->phs.variant[PACKET_UNIT_NUKE]) {

  case 100:
    return send_packet_unit_nuke_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_NUKE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_nuke(struct connection *pc, int unit_id)
{
  struct packet_unit_nuke packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  
  return send_packet_unit_nuke(pc, real_packet);
}

#define hash_packet_unit_paradrop_to_100 hash_const

#define cmp_packet_unit_paradrop_to_100 cmp_const

BV_DEFINE(packet_unit_paradrop_to_100_fields, 2);

static struct packet_unit_paradrop_to *receive_packet_unit_paradrop_to_100(struct connection *pc)
{
  packet_unit_paradrop_to_100_fields fields;
  struct packet_unit_paradrop_to *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_PARADROP_TO;
  RECEIVE_PACKET_START(packet_unit_paradrop_to, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_paradrop_to_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_paradrop_to_100, cmp_packet_unit_paradrop_to_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tile'");
    if (!dio_get_sint32(&din, &real_packet->tile)) {
      RECEIVE_PACKET_FIELD_ERROR(tile);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_paradrop_to_100(struct connection *pc, const struct packet_unit_paradrop_to *packet)
{
  const struct packet_unit_paradrop_to *real_packet = packet;
  packet_unit_paradrop_to_100_fields fields;
  struct packet_unit_paradrop_to *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_PARADROP_TO;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_PARADROP_TO);

  log_packet_detailed("packet_unit_paradrop_to_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_paradrop_to_100, cmp_packet_unit_paradrop_to_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tile != real_packet->tile);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tile' has changed");
    dio_put_sint32(&dout, real_packet->tile);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_PARADROP_TO);
}

static void ensure_valid_variant_packet_unit_paradrop_to(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_PARADROP_TO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_PARADROP_TO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_PARADROP_TO] = variant;
}

struct packet_unit_paradrop_to *receive_packet_unit_paradrop_to(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_paradrop_to at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_paradrop_to(pc);

  switch(pc->phs.variant[PACKET_UNIT_PARADROP_TO]) {
  case 100:
    return receive_packet_unit_paradrop_to_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_PARADROP_TO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_paradrop_to(struct connection *pc, const struct packet_unit_paradrop_to *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_paradrop_to from the server.");
  }
  ensure_valid_variant_packet_unit_paradrop_to(pc);

  switch(pc->phs.variant[PACKET_UNIT_PARADROP_TO]) {

  case 100:
    return send_packet_unit_paradrop_to_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_PARADROP_TO variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_paradrop_to(struct connection *pc, int unit_id, int tile)
{
  struct packet_unit_paradrop_to packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->tile = tile;
  
  return send_packet_unit_paradrop_to(pc, real_packet);
}

#define hash_packet_unit_airlift_100 hash_const

#define cmp_packet_unit_airlift_100 cmp_const

BV_DEFINE(packet_unit_airlift_100_fields, 2);

static struct packet_unit_airlift *receive_packet_unit_airlift_100(struct connection *pc)
{
  packet_unit_airlift_100_fields fields;
  struct packet_unit_airlift *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_AIRLIFT;
  RECEIVE_PACKET_START(packet_unit_airlift, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_airlift_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_airlift_100, cmp_packet_unit_airlift_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'city_id'");
    if (!dio_get_uint16(&din, &real_packet->city_id)) {
      RECEIVE_PACKET_FIELD_ERROR(city_id);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_airlift_100(struct connection *pc, const struct packet_unit_airlift *packet)
{
  const struct packet_unit_airlift *real_packet = packet;
  packet_unit_airlift_100_fields fields;
  struct packet_unit_airlift *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_AIRLIFT;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_AIRLIFT);

  log_packet_detailed("packet_unit_airlift_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_airlift_100, cmp_packet_unit_airlift_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->city_id != real_packet->city_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'city_id' has changed");
    dio_put_uint16(&dout, real_packet->city_id);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_AIRLIFT);
}

static void ensure_valid_variant_packet_unit_airlift(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_AIRLIFT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_AIRLIFT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_AIRLIFT] = variant;
}

struct packet_unit_airlift *receive_packet_unit_airlift(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_airlift at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_airlift(pc);

  switch(pc->phs.variant[PACKET_UNIT_AIRLIFT]) {
  case 100:
    return receive_packet_unit_airlift_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_AIRLIFT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_airlift(struct connection *pc, const struct packet_unit_airlift *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_airlift from the server.");
  }
  ensure_valid_variant_packet_unit_airlift(pc);

  switch(pc->phs.variant[PACKET_UNIT_AIRLIFT]) {

  case 100:
    return send_packet_unit_airlift_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_AIRLIFT variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_airlift(struct connection *pc, int unit_id, int city_id)
{
  struct packet_unit_airlift packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->city_id = city_id;
  
  return send_packet_unit_airlift(pc, real_packet);
}

#define hash_packet_unit_diplomat_query_100 hash_const

#define cmp_packet_unit_diplomat_query_100 cmp_const

BV_DEFINE(packet_unit_diplomat_query_100_fields, 4);

static struct packet_unit_diplomat_query *receive_packet_unit_diplomat_query_100(struct connection *pc)
{
  packet_unit_diplomat_query_100_fields fields;
  struct packet_unit_diplomat_query *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_DIPLOMAT_QUERY;
  RECEIVE_PACKET_START(packet_unit_diplomat_query, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_diplomat_query_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_query_100, cmp_packet_unit_diplomat_query_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    if (!dio_get_uint16(&din, &real_packet->diplomat_id)) {
      RECEIVE_PACKET_FIELD_ERROR(diplomat_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_id'");
    if (!dio_get_uint16(&din, &real_packet->target_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'value'");
    if (!dio_get_sint16(&din, &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'action_type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(action_type);
      }
      real_packet->action_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_diplomat_query_100(struct connection *pc, const struct packet_unit_diplomat_query *packet)
{
  const struct packet_unit_diplomat_query *real_packet = packet;
  packet_unit_diplomat_query_100_fields fields;
  struct packet_unit_diplomat_query *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DIPLOMAT_QUERY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DIPLOMAT_QUERY);

  log_packet_detailed("packet_unit_diplomat_query_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_query_100, cmp_packet_unit_diplomat_query_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_id != real_packet->target_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->action_type != real_packet->action_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    dio_put_uint16(&dout, real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_id' has changed");
    dio_put_uint16(&dout, real_packet->target_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_sint16(&dout, real_packet->value);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'action_type' has changed");
    dio_put_uint8(&dout, real_packet->action_type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_DIPLOMAT_QUERY);
}

static void ensure_valid_variant_packet_unit_diplomat_query(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_DIPLOMAT_QUERY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_DIPLOMAT_QUERY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_DIPLOMAT_QUERY] = variant;
}

struct packet_unit_diplomat_query *receive_packet_unit_diplomat_query(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_diplomat_query at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_diplomat_query(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_QUERY]) {
  case 100:
    return receive_packet_unit_diplomat_query_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_QUERY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_diplomat_query(struct connection *pc, const struct packet_unit_diplomat_query *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_diplomat_query from the server.");
  }
  ensure_valid_variant_packet_unit_diplomat_query(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_QUERY]) {

  case 100:
    return send_packet_unit_diplomat_query_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_QUERY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_diplomat_query(struct connection *pc, int diplomat_id, int target_id, int value, enum diplomat_actions action_type)
{
  struct packet_unit_diplomat_query packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->value = value;
  real_packet->action_type = action_type;
  
  return send_packet_unit_diplomat_query(pc, real_packet);
}

#define hash_packet_unit_type_upgrade_100 hash_const

#define cmp_packet_unit_type_upgrade_100 cmp_const

BV_DEFINE(packet_unit_type_upgrade_100_fields, 1);

static struct packet_unit_type_upgrade *receive_packet_unit_type_upgrade_100(struct connection *pc)
{
  packet_unit_type_upgrade_100_fields fields;
  struct packet_unit_type_upgrade *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_TYPE_UPGRADE;
  RECEIVE_PACKET_START(packet_unit_type_upgrade, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_type_upgrade_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_type_upgrade_100, cmp_packet_unit_type_upgrade_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_type_upgrade_100(struct connection *pc, const struct packet_unit_type_upgrade *packet)
{
  const struct packet_unit_type_upgrade *real_packet = packet;
  packet_unit_type_upgrade_100_fields fields;
  struct packet_unit_type_upgrade *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_TYPE_UPGRADE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_TYPE_UPGRADE);

  log_packet_detailed("packet_unit_type_upgrade_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_type_upgrade_100, cmp_packet_unit_type_upgrade_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_TYPE_UPGRADE);
}

static void ensure_valid_variant_packet_unit_type_upgrade(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_TYPE_UPGRADE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_TYPE_UPGRADE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_TYPE_UPGRADE] = variant;
}

struct packet_unit_type_upgrade *receive_packet_unit_type_upgrade(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_type_upgrade at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_type_upgrade(pc);

  switch(pc->phs.variant[PACKET_UNIT_TYPE_UPGRADE]) {
  case 100:
    return receive_packet_unit_type_upgrade_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_TYPE_UPGRADE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_type_upgrade(struct connection *pc, const struct packet_unit_type_upgrade *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_type_upgrade from the server.");
  }
  ensure_valid_variant_packet_unit_type_upgrade(pc);

  switch(pc->phs.variant[PACKET_UNIT_TYPE_UPGRADE]) {

  case 100:
    return send_packet_unit_type_upgrade_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_TYPE_UPGRADE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_type_upgrade(struct connection *pc, Unit_type_id type)
{
  struct packet_unit_type_upgrade packet, *real_packet = &packet;

  real_packet->type = type;
  
  return send_packet_unit_type_upgrade(pc, real_packet);
}

#define hash_packet_unit_diplomat_action_100 hash_const

#define cmp_packet_unit_diplomat_action_100 cmp_const

BV_DEFINE(packet_unit_diplomat_action_100_fields, 4);

static struct packet_unit_diplomat_action *receive_packet_unit_diplomat_action_100(struct connection *pc)
{
  packet_unit_diplomat_action_100_fields fields;
  struct packet_unit_diplomat_action *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_DIPLOMAT_ACTION;
  RECEIVE_PACKET_START(packet_unit_diplomat_action, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_diplomat_action_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_action_100, cmp_packet_unit_diplomat_action_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    if (!dio_get_uint16(&din, &real_packet->diplomat_id)) {
      RECEIVE_PACKET_FIELD_ERROR(diplomat_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_id'");
    if (!dio_get_uint16(&din, &real_packet->target_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'value'");
    if (!dio_get_sint16(&din, &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'action_type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(action_type);
      }
      real_packet->action_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_diplomat_action_100(struct connection *pc, const struct packet_unit_diplomat_action *packet)
{
  const struct packet_unit_diplomat_action *real_packet = packet;
  packet_unit_diplomat_action_100_fields fields;
  struct packet_unit_diplomat_action *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DIPLOMAT_ACTION;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DIPLOMAT_ACTION);

  log_packet_detailed("packet_unit_diplomat_action_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_action_100, cmp_packet_unit_diplomat_action_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_id != real_packet->target_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->action_type != real_packet->action_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    dio_put_uint16(&dout, real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_id' has changed");
    dio_put_uint16(&dout, real_packet->target_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_sint16(&dout, real_packet->value);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'action_type' has changed");
    dio_put_uint8(&dout, real_packet->action_type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_DIPLOMAT_ACTION);
}

static void ensure_valid_variant_packet_unit_diplomat_action(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ACTION] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_DIPLOMAT_ACTION variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_DIPLOMAT_ACTION] = variant;
}

struct packet_unit_diplomat_action *receive_packet_unit_diplomat_action(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_diplomat_action at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_diplomat_action(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ACTION]) {
  case 100:
    return receive_packet_unit_diplomat_action_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_ACTION variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_diplomat_action(struct connection *pc, const struct packet_unit_diplomat_action *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_diplomat_action from the server.");
  }
  ensure_valid_variant_packet_unit_diplomat_action(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ACTION]) {

  case 100:
    return send_packet_unit_diplomat_action_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_ACTION variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_diplomat_action(struct connection *pc, int diplomat_id, int target_id, int value, enum diplomat_actions action_type)
{
  struct packet_unit_diplomat_action packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->value = value;
  real_packet->action_type = action_type;
  
  return send_packet_unit_diplomat_action(pc, real_packet);
}

#define hash_packet_unit_diplomat_answer_100 hash_const

#define cmp_packet_unit_diplomat_answer_100 cmp_const

BV_DEFINE(packet_unit_diplomat_answer_100_fields, 4);

static struct packet_unit_diplomat_answer *receive_packet_unit_diplomat_answer_100(struct connection *pc)
{
  packet_unit_diplomat_answer_100_fields fields;
  struct packet_unit_diplomat_answer *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_DIPLOMAT_ANSWER;
  RECEIVE_PACKET_START(packet_unit_diplomat_answer, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_diplomat_answer_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_answer_100, cmp_packet_unit_diplomat_answer_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'diplomat_id'");
    if (!dio_get_uint16(&din, &real_packet->diplomat_id)) {
      RECEIVE_PACKET_FIELD_ERROR(diplomat_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'target_id'");
    if (!dio_get_uint16(&din, &real_packet->target_id)) {
      RECEIVE_PACKET_FIELD_ERROR(target_id);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'cost'");
    if (!dio_get_uint32(&din, &real_packet->cost)) {
      RECEIVE_PACKET_FIELD_ERROR(cost);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'action_type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(action_type);
      }
      real_packet->action_type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_diplomat_answer_100(struct connection *pc, const struct packet_unit_diplomat_answer *packet)
{
  const struct packet_unit_diplomat_answer *real_packet = packet;
  packet_unit_diplomat_answer_100_fields fields;
  struct packet_unit_diplomat_answer *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_DIPLOMAT_ANSWER;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_DIPLOMAT_ANSWER);

  log_packet_detailed("packet_unit_diplomat_answer_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_diplomat_answer_100, cmp_packet_unit_diplomat_answer_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->diplomat_id != real_packet->diplomat_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->target_id != real_packet->target_id);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->cost != real_packet->cost);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->action_type != real_packet->action_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'diplomat_id' has changed");
    dio_put_uint16(&dout, real_packet->diplomat_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'target_id' has changed");
    dio_put_uint16(&dout, real_packet->target_id);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'cost' has changed");
    dio_put_uint32(&dout, real_packet->cost);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'action_type' has changed");
    dio_put_uint8(&dout, real_packet->action_type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_DIPLOMAT_ANSWER);
}

static void ensure_valid_variant_packet_unit_diplomat_answer(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ANSWER] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_DIPLOMAT_ANSWER variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_DIPLOMAT_ANSWER] = variant;
}

struct packet_unit_diplomat_answer *receive_packet_unit_diplomat_answer(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_unit_diplomat_answer at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_diplomat_answer(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ANSWER]) {
  case 100:
    return receive_packet_unit_diplomat_answer_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_ANSWER variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_diplomat_answer(struct connection *pc, const struct packet_unit_diplomat_answer *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_unit_diplomat_answer from the client.");
  }
  ensure_valid_variant_packet_unit_diplomat_answer(pc);

  switch(pc->phs.variant[PACKET_UNIT_DIPLOMAT_ANSWER]) {

  case 100:
    return send_packet_unit_diplomat_answer_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_DIPLOMAT_ANSWER variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_unit_diplomat_answer(struct conn_list *dest, const struct packet_unit_diplomat_answer *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_unit_diplomat_answer(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_unit_diplomat_answer(struct connection *pc, int diplomat_id, int target_id, int cost, enum diplomat_actions action_type)
{
  struct packet_unit_diplomat_answer packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->cost = cost;
  real_packet->action_type = action_type;
  
  return send_packet_unit_diplomat_answer(pc, real_packet);
}

void dlsend_packet_unit_diplomat_answer(struct conn_list *dest, int diplomat_id, int target_id, int cost, enum diplomat_actions action_type)
{
  struct packet_unit_diplomat_answer packet, *real_packet = &packet;

  real_packet->diplomat_id = diplomat_id;
  real_packet->target_id = target_id;
  real_packet->cost = cost;
  real_packet->action_type = action_type;
  
  lsend_packet_unit_diplomat_answer(dest, real_packet);
}

#define hash_packet_unit_change_activity_100 hash_const

#define cmp_packet_unit_change_activity_100 cmp_const

BV_DEFINE(packet_unit_change_activity_100_fields, 3);

static struct packet_unit_change_activity *receive_packet_unit_change_activity_100(struct connection *pc)
{
  packet_unit_change_activity_100_fields fields;
  struct packet_unit_change_activity *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_CHANGE_ACTIVITY;
  RECEIVE_PACKET_START(packet_unit_change_activity, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_change_activity_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_100, cmp_packet_unit_change_activity_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'activity_target'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_target);
      }
      real_packet->activity_target = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_change_activity_100(struct connection *pc, const struct packet_unit_change_activity *packet)
{
  const struct packet_unit_change_activity *real_packet = packet;
  packet_unit_change_activity_100_fields fields;
  struct packet_unit_change_activity *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_CHANGE_ACTIVITY;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_CHANGE_ACTIVITY);

  log_packet_detailed("packet_unit_change_activity_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_100, cmp_packet_unit_change_activity_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->activity_target != real_packet->activity_target);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'activity_target' has changed");
    dio_put_uint8(&dout, real_packet->activity_target);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_CHANGE_ACTIVITY);
}

static void ensure_valid_variant_packet_unit_change_activity(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_CHANGE_ACTIVITY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY] = variant;
}

struct packet_unit_change_activity *receive_packet_unit_change_activity(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_change_activity at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_change_activity(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY]) {
  case 100:
    return receive_packet_unit_change_activity_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_ACTIVITY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_change_activity(struct connection *pc, const struct packet_unit_change_activity *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_change_activity from the server.");
  }
  ensure_valid_variant_packet_unit_change_activity(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY]) {

  case 100:
    return send_packet_unit_change_activity_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_ACTIVITY variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_change_activity(struct connection *pc, int unit_id, enum unit_activity activity, enum tile_special_type activity_target)
{
  struct packet_unit_change_activity packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->activity = activity;
  real_packet->activity_target = activity_target;
  
  return send_packet_unit_change_activity(pc, real_packet);
}

#define hash_packet_unit_change_activity_base_100 hash_const

#define cmp_packet_unit_change_activity_base_100 cmp_const

BV_DEFINE(packet_unit_change_activity_base_100_fields, 3);

static struct packet_unit_change_activity_base *receive_packet_unit_change_activity_base_100(struct connection *pc)
{
  packet_unit_change_activity_base_100_fields fields;
  struct packet_unit_change_activity_base *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_CHANGE_ACTIVITY_BASE;
  RECEIVE_PACKET_START(packet_unit_change_activity_base, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_change_activity_base_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_base_100, cmp_packet_unit_change_activity_base_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'activity_base'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_base);
      }
      real_packet->activity_base = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_change_activity_base_100(struct connection *pc, const struct packet_unit_change_activity_base *packet)
{
  const struct packet_unit_change_activity_base *real_packet = packet;
  packet_unit_change_activity_base_100_fields fields;
  struct packet_unit_change_activity_base *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_CHANGE_ACTIVITY_BASE;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_CHANGE_ACTIVITY_BASE);

  log_packet_detailed("packet_unit_change_activity_base_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_base_100, cmp_packet_unit_change_activity_base_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->activity_base != real_packet->activity_base);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'activity_base' has changed");
    dio_put_sint8(&dout, real_packet->activity_base);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_CHANGE_ACTIVITY_BASE);
}

static void ensure_valid_variant_packet_unit_change_activity_base(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY_BASE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_CHANGE_ACTIVITY_BASE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY_BASE] = variant;
}

struct packet_unit_change_activity_base *receive_packet_unit_change_activity_base(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_change_activity_base at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_change_activity_base(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY_BASE]) {
  case 100:
    return receive_packet_unit_change_activity_base_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_ACTIVITY_BASE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_change_activity_base(struct connection *pc, const struct packet_unit_change_activity_base *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_change_activity_base from the server.");
  }
  ensure_valid_variant_packet_unit_change_activity_base(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY_BASE]) {

  case 100:
    return send_packet_unit_change_activity_base_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_ACTIVITY_BASE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_change_activity_base(struct connection *pc, int unit_id, enum unit_activity activity, Base_type_id activity_base)
{
  struct packet_unit_change_activity_base packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->activity = activity;
  real_packet->activity_base = activity_base;
  
  return send_packet_unit_change_activity_base(pc, real_packet);
}

#define hash_packet_unit_change_activity_road_100 hash_const

#define cmp_packet_unit_change_activity_road_100 cmp_const

BV_DEFINE(packet_unit_change_activity_road_100_fields, 3);

static struct packet_unit_change_activity_road *receive_packet_unit_change_activity_road_100(struct connection *pc)
{
  packet_unit_change_activity_road_100_fields fields;
  struct packet_unit_change_activity_road *old;
  struct genhash **hash = pc->phs.received + PACKET_UNIT_CHANGE_ACTIVITY_ROAD;
  RECEIVE_PACKET_START(packet_unit_change_activity_road, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_unit_change_activity_road_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_road_100, cmp_packet_unit_change_activity_road_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit_id'");
    if (!dio_get_uint16(&din, &real_packet->unit_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'activity'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity);
      }
      real_packet->activity = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'activity_road'");
    {
      int readin;
      
      if (!dio_get_sint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(activity_road);
      }
      real_packet->activity_road = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_unit_change_activity_road_100(struct connection *pc, const struct packet_unit_change_activity_road *packet)
{
  const struct packet_unit_change_activity_road *real_packet = packet;
  packet_unit_change_activity_road_100_fields fields;
  struct packet_unit_change_activity_road *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_UNIT_CHANGE_ACTIVITY_ROAD;
  int different = 0;
  SEND_PACKET_START(PACKET_UNIT_CHANGE_ACTIVITY_ROAD);

  log_packet_detailed("packet_unit_change_activity_road_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_unit_change_activity_road_100, cmp_packet_unit_change_activity_road_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit_id != real_packet->unit_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->activity != real_packet->activity);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->activity_road != real_packet->activity_road);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit_id' has changed");
    dio_put_uint16(&dout, real_packet->unit_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'activity' has changed");
    dio_put_uint8(&dout, real_packet->activity);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'activity_road' has changed");
    dio_put_sint8(&dout, real_packet->activity_road);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_UNIT_CHANGE_ACTIVITY_ROAD);
}

static void ensure_valid_variant_packet_unit_change_activity_road(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY_ROAD] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_UNIT_CHANGE_ACTIVITY_ROAD variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY_ROAD] = variant;
}

struct packet_unit_change_activity_road *receive_packet_unit_change_activity_road(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_unit_change_activity_road at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_unit_change_activity_road(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY_ROAD]) {
  case 100:
    return receive_packet_unit_change_activity_road_100(pc);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_ACTIVITY_ROAD variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_unit_change_activity_road(struct connection *pc, const struct packet_unit_change_activity_road *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_unit_change_activity_road from the server.");
  }
  ensure_valid_variant_packet_unit_change_activity_road(pc);

  switch(pc->phs.variant[PACKET_UNIT_CHANGE_ACTIVITY_ROAD]) {

  case 100:
    return send_packet_unit_change_activity_road_100(pc, packet);
  default:
    log_debug("Unknown PACKET_UNIT_CHANGE_ACTIVITY_ROAD variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_unit_change_activity_road(struct connection *pc, int unit_id, enum unit_activity activity, Road_type_id activity_road)
{
  struct packet_unit_change_activity_road packet, *real_packet = &packet;

  real_packet->unit_id = unit_id;
  real_packet->activity = activity;
  real_packet->activity_road = activity_road;
  
  return send_packet_unit_change_activity_road(pc, real_packet);
}

#define hash_packet_diplomacy_init_meeting_req_100 hash_const

#define cmp_packet_diplomacy_init_meeting_req_100 cmp_const

BV_DEFINE(packet_diplomacy_init_meeting_req_100_fields, 1);

static struct packet_diplomacy_init_meeting_req *receive_packet_diplomacy_init_meeting_req_100(struct connection *pc)
{
  packet_diplomacy_init_meeting_req_100_fields fields;
  struct packet_diplomacy_init_meeting_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_INIT_MEETING_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_init_meeting_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_init_meeting_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_req_100, cmp_packet_diplomacy_init_meeting_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_init_meeting_req_100(struct connection *pc, const struct packet_diplomacy_init_meeting_req *packet)
{
  const struct packet_diplomacy_init_meeting_req *real_packet = packet;
  packet_diplomacy_init_meeting_req_100_fields fields;
  struct packet_diplomacy_init_meeting_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_INIT_MEETING_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_INIT_MEETING_REQ);

  log_packet_detailed("packet_diplomacy_init_meeting_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_req_100, cmp_packet_diplomacy_init_meeting_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_INIT_MEETING_REQ);
}

static void ensure_valid_variant_packet_diplomacy_init_meeting_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_INIT_MEETING_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING_REQ] = variant;
}

struct packet_diplomacy_init_meeting_req *receive_packet_diplomacy_init_meeting_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_diplomacy_init_meeting_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_init_meeting_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING_REQ]) {
  case 100:
    return receive_packet_diplomacy_init_meeting_req_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_INIT_MEETING_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_init_meeting_req(struct connection *pc, const struct packet_diplomacy_init_meeting_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_init_meeting_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_init_meeting_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING_REQ]) {

  case 100:
    return send_packet_diplomacy_init_meeting_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_INIT_MEETING_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_init_meeting_req(struct connection *pc, int counterpart)
{
  struct packet_diplomacy_init_meeting_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  
  return send_packet_diplomacy_init_meeting_req(pc, real_packet);
}

#define hash_packet_diplomacy_init_meeting_100 hash_const

#define cmp_packet_diplomacy_init_meeting_100 cmp_const

BV_DEFINE(packet_diplomacy_init_meeting_100_fields, 2);

static struct packet_diplomacy_init_meeting *receive_packet_diplomacy_init_meeting_100(struct connection *pc)
{
  packet_diplomacy_init_meeting_100_fields fields;
  struct packet_diplomacy_init_meeting *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_INIT_MEETING;
  RECEIVE_PACKET_START(packet_diplomacy_init_meeting, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_init_meeting_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_100, cmp_packet_diplomacy_init_meeting_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'initiated_from'");
    if (!dio_get_sint8(&din, &real_packet->initiated_from)) {
      RECEIVE_PACKET_FIELD_ERROR(initiated_from);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_init_meeting_100(struct connection *pc, const struct packet_diplomacy_init_meeting *packet)
{
  const struct packet_diplomacy_init_meeting *real_packet = packet;
  packet_diplomacy_init_meeting_100_fields fields;
  struct packet_diplomacy_init_meeting *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_INIT_MEETING;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_INIT_MEETING);

  log_packet_detailed("packet_diplomacy_init_meeting_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_init_meeting_100, cmp_packet_diplomacy_init_meeting_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->initiated_from != real_packet->initiated_from);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'initiated_from' has changed");
    dio_put_sint8(&dout, real_packet->initiated_from);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_INIT_MEETING);
}

static void ensure_valid_variant_packet_diplomacy_init_meeting(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_INIT_MEETING variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING] = variant;
}

struct packet_diplomacy_init_meeting *receive_packet_diplomacy_init_meeting(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_diplomacy_init_meeting at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_init_meeting(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING]) {
  case 100:
    return receive_packet_diplomacy_init_meeting_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_INIT_MEETING variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_init_meeting(struct connection *pc, const struct packet_diplomacy_init_meeting *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_init_meeting from the client.");
  }
  ensure_valid_variant_packet_diplomacy_init_meeting(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_INIT_MEETING]) {

  case 100:
    return send_packet_diplomacy_init_meeting_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_INIT_MEETING variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_init_meeting(struct conn_list *dest, const struct packet_diplomacy_init_meeting *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_init_meeting(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_init_meeting(struct connection *pc, int counterpart, int initiated_from)
{
  struct packet_diplomacy_init_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  return send_packet_diplomacy_init_meeting(pc, real_packet);
}

void dlsend_packet_diplomacy_init_meeting(struct conn_list *dest, int counterpart, int initiated_from)
{
  struct packet_diplomacy_init_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  lsend_packet_diplomacy_init_meeting(dest, real_packet);
}

#define hash_packet_diplomacy_cancel_meeting_req_100 hash_const

#define cmp_packet_diplomacy_cancel_meeting_req_100 cmp_const

BV_DEFINE(packet_diplomacy_cancel_meeting_req_100_fields, 1);

static struct packet_diplomacy_cancel_meeting_req *receive_packet_diplomacy_cancel_meeting_req_100(struct connection *pc)
{
  packet_diplomacy_cancel_meeting_req_100_fields fields;
  struct packet_diplomacy_cancel_meeting_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CANCEL_MEETING_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_cancel_meeting_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_cancel_meeting_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_req_100, cmp_packet_diplomacy_cancel_meeting_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_cancel_meeting_req_100(struct connection *pc, const struct packet_diplomacy_cancel_meeting_req *packet)
{
  const struct packet_diplomacy_cancel_meeting_req *real_packet = packet;
  packet_diplomacy_cancel_meeting_req_100_fields fields;
  struct packet_diplomacy_cancel_meeting_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CANCEL_MEETING_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CANCEL_MEETING_REQ);

  log_packet_detailed("packet_diplomacy_cancel_meeting_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_req_100, cmp_packet_diplomacy_cancel_meeting_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CANCEL_MEETING_REQ);
}

static void ensure_valid_variant_packet_diplomacy_cancel_meeting_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CANCEL_MEETING_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING_REQ] = variant;
}

struct packet_diplomacy_cancel_meeting_req *receive_packet_diplomacy_cancel_meeting_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_diplomacy_cancel_meeting_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_cancel_meeting_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING_REQ]) {
  case 100:
    return receive_packet_diplomacy_cancel_meeting_req_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_MEETING_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_cancel_meeting_req(struct connection *pc, const struct packet_diplomacy_cancel_meeting_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_cancel_meeting_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_cancel_meeting_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING_REQ]) {

  case 100:
    return send_packet_diplomacy_cancel_meeting_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_MEETING_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_cancel_meeting_req(struct connection *pc, int counterpart)
{
  struct packet_diplomacy_cancel_meeting_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  
  return send_packet_diplomacy_cancel_meeting_req(pc, real_packet);
}

#define hash_packet_diplomacy_cancel_meeting_100 hash_const

#define cmp_packet_diplomacy_cancel_meeting_100 cmp_const

BV_DEFINE(packet_diplomacy_cancel_meeting_100_fields, 2);

static struct packet_diplomacy_cancel_meeting *receive_packet_diplomacy_cancel_meeting_100(struct connection *pc)
{
  packet_diplomacy_cancel_meeting_100_fields fields;
  struct packet_diplomacy_cancel_meeting *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CANCEL_MEETING;
  RECEIVE_PACKET_START(packet_diplomacy_cancel_meeting, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_cancel_meeting_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_100, cmp_packet_diplomacy_cancel_meeting_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'initiated_from'");
    if (!dio_get_sint8(&din, &real_packet->initiated_from)) {
      RECEIVE_PACKET_FIELD_ERROR(initiated_from);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_cancel_meeting_100(struct connection *pc, const struct packet_diplomacy_cancel_meeting *packet)
{
  const struct packet_diplomacy_cancel_meeting *real_packet = packet;
  packet_diplomacy_cancel_meeting_100_fields fields;
  struct packet_diplomacy_cancel_meeting *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CANCEL_MEETING;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CANCEL_MEETING);

  log_packet_detailed("packet_diplomacy_cancel_meeting_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_meeting_100, cmp_packet_diplomacy_cancel_meeting_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->initiated_from != real_packet->initiated_from);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'initiated_from' has changed");
    dio_put_sint8(&dout, real_packet->initiated_from);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CANCEL_MEETING);
}

static void ensure_valid_variant_packet_diplomacy_cancel_meeting(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CANCEL_MEETING variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING] = variant;
}

struct packet_diplomacy_cancel_meeting *receive_packet_diplomacy_cancel_meeting(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_diplomacy_cancel_meeting at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_cancel_meeting(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING]) {
  case 100:
    return receive_packet_diplomacy_cancel_meeting_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_MEETING variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_cancel_meeting(struct connection *pc, const struct packet_diplomacy_cancel_meeting *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_cancel_meeting from the client.");
  }
  ensure_valid_variant_packet_diplomacy_cancel_meeting(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_MEETING]) {

  case 100:
    return send_packet_diplomacy_cancel_meeting_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_MEETING variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_cancel_meeting(struct conn_list *dest, const struct packet_diplomacy_cancel_meeting *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_cancel_meeting(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_cancel_meeting(struct connection *pc, int counterpart, int initiated_from)
{
  struct packet_diplomacy_cancel_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  return send_packet_diplomacy_cancel_meeting(pc, real_packet);
}

void dlsend_packet_diplomacy_cancel_meeting(struct conn_list *dest, int counterpart, int initiated_from)
{
  struct packet_diplomacy_cancel_meeting packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->initiated_from = initiated_from;
  
  lsend_packet_diplomacy_cancel_meeting(dest, real_packet);
}

#define hash_packet_diplomacy_create_clause_req_100 hash_const

#define cmp_packet_diplomacy_create_clause_req_100 cmp_const

BV_DEFINE(packet_diplomacy_create_clause_req_100_fields, 4);

static struct packet_diplomacy_create_clause_req *receive_packet_diplomacy_create_clause_req_100(struct connection *pc)
{
  packet_diplomacy_create_clause_req_100_fields fields;
  struct packet_diplomacy_create_clause_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CREATE_CLAUSE_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_create_clause_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_create_clause_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_req_100, cmp_packet_diplomacy_create_clause_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    if (!dio_get_sint8(&din, &real_packet->giver)) {
      RECEIVE_PACKET_FIELD_ERROR(giver);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!dio_get_uint32(&din, &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_create_clause_req_100(struct connection *pc, const struct packet_diplomacy_create_clause_req *packet)
{
  const struct packet_diplomacy_create_clause_req *real_packet = packet;
  packet_diplomacy_create_clause_req_100_fields fields;
  struct packet_diplomacy_create_clause_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CREATE_CLAUSE_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CREATE_CLAUSE_REQ);

  log_packet_detailed("packet_diplomacy_create_clause_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_req_100, cmp_packet_diplomacy_create_clause_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    dio_put_sint8(&dout, real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_uint32(&dout, real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CREATE_CLAUSE_REQ);
}

static void ensure_valid_variant_packet_diplomacy_create_clause_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ] = variant;
}

struct packet_diplomacy_create_clause_req *receive_packet_diplomacy_create_clause_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_diplomacy_create_clause_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_create_clause_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ]) {
  case 100:
    return receive_packet_diplomacy_create_clause_req_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_create_clause_req(struct connection *pc, const struct packet_diplomacy_create_clause_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_create_clause_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_create_clause_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE_REQ]) {

  case 100:
    return send_packet_diplomacy_create_clause_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_create_clause_req(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_create_clause_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_create_clause_req(pc, real_packet);
}

#define hash_packet_diplomacy_create_clause_100 hash_const

#define cmp_packet_diplomacy_create_clause_100 cmp_const

BV_DEFINE(packet_diplomacy_create_clause_100_fields, 4);

static struct packet_diplomacy_create_clause *receive_packet_diplomacy_create_clause_100(struct connection *pc)
{
  packet_diplomacy_create_clause_100_fields fields;
  struct packet_diplomacy_create_clause *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CREATE_CLAUSE;
  RECEIVE_PACKET_START(packet_diplomacy_create_clause, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_create_clause_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_100, cmp_packet_diplomacy_create_clause_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    if (!dio_get_sint8(&din, &real_packet->giver)) {
      RECEIVE_PACKET_FIELD_ERROR(giver);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!dio_get_uint32(&din, &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_create_clause_100(struct connection *pc, const struct packet_diplomacy_create_clause *packet)
{
  const struct packet_diplomacy_create_clause *real_packet = packet;
  packet_diplomacy_create_clause_100_fields fields;
  struct packet_diplomacy_create_clause *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CREATE_CLAUSE;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CREATE_CLAUSE);

  log_packet_detailed("packet_diplomacy_create_clause_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_create_clause_100, cmp_packet_diplomacy_create_clause_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    dio_put_sint8(&dout, real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_uint32(&dout, real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CREATE_CLAUSE);
}

static void ensure_valid_variant_packet_diplomacy_create_clause(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE] = variant;
}

struct packet_diplomacy_create_clause *receive_packet_diplomacy_create_clause(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_diplomacy_create_clause at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_create_clause(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE]) {
  case 100:
    return receive_packet_diplomacy_create_clause_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_create_clause(struct connection *pc, const struct packet_diplomacy_create_clause *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_create_clause from the client.");
  }
  ensure_valid_variant_packet_diplomacy_create_clause(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CREATE_CLAUSE]) {

  case 100:
    return send_packet_diplomacy_create_clause_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CREATE_CLAUSE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_create_clause(struct conn_list *dest, const struct packet_diplomacy_create_clause *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_create_clause(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_create_clause(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_create_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_create_clause(pc, real_packet);
}

void dlsend_packet_diplomacy_create_clause(struct conn_list *dest, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_create_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  lsend_packet_diplomacy_create_clause(dest, real_packet);
}

#define hash_packet_diplomacy_remove_clause_req_100 hash_const

#define cmp_packet_diplomacy_remove_clause_req_100 cmp_const

BV_DEFINE(packet_diplomacy_remove_clause_req_100_fields, 4);

static struct packet_diplomacy_remove_clause_req *receive_packet_diplomacy_remove_clause_req_100(struct connection *pc)
{
  packet_diplomacy_remove_clause_req_100_fields fields;
  struct packet_diplomacy_remove_clause_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_remove_clause_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_remove_clause_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_req_100, cmp_packet_diplomacy_remove_clause_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    if (!dio_get_sint8(&din, &real_packet->giver)) {
      RECEIVE_PACKET_FIELD_ERROR(giver);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!dio_get_uint32(&din, &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_remove_clause_req_100(struct connection *pc, const struct packet_diplomacy_remove_clause_req *packet)
{
  const struct packet_diplomacy_remove_clause_req *real_packet = packet;
  packet_diplomacy_remove_clause_req_100_fields fields;
  struct packet_diplomacy_remove_clause_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ);

  log_packet_detailed("packet_diplomacy_remove_clause_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_req_100, cmp_packet_diplomacy_remove_clause_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    dio_put_sint8(&dout, real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_uint32(&dout, real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ);
}

static void ensure_valid_variant_packet_diplomacy_remove_clause_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ] = variant;
}

struct packet_diplomacy_remove_clause_req *receive_packet_diplomacy_remove_clause_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_diplomacy_remove_clause_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_remove_clause_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ]) {
  case 100:
    return receive_packet_diplomacy_remove_clause_req_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_remove_clause_req(struct connection *pc, const struct packet_diplomacy_remove_clause_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_remove_clause_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_remove_clause_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ]) {

  case 100:
    return send_packet_diplomacy_remove_clause_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_remove_clause_req(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_remove_clause_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_remove_clause_req(pc, real_packet);
}

#define hash_packet_diplomacy_remove_clause_100 hash_const

#define cmp_packet_diplomacy_remove_clause_100 cmp_const

BV_DEFINE(packet_diplomacy_remove_clause_100_fields, 4);

static struct packet_diplomacy_remove_clause *receive_packet_diplomacy_remove_clause_100(struct connection *pc)
{
  packet_diplomacy_remove_clause_100_fields fields;
  struct packet_diplomacy_remove_clause *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_REMOVE_CLAUSE;
  RECEIVE_PACKET_START(packet_diplomacy_remove_clause, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_remove_clause_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_100, cmp_packet_diplomacy_remove_clause_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'giver'");
    if (!dio_get_sint8(&din, &real_packet->giver)) {
      RECEIVE_PACKET_FIELD_ERROR(giver);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!dio_get_uint32(&din, &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_remove_clause_100(struct connection *pc, const struct packet_diplomacy_remove_clause *packet)
{
  const struct packet_diplomacy_remove_clause *real_packet = packet;
  packet_diplomacy_remove_clause_100_fields fields;
  struct packet_diplomacy_remove_clause *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_REMOVE_CLAUSE;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_REMOVE_CLAUSE);

  log_packet_detailed("packet_diplomacy_remove_clause_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_remove_clause_100, cmp_packet_diplomacy_remove_clause_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->giver != real_packet->giver);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'giver' has changed");
    dio_put_sint8(&dout, real_packet->giver);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_uint32(&dout, real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_REMOVE_CLAUSE);
}

static void ensure_valid_variant_packet_diplomacy_remove_clause(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE] = variant;
}

struct packet_diplomacy_remove_clause *receive_packet_diplomacy_remove_clause(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_diplomacy_remove_clause at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_remove_clause(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE]) {
  case 100:
    return receive_packet_diplomacy_remove_clause_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_remove_clause(struct connection *pc, const struct packet_diplomacy_remove_clause *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_remove_clause from the client.");
  }
  ensure_valid_variant_packet_diplomacy_remove_clause(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_REMOVE_CLAUSE]) {

  case 100:
    return send_packet_diplomacy_remove_clause_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_REMOVE_CLAUSE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_remove_clause(struct conn_list *dest, const struct packet_diplomacy_remove_clause *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_remove_clause(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_remove_clause(struct connection *pc, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_remove_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  return send_packet_diplomacy_remove_clause(pc, real_packet);
}

void dlsend_packet_diplomacy_remove_clause(struct conn_list *dest, int counterpart, int giver, enum clause_type type, int value)
{
  struct packet_diplomacy_remove_clause packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->giver = giver;
  real_packet->type = type;
  real_packet->value = value;
  
  lsend_packet_diplomacy_remove_clause(dest, real_packet);
}

#define hash_packet_diplomacy_accept_treaty_req_100 hash_const

#define cmp_packet_diplomacy_accept_treaty_req_100 cmp_const

BV_DEFINE(packet_diplomacy_accept_treaty_req_100_fields, 1);

static struct packet_diplomacy_accept_treaty_req *receive_packet_diplomacy_accept_treaty_req_100(struct connection *pc)
{
  packet_diplomacy_accept_treaty_req_100_fields fields;
  struct packet_diplomacy_accept_treaty_req *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_ACCEPT_TREATY_REQ;
  RECEIVE_PACKET_START(packet_diplomacy_accept_treaty_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_accept_treaty_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_req_100, cmp_packet_diplomacy_accept_treaty_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_accept_treaty_req_100(struct connection *pc, const struct packet_diplomacy_accept_treaty_req *packet)
{
  const struct packet_diplomacy_accept_treaty_req *real_packet = packet;
  packet_diplomacy_accept_treaty_req_100_fields fields;
  struct packet_diplomacy_accept_treaty_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_ACCEPT_TREATY_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_ACCEPT_TREATY_REQ);

  log_packet_detailed("packet_diplomacy_accept_treaty_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_req_100, cmp_packet_diplomacy_accept_treaty_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_ACCEPT_TREATY_REQ);
}

static void ensure_valid_variant_packet_diplomacy_accept_treaty_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ] = variant;
}

struct packet_diplomacy_accept_treaty_req *receive_packet_diplomacy_accept_treaty_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_diplomacy_accept_treaty_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_accept_treaty_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ]) {
  case 100:
    return receive_packet_diplomacy_accept_treaty_req_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_accept_treaty_req(struct connection *pc, const struct packet_diplomacy_accept_treaty_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_accept_treaty_req from the server.");
  }
  ensure_valid_variant_packet_diplomacy_accept_treaty_req(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY_REQ]) {

  case 100:
    return send_packet_diplomacy_accept_treaty_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_accept_treaty_req(struct connection *pc, int counterpart)
{
  struct packet_diplomacy_accept_treaty_req packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  
  return send_packet_diplomacy_accept_treaty_req(pc, real_packet);
}

#define hash_packet_diplomacy_accept_treaty_100 hash_const

#define cmp_packet_diplomacy_accept_treaty_100 cmp_const

BV_DEFINE(packet_diplomacy_accept_treaty_100_fields, 3);

static struct packet_diplomacy_accept_treaty *receive_packet_diplomacy_accept_treaty_100(struct connection *pc)
{
  packet_diplomacy_accept_treaty_100_fields fields;
  struct packet_diplomacy_accept_treaty *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_ACCEPT_TREATY;
  RECEIVE_PACKET_START(packet_diplomacy_accept_treaty, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_accept_treaty_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_100, cmp_packet_diplomacy_accept_treaty_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'counterpart'");
    if (!dio_get_sint8(&din, &real_packet->counterpart)) {
      RECEIVE_PACKET_FIELD_ERROR(counterpart);
    }
  }
  real_packet->I_accepted = BV_ISSET(fields, 1);
  real_packet->other_accepted = BV_ISSET(fields, 2);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_accept_treaty_100(struct connection *pc, const struct packet_diplomacy_accept_treaty *packet)
{
  const struct packet_diplomacy_accept_treaty *real_packet = packet;
  packet_diplomacy_accept_treaty_100_fields fields;
  struct packet_diplomacy_accept_treaty *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_ACCEPT_TREATY;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_ACCEPT_TREATY);

  log_packet_detailed("packet_diplomacy_accept_treaty_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_accept_treaty_100, cmp_packet_diplomacy_accept_treaty_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->counterpart != real_packet->counterpart);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->I_accepted != real_packet->I_accepted);
  if(differ) {
    different++;
  }
  if (packet->I_accepted) {
    BV_SET(fields, 1);
  }

  differ = (old->other_accepted != real_packet->other_accepted);
  if(differ) {
    different++;
  }
  if (packet->other_accepted) {
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'counterpart' has changed");
    dio_put_sint8(&dout, real_packet->counterpart);
  }
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_ACCEPT_TREATY);
}

static void ensure_valid_variant_packet_diplomacy_accept_treaty(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY] = variant;
}

struct packet_diplomacy_accept_treaty *receive_packet_diplomacy_accept_treaty(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_diplomacy_accept_treaty at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_accept_treaty(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY]) {
  case 100:
    return receive_packet_diplomacy_accept_treaty_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_accept_treaty(struct connection *pc, const struct packet_diplomacy_accept_treaty *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_diplomacy_accept_treaty from the client.");
  }
  ensure_valid_variant_packet_diplomacy_accept_treaty(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_ACCEPT_TREATY]) {

  case 100:
    return send_packet_diplomacy_accept_treaty_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_ACCEPT_TREATY variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_diplomacy_accept_treaty(struct conn_list *dest, const struct packet_diplomacy_accept_treaty *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_diplomacy_accept_treaty(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_diplomacy_accept_treaty(struct connection *pc, int counterpart, bool I_accepted, bool other_accepted)
{
  struct packet_diplomacy_accept_treaty packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->I_accepted = I_accepted;
  real_packet->other_accepted = other_accepted;
  
  return send_packet_diplomacy_accept_treaty(pc, real_packet);
}

void dlsend_packet_diplomacy_accept_treaty(struct conn_list *dest, int counterpart, bool I_accepted, bool other_accepted)
{
  struct packet_diplomacy_accept_treaty packet, *real_packet = &packet;

  real_packet->counterpart = counterpart;
  real_packet->I_accepted = I_accepted;
  real_packet->other_accepted = other_accepted;
  
  lsend_packet_diplomacy_accept_treaty(dest, real_packet);
}

#define hash_packet_diplomacy_cancel_pact_100 hash_const

#define cmp_packet_diplomacy_cancel_pact_100 cmp_const

BV_DEFINE(packet_diplomacy_cancel_pact_100_fields, 2);

static struct packet_diplomacy_cancel_pact *receive_packet_diplomacy_cancel_pact_100(struct connection *pc)
{
  packet_diplomacy_cancel_pact_100_fields fields;
  struct packet_diplomacy_cancel_pact *old;
  struct genhash **hash = pc->phs.received + PACKET_DIPLOMACY_CANCEL_PACT;
  RECEIVE_PACKET_START(packet_diplomacy_cancel_pact, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_diplomacy_cancel_pact_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_pact_100, cmp_packet_diplomacy_cancel_pact_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'other_player_id'");
    if (!dio_get_sint8(&din, &real_packet->other_player_id)) {
      RECEIVE_PACKET_FIELD_ERROR(other_player_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'clause'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(clause);
      }
      real_packet->clause = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_diplomacy_cancel_pact_100(struct connection *pc, const struct packet_diplomacy_cancel_pact *packet)
{
  const struct packet_diplomacy_cancel_pact *real_packet = packet;
  packet_diplomacy_cancel_pact_100_fields fields;
  struct packet_diplomacy_cancel_pact *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_DIPLOMACY_CANCEL_PACT;
  int different = 0;
  SEND_PACKET_START(PACKET_DIPLOMACY_CANCEL_PACT);

  log_packet_detailed("packet_diplomacy_cancel_pact_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_diplomacy_cancel_pact_100, cmp_packet_diplomacy_cancel_pact_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->other_player_id != real_packet->other_player_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->clause != real_packet->clause);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'other_player_id' has changed");
    dio_put_sint8(&dout, real_packet->other_player_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'clause' has changed");
    dio_put_uint8(&dout, real_packet->clause);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_DIPLOMACY_CANCEL_PACT);
}

static void ensure_valid_variant_packet_diplomacy_cancel_pact(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_PACT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_DIPLOMACY_CANCEL_PACT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_DIPLOMACY_CANCEL_PACT] = variant;
}

struct packet_diplomacy_cancel_pact *receive_packet_diplomacy_cancel_pact(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_diplomacy_cancel_pact at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_diplomacy_cancel_pact(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_PACT]) {
  case 100:
    return receive_packet_diplomacy_cancel_pact_100(pc);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_PACT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_diplomacy_cancel_pact(struct connection *pc, const struct packet_diplomacy_cancel_pact *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_diplomacy_cancel_pact from the server.");
  }
  ensure_valid_variant_packet_diplomacy_cancel_pact(pc);

  switch(pc->phs.variant[PACKET_DIPLOMACY_CANCEL_PACT]) {

  case 100:
    return send_packet_diplomacy_cancel_pact_100(pc, packet);
  default:
    log_debug("Unknown PACKET_DIPLOMACY_CANCEL_PACT variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_diplomacy_cancel_pact(struct connection *pc, int other_player_id, enum clause_type clause)
{
  struct packet_diplomacy_cancel_pact packet, *real_packet = &packet;

  real_packet->other_player_id = other_player_id;
  real_packet->clause = clause;
  
  return send_packet_diplomacy_cancel_pact(pc, real_packet);
}

#define hash_packet_page_msg_old_100 hash_const

#define cmp_packet_page_msg_old_100 cmp_const

BV_DEFINE(packet_page_msg_old_100_fields, 4);

static struct packet_page_msg_old *receive_packet_page_msg_old_100(struct connection *pc)
{
  packet_page_msg_old_100_fields fields;
  struct packet_page_msg_old *old;
  struct genhash **hash = pc->phs.received + PACKET_PAGE_MSG_OLD;
  RECEIVE_PACKET_START(packet_page_msg_old, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_page_msg_old_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_old_100, cmp_packet_page_msg_old_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'caption'");
    if (!dio_get_string(&din, real_packet->caption, sizeof(real_packet->caption))) {
      RECEIVE_PACKET_FIELD_ERROR(caption);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'headline'");
    if (!dio_get_string(&din, real_packet->headline, sizeof(real_packet->headline))) {
      RECEIVE_PACKET_FIELD_ERROR(headline);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'lines'");
    if (!dio_get_string(&din, real_packet->lines, sizeof(real_packet->lines))) {
      RECEIVE_PACKET_FIELD_ERROR(lines);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'event'");
    {
      int readin;
      
      if (!dio_get_sint16(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(event);
      }
      real_packet->event = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_page_msg_old_100(struct connection *pc, const struct packet_page_msg_old *packet)
{
  const struct packet_page_msg_old *real_packet = packet;
  packet_page_msg_old_100_fields fields;
  struct packet_page_msg_old *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PAGE_MSG_OLD;
  int different = 0;
  SEND_PACKET_START(PACKET_PAGE_MSG_OLD);

  log_packet_detailed("packet_page_msg_old_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_old_100, cmp_packet_page_msg_old_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->caption, real_packet->caption) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->headline, real_packet->headline) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->lines, real_packet->lines) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'caption' has changed");
    dio_put_string(&dout, real_packet->caption);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'headline' has changed");
    dio_put_string(&dout, real_packet->headline);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'lines' has changed");
    dio_put_string(&dout, real_packet->lines);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'event' has changed");
    dio_put_sint16(&dout, real_packet->event);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PAGE_MSG_OLD);
}

static void ensure_valid_variant_packet_page_msg_old(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PAGE_MSG_OLD] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PAGE_MSG_OLD variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PAGE_MSG_OLD] = variant;
}

struct packet_page_msg_old *receive_packet_page_msg_old(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_page_msg_old at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_page_msg_old(pc);

  switch(pc->phs.variant[PACKET_PAGE_MSG_OLD]) {
  case 100:
    return receive_packet_page_msg_old_100(pc);
  default:
    log_debug("Unknown PACKET_PAGE_MSG_OLD variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_page_msg_old(struct connection *pc, const struct packet_page_msg_old *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_page_msg_old from the client.");
  }
  ensure_valid_variant_packet_page_msg_old(pc);

  switch(pc->phs.variant[PACKET_PAGE_MSG_OLD]) {

  case 100:
    return send_packet_page_msg_old_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PAGE_MSG_OLD variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_page_msg_old(struct conn_list *dest, const struct packet_page_msg_old *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_page_msg_old(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_page_msg_new_100 hash_const

#define cmp_packet_page_msg_new_100 cmp_const

BV_DEFINE(packet_page_msg_new_100_fields, 5);

static struct packet_page_msg_new *receive_packet_page_msg_new_100(struct connection *pc)
{
  packet_page_msg_new_100_fields fields;
  struct packet_page_msg_new *old;
  struct genhash **hash = pc->phs.received + PACKET_PAGE_MSG_NEW;
  RECEIVE_PACKET_START(packet_page_msg_new, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_page_msg_new_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_new_100, cmp_packet_page_msg_new_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'caption'");
    if (!dio_get_string(&din, real_packet->caption, sizeof(real_packet->caption))) {
      RECEIVE_PACKET_FIELD_ERROR(caption);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'headline'");
    if (!dio_get_string(&din, real_packet->headline, sizeof(real_packet->headline))) {
      RECEIVE_PACKET_FIELD_ERROR(headline);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'event'");
    {
      int readin;
      
      if (!dio_get_sint16(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(event);
      }
      real_packet->event = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'len'");
    if (!dio_get_uint32(&din, &real_packet->len)) {
      RECEIVE_PACKET_FIELD_ERROR(len);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'parts'");
    if (!dio_get_uint16(&din, &real_packet->parts)) {
      RECEIVE_PACKET_FIELD_ERROR(parts);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_page_msg_new_100(struct connection *pc, const struct packet_page_msg_new *packet)
{
  const struct packet_page_msg_new *real_packet = packet;
  packet_page_msg_new_100_fields fields;
  struct packet_page_msg_new *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PAGE_MSG_NEW;
  int different = 0;
  SEND_PACKET_START(PACKET_PAGE_MSG_NEW);

  log_packet_detailed("packet_page_msg_new_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_new_100, cmp_packet_page_msg_new_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->caption, real_packet->caption) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->headline, real_packet->headline) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->event != real_packet->event);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->len != real_packet->len);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->parts != real_packet->parts);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'caption' has changed");
    dio_put_string(&dout, real_packet->caption);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'headline' has changed");
    dio_put_string(&dout, real_packet->headline);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'event' has changed");
    dio_put_sint16(&dout, real_packet->event);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'len' has changed");
    dio_put_uint32(&dout, real_packet->len);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'parts' has changed");
    dio_put_uint16(&dout, real_packet->parts);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PAGE_MSG_NEW);
}

static void ensure_valid_variant_packet_page_msg_new(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PAGE_MSG_NEW] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PAGE_MSG_NEW variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PAGE_MSG_NEW] = variant;
}

struct packet_page_msg_new *receive_packet_page_msg_new(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_page_msg_new at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_page_msg_new(pc);

  switch(pc->phs.variant[PACKET_PAGE_MSG_NEW]) {
  case 100:
    return receive_packet_page_msg_new_100(pc);
  default:
    log_debug("Unknown PACKET_PAGE_MSG_NEW variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_page_msg_new(struct connection *pc, const struct packet_page_msg_new *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_page_msg_new from the client.");
  }
  ensure_valid_variant_packet_page_msg_new(pc);

  switch(pc->phs.variant[PACKET_PAGE_MSG_NEW]) {

  case 100:
    return send_packet_page_msg_new_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PAGE_MSG_NEW variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_page_msg_new(struct conn_list *dest, const struct packet_page_msg_new *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_page_msg_new(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_page_msg_part_100 hash_const

#define cmp_packet_page_msg_part_100 cmp_const

BV_DEFINE(packet_page_msg_part_100_fields, 1);

static struct packet_page_msg_part *receive_packet_page_msg_part_100(struct connection *pc)
{
  packet_page_msg_part_100_fields fields;
  struct packet_page_msg_part *old;
  struct genhash **hash = pc->phs.received + PACKET_PAGE_MSG_PART;
  RECEIVE_PACKET_START(packet_page_msg_part, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_page_msg_part_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_part_100, cmp_packet_page_msg_part_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'lines'");
    if (!dio_get_string(&din, real_packet->lines, sizeof(real_packet->lines))) {
      RECEIVE_PACKET_FIELD_ERROR(lines);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_page_msg_part_100(struct connection *pc, const struct packet_page_msg_part *packet)
{
  const struct packet_page_msg_part *real_packet = packet;
  packet_page_msg_part_100_fields fields;
  struct packet_page_msg_part *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_PAGE_MSG_PART;
  int different = 0;
  SEND_PACKET_START(PACKET_PAGE_MSG_PART);

  log_packet_detailed("packet_page_msg_part_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_page_msg_part_100, cmp_packet_page_msg_part_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->lines, real_packet->lines) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'lines' has changed");
    dio_put_string(&dout, real_packet->lines);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_PAGE_MSG_PART);
}

static void ensure_valid_variant_packet_page_msg_part(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_PAGE_MSG_PART] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_PAGE_MSG_PART variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_PAGE_MSG_PART] = variant;
}

struct packet_page_msg_part *receive_packet_page_msg_part(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_page_msg_part at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_page_msg_part(pc);

  switch(pc->phs.variant[PACKET_PAGE_MSG_PART]) {
  case 100:
    return receive_packet_page_msg_part_100(pc);
  default:
    log_debug("Unknown PACKET_PAGE_MSG_PART variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_page_msg_part(struct connection *pc, const struct packet_page_msg_part *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_page_msg_part from the client.");
  }
  ensure_valid_variant_packet_page_msg_part(pc);

  switch(pc->phs.variant[PACKET_PAGE_MSG_PART]) {

  case 100:
    return send_packet_page_msg_part_100(pc, packet);
  default:
    log_debug("Unknown PACKET_PAGE_MSG_PART variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_page_msg_part(struct conn_list *dest, const struct packet_page_msg_part *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_page_msg_part(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_report_req_100 hash_const

#define cmp_packet_report_req_100 cmp_const

BV_DEFINE(packet_report_req_100_fields, 1);

static struct packet_report_req *receive_packet_report_req_100(struct connection *pc)
{
  packet_report_req_100_fields fields;
  struct packet_report_req *old;
  struct genhash **hash = pc->phs.received + PACKET_REPORT_REQ;
  RECEIVE_PACKET_START(packet_report_req, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_report_req_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_report_req_100, cmp_packet_report_req_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_report_req_100(struct connection *pc, const struct packet_report_req *packet)
{
  const struct packet_report_req *real_packet = packet;
  packet_report_req_100_fields fields;
  struct packet_report_req *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_REPORT_REQ;
  int different = 0;
  SEND_PACKET_START(PACKET_REPORT_REQ);

  log_packet_detailed("packet_report_req_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_report_req_100, cmp_packet_report_req_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_REPORT_REQ);
}

static void ensure_valid_variant_packet_report_req(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_REPORT_REQ] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_REPORT_REQ variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_REPORT_REQ] = variant;
}

struct packet_report_req *receive_packet_report_req(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_report_req at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_report_req(pc);

  switch(pc->phs.variant[PACKET_REPORT_REQ]) {
  case 100:
    return receive_packet_report_req_100(pc);
  default:
    log_debug("Unknown PACKET_REPORT_REQ variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_report_req(struct connection *pc, const struct packet_report_req *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_report_req from the server.");
  }
  ensure_valid_variant_packet_report_req(pc);

  switch(pc->phs.variant[PACKET_REPORT_REQ]) {

  case 100:
    return send_packet_report_req_100(pc, packet);
  default:
    log_debug("Unknown PACKET_REPORT_REQ variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_report_req(struct connection *pc, enum report_type type)
{
  struct packet_report_req packet, *real_packet = &packet;

  real_packet->type = type;
  
  return send_packet_report_req(pc, real_packet);
}

static genhash_val_t hash_packet_conn_info_100(const void *vkey)
{
  const struct packet_conn_info *key = (const struct packet_conn_info *) vkey;

  return key->id;
}

static bool cmp_packet_conn_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_conn_info *key1 = (const struct packet_conn_info *) vkey1;
  const struct packet_conn_info *key2 = (const struct packet_conn_info *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_conn_info_100_fields, 8);

static struct packet_conn_info *receive_packet_conn_info_100(struct connection *pc)
{
  packet_conn_info_100_fields fields;
  struct packet_conn_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CONN_INFO;
  RECEIVE_PACKET_START(packet_conn_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_sint16(&din, &real_packet->id)) {
    RECEIVE_PACKET_FIELD_ERROR(id);
  }

  log_packet_detailed("packet_conn_info_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_info_100, cmp_packet_conn_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  real_packet->used = BV_ISSET(fields, 0);
  real_packet->established = BV_ISSET(fields, 1);
  real_packet->observer = BV_ISSET(fields, 2);
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'player_num'");
    if (!dio_get_sint8(&din, &real_packet->player_num)) {
      RECEIVE_PACKET_FIELD_ERROR(player_num);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'access_level'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(access_level);
      }
      real_packet->access_level = readin;
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'username'");
    if (!dio_get_string(&din, real_packet->username, sizeof(real_packet->username))) {
      RECEIVE_PACKET_FIELD_ERROR(username);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'addr'");
    if (!dio_get_string(&din, real_packet->addr, sizeof(real_packet->addr))) {
      RECEIVE_PACKET_FIELD_ERROR(addr);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'capability'");
    if (!dio_get_string(&din, real_packet->capability, sizeof(real_packet->capability))) {
      RECEIVE_PACKET_FIELD_ERROR(capability);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_info_100(struct connection *pc, const struct packet_conn_info *packet)
{
  const struct packet_conn_info *real_packet = packet;
  packet_conn_info_100_fields fields;
  struct packet_conn_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONN_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CONN_INFO);

  log_packet_detailed("packet_conn_info_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_info_100, cmp_packet_conn_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->used != real_packet->used);
  if(differ) {
    different++;
  }
  if (packet->used) {
    BV_SET(fields, 0);
  }

  differ = (old->established != real_packet->established);
  if(differ) {
    different++;
  }
  if (packet->established) {
    BV_SET(fields, 1);
  }

  differ = (old->observer != real_packet->observer);
  if(differ) {
    different++;
  }
  if (packet->observer) {
    BV_SET(fields, 2);
  }

  differ = (old->player_num != real_packet->player_num);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->access_level != real_packet->access_level);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->username, real_packet->username) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->addr, real_packet->addr) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->capability, real_packet->capability) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  if (different == 0) {
    log_packet_detailed("  no change -> discard");
    return 0;
  }

  DIO_BV_PUT(&dout, fields);
  dio_put_sint16(&dout, real_packet->id);

  /* field 0 is folded into the header */
  /* field 1 is folded into the header */
  /* field 2 is folded into the header */
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'player_num' has changed");
    dio_put_sint8(&dout, real_packet->player_num);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'access_level' has changed");
    dio_put_uint8(&dout, real_packet->access_level);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'username' has changed");
    dio_put_string(&dout, real_packet->username);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'addr' has changed");
    dio_put_string(&dout, real_packet->addr);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'capability' has changed");
    dio_put_string(&dout, real_packet->capability);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CONN_INFO);
}

static void ensure_valid_variant_packet_conn_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONN_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONN_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONN_INFO] = variant;
}

struct packet_conn_info *receive_packet_conn_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_conn_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_conn_info(pc);

  switch(pc->phs.variant[PACKET_CONN_INFO]) {
  case 100:
    return receive_packet_conn_info_100(pc);
  default:
    log_debug("Unknown PACKET_CONN_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_conn_info(struct connection *pc, const struct packet_conn_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_conn_info from the client.");
  }
  ensure_valid_variant_packet_conn_info(pc);

  switch(pc->phs.variant[PACKET_CONN_INFO]) {

  case 100:
    return send_packet_conn_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CONN_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_conn_info(struct conn_list *dest, const struct packet_conn_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_conn_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_conn_ping_info_100 hash_const

#define cmp_packet_conn_ping_info_100 cmp_const

BV_DEFINE(packet_conn_ping_info_100_fields, 3);

static struct packet_conn_ping_info *receive_packet_conn_ping_info_100(struct connection *pc)
{
  packet_conn_ping_info_100_fields fields;
  struct packet_conn_ping_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CONN_PING_INFO;
  RECEIVE_PACKET_START(packet_conn_ping_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_conn_ping_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_ping_info_100, cmp_packet_conn_ping_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'connections'");
    if (!dio_get_uint8(&din, &real_packet->connections)) {
      RECEIVE_PACKET_FIELD_ERROR(connections);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'conn_id'");
    
    {
      int i;
    
      if (real_packet->connections > MAX_NUM_CONNECTIONS) {
        RECEIVE_PACKET_FIELD_ERROR(conn_id, ": truncation array");
      }
      for (i = 0; i < real_packet->connections; i++) {
        if (!dio_get_sint16(&din, &real_packet->conn_id[i])) {
          RECEIVE_PACKET_FIELD_ERROR(conn_id);
        }
      }
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'ping_time'");
    
    {
      int i;
    
      if (real_packet->connections > MAX_NUM_CONNECTIONS) {
        RECEIVE_PACKET_FIELD_ERROR(ping_time, ": truncation array");
      }
      for (i = 0; i < real_packet->connections; i++) {
        if (!dio_get_sfloat(&din, &real_packet->ping_time[i], 1000000)) {
          RECEIVE_PACKET_FIELD_ERROR(ping_time);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_ping_info_100(struct connection *pc, const struct packet_conn_ping_info *packet)
{
  const struct packet_conn_ping_info *real_packet = packet;
  packet_conn_ping_info_100_fields fields;
  struct packet_conn_ping_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CONN_PING_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CONN_PING_INFO);

  log_packet_detailed("packet_conn_ping_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_conn_ping_info_100, cmp_packet_conn_ping_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->connections != real_packet->connections);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->connections != real_packet->connections);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->connections; i++) {
          if (old->conn_id[i] != real_packet->conn_id[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->connections != real_packet->connections);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->connections; i++) {
          if (old->ping_time[i] != real_packet->ping_time[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'connections' has changed");
    dio_put_uint8(&dout, real_packet->connections);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'conn_id' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->connections; i++) {
        dio_put_sint16(&dout, real_packet->conn_id[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'ping_time' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->connections; i++) {
          dio_put_sfloat(&dout, real_packet->ping_time[i], 1000000);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CONN_PING_INFO);
}

static void ensure_valid_variant_packet_conn_ping_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONN_PING_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONN_PING_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONN_PING_INFO] = variant;
}

struct packet_conn_ping_info *receive_packet_conn_ping_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_conn_ping_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_conn_ping_info(pc);

  switch(pc->phs.variant[PACKET_CONN_PING_INFO]) {
  case 100:
    return receive_packet_conn_ping_info_100(pc);
  default:
    log_debug("Unknown PACKET_CONN_PING_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_conn_ping_info(struct connection *pc, const struct packet_conn_ping_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_conn_ping_info from the client.");
  }
  ensure_valid_variant_packet_conn_ping_info(pc);

  switch(pc->phs.variant[PACKET_CONN_PING_INFO]) {

  case 100:
    return send_packet_conn_ping_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CONN_PING_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_conn_ping_info(struct conn_list *dest, const struct packet_conn_ping_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_conn_ping_info(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_conn_ping *receive_packet_conn_ping_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_conn_ping, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_conn_ping_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_ping_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_CONN_PING);

  log_packet_detailed("packet_conn_ping_100: sending info about ()");
  SEND_PACKET_END(PACKET_CONN_PING);
}

static void ensure_valid_variant_packet_conn_ping(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONN_PING] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONN_PING variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONN_PING] = variant;
}

struct packet_conn_ping *receive_packet_conn_ping(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_conn_ping at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_conn_ping(pc);

  switch(pc->phs.variant[PACKET_CONN_PING]) {
  case 100:
    return receive_packet_conn_ping_100(pc);
  default:
    log_debug("Unknown PACKET_CONN_PING variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_conn_ping(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_conn_ping from the client.");
  }
  ensure_valid_variant_packet_conn_ping(pc);

  switch(pc->phs.variant[PACKET_CONN_PING]) {

  case 100:
    return send_packet_conn_ping_100(pc);
  default:
    log_debug("Unknown PACKET_CONN_PING variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_conn_pong *receive_packet_conn_pong_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_conn_pong, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_conn_pong_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_conn_pong_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_CONN_PONG);

  log_packet_detailed("packet_conn_pong_100: sending info about ()");
  SEND_PACKET_END(PACKET_CONN_PONG);
}

static void ensure_valid_variant_packet_conn_pong(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CONN_PONG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CONN_PONG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CONN_PONG] = variant;
}

struct packet_conn_pong *receive_packet_conn_pong(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_conn_pong at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_conn_pong(pc);

  switch(pc->phs.variant[PACKET_CONN_PONG]) {
  case 100:
    return receive_packet_conn_pong_100(pc);
  default:
    log_debug("Unknown PACKET_CONN_PONG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_conn_pong(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_conn_pong from the server.");
  }
  ensure_valid_variant_packet_conn_pong(pc);

  switch(pc->phs.variant[PACKET_CONN_PONG]) {

  case 100:
    return send_packet_conn_pong_100(pc);
  default:
    log_debug("Unknown PACKET_CONN_PONG variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_client_info_100 hash_const

#define cmp_packet_client_info_100 cmp_const

BV_DEFINE(packet_client_info_100_fields, 2);

static struct packet_client_info *receive_packet_client_info_100(struct connection *pc)
{
  packet_client_info_100_fields fields;
  struct packet_client_info *old;
  struct genhash **hash = pc->phs.received + PACKET_CLIENT_INFO;
  RECEIVE_PACKET_START(packet_client_info, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_client_info_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_client_info_100, cmp_packet_client_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'gui'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gui);
      }
      real_packet->gui = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'distribution'");
    if (!dio_get_string(&din, real_packet->distribution, sizeof(real_packet->distribution))) {
      RECEIVE_PACKET_FIELD_ERROR(distribution);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_client_info_100(struct connection *pc, const struct packet_client_info *packet)
{
  const struct packet_client_info *real_packet = packet;
  packet_client_info_100_fields fields;
  struct packet_client_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_CLIENT_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_CLIENT_INFO);

  log_packet_detailed("packet_client_info_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_client_info_100, cmp_packet_client_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->gui != real_packet->gui);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->distribution, real_packet->distribution) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'gui' has changed");
    dio_put_uint8(&dout, real_packet->gui);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'distribution' has changed");
    dio_put_string(&dout, real_packet->distribution);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_CLIENT_INFO);
}

static void ensure_valid_variant_packet_client_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_CLIENT_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_CLIENT_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_CLIENT_INFO] = variant;
}

struct packet_client_info *receive_packet_client_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_client_info at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_client_info(pc);

  switch(pc->phs.variant[PACKET_CLIENT_INFO]) {
  case 100:
    return receive_packet_client_info_100(pc);
  default:
    log_debug("Unknown PACKET_CLIENT_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_client_info(struct connection *pc, const struct packet_client_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_client_info from the server.");
  }
  ensure_valid_variant_packet_client_info(pc);

  switch(pc->phs.variant[PACKET_CLIENT_INFO]) {

  case 100:
    return send_packet_client_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_CLIENT_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
static struct packet_end_phase *receive_packet_end_phase_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_end_phase, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_end_phase_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_end_phase_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_END_PHASE);

  log_packet_detailed("packet_end_phase_100: sending info about ()");
  SEND_PACKET_END(PACKET_END_PHASE);
}

static void ensure_valid_variant_packet_end_phase(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_END_PHASE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_END_PHASE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_END_PHASE] = variant;
}

struct packet_end_phase *receive_packet_end_phase(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_end_phase at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_end_phase(pc);

  switch(pc->phs.variant[PACKET_END_PHASE]) {
  case 100:
    return receive_packet_end_phase_100(pc);
  default:
    log_debug("Unknown PACKET_END_PHASE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_end_phase(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_end_phase from the client.");
  }
  ensure_valid_variant_packet_end_phase(pc);

  switch(pc->phs.variant[PACKET_END_PHASE]) {

  case 100:
    return send_packet_end_phase_100(pc);
  default:
    log_debug("Unknown PACKET_END_PHASE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_end_phase(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_end_phase(pconn);
  } conn_list_iterate_end;
}

#define hash_packet_start_phase_100 hash_const

#define cmp_packet_start_phase_100 cmp_const

BV_DEFINE(packet_start_phase_100_fields, 1);

static struct packet_start_phase *receive_packet_start_phase_100(struct connection *pc)
{
  packet_start_phase_100_fields fields;
  struct packet_start_phase *old;
  struct genhash **hash = pc->phs.received + PACKET_START_PHASE;
  RECEIVE_PACKET_START(packet_start_phase, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_start_phase_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_start_phase_100, cmp_packet_start_phase_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'phase'");
    if (!dio_get_sint16(&din, &real_packet->phase)) {
      RECEIVE_PACKET_FIELD_ERROR(phase);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_start_phase_100(struct connection *pc, const struct packet_start_phase *packet)
{
  const struct packet_start_phase *real_packet = packet;
  packet_start_phase_100_fields fields;
  struct packet_start_phase *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_START_PHASE;
  int different = 0;
  SEND_PACKET_START(PACKET_START_PHASE);

  log_packet_detailed("packet_start_phase_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_start_phase_100, cmp_packet_start_phase_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->phase != real_packet->phase);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'phase' has changed");
    dio_put_sint16(&dout, real_packet->phase);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_START_PHASE);
}

static void ensure_valid_variant_packet_start_phase(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_START_PHASE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_START_PHASE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_START_PHASE] = variant;
}

struct packet_start_phase *receive_packet_start_phase(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_start_phase at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_start_phase(pc);

  switch(pc->phs.variant[PACKET_START_PHASE]) {
  case 100:
    return receive_packet_start_phase_100(pc);
  default:
    log_debug("Unknown PACKET_START_PHASE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_start_phase(struct connection *pc, const struct packet_start_phase *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_start_phase from the client.");
  }
  ensure_valid_variant_packet_start_phase(pc);

  switch(pc->phs.variant[PACKET_START_PHASE]) {

  case 100:
    return send_packet_start_phase_100(pc, packet);
  default:
    log_debug("Unknown PACKET_START_PHASE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_start_phase(struct conn_list *dest, const struct packet_start_phase *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_start_phase(pconn, packet);
  } conn_list_iterate_end;
}

int dsend_packet_start_phase(struct connection *pc, int phase)
{
  struct packet_start_phase packet, *real_packet = &packet;

  real_packet->phase = phase;
  
  return send_packet_start_phase(pc, real_packet);
}

void dlsend_packet_start_phase(struct conn_list *dest, int phase)
{
  struct packet_start_phase packet, *real_packet = &packet;

  real_packet->phase = phase;
  
  lsend_packet_start_phase(dest, real_packet);
}

#define hash_packet_new_year_100 hash_const

#define cmp_packet_new_year_100 cmp_const

BV_DEFINE(packet_new_year_100_fields, 2);

static struct packet_new_year *receive_packet_new_year_100(struct connection *pc)
{
  packet_new_year_100_fields fields;
  struct packet_new_year *old;
  struct genhash **hash = pc->phs.received + PACKET_NEW_YEAR;
  RECEIVE_PACKET_START(packet_new_year, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_new_year_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_new_year_100, cmp_packet_new_year_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'year'");
    if (!dio_get_sint16(&din, &real_packet->year)) {
      RECEIVE_PACKET_FIELD_ERROR(year);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'turn'");
    if (!dio_get_sint16(&din, &real_packet->turn)) {
      RECEIVE_PACKET_FIELD_ERROR(turn);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_new_year_100(struct connection *pc, const struct packet_new_year *packet)
{
  const struct packet_new_year *real_packet = packet;
  packet_new_year_100_fields fields;
  struct packet_new_year *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NEW_YEAR;
  int different = 0;
  SEND_PACKET_START(PACKET_NEW_YEAR);

  log_packet_detailed("packet_new_year_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_new_year_100, cmp_packet_new_year_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->year != real_packet->year);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->turn != real_packet->turn);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'year' has changed");
    dio_put_sint16(&dout, real_packet->year);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'turn' has changed");
    dio_put_sint16(&dout, real_packet->turn);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_NEW_YEAR);
}

static void ensure_valid_variant_packet_new_year(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_NEW_YEAR] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_NEW_YEAR variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_NEW_YEAR] = variant;
}

struct packet_new_year *receive_packet_new_year(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_new_year at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_new_year(pc);

  switch(pc->phs.variant[PACKET_NEW_YEAR]) {
  case 100:
    return receive_packet_new_year_100(pc);
  default:
    log_debug("Unknown PACKET_NEW_YEAR variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_new_year(struct connection *pc, const struct packet_new_year *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_new_year from the client.");
  }
  ensure_valid_variant_packet_new_year(pc);

  switch(pc->phs.variant[PACKET_NEW_YEAR]) {

  case 100:
    return send_packet_new_year_100(pc, packet);
  default:
    log_debug("Unknown PACKET_NEW_YEAR variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_new_year(struct conn_list *dest, const struct packet_new_year *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_new_year(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_begin_turn *receive_packet_begin_turn_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_begin_turn, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_begin_turn_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_begin_turn_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_BEGIN_TURN);

  log_packet_detailed("packet_begin_turn_100: sending info about ()");
  SEND_PACKET_END(PACKET_BEGIN_TURN);
}

static void ensure_valid_variant_packet_begin_turn(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_BEGIN_TURN] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_BEGIN_TURN variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_BEGIN_TURN] = variant;
}

struct packet_begin_turn *receive_packet_begin_turn(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_begin_turn at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_begin_turn(pc);

  switch(pc->phs.variant[PACKET_BEGIN_TURN]) {
  case 100:
    return receive_packet_begin_turn_100(pc);
  default:
    log_debug("Unknown PACKET_BEGIN_TURN variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_begin_turn(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_begin_turn from the client.");
  }
  ensure_valid_variant_packet_begin_turn(pc);

  switch(pc->phs.variant[PACKET_BEGIN_TURN]) {

  case 100:
    return send_packet_begin_turn_100(pc);
  default:
    log_debug("Unknown PACKET_BEGIN_TURN variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_begin_turn(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_begin_turn(pconn);
  } conn_list_iterate_end;
}

static struct packet_end_turn *receive_packet_end_turn_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_end_turn, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_end_turn_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_end_turn_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_END_TURN);

  log_packet_detailed("packet_end_turn_100: sending info about ()");
  SEND_PACKET_END(PACKET_END_TURN);
}

static void ensure_valid_variant_packet_end_turn(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_END_TURN] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_END_TURN variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_END_TURN] = variant;
}

struct packet_end_turn *receive_packet_end_turn(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_end_turn at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_end_turn(pc);

  switch(pc->phs.variant[PACKET_END_TURN]) {
  case 100:
    return receive_packet_end_turn_100(pc);
  default:
    log_debug("Unknown PACKET_END_TURN variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_end_turn(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_end_turn from the client.");
  }
  ensure_valid_variant_packet_end_turn(pc);

  switch(pc->phs.variant[PACKET_END_TURN]) {

  case 100:
    return send_packet_end_turn_100(pc);
  default:
    log_debug("Unknown PACKET_END_TURN variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_end_turn(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_end_turn(pconn);
  } conn_list_iterate_end;
}

static struct packet_freeze_client *receive_packet_freeze_client_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_freeze_client, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_freeze_client_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_freeze_client_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_FREEZE_CLIENT);

  log_packet_detailed("packet_freeze_client_100: sending info about ()");
  SEND_PACKET_END(PACKET_FREEZE_CLIENT);
}

static void ensure_valid_variant_packet_freeze_client(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_FREEZE_CLIENT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_FREEZE_CLIENT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_FREEZE_CLIENT] = variant;
}

struct packet_freeze_client *receive_packet_freeze_client(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_freeze_client at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_freeze_client(pc);

  switch(pc->phs.variant[PACKET_FREEZE_CLIENT]) {
  case 100:
    return receive_packet_freeze_client_100(pc);
  default:
    log_debug("Unknown PACKET_FREEZE_CLIENT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_freeze_client(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_freeze_client from the client.");
  }
  ensure_valid_variant_packet_freeze_client(pc);

  switch(pc->phs.variant[PACKET_FREEZE_CLIENT]) {

  case 100:
    return send_packet_freeze_client_100(pc);
  default:
    log_debug("Unknown PACKET_FREEZE_CLIENT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_freeze_client(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_freeze_client(pconn);
  } conn_list_iterate_end;
}

static struct packet_thaw_client *receive_packet_thaw_client_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_thaw_client, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_thaw_client_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_thaw_client_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_THAW_CLIENT);

  log_packet_detailed("packet_thaw_client_100: sending info about ()");
  SEND_PACKET_END(PACKET_THAW_CLIENT);
}

static void ensure_valid_variant_packet_thaw_client(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_THAW_CLIENT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_THAW_CLIENT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_THAW_CLIENT] = variant;
}

struct packet_thaw_client *receive_packet_thaw_client(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_thaw_client at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_thaw_client(pc);

  switch(pc->phs.variant[PACKET_THAW_CLIENT]) {
  case 100:
    return receive_packet_thaw_client_100(pc);
  default:
    log_debug("Unknown PACKET_THAW_CLIENT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_thaw_client(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_thaw_client from the client.");
  }
  ensure_valid_variant_packet_thaw_client(pc);

  switch(pc->phs.variant[PACKET_THAW_CLIENT]) {

  case 100:
    return send_packet_thaw_client_100(pc);
  default:
    log_debug("Unknown PACKET_THAW_CLIENT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_thaw_client(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_thaw_client(pconn);
  } conn_list_iterate_end;
}

static struct packet_spaceship_launch *receive_packet_spaceship_launch_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_spaceship_launch, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_spaceship_launch_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_spaceship_launch_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_SPACESHIP_LAUNCH);

  log_packet_detailed("packet_spaceship_launch_100: sending info about ()");
  SEND_PACKET_END(PACKET_SPACESHIP_LAUNCH);
}

static void ensure_valid_variant_packet_spaceship_launch(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SPACESHIP_LAUNCH] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SPACESHIP_LAUNCH variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SPACESHIP_LAUNCH] = variant;
}

struct packet_spaceship_launch *receive_packet_spaceship_launch(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_spaceship_launch at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_spaceship_launch(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_LAUNCH]) {
  case 100:
    return receive_packet_spaceship_launch_100(pc);
  default:
    log_debug("Unknown PACKET_SPACESHIP_LAUNCH variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_spaceship_launch(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_spaceship_launch from the server.");
  }
  ensure_valid_variant_packet_spaceship_launch(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_LAUNCH]) {

  case 100:
    return send_packet_spaceship_launch_100(pc);
  default:
    log_debug("Unknown PACKET_SPACESHIP_LAUNCH variant for connection %s", conn_description(pc));
    return -1;
  }
}
#define hash_packet_spaceship_place_100 hash_const

#define cmp_packet_spaceship_place_100 cmp_const

BV_DEFINE(packet_spaceship_place_100_fields, 2);

static struct packet_spaceship_place *receive_packet_spaceship_place_100(struct connection *pc)
{
  packet_spaceship_place_100_fields fields;
  struct packet_spaceship_place *old;
  struct genhash **hash = pc->phs.received + PACKET_SPACESHIP_PLACE;
  RECEIVE_PACKET_START(packet_spaceship_place, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_spaceship_place_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_place_100, cmp_packet_spaceship_place_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'num'");
    if (!dio_get_uint8(&din, &real_packet->num)) {
      RECEIVE_PACKET_FIELD_ERROR(num);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_spaceship_place_100(struct connection *pc, const struct packet_spaceship_place *packet)
{
  const struct packet_spaceship_place *real_packet = packet;
  packet_spaceship_place_100_fields fields;
  struct packet_spaceship_place *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SPACESHIP_PLACE;
  int different = 0;
  SEND_PACKET_START(PACKET_SPACESHIP_PLACE);

  log_packet_detailed("packet_spaceship_place_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_place_100, cmp_packet_spaceship_place_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->num != real_packet->num);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'num' has changed");
    dio_put_uint8(&dout, real_packet->num);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SPACESHIP_PLACE);
}

static void ensure_valid_variant_packet_spaceship_place(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SPACESHIP_PLACE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SPACESHIP_PLACE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SPACESHIP_PLACE] = variant;
}

struct packet_spaceship_place *receive_packet_spaceship_place(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (!is_server()) {
    log_packet("Receiving packet_spaceship_place at the client.");
    return NULL;
  }
  ensure_valid_variant_packet_spaceship_place(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_PLACE]) {
  case 100:
    return receive_packet_spaceship_place_100(pc);
  default:
    log_debug("Unknown PACKET_SPACESHIP_PLACE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_spaceship_place(struct connection *pc, const struct packet_spaceship_place *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (is_server()) {
    log_error("Sending packet_spaceship_place from the server.");
  }
  ensure_valid_variant_packet_spaceship_place(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_PLACE]) {

  case 100:
    return send_packet_spaceship_place_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SPACESHIP_PLACE variant for connection %s", conn_description(pc));
    return -1;
  }
}
int dsend_packet_spaceship_place(struct connection *pc, enum spaceship_place_type type, int num)
{
  struct packet_spaceship_place packet, *real_packet = &packet;

  real_packet->type = type;
  real_packet->num = num;
  
  return send_packet_spaceship_place(pc, real_packet);
}

static genhash_val_t hash_packet_spaceship_info_100(const void *vkey)
{
  const struct packet_spaceship_info *key = (const struct packet_spaceship_info *) vkey;

  return key->player_num;
}

static bool cmp_packet_spaceship_info_100(const void *vkey1, const void *vkey2)
{
  const struct packet_spaceship_info *key1 = (const struct packet_spaceship_info *) vkey1;
  const struct packet_spaceship_info *key2 = (const struct packet_spaceship_info *) vkey2;

  return key1->player_num == key2->player_num;
}

BV_DEFINE(packet_spaceship_info_100_fields, 17);

static struct packet_spaceship_info *receive_packet_spaceship_info_100(struct connection *pc)
{
  packet_spaceship_info_100_fields fields;
  struct packet_spaceship_info *old;
  struct genhash **hash = pc->phs.received + PACKET_SPACESHIP_INFO;
  RECEIVE_PACKET_START(packet_spaceship_info, real_packet);

  DIO_BV_GET(&din, fields);
  if (!dio_get_sint8(&din, &real_packet->player_num)) {
    RECEIVE_PACKET_FIELD_ERROR(player_num);
  }

  log_packet_detailed("packet_spaceship_info_100: got info about (%d)",
    real_packet->player_num);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_info_100, cmp_packet_spaceship_info_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    int player_num = real_packet->player_num;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->player_num = player_num;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'sship_state'");
    if (!dio_get_uint8(&din, &real_packet->sship_state)) {
      RECEIVE_PACKET_FIELD_ERROR(sship_state);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'structurals'");
    if (!dio_get_uint8(&din, &real_packet->structurals)) {
      RECEIVE_PACKET_FIELD_ERROR(structurals);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'components'");
    if (!dio_get_uint8(&din, &real_packet->components)) {
      RECEIVE_PACKET_FIELD_ERROR(components);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'modules'");
    if (!dio_get_uint8(&din, &real_packet->modules)) {
      RECEIVE_PACKET_FIELD_ERROR(modules);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'fuel'");
    if (!dio_get_uint8(&din, &real_packet->fuel)) {
      RECEIVE_PACKET_FIELD_ERROR(fuel);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'propulsion'");
    if (!dio_get_uint8(&din, &real_packet->propulsion)) {
      RECEIVE_PACKET_FIELD_ERROR(propulsion);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'habitation'");
    if (!dio_get_uint8(&din, &real_packet->habitation)) {
      RECEIVE_PACKET_FIELD_ERROR(habitation);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'life_support'");
    if (!dio_get_uint8(&din, &real_packet->life_support)) {
      RECEIVE_PACKET_FIELD_ERROR(life_support);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'solar_panels'");
    if (!dio_get_uint8(&din, &real_packet->solar_panels)) {
      RECEIVE_PACKET_FIELD_ERROR(solar_panels);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'launch_year'");
    if (!dio_get_sint16(&din, &real_packet->launch_year)) {
      RECEIVE_PACKET_FIELD_ERROR(launch_year);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'population'");
    if (!dio_get_uint32(&din, &real_packet->population)) {
      RECEIVE_PACKET_FIELD_ERROR(population);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'mass'");
    if (!dio_get_uint32(&din, &real_packet->mass)) {
      RECEIVE_PACKET_FIELD_ERROR(mass);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'structure'");
    if (!DIO_BV_GET(&din, real_packet->structure)) {
      RECEIVE_PACKET_FIELD_ERROR(structure);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'support_rate'");
    if (!dio_get_ufloat(&din, &real_packet->support_rate, 10000)) {
      RECEIVE_PACKET_FIELD_ERROR(support_rate);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'energy_rate'");
    if (!dio_get_ufloat(&din, &real_packet->energy_rate, 10000)) {
      RECEIVE_PACKET_FIELD_ERROR(energy_rate);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'success_rate'");
    if (!dio_get_ufloat(&din, &real_packet->success_rate, 10000)) {
      RECEIVE_PACKET_FIELD_ERROR(success_rate);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'travel_time'");
    if (!dio_get_ufloat(&din, &real_packet->travel_time, 10000)) {
      RECEIVE_PACKET_FIELD_ERROR(travel_time);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_spaceship_info_100(struct connection *pc, const struct packet_spaceship_info *packet)
{
  const struct packet_spaceship_info *real_packet = packet;
  packet_spaceship_info_100_fields fields;
  struct packet_spaceship_info *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_SPACESHIP_INFO;
  int different = 0;
  SEND_PACKET_START(PACKET_SPACESHIP_INFO);

  log_packet_detailed("packet_spaceship_info_100: sending info about (%d)",
    real_packet->player_num);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_spaceship_info_100, cmp_packet_spaceship_info_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->sship_state != real_packet->sship_state);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->structurals != real_packet->structurals);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->components != real_packet->components);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->modules != real_packet->modules);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->propulsion != real_packet->propulsion);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->habitation != real_packet->habitation);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->life_support != real_packet->life_support);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->solar_panels != real_packet->solar_panels);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->launch_year != real_packet->launch_year);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->population != real_packet->population);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->mass != real_packet->mass);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = !BV_ARE_EQUAL(old->structure, real_packet->structure);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->support_rate != real_packet->support_rate);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->energy_rate != real_packet->energy_rate);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->success_rate != real_packet->success_rate);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->travel_time != real_packet->travel_time);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_sint8(&dout, real_packet->player_num);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'sship_state' has changed");
    dio_put_uint8(&dout, real_packet->sship_state);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'structurals' has changed");
    dio_put_uint8(&dout, real_packet->structurals);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'components' has changed");
    dio_put_uint8(&dout, real_packet->components);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'modules' has changed");
    dio_put_uint8(&dout, real_packet->modules);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'fuel' has changed");
    dio_put_uint8(&dout, real_packet->fuel);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'propulsion' has changed");
    dio_put_uint8(&dout, real_packet->propulsion);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'habitation' has changed");
    dio_put_uint8(&dout, real_packet->habitation);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'life_support' has changed");
    dio_put_uint8(&dout, real_packet->life_support);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'solar_panels' has changed");
    dio_put_uint8(&dout, real_packet->solar_panels);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'launch_year' has changed");
    dio_put_sint16(&dout, real_packet->launch_year);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'population' has changed");
    dio_put_uint32(&dout, real_packet->population);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'mass' has changed");
    dio_put_uint32(&dout, real_packet->mass);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'structure' has changed");
  DIO_BV_PUT(&dout, packet->structure);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'support_rate' has changed");
    dio_put_ufloat(&dout, real_packet->support_rate, 10000);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'energy_rate' has changed");
    dio_put_ufloat(&dout, real_packet->energy_rate, 10000);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'success_rate' has changed");
    dio_put_ufloat(&dout, real_packet->success_rate, 10000);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'travel_time' has changed");
    dio_put_ufloat(&dout, real_packet->travel_time, 10000);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_SPACESHIP_INFO);
}

static void ensure_valid_variant_packet_spaceship_info(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_SPACESHIP_INFO] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_SPACESHIP_INFO variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_SPACESHIP_INFO] = variant;
}

struct packet_spaceship_info *receive_packet_spaceship_info(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_spaceship_info at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_spaceship_info(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_INFO]) {
  case 100:
    return receive_packet_spaceship_info_100(pc);
  default:
    log_debug("Unknown PACKET_SPACESHIP_INFO variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_spaceship_info(struct connection *pc, const struct packet_spaceship_info *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_spaceship_info from the client.");
  }
  ensure_valid_variant_packet_spaceship_info(pc);

  switch(pc->phs.variant[PACKET_SPACESHIP_INFO]) {

  case 100:
    return send_packet_spaceship_info_100(pc, packet);
  default:
    log_debug("Unknown PACKET_SPACESHIP_INFO variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_spaceship_info(struct conn_list *dest, const struct packet_spaceship_info *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_spaceship_info(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_100 hash_const

#define cmp_packet_ruleset_unit_100 cmp_const

BV_DEFINE(packet_ruleset_unit_100_fields, 44);

static struct packet_ruleset_unit *receive_packet_ruleset_unit_100(struct connection *pc)
{
  packet_ruleset_unit_100_fields fields;
  struct packet_ruleset_unit *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT;
  RECEIVE_PACKET_START(packet_ruleset_unit, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_100, cmp_packet_ruleset_unit_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'sound_move'");
    if (!dio_get_string(&din, real_packet->sound_move, sizeof(real_packet->sound_move))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_move);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'sound_move_alt'");
    if (!dio_get_string(&din, real_packet->sound_move_alt, sizeof(real_packet->sound_move_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_move_alt);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'sound_fight'");
    if (!dio_get_string(&din, real_packet->sound_fight, sizeof(real_packet->sound_fight))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_fight);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'sound_fight_alt'");
    if (!dio_get_string(&din, real_packet->sound_fight_alt, sizeof(real_packet->sound_fight_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_fight_alt);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'unit_class_id'");
    if (!dio_get_uint8(&din, &real_packet->unit_class_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_class_id);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'build_cost'");
    if (!dio_get_uint16(&din, &real_packet->build_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(build_cost);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'pop_cost'");
    if (!dio_get_uint8(&din, &real_packet->pop_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(pop_cost);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'attack_strength'");
    if (!dio_get_uint8(&din, &real_packet->attack_strength)) {
      RECEIVE_PACKET_FIELD_ERROR(attack_strength);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'defense_strength'");
    if (!dio_get_uint8(&din, &real_packet->defense_strength)) {
      RECEIVE_PACKET_FIELD_ERROR(defense_strength);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'move_rate_new'");
    if (!dio_get_uint16(&din, &real_packet->move_rate_new)) {
      RECEIVE_PACKET_FIELD_ERROR(move_rate_new);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'tech_requirement'");
    if (!dio_get_uint8(&din, &real_packet->tech_requirement)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_requirement);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'impr_requirement'");
    if (!dio_get_uint8(&din, &real_packet->impr_requirement)) {
      RECEIVE_PACKET_FIELD_ERROR(impr_requirement);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'gov_requirement'");
    if (!dio_get_uint8(&din, &real_packet->gov_requirement)) {
      RECEIVE_PACKET_FIELD_ERROR(gov_requirement);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'vision_radius_sq'");
    if (!dio_get_uint16(&din, &real_packet->vision_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(vision_radius_sq);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'transport_capacity'");
    if (!dio_get_uint8(&din, &real_packet->transport_capacity)) {
      RECEIVE_PACKET_FIELD_ERROR(transport_capacity);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'hp'");
    if (!dio_get_uint8(&din, &real_packet->hp)) {
      RECEIVE_PACKET_FIELD_ERROR(hp);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'firepower'");
    if (!dio_get_uint8(&din, &real_packet->firepower)) {
      RECEIVE_PACKET_FIELD_ERROR(firepower);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'obsoleted_by'");
    if (!dio_get_sint8(&din, &real_packet->obsoleted_by)) {
      RECEIVE_PACKET_FIELD_ERROR(obsoleted_by);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'converted_to'");
    if (!dio_get_sint8(&din, &real_packet->converted_to)) {
      RECEIVE_PACKET_FIELD_ERROR(converted_to);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'convert_time'");
    if (!dio_get_uint8(&din, &real_packet->convert_time)) {
      RECEIVE_PACKET_FIELD_ERROR(convert_time);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'fuel'");
    if (!dio_get_uint8(&din, &real_packet->fuel)) {
      RECEIVE_PACKET_FIELD_ERROR(fuel);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'happy_cost'");
    if (!dio_get_uint8(&din, &real_packet->happy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(happy_cost);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'upkeep'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->upkeep[i])) {
          RECEIVE_PACKET_FIELD_ERROR(upkeep);
        }
      }
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'paratroopers_range'");
    if (!dio_get_uint8(&din, &real_packet->paratroopers_range)) {
      RECEIVE_PACKET_FIELD_ERROR(paratroopers_range);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'paratroopers_mr_req'");
    if (!dio_get_uint8(&din, &real_packet->paratroopers_mr_req)) {
      RECEIVE_PACKET_FIELD_ERROR(paratroopers_mr_req);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'paratroopers_mr_sub'");
    if (!dio_get_uint8(&din, &real_packet->paratroopers_mr_sub)) {
      RECEIVE_PACKET_FIELD_ERROR(paratroopers_mr_sub);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'veteran_levels'");
    if (!dio_get_uint8(&din, &real_packet->veteran_levels)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran_levels);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'veteran_name'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(veteran_name, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_string(&din, real_packet->veteran_name[i], sizeof(real_packet->veteran_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(veteran_name);
        }
      }
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'power_fact'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(power_fact, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_uint16(&din, &real_packet->power_fact[i])) {
          RECEIVE_PACKET_FIELD_ERROR(power_fact);
        }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'move_bonus_new'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(move_bonus_new, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_uint16(&din, &real_packet->move_bonus_new[i])) {
          RECEIVE_PACKET_FIELD_ERROR(move_bonus_new);
        }
      }
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'bombard_rate'");
    if (!dio_get_uint8(&din, &real_packet->bombard_rate)) {
      RECEIVE_PACKET_FIELD_ERROR(bombard_rate);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'city_size'");
    if (!dio_get_uint8(&din, &real_packet->city_size)) {
      RECEIVE_PACKET_FIELD_ERROR(city_size);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'cargo'");
    if (!DIO_BV_GET(&din, real_packet->cargo)) {
      RECEIVE_PACKET_FIELD_ERROR(cargo);
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'targets'");
    if (!DIO_BV_GET(&din, real_packet->targets)) {
      RECEIVE_PACKET_FIELD_ERROR(targets);
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'embarks'");
    if (!DIO_BV_GET(&din, real_packet->embarks)) {
      RECEIVE_PACKET_FIELD_ERROR(embarks);
    }
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  got field 'disembarks'");
    if (!DIO_BV_GET(&din, real_packet->disembarks)) {
      RECEIVE_PACKET_FIELD_ERROR(disembarks);
    }
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'helptext'");
    if (!dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'roles'");
    if (!DIO_BV_GET(&din, real_packet->roles)) {
      RECEIVE_PACKET_FIELD_ERROR(roles);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_100(struct connection *pc, const struct packet_ruleset_unit *packet)
{
  const struct packet_ruleset_unit *real_packet = packet;
  packet_ruleset_unit_100_fields fields;
  struct packet_ruleset_unit *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT);

  log_packet_detailed("packet_ruleset_unit_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_100, cmp_packet_ruleset_unit_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->sound_move, real_packet->sound_move) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->sound_move_alt, real_packet->sound_move_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->sound_fight, real_packet->sound_fight) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->sound_fight_alt, real_packet->sound_fight_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->unit_class_id != real_packet->unit_class_id);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->build_cost != real_packet->build_cost);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->pop_cost != real_packet->pop_cost);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->attack_strength != real_packet->attack_strength);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->defense_strength != real_packet->defense_strength);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->move_rate_new != real_packet->move_rate_new);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->tech_requirement != real_packet->tech_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->impr_requirement != real_packet->impr_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->gov_requirement != real_packet->gov_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->vision_radius_sq != real_packet->vision_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->transport_capacity != real_packet->transport_capacity);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->firepower != real_packet->firepower);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->obsoleted_by != real_packet->obsoleted_by);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->converted_to != real_packet->converted_to);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->convert_time != real_packet->convert_time);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->upkeep[i] != real_packet->upkeep[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->paratroopers_range != real_packet->paratroopers_range);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->paratroopers_mr_req != real_packet->paratroopers_mr_req);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->paratroopers_mr_sub != real_packet->paratroopers_mr_sub);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->veteran_levels != real_packet->veteran_levels);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (strcmp(old->veteran_name[i], real_packet->veteran_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->power_fact[i] != real_packet->power_fact[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->move_bonus_new[i] != real_packet->move_bonus_new[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->bombard_rate != real_packet->bombard_rate);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->city_size != real_packet->city_size);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = !BV_ARE_EQUAL(old->cargo, real_packet->cargo);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = !BV_ARE_EQUAL(old->targets, real_packet->targets);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = !BV_ARE_EQUAL(old->embarks, real_packet->embarks);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }

  differ = !BV_ARE_EQUAL(old->disembarks, real_packet->disembarks);
  if (differ) {
    different++;
    BV_SET(fields, 40);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = !BV_ARE_EQUAL(old->roles, real_packet->roles);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'sound_move' has changed");
    dio_put_string(&dout, real_packet->sound_move);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'sound_move_alt' has changed");
    dio_put_string(&dout, real_packet->sound_move_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'sound_fight' has changed");
    dio_put_string(&dout, real_packet->sound_fight);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'sound_fight_alt' has changed");
    dio_put_string(&dout, real_packet->sound_fight_alt);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'unit_class_id' has changed");
    dio_put_uint8(&dout, real_packet->unit_class_id);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'build_cost' has changed");
    dio_put_uint16(&dout, real_packet->build_cost);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'pop_cost' has changed");
    dio_put_uint8(&dout, real_packet->pop_cost);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'attack_strength' has changed");
    dio_put_uint8(&dout, real_packet->attack_strength);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'defense_strength' has changed");
    dio_put_uint8(&dout, real_packet->defense_strength);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'move_rate_new' has changed");
    dio_put_uint16(&dout, real_packet->move_rate_new);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'tech_requirement' has changed");
    dio_put_uint8(&dout, real_packet->tech_requirement);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'impr_requirement' has changed");
    dio_put_uint8(&dout, real_packet->impr_requirement);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'gov_requirement' has changed");
    dio_put_uint8(&dout, real_packet->gov_requirement);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'vision_radius_sq' has changed");
    dio_put_uint16(&dout, real_packet->vision_radius_sq);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'transport_capacity' has changed");
    dio_put_uint8(&dout, real_packet->transport_capacity);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'hp' has changed");
    dio_put_uint8(&dout, real_packet->hp);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'firepower' has changed");
    dio_put_uint8(&dout, real_packet->firepower);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'obsoleted_by' has changed");
    dio_put_sint8(&dout, real_packet->obsoleted_by);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'converted_to' has changed");
    dio_put_sint8(&dout, real_packet->converted_to);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'convert_time' has changed");
    dio_put_uint8(&dout, real_packet->convert_time);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'fuel' has changed");
    dio_put_uint8(&dout, real_packet->fuel);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'happy_cost' has changed");
    dio_put_uint8(&dout, real_packet->happy_cost);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'upkeep' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->upkeep[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'paratroopers_range' has changed");
    dio_put_uint8(&dout, real_packet->paratroopers_range);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'paratroopers_mr_req' has changed");
    dio_put_uint8(&dout, real_packet->paratroopers_mr_req);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'paratroopers_mr_sub' has changed");
    dio_put_uint8(&dout, real_packet->paratroopers_mr_sub);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'veteran_levels' has changed");
    dio_put_uint8(&dout, real_packet->veteran_levels);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'veteran_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_string(&dout, real_packet->veteran_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'power_fact' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->power_fact[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'move_bonus_new' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->move_bonus_new[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'bombard_rate' has changed");
    dio_put_uint8(&dout, real_packet->bombard_rate);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'city_size' has changed");
    dio_put_uint8(&dout, real_packet->city_size);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'cargo' has changed");
  DIO_BV_PUT(&dout, packet->cargo);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'targets' has changed");
  DIO_BV_PUT(&dout, packet->targets);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'embarks' has changed");
  DIO_BV_PUT(&dout, packet->embarks);
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  field 'disembarks' has changed");
  DIO_BV_PUT(&dout, packet->disembarks);
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'roles' has changed");
  DIO_BV_PUT(&dout, packet->roles);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT);
}

#define hash_packet_ruleset_unit_101 hash_const

#define cmp_packet_ruleset_unit_101 cmp_const

BV_DEFINE(packet_ruleset_unit_101_fields, 44);

static struct packet_ruleset_unit *receive_packet_ruleset_unit_101(struct connection *pc)
{
  packet_ruleset_unit_101_fields fields;
  struct packet_ruleset_unit *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT;
  RECEIVE_PACKET_START(packet_ruleset_unit, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_101: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_101, cmp_packet_ruleset_unit_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'sound_move'");
    if (!dio_get_string(&din, real_packet->sound_move, sizeof(real_packet->sound_move))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_move);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'sound_move_alt'");
    if (!dio_get_string(&din, real_packet->sound_move_alt, sizeof(real_packet->sound_move_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_move_alt);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'sound_fight'");
    if (!dio_get_string(&din, real_packet->sound_fight, sizeof(real_packet->sound_fight))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_fight);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'sound_fight_alt'");
    if (!dio_get_string(&din, real_packet->sound_fight_alt, sizeof(real_packet->sound_fight_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(sound_fight_alt);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'unit_class_id'");
    if (!dio_get_uint8(&din, &real_packet->unit_class_id)) {
      RECEIVE_PACKET_FIELD_ERROR(unit_class_id);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'build_cost'");
    if (!dio_get_uint16(&din, &real_packet->build_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(build_cost);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'pop_cost'");
    if (!dio_get_uint8(&din, &real_packet->pop_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(pop_cost);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'attack_strength'");
    if (!dio_get_uint8(&din, &real_packet->attack_strength)) {
      RECEIVE_PACKET_FIELD_ERROR(attack_strength);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'defense_strength'");
    if (!dio_get_uint8(&din, &real_packet->defense_strength)) {
      RECEIVE_PACKET_FIELD_ERROR(defense_strength);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'move_rate_old'");
    if (!dio_get_uint8(&din, &real_packet->move_rate_old)) {
      RECEIVE_PACKET_FIELD_ERROR(move_rate_old);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'tech_requirement'");
    if (!dio_get_uint8(&din, &real_packet->tech_requirement)) {
      RECEIVE_PACKET_FIELD_ERROR(tech_requirement);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'impr_requirement'");
    if (!dio_get_uint8(&din, &real_packet->impr_requirement)) {
      RECEIVE_PACKET_FIELD_ERROR(impr_requirement);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'gov_requirement'");
    if (!dio_get_uint8(&din, &real_packet->gov_requirement)) {
      RECEIVE_PACKET_FIELD_ERROR(gov_requirement);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'vision_radius_sq'");
    if (!dio_get_uint16(&din, &real_packet->vision_radius_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(vision_radius_sq);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'transport_capacity'");
    if (!dio_get_uint8(&din, &real_packet->transport_capacity)) {
      RECEIVE_PACKET_FIELD_ERROR(transport_capacity);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'hp'");
    if (!dio_get_uint8(&din, &real_packet->hp)) {
      RECEIVE_PACKET_FIELD_ERROR(hp);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'firepower'");
    if (!dio_get_uint8(&din, &real_packet->firepower)) {
      RECEIVE_PACKET_FIELD_ERROR(firepower);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'obsoleted_by'");
    if (!dio_get_sint8(&din, &real_packet->obsoleted_by)) {
      RECEIVE_PACKET_FIELD_ERROR(obsoleted_by);
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'converted_to'");
    if (!dio_get_sint8(&din, &real_packet->converted_to)) {
      RECEIVE_PACKET_FIELD_ERROR(converted_to);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'convert_time'");
    if (!dio_get_uint8(&din, &real_packet->convert_time)) {
      RECEIVE_PACKET_FIELD_ERROR(convert_time);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'fuel'");
    if (!dio_get_uint8(&din, &real_packet->fuel)) {
      RECEIVE_PACKET_FIELD_ERROR(fuel);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'happy_cost'");
    if (!dio_get_uint8(&din, &real_packet->happy_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(happy_cost);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'upkeep'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->upkeep[i])) {
          RECEIVE_PACKET_FIELD_ERROR(upkeep);
        }
      }
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'paratroopers_range'");
    if (!dio_get_uint8(&din, &real_packet->paratroopers_range)) {
      RECEIVE_PACKET_FIELD_ERROR(paratroopers_range);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'paratroopers_mr_req'");
    if (!dio_get_uint8(&din, &real_packet->paratroopers_mr_req)) {
      RECEIVE_PACKET_FIELD_ERROR(paratroopers_mr_req);
    }
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  got field 'paratroopers_mr_sub'");
    if (!dio_get_uint8(&din, &real_packet->paratroopers_mr_sub)) {
      RECEIVE_PACKET_FIELD_ERROR(paratroopers_mr_sub);
    }
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  got field 'veteran_levels'");
    if (!dio_get_uint8(&din, &real_packet->veteran_levels)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran_levels);
    }
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  got field 'veteran_name'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(veteran_name, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_string(&din, real_packet->veteran_name[i], sizeof(real_packet->veteran_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(veteran_name);
        }
      }
    }
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  got field 'power_fact'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(power_fact, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_uint16(&din, &real_packet->power_fact[i])) {
          RECEIVE_PACKET_FIELD_ERROR(power_fact);
        }
      }
    }
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  got field 'move_bonus_old'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(move_bonus_old, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_uint8(&din, &real_packet->move_bonus_old[i])) {
          RECEIVE_PACKET_FIELD_ERROR(move_bonus_old);
        }
      }
    }
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  got field 'bombard_rate'");
    if (!dio_get_uint8(&din, &real_packet->bombard_rate)) {
      RECEIVE_PACKET_FIELD_ERROR(bombard_rate);
    }
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  got field 'city_size'");
    if (!dio_get_uint8(&din, &real_packet->city_size)) {
      RECEIVE_PACKET_FIELD_ERROR(city_size);
    }
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  got field 'cargo'");
    if (!DIO_BV_GET(&din, real_packet->cargo)) {
      RECEIVE_PACKET_FIELD_ERROR(cargo);
    }
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  got field 'targets'");
    if (!DIO_BV_GET(&din, real_packet->targets)) {
      RECEIVE_PACKET_FIELD_ERROR(targets);
    }
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  got field 'embarks'");
    if (!DIO_BV_GET(&din, real_packet->embarks)) {
      RECEIVE_PACKET_FIELD_ERROR(embarks);
    }
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  got field 'disembarks'");
    if (!DIO_BV_GET(&din, real_packet->disembarks)) {
      RECEIVE_PACKET_FIELD_ERROR(disembarks);
    }
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  got field 'helptext'");
    if (!dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  got field 'roles'");
    if (!DIO_BV_GET(&din, real_packet->roles)) {
      RECEIVE_PACKET_FIELD_ERROR(roles);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_101(struct connection *pc, const struct packet_ruleset_unit *packet)
{
  const struct packet_ruleset_unit *real_packet = packet;
  packet_ruleset_unit_101_fields fields;
  struct packet_ruleset_unit *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT);

  log_packet_detailed("packet_ruleset_unit_101: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_101, cmp_packet_ruleset_unit_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->sound_move, real_packet->sound_move) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->sound_move_alt, real_packet->sound_move_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->sound_fight, real_packet->sound_fight) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->sound_fight_alt, real_packet->sound_fight_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->unit_class_id != real_packet->unit_class_id);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->build_cost != real_packet->build_cost);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->pop_cost != real_packet->pop_cost);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->attack_strength != real_packet->attack_strength);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->defense_strength != real_packet->defense_strength);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->move_rate_old != real_packet->move_rate_old);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->tech_requirement != real_packet->tech_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->impr_requirement != real_packet->impr_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->gov_requirement != real_packet->gov_requirement);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->vision_radius_sq != real_packet->vision_radius_sq);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->transport_capacity != real_packet->transport_capacity);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->hp != real_packet->hp);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->firepower != real_packet->firepower);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->obsoleted_by != real_packet->obsoleted_by);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->converted_to != real_packet->converted_to);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->convert_time != real_packet->convert_time);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->fuel != real_packet->fuel);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->happy_cost != real_packet->happy_cost);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->upkeep[i] != real_packet->upkeep[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->paratroopers_range != real_packet->paratroopers_range);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (old->paratroopers_mr_req != real_packet->paratroopers_mr_req);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }

  differ = (old->paratroopers_mr_sub != real_packet->paratroopers_mr_sub);
  if (differ) {
    different++;
    BV_SET(fields, 30);
  }

  differ = (old->veteran_levels != real_packet->veteran_levels);
  if (differ) {
    different++;
    BV_SET(fields, 31);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (strcmp(old->veteran_name[i], real_packet->veteran_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 32);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->power_fact[i] != real_packet->power_fact[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 33);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->move_bonus_old[i] != real_packet->move_bonus_old[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 34);
  }

  differ = (old->bombard_rate != real_packet->bombard_rate);
  if (differ) {
    different++;
    BV_SET(fields, 35);
  }

  differ = (old->city_size != real_packet->city_size);
  if (differ) {
    different++;
    BV_SET(fields, 36);
  }

  differ = !BV_ARE_EQUAL(old->cargo, real_packet->cargo);
  if (differ) {
    different++;
    BV_SET(fields, 37);
  }

  differ = !BV_ARE_EQUAL(old->targets, real_packet->targets);
  if (differ) {
    different++;
    BV_SET(fields, 38);
  }

  differ = !BV_ARE_EQUAL(old->embarks, real_packet->embarks);
  if (differ) {
    different++;
    BV_SET(fields, 39);
  }

  differ = !BV_ARE_EQUAL(old->disembarks, real_packet->disembarks);
  if (differ) {
    different++;
    BV_SET(fields, 40);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 41);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 42);
  }

  differ = !BV_ARE_EQUAL(old->roles, real_packet->roles);
  if (differ) {
    different++;
    BV_SET(fields, 43);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'sound_move' has changed");
    dio_put_string(&dout, real_packet->sound_move);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'sound_move_alt' has changed");
    dio_put_string(&dout, real_packet->sound_move_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'sound_fight' has changed");
    dio_put_string(&dout, real_packet->sound_fight);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'sound_fight_alt' has changed");
    dio_put_string(&dout, real_packet->sound_fight_alt);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'unit_class_id' has changed");
    dio_put_uint8(&dout, real_packet->unit_class_id);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'build_cost' has changed");
    dio_put_uint16(&dout, real_packet->build_cost);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'pop_cost' has changed");
    dio_put_uint8(&dout, real_packet->pop_cost);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'attack_strength' has changed");
    dio_put_uint8(&dout, real_packet->attack_strength);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'defense_strength' has changed");
    dio_put_uint8(&dout, real_packet->defense_strength);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'move_rate_old' has changed");
    dio_put_uint8(&dout, real_packet->move_rate_old);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'tech_requirement' has changed");
    dio_put_uint8(&dout, real_packet->tech_requirement);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'impr_requirement' has changed");
    dio_put_uint8(&dout, real_packet->impr_requirement);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'gov_requirement' has changed");
    dio_put_uint8(&dout, real_packet->gov_requirement);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'vision_radius_sq' has changed");
    dio_put_uint16(&dout, real_packet->vision_radius_sq);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'transport_capacity' has changed");
    dio_put_uint8(&dout, real_packet->transport_capacity);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'hp' has changed");
    dio_put_uint8(&dout, real_packet->hp);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'firepower' has changed");
    dio_put_uint8(&dout, real_packet->firepower);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'obsoleted_by' has changed");
    dio_put_sint8(&dout, real_packet->obsoleted_by);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'converted_to' has changed");
    dio_put_sint8(&dout, real_packet->converted_to);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'convert_time' has changed");
    dio_put_uint8(&dout, real_packet->convert_time);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'fuel' has changed");
    dio_put_uint8(&dout, real_packet->fuel);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'happy_cost' has changed");
    dio_put_uint8(&dout, real_packet->happy_cost);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'upkeep' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->upkeep[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'paratroopers_range' has changed");
    dio_put_uint8(&dout, real_packet->paratroopers_range);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'paratroopers_mr_req' has changed");
    dio_put_uint8(&dout, real_packet->paratroopers_mr_req);
  }
  if (BV_ISSET(fields, 30)) {
    log_packet_detailed("  field 'paratroopers_mr_sub' has changed");
    dio_put_uint8(&dout, real_packet->paratroopers_mr_sub);
  }
  if (BV_ISSET(fields, 31)) {
    log_packet_detailed("  field 'veteran_levels' has changed");
    dio_put_uint8(&dout, real_packet->veteran_levels);
  }
  if (BV_ISSET(fields, 32)) {
    log_packet_detailed("  field 'veteran_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_string(&dout, real_packet->veteran_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 33)) {
    log_packet_detailed("  field 'power_fact' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->power_fact[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 34)) {
    log_packet_detailed("  field 'move_bonus_old' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint8(&dout, real_packet->move_bonus_old[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 35)) {
    log_packet_detailed("  field 'bombard_rate' has changed");
    dio_put_uint8(&dout, real_packet->bombard_rate);
  }
  if (BV_ISSET(fields, 36)) {
    log_packet_detailed("  field 'city_size' has changed");
    dio_put_uint8(&dout, real_packet->city_size);
  }
  if (BV_ISSET(fields, 37)) {
    log_packet_detailed("  field 'cargo' has changed");
  DIO_BV_PUT(&dout, packet->cargo);
  }
  if (BV_ISSET(fields, 38)) {
    log_packet_detailed("  field 'targets' has changed");
  DIO_BV_PUT(&dout, packet->targets);
  }
  if (BV_ISSET(fields, 39)) {
    log_packet_detailed("  field 'embarks' has changed");
  DIO_BV_PUT(&dout, packet->embarks);
  }
  if (BV_ISSET(fields, 40)) {
    log_packet_detailed("  field 'disembarks' has changed");
  DIO_BV_PUT(&dout, packet->disembarks);
  }
  if (BV_ISSET(fields, 41)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }
  if (BV_ISSET(fields, 42)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 43)) {
    log_packet_detailed("  field 'roles' has changed");
  DIO_BV_PUT(&dout, packet->roles);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT);
}

static void ensure_valid_variant_packet_ruleset_unit(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_UNIT] != -1) {
    return;
  }

  if(FALSE) {
  } else if((has_capability("extended_move_rate", pc->capability) && has_capability("extended_move_rate", our_capability))) {
    variant = 100;
  } else if(!(has_capability("extended_move_rate", pc->capability) && has_capability("extended_move_rate", our_capability))) {
    variant = 101;
  } else {
    log_error("Unknown PACKET_RULESET_UNIT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  log_packet_detailed("packet_ruleset_unit: using variant=%d cap=%s", variant, pc->capability);
  pc->phs.variant[PACKET_RULESET_UNIT] = variant;
}

struct packet_ruleset_unit *receive_packet_ruleset_unit(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_unit at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_unit(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT]) {
  case 100:
    return receive_packet_ruleset_unit_100(pc);
  case 101:
    return receive_packet_ruleset_unit_101(pc);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_unit(struct connection *pc, const struct packet_ruleset_unit *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_unit from the client.");
  }
  ensure_valid_variant_packet_ruleset_unit(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT]) {

  case 100:
    return send_packet_ruleset_unit_100(pc, packet);
  case 101:
    return send_packet_ruleset_unit_101(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_unit(struct conn_list *dest, const struct packet_ruleset_unit *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_bonus_100 hash_const

#define cmp_packet_ruleset_unit_bonus_100 cmp_const

BV_DEFINE(packet_ruleset_unit_bonus_100_fields, 4);

static struct packet_ruleset_unit_bonus *receive_packet_ruleset_unit_bonus_100(struct connection *pc)
{
  packet_ruleset_unit_bonus_100_fields fields;
  struct packet_ruleset_unit_bonus *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT_BONUS;
  RECEIVE_PACKET_START(packet_ruleset_unit_bonus, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_bonus_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_bonus_100, cmp_packet_ruleset_unit_bonus_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'unit'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(unit);
      }
      real_packet->unit = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'flag'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(flag);
      }
      real_packet->flag = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(type);
      }
      real_packet->type = readin;
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'value'");
    if (!dio_get_uint8(&din, &real_packet->value)) {
      RECEIVE_PACKET_FIELD_ERROR(value);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_bonus_100(struct connection *pc, const struct packet_ruleset_unit_bonus *packet)
{
  const struct packet_ruleset_unit_bonus *real_packet = packet;
  packet_ruleset_unit_bonus_100_fields fields;
  struct packet_ruleset_unit_bonus *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT_BONUS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT_BONUS);

  log_packet_detailed("packet_ruleset_unit_bonus_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_bonus_100, cmp_packet_ruleset_unit_bonus_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->unit != real_packet->unit);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->flag != real_packet->flag);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->type != real_packet->type);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->value != real_packet->value);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'unit' has changed");
    dio_put_uint8(&dout, real_packet->unit);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'flag' has changed");
    dio_put_uint8(&dout, real_packet->flag);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'type' has changed");
    dio_put_uint8(&dout, real_packet->type);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'value' has changed");
    dio_put_uint8(&dout, real_packet->value);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT_BONUS);
}

static void ensure_valid_variant_packet_ruleset_unit_bonus(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_UNIT_BONUS] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_UNIT_BONUS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_UNIT_BONUS] = variant;
}

struct packet_ruleset_unit_bonus *receive_packet_ruleset_unit_bonus(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_unit_bonus at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_unit_bonus(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT_BONUS]) {
  case 100:
    return receive_packet_ruleset_unit_bonus_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT_BONUS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_unit_bonus(struct connection *pc, const struct packet_ruleset_unit_bonus *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_unit_bonus from the client.");
  }
  ensure_valid_variant_packet_ruleset_unit_bonus(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT_BONUS]) {

  case 100:
    return send_packet_ruleset_unit_bonus_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT_BONUS variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_unit_bonus(struct conn_list *dest, const struct packet_ruleset_unit_bonus *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit_bonus(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_flag_100 hash_const

#define cmp_packet_ruleset_unit_flag_100 cmp_const

BV_DEFINE(packet_ruleset_unit_flag_100_fields, 3);

static struct packet_ruleset_unit_flag *receive_packet_ruleset_unit_flag_100(struct connection *pc)
{
  packet_ruleset_unit_flag_100_fields fields;
  struct packet_ruleset_unit_flag *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT_FLAG;
  RECEIVE_PACKET_START(packet_ruleset_unit_flag, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_flag_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_flag_100, cmp_packet_ruleset_unit_flag_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!dio_get_uint8(&din, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'helptxt'");
    if (!dio_get_string(&din, real_packet->helptxt, sizeof(real_packet->helptxt))) {
      RECEIVE_PACKET_FIELD_ERROR(helptxt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_flag_100(struct connection *pc, const struct packet_ruleset_unit_flag *packet)
{
  const struct packet_ruleset_unit_flag *real_packet = packet;
  packet_ruleset_unit_flag_100_fields fields;
  struct packet_ruleset_unit_flag *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT_FLAG;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT_FLAG);

  log_packet_detailed("packet_ruleset_unit_flag_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_flag_100, cmp_packet_ruleset_unit_flag_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->helptxt, real_packet->helptxt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'helptxt' has changed");
    dio_put_string(&dout, real_packet->helptxt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT_FLAG);
}

static void ensure_valid_variant_packet_ruleset_unit_flag(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_UNIT_FLAG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_UNIT_FLAG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_UNIT_FLAG] = variant;
}

struct packet_ruleset_unit_flag *receive_packet_ruleset_unit_flag(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_unit_flag at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_unit_flag(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT_FLAG]) {
  case 100:
    return receive_packet_ruleset_unit_flag_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT_FLAG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_unit_flag(struct connection *pc, const struct packet_ruleset_unit_flag *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_unit_flag from the client.");
  }
  ensure_valid_variant_packet_ruleset_unit_flag(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT_FLAG]) {

  case 100:
    return send_packet_ruleset_unit_flag_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT_FLAG variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_unit_flag(struct conn_list *dest, const struct packet_ruleset_unit_flag *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit_flag(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_game_100 hash_const

#define cmp_packet_ruleset_game_100 cmp_const

BV_DEFINE(packet_ruleset_game_100_fields, 10);

static struct packet_ruleset_game *receive_packet_ruleset_game_100(struct connection *pc)
{
  packet_ruleset_game_100_fields fields;
  struct packet_ruleset_game *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_GAME;
  RECEIVE_PACKET_START(packet_ruleset_game, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_game_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_game_100, cmp_packet_ruleset_game_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'default_specialist'");
    if (!dio_get_uint8(&din, &real_packet->default_specialist)) {
      RECEIVE_PACKET_FIELD_ERROR(default_specialist);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'global_init_techs'");
    if (!dio_get_tech_list(&din, real_packet->global_init_techs)) {
      RECEIVE_PACKET_FIELD_ERROR(global_init_techs);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'global_init_buildings'");
    if (!dio_get_building_list(&din, real_packet->global_init_buildings)) {
      RECEIVE_PACKET_FIELD_ERROR(global_init_buildings);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'veteran_levels'");
    if (!dio_get_uint8(&din, &real_packet->veteran_levels)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran_levels);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'veteran_name'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(veteran_name, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_string(&din, real_packet->veteran_name[i], sizeof(real_packet->veteran_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(veteran_name);
        }
      }
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'power_fact'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(power_fact, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_uint16(&din, &real_packet->power_fact[i])) {
          RECEIVE_PACKET_FIELD_ERROR(power_fact);
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'move_bonus_new'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(move_bonus_new, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_uint16(&din, &real_packet->move_bonus_new[i])) {
          RECEIVE_PACKET_FIELD_ERROR(move_bonus_new);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'background_red'");
    if (!dio_get_uint8(&din, &real_packet->background_red)) {
      RECEIVE_PACKET_FIELD_ERROR(background_red);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'background_green'");
    if (!dio_get_uint8(&din, &real_packet->background_green)) {
      RECEIVE_PACKET_FIELD_ERROR(background_green);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'background_blue'");
    if (!dio_get_uint8(&din, &real_packet->background_blue)) {
      RECEIVE_PACKET_FIELD_ERROR(background_blue);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_game_100(struct connection *pc, const struct packet_ruleset_game *packet)
{
  const struct packet_ruleset_game *real_packet = packet;
  packet_ruleset_game_100_fields fields;
  struct packet_ruleset_game *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GAME;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GAME);

  log_packet_detailed("packet_ruleset_game_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_game_100, cmp_packet_ruleset_game_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->default_specialist != real_packet->default_specialist);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (MAX_NUM_TECH_LIST != MAX_NUM_TECH_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_TECH_LIST; i++) {
          if (old->global_init_techs[i] != real_packet->global_init_techs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (MAX_NUM_BUILDING_LIST != MAX_NUM_BUILDING_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_BUILDING_LIST; i++) {
          if (old->global_init_buildings[i] != real_packet->global_init_buildings[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->veteran_levels != real_packet->veteran_levels);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (strcmp(old->veteran_name[i], real_packet->veteran_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->power_fact[i] != real_packet->power_fact[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->move_bonus_new[i] != real_packet->move_bonus_new[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->background_red != real_packet->background_red);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->background_green != real_packet->background_green);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->background_blue != real_packet->background_blue);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'default_specialist' has changed");
    dio_put_uint8(&dout, real_packet->default_specialist);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'global_init_techs' has changed");
    dio_put_tech_list(&dout, real_packet->global_init_techs);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'global_init_buildings' has changed");
    dio_put_building_list(&dout, real_packet->global_init_buildings);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'veteran_levels' has changed");
    dio_put_uint8(&dout, real_packet->veteran_levels);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'veteran_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_string(&dout, real_packet->veteran_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'power_fact' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->power_fact[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'move_bonus_new' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->move_bonus_new[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'background_red' has changed");
    dio_put_uint8(&dout, real_packet->background_red);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'background_green' has changed");
    dio_put_uint8(&dout, real_packet->background_green);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'background_blue' has changed");
    dio_put_uint8(&dout, real_packet->background_blue);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_GAME);
}

#define hash_packet_ruleset_game_101 hash_const

#define cmp_packet_ruleset_game_101 cmp_const

BV_DEFINE(packet_ruleset_game_101_fields, 10);

static struct packet_ruleset_game *receive_packet_ruleset_game_101(struct connection *pc)
{
  packet_ruleset_game_101_fields fields;
  struct packet_ruleset_game *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_GAME;
  RECEIVE_PACKET_START(packet_ruleset_game, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_game_101: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_game_101, cmp_packet_ruleset_game_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'default_specialist'");
    if (!dio_get_uint8(&din, &real_packet->default_specialist)) {
      RECEIVE_PACKET_FIELD_ERROR(default_specialist);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'global_init_techs'");
    if (!dio_get_tech_list(&din, real_packet->global_init_techs)) {
      RECEIVE_PACKET_FIELD_ERROR(global_init_techs);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'global_init_buildings'");
    if (!dio_get_building_list(&din, real_packet->global_init_buildings)) {
      RECEIVE_PACKET_FIELD_ERROR(global_init_buildings);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'veteran_levels'");
    if (!dio_get_uint8(&din, &real_packet->veteran_levels)) {
      RECEIVE_PACKET_FIELD_ERROR(veteran_levels);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'veteran_name'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(veteran_name, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_string(&din, real_packet->veteran_name[i], sizeof(real_packet->veteran_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(veteran_name);
        }
      }
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'power_fact'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(power_fact, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_uint16(&din, &real_packet->power_fact[i])) {
          RECEIVE_PACKET_FIELD_ERROR(power_fact);
        }
      }
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'move_bonus_old'");
    
    {
      int i;
    
      if (real_packet->veteran_levels > MAX_VET_LEVELS) {
        RECEIVE_PACKET_FIELD_ERROR(move_bonus_old, ": truncation array");
      }
      for (i = 0; i < real_packet->veteran_levels; i++) {
        if (!dio_get_uint8(&din, &real_packet->move_bonus_old[i])) {
          RECEIVE_PACKET_FIELD_ERROR(move_bonus_old);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'background_red'");
    if (!dio_get_uint8(&din, &real_packet->background_red)) {
      RECEIVE_PACKET_FIELD_ERROR(background_red);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'background_green'");
    if (!dio_get_uint8(&din, &real_packet->background_green)) {
      RECEIVE_PACKET_FIELD_ERROR(background_green);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'background_blue'");
    if (!dio_get_uint8(&din, &real_packet->background_blue)) {
      RECEIVE_PACKET_FIELD_ERROR(background_blue);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_game_101(struct connection *pc, const struct packet_ruleset_game *packet)
{
  const struct packet_ruleset_game *real_packet = packet;
  packet_ruleset_game_101_fields fields;
  struct packet_ruleset_game *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GAME;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GAME);

  log_packet_detailed("packet_ruleset_game_101: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_game_101, cmp_packet_ruleset_game_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->default_specialist != real_packet->default_specialist);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (MAX_NUM_TECH_LIST != MAX_NUM_TECH_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_TECH_LIST; i++) {
          if (old->global_init_techs[i] != real_packet->global_init_techs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (MAX_NUM_BUILDING_LIST != MAX_NUM_BUILDING_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_BUILDING_LIST; i++) {
          if (old->global_init_buildings[i] != real_packet->global_init_buildings[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->veteran_levels != real_packet->veteran_levels);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (strcmp(old->veteran_name[i], real_packet->veteran_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->power_fact[i] != real_packet->power_fact[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->veteran_levels != real_packet->veteran_levels);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->veteran_levels; i++) {
          if (old->move_bonus_old[i] != real_packet->move_bonus_old[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->background_red != real_packet->background_red);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->background_green != real_packet->background_green);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->background_blue != real_packet->background_blue);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'default_specialist' has changed");
    dio_put_uint8(&dout, real_packet->default_specialist);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'global_init_techs' has changed");
    dio_put_tech_list(&dout, real_packet->global_init_techs);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'global_init_buildings' has changed");
    dio_put_building_list(&dout, real_packet->global_init_buildings);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'veteran_levels' has changed");
    dio_put_uint8(&dout, real_packet->veteran_levels);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'veteran_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_string(&dout, real_packet->veteran_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'power_fact' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint16(&dout, real_packet->power_fact[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'move_bonus_old' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->veteran_levels; i++) {
        dio_put_uint8(&dout, real_packet->move_bonus_old[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'background_red' has changed");
    dio_put_uint8(&dout, real_packet->background_red);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'background_green' has changed");
    dio_put_uint8(&dout, real_packet->background_green);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'background_blue' has changed");
    dio_put_uint8(&dout, real_packet->background_blue);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_GAME);
}

static void ensure_valid_variant_packet_ruleset_game(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_GAME] != -1) {
    return;
  }

  if(FALSE) {
  } else if((has_capability("extended_move_rate", pc->capability) && has_capability("extended_move_rate", our_capability))) {
    variant = 100;
  } else if(!(has_capability("extended_move_rate", pc->capability) && has_capability("extended_move_rate", our_capability))) {
    variant = 101;
  } else {
    log_error("Unknown PACKET_RULESET_GAME variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  log_packet_detailed("packet_ruleset_game: using variant=%d cap=%s", variant, pc->capability);
  pc->phs.variant[PACKET_RULESET_GAME] = variant;
}

struct packet_ruleset_game *receive_packet_ruleset_game(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_game at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_game(pc);

  switch(pc->phs.variant[PACKET_RULESET_GAME]) {
  case 100:
    return receive_packet_ruleset_game_100(pc);
  case 101:
    return receive_packet_ruleset_game_101(pc);
  default:
    log_debug("Unknown PACKET_RULESET_GAME variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_game(struct connection *pc, const struct packet_ruleset_game *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_game from the client.");
  }
  ensure_valid_variant_packet_ruleset_game(pc);

  switch(pc->phs.variant[PACKET_RULESET_GAME]) {

  case 100:
    return send_packet_ruleset_game_100(pc, packet);
  case 101:
    return send_packet_ruleset_game_101(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_GAME variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_game(struct conn_list *dest, const struct packet_ruleset_game *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_game(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_specialist_100 hash_const

#define cmp_packet_ruleset_specialist_100 cmp_const

BV_DEFINE(packet_ruleset_specialist_100_fields, 8);

static struct packet_ruleset_specialist *receive_packet_ruleset_specialist_100(struct connection *pc)
{
  packet_ruleset_specialist_100_fields fields;
  struct packet_ruleset_specialist *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_SPECIALIST;
  RECEIVE_PACKET_START(packet_ruleset_specialist, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_specialist_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_specialist_100, cmp_packet_ruleset_specialist_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'plural_name'");
    if (!dio_get_string(&din, real_packet->plural_name, sizeof(real_packet->plural_name))) {
      RECEIVE_PACKET_FIELD_ERROR(plural_name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'short_name'");
    if (!dio_get_string(&din, real_packet->short_name, sizeof(real_packet->short_name))) {
      RECEIVE_PACKET_FIELD_ERROR(short_name);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!dio_get_uint8(&din, &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!dio_get_requirement(&din, &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'helptext'");
    if (!dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_specialist_100(struct connection *pc, const struct packet_ruleset_specialist *packet)
{
  const struct packet_ruleset_specialist *real_packet = packet;
  packet_ruleset_specialist_100_fields fields;
  struct packet_ruleset_specialist *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_SPECIALIST;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_SPECIALIST);

  log_packet_detailed("packet_ruleset_specialist_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_specialist_100, cmp_packet_ruleset_specialist_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->plural_name, real_packet->plural_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->short_name, real_packet->short_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'plural_name' has changed");
    dio_put_string(&dout, real_packet->plural_name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'short_name' has changed");
    dio_put_string(&dout, real_packet->short_name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_SPECIALIST);
}

static void ensure_valid_variant_packet_ruleset_specialist(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_SPECIALIST] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_SPECIALIST variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_SPECIALIST] = variant;
}

struct packet_ruleset_specialist *receive_packet_ruleset_specialist(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_specialist at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_specialist(pc);

  switch(pc->phs.variant[PACKET_RULESET_SPECIALIST]) {
  case 100:
    return receive_packet_ruleset_specialist_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_SPECIALIST variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_specialist(struct connection *pc, const struct packet_ruleset_specialist *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_specialist from the client.");
  }
  ensure_valid_variant_packet_ruleset_specialist(pc);

  switch(pc->phs.variant[PACKET_RULESET_SPECIALIST]) {

  case 100:
    return send_packet_ruleset_specialist_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_SPECIALIST variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_specialist(struct conn_list *dest, const struct packet_ruleset_specialist *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_specialist(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_government_ruler_title_100 hash_const

#define cmp_packet_ruleset_government_ruler_title_100 cmp_const

BV_DEFINE(packet_ruleset_government_ruler_title_100_fields, 4);

static struct packet_ruleset_government_ruler_title *receive_packet_ruleset_government_ruler_title_100(struct connection *pc)
{
  packet_ruleset_government_ruler_title_100_fields fields;
  struct packet_ruleset_government_ruler_title *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_GOVERNMENT_RULER_TITLE;
  RECEIVE_PACKET_START(packet_ruleset_government_ruler_title, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_government_ruler_title_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_ruler_title_100, cmp_packet_ruleset_government_ruler_title_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'gov'");
    if (!dio_get_uint8(&din, &real_packet->gov)) {
      RECEIVE_PACKET_FIELD_ERROR(gov);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'nation'");
    {
      int readin;
      
      if (!dio_get_sint16(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(nation);
      }
      real_packet->nation = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'male_title'");
    if (!dio_get_string(&din, real_packet->male_title, sizeof(real_packet->male_title))) {
      RECEIVE_PACKET_FIELD_ERROR(male_title);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'female_title'");
    if (!dio_get_string(&din, real_packet->female_title, sizeof(real_packet->female_title))) {
      RECEIVE_PACKET_FIELD_ERROR(female_title);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_government_ruler_title_100(struct connection *pc, const struct packet_ruleset_government_ruler_title *packet)
{
  const struct packet_ruleset_government_ruler_title *real_packet = packet;
  packet_ruleset_government_ruler_title_100_fields fields;
  struct packet_ruleset_government_ruler_title *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GOVERNMENT_RULER_TITLE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GOVERNMENT_RULER_TITLE);

  log_packet_detailed("packet_ruleset_government_ruler_title_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_ruler_title_100, cmp_packet_ruleset_government_ruler_title_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->gov != real_packet->gov);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->nation != real_packet->nation);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->male_title, real_packet->male_title) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->female_title, real_packet->female_title) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'gov' has changed");
    dio_put_uint8(&dout, real_packet->gov);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'nation' has changed");
    dio_put_sint16(&dout, real_packet->nation);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'male_title' has changed");
    dio_put_string(&dout, real_packet->male_title);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'female_title' has changed");
    dio_put_string(&dout, real_packet->female_title);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_GOVERNMENT_RULER_TITLE);
}

static void ensure_valid_variant_packet_ruleset_government_ruler_title(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_GOVERNMENT_RULER_TITLE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_GOVERNMENT_RULER_TITLE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_GOVERNMENT_RULER_TITLE] = variant;
}

struct packet_ruleset_government_ruler_title *receive_packet_ruleset_government_ruler_title(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_government_ruler_title at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_government_ruler_title(pc);

  switch(pc->phs.variant[PACKET_RULESET_GOVERNMENT_RULER_TITLE]) {
  case 100:
    return receive_packet_ruleset_government_ruler_title_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_GOVERNMENT_RULER_TITLE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_government_ruler_title(struct connection *pc, const struct packet_ruleset_government_ruler_title *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_government_ruler_title from the client.");
  }
  ensure_valid_variant_packet_ruleset_government_ruler_title(pc);

  switch(pc->phs.variant[PACKET_RULESET_GOVERNMENT_RULER_TITLE]) {

  case 100:
    return send_packet_ruleset_government_ruler_title_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_GOVERNMENT_RULER_TITLE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_government_ruler_title(struct conn_list *dest, const struct packet_ruleset_government_ruler_title *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_government_ruler_title(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_tech_100 hash_const

#define cmp_packet_ruleset_tech_100 cmp_const

BV_DEFINE(packet_ruleset_tech_100_fields, 11);

static struct packet_ruleset_tech *receive_packet_ruleset_tech_100(struct connection *pc)
{
  packet_ruleset_tech_100_fields fields;
  struct packet_ruleset_tech *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TECH;
  RECEIVE_PACKET_START(packet_ruleset_tech, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_tech_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_100, cmp_packet_ruleset_tech_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!dio_get_uint8(&din, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'req'");
    
    {
      int i;
    
      for (i = 0; i < 2; i++) {
        if (!dio_get_uint8(&din, &real_packet->req[i])) {
          RECEIVE_PACKET_FIELD_ERROR(req);
        }
      }
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'root_req'");
    if (!dio_get_uint8(&din, &real_packet->root_req)) {
      RECEIVE_PACKET_FIELD_ERROR(root_req);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'preset_cost'");
    if (!dio_get_uint32(&din, &real_packet->preset_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(preset_cost);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'num_reqs'");
    if (!dio_get_uint32(&din, &real_packet->num_reqs)) {
      RECEIVE_PACKET_FIELD_ERROR(num_reqs);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'helptext'");
    if (!dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_tech_100(struct connection *pc, const struct packet_ruleset_tech *packet)
{
  const struct packet_ruleset_tech *real_packet = packet;
  packet_ruleset_tech_100_fields fields;
  struct packet_ruleset_tech *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TECH;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TECH);

  log_packet_detailed("packet_ruleset_tech_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_100, cmp_packet_ruleset_tech_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (2 != 2);
      if(!differ) {
        int i;
        for (i = 0; i < 2; i++) {
          if (old->req[i] != real_packet->req[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->root_req != real_packet->root_req);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->preset_cost != real_packet->preset_cost);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->num_reqs != real_packet->num_reqs);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'req' has changed");
  
    {
      int i;

      for (i = 0; i < 2; i++) {
        dio_put_uint8(&dout, real_packet->req[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'root_req' has changed");
    dio_put_uint8(&dout, real_packet->root_req);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'preset_cost' has changed");
    dio_put_uint32(&dout, real_packet->preset_cost);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'num_reqs' has changed");
    dio_put_uint32(&dout, real_packet->num_reqs);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TECH);
}

static void ensure_valid_variant_packet_ruleset_tech(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_TECH] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_TECH variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_TECH] = variant;
}

struct packet_ruleset_tech *receive_packet_ruleset_tech(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_tech at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_tech(pc);

  switch(pc->phs.variant[PACKET_RULESET_TECH]) {
  case 100:
    return receive_packet_ruleset_tech_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_TECH variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_tech(struct connection *pc, const struct packet_ruleset_tech *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_tech from the client.");
  }
  ensure_valid_variant_packet_ruleset_tech(pc);

  switch(pc->phs.variant[PACKET_RULESET_TECH]) {

  case 100:
    return send_packet_ruleset_tech_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_TECH variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_tech(struct conn_list *dest, const struct packet_ruleset_tech *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_tech(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_tech_flag_100 hash_const

#define cmp_packet_ruleset_tech_flag_100 cmp_const

BV_DEFINE(packet_ruleset_tech_flag_100_fields, 3);

static struct packet_ruleset_tech_flag *receive_packet_ruleset_tech_flag_100(struct connection *pc)
{
  packet_ruleset_tech_flag_100_fields fields;
  struct packet_ruleset_tech_flag *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TECH_FLAG;
  RECEIVE_PACKET_START(packet_ruleset_tech_flag, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_tech_flag_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_flag_100, cmp_packet_ruleset_tech_flag_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!dio_get_uint8(&din, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'helptxt'");
    if (!dio_get_string(&din, real_packet->helptxt, sizeof(real_packet->helptxt))) {
      RECEIVE_PACKET_FIELD_ERROR(helptxt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_tech_flag_100(struct connection *pc, const struct packet_ruleset_tech_flag *packet)
{
  const struct packet_ruleset_tech_flag *real_packet = packet;
  packet_ruleset_tech_flag_100_fields fields;
  struct packet_ruleset_tech_flag *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TECH_FLAG;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TECH_FLAG);

  log_packet_detailed("packet_ruleset_tech_flag_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_tech_flag_100, cmp_packet_ruleset_tech_flag_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->helptxt, real_packet->helptxt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'helptxt' has changed");
    dio_put_string(&dout, real_packet->helptxt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TECH_FLAG);
}

static void ensure_valid_variant_packet_ruleset_tech_flag(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_TECH_FLAG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_TECH_FLAG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_TECH_FLAG] = variant;
}

struct packet_ruleset_tech_flag *receive_packet_ruleset_tech_flag(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_tech_flag at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_tech_flag(pc);

  switch(pc->phs.variant[PACKET_RULESET_TECH_FLAG]) {
  case 100:
    return receive_packet_ruleset_tech_flag_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_TECH_FLAG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_tech_flag(struct connection *pc, const struct packet_ruleset_tech_flag *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_tech_flag from the client.");
  }
  ensure_valid_variant_packet_ruleset_tech_flag(pc);

  switch(pc->phs.variant[PACKET_RULESET_TECH_FLAG]) {

  case 100:
    return send_packet_ruleset_tech_flag_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_TECH_FLAG variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_tech_flag(struct conn_list *dest, const struct packet_ruleset_tech_flag *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_tech_flag(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_government_100 hash_const

#define cmp_packet_ruleset_government_100 cmp_const

BV_DEFINE(packet_ruleset_government_100_fields, 8);

static struct packet_ruleset_government *receive_packet_ruleset_government_100(struct connection *pc)
{
  packet_ruleset_government_100_fields fields;
  struct packet_ruleset_government *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_GOVERNMENT;
  RECEIVE_PACKET_START(packet_ruleset_government, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_government_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_100, cmp_packet_ruleset_government_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!dio_get_uint8(&din, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!dio_get_uint8(&din, &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!dio_get_requirement(&din, &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'helptext'");
    if (!dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_government_100(struct connection *pc, const struct packet_ruleset_government *packet)
{
  const struct packet_ruleset_government *real_packet = packet;
  packet_ruleset_government_100_fields fields;
  struct packet_ruleset_government *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_GOVERNMENT;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_GOVERNMENT);

  log_packet_detailed("packet_ruleset_government_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_government_100, cmp_packet_ruleset_government_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_GOVERNMENT);
}

static void ensure_valid_variant_packet_ruleset_government(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_GOVERNMENT] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_GOVERNMENT variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_GOVERNMENT] = variant;
}

struct packet_ruleset_government *receive_packet_ruleset_government(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_government at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_government(pc);

  switch(pc->phs.variant[PACKET_RULESET_GOVERNMENT]) {
  case 100:
    return receive_packet_ruleset_government_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_GOVERNMENT variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_government(struct connection *pc, const struct packet_ruleset_government *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_government from the client.");
  }
  ensure_valid_variant_packet_ruleset_government(pc);

  switch(pc->phs.variant[PACKET_RULESET_GOVERNMENT]) {

  case 100:
    return send_packet_ruleset_government_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_GOVERNMENT variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_government(struct conn_list *dest, const struct packet_ruleset_government *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_government(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_terrain_control_100 hash_const

#define cmp_packet_ruleset_terrain_control_100 cmp_const

BV_DEFINE(packet_ruleset_terrain_control_100_fields, 8);

static struct packet_ruleset_terrain_control *receive_packet_ruleset_terrain_control_100(struct connection *pc)
{
  packet_ruleset_terrain_control_100_fields fields;
  struct packet_ruleset_terrain_control *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TERRAIN_CONTROL;
  RECEIVE_PACKET_START(packet_ruleset_terrain_control, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_terrain_control_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_control_100, cmp_packet_ruleset_terrain_control_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ocean_reclaim_requirement_pct'");
    if (!dio_get_uint8(&din, &real_packet->ocean_reclaim_requirement_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(ocean_reclaim_requirement_pct);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'land_channel_requirement_pct'");
    if (!dio_get_uint8(&din, &real_packet->land_channel_requirement_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(land_channel_requirement_pct);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'lake_max_size'");
    if (!dio_get_uint8(&din, &real_packet->lake_max_size)) {
      RECEIVE_PACKET_FIELD_ERROR(lake_max_size);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'min_start_native_area'");
    if (!dio_get_uint8(&din, &real_packet->min_start_native_area)) {
      RECEIVE_PACKET_FIELD_ERROR(min_start_native_area);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'move_fragments'");
    if (!dio_get_uint8(&din, &real_packet->move_fragments)) {
      RECEIVE_PACKET_FIELD_ERROR(move_fragments);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'igter_cost'");
    if (!dio_get_uint8(&din, &real_packet->igter_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(igter_cost);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'pollution_tile_penalty'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->pollution_tile_penalty[i])) {
          RECEIVE_PACKET_FIELD_ERROR(pollution_tile_penalty);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'fallout_tile_penalty'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->fallout_tile_penalty[i])) {
          RECEIVE_PACKET_FIELD_ERROR(fallout_tile_penalty);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_terrain_control_100(struct connection *pc, const struct packet_ruleset_terrain_control *packet)
{
  const struct packet_ruleset_terrain_control *real_packet = packet;
  packet_ruleset_terrain_control_100_fields fields;
  struct packet_ruleset_terrain_control *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TERRAIN_CONTROL;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TERRAIN_CONTROL);

  log_packet_detailed("packet_ruleset_terrain_control_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_control_100, cmp_packet_ruleset_terrain_control_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ocean_reclaim_requirement_pct != real_packet->ocean_reclaim_requirement_pct);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->land_channel_requirement_pct != real_packet->land_channel_requirement_pct);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->lake_max_size != real_packet->lake_max_size);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->min_start_native_area != real_packet->min_start_native_area);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->move_fragments != real_packet->move_fragments);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->igter_cost != real_packet->igter_cost);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->pollution_tile_penalty[i] != real_packet->pollution_tile_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->fallout_tile_penalty[i] != real_packet->fallout_tile_penalty[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ocean_reclaim_requirement_pct' has changed");
    dio_put_uint8(&dout, real_packet->ocean_reclaim_requirement_pct);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'land_channel_requirement_pct' has changed");
    dio_put_uint8(&dout, real_packet->land_channel_requirement_pct);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'lake_max_size' has changed");
    dio_put_uint8(&dout, real_packet->lake_max_size);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'min_start_native_area' has changed");
    dio_put_uint8(&dout, real_packet->min_start_native_area);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'move_fragments' has changed");
    dio_put_uint8(&dout, real_packet->move_fragments);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'igter_cost' has changed");
    dio_put_uint8(&dout, real_packet->igter_cost);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'pollution_tile_penalty' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->pollution_tile_penalty[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'fallout_tile_penalty' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->fallout_tile_penalty[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TERRAIN_CONTROL);
}

static void ensure_valid_variant_packet_ruleset_terrain_control(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_TERRAIN_CONTROL] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_TERRAIN_CONTROL variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_TERRAIN_CONTROL] = variant;
}

struct packet_ruleset_terrain_control *receive_packet_ruleset_terrain_control(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_terrain_control at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_terrain_control(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN_CONTROL]) {
  case 100:
    return receive_packet_ruleset_terrain_control_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN_CONTROL variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_terrain_control(struct connection *pc, const struct packet_ruleset_terrain_control *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_terrain_control from the client.");
  }
  ensure_valid_variant_packet_ruleset_terrain_control(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN_CONTROL]) {

  case 100:
    return send_packet_ruleset_terrain_control_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN_CONTROL variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_terrain_control(struct conn_list *dest, const struct packet_ruleset_terrain_control *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_terrain_control(pconn, packet);
  } conn_list_iterate_end;
}

static struct packet_rulesets_ready *receive_packet_rulesets_ready_100(struct connection *pc)
{
  RECEIVE_PACKET_START(packet_rulesets_ready, real_packet);
  real_packet->__dummy = 0xff;
  log_packet_detailed("packet_rulesets_ready_100: got info about ()");
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_rulesets_ready_100(struct connection *pc)
{
  SEND_PACKET_START(PACKET_RULESETS_READY);

  log_packet_detailed("packet_rulesets_ready_100: sending info about ()");
  SEND_PACKET_END(PACKET_RULESETS_READY);
}

static void ensure_valid_variant_packet_rulesets_ready(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESETS_READY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESETS_READY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESETS_READY] = variant;
}

struct packet_rulesets_ready *receive_packet_rulesets_ready(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_rulesets_ready at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_rulesets_ready(pc);

  switch(pc->phs.variant[PACKET_RULESETS_READY]) {
  case 100:
    return receive_packet_rulesets_ready_100(pc);
  default:
    log_debug("Unknown PACKET_RULESETS_READY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_rulesets_ready(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_rulesets_ready from the client.");
  }
  ensure_valid_variant_packet_rulesets_ready(pc);

  switch(pc->phs.variant[PACKET_RULESETS_READY]) {

  case 100:
    return send_packet_rulesets_ready_100(pc);
  default:
    log_debug("Unknown PACKET_RULESETS_READY variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_rulesets_ready(struct conn_list *dest)
{
  conn_list_iterate(dest, pconn) {
    send_packet_rulesets_ready(pconn);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_nation_sets_100 hash_const

#define cmp_packet_ruleset_nation_sets_100 cmp_const

BV_DEFINE(packet_ruleset_nation_sets_100_fields, 4);

static struct packet_ruleset_nation_sets *receive_packet_ruleset_nation_sets_100(struct connection *pc)
{
  packet_ruleset_nation_sets_100_fields fields;
  struct packet_ruleset_nation_sets *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_NATION_SETS;
  RECEIVE_PACKET_START(packet_ruleset_nation_sets, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_nation_sets_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_sets_100, cmp_packet_ruleset_nation_sets_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'nsets'");
    if (!dio_get_uint8(&din, &real_packet->nsets)) {
      RECEIVE_PACKET_FIELD_ERROR(nsets);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'names'");
    
    {
      int i;
    
      if (real_packet->nsets > MAX_NUM_NATION_SETS) {
        RECEIVE_PACKET_FIELD_ERROR(names, ": truncation array");
      }
      for (i = 0; i < real_packet->nsets; i++) {
        if (!dio_get_string(&din, real_packet->names[i], sizeof(real_packet->names[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(names);
        }
      }
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_names'");
    
    {
      int i;
    
      if (real_packet->nsets > MAX_NUM_NATION_SETS) {
        RECEIVE_PACKET_FIELD_ERROR(rule_names, ": truncation array");
      }
      for (i = 0; i < real_packet->nsets; i++) {
        if (!dio_get_string(&din, real_packet->rule_names[i], sizeof(real_packet->rule_names[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(rule_names);
        }
      }
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'descriptions'");
    
    {
      int i;
    
      if (real_packet->nsets > MAX_NUM_NATION_SETS) {
        RECEIVE_PACKET_FIELD_ERROR(descriptions, ": truncation array");
      }
      for (i = 0; i < real_packet->nsets; i++) {
        if (!dio_get_string(&din, real_packet->descriptions[i], sizeof(real_packet->descriptions[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(descriptions);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_nation_sets_100(struct connection *pc, const struct packet_ruleset_nation_sets *packet)
{
  const struct packet_ruleset_nation_sets *real_packet = packet;
  packet_ruleset_nation_sets_100_fields fields;
  struct packet_ruleset_nation_sets *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_NATION_SETS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_NATION_SETS);

  log_packet_detailed("packet_ruleset_nation_sets_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_sets_100, cmp_packet_ruleset_nation_sets_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->nsets != real_packet->nsets);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->nsets != real_packet->nsets);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nsets; i++) {
          if (strcmp(old->names[i], real_packet->names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


    {
      differ = (old->nsets != real_packet->nsets);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nsets; i++) {
          if (strcmp(old->rule_names[i], real_packet->rule_names[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


    {
      differ = (old->nsets != real_packet->nsets);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nsets; i++) {
          if (strcmp(old->descriptions[i], real_packet->descriptions[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'nsets' has changed");
    dio_put_uint8(&dout, real_packet->nsets);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nsets; i++) {
        dio_put_string(&dout, real_packet->names[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_names' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nsets; i++) {
        dio_put_string(&dout, real_packet->rule_names[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'descriptions' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nsets; i++) {
        dio_put_string(&dout, real_packet->descriptions[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_NATION_SETS);
}

static void ensure_valid_variant_packet_ruleset_nation_sets(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_NATION_SETS] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_NATION_SETS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_NATION_SETS] = variant;
}

struct packet_ruleset_nation_sets *receive_packet_ruleset_nation_sets(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_nation_sets at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_nation_sets(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION_SETS]) {
  case 100:
    return receive_packet_ruleset_nation_sets_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_NATION_SETS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_nation_sets(struct connection *pc, const struct packet_ruleset_nation_sets *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_nation_sets from the client.");
  }
  ensure_valid_variant_packet_ruleset_nation_sets(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION_SETS]) {

  case 100:
    return send_packet_ruleset_nation_sets_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_NATION_SETS variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_nation_sets(struct conn_list *dest, const struct packet_ruleset_nation_sets *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_nation_sets(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_nation_groups_100 hash_const

#define cmp_packet_ruleset_nation_groups_100 cmp_const

BV_DEFINE(packet_ruleset_nation_groups_100_fields, 2);

static struct packet_ruleset_nation_groups *receive_packet_ruleset_nation_groups_100(struct connection *pc)
{
  packet_ruleset_nation_groups_100_fields fields;
  struct packet_ruleset_nation_groups *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_NATION_GROUPS;
  RECEIVE_PACKET_START(packet_ruleset_nation_groups, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_nation_groups_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_groups_100, cmp_packet_ruleset_nation_groups_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ngroups'");
    if (!dio_get_uint8(&din, &real_packet->ngroups)) {
      RECEIVE_PACKET_FIELD_ERROR(ngroups);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'groups'");
    
    {
      int i;
    
      if (real_packet->ngroups > MAX_NUM_NATION_GROUPS) {
        RECEIVE_PACKET_FIELD_ERROR(groups, ": truncation array");
      }
      for (i = 0; i < real_packet->ngroups; i++) {
        if (!dio_get_string(&din, real_packet->groups[i], sizeof(real_packet->groups[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(groups);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_nation_groups_100(struct connection *pc, const struct packet_ruleset_nation_groups *packet)
{
  const struct packet_ruleset_nation_groups *real_packet = packet;
  packet_ruleset_nation_groups_100_fields fields;
  struct packet_ruleset_nation_groups *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_NATION_GROUPS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_NATION_GROUPS);

  log_packet_detailed("packet_ruleset_nation_groups_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_groups_100, cmp_packet_ruleset_nation_groups_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ngroups != real_packet->ngroups);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->ngroups != real_packet->ngroups);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ngroups; i++) {
          if (strcmp(old->groups[i], real_packet->groups[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ngroups' has changed");
    dio_put_uint8(&dout, real_packet->ngroups);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'groups' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ngroups; i++) {
        dio_put_string(&dout, real_packet->groups[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_NATION_GROUPS);
}

static void ensure_valid_variant_packet_ruleset_nation_groups(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_NATION_GROUPS] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_NATION_GROUPS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_NATION_GROUPS] = variant;
}

struct packet_ruleset_nation_groups *receive_packet_ruleset_nation_groups(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_nation_groups at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_nation_groups(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION_GROUPS]) {
  case 100:
    return receive_packet_ruleset_nation_groups_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_NATION_GROUPS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_nation_groups(struct connection *pc, const struct packet_ruleset_nation_groups *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_nation_groups from the client.");
  }
  ensure_valid_variant_packet_ruleset_nation_groups(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION_GROUPS]) {

  case 100:
    return send_packet_ruleset_nation_groups_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_NATION_GROUPS variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_nation_groups(struct conn_list *dest, const struct packet_ruleset_nation_groups *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_nation_groups(pconn, packet);
  } conn_list_iterate_end;
}

static genhash_val_t hash_packet_ruleset_nation_100(const void *vkey)
{
  const struct packet_ruleset_nation *key = (const struct packet_ruleset_nation *) vkey;

  return key->id;
}

static bool cmp_packet_ruleset_nation_100(const void *vkey1, const void *vkey2)
{
  const struct packet_ruleset_nation *key1 = (const struct packet_ruleset_nation *) vkey1;
  const struct packet_ruleset_nation *key2 = (const struct packet_ruleset_nation *) vkey2;

  return key1->id == key2->id;
}

BV_DEFINE(packet_ruleset_nation_100_fields, 21);

static struct packet_ruleset_nation *receive_packet_ruleset_nation_100(struct connection *pc)
{
  packet_ruleset_nation_100_fields fields;
  struct packet_ruleset_nation *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_NATION;
  RECEIVE_PACKET_START(packet_ruleset_nation, real_packet);

  DIO_BV_GET(&din, fields);
  {
    int readin;
    
    if (!dio_get_sint16(&din, &readin)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
    real_packet->id = readin;
  }

  log_packet_detailed("packet_ruleset_nation_100: got info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_100, cmp_packet_ruleset_nation_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    Nation_type_id id = real_packet->id;

    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));

    real_packet->id = id;
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'translation_domain'");
    if (!dio_get_string(&din, real_packet->translation_domain, sizeof(real_packet->translation_domain))) {
      RECEIVE_PACKET_FIELD_ERROR(translation_domain);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'adjective'");
    if (!dio_get_string(&din, real_packet->adjective, sizeof(real_packet->adjective))) {
      RECEIVE_PACKET_FIELD_ERROR(adjective);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'noun_plural'");
    if (!dio_get_string(&din, real_packet->noun_plural, sizeof(real_packet->noun_plural))) {
      RECEIVE_PACKET_FIELD_ERROR(noun_plural);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'legend'");
    if (!dio_get_string(&din, real_packet->legend, sizeof(real_packet->legend))) {
      RECEIVE_PACKET_FIELD_ERROR(legend);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'city_style'");
    if (!dio_get_uint8(&din, &real_packet->city_style)) {
      RECEIVE_PACKET_FIELD_ERROR(city_style);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'leader_count'");
    if (!dio_get_uint8(&din, &real_packet->leader_count)) {
      RECEIVE_PACKET_FIELD_ERROR(leader_count);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'leader_name'");
    
    {
      int i;
    
      if (real_packet->leader_count > MAX_NUM_LEADERS) {
        RECEIVE_PACKET_FIELD_ERROR(leader_name, ": truncation array");
      }
      for (i = 0; i < real_packet->leader_count; i++) {
        if (!dio_get_string(&din, real_packet->leader_name[i], sizeof(real_packet->leader_name[i]))) {
          RECEIVE_PACKET_FIELD_ERROR(leader_name);
        }
      }
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'leader_is_male'");
    
    {
      int i;
    
      if (real_packet->leader_count > MAX_NUM_LEADERS) {
        RECEIVE_PACKET_FIELD_ERROR(leader_is_male, ": truncation array");
      }
      for (i = 0; i < real_packet->leader_count; i++) {
        if (!dio_get_bool8(&din, &real_packet->leader_is_male[i])) {
          RECEIVE_PACKET_FIELD_ERROR(leader_is_male);
        }
      }
    }
  }
  real_packet->is_playable = BV_ISSET(fields, 11);
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'barbarian_type'");
    if (!dio_get_uint8(&din, &real_packet->barbarian_type)) {
      RECEIVE_PACKET_FIELD_ERROR(barbarian_type);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'nsets'");
    if (!dio_get_uint8(&din, &real_packet->nsets)) {
      RECEIVE_PACKET_FIELD_ERROR(nsets);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'sets'");
    
    {
      int i;
    
      if (real_packet->nsets > MAX_NUM_NATION_SETS) {
        RECEIVE_PACKET_FIELD_ERROR(sets, ": truncation array");
      }
      for (i = 0; i < real_packet->nsets; i++) {
        if (!dio_get_uint8(&din, &real_packet->sets[i])) {
          RECEIVE_PACKET_FIELD_ERROR(sets);
        }
      }
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'ngroups'");
    if (!dio_get_uint8(&din, &real_packet->ngroups)) {
      RECEIVE_PACKET_FIELD_ERROR(ngroups);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'groups'");
    
    {
      int i;
    
      if (real_packet->ngroups > MAX_NUM_NATION_GROUPS) {
        RECEIVE_PACKET_FIELD_ERROR(groups, ": truncation array");
      }
      for (i = 0; i < real_packet->ngroups; i++) {
        if (!dio_get_uint8(&din, &real_packet->groups[i])) {
          RECEIVE_PACKET_FIELD_ERROR(groups);
        }
      }
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'init_government_id'");
    if (!dio_get_uint8(&din, &real_packet->init_government_id)) {
      RECEIVE_PACKET_FIELD_ERROR(init_government_id);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'init_techs'");
    if (!dio_get_tech_list(&din, real_packet->init_techs)) {
      RECEIVE_PACKET_FIELD_ERROR(init_techs);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'init_units'");
    if (!dio_get_unit_list(&din, real_packet->init_units)) {
      RECEIVE_PACKET_FIELD_ERROR(init_units);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'init_buildings'");
    if (!dio_get_building_list(&din, real_packet->init_buildings)) {
      RECEIVE_PACKET_FIELD_ERROR(init_buildings);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_nation_100(struct connection *pc, const struct packet_ruleset_nation *packet)
{
  const struct packet_ruleset_nation *real_packet = packet;
  packet_ruleset_nation_100_fields fields;
  struct packet_ruleset_nation *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_NATION;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_NATION);

  log_packet_detailed("packet_ruleset_nation_100: sending info about (%d)",
    real_packet->id);

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_nation_100, cmp_packet_ruleset_nation_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (strcmp(old->translation_domain, real_packet->translation_domain) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->adjective, real_packet->adjective) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->noun_plural, real_packet->noun_plural) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->legend, real_packet->legend) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->city_style != real_packet->city_style);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->leader_count != real_packet->leader_count);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }


    {
      differ = (old->leader_count != real_packet->leader_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->leader_count; i++) {
          if (strcmp(old->leader_name[i], real_packet->leader_name[i]) != 0) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


    {
      differ = (old->leader_count != real_packet->leader_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->leader_count; i++) {
          if (old->leader_is_male[i] != real_packet->leader_is_male[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->is_playable != real_packet->is_playable);
  if(differ) {
    different++;
  }
  if (packet->is_playable) {
    BV_SET(fields, 11);
  }

  differ = (old->barbarian_type != real_packet->barbarian_type);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->nsets != real_packet->nsets);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }


    {
      differ = (old->nsets != real_packet->nsets);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->nsets; i++) {
          if (old->sets[i] != real_packet->sets[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->ngroups != real_packet->ngroups);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }


    {
      differ = (old->ngroups != real_packet->ngroups);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ngroups; i++) {
          if (old->groups[i] != real_packet->groups[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->init_government_id != real_packet->init_government_id);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }


    {
      differ = (MAX_NUM_TECH_LIST != MAX_NUM_TECH_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_TECH_LIST; i++) {
          if (old->init_techs[i] != real_packet->init_techs[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }


    {
      differ = (MAX_NUM_UNIT_LIST != MAX_NUM_UNIT_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_UNIT_LIST; i++) {
          if (old->init_units[i] != real_packet->init_units[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }


    {
      differ = (MAX_NUM_BUILDING_LIST != MAX_NUM_BUILDING_LIST);
      if(!differ) {
        int i;
        for (i = 0; i < MAX_NUM_BUILDING_LIST; i++) {
          if (old->init_buildings[i] != real_packet->init_buildings[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }


  DIO_BV_PUT(&dout, fields);
  dio_put_sint16(&dout, real_packet->id);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'translation_domain' has changed");
    dio_put_string(&dout, real_packet->translation_domain);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'adjective' has changed");
    dio_put_string(&dout, real_packet->adjective);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'noun_plural' has changed");
    dio_put_string(&dout, real_packet->noun_plural);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'legend' has changed");
    dio_put_string(&dout, real_packet->legend);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'city_style' has changed");
    dio_put_uint8(&dout, real_packet->city_style);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'leader_count' has changed");
    dio_put_uint8(&dout, real_packet->leader_count);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'leader_name' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->leader_count; i++) {
        dio_put_string(&dout, real_packet->leader_name[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'leader_is_male' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->leader_count; i++) {
        dio_put_bool8(&dout, real_packet->leader_is_male[i]);
      }
    } 
  }
  /* field 11 is folded into the header */
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'barbarian_type' has changed");
    dio_put_uint8(&dout, real_packet->barbarian_type);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'nsets' has changed");
    dio_put_uint8(&dout, real_packet->nsets);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'sets' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->nsets; i++) {
        dio_put_uint8(&dout, real_packet->sets[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'ngroups' has changed");
    dio_put_uint8(&dout, real_packet->ngroups);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'groups' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ngroups; i++) {
        dio_put_uint8(&dout, real_packet->groups[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'init_government_id' has changed");
    dio_put_uint8(&dout, real_packet->init_government_id);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'init_techs' has changed");
    dio_put_tech_list(&dout, real_packet->init_techs);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'init_units' has changed");
    dio_put_unit_list(&dout, real_packet->init_units);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'init_buildings' has changed");
    dio_put_building_list(&dout, real_packet->init_buildings);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_NATION);
}

static void ensure_valid_variant_packet_ruleset_nation(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_NATION] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_NATION variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_NATION] = variant;
}

struct packet_ruleset_nation *receive_packet_ruleset_nation(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_nation at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_nation(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION]) {
  case 100:
    return receive_packet_ruleset_nation_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_NATION variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_nation(struct connection *pc, const struct packet_ruleset_nation *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_nation from the client.");
  }
  ensure_valid_variant_packet_ruleset_nation(pc);

  switch(pc->phs.variant[PACKET_RULESET_NATION]) {

  case 100:
    return send_packet_ruleset_nation_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_NATION variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_nation(struct conn_list *dest, const struct packet_ruleset_nation *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_nation(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_nation_availability_100 hash_const

#define cmp_packet_nation_availability_100 cmp_const

BV_DEFINE(packet_nation_availability_100_fields, 3);

static struct packet_nation_availability *receive_packet_nation_availability_100(struct connection *pc)
{
  packet_nation_availability_100_fields fields;
  struct packet_nation_availability *old;
  struct genhash **hash = pc->phs.received + PACKET_NATION_AVAILABILITY;
  RECEIVE_PACKET_START(packet_nation_availability, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_nation_availability_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_availability_100, cmp_packet_nation_availability_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ncount'");
    if (!dio_get_uint16(&din, &real_packet->ncount)) {
      RECEIVE_PACKET_FIELD_ERROR(ncount);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'is_pickable'");
    
    {
      int i;
    
      if (real_packet->ncount > MAX_NUM_NATIONS) {
        RECEIVE_PACKET_FIELD_ERROR(is_pickable, ": truncation array");
      }
      for (i = 0; i < real_packet->ncount; i++) {
        if (!dio_get_bool8(&din, &real_packet->is_pickable[i])) {
          RECEIVE_PACKET_FIELD_ERROR(is_pickable);
        }
      }
    }
  }
  real_packet->nationset_change = BV_ISSET(fields, 2);

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nation_availability_100(struct connection *pc, const struct packet_nation_availability *packet)
{
  const struct packet_nation_availability *real_packet = packet;
  packet_nation_availability_100_fields fields;
  struct packet_nation_availability *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NATION_AVAILABILITY;
  int different = 0;
  SEND_PACKET_START(PACKET_NATION_AVAILABILITY);

  log_packet_detailed("packet_nation_availability_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_availability_100, cmp_packet_nation_availability_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ncount != real_packet->ncount);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->ncount != real_packet->ncount);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ncount; i++) {
          if (old->is_pickable[i] != real_packet->is_pickable[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (old->nationset_change != real_packet->nationset_change);
  if(differ) {
    different++;
  }
  if (packet->nationset_change) {
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ncount' has changed");
    dio_put_uint16(&dout, real_packet->ncount);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'is_pickable' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ncount; i++) {
        dio_put_bool8(&dout, real_packet->is_pickable[i]);
      }
    } 
  }
  /* field 2 is folded into the header */

  *old = *real_packet;
  SEND_PACKET_END(PACKET_NATION_AVAILABILITY);
}

#define hash_packet_nation_availability_101 hash_const

#define cmp_packet_nation_availability_101 cmp_const

BV_DEFINE(packet_nation_availability_101_fields, 2);

static struct packet_nation_availability *receive_packet_nation_availability_101(struct connection *pc)
{
  packet_nation_availability_101_fields fields;
  struct packet_nation_availability *old;
  struct genhash **hash = pc->phs.received + PACKET_NATION_AVAILABILITY;
  RECEIVE_PACKET_START(packet_nation_availability, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_nation_availability_101: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_availability_101, cmp_packet_nation_availability_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'ncount'");
    if (!dio_get_uint16(&din, &real_packet->ncount)) {
      RECEIVE_PACKET_FIELD_ERROR(ncount);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'is_pickable'");
    
    {
      int i;
    
      if (real_packet->ncount > MAX_NUM_NATIONS) {
        RECEIVE_PACKET_FIELD_ERROR(is_pickable, ": truncation array");
      }
      for (i = 0; i < real_packet->ncount; i++) {
        if (!dio_get_bool8(&din, &real_packet->is_pickable[i])) {
          RECEIVE_PACKET_FIELD_ERROR(is_pickable);
        }
      }
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_nation_availability_101(struct connection *pc, const struct packet_nation_availability *packet)
{
  const struct packet_nation_availability *real_packet = packet;
  packet_nation_availability_101_fields fields;
  struct packet_nation_availability *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_NATION_AVAILABILITY;
  int different = 0;
  SEND_PACKET_START(PACKET_NATION_AVAILABILITY);

  log_packet_detailed("packet_nation_availability_101: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_nation_availability_101, cmp_packet_nation_availability_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->ncount != real_packet->ncount);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }


    {
      differ = (old->ncount != real_packet->ncount);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->ncount; i++) {
          if (old->is_pickable[i] != real_packet->is_pickable[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'ncount' has changed");
    dio_put_uint16(&dout, real_packet->ncount);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'is_pickable' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->ncount; i++) {
        dio_put_bool8(&dout, real_packet->is_pickable[i]);
      }
    } 
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_NATION_AVAILABILITY);
}

static void ensure_valid_variant_packet_nation_availability(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_NATION_AVAILABILITY] != -1) {
    return;
  }

  if(FALSE) {
  } else if((has_capability("nationset_change", pc->capability) && has_capability("nationset_change", our_capability))) {
    variant = 100;
  } else if(!(has_capability("nationset_change", pc->capability) && has_capability("nationset_change", our_capability))) {
    variant = 101;
  } else {
    log_error("Unknown PACKET_NATION_AVAILABILITY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  log_packet_detailed("packet_nation_availability: using variant=%d cap=%s", variant, pc->capability);
  pc->phs.variant[PACKET_NATION_AVAILABILITY] = variant;
}

struct packet_nation_availability *receive_packet_nation_availability(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_nation_availability at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_nation_availability(pc);

  switch(pc->phs.variant[PACKET_NATION_AVAILABILITY]) {
  case 100:
    return receive_packet_nation_availability_100(pc);
  case 101:
    return receive_packet_nation_availability_101(pc);
  default:
    log_debug("Unknown PACKET_NATION_AVAILABILITY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_nation_availability(struct connection *pc, const struct packet_nation_availability *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_nation_availability from the client.");
  }
  ensure_valid_variant_packet_nation_availability(pc);

  switch(pc->phs.variant[PACKET_NATION_AVAILABILITY]) {

  case 100:
    return send_packet_nation_availability_100(pc, packet);
  case 101:
    return send_packet_nation_availability_101(pc, packet);
  default:
    log_debug("Unknown PACKET_NATION_AVAILABILITY variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_nation_availability(struct conn_list *dest, const struct packet_nation_availability *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_nation_availability(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_city_100 hash_const

#define cmp_packet_ruleset_city_100 cmp_const

BV_DEFINE(packet_ruleset_city_100_fields, 12);

static struct packet_ruleset_city *receive_packet_ruleset_city_100(struct connection *pc)
{
  packet_ruleset_city_100_fields fields;
  struct packet_ruleset_city *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_CITY;
  RECEIVE_PACKET_START(packet_ruleset_city, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_city_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_city_100, cmp_packet_ruleset_city_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'style_id'");
    if (!dio_get_uint8(&din, &real_packet->style_id)) {
      RECEIVE_PACKET_FIELD_ERROR(style_id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'citizens_graphic'");
    if (!dio_get_string(&din, real_packet->citizens_graphic, sizeof(real_packet->citizens_graphic))) {
      RECEIVE_PACKET_FIELD_ERROR(citizens_graphic);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'citizens_graphic_alt'");
    if (!dio_get_string(&din, real_packet->citizens_graphic_alt, sizeof(real_packet->citizens_graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(citizens_graphic_alt);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!dio_get_uint8(&din, &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!dio_get_requirement(&din, &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'graphic'");
    if (!dio_get_string(&din, real_packet->graphic, sizeof(real_packet->graphic))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'oceanic_graphic'");
    if (!dio_get_string(&din, real_packet->oceanic_graphic, sizeof(real_packet->oceanic_graphic))) {
      RECEIVE_PACKET_FIELD_ERROR(oceanic_graphic);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'oceanic_graphic_alt'");
    if (!dio_get_string(&din, real_packet->oceanic_graphic_alt, sizeof(real_packet->oceanic_graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(oceanic_graphic_alt);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'replaced_by'");
    if (!dio_get_sint8(&din, &real_packet->replaced_by)) {
      RECEIVE_PACKET_FIELD_ERROR(replaced_by);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_city_100(struct connection *pc, const struct packet_ruleset_city *packet)
{
  const struct packet_ruleset_city *real_packet = packet;
  packet_ruleset_city_100_fields fields;
  struct packet_ruleset_city *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_CITY;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_CITY);

  log_packet_detailed("packet_ruleset_city_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_city_100, cmp_packet_ruleset_city_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->style_id != real_packet->style_id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->citizens_graphic, real_packet->citizens_graphic) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->citizens_graphic_alt, real_packet->citizens_graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->graphic, real_packet->graphic) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (strcmp(old->oceanic_graphic, real_packet->oceanic_graphic) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (strcmp(old->oceanic_graphic_alt, real_packet->oceanic_graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->replaced_by != real_packet->replaced_by);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'style_id' has changed");
    dio_put_uint8(&dout, real_packet->style_id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'citizens_graphic' has changed");
    dio_put_string(&dout, real_packet->citizens_graphic);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'citizens_graphic_alt' has changed");
    dio_put_string(&dout, real_packet->citizens_graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'graphic' has changed");
    dio_put_string(&dout, real_packet->graphic);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'oceanic_graphic' has changed");
    dio_put_string(&dout, real_packet->oceanic_graphic);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'oceanic_graphic_alt' has changed");
    dio_put_string(&dout, real_packet->oceanic_graphic_alt);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'replaced_by' has changed");
    dio_put_sint8(&dout, real_packet->replaced_by);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_CITY);
}

static void ensure_valid_variant_packet_ruleset_city(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_CITY] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_CITY variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_CITY] = variant;
}

struct packet_ruleset_city *receive_packet_ruleset_city(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_city at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_city(pc);

  switch(pc->phs.variant[PACKET_RULESET_CITY]) {
  case 100:
    return receive_packet_ruleset_city_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_CITY variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_city(struct connection *pc, const struct packet_ruleset_city *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_city from the client.");
  }
  ensure_valid_variant_packet_ruleset_city(pc);

  switch(pc->phs.variant[PACKET_RULESET_CITY]) {

  case 100:
    return send_packet_ruleset_city_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_CITY variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_city(struct conn_list *dest, const struct packet_ruleset_city *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_city(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_building_100 hash_const

#define cmp_packet_ruleset_building_100 cmp_const

BV_DEFINE(packet_ruleset_building_100_fields, 17);

static struct packet_ruleset_building *receive_packet_ruleset_building_100(struct connection *pc)
{
  packet_ruleset_building_100_fields fields;
  struct packet_ruleset_building *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_BUILDING;
  RECEIVE_PACKET_START(packet_ruleset_building, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_building_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_building_100, cmp_packet_ruleset_building_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'genus'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(genus);
      }
      real_packet->genus = readin;
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!dio_get_uint8(&din, &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!dio_get_requirement(&din, &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'obsolete_by'");
    if (!dio_get_uint8(&din, &real_packet->obsolete_by)) {
      RECEIVE_PACKET_FIELD_ERROR(obsolete_by);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'replaced_by'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(replaced_by);
      }
      real_packet->replaced_by = readin;
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'build_cost'");
    if (!dio_get_uint16(&din, &real_packet->build_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(build_cost);
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'upkeep'");
    if (!dio_get_uint8(&din, &real_packet->upkeep)) {
      RECEIVE_PACKET_FIELD_ERROR(upkeep);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'sabotage'");
    if (!dio_get_uint8(&din, &real_packet->sabotage)) {
      RECEIVE_PACKET_FIELD_ERROR(sabotage);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'soundtag'");
    if (!dio_get_string(&din, real_packet->soundtag, sizeof(real_packet->soundtag))) {
      RECEIVE_PACKET_FIELD_ERROR(soundtag);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'soundtag_alt'");
    if (!dio_get_string(&din, real_packet->soundtag_alt, sizeof(real_packet->soundtag_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(soundtag_alt);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'helptext'");
    if (!dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_building_100(struct connection *pc, const struct packet_ruleset_building *packet)
{
  const struct packet_ruleset_building *real_packet = packet;
  packet_ruleset_building_100_fields fields;
  struct packet_ruleset_building *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_BUILDING;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_BUILDING);

  log_packet_detailed("packet_ruleset_building_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_building_100, cmp_packet_ruleset_building_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->genus != real_packet->genus);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->obsolete_by != real_packet->obsolete_by);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->replaced_by != real_packet->replaced_by);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->build_cost != real_packet->build_cost);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->upkeep != real_packet->upkeep);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = (old->sabotage != real_packet->sabotage);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (strcmp(old->soundtag, real_packet->soundtag) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (strcmp(old->soundtag_alt, real_packet->soundtag_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'genus' has changed");
    dio_put_uint8(&dout, real_packet->genus);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'obsolete_by' has changed");
    dio_put_uint8(&dout, real_packet->obsolete_by);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'replaced_by' has changed");
    dio_put_uint8(&dout, real_packet->replaced_by);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'build_cost' has changed");
    dio_put_uint16(&dout, real_packet->build_cost);
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'upkeep' has changed");
    dio_put_uint8(&dout, real_packet->upkeep);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'sabotage' has changed");
    dio_put_uint8(&dout, real_packet->sabotage);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'soundtag' has changed");
    dio_put_string(&dout, real_packet->soundtag);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'soundtag_alt' has changed");
    dio_put_string(&dout, real_packet->soundtag_alt);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_BUILDING);
}

static void ensure_valid_variant_packet_ruleset_building(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_BUILDING] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_BUILDING variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_BUILDING] = variant;
}

struct packet_ruleset_building *receive_packet_ruleset_building(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_building at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_building(pc);

  switch(pc->phs.variant[PACKET_RULESET_BUILDING]) {
  case 100:
    return receive_packet_ruleset_building_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_BUILDING variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_building(struct connection *pc, const struct packet_ruleset_building *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_building from the client.");
  }
  ensure_valid_variant_packet_ruleset_building(pc);

  switch(pc->phs.variant[PACKET_RULESET_BUILDING]) {

  case 100:
    return send_packet_ruleset_building_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_BUILDING variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_building(struct conn_list *dest, const struct packet_ruleset_building *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_building(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_terrain_100 hash_const

#define cmp_packet_ruleset_terrain_100 cmp_const

BV_DEFINE(packet_ruleset_terrain_100_fields, 30);

static struct packet_ruleset_terrain *receive_packet_ruleset_terrain_100(struct connection *pc)
{
  packet_ruleset_terrain_100_fields fields;
  struct packet_ruleset_terrain *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TERRAIN;
  RECEIVE_PACKET_START(packet_ruleset_terrain, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_terrain_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_100, cmp_packet_ruleset_terrain_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(id);
      }
      real_packet->id = readin;
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'tclass'");
    if (!dio_get_uint8(&din, &real_packet->tclass)) {
      RECEIVE_PACKET_FIELD_ERROR(tclass);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'native_to'");
    if (!DIO_BV_GET(&din, real_packet->native_to)) {
      RECEIVE_PACKET_FIELD_ERROR(native_to);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'movement_cost'");
    if (!dio_get_uint8(&din, &real_packet->movement_cost)) {
      RECEIVE_PACKET_FIELD_ERROR(movement_cost);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'defense_bonus'");
    if (!dio_get_sint16(&din, &real_packet->defense_bonus)) {
      RECEIVE_PACKET_FIELD_ERROR(defense_bonus);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'output'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint8(&din, &real_packet->output[i])) {
          RECEIVE_PACKET_FIELD_ERROR(output);
        }
      }
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'num_resources'");
    if (!dio_get_uint8(&din, &real_packet->num_resources)) {
      RECEIVE_PACKET_FIELD_ERROR(num_resources);
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'resources'");
    
    {
      int i;
    
      if (real_packet->num_resources > MAX_NUM_RESOURCES) {
        RECEIVE_PACKET_FIELD_ERROR(resources, ": truncation array");
      }
      for (i = 0; i < real_packet->num_resources; i++) {
        {
          int readin;
      
          if (!dio_get_uint8(&din, &readin)) {
            RECEIVE_PACKET_FIELD_ERROR(resources);
          }
          real_packet->resources[i] = readin;
        }
      }
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'road_output_incr_pct'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint16(&din, &real_packet->road_output_incr_pct[i])) {
          RECEIVE_PACKET_FIELD_ERROR(road_output_incr_pct);
        }
      }
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'base_time'");
    if (!dio_get_uint8(&din, &real_packet->base_time)) {
      RECEIVE_PACKET_FIELD_ERROR(base_time);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'road_time'");
    if (!dio_get_uint8(&din, &real_packet->road_time)) {
      RECEIVE_PACKET_FIELD_ERROR(road_time);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'irrigation_result'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(irrigation_result);
      }
      real_packet->irrigation_result = readin;
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'irrigation_food_incr'");
    if (!dio_get_uint8(&din, &real_packet->irrigation_food_incr)) {
      RECEIVE_PACKET_FIELD_ERROR(irrigation_food_incr);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'irrigation_time'");
    if (!dio_get_uint8(&din, &real_packet->irrigation_time)) {
      RECEIVE_PACKET_FIELD_ERROR(irrigation_time);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'mining_result'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(mining_result);
      }
      real_packet->mining_result = readin;
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'mining_shield_incr'");
    if (!dio_get_uint8(&din, &real_packet->mining_shield_incr)) {
      RECEIVE_PACKET_FIELD_ERROR(mining_shield_incr);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'mining_time'");
    if (!dio_get_uint8(&din, &real_packet->mining_time)) {
      RECEIVE_PACKET_FIELD_ERROR(mining_time);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'transform_result'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(transform_result);
      }
      real_packet->transform_result = readin;
    }
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  got field 'transform_time'");
    if (!dio_get_uint8(&din, &real_packet->transform_time)) {
      RECEIVE_PACKET_FIELD_ERROR(transform_time);
    }
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  got field 'clean_pollution_time'");
    if (!dio_get_uint8(&din, &real_packet->clean_pollution_time)) {
      RECEIVE_PACKET_FIELD_ERROR(clean_pollution_time);
    }
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  got field 'clean_fallout_time'");
    if (!dio_get_uint8(&din, &real_packet->clean_fallout_time)) {
      RECEIVE_PACKET_FIELD_ERROR(clean_fallout_time);
    }
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  got field 'color_red'");
    if (!dio_get_uint8(&din, &real_packet->color_red)) {
      RECEIVE_PACKET_FIELD_ERROR(color_red);
    }
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  got field 'color_green'");
    if (!dio_get_uint8(&din, &real_packet->color_green)) {
      RECEIVE_PACKET_FIELD_ERROR(color_green);
    }
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  got field 'color_blue'");
    if (!dio_get_uint8(&din, &real_packet->color_blue)) {
      RECEIVE_PACKET_FIELD_ERROR(color_blue);
    }
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  got field 'helptext'");
    if (!dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_terrain_100(struct connection *pc, const struct packet_ruleset_terrain *packet)
{
  const struct packet_ruleset_terrain *real_packet = packet;
  packet_ruleset_terrain_100_fields fields;
  struct packet_ruleset_terrain *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TERRAIN;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TERRAIN);

  log_packet_detailed("packet_ruleset_terrain_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_100, cmp_packet_ruleset_terrain_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (old->tclass != real_packet->tclass);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = !BV_ARE_EQUAL(old->native_to, real_packet->native_to);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->movement_cost != real_packet->movement_cost);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->defense_bonus != real_packet->defense_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->output[i] != real_packet->output[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->num_resources != real_packet->num_resources);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }


    {
      differ = (old->num_resources != real_packet->num_resources);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->num_resources; i++) {
          if (old->resources[i] != real_packet->resources[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->road_output_incr_pct[i] != real_packet->road_output_incr_pct[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->base_time != real_packet->base_time);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->road_time != real_packet->road_time);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->irrigation_result != real_packet->irrigation_result);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->irrigation_food_incr != real_packet->irrigation_food_incr);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->irrigation_time != real_packet->irrigation_time);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = (old->mining_result != real_packet->mining_result);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (old->mining_shield_incr != real_packet->mining_shield_incr);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = (old->mining_time != real_packet->mining_time);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (old->transform_result != real_packet->transform_result);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }

  differ = (old->transform_time != real_packet->transform_time);
  if (differ) {
    different++;
    BV_SET(fields, 23);
  }

  differ = (old->clean_pollution_time != real_packet->clean_pollution_time);
  if (differ) {
    different++;
    BV_SET(fields, 24);
  }

  differ = (old->clean_fallout_time != real_packet->clean_fallout_time);
  if (differ) {
    different++;
    BV_SET(fields, 25);
  }

  differ = (old->color_red != real_packet->color_red);
  if (differ) {
    different++;
    BV_SET(fields, 26);
  }

  differ = (old->color_green != real_packet->color_green);
  if (differ) {
    different++;
    BV_SET(fields, 27);
  }

  differ = (old->color_blue != real_packet->color_blue);
  if (differ) {
    different++;
    BV_SET(fields, 28);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 29);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'tclass' has changed");
    dio_put_uint8(&dout, real_packet->tclass);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'native_to' has changed");
  DIO_BV_PUT(&dout, packet->native_to);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'movement_cost' has changed");
    dio_put_uint8(&dout, real_packet->movement_cost);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'defense_bonus' has changed");
    dio_put_sint16(&dout, real_packet->defense_bonus);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'output' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint8(&dout, real_packet->output[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'num_resources' has changed");
    dio_put_uint8(&dout, real_packet->num_resources);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'resources' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->num_resources; i++) {
        dio_put_uint8(&dout, real_packet->resources[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'road_output_incr_pct' has changed");
  
    {
      int i;

      for (i = 0; i < O_LAST; i++) {
        dio_put_uint16(&dout, real_packet->road_output_incr_pct[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'base_time' has changed");
    dio_put_uint8(&dout, real_packet->base_time);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'road_time' has changed");
    dio_put_uint8(&dout, real_packet->road_time);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'irrigation_result' has changed");
    dio_put_uint8(&dout, real_packet->irrigation_result);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'irrigation_food_incr' has changed");
    dio_put_uint8(&dout, real_packet->irrigation_food_incr);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'irrigation_time' has changed");
    dio_put_uint8(&dout, real_packet->irrigation_time);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'mining_result' has changed");
    dio_put_uint8(&dout, real_packet->mining_result);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'mining_shield_incr' has changed");
    dio_put_uint8(&dout, real_packet->mining_shield_incr);
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  field 'mining_time' has changed");
    dio_put_uint8(&dout, real_packet->mining_time);
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  field 'transform_result' has changed");
    dio_put_uint8(&dout, real_packet->transform_result);
  }
  if (BV_ISSET(fields, 23)) {
    log_packet_detailed("  field 'transform_time' has changed");
    dio_put_uint8(&dout, real_packet->transform_time);
  }
  if (BV_ISSET(fields, 24)) {
    log_packet_detailed("  field 'clean_pollution_time' has changed");
    dio_put_uint8(&dout, real_packet->clean_pollution_time);
  }
  if (BV_ISSET(fields, 25)) {
    log_packet_detailed("  field 'clean_fallout_time' has changed");
    dio_put_uint8(&dout, real_packet->clean_fallout_time);
  }
  if (BV_ISSET(fields, 26)) {
    log_packet_detailed("  field 'color_red' has changed");
    dio_put_uint8(&dout, real_packet->color_red);
  }
  if (BV_ISSET(fields, 27)) {
    log_packet_detailed("  field 'color_green' has changed");
    dio_put_uint8(&dout, real_packet->color_green);
  }
  if (BV_ISSET(fields, 28)) {
    log_packet_detailed("  field 'color_blue' has changed");
    dio_put_uint8(&dout, real_packet->color_blue);
  }
  if (BV_ISSET(fields, 29)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TERRAIN);
}

static void ensure_valid_variant_packet_ruleset_terrain(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_TERRAIN] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_TERRAIN variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_TERRAIN] = variant;
}

struct packet_ruleset_terrain *receive_packet_ruleset_terrain(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_terrain at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_terrain(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN]) {
  case 100:
    return receive_packet_ruleset_terrain_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_terrain(struct connection *pc, const struct packet_ruleset_terrain *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_terrain from the client.");
  }
  ensure_valid_variant_packet_ruleset_terrain(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN]) {

  case 100:
    return send_packet_ruleset_terrain_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_terrain(struct conn_list *dest, const struct packet_ruleset_terrain *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_terrain(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_terrain_flag_100 hash_const

#define cmp_packet_ruleset_terrain_flag_100 cmp_const

BV_DEFINE(packet_ruleset_terrain_flag_100_fields, 3);

static struct packet_ruleset_terrain_flag *receive_packet_ruleset_terrain_flag_100(struct connection *pc)
{
  packet_ruleset_terrain_flag_100_fields fields;
  struct packet_ruleset_terrain_flag *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_TERRAIN_FLAG;
  RECEIVE_PACKET_START(packet_ruleset_terrain_flag, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_terrain_flag_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_flag_100, cmp_packet_ruleset_terrain_flag_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!dio_get_uint8(&din, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'helptxt'");
    if (!dio_get_string(&din, real_packet->helptxt, sizeof(real_packet->helptxt))) {
      RECEIVE_PACKET_FIELD_ERROR(helptxt);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_terrain_flag_100(struct connection *pc, const struct packet_ruleset_terrain_flag *packet)
{
  const struct packet_ruleset_terrain_flag *real_packet = packet;
  packet_ruleset_terrain_flag_100_fields fields;
  struct packet_ruleset_terrain_flag *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_TERRAIN_FLAG;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_TERRAIN_FLAG);

  log_packet_detailed("packet_ruleset_terrain_flag_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_terrain_flag_100, cmp_packet_ruleset_terrain_flag_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->helptxt, real_packet->helptxt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'helptxt' has changed");
    dio_put_string(&dout, real_packet->helptxt);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_TERRAIN_FLAG);
}

static void ensure_valid_variant_packet_ruleset_terrain_flag(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_TERRAIN_FLAG] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_TERRAIN_FLAG variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_TERRAIN_FLAG] = variant;
}

struct packet_ruleset_terrain_flag *receive_packet_ruleset_terrain_flag(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_terrain_flag at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_terrain_flag(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN_FLAG]) {
  case 100:
    return receive_packet_ruleset_terrain_flag_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN_FLAG variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_terrain_flag(struct connection *pc, const struct packet_ruleset_terrain_flag *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_terrain_flag from the client.");
  }
  ensure_valid_variant_packet_ruleset_terrain_flag(pc);

  switch(pc->phs.variant[PACKET_RULESET_TERRAIN_FLAG]) {

  case 100:
    return send_packet_ruleset_terrain_flag_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_TERRAIN_FLAG variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_terrain_flag(struct conn_list *dest, const struct packet_ruleset_terrain_flag *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_terrain_flag(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_unit_class_100 hash_const

#define cmp_packet_ruleset_unit_class_100 cmp_const

BV_DEFINE(packet_ruleset_unit_class_100_fields, 8);

static struct packet_ruleset_unit_class *receive_packet_ruleset_unit_class_100(struct connection *pc)
{
  packet_ruleset_unit_class_100_fields fields;
  struct packet_ruleset_unit_class *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT_CLASS;
  RECEIVE_PACKET_START(packet_ruleset_unit_class, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_class_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_class_100, cmp_packet_ruleset_unit_class_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!dio_get_uint8(&din, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'move_type'");
    if (!dio_get_uint8(&din, &real_packet->move_type)) {
      RECEIVE_PACKET_FIELD_ERROR(move_type);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'min_speed_new'");
    if (!dio_get_uint16(&din, &real_packet->min_speed_new)) {
      RECEIVE_PACKET_FIELD_ERROR(min_speed_new);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'hp_loss_pct'");
    if (!dio_get_uint8(&din, &real_packet->hp_loss_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(hp_loss_pct);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'hut_behavior'");
    if (!dio_get_uint8(&din, &real_packet->hut_behavior)) {
      RECEIVE_PACKET_FIELD_ERROR(hut_behavior);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_class_100(struct connection *pc, const struct packet_ruleset_unit_class *packet)
{
  const struct packet_ruleset_unit_class *real_packet = packet;
  packet_ruleset_unit_class_100_fields fields;
  struct packet_ruleset_unit_class *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT_CLASS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT_CLASS);

  log_packet_detailed("packet_ruleset_unit_class_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_class_100, cmp_packet_ruleset_unit_class_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->move_type != real_packet->move_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->min_speed_new != real_packet->min_speed_new);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->hp_loss_pct != real_packet->hp_loss_pct);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->hut_behavior != real_packet->hut_behavior);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'move_type' has changed");
    dio_put_uint8(&dout, real_packet->move_type);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'min_speed_new' has changed");
    dio_put_uint16(&dout, real_packet->min_speed_new);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'hp_loss_pct' has changed");
    dio_put_uint8(&dout, real_packet->hp_loss_pct);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'hut_behavior' has changed");
    dio_put_uint8(&dout, real_packet->hut_behavior);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT_CLASS);
}

#define hash_packet_ruleset_unit_class_101 hash_const

#define cmp_packet_ruleset_unit_class_101 cmp_const

BV_DEFINE(packet_ruleset_unit_class_101_fields, 8);

static struct packet_ruleset_unit_class *receive_packet_ruleset_unit_class_101(struct connection *pc)
{
  packet_ruleset_unit_class_101_fields fields;
  struct packet_ruleset_unit_class *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_UNIT_CLASS;
  RECEIVE_PACKET_START(packet_ruleset_unit_class, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_unit_class_101: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_class_101, cmp_packet_ruleset_unit_class_101,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!dio_get_uint8(&din, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'move_type'");
    if (!dio_get_uint8(&din, &real_packet->move_type)) {
      RECEIVE_PACKET_FIELD_ERROR(move_type);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'min_speed_old'");
    if (!dio_get_uint8(&din, &real_packet->min_speed_old)) {
      RECEIVE_PACKET_FIELD_ERROR(min_speed_old);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'hp_loss_pct'");
    if (!dio_get_uint8(&din, &real_packet->hp_loss_pct)) {
      RECEIVE_PACKET_FIELD_ERROR(hp_loss_pct);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'hut_behavior'");
    if (!dio_get_uint8(&din, &real_packet->hut_behavior)) {
      RECEIVE_PACKET_FIELD_ERROR(hut_behavior);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_unit_class_101(struct connection *pc, const struct packet_ruleset_unit_class *packet)
{
  const struct packet_ruleset_unit_class *real_packet = packet;
  packet_ruleset_unit_class_101_fields fields;
  struct packet_ruleset_unit_class *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_UNIT_CLASS;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_UNIT_CLASS);

  log_packet_detailed("packet_ruleset_unit_class_101: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_unit_class_101, cmp_packet_ruleset_unit_class_101,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->move_type != real_packet->move_type);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (old->min_speed_old != real_packet->min_speed_old);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (old->hp_loss_pct != real_packet->hp_loss_pct);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (old->hut_behavior != real_packet->hut_behavior);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'move_type' has changed");
    dio_put_uint8(&dout, real_packet->move_type);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'min_speed_old' has changed");
    dio_put_uint8(&dout, real_packet->min_speed_old);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'hp_loss_pct' has changed");
    dio_put_uint8(&dout, real_packet->hp_loss_pct);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'hut_behavior' has changed");
    dio_put_uint8(&dout, real_packet->hut_behavior);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_UNIT_CLASS);
}

static void ensure_valid_variant_packet_ruleset_unit_class(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_UNIT_CLASS] != -1) {
    return;
  }

  if(FALSE) {
  } else if((has_capability("extended_move_rate", pc->capability) && has_capability("extended_move_rate", our_capability))) {
    variant = 100;
  } else if(!(has_capability("extended_move_rate", pc->capability) && has_capability("extended_move_rate", our_capability))) {
    variant = 101;
  } else {
    log_error("Unknown PACKET_RULESET_UNIT_CLASS variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  log_packet_detailed("packet_ruleset_unit_class: using variant=%d cap=%s", variant, pc->capability);
  pc->phs.variant[PACKET_RULESET_UNIT_CLASS] = variant;
}

struct packet_ruleset_unit_class *receive_packet_ruleset_unit_class(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_unit_class at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_unit_class(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT_CLASS]) {
  case 100:
    return receive_packet_ruleset_unit_class_100(pc);
  case 101:
    return receive_packet_ruleset_unit_class_101(pc);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT_CLASS variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_unit_class(struct connection *pc, const struct packet_ruleset_unit_class *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_unit_class from the client.");
  }
  ensure_valid_variant_packet_ruleset_unit_class(pc);

  switch(pc->phs.variant[PACKET_RULESET_UNIT_CLASS]) {

  case 100:
    return send_packet_ruleset_unit_class_100(pc, packet);
  case 101:
    return send_packet_ruleset_unit_class_101(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_UNIT_CLASS variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_unit_class(struct conn_list *dest, const struct packet_ruleset_unit_class *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_unit_class(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_base_100 hash_const

#define cmp_packet_ruleset_base_100 cmp_const

BV_DEFINE(packet_ruleset_base_100_fields, 21);

static struct packet_ruleset_base *receive_packet_ruleset_base_100(struct connection *pc)
{
  packet_ruleset_base_100_fields fields;
  struct packet_ruleset_base *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_BASE;
  RECEIVE_PACKET_START(packet_ruleset_base, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_base_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_base_100, cmp_packet_ruleset_base_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!dio_get_uint8(&din, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  real_packet->buildable = BV_ISSET(fields, 3);
  real_packet->pillageable = BV_ISSET(fields, 4);
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'activity_gfx'");
    if (!dio_get_string(&din, real_packet->activity_gfx, sizeof(real_packet->activity_gfx))) {
      RECEIVE_PACKET_FIELD_ERROR(activity_gfx);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'act_gfx_alt'");
    if (!dio_get_string(&din, real_packet->act_gfx_alt, sizeof(real_packet->act_gfx_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(act_gfx_alt);
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!dio_get_uint8(&din, &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!dio_get_requirement(&din, &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  got field 'gui_type'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(gui_type);
      }
      real_packet->gui_type = readin;
    }
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  got field 'native_to'");
    if (!DIO_BV_GET(&din, real_packet->native_to)) {
      RECEIVE_PACKET_FIELD_ERROR(native_to);
    }
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'build_time'");
    if (!dio_get_uint8(&din, &real_packet->build_time)) {
      RECEIVE_PACKET_FIELD_ERROR(build_time);
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'defense_bonus'");
    if (!dio_get_uint8(&din, &real_packet->defense_bonus)) {
      RECEIVE_PACKET_FIELD_ERROR(defense_bonus);
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'border_sq'");
    if (!dio_get_sint8(&din, &real_packet->border_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(border_sq);
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'vision_main_sq'");
    if (!dio_get_sint8(&din, &real_packet->vision_main_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(vision_main_sq);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'vision_invis_sq'");
    if (!dio_get_sint8(&din, &real_packet->vision_invis_sq)) {
      RECEIVE_PACKET_FIELD_ERROR(vision_invis_sq);
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'conflicts'");
    if (!DIO_BV_GET(&din, real_packet->conflicts)) {
      RECEIVE_PACKET_FIELD_ERROR(conflicts);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'helptext'");
    if (!dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_base_100(struct connection *pc, const struct packet_ruleset_base *packet)
{
  const struct packet_ruleset_base *real_packet = packet;
  packet_ruleset_base_100_fields fields;
  struct packet_ruleset_base *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_BASE;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_BASE);

  log_packet_detailed("packet_ruleset_base_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_base_100, cmp_packet_ruleset_base_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (old->buildable != real_packet->buildable);
  if(differ) {
    different++;
  }
  if (packet->buildable) {
    BV_SET(fields, 3);
  }

  differ = (old->pillageable != real_packet->pillageable);
  if(differ) {
    different++;
  }
  if (packet->pillageable) {
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (strcmp(old->activity_gfx, real_packet->activity_gfx) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (strcmp(old->act_gfx_alt, real_packet->act_gfx_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->gui_type != real_packet->gui_type);
  if (differ) {
    different++;
    BV_SET(fields, 11);
  }

  differ = !BV_ARE_EQUAL(old->native_to, real_packet->native_to);
  if (differ) {
    different++;
    BV_SET(fields, 12);
  }

  differ = (old->build_time != real_packet->build_time);
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }

  differ = (old->defense_bonus != real_packet->defense_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }

  differ = (old->border_sq != real_packet->border_sq);
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->vision_main_sq != real_packet->vision_main_sq);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }

  differ = (old->vision_invis_sq != real_packet->vision_invis_sq);
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = !BV_ARE_EQUAL(old->conflicts, real_packet->conflicts);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  /* field 3 is folded into the header */
  /* field 4 is folded into the header */
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'activity_gfx' has changed");
    dio_put_string(&dout, real_packet->activity_gfx);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'act_gfx_alt' has changed");
    dio_put_string(&dout, real_packet->act_gfx_alt);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'reqs_count' has changed");
    dio_put_uint8(&dout, real_packet->reqs_count);
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  field 'reqs' has changed");
  
    {
      int i;

      for (i = 0; i < real_packet->reqs_count; i++) {
        dio_put_requirement(&dout, &real_packet->reqs[i]);
      }
    } 
  }
  if (BV_ISSET(fields, 11)) {
    log_packet_detailed("  field 'gui_type' has changed");
    dio_put_uint8(&dout, real_packet->gui_type);
  }
  if (BV_ISSET(fields, 12)) {
    log_packet_detailed("  field 'native_to' has changed");
  DIO_BV_PUT(&dout, packet->native_to);
  }
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  field 'build_time' has changed");
    dio_put_uint8(&dout, real_packet->build_time);
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  field 'defense_bonus' has changed");
    dio_put_uint8(&dout, real_packet->defense_bonus);
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  field 'border_sq' has changed");
    dio_put_sint8(&dout, real_packet->border_sq);
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  field 'vision_main_sq' has changed");
    dio_put_sint8(&dout, real_packet->vision_main_sq);
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  field 'vision_invis_sq' has changed");
    dio_put_sint8(&dout, real_packet->vision_invis_sq);
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  field 'flags' has changed");
  DIO_BV_PUT(&dout, packet->flags);
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  field 'conflicts' has changed");
  DIO_BV_PUT(&dout, packet->conflicts);
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  field 'helptext' has changed");
    dio_put_string(&dout, real_packet->helptext);
  }

  *old = *real_packet;
  SEND_PACKET_END(PACKET_RULESET_BASE);
}

static void ensure_valid_variant_packet_ruleset_base(struct connection *pc)
{
  int variant = -1;

  if(pc->phs.variant[PACKET_RULESET_BASE] != -1) {
    return;
  }

  if(FALSE) {
  } else if(TRUE) {
    variant = 100;
  } else {
    log_error("Unknown PACKET_RULESET_BASE variant for connection %s", conn_description(pc));
    variant = -2;       /* Keep something invalid. */
  }
  pc->phs.variant[PACKET_RULESET_BASE] = variant;
}

struct packet_ruleset_base *receive_packet_ruleset_base(struct connection *pc)
{
  if(!pc->used) {
    log_error("WARNING: trying to read data from the closed connection %s",
              conn_description(pc));
    return NULL;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, NULL);
  if (is_server()) {
    log_packet("Receiving packet_ruleset_base at the server.");
    return NULL;
  }
  ensure_valid_variant_packet_ruleset_base(pc);

  switch(pc->phs.variant[PACKET_RULESET_BASE]) {
  case 100:
    return receive_packet_ruleset_base_100(pc);
  default:
    log_debug("Unknown PACKET_RULESET_BASE variant for connection %s", conn_description(pc));
    return NULL;
  }
}
int send_packet_ruleset_base(struct connection *pc, const struct packet_ruleset_base *packet)
{
  if(!pc->used) {
    log_error("WARNING: trying to send data to the closed connection %s",
              conn_description(pc));
    return -1;
  }
  fc_assert_ret_val(NULL != pc->phs.variant, -1);
  if (!is_server()) {
    log_error("Sending packet_ruleset_base from the client.");
  }
  ensure_valid_variant_packet_ruleset_base(pc);

  switch(pc->phs.variant[PACKET_RULESET_BASE]) {

  case 100:
    return send_packet_ruleset_base_100(pc, packet);
  default:
    log_debug("Unknown PACKET_RULESET_BASE variant for connection %s", conn_description(pc));
    return -1;
  }
}
void lsend_packet_ruleset_base(struct conn_list *dest, const struct packet_ruleset_base *packet)
{
  conn_list_iterate(dest, pconn) {
    send_packet_ruleset_base(pconn, packet);
  } conn_list_iterate_end;
}

#define hash_packet_ruleset_road_100 hash_const

#define cmp_packet_ruleset_road_100 cmp_const

BV_DEFINE(packet_ruleset_road_100_fields, 23);

static struct packet_ruleset_road *receive_packet_ruleset_road_100(struct connection *pc)
{
  packet_ruleset_road_100_fields fields;
  struct packet_ruleset_road *old;
  struct genhash **hash = pc->phs.received + PACKET_RULESET_ROAD;
  RECEIVE_PACKET_START(packet_ruleset_road, real_packet);

  DIO_BV_GET(&din, fields);

  log_packet_detailed("packet_ruleset_road_100: got info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_road_100, cmp_packet_ruleset_road_100,
                             NULL, NULL, NULL, free);
  }

  if (genhash_lookup(*hash, real_packet, (void **) &old)) {
    *real_packet = *old;
  } else {
    log_packet_detailed("  no old info");
    memset(real_packet, 0, sizeof(*real_packet));
  }

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  got field 'id'");
    if (!dio_get_uint8(&din, &real_packet->id)) {
      RECEIVE_PACKET_FIELD_ERROR(id);
    }
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  got field 'name'");
    if (!dio_get_string(&din, real_packet->name, sizeof(real_packet->name))) {
      RECEIVE_PACKET_FIELD_ERROR(name);
    }
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  got field 'rule_name'");
    if (!dio_get_string(&din, real_packet->rule_name, sizeof(real_packet->rule_name))) {
      RECEIVE_PACKET_FIELD_ERROR(rule_name);
    }
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  got field 'graphic_str'");
    if (!dio_get_string(&din, real_packet->graphic_str, sizeof(real_packet->graphic_str))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_str);
    }
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  got field 'graphic_alt'");
    if (!dio_get_string(&din, real_packet->graphic_alt, sizeof(real_packet->graphic_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(graphic_alt);
    }
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  got field 'activity_gfx'");
    if (!dio_get_string(&din, real_packet->activity_gfx, sizeof(real_packet->activity_gfx))) {
      RECEIVE_PACKET_FIELD_ERROR(activity_gfx);
    }
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  got field 'act_gfx_alt'");
    if (!dio_get_string(&din, real_packet->act_gfx_alt, sizeof(real_packet->act_gfx_alt))) {
      RECEIVE_PACKET_FIELD_ERROR(act_gfx_alt);
    }
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  got field 'move_cost_new'");
    if (!dio_get_uint16(&din, &real_packet->move_cost_new)) {
      RECEIVE_PACKET_FIELD_ERROR(move_cost_new);
    }
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  got field 'move_mode'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(move_mode);
      }
      real_packet->move_mode = readin;
    }
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  got field 'build_time'");
    if (!dio_get_uint8(&din, &real_packet->build_time)) {
      RECEIVE_PACKET_FIELD_ERROR(build_time);
    }
  }
  if (BV_ISSET(fields, 10)) {
    log_packet_detailed("  got field 'defense_bonus'");
    if (!dio_get_uint8(&din, &real_packet->defense_bonus)) {
      RECEIVE_PACKET_FIELD_ERROR(defense_bonus);
    }
  }
  real_packet->buildable = BV_ISSET(fields, 11);
  real_packet->pillageable = BV_ISSET(fields, 12);
  if (BV_ISSET(fields, 13)) {
    log_packet_detailed("  got field 'tile_incr_const'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint16(&din, &real_packet->tile_incr_const[i])) {
          RECEIVE_PACKET_FIELD_ERROR(tile_incr_const);
        }
      }
    }
  }
  if (BV_ISSET(fields, 14)) {
    log_packet_detailed("  got field 'tile_incr'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint16(&din, &real_packet->tile_incr[i])) {
          RECEIVE_PACKET_FIELD_ERROR(tile_incr);
        }
      }
    }
  }
  if (BV_ISSET(fields, 15)) {
    log_packet_detailed("  got field 'tile_bonus'");
    
    {
      int i;
    
      for (i = 0; i < O_LAST; i++) {
        if (!dio_get_uint16(&din, &real_packet->tile_bonus[i])) {
          RECEIVE_PACKET_FIELD_ERROR(tile_bonus);
        }
      }
    }
  }
  if (BV_ISSET(fields, 16)) {
    log_packet_detailed("  got field 'reqs_count'");
    if (!dio_get_uint8(&din, &real_packet->reqs_count)) {
      RECEIVE_PACKET_FIELD_ERROR(reqs_count);
    }
  }
  if (BV_ISSET(fields, 17)) {
    log_packet_detailed("  got field 'reqs'");
    
    {
      int i;
    
      if (real_packet->reqs_count > MAX_NUM_REQS) {
        RECEIVE_PACKET_FIELD_ERROR(reqs, ": truncation array");
      }
      for (i = 0; i < real_packet->reqs_count; i++) {
        if (!dio_get_requirement(&din, &real_packet->reqs[i])) {
          RECEIVE_PACKET_FIELD_ERROR(reqs);
        }
      }
    }
  }
  if (BV_ISSET(fields, 18)) {
    log_packet_detailed("  got field 'compat'");
    {
      int readin;
      
      if (!dio_get_uint8(&din, &readin)) {
        RECEIVE_PACKET_FIELD_ERROR(compat);
      }
      real_packet->compat = readin;
    }
  }
  if (BV_ISSET(fields, 19)) {
    log_packet_detailed("  got field 'native_to'");
    if (!DIO_BV_GET(&din, real_packet->native_to)) {
      RECEIVE_PACKET_FIELD_ERROR(native_to);
    }
  }
  if (BV_ISSET(fields, 20)) {
    log_packet_detailed("  got field 'hidden_by'");
    if (!DIO_BV_GET(&din, real_packet->hidden_by)) {
      RECEIVE_PACKET_FIELD_ERROR(hidden_by);
    }
  }
  if (BV_ISSET(fields, 21)) {
    log_packet_detailed("  got field 'flags'");
    if (!DIO_BV_GET(&din, real_packet->flags)) {
      RECEIVE_PACKET_FIELD_ERROR(flags);
    }
  }
  if (BV_ISSET(fields, 22)) {
    log_packet_detailed("  got field 'helptext'");
    if (!dio_get_string(&din, real_packet->helptext, sizeof(real_packet->helptext))) {
      RECEIVE_PACKET_FIELD_ERROR(helptext);
    }
  }

  if (NULL == old) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
  } else {
    *old = *real_packet;
  }
  RECEIVE_PACKET_END(real_packet);
}

static int send_packet_ruleset_road_100(struct connection *pc, const struct packet_ruleset_road *packet)
{
  const struct packet_ruleset_road *real_packet = packet;
  packet_ruleset_road_100_fields fields;
  struct packet_ruleset_road *old;
  bool differ;
  struct genhash **hash = pc->phs.sent + PACKET_RULESET_ROAD;
  int different = 0;
  SEND_PACKET_START(PACKET_RULESET_ROAD);

  log_packet_detailed("packet_ruleset_road_100: sending info about ()");

  if (NULL == *hash) {
    *hash = genhash_new_full(hash_packet_ruleset_road_100, cmp_packet_ruleset_road_100,
                             NULL, NULL, NULL, free);
  }
  BV_CLR_ALL(fields);

  if (!genhash_lookup(*hash, real_packet, (void **) &old)) {
    old = fc_malloc(sizeof(*old));
    *old = *real_packet;
    genhash_insert(*hash, old, old);
    memset(old, 0, sizeof(*old));
    different = 1;      /* Force to send. */
  }

  differ = (old->id != real_packet->id);
  if (differ) {
    different++;
    BV_SET(fields, 0);
  }

  differ = (strcmp(old->name, real_packet->name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 1);
  }

  differ = (strcmp(old->rule_name, real_packet->rule_name) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 2);
  }

  differ = (strcmp(old->graphic_str, real_packet->graphic_str) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 3);
  }

  differ = (strcmp(old->graphic_alt, real_packet->graphic_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 4);
  }

  differ = (strcmp(old->activity_gfx, real_packet->activity_gfx) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 5);
  }

  differ = (strcmp(old->act_gfx_alt, real_packet->act_gfx_alt) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 6);
  }

  differ = (old->move_cost_new != real_packet->move_cost_new);
  if (differ) {
    different++;
    BV_SET(fields, 7);
  }

  differ = (old->move_mode != real_packet->move_mode);
  if (differ) {
    different++;
    BV_SET(fields, 8);
  }

  differ = (old->build_time != real_packet->build_time);
  if (differ) {
    different++;
    BV_SET(fields, 9);
  }

  differ = (old->defense_bonus != real_packet->defense_bonus);
  if (differ) {
    different++;
    BV_SET(fields, 10);
  }

  differ = (old->buildable != real_packet->buildable);
  if(differ) {
    different++;
  }
  if (packet->buildable) {
    BV_SET(fields, 11);
  }

  differ = (old->pillageable != real_packet->pillageable);
  if(differ) {
    different++;
  }
  if (packet->pillageable) {
    BV_SET(fields, 12);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->tile_incr_const[i] != real_packet->tile_incr_const[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 13);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->tile_incr[i] != real_packet->tile_incr[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 14);
  }


    {
      differ = (O_LAST != O_LAST);
      if(!differ) {
        int i;
        for (i = 0; i < O_LAST; i++) {
          if (old->tile_bonus[i] != real_packet->tile_bonus[i]) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 15);
  }

  differ = (old->reqs_count != real_packet->reqs_count);
  if (differ) {
    different++;
    BV_SET(fields, 16);
  }


    {
      differ = (old->reqs_count != real_packet->reqs_count);
      if(!differ) {
        int i;
        for (i = 0; i < real_packet->reqs_count; i++) {
          if (!are_requirements_equal(&old->reqs[i], &real_packet->reqs[i])) {
            differ = TRUE;
            break;
          }
        }
      }
    }
  if (differ) {
    different++;
    BV_SET(fields, 17);
  }

  differ = (old->compat != real_packet->compat);
  if (differ) {
    different++;
    BV_SET(fields, 18);
  }

  differ = !BV_ARE_EQUAL(old->native_to, real_packet->native_to);
  if (differ) {
    different++;
    BV_SET(fields, 19);
  }

  differ = !BV_ARE_EQUAL(old->hidden_by, real_packet->hidden_by);
  if (differ) {
    different++;
    BV_SET(fields, 20);
  }

  differ = !BV_ARE_EQUAL(old->flags, real_packet->flags);
  if (differ) {
    different++;
    BV_SET(fields, 21);
  }

  differ = (strcmp(old->helptext, real_packet->helptext) != 0);
  if (differ) {
    different++;
    BV_SET(fields, 22);
  }


  DIO_BV_PUT(&dout, fields);

  if (BV_ISSET(fields, 0)) {
    log_packet_detailed("  field 'id' has changed");
    dio_put_uint8(&dout, real_packet->id);
  }
  if (BV_ISSET(fields, 1)) {
    log_packet_detailed("  field 'name' has changed");
    dio_put_string(&dout, real_packet->name);
  }
  if (BV_ISSET(fields, 2)) {
    log_packet_detailed("  field 'rule_name' has changed");
    dio_put_string(&dout, real_packet->rule_name);
  }
  if (BV_ISSET(fields, 3)) {
    log_packet_detailed("  field 'graphic_str' has changed");
    dio_put_string(&dout, real_packet->graphic_str);
  }
  if (BV_ISSET(fields, 4)) {
    log_packet_detailed("  field 'graphic_alt' has changed");
    dio_put_string(&dout, real_packet->graphic_alt);
  }
  if (BV_ISSET(fields, 5)) {
    log_packet_detailed("  field 'activity_gfx' has changed");
    dio_put_string(&dout, real_packet->activity_gfx);
  }
  if (BV_ISSET(fields, 6)) {
    log_packet_detailed("  field 'act_gfx_alt' has changed");
    dio_put_string(&dout, real_packet->act_gfx_alt);
  }
  if (BV_ISSET(fields, 7)) {
    log_packet_detailed("  field 'move_cost_new' has changed");
    dio_put_uint16(&dout, real_packet->move_cost_new);
  }
  if (BV_ISSET(fields, 8)) {
    log_packet_detailed("  field 'move_mode' has changed");
    dio_put_uint8(&dout, real_packet->move_mode);
  }
  if (BV_ISSET(fields, 9)) {
    log_packet_detailed("  field 'build_time' has changed");
    dio_put_uint8(&dout, real_packet->b