#pragma once

#include "../JuceLibraryCode/JuceHeader.h"
#include "PluginProcessor.h"


//==============================================================================
/**
*/
class SawtoothSynthAudioProcessorEditor  : public AudioProcessorEditor, private MidiInputCallback, private MidiKeyboardStateListener
{
public:
    SawtoothSynthAudioProcessorEditor (SawtoothSynthAudioProcessor&);
    ~SawtoothSynthAudioProcessorEditor();

    //==============================================================================
    void paint (Graphics&) override;
    void resized() override;

private:
    void handleNoteOn (MidiKeyboardState*, int midiChannel, int midiNoteNumber, float velocity) override;
    void handleNoteOff (MidiKeyboardState*, int midiChannel, int midiNoteNumber, float /*velocity*/) override;
    void handleIncomingMidiMessage (MidiInput* source, const MidiMessage& message) override;
  
    MidiKeyboardState keyboardState;            // [5]
    MidiKeyboardComponent keyboardComponent;    // [6]
    
    Slider cutoffSlider;
    Label cutoffLabel;
  
    // This reference is provided as a quick way for your editor to
    // access the processor object that created it.
    SawtoothSynthAudioProcessor& processor;

    JUCE_DECLARE_NON_COPYABLE_WITH_LEAK_DETECTOR (SawtoothSynthAudioProcessorEditor)
};
