package ONVIF::Analytics::Types::SystemLogUri;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Type_of :ATTR(:get<Type>);
my %Uri_of :ATTR(:get<Uri>);

__PACKAGE__->_factory(
    [ qw(        Type
        Uri

    ) ],
    {
        'Type' => \%Type_of,
        'Uri' => \%Uri_of,
    },
    {
        'Type' => 'ONVIF::Analytics::Types::SystemLogType',
        'Uri' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
    },
    {

        'Type' => 'Type',
        'Uri' => 'Uri',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::SystemLogUri

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SystemLogUri from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Type


=item * Uri




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::SystemLogUri
   Type => $some_value, # SystemLogType
   Uri =>  $some_value, # anyURI
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

