#import "TestListenerTest.h"
#import "MockTestCase.h"

@implementation TestListenerTest

- (void)startTest:(id<Test>)test {
    ++startCount;
}

- (void)endTest:(id<Test>)test {
    ++endCount;
}

- (void)addError:(NSException *)exception forTest:(id<Test>)test {
    ++errorCount;
}

- (void)addFailure:(NSException *)exception forTest:(id<Test>)test {
    ++failureCount;
}

- (void)setUp {
    result = [[TestResult alloc] init];
    [result addListener:self];
    errorCount = endCount = 0;
}

- (void)tearDown {
    [result release];
}

- (void)testError {
    MockTestCase *test = [MockTestCase testWithName:@"error"];
    test->runTestRaisesException = YES;
    [test run:result];
    [self assertInt:errorCount equals:1];
    [self assertInt:endCount equals:1];
}

- (void)testFailure {
    MockTestCase *test = [MockTestCase testWithName:@"fail"];
    test->runTestFails = YES;
    [test run:result];
    [self assertInt:failureCount equals:1];
    [self assertInt:endCount equals:1];
}

- (void)testStartStop {
    MockTestCase *test = [MockTestCase testWithName:@"success"];
    [test run:result];
    [self assertInt:startCount equals:1];
    [self assertInt:endCount equals:1];
}

@end
