/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.browser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.web3d.browser.BrowserCore;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.WriteableSceneMetaData;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.browser.CommonBrowser;
import org.web3d.vrml.scripting.browser.ReplaceWorldVRMLScene;
import org.web3d.vrml.scripting.browser.SceneFillTraverser;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.loading.WorldLoader;
import org.xj3d.core.loading.WorldLoaderManager;

public class VRML97CommonBrowser
extends CommonBrowser {
    private static final String DEFAULT_VRML_HEADER = "#VRML V2.0 utf8\n";
    private static final String VRML97_PROFILE_STRING = "vrml97";
    private VRMLNodeFactory nodeFactory;

    public VRML97CommonBrowser(BrowserCore browserCore, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager, VRMLNodeFactory vRMLNodeFactory) {
        super(browserCore, routeManager, frameStateManager, worldLoaderManager);
        this.nodeFactory = vRMLNodeFactory;
    }

    public void replaceWorld(VRMLNodeType[] vRMLNodeTypeArray) {
        VRMLWorldRootNodeType vRMLWorldRootNodeType = (VRMLWorldRootNodeType)this.nodeFactory.createVRMLNode("WorldRoot", false);
        vRMLWorldRootNodeType.setErrorReporter(this.errorReporter);
        vRMLWorldRootNodeType.setChildren(vRMLNodeTypeArray);
        vRMLWorldRootNodeType.setupFinished();
        ReplaceWorldVRMLScene replaceWorldVRMLScene = new ReplaceWorldVRMLScene(2, 0, vRMLWorldRootNodeType, this.core.getWorldURL());
        WriteableSceneMetaData writeableSceneMetaData = new WriteableSceneMetaData("2.0", true, 2);
        writeableSceneMetaData.setProfileName(VRML97_PROFILE_STRING);
        replaceWorldVRMLScene.setWorldRootURL(this.getWorldURL());
        replaceWorldVRMLScene.setNodeFactory(this.nodeFactory);
        replaceWorldVRMLScene.setMetaData(writeableSceneMetaData);
        replaceWorldVRMLScene.setRootNode(vRMLWorldRootNodeType);
        vRMLWorldRootNodeType.setContainedScene(replaceWorldVRMLScene);
        SceneFillTraverser.processNodes(replaceWorldVRMLScene);
        this.core.setScene(replaceWorldVRMLScene, null);
    }

    public VRMLNodeType[] createVrmlFromString(String string, VRMLExecutionSpace vRMLExecutionSpace) throws VRMLException, VRMLParseException, IOException {
        VRMLNodeType[] vRMLNodeTypeArray = null;
        String string2 = !string.startsWith(DEFAULT_VRML_HEADER) ? DEFAULT_VRML_HEADER + string : string;
        StringReader stringReader = new StringReader(string2);
        InputSource inputSource = new InputSource(this.core.getWorldURL(), stringReader);
        WorldLoader worldLoader = this.loaderManager.fetchLoader();
        VRMLScene vRMLScene = worldLoader.loadNow(this.core, inputSource, false, 2, 0);
        this.loaderManager.releaseLoader(worldLoader);
        VRMLNodeType vRMLNodeType = (VRMLNodeType)vRMLScene.getRootNode();
        if (vRMLNodeType.getPrimaryType() == 57) {
            VRMLWorldRootNodeType vRMLWorldRootNodeType = (VRMLWorldRootNodeType)vRMLNodeType;
            VRMLNodeType[] vRMLNodeTypeArray2 = vRMLWorldRootNodeType.getChildren();
            vRMLWorldRootNodeType.setChildren((VRMLNodeType)null);
            vRMLNodeTypeArray = vRMLNodeTypeArray2;
            this.routeManager.addSpace(vRMLWorldRootNodeType);
            ArrayList arrayList = vRMLScene.getByPrimaryType(24);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                VRMLInlineNodeType vRMLInlineNodeType = (VRMLInlineNodeType)arrayList.get(i);
                vRMLInlineNodeType.setParentSpace(vRMLExecutionSpace);
            }
            ArrayList arrayList2 = vRMLScene.getNodeTemplates();
            n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList2.get(i);
                if (!(e instanceof VRMLExternProtoDeclare)) continue;
                VRMLExternProtoDeclare vRMLExternProtoDeclare = (VRMLExternProtoDeclare)e;
                this.stateManager.registerAddedExternProto(vRMLExternProtoDeclare);
            }
        } else {
            this.errorReporter.messageReport("Unhandled root node type in VRML97CommonBrowser.");
            vRMLNodeTypeArray = new VRMLNodeType[]{vRMLNodeType};
        }
        return vRMLNodeTypeArray;
    }

    public void createVrmlFromURL(String[] stringArray, VRMLNodeType vRMLNodeType, String string) throws InvalidFieldException {
        int n = vRMLNodeType.getFieldIndex(string);
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
        int n2 = vRMLFieldDeclaration.getAccessType();
        if (n2 == 4 || n2 == 2) {
            throw new InvalidFieldException("The field is not an eventIn");
        }
        int n3 = vRMLFieldDeclaration.getFieldType();
        if (n3 != 12) {
            throw new InvalidFieldException("Field is not an MFNode");
        }
        this.loaderManager.queueCreateURL(stringArray, vRMLNodeType, n, this.core.getWorldExecutionSpace());
    }
}

