/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import rfb.Cursor;
import rfb.LogWriter;
import rfb.ManagedPixelBuffer;
import rfb.PixelFormat;
import vncviewer.CConn;
import vncviewer.ClipboardDialog;
import vncviewer.PixelBufferImage;

class DesktopWindow
extends Canvas
implements Runnable {
    String oldContents = "";
    CConn cc;
    PixelBufferImage im;
    Graphics graphics;
    Thread setColourMapEntriesTimerThread;
    Cursor cursor;
    boolean cursorVisible;
    boolean cursorAvailable;
    int cursorPosX;
    int cursorPosY;
    ManagedPixelBuffer cursorBacking;
    int cursorBackingX;
    int cursorBackingY;
    boolean invalidRect;
    int invalidLeft;
    int invalidRight;
    int invalidTop;
    int invalidBottom;
    int lastX;
    int lastY;
    static LogWriter vlog = new LogWriter("DesktopWindow");

    public DesktopWindow(PixelFormat serverPF, CConn cc_) {
        this.cc = cc_;
        this.setSize(this.cc.cp.width, this.cc.cp.height);
        this.im = new PixelBufferImage(this.cc.cp.width, this.cc.cp.height, this);
        this.cursor = new Cursor();
        this.cursorBacking = new ManagedPixelBuffer();
    }

    public void initGraphics() {
        this.graphics = this.getGraphics();
    }

    public final PixelFormat getPF() {
        return this.im.getPF();
    }

    public synchronized void setCursor(int hotspotX, int hotspotY, int w, int h, byte[] data, byte[] mask) {
        if (!this.cc.viewer.useLocalCursor.getValue()) {
            return;
        }
        if (!this.cursorAvailable) {
            this.cursorAvailable = true;
        }
        this.hideLocalCursor();
        this.cursor.hotspotX = hotspotX;
        this.cursor.hotspotY = hotspotY;
        this.cursor.setSize(w, h);
        this.cursor.setPF(this.getPF());
        System.arraycopy(data, 0, this.cursor.data, 0, this.cursor.dataLen());
        System.arraycopy(mask, 0, this.cursor.mask, 0, this.cursor.maskLen());
        this.cursorBacking.setSize(w, h);
        this.cursorBacking.setPF(this.getPF());
        this.showLocalCursor();
    }

    public synchronized void setColourMapEntries(int firstColour, int nColours, int[] rgbs) {
        this.im.setColourMapEntries(firstColour, nColours, rgbs);
        if (nColours == 256) {
            this.im.updateColourMap();
            this.im.put(0, 0, this.im.width(), this.im.height(), this.graphics);
        } else if (this.setColourMapEntriesTimerThread == null) {
            this.setColourMapEntriesTimerThread = new Thread(this);
            this.setColourMapEntriesTimerThread.start();
        }
    }

    public synchronized void resize() {
        vlog.debug("DesktopWindow.resize() called");
        int w = this.cc.cp.width;
        int h = this.cc.cp.height;
        this.hideLocalCursor();
        this.setSize(w, h);
        this.im.resize(w, h, this);
    }

    final void drawInvalidRect() {
        if (!this.invalidRect) {
            return;
        }
        int x = this.invalidLeft;
        int w = this.invalidRight - x;
        int y = this.invalidTop;
        int h = this.invalidBottom - y;
        this.invalidRect = false;
        DesktopWindow desktopWindow = this;
        synchronized (desktopWindow) {
            this.im.put(x, y, w, h, this.graphics);
        }
    }

    final void invalidate(int x, int y, int w, int h) {
        if (this.invalidRect) {
            if (x < this.invalidLeft) {
                this.invalidLeft = x;
            }
            if (x + w > this.invalidRight) {
                this.invalidRight = x + w;
            }
            if (y < this.invalidTop) {
                this.invalidTop = y;
            }
            if (y + h > this.invalidBottom) {
                this.invalidBottom = y + h;
            }
        } else {
            this.invalidLeft = x;
            this.invalidRight = x + w;
            this.invalidTop = y;
            this.invalidBottom = y + h;
            this.invalidRect = true;
        }
        if ((this.invalidRight - this.invalidLeft) * (this.invalidBottom - this.invalidTop) > 100000) {
            this.drawInvalidRect();
        }
    }

    public void beginRect(int x, int y, int w, int h, int encoding) {
        this.invalidRect = false;
    }

    public void endRect(int x, int y, int w, int h, int encoding) {
        this.drawInvalidRect();
    }

    public final synchronized void fillRect(int x, int y, int w, int h, int pix) {
        if (this.overlapsCursor(x, y, w, h)) {
            this.hideLocalCursor();
        }
        this.im.fillRect(x, y, w, h, pix);
        this.invalidate(x, y, w, h);
        this.showLocalCursor();
    }

    public final synchronized void imageRect(int x, int y, int w, int h, byte[] pix, int offset) {
        if (this.overlapsCursor(x, y, w, h)) {
            this.hideLocalCursor();
        }
        this.im.imageRect(x, y, w, h, pix, offset);
        this.invalidate(x, y, w, h);
        this.showLocalCursor();
    }

    public final synchronized void copyRect(int x, int y, int w, int h, int srcX, int srcY) {
        if (this.overlapsCursor(x, y, w, h) || this.overlapsCursor(srcX, srcY, w, h)) {
            this.hideLocalCursor();
        }
        this.im.copyRect(x, y, w, h, srcX, srcY);
        if (this.cc.viewer.fastCopyRect.getValue()) {
            this.graphics.setClip(0, 0, this.im.width(), this.im.height());
            this.graphics.copyArea(srcX, srcY, w, h, x - srcX, y - srcY);
        } else {
            this.invalidate(x, y, w, h);
        }
    }

    final boolean overlapsCursor(int x, int y, int w, int h) {
        return x < this.cursorBackingX + this.cursorBacking.width() && y < this.cursorBackingY + this.cursorBacking.height() && x + w > this.cursorBackingX && y + h > this.cursorBackingY;
    }

    synchronized void resetLocalCursor() {
        this.hideLocalCursor();
        this.cursorAvailable = false;
    }

    public synchronized Dimension getPreferredSize() {
        return new Dimension(this.im.width(), this.im.height());
    }

    public synchronized Dimension getMinimumSize() {
        return new Dimension(this.im.width(), this.im.height());
    }

    public void update(Graphics g) {
        System.err.println("update called");
    }

    public synchronized void paint(Graphics g) {
        g.drawImage(this.im.image, 0, 0, null);
    }

    public synchronized void checkClipboard() {
        Transferable t;
        if (ClipboardDialog.systemClipboard != null && this.cc.viewer.sendClipboard.getValue() && (t = ClipboardDialog.systemClipboard.getContents(this)) != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String newContents = (String)t.getTransferData(DataFlavor.stringFlavor);
                if (newContents != null && !newContents.equals(this.oldContents)) {
                    this.cc.writeClientCutText(newContents);
                    this.oldContents = newContents;
                    this.cc.clipboardDialog.setContents(newContents);
                }
            }
            catch (Exception e) {
                System.out.println("Exception getting clipboard data: " + e.getMessage());
            }
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 1004: {
                this.checkClipboard();
                break;
            }
            case 503: 
            case 506: {
                if (!this.cc.viewer.viewOnly.getValue()) {
                    this.cc.writePointerEvent(event);
                }
                DesktopWindow desktopWindow = this;
                synchronized (desktopWindow) {
                    if (this.cursorAvailable && (event.x != this.cursorPosX || event.y != this.cursorPosY)) {
                        this.hideLocalCursor();
                        if (event.x >= 0 && event.x < this.im.width() && event.y >= 0 && event.y < this.im.height()) {
                            this.cursorPosX = event.x;
                            this.cursorPosY = event.y;
                            this.showLocalCursor();
                        }
                    }
                }
                this.lastX = event.x;
                this.lastY = event.y;
                break;
            }
            case 501: 
            case 502: {
                if (!this.cc.viewer.viewOnly.getValue()) {
                    this.cc.writePointerEvent(event);
                }
                this.lastX = event.x;
                this.lastY = event.y;
                break;
            }
            case 403: {
                if (event.key == 1015) {
                    this.cc.showMenu(this.lastX, this.lastY);
                    break;
                }
            }
            case 401: {
                if (this.cc.viewer.viewOnly.getValue()) break;
                this.cc.writeKeyEvent(event);
            }
        }
        return super.handleEvent(event);
    }

    private void hideLocalCursor() {
        if (this.cursorVisible) {
            this.cursorVisible = false;
            this.im.imageRect(this.cursorBackingX, this.cursorBackingY, this.cursorBacking.width(), this.cursorBacking.height(), this.cursorBacking.data, 0);
            this.im.put(this.cursorBackingX, this.cursorBackingY, this.cursorBacking.width(), this.cursorBacking.height(), this.graphics);
        }
    }

    private void showLocalCursor() {
        if (this.cursorAvailable && !this.cursorVisible) {
            if (!this.im.getPF().equal(this.cursor.getPF()) || this.cursor.width() == 0 || this.cursor.height() == 0) {
                vlog.debug("attempting to render invalid local cursor");
                this.cursorAvailable = false;
                return;
            }
            this.cursorVisible = true;
            int cursorLeft = this.cursorPosX - this.cursor.hotspotX;
            int cursorTop = this.cursorPosY - this.cursor.hotspotY;
            int cursorRight = cursorLeft + this.cursor.width();
            int cursorBottom = cursorTop + this.cursor.height();
            int x = cursorLeft >= 0 ? cursorLeft : 0;
            int y = cursorTop >= 0 ? cursorTop : 0;
            int w = (cursorRight < this.im.width() ? cursorRight : this.im.width()) - x;
            int h = (cursorBottom < this.im.height() ? cursorBottom : this.im.height()) - y;
            this.cursorBackingX = x;
            this.cursorBackingY = y;
            this.cursorBacking.setSize(w, h);
            int j = 0;
            while (j < h) {
                System.arraycopy(this.im.data, (y + j) * this.im.width() + x, this.cursorBacking.data, j * w, w);
                ++j;
            }
            this.im.maskRect(cursorLeft, cursorTop, this.cursor.width(), this.cursor.height(), this.cursor.data, this.cursor.mask);
            this.im.put(x, y, w, h, this.graphics);
        }
    }

    public void run() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        DesktopWindow desktopWindow = this;
        synchronized (desktopWindow) {
            this.im.updateColourMap();
            this.im.put(0, 0, this.im.width(), this.im.height(), this.graphics);
            this.setColourMapEntriesTimerThread = null;
        }
    }
}

