#ifndef OptionWidget_h
#define OptionWidget_h

/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "Options.h"

#include <QObject>
#include <QString>

class OptionWidget
{
    public:

    //! constructor
    OptionWidget( const QString& name, QObject* budy = 0 ):
        optionName_( name ),
        buddy_( budy ),
        connected_( false )
    {}

    //! destructor
    virtual ~OptionWidget()
    {}

    //! set widget value from option value
    virtual void read( const Options& ) = 0;

    //! set option value from widget value
    virtual void write( Options& ) const = 0;

    //! true if has buddy
    bool hasBuddy( void ) const
    { return buddy_; }

    //! buddy
    QObject& buddy( void ) const
    { return *buddy_; }

    //! option name
    const QString& optionName( void ) const
    { return optionName_; }

    protected:

    //! set buddy
    virtual void _setBuddy( QObject* buddy )
    { buddy_ = buddy; }

    //! true when connected
    bool _connected( void ) const
    { return connected_; }

    //! set connected
    void _setConnected( bool value = true )
    { connected_ = value; }

    private:

    //! name of the option linked to the widget
    QString optionName_;

    //! buddy
    /*! it is used for signal/slots connections in derived class implementations */
    QObject* buddy_;

    //! true when connected
    bool connected_;

};

#endif
