/***************************************************************************
 *   Copyright (C) 2005 by Johan Maes   *
 *   on4qz@telenet.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/
#include "modefax.h"
#include "imageview.h"
#include "io_event.h"
#include <qapplication.h>
#include "io_control.h"
#include "configdialog.h"

modeFAX::modeFAX(esstvMode m,bool tx) : modeBase(m,tx)
{
	
}


modeFAX::~modeFAX()
{

}

void modeFAX::modeInit(double rxClk)
{
	lineCounter=0;
	displayLineCounter=0;
	subLine=0;
	sampleCounter=0;

	
	state=MBSETUPLINE;
	debugState=stHUNT;
	deleteBuffers();
	pixelPositionTable=new unsigned int[activeFAXParam.numberOfPixels];
	greenArrayPtr=new unsigned char[activeFAXParam.numberOfPixels];
	setupParams(rxClk);
	pixelArrayPtr=greenArrayPtr;
	faxState=FAXAPTSTART;
	setupFAXLineTimeTable(rxClk);
	visibleLineLength=(60./(activeFAXParam.lpm))*rxClk; // in samples
	for (int i=0;i<SYNCMAX;i++)
		{
			syncArray[i]=0;
		}
	sMax=0; up=FALSE;
}

eModeBase modeFAX::receive(float *f,uint &pos,uint len)
{
	uint i;
	for(i=0;i<len;i++)
		{
			sample=f[pos];
			debugStateBuffer[pos]=debugState;
			pos=(++pos&DSPINPUTINDEXMASK);
			switch (faxState)
				{
					case FAXAPTSTART:
						if(detectStart()) faxState=FAXPHASING;
					break;
					case FAXPHASING:
						if(detectPhasing())
							{
								sampleCounter=0;
								pixelCounter=0;
								faxState=FAXSETUPLINE;
							}
					break;
					case FAXSETUPLINE:
						{
							calcPixelPositionTable(FALSE);
							faxState=FAXDISPLAY;
						}
					case FAXDISPLAY:
						sampleCounter++;
					
						if(getPixels())
							{
								pixelCounter=0;
								showLine();
								pixelDisplayEvent *ce= new pixelDisplayEvent(displayLineCounter);
								QApplication::postEvent( io_ctrl, ce );  // Qt will delete it when done
								lineCounter++;
								calcPixelPositionTable(FALSE);
							 	if (displayLineCounter>=activeFAXParam.numberOfDisplayLines)
									{
										faxState=FAXSTOP;
									}
							}
					break;
					case FAXSTOP:
							return MBENDOFIMAGE;
					break;
				}
		}
	return MBRUNNING;
}



bool modeFAX::detectStart()
{
	
	if(activeFAXParam.aptStartDuration==0) return TRUE;
	
	
	return TRUE;
}

bool modeFAX::detectPhasing()
{
	bool deb=FALSE;
	sampleCounter++;
	if((sampleCounter>47476)&&(sampleCounter<47576))
		{
			deb=TRUE;
			qDebug("s=%f, max=%f, cnt=%d",sample,sMax,sampleCounter);
		}

	if(activeFAXParam.mode==NOAA)
		{
			// we don't have phasing lines, but need to find start
			if(sMax<sample)
				{	
				 	sMax=sample;
					up=TRUE;
				}
			else
				{
					if(up) 
						{
							up=FALSE;
							if(sMax>80)
								{
									if(deb) qDebug("record");
									shiftUp();
									syncArray[SYNCMAX-1]=sampleCounter;
									if(checkNOAASync())
												 return TRUE;
								}
						}
					sMax=sample;
				}
			return FALSE;
	}
	if(activeFAXParam.numberOfPhasingLines==0) return TRUE;
	return TRUE;
}

/*


			else if(sMin>sample) sMin=sample;
			else if ((sample<(0.7*sMax)) && (sMax>80))
				{
					
					shiftUp();
					syncArray[SYNCMAX-1]=sampleCounter;
					sMax=0; sMin=256;
					if(checkNOAASync()) return TRUE;
				}
			if(deb) qDebug("s=%f, min=%f, max=%f, cnt=%d",sample,sMin,sMax,sampleCounter);
			return FALSE;

}*/

void modeFAX::shiftUp()
{
	int i;
	for(i=1;i<SYNCMAX;i++)
		{
			syncArray[i-1]=syncArray[i];	
		}
}

bool modeFAX::checkNOAASync()
{
	if (abs((syncArray[SYNCMAX-1]-syncArray[SYNCMAX-7])-(int)(6.*rxClock/1040.))<8)
		{
			for(int i=1;i<(SYNCMAX-1);i++)
				{
					if(abs(abs(syncArray[i+1]-syncArray[i])-10)>2)
						{
						 	return FALSE;
						}
				}
			return TRUE;
		}
	return FALSE;
}

eModeBase modeFAX::transmitImage()
{

}


embState modeFAX::setupLine(uint &subLine)
{
	
}

void modeFAX::calcPixelPositionTable(bool tx)
{
	unsigned int i;
	int ofx=0;
	if(tx) ofx=1;
	double start=0;
	if(lineCounter!=0) start=lineTimeTable[lineCounter-1];
	debugState=stColorLine4;
	for(i=0;i<activeFAXParam.numberOfPixels;i++)
		{
			pixelPositionTable[i]=(unsigned int)round(start+((double)(i+ofx))*visibleLineLength/((double)activeFAXParam.numberOfPixels));
		}
	
}

void modeFAX::setupParams(double clock)
{

}



void modeFAX::showLine()
{
		unsigned int i;
	unsigned int *pixelArray=rxImagePtr->getLineAddress(displayLineCounter);
	for(i=0;i<activeFAXParam.numberOfPixels;i++)
		{
			pixelArray[i]=qRgb(greenArrayPtr[i],greenArrayPtr[i],greenArrayPtr[i]);
		}
	logfile.add("modefax: line=%d",displayLineCounter);
	displayLineCounter++;
}

embState modeFAX::txSetupLine(uint &subln)
{
}

void modeFAX::getLine()
{
}

bool modeFAX::getPixels()
{
	int color;
	double dev=activeFAXParam.deviation*2;
	double fc=activeFAXParam.subcarrier;
	if(sampleCounter>=pixelPositionTable[pixelCounter])
		{
			if(activeFAXParam.modulation== DEMODAM)
				{
					color=(int)sample;
				}
			else
				{
					color=(int)(255.*((sample-(fc-dev/2))/dev));
				}
			if(color<0) color=0; if (color>255) color=255;
			pixelArrayPtr[pixelCounter]=(unsigned char)color;
			pixelCounter++;
			if(pixelCounter>=activeFAXParam.numberOfPixels)
				{
//					qDebug("sc=%u",sampleCounter);
					return TRUE;
				}
		}

	return FALSE; // indicate, it's not the end of the line
}



