% QWDCTL(1)
% Roland Mas
% April 2021

# NAME

qwdctl - Control qemu-web-desktop

# SYNOPSIS

**qwdctl** *keyword*

# DESCRIPTION

**qwdctl** is a simple script that downloads virtual machine images
for use with **qemu-web-desktop** and/or refreshes the list of
available images so that **qemu-web-desktop** can display it in its
web interface. Additionally, mount points can be made available for the guests
via the '9p' protocol (see https://wiki.qemu.org/Documentation/9psetup).

Each entry in the configuration file `/etc/qemu-web-desktop/machines.conf` 
spans on 3 lines:

-  [name.ext] 
-  url=[URL to ISO, QCOW2, VDI, VMDK, RAW virtual machine disk, optional]
-  description=[description to be shown in the service page] 

Images listed in the configuration file without a `url=` parameter are
expected to be downloaded by hand and installed into
`/var/lib/qemu-web-desktop/machines` by the local administrator. Then, just 
specify the [name.ext] and description.

You may as well define mounts from the host into the guest with:

- [/path/to/mount/in/server]
- mount=[name of mount to appear in the service page]

The last word of the path defines a '9p' tag 'host_[lastword]' mountable in the guest. 
Then, mount it in the guest with e.g.:
- mount -t 9p -o trans=virtio,access=client host_[lastword] [mount point]


# SUBCOMMANDS

**download**
:   Downloads virtual machine images referenced in the
    `/etc/qemu-web-desktop/machines.conf` file. A **refresh** is automatically
    launched afterwards.

**refresh**
:   Regenerates the list of available images and mounts based on the
    `/etc/qemu-web-desktop/machines.conf` file. 
    The generated file is e.g. `/var/lib/qemu-web-desktop/machines.html`. The mount 
    points are stored in `/var/lib/qemu-web-desktop/mounts.html`. Both files 
    should be linked as `/usr/share/qemu-web-desktop/html/desktop/

# FILES

- /etc/qemu-web-desktop/machines.conf
- /var/lib/qemu-web-desktop/machines.html
- /var/lib/qemu-web-desktop/mount.html
- /var/lib/qemu-web-desktop/machines
- /usr/share/qemu-web-desktop/html/desktop
