/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef QCHATSERVER_H
#define QCHATSERVER_H

#include <QObject>
#include <QList>
#include <QTcpServer>

#include "user.h"

#include "abstractchatcore.h"
#include "qchatserversocket.h"

class MsgHistory;
class Message;

/**
        @author Anistratov Oleg <ower86@gmail.com>
*/
class QChatServer : public QObject, public AbstractChatCore
{
  Q_OBJECT
  private:
    char*                           m_buffer;
    int                             m_bufferSize;
    QMap<QChatServerSocket*, User*> m_users;
    QTcpServer                      m_server;
    QList<QChatServerSocket*>*      m_newConnections;
    QString                         m_welcomeMessage;
    uint                            m_nextUid;
    QMap<QString, MsgHistory*>      m_channelsHistory;
    QList<QString>                  m_bannedLogins;
    QList<QHostAddress>             m_bannedIPs;
    QChatServerSocket*              m_currentSocket;

  public:
    QChatServer(QObject *parent = 0);
    ~QChatServer();

    QString checkLogin(const QString &);
    void canLogin();
    uint login(QChatServerSocket*, const QString&);

    void rejectLogin(QChatServerSocket*, const QString &);
    int  sendData(QChatServerSocket*, uint = 0);

    void addMessage(const QString& channel, Message* msg);

    void msgsHistoryAnswer(const QString & ch_name_id, quint64 uid, const QByteArray & msgs, AbstractChatCore::ChannelType type, QChatServerSocket*);

    void msgsNumAnswer(const QString & ch_name_id, quint64 uid, QChatServerSocket*);

    void setUserLogin(const QString&);

    void sendInstruction(const QString&, const QString&);

    void kickUser    (const QString&);
    void banUser     (const QString&);
    void unbanUser   (const QString&);
    void kickIp      (const QString&);
    void banIp       (const QString&);
    void unbanIp     (const QString&);

    void processInstructions(int);

  public slots:
    void processNewConnections();
    void processDisconnect();
    void processNewData();
};

#endif
