###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_easy_rmtomp3_conv_bof_vuln.nasl 1825 2009-04-28 20:07:05Z apr $
#
# Easy RM to MP3 Converter Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900633);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1330");
  script_bugtraq_id(34514);
  script_name("Easy RM to MP3 Converter Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with Easy RM to MP3 Converter and is prone
  to Buffer Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to improper boundary checking while the user supplies
  the input to the application by opening any crafted playlist file.

  Impact:
  Successful exploitation will let the attacker craft a malicious playlist file
  and can cause denial of service in the context of the affected system.

  Impact Level: Application

  Affected Software/OS:
  Easy RM to MP3 Converter version 2.7.3.700 on Windows.

  Fix: No solution or patch is available as on 29th April, 2009.Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.rm-to-mp3.net

  References:
  http://www.milw0rm.com/exploits/8427
  http://secunia.com/advisories/34653

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the version of Easy RM to MP3 Converter");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_easy_rmtomp3_conv_detect.nasl");
  script_require_keys("EasyRmtoMp3/Conv/Ver");
  exit(0);
}


include("version_func.inc");

easyVer = get_kb_item("EasyRmtoMp3/Conv/Ver");
if(easyVer != NULL)
{
  if(version_is_less_equal(version:easyVer, test_version:"2.7.3.700")){
    security_hole(0);
  }
}
