###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_money_detect.nasl 812 2009-01-07 13:30:24Z jan $
#
# Microsoft Money Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800217);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Microsoft Money Version Detection");
  desc = "
  Overview : This script finds the installed Microsoft Money Version and
  saves in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of Microsoft Money in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Microsoft\Money")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  if("Microsoft Money" >< registry_get_sz(key:key + item, item:"DisplayName"))
  {
    name = registry_get_sz(key:key + item, item:"DisplayName");
    ver = eregmatch(pattern:"Microsoft Money ([0-9]+)", string:name);
    if(ver[1] != NULL)
    {
      set_kb_item(name:"MS/Money/Version", value:ver[1]);
      security_note(data:"Microsoft Money version " + ver[1] + " was detected"
                                        + " on the host");
    }
    exit(0);
  }
}
