###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for Thunar FEDORA-2007-4385
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861446);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-4385");
  script_name( "Fedora Update for Thunar FEDORA-2007-4385");
  desc = "

  Vulnerability Insight:
  Thunar is a new modern file manager for the Xfce Desktop Environment.
  It has been designed from the ground up to be fast and easy-to-use.
  Its user interface is clean and intuitive, and does not include any
  confusing or useless options. Thunar is fast and responsive with a
  good start up time and directory load time.


  Affected Software/OS:
  Thunar on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00531.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Thunar");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"Thunar", rpm:"Thunar~0.9.0~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"Thunar-debuginfo", rpm:"Thunar-debuginfo~0.9.0~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"Thunar", rpm:"Thunar~0.9.0~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"Thunar-devel", rpm:"Thunar-devel~0.9.0~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"Thunar-devel", rpm:"Thunar-devel~0.9.0~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"Thunar", rpm:"Thunar~0.9.0~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"Thunar-debuginfo", rpm:"Thunar-debuginfo~0.9.0~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}