#
#VID a5742055-300a-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52313);
 script_bugtraq_id(11448);
 script_cve_id("CVE-2004-1096");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: p5-Archive-Zip";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: p5-Archive-Zip

The Archive::Zip Perl module, when used by antivirus
programs such as amavisd-new, allows remote attackers
to bypass antivirus protection via a compressed file
with both local and global headers set to zero, which
does not prevent the compressed file from being opened
on a target system.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.idefense.com/application/poi/display?id=153&type=vulnerabilities
http://www.amavis.org/security/asa-2004-6.txt
http://rt.cpan.org/NoAuth/Bug.html?id=8077
http://www.vuxml.org/freebsd/a5742055-300a-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: p5-Archive-Zip";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"p5-Archive-Zip");
if(!isnull(bver) && revcomp(a:bver, b:"1.14")<0) {
    security_note(0, data:"Package p5-Archive-Zip version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
