# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2008-10755 (am-utils)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63130);
 script_cve_id("CVE-2008-1078");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 9 FEDORA-2008-10755 (am-utils)";
 script_name(name);

 desc = "The remote host is missing an update to am-utils
announced via advisory FEDORA-2008-10755.

ChangeLog:

* Tue Dec  2 2008 Karel Zak  5:6.1.5-8.1
- fix #450754 - Amd does not work with 2.6.25 (thanks to Philippe Troin)
- fix #435420 - CVE-2008-1078 am-utils: insecure usage of temporary files
- fix autotools stuff

References:

[ 1 ] Bug #435420 - CVE-2008-1078 am-utils: insecure usage of temporary files
https://bugzilla.redhat.com/show_bug.cgi?id=435420

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update am-utils' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2008-10755

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2008-10755 (am-utils)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"am-utils", rpm:"am-utils~6.1.5~8.1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"am-utils-debuginfo", rpm:"am-utils-debuginfo~6.1.5~8.1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
