# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 429-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53137);
 script_bugtraq_id(9115);
 script_cve_id("CVE-2003-0971");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 429-2 (gnupg)";
 script_name(name);

 desc = "The remote host is missing an update to gnupg
announced via advisory DSA 429-2.

Phong Nguyen identified a severe bug in the way GnuPG creates and uses
ElGamal keys for signing.  This is a significant security failure
which can lead to a compromise of almost all ElGamal keys used for
signing.

The update provided in DSA 459-1 disables the use of this type of key,
using an interim fix.  This update, DSA 459-2, implements a more
correct and permanent fix provided by David Shaw.

For the current stable distribution (woody) this problem has been
fixed in version 1.0.6-4woody3.

We recommend that you update your gnupg package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20429-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 429-2 (gnupg)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnupg", ver:"1.0.6-4woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
