# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 2012-1 (linux-2.6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(67036);
 script_cve_id("CVE-2009-3725", "CVE-2010-0622");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 2012-1 (linux-2.6)");

 desc = "The remote host is missing an update to linux-2.6
announced via advisory DSA 2012-1.

Two vulnerabilities have been discovered in the Linux kernel that
may lead to a denial of service or privilege escalation. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2009-3725

Philipp Reisner reported an issue in the connector subsystem
which allows unprivileged users to send netlink packets. This
allows local users to manipulate settings for uvesafb devices
which are normally reserved for privileged users.

CVE-2010-0622

Jermome Marchand reported an issue in the futex subsystem that
allows a local user to force an invalid futex state which results
in a denial of service (oops).

This update also includes fixes for regressions introduced by previous
updates. See the referenced Debian bug pages for details.

For the stable distribution (lenny), this problem has been fixed in
version 2.6.26-21lenny4.

We recommend that you upgrade your linux-2.6 and user-mode-linux

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%202012-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 2012-1 (linux-2.6)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"linux-support-2.6.26-2", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-manual-2.6.26", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-source-2.6.26", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-patch-debian-2.6.26", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-doc-2.6.26", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-tree-2.6.26", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-alpha-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-alpha", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-alpha-legacy", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-alpha-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-alpha-generic", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-alpha-legacy", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-alpha-generic", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common-xen", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.26-2-xen-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common-vserver", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-openvz-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-xen-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-xen-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-openvz-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.26-2-xen-amd64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-common-openvz", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-arm", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-footbridge", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-ixp4xx", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-iop32x", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-orion5x", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-iop32x", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-orion5x", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-ixp4xx", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-footbridge", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-versatile", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-armel", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-versatile", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-hppa", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc64-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc64-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-parisc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-parisc-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-686-bigmem", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-modules-2.6.26-2-xen-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-686-bigmem", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-486", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-686-bigmem", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-i386", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-openvz-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xen-linux-system-2.6.26-2-xen-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-486", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-xen-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-686-bigmem", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-openvz-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-xen-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-686", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-itanium", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-ia64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-mckinley", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-mckinley", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-itanium", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-itanium", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-mckinley", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-mckinley", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-itanium", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-r5k-ip32", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-sb1-bcm91250a", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-sb1a-bcm91480b", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-5kc-malta", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-r5k-ip32", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-5kc-malta", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-mips", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-4kc-malta", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-sb1-bcm91250a", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-r4k-ip22", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-4kc-malta", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-r4k-ip22", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-sb1a-bcm91480b", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-r5k-cobalt", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-mipsel", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-r5k-cobalt", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-powerpc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-powerpc", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-powerpc", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-powerpc-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-powerpc", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-powerpc-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-powerpc", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-powerpc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-powerpc", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-powerpc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-powerpc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-s390-tape", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-s390", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-s390", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-s390x", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-s390", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-s390x", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-s390x", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-s390x", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-vserver-sparc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-vserver-sparc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-sparc64-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-sparc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-sparc64", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-image-2.6.26-2-sparc64-smp", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"linux-headers-2.6.26-2-all-sparc", ver:"2.6.26-21lenny4", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
