/*****************************************************************************
*                                                                            *
*  OpenNI 2.x Alpha                                                          *
*  Copyright (C) 2012 PrimeSense Ltd.                                        *
*                                                                            *
*  This file is part of OpenNI.                                              *
*                                                                            *
*  Licensed under the Apache License, Version 2.0 (the "License");           *
*  you may not use this file except in compliance with the License.          *
*  You may obtain a copy of the License at                                   *
*                                                                            *
*      http://www.apache.org/licenses/LICENSE-2.0                            *
*                                                                            *
*  Unless required by applicable law or agreed to in writing, software       *
*  distributed under the License is distributed on an "AS IS" BASIS,         *
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
*  See the License for the specific language governing permissions and       *
*  limitations under the License.                                            *
*                                                                            *
*****************************************************************************/
#ifndef __NICODECIDS_H__
#define __NICODECIDS_H__

/** Define a Codec ID by 4 characters, e.g. XN_CODEC_ID('J','P','E','G') **/
#define XN_CODEC_ID(c1, c2, c3, c4) (XnCodecID)((c4 << 24) | (c3 << 16) | (c2 << 8) | c1)

#define XN_CODEC_NULL				XN_CODEC_ID(0, 0, 0, 0)
#define XN_CODEC_UNCOMPRESSED		XN_CODEC_ID('N','O','N','E')
#define XN_CODEC_JPEG				XN_CODEC_ID('J','P','E','G')
#define XN_CODEC_16Z				XN_CODEC_ID('1','6','z','P')
#define XN_CODEC_16Z_EMB_TABLES		XN_CODEC_ID('1','6','z','T')
#define XN_CODEC_8Z					XN_CODEC_ID('I','m','8','z')

#endif // __NICODECIDS_H__
