/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLTest/Thread.h"

#include <unistd.h>

#ifdef GTLTEST_HAVE_THREAD

class MyThreadTCTLRT : public GTLTest::Thread
{
  public:
    MyThreadTCTLRT(const GTLCore::Function* _function) : m_stop(false), m_function(_function)
    {
    }
    void stop()
    {
      m_stop = true;
    }
  protected:
    virtual void run()
    {
      std::vector< GTLCore::Value> arguments;
      while(not m_stop)
      {
        m_function->call( arguments );        
      }
    }
  private:
    bool m_stop;
    const GTLCore::Function* m_function;
};

class TestRuntimeThreading : public GTLTest::Case {
  public:
    TestRuntimeThreading() : GTLTest::Case("RuntimeThreading")
    {
    }
    virtual void runTest()
    {
      OpenCTL::Module p;
      p.setSource( "testCall", " \
void testCall() \
{ \
  int a[5]; \
  a[0] = 1; \
  a[1] = -1; \
  a[2] = -2; \
  a[3] = 2; \
  a[4] = 3; \
}");
      p.compile();
      GTLTEST_CHECK_REQUIRED(p.isCompiled());
      const GTLCore::Function* function = p.functions("testCall").front();
      GTLTEST_CHECK_REQUIRED(function);
      MyThreadTCTLRT thread1(function);
      thread1.start();
      MyThreadTCTLRT thread2(function);
      thread2.start();
      MyThreadTCTLRT thread3(function);
      thread3.start();
      MyThreadTCTLRT thread4(function);
      thread4.start();
      MyThreadTCTLRT thread5(function);
      thread5.start();
      MyThreadTCTLRT thread6(function);
      thread6.start();
      sleep(3);
      thread1.stop();
      thread2.stop();
      thread3.stop();
      thread4.stop();
      thread5.stop();
      thread6.stop();
      thread1.wait();
      thread2.wait();
      thread3.wait();
      thread4.wait();
      thread5.wait();
      thread6.wait();
    }
};
#endif
