/*
 * Copyright 2002-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.messaging.handler.annotation.support;

import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;

/**
 * Base class for exceptions resulting from the invocation of
 * {@link org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver}.
 *
 * @author Rossen Stoyanchev
 * @since 4.0.3
 * @deprecated as of 4.3.6, in favor of the invocation-associated
 * {@link MethodArgumentResolutionException}
 */
@Deprecated
@SuppressWarnings("serial")
public abstract class AbstractMethodArgumentResolutionException extends MethodArgumentResolutionException {

	protected AbstractMethodArgumentResolutionException(Message<?> message, MethodParameter parameter) {
		super(message, parameter);
	}

	protected AbstractMethodArgumentResolutionException(Message<?> message, MethodParameter parameter, String description) {
		super(message, parameter, description);
	}


	protected static String getMethodParamMessage(MethodParameter param) {
		return "";
	}

}
