/* ----- encode/761xfreeze3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_761xfreeze3_checksums[] = {
  "86a1be02df02f23f8ca5945147a0828fcf2fca756cb71c59f23c8e77ad236fbd",
  "eea69494ef8944ba675ce29a3b004c6e03e1356459dcd1e7bf0afd07d8a62b62",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_761xfreeze3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_761xfreeze3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_761xfreeze3_ITEMBYTES

static void *storage_encode_761xfreeze3_s;
static unsigned char *test_encode_761xfreeze3_s;
static void *storage_encode_761xfreeze3_x;
static unsigned char *test_encode_761xfreeze3_x;
static void *storage_encode_761xfreeze3_s2;
static unsigned char *test_encode_761xfreeze3_s2;
static void *storage_encode_761xfreeze3_x2;
static unsigned char *test_encode_761xfreeze3_x2;

#define precomputed_encode_761xfreeze3_NUM 4

static const unsigned char precomputed_encode_761xfreeze3_s[precomputed_encode_761xfreeze3_NUM][crypto_encode_STRBYTES] = {
  {1,0,1,255,1,2,255,2,255,0,1,0,254,1,255,1,2,0,0,1,255,2,1,0,0,0,1,0,0,1,1,0,2,255,0,0,0,255,1,255,0,0,0,2,255,0,255,255,0,0,255,254,0,2,1,2,0,2,0,0,2,254,0,255,1,254,255,0,255,255,1,255,0,1,2,1,1,254,255,0,0,2,0,1,0,0,0,255,0,1,1,0,0,0,255,0,0,254,0,255,0,255,255,0,254,0,0,255,1,0,254,1,1,2,0,1,0,255,1,254,0,255,0,1,2,0,0,0,255,2,0,1,0,0,255,0,0,254,255,0,255,0,255,255,1,0,254,1,2,1,0,255,1,255,254,2,2,255,1,0,0,255,255,1,0,255,255,0,1,255,0,0,255,0,0,0,255,1,0,255,0,0,1,255,0,255,254,255,1,1,0,0,0,254,1,255,254,255,0,255,255,255,255,255,255,0,255,1,1,0,1,0,0,0,1,0,0,0,255,255,1,255,1,255,1,0,0,255,2,255,255,0,0,255,255,0,1,1,0,1,255,255,255,2,0,255,254,1,1,255,0,0,1,255,255,1,2,1,1,254,254,1,2,255,2,255,0,255,0,255,1,1,254,255,255,0,1,0,0,1,1,254,0,0,0,0,0,254,0,0,255,0,255,254,0,0,0,0,0,0,254,1,1,0,255,255,1,0,0,255,2,0,1,1,255,255,0,255,2,255,2,0,1,0,254,255,0,254,255,0,1,255,1,255,255,255,0,255,255,0,1,255,2,1,0,1,1,254,0,255,255,1,0,2,255,0,0,2,255,1,255,0,1,1,255,255,1,0,0,1,0,0,1,0,255,0,1,0,0,0,0,0,254,255,2,255,0,0,254,1,1,1,1,1,255,255,1,1,0,1,255,1,0,255,255,0,0,2,0,255,0,255,0,0,1,255,0,1,255,255,254,255,255,0,0,0,0,255,0,255,0,0,0,0,1,255,1,0,1,0,1,0,1,0,254,0,255,0,0,254,1,0,2,1,1,0,0,1,0,2,1,1,255,1,255,2,1,255,255,255,255,255,255,1,0,255,255,254,255,255,255,0,2,255,0,2,1,1,255,0,0,255,255,0,255,0,2,255,0,1,255,1,255,255,0,1,2,0,254,0,0,1,1,0,0,255,1,1,254,0,0,0,255,255,0,254,2,0,255,255,2,254,1,0,0,0,254,0,1,255,0,0,255,1,255,0,0,1,1,1,0,255,1,0,0,0,0,1,0,255,0,255,0,0,1,1,0,255,0,255,255,1,0,2,254,255,0,1,0,1,0,1,1,0,0,254,0,1,1,0,1,0,1,255,0,255,255,254,255,1,0,2,255,255,1,0,255,254,1,255,2,0,254,0,255,1,0,255,0,0,255,1,0,254,255,0,0,0,1,0,255,1,0,0,255,255,0,1,254,1,1,0,1,255,0,1,0,0,0,255,1,255,0,0,254,1,255,255,0,0,255,0,0,255,0,1,255,255,254,255,1,0,255,255,1,0,1,254,1,255,255,255,0,0,0,0,255,254,1,255,255,0,255,255,0,1,1,255,2,254,1,255,1,254,0,0,0,255,1,0,254,255,255,0,254,255,255,0,2,0,2,255,255,2,0,0,2,1,2,0,255,1,255,255,255,1,254,0,1,0,0,1,1,2,0,1,255,0,2,0,254,254,0,2,1,0,0,2,1,1,254},
  {0,0,1,0,0,255,254,1,2,255,1,1,1,1,0,1,0,255,254,1,0,254,0,1,0,0,255,0,2,0,0,254,0,2,1,1,2,0,255,0,1,255,254,0,1,254,254,2,255,0,1,1,0,1,255,0,0,0,0,0,0,0,255,1,0,1,255,2,255,0,0,255,0,254,0,1,1,0,255,0,1,0,0,254,255,2,255,2,2,2,255,1,255,0,0,1,0,0,255,1,254,1,0,255,255,0,0,0,0,1,255,0,1,255,0,255,2,255,255,0,0,1,0,0,0,0,255,0,1,255,1,254,0,255,2,254,1,0,1,255,255,0,254,0,0,1,255,0,255,254,255,2,0,1,1,0,1,0,1,2,1,255,0,0,1,255,2,1,1,255,0,0,255,0,255,254,1,255,254,0,0,0,1,1,255,1,255,1,255,0,1,255,254,0,255,254,1,254,0,2,0,254,2,254,255,255,255,0,0,1,255,254,1,254,2,2,0,0,0,255,255,255,2,0,2,1,254,255,0,254,255,2,1,2,1,1,1,254,1,255,0,1,255,0,254,255,0,255,254,255,255,1,0,255,1,0,255,0,1,255,1,1,1,2,0,255,0,0,0,1,254,0,1,0,255,0,1,1,0,255,0,0,1,1,0,255,0,1,0,1,254,0,1,254,0,2,255,1,1,0,0,0,255,255,254,0,0,255,0,0,0,0,0,0,0,0,0,255,2,255,255,0,0,1,255,255,1,255,1,1,1,255,1,2,1,0,0,1,255,0,1,0,255,2,1,1,1,0,0,255,1,255,2,255,254,1,1,1,0,0,0,1,0,0,0,0,0,0,2,255,255,255,255,1,0,255,1,254,255,1,0,254,1,1,1,255,0,2,255,2,255,1,1,0,0,0,255,2,2,255,255,1,0,0,1,0,2,2,0,1,255,1,1,255,255,255,0,1,255,1,254,0,0,255,255,1,0,0,0,0,255,254,0,1,0,0,255,0,0,255,255,0,0,0,0,2,254,0,1,1,255,2,255,2,255,0,255,1,2,0,254,1,255,0,1,1,1,1,0,0,1,0,255,254,1,0,255,0,255,1,0,255,1,2,2,1,2,2,255,255,1,1,255,255,0,0,1,2,255,0,254,255,1,255,255,1,0,0,0,0,0,254,0,254,255,1,0,2,254,1,1,0,0,0,255,1,1,0,255,0,255,0,0,255,0,255,1,0,0,0,2,1,0,2,1,1,2,255,255,1,255,1,255,1,0,1,0,0,255,0,0,1,1,0,0,1,255,254,1,255,0,1,255,1,254,255,0,255,1,1,1,2,255,0,0,0,255,255,2,0,2,2,1,254,255,0,255,255,0,1,0,0,255,0,0,255,0,0,1,1,0,254,0,1,255,255,254,0,0,0,0,0,255,0,255,0,0,1,0,1,0,2,0,1,1,255,0,255,255,255,0,0,0,2,1,254,0,1,255,0,0,0,2,1,1,1,0,0,254,1,0,255,1,254,254,0,1,0,0,1,255,255,1,2,254,0,0,0,255,0,2,255,254,0,0,2,0,1,0,255,255,255,1,255,255,255,0,1,1,0,1,1,0,0,0,0,0,1,255,0,1,255,1,1,255,0,0,0,255,0,0,1,0,0,255,0,0,254,2,255,1,2,255,0,0,1,255,255,255,254,0,255,1,254,255,255,254,1,255,1,1,255,254,0,0,255,1,254,2,1,0},
  {255,255,255,0,255,1,0,255,1,254,0,0,0,255,255,0,255,0,1,0,255,0,254,0,0,1,255,1,255,254,1,2,255,1,1,1,1,0,255,255,254,1,1,1,255,254,1,2,1,0,2,0,0,255,254,1,255,0,2,1,1,1,255,0,0,1,2,0,0,254,0,1,254,1,1,0,1,0,255,0,0,255,0,255,255,254,0,0,2,0,1,255,255,255,254,0,255,1,1,255,255,0,1,1,255,0,2,0,255,1,0,0,0,2,0,254,254,1,255,1,1,254,0,255,2,2,0,0,1,255,1,255,1,0,1,0,254,255,1,255,0,0,2,1,0,255,0,254,0,1,254,1,1,1,255,255,255,2,0,255,255,1,0,0,1,2,254,2,2,1,2,255,0,255,1,1,0,0,2,0,0,2,255,1,0,0,0,2,1,255,0,0,2,254,1,255,254,254,255,255,254,0,2,255,255,2,254,255,255,1,1,0,1,0,255,0,255,0,1,0,1,255,0,0,0,255,254,255,0,1,1,0,255,2,0,255,0,255,1,255,1,0,1,0,2,0,255,0,255,255,0,1,255,255,255,0,0,255,1,0,254,254,255,2,255,1,1,0,0,0,255,0,1,1,255,254,0,255,0,0,1,1,2,255,0,255,0,1,1,0,0,0,1,0,1,255,255,254,2,255,2,0,1,255,254,254,254,254,254,254,0,0,255,0,255,0,1,0,255,255,2,1,255,0,1,1,255,0,1,0,2,1,1,0,2,255,0,2,2,2,255,255,254,255,1,1,0,2,1,255,1,1,254,255,255,255,2,0,1,1,1,255,255,0,0,255,0,255,2,0,255,0,1,2,2,0,1,255,1,1,1,1,0,254,0,1,0,0,0,0,0,1,1,0,1,1,0,2,255,1,1,255,1,255,1,255,255,255,1,0,1,0,255,255,0,2,1,255,255,2,255,1,0,255,0,0,1,1,2,0,0,1,0,1,254,1,2,255,0,0,254,1,1,1,255,255,0,0,0,255,1,255,0,0,0,0,255,255,0,0,0,2,2,0,0,1,255,1,1,1,255,255,255,0,1,254,0,1,255,0,1,0,0,1,1,1,2,254,0,0,0,254,1,0,1,1,1,1,0,255,255,1,1,1,255,0,2,1,0,1,0,255,0,1,0,1,0,1,1,1,1,1,0,255,1,2,2,255,1,1,2,0,255,1,1,1,2,1,0,2,1,254,0,255,0,255,0,255,0,255,0,2,0,1,255,1,1,0,0,255,0,2,0,0,1,255,0,0,255,1,255,255,2,255,1,255,1,255,254,0,254,255,255,0,255,254,0,0,2,1,2,2,0,1,254,0,2,255,2,0,1,255,255,0,2,254,1,0,254,0,0,255,255,0,1,0,0,0,255,2,2,1,1,0,0,0,2,1,1,0,1,1,255,0,0,254,0,0,255,254,0,0,255,0,255,1,0,0,254,0,254,0,1,2,0,255,255,254,0,0,0,1,254,254,255,255,0,0,0,1,254,255,0,2,255,255,2,1,1,0,0,1,0,0,2,1,2,0,1,0,0,254,0,1,254,0,255,0,254,255,255,0,255,0,1,1,0,0,254,0,255,1,2,1,0,1,0,0,1,255,2,255,1,255,255,0,254,255,255,0,1,2,255,0,2,1,0,255,1,1,255,0,254,255,254,255,255,1,0,254,1,2,1,255,1,0,0,255,255,1,0},
  {254,1,1,2,0,1,255,0,255,1,0,255,0,0,0,255,1,1,0,1,255,0,0,2,255,2,2,2,0,1,255,0,0,1,1,0,1,255,0,255,1,255,0,255,254,255,0,254,1,1,0,1,255,255,1,255,0,0,1,0,1,255,1,1,0,255,1,1,255,0,255,1,0,0,255,0,2,1,1,2,0,2,1,255,1,1,0,0,1,0,0,1,255,0,0,0,255,0,0,255,1,1,255,0,0,255,255,1,1,2,0,0,1,0,1,1,0,1,0,2,0,255,1,254,0,2,254,0,254,0,254,1,255,0,1,1,0,255,1,0,1,0,255,1,0,1,1,0,0,2,255,0,2,2,0,0,1,2,255,2,255,255,1,0,0,0,255,255,2,255,254,0,255,254,0,0,255,254,1,1,1,0,255,0,255,0,0,1,0,2,254,1,1,255,1,1,2,255,254,254,2,1,255,2,0,0,0,1,1,255,2,0,255,1,0,2,255,1,1,1,255,0,1,0,0,254,1,255,0,255,254,0,0,0,2,255,255,255,255,255,255,1,1,0,0,2,255,1,255,1,0,0,0,1,1,254,1,0,2,1,2,2,255,255,0,0,0,0,2,0,0,0,1,0,1,0,0,2,254,255,0,1,1,255,0,254,2,255,255,0,1,0,2,0,255,255,255,0,0,1,0,0,1,0,255,1,255,255,0,255,254,0,0,0,1,1,255,2,0,0,1,0,1,1,255,0,0,0,0,1,1,0,0,1,0,2,0,255,0,1,255,2,255,0,1,255,0,2,1,1,0,2,255,1,255,2,255,1,254,0,254,0,254,1,0,254,255,0,0,0,0,255,1,0,255,255,0,255,1,1,255,2,1,1,255,0,0,1,0,0,2,1,254,1,255,0,1,0,255,255,1,255,254,0,255,255,1,2,0,1,255,254,0,255,254,2,0,1,255,0,1,1,1,255,0,255,0,254,2,0,0,0,0,255,0,255,0,255,0,2,0,0,255,254,0,0,0,1,255,1,0,0,254,255,0,2,255,255,1,255,1,255,0,254,1,255,2,255,0,0,2,254,1,255,1,0,255,1,0,255,0,0,1,1,0,1,255,255,255,255,1,1,0,1,0,2,255,255,0,2,0,255,0,255,0,0,254,1,0,255,1,0,1,1,1,2,0,254,1,0,255,1,0,0,0,1,0,254,255,255,0,254,255,0,1,0,0,1,0,255,255,0,0,255,255,2,254,0,2,0,254,255,1,2,0,2,0,1,2,0,1,1,0,2,0,0,0,1,0,0,0,2,0,2,255,255,255,255,0,2,1,255,0,255,255,0,1,1,0,254,0,0,255,0,0,255,255,0,0,1,0,0,255,2,1,1,255,1,0,255,1,255,254,1,0,1,255,1,0,1,0,1,255,1,254,0,255,0,0,255,0,2,255,255,1,255,1,255,255,0,255,255,0,1,255,0,255,1,2,1,2,255,1,255,0,0,0,0,1,0,0,0,255,0,0,0,0,254,1,0,0,255,255,1,0,1,254,1,2,0,2,0,1,1,1,255,1,255,0,0,2,0,2,1,255,0,0,255,1,1,254,255,1,0,0,0,0,0,0,1,1,0,1,0,255,0,254,255,0,0,1,0,255,254,0,1,1,0,1,0,255,0,0,255,2,255,255,2,1,1,0,255,0,0,1,1,1,1,2,255,0,255,0,0,1,0,0,0,1,255,1},
} ;

static const int16_t precomputed_encode_761xfreeze3_x[precomputed_encode_761xfreeze3_NUM][crypto_encode_ITEMS] = {
  {-27413,23394,-10631,-7306,-10499,-32089,20882,-22609,-13018,-28578,-4385,-1839,29404,13069,18095,-2438,-30805,30048,19329,-6803,-4975,-30181,10672,30816,22791,21408,-212,-20175,-30993,-8453,7258,27852,-20938,3584,6369,8349,21876,-13,-3497,6800,7494,-11565,-16590,-21781,18683,-2616,-10978,-11098,-2199,23202,8927,30796,-15645,-22525,-27686,-23392,-27753,-29500,8361,-13224,-27016,28555,12210,25568,-20114,24538,19562,12312,-12787,16844,-16178,-1072,-8817,142,-22759,-13535,-19715,32599,16400,-29025,-6654,-24358,-29469,-6917,-4923,-23967,-16692,22319,-2985,12391,-32525,12564,18636,-150,32294,684,10398,29557,28368,25589,-29673,5333,10112,-2361,16663,19263,-26040,1427,-4391,26211,24130,8251,-31274,-22303,-10740,12646,3654,-8503,-20240,20053,-2928,12251,-31182,-24452,-17272,18870,-11166,16512,13175,-28006,-3789,1243,-25545,-1851,31727,1542,-25938,17233,-13096,21807,-7552,6999,16235,8498,1780,13476,18400,-3686,-21193,14656,-27789,206,10570,27719,25783,-27901,-24883,24791,3241,27135,15909,-13123,4211,-24965,23508,26060,26111,8853,-11021,30923,29289,-26055,27281,1290,13479,15600,13727,-4136,2751,22103,-23574,28836,-32648,-15046,15801,-13288,26293,16700,-23846,7747,31983,22605,20106,18190,-8861,-15949,22144,13892,24132,-5599,1388,30524,1913,32447,19397,28854,17147,-24311,-30998,24186,-16256,-21885,19014,12741,-1535,32559,-11655,-25287,29942,1406,9961,-4768,13051,-199,2983,14877,16101,31991,-32242,-14611,-8119,27444,9666,15695,-8299,12564,1396,10405,10797,-13055,-4039,-1555,24260,-28735,-25842,24356,28060,-1136,10543,18020,-6678,-9330,-9182,17336,10688,-13091,-19627,-4019,9250,22696,28183,-2267,-20317,764,-17821,25052,31350,10352,4830,-13786,-23174,-4997,30169,-8437,-8344,18687,-20228,24678,-201,-14639,-31337,22855,-15390,14316,25155,-13281,20601,17818,18339,-5433,26018,4002,-7333,24673,-14343,-5496,-3477,16260,-27480,-28743,27844,6052,6367,-19368,9797,-1387,16075,-18939,-17904,-12403,-22942,28965,-30404,-16934,13289,18164,-14490,4820,-31063,32300,-25687,29265,-9890,-7530,22039,27002,-18933,30352,28838,-4914,14533,19133,-19166,8477,-9676,19802,-15666,30323,19700,-12474,3460,15617,-16960,-3095,-29460,14281,-11144,22252,-20184,-8392,3902,-21773,-20013,-19249,-9082,-29451,-22836,-20131,-16252,-20417,509,-60,15742,-14789,28274,-8728,-21317,2016,-13323,-18326,-18717,-5532,-5543,12291,28442,-18033,13942,24189,-7131,16092,-19293,24300,19078,1649,-21136,-11449,21999,-4455,23887,-8366,-14447,-23084,-20609,1636,4814,4910,-11732,-17231,-17382,10138,25655,-2234,-846,11786,-10087,-8928,-4584,-32071,7650,29651,2196,16895,10524,18717,16351,16106,-8553,-19388,29,-604,21409,-14542,20174,-10896,19518,-31137,-8850,7697,9018,30080,20859,-9951,18855,-23214,-31589,10466,-14561,-4536,13057,14157,-12653,-21579,-9809,30915,32212,-23448,21800,12264,3900,21013,1369,-15279,-29122,-10775,-28241,-9843,-5151,5902,24921,-31177,-10700,-2246,-4852,-1193,-7804,-24910,559,-14800,25847,-9961,14570,1160,14555,11650,-1179,12365,16334,32035,-11179,13787,16208,24753,-19843,19883,17229,-17560,-11135,-16529,-3994,-17241,29367,-8446,10256,13272,17942,-3594,-32728,-10780,9300,-26951,10397,976,2333,-4795,-21852,12103,-31720,5394,24580,-29607,-18525,5287,-28757,-5148,20628,32327,14698,2104,32395,30732,-17901,-25977,5381,23564,-32427,32074,-29359,-11415,-14134,25826,-25978,16810,1798,-17253,-14649,26982,18517,-31032,-2936,-1783,-7839,21978,29114,5701,-5092,2151,25602,-29447,-15164,-32342,-3648,21557,11410,18753,27732,30351,6348,-7169,-11298,22358,-11847,26231,-11574,-14538,-32612,-3452,6132,-11794,26250,-1579,-11059,-23288,-4782,-22849,32113,16139,-16176,-17903,13962,-27947,15477,-17462,-28160,9144,-14166,24001,-36,-11711,-3293,-31644,7909,30876,-12803,425,-24390,5249,-16006,28129,30581,16309,-30390,-28834,1061,28970,-20711,-11727,-3583,16744,-27956,-7093,-30706,-23091,29338,21858,-9574,-1748,834,15587,16458,29562,-11839,-10868,13056,31696,25496,-11097,26352,-16806,-10766,21861,-7990,7735,-6795,7815,15491,1895,-32379,-28667,24325,-28505,-17294,-30729,-26693,-8734,2559,-4886,25653,29739,-2472,-10804,-23174,17855,2382,14874,29191,13153,15584,3017,-7002,29439,-11758,-30051,-15303,-3703,15504,-15527,-15829,27371,22741,-2122,-25994,-1989,1370,11888,-30116,-5085,14779,21994,1912,-1759,19445,20708,4020,-17715,16395,22584,26804,20113,-21404,-2188,28844,26196,71,-2629,24822,11521,15661,30359,-31225,22717,-18038,32429,-29432,22975,-3585,-1176,29718,-7087,7081,27720,25996,-2920,2108,4476,28516,16163,7832,-2232,-23596,-21726,-32239,5354,-13678,-31900,-7719,-18951,-30172,1516,-30499,18138,-10180,-15587,-13453,8132,3020,-9587,30385,21708,10738,-27294,14367,-19940,4636,-19045,13311,-2120,28742,-13347,-29125,-17502,26593,32764,-4926,-28336,-5348,31722,-543,-31624,12343,-17024,25888},
  {18600,-15099,-14003,-14784,-23292,12665,23773,10579,-22339,30746,-7787,2311,-30413,-10175,-27888,-14861,-24693,4142,29281,-6422,-30510,26164,7938,-2570,-32316,-25575,-127,8625,-28279,-28566,-24423,16756,21516,-21229,-26930,-13907,-28354,4230,20906,15870,-26207,-8479,23164,-12993,6850,27247,26548,-29764,17264,-25443,1381,-24632,1179,-16133,24341,18723,-16653,-2061,-12699,12240,-22206,-20430,21467,-18290,-1347,-22490,24335,-27229,13118,15687,29616,-13810,12816,23821,-24159,15229,-23054,-5664,25571,24744,-24260,-10878,16995,32380,18053,-28093,6104,-23680,-31858,-28993,6164,14839,4100,4755,24708,-20648,4782,-15747,12311,-21884,27451,-20855,-981,-6541,13337,22311,17838,-14097,-20808,-5795,6332,29394,10888,18725,26901,-1255,-22942,-9697,25412,-24786,22542,-14396,5529,825,-26487,12477,-12751,-13089,15727,-3148,2935,29104,28656,7820,-19930,18745,-7676,-7401,2005,16991,10514,27999,31291,-27189,26982,9436,5762,-6246,2903,25699,7868,-32497,1824,-29261,6124,4836,1285,1659,-1232,-30028,-8747,13121,969,-23286,-176,30725,-31348,-15368,9880,1046,24219,9129,20786,29361,22259,27586,-14858,-916,23128,7788,18162,31974,-7301,-23789,29906,-2048,4745,-22319,26348,27813,-7412,-9700,19081,-21663,-4951,25930,13711,27649,6411,-17560,4026,17368,-17290,31669,31628,116,-649,-16305,-2607,-995,413,26557,-19715,22969,-30985,-28771,-25632,2742,-10539,14954,-3715,15491,-17044,31560,-25639,994,31228,-7861,-15975,22915,12650,-26995,-14690,-30835,-8831,-23471,7981,17518,3679,9446,22848,385,-4435,23955,25309,23744,-25539,15296,30322,21998,29405,-21674,-29769,2411,-25478,-7407,11648,-3318,5896,-12589,-20639,-29420,-386,-30802,25593,5927,-10461,-4668,-25812,16285,26518,-5895,-983,-18768,17555,14097,-20246,10261,-31026,23504,27549,25149,-24101,-31841,-16728,7757,-29619,-6182,-13950,3529,32494,14616,-12152,29494,32028,-31837,19796,-12074,13417,16245,27000,19494,2783,18473,22330,-4284,11889,21761,-29952,-477,-32091,-6024,-31095,-22221,-14184,18525,-18426,-8167,-29563,9242,15584,5094,32763,1729,-5170,15095,3799,-13795,11866,-24341,2551,11720,-21053,-22531,-788,-31158,-17112,7060,29144,2247,-13553,31017,-13804,-28249,-15839,-29903,-23453,23727,12963,22433,-27161,-5857,-17830,19355,32416,15634,-25601,2215,-8421,-8151,-2511,682,-15498,-10680,-2181,-432,2469,-4218,-17383,16724,27080,32699,8063,-25214,-15921,22022,-27533,29332,21767,643,27057,20047,-22601,-12404,-30416,15395,-23790,-18394,21398,-21823,9563,-25553,-15374,24963,-21039,-20178,-10405,-28345,-17830,23045,-12994,397,-6432,21798,-14054,3864,-23926,-29299,-10092,-9287,-661,12445,-28400,-775,29975,25538,-16485,-14141,-607,-30821,23860,12267,14415,11540,-5530,5497,-21849,-11496,-9972,29868,12209,24196,14913,766,-19452,-26154,10760,12495,17484,24704,-6430,16026,-15501,-3294,13887,-23866,19309,-17772,-863,-3722,-11032,-18139,8687,-21127,2354,-8463,31280,-31157,-18289,-21276,23635,12115,899,27141,-5003,-12422,-7064,-23468,-18045,2622,-15899,-31071,-8623,18034,11290,23760,19715,-17820,2831,12430,28128,31208,-5837,-28117,-19198,7900,-21397,-16741,11438,-6634,15076,-12035,-2965,-13264,-7491,396,11581,-20749,-12613,-24258,32623,2987,-14822,3065,27791,-15635,393,26268,-32730,5613,9453,21214,-14229,21436,-6091,13066,9852,-31627,22351,-32204,-26336,-16686,15975,3903,6890,10705,-16052,-15096,29123,-13635,-12307,-4182,-1299,-5608,7578,21488,-725,27096,-31896,28119,-25396,-12290,-2265,-23452,-15050,11581,-24166,-5326,1064,-20516,17303,-29672,28292,-20207,-18933,-5072,-12666,-18279,19079,31995,-31209,8626,-22946,5175,-20265,-26186,12794,26794,-4139,6413,27315,-15995,15590,4075,31822,-5527,26451,11654,-17498,-11468,-30770,-23605,18059,-19161,-6669,-29607,23483,26135,-27550,-7410,-23716,-26548,9016,32287,-8353,30267,23759,15884,3141,-7916,31830,14907,1520,10242,-6528,-15013,16980,-6213,-479,-5813,-19794,29848,-10869,12253,18038,31298,16720,-4326,19473,-22212,28680,15156,6170,22326,17699,18816,3420,-2585,-16092,-1595,-26550,-19228,7719,8743,9319,14738,-28908,-8530,-12769,-4669,-26586,8001,9966,-18958,-25601,30595,20034,-28508,31451,29934,4785,15243,-32722,4063,2275,-18278,-27954,6969,19522,6883,26967,-14257,11284,30793,17152,12516,-26306,9825,21153,-19184,21593,25703,-21713,-18808,23083,25983,16653,-6546,1448,25722,-19156,3593,30502,23052,20046,-19588,-15471,-155,28692,22367,12971,24032,-31319,19985,15707,16316,4608,-10673,-1469,-14730,-11189,12880,-5064,2634,-22089,-7641,16470,6259,-2095,14967,-30551,-322,-5534,-18674,29633,1239,10791,-24234,32081,-30129,28089,-5195,-2472,-13962,21656,-21783,-30285,22906,-25906,-15364,-16670,-22291,26123,32067,2697,16183,18461,-262,27065,32095,22620,-11860,-24509,26377,25907,-1465,21958,-8525,-1189,-773,11566,-1984,29758,-8598,1071,16202,-32021,17791,-26545,-3959,-2805},
  {1016,11192,-10402,-2976,22802,-10130,-6402,665,1726,30211,12111,20421,6561,29585,17057,18564,-5959,-1194,-13208,4344,-12118,-15666,26719,3546,5289,3406,-10897,-28298,9767,27742,-2174,-28015,32015,10264,-18143,16240,-392,24441,-5119,10358,22393,-25754,-30308,-566,16382,26869,-18584,-19849,-27329,28686,-27619,18909,-28680,6965,27496,10894,689,-14412,-29266,-24824,-27347,-21140,3194,-11103,-6474,10903,-30040,-25107,-23778,27025,11001,8920,18010,-1577,-7352,15894,-2192,19491,-15754,-17985,25434,29033,-2040,26969,-5587,18517,-7341,-24699,-21814,-22281,12694,-1018,-11626,4922,29140,-12954,27581,-23300,-14555,11543,-2872,18132,-31277,13075,9794,1221,-28639,-435,22031,-2051,-26292,8130,636,-19963,-10233,18346,31210,-3278,-1189,-10334,11800,28927,19692,11459,-24820,-21715,-17262,3330,3331,-5434,-4679,-2275,-15530,17442,14785,27927,32155,24305,1804,31829,8736,8139,-20128,-24653,-6993,12155,12531,30736,25539,-27383,31687,7717,11950,-12116,-7372,26405,-14935,-17140,-16431,32291,1634,-5192,-17097,3645,-28097,-28219,30649,-26776,-23683,-28073,-21892,-4516,29295,14177,-12470,7546,25509,20496,-25819,20676,10305,-27949,27296,-2435,-20244,13407,-7800,-23365,6352,10892,-20211,-32190,-27841,19483,-5360,-9187,31585,17164,-5548,4811,22570,-25266,-24217,27500,-11200,-22993,26122,-508,9311,-25229,-1385,29304,6544,-12423,24542,13311,3440,32001,-22538,4857,-1574,29174,-8763,-28266,-4056,21452,26842,14951,-30474,-14843,-24731,26898,11309,-19645,15471,4808,-6171,-4480,13390,-11638,-2018,-9429,6628,-15681,-22663,-18357,-5617,2337,-15241,-10642,25389,1270,16385,13256,-13618,5040,-12381,10334,-30950,-23790,29377,26506,23117,-20251,13439,-19358,9580,12555,22959,19161,-14731,-8403,-16964,-10421,3284,31093,31017,3329,25962,18051,-22793,-26897,-26011,12110,22050,-922,11979,14605,-65,-7974,-9813,11337,14719,15840,15196,23030,17831,27331,-19939,-1546,-30346,21324,-22682,-15160,30703,25780,19903,32596,28291,18454,27051,-29898,18989,-29172,-11443,-13170,-28430,-22086,-529,9035,-30652,-10865,2141,-6423,-13664,-25298,14564,6654,-21197,-22569,-28672,-31052,-29726,-32238,-24400,9776,31539,-29848,-26698,-23227,-11776,908,21049,22661,4423,-25571,27495,-30658,-2228,-7570,11695,13789,19624,-2458,6710,6275,-17752,28392,-25367,-7259,-28073,29090,15962,2637,26130,3383,-11511,-2068,-23749,31038,-7633,-7551,-19883,-29023,-28720,-20610,-17903,28109,-21059,-14897,3229,-1508,-1431,24559,14718,7999,24708,29100,342,20220,6534,694,-20051,-11877,-22691,13903,14304,-22141,-12877,2107,-1934,26558,-16727,1379,12208,-12691,30398,-6730,-11867,-21636,-7790,20529,7106,6146,23526,-26677,5029,27134,-14482,-23008,22295,-11798,14610,1322,-27144,-4479,-31949,-19598,-17827,20205,20493,-21770,6429,-25127,19753,-15653,-27484,24140,28998,20151,30040,-5666,-7346,12961,-2212,-16246,19911,-30330,9924,5105,9835,-2614,-4374,14673,2274,27576,27845,-934,-13431,708,17841,-16390,-21400,-3111,-27099,11656,-5224,-1739,-14633,-29114,-11341,-7636,-8362,-1407,-27893,21835,-16209,-9737,30629,-22683,10642,-12450,135,-22562,-29084,5332,-32389,20230,-14409,-26139,3672,29956,-26201,-20418,8377,8722,-27677,-24083,9447,10205,28853,-22919,-21758,-3674,31718,19005,-23551,11761,-26514,-6251,-2958,-6232,3159,-29651,-11166,-29843,2529,-11033,-7193,11083,15661,-32111,5067,5861,-14516,-17908,-23080,-7228,7033,-18353,-16516,13023,2864,1852,-3368,15208,-17389,8692,5661,-21166,4279,23455,15216,27761,-7362,-5347,2220,7493,22731,14210,-20556,-26434,-15708,-3404,-937,-8216,-12641,-31017,13287,24683,29211,-27943,15303,12324,8452,27554,1680,11445,3503,8029,7022,-5917,-22576,26588,211,11135,-9413,8522,30739,13959,18985,28685,5003,14061,11921,22540,1887,-31011,-27331,-18401,-31015,-30562,6639,-7310,19390,-14196,-25600,10082,-21874,-19347,-12485,2825,25406,-25935,-24931,25102,2890,-30366,21538,-8595,-2166,5129,18842,20472,-116,10365,-20982,-15207,17096,-30139,-18784,7480,-21644,-17967,-7290,-31458,-23428,9283,-21140,30027,-22937,-18248,-5173,-20508,24783,26554,7047,30690,24008,30901,22854,20631,-4312,1725,-12082,-19634,-31464,22032,32182,26139,17965,2628,11818,-23641,-20673,19559,7442,24973,29481,-19758,-1512,-13070,18547,16510,-15376,23021,-25800,-12546,22674,-74,20965,-15973,-10887,-17962,1526,-4207,-30487,-24338,10942,28602,-28317,-26567,-6762,24045,-26545,8788,-31339,13554,-104,6477,-18741,25930,-3930,-6098,23512,3267,19661,-14490,21619,263,21269,-2559,-4069,-9585,-18068,-15194,1830,2106,19792,23025,32408,-2507,-18736,-5732,23751,-20612,4095,-19998,-22565,25418,-32113,-7273,10927,31727,7793,-21228,17926,23429,22745,11241,14812,-31450,6428,23316,-26131,-5894,5145,-3523,-19529,-31427,-1987,19275,23353,9110,19192,5156,-10315,5938,24423,19264,3373,-26503,-14795,-11581,-15575,-2580,17748,21176,7718,6862,-32292},
  {26284,7579,-28388,-27667,20217,-27815,5132,-6333,-14017,6364,-8358,-15244,-11211,-5979,30492,-2026,-5651,-15884,32688,-10862,6716,12849,-17682,-29479,11402,-17917,-31459,-24226,11343,13873,-2020,-26622,25899,-29486,-2435,22671,-23237,9479,29241,23285,-24059,12035,-29283,-10942,28099,-142,-3591,27286,-5360,-2651,6855,676,11333,-1783,-15485,5135,-22188,-11721,-17441,3438,11863,11405,1765,1891,8583,-3187,-20552,-19757,-14509,31635,7442,-22802,-7143,23217,-9667,-14919,-32509,5707,364,-27205,18843,-20164,-20579,31280,7648,3604,-21804,-7149,-10112,-26268,-32007,2971,-10405,26868,-32118,-24780,7571,22950,-3141,21758,-5750,-30485,-10189,28752,-32175,17489,12311,-10103,6013,-29533,29070,10548,-17120,3156,14869,11134,29022,-5912,-22770,-17032,20274,-1804,12385,31780,-19257,-30739,27013,-2088,32479,19422,30787,3355,1217,20208,9508,-5795,16389,21914,3886,29709,8845,18984,24011,1921,-15318,-13178,4270,-7290,-21267,-28354,-5995,15294,-20347,-25330,-30330,-6600,-23948,-28996,5456,-20674,27092,-3229,-8081,-17226,-8265,30510,20411,18431,-25561,23420,21343,3036,-10282,25612,-28122,-9177,23963,20527,-26525,11668,-31352,13962,-15103,-19158,2669,17775,14322,10480,-14811,-26416,26947,4777,2308,-1570,-16154,-12092,-24745,19607,30676,24262,-31831,-26702,-7195,-23491,14733,-11607,3084,-20234,-6704,32393,-20959,-30360,25268,-18257,-7296,-32767,-2251,-9179,5236,-3599,2555,-26538,3178,-25275,8643,22705,12772,15902,6459,-9241,23341,17544,-31503,-2550,-17350,-6880,19385,-7384,27257,25421,11468,-31601,-18413,18942,21843,-31843,-7567,-27926,2285,-2915,-11529,-2052,-25116,-458,-3521,17650,-1529,32106,-20917,5134,-23725,-16966,20108,12095,1275,-29040,-27066,11577,-18913,20196,-24492,-18585,-1394,25182,-15614,3396,-26754,-21622,18433,11588,6285,-1247,10153,-7366,-26865,19174,-24748,23378,22454,-12822,7957,-27858,-26059,9840,24032,24911,16382,8070,23790,3493,-12087,19431,-16739,6489,-14914,14035,18446,14342,-13131,11816,32767,-32592,-13656,3216,8458,-10439,794,-25777,-13713,25800,-1742,21642,5929,9658,12611,3201,29664,28518,-32004,5518,-21164,-10212,11337,-5435,21654,-23974,23178,-12238,-6879,-31529,-15313,-25048,2861,19350,-32072,32597,10899,-19471,-28805,1324,14121,-30343,16841,12571,7241,-25900,-14950,-14972,30751,-8373,19741,-15912,30109,3787,24552,26383,-10315,26772,-12276,3234,23268,-8356,241,651,26861,29420,-32409,27581,-4445,-716,-3655,-27247,-26201,8431,-6220,4377,-13914,-30449,22839,17823,-19000,9214,28210,-2864,3539,-16536,-25475,16518,-10747,-7576,12727,-775,30703,10239,3152,15362,3028,-22981,16719,10540,-11944,24604,-14148,4658,18649,-21838,-552,-23903,-11155,-25185,-20570,-28838,4153,-2125,30717,31154,-13515,22456,-24070,17349,-10311,-1956,13134,-6577,-22599,6227,7041,15425,13713,-27577,6405,19371,20543,22393,2940,-14394,-7479,-6641,8507,577,17559,-14970,24721,-6808,22134,-24187,11297,10904,-2516,20297,7327,-2659,-12639,20287,7645,-13042,-31987,-1786,-28581,-19116,-32095,24607,-2612,15992,2737,-15567,13163,-29828,5361,29480,5010,279,7153,16270,-25401,-27461,-10270,19385,16745,-16345,-4418,-15428,17862,-9761,24564,-23083,12854,16739,29553,-25786,13842,-2530,7800,5492,-29436,1308,20476,-31823,-567,12176,-11594,-12756,-5912,-11156,12592,-19474,-2595,26611,-11231,8187,5840,-12731,-32079,-2442,-13827,-1406,-26469,17101,14189,8858,21138,31222,-13009,-13200,-11684,13917,-24990,-15755,28407,-4255,32189,-25965,14916,4706,-1297,-28048,26710,516,-30634,19134,25810,-5767,5896,-31879,-8298,-16924,7164,-21527,-28777,-31809,-29984,6232,-22740,-27049,-5991,24231,31440,-23096,30294,-5595,-9363,-31045,2757,-25558,-775,4235,15146,31499,-24042,-18775,-12203,26675,14421,2135,9596,609,14272,4759,20229,23332,7869,28104,9761,28890,-22980,32174,20183,-19887,-27510,2356,-27522,-25026,17090,-20476,-10304,-20699,11855,-7751,-2085,29945,11938,1115,30601,15307,528,-29468,410,-32528,28995,-15593,23820,-32225,-12316,-6656,24478,23211,-10987,-4650,28848,5921,-31707,-17869,16211,24725,7225,29324,5236,24911,17183,5565,-2095,19751,21639,10201,12665,-8931,26363,3925,-18502,1552,-16960,1931,9910,941,-24978,-12411,-28641,-3261,2986,-31671,27729,-15834,31571,9876,-22053,8700,-8511,23518,-24782,9279,-17517,8780,-4693,-32324,-9735,-32141,20845,-5957,-27346,25968,-16420,20211,-32063,15010,-31142,-9520,-2537,-15910,-8322,26763,-19465,17106,-30256,10810,30779,-2661,2217,17021,5347,8617,31798,9797,-31115,-11013,5859,22218,24627,31098,-11583,-3314,12853,-17406,-428,-32262,14906,-8847,32308,-13795,1740,-26736,-10256,-6444,13751,22900,714,10366,-24167,-3360,9625,-16185,12194,14097,5184,2501,-28663,-1,13313,-22675,9505,-2852,22638,15578,-26262,4308,15832,4327,-12533,-8267,-28750,-4345,23325,18551,-8679,-15381,-26681,-32199,4962,-32655,-24836,8960,15103},
} ;

static void test_encode_761xfreeze3_impl(long long impl)
{
  unsigned char *s = test_encode_761xfreeze3_s;
  unsigned char *x = test_encode_761xfreeze3_x;
  unsigned char *s2 = test_encode_761xfreeze3_s2;
  unsigned char *x2 = test_encode_761xfreeze3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_761xfreeze3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_761xfreeze3(impl);
    printf("encode_761xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761xfreeze3_implementation(impl),ntruprime_dispatch_encode_761xfreeze3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_761xfreeze3;
    printf("encode_761xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_761xfreeze3_implementation(),ntruprime_encode_761xfreeze3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_761xfreeze3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_761xfreeze3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_761xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_761xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_761xfreeze3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_761xfreeze3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_761xfreeze3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761xfreeze3")) return;
  storage_encode_761xfreeze3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_761xfreeze3_s = aligned(storage_encode_761xfreeze3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_761xfreeze3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_761xfreeze3_x = aligned(storage_encode_761xfreeze3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_761xfreeze3_s2 = callocplus(maxalloc);
  test_encode_761xfreeze3_s2 = aligned(storage_encode_761xfreeze3_s2,crypto_encode_STRBYTES);
  storage_encode_761xfreeze3_x2 = callocplus(maxalloc);
  test_encode_761xfreeze3_x2 = aligned(storage_encode_761xfreeze3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_761xfreeze3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_761xfreeze3();++impl)
      forked(test_encode_761xfreeze3_impl,impl);
    ++test_encode_761xfreeze3_s;
    ++test_encode_761xfreeze3_x;
    ++test_encode_761xfreeze3_s2;
    ++test_encode_761xfreeze3_x2;
  }
  free(storage_encode_761xfreeze3_x2);
  free(storage_encode_761xfreeze3_s2);
  free(storage_encode_761xfreeze3_x);
  free(storage_encode_761xfreeze3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

