/* ----- core/multsntrup857, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_multsntrup857_checksums[] = {
  "d8bf44e9672dea2fc7a424fc0a0036c60cbb70bbde0754573455fffcf65e6e29",
  "b043b7fb8f6de5ed482bcbec3b317ef523d5b1d67061dd51f4a5b335696f7ef6",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_multsntrup857_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_multsntrup857_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_multsntrup857_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_multsntrup857_CONSTBYTES

static void *storage_core_multsntrup857_h;
static unsigned char *test_core_multsntrup857_h;
static void *storage_core_multsntrup857_n;
static unsigned char *test_core_multsntrup857_n;
static void *storage_core_multsntrup857_k;
static unsigned char *test_core_multsntrup857_k;
static void *storage_core_multsntrup857_c;
static unsigned char *test_core_multsntrup857_c;
static void *storage_core_multsntrup857_h2;
static unsigned char *test_core_multsntrup857_h2;
static void *storage_core_multsntrup857_n2;
static unsigned char *test_core_multsntrup857_n2;
static void *storage_core_multsntrup857_k2;
static unsigned char *test_core_multsntrup857_k2;
static void *storage_core_multsntrup857_c2;
static unsigned char *test_core_multsntrup857_c2;

#define precomputed_core_multsntrup857_NUM 4

static const unsigned char precomputed_core_multsntrup857_h[precomputed_core_multsntrup857_NUM][crypto_core_OUTPUTBYTES] = {
  {3,1,70,1,205,8,103,9,105,8,161,255,2,5,253,0,241,6,186,2,6,3,167,252,174,254,55,1,211,252,43,250,143,7,176,249,0,249,133,4,166,7,145,246,155,249,110,247,48,249,57,248,225,3,123,246,105,251,190,255,247,9,229,1,187,3,242,246,101,8,15,10,247,1,207,251,168,8,247,255,47,7,219,8,162,255,155,8,42,8,22,247,166,252,40,255,197,3,3,255,185,2,180,1,247,9,80,0,52,251,111,253,164,8,236,251,5,248,231,4,129,249,192,251,63,6,84,3,91,249,19,249,183,250,174,246,40,8,197,249,158,255,32,253,73,250,30,251,129,7,101,254,15,5,66,246,224,246,119,251,120,248,73,246,173,255,166,246,225,2,70,5,133,2,72,4,152,7,159,4,19,248,129,248,254,249,121,254,205,8,59,249,71,8,60,249,17,252,22,3,122,9,164,252,130,8,93,6,245,8,82,255,90,249,14,5,242,5,217,2,76,246,254,8,169,1,178,246,70,7,111,247,231,3,81,5,195,1,27,248,31,0,110,253,6,246,150,8,127,250,212,9,38,250,195,252,23,7,227,0,0,7,22,253,231,9,46,4,197,6,68,254,209,253,244,246,225,6,166,252,247,5,52,251,53,251,79,254,153,0,101,248,43,4,44,6,104,250,177,2,143,252,218,8,181,0,169,5,61,255,36,8,118,252,163,252,222,255,224,252,124,9,248,0,55,0,45,4,46,248,44,1,198,248,8,253,14,10,131,5,214,8,37,253,222,247,88,250,248,2,237,5,100,249,97,2,110,8,132,6,19,253,129,251,79,4,28,0,128,0,35,0,11,10,232,255,32,247,173,3,61,250,172,0,243,7,84,248,160,5,57,247,216,4,240,252,139,255,146,7,81,7,158,250,227,7,64,3,196,253,176,3,232,5,185,249,0,5,67,8,12,8,141,9,199,8,189,253,221,255,110,249,62,9,45,6,35,0,108,246,240,248,135,254,53,246,108,254,75,5,194,251,37,6,28,255,234,246,42,6,133,0,187,247,177,4,210,7,164,249,219,246,32,253,49,252,70,255,92,251,122,253,225,253,112,7,205,4,60,254,198,254,173,7,3,247,158,1,116,9,24,4,67,4,114,2,94,255,31,6,82,7,73,7,76,250,18,248,89,6,157,5,120,255,83,246,190,1,36,250,166,2,202,0,63,250,20,249,89,252,88,251,214,3,162,2,204,3,207,251,190,5,210,248,115,7,163,248,18,3,86,3,92,253,133,251,251,249,240,247,229,6,153,252,133,248,154,248,182,252,190,247,177,8,139,8,124,251,218,9,226,9,214,252,128,250,155,1,246,252,174,247,164,9,34,4,244,9,128,249,206,4,28,249,39,251,81,250,151,2,96,5,70,5,113,3,252,3,115,248,198,0,42,5,93,5,90,2,250,6,226,252,107,1,82,0,101,255,49,247,247,2,56,6,191,0,188,4,49,0,102,9,136,5,168,252,201,4,154,7,166,254,91,8,52,1,97,250,124,4,100,253,63,1,79,253,227,247,134,1,235,248,201,254,238,246,27,255,148,252,241,246,4,250,134,252,64,253,177,9,13,255,178,8,143,0,170,3,238,245,76,253,20,250,104,250,54,249,87,2,50,254,179,250,2,249,145,8,209,249,45,252,60,1,175,0,212,246,208,247,39,0,61,9,54,6,101,255,110,9,79,248,140,1,106,0,209,3,74,6,46,7,93,251,21,249,11,8,202,6,115,250,21,254,223,1,187,248,195,9,0,10,39,247,31,2,100,4,220,4,235,254,37,252,98,251,159,249,204,0,230,255,59,4,18,0,175,255,74,6,178,3,51,252,11,2,238,255,179,251,130,255,36,253,204,2,107,8,28,8,130,250,227,2,53,3,148,247,175,3,3,1,94,6,126,4,219,0,85,255,108,254,3,246,115,0,244,250,124,7,16,8,250,2,64,1,46,4,245,255,233,251,210,0,190,2,137,252,200,4,122,248,22,252,133,247,218,4,53,248,96,254,133,253,233,245,13,250,212,0,145,7,200,248,170,247,1,255,172,0,82,3,188,7,122,6,17,251,209,254,30,5,72,9,13,0,206,253,177,249,45,248,26,255,200,5,219,5,123,246,242,248,186,253,218,8,120,246,170,5,241,9,189,0,147,252,240,255,95,1,87,254,210,5,48,1,240,1,251,252,97,254,130,6,122,0,132,253,88,247,219,249,20,251,78,248,22,246,100,9,77,255,232,9,36,4,236,1,48,2,104,7,226,253,97,4,13,249,221,2,41,4,78,250,82,251,188,255,180,247,235,246,0,252,43,2,128,3,56,253,126,8,169,248,8,254,80,7,10,253,213,4,89,249,169,5,92,250,46,250,46,7,70,247,1,10,56,6,141,4,248,253,125,251,237,5,12,252,119,254,92,7,22,250,205,246,198,9,248,250,78,250,29,4,25,6,78,250,160,253,222,8,136,248,51,251,246,255,190,255,125,250,98,250,115,253,229,7,178,5,114,7,237,255,17,251,217,6,183,7,103,250,113,6,196,7,31,248,123,249,51,7,38,2,93,8,37,249,175,254,133,253,203,8,241,6,85,4,36,0,224,253,89,1,185,249,236,2,163,249,180,250,20,248,29,1,221,250,55,248,246,255,68,252,237,8,176,255,32,3,61,248,235,7,168,4,246,247,142,246,20,6,12,250,187,7,209,249,6,2,244,245,64,2,114,6,41,5,118,3,78,9,222,250,6,252,145,254,167,8,36,4,45,2,38,250,125,253,216,4,156,255,169,250,81,3,192,1,144,6,168,252,248,1,108,2,133,3,174,248,230,248,84,246,254,7,102,247,63,0,224,248,218,6,63,251,24,0,68,254,145,4,194,2,230,5,75,9,37,250,15,2,194,253,81,246,240,1,120,0,41,246,195,254,79,250,82,249,246,0,144,2,215,252,46,253,175,9,166,253,40,250,247,246,66,255,250,7,22,250,136,0,32,252,191,247,70,3,181,247,234,9,143,247,15,250,149,0,59,8,2,8,71,7,165,250,64,2,8,253,171,6,96,254,140,248,119,5,122,0,27,252,47,2,195,4,217,6,191,252,131,3,14,254,184,9,239,252,206,253,63,247,116,0,118,1,251,3,95,253,187,9,155,4,107,254,49,8,213,0,222,246,210,246,56,254,231,247,35,253,206,2,102,5,6,8,159,9,70,3,5,10,169,1,99,7,103,9,214,8,202,0,49,1,38,250,143,247,2,2,242,254,148,8,250,254,9,5,11,246,136,3,65,248,216,255,2,10,43,1,30,246,220,255,223,2,78,6,170,248,128,0,218,4,52,247,254,245,214,249,109,1,20,252,22,9,60,3,121,8,254,6,238,245,159,1,110,6,200,252,87,250,40,6,38,9,65,8,58,3,247,5,241,255,73,3,119,1,23,249,233,251,160,251,121,1,66,4,73,247,90,249,105,2,209,8,136,249,153,6,103,246,38,7,52,250,121,249,186,9,8,3,10,5,186,5,249,249,177,253,196,9,169,247,32,251,237,249,224,246,143,6,61,248,128,248,198,251,191,249,7,248,101,8,142,7,216,250,41,251,161,252,9,6,229,252,51,254,50,249,162,5,50,6,67,1,214,6,56,5,83,248,46,249,243,8,219,0,128,255,240,250,126,255,237,9,161,6,95,255,199,1,174,6,237,247,108,253,177,6,125,250,205,251,166,7,127,5,32,2,70,6,108,246,249,2,73,4,21,249,82,1,37,247,128,250,3,254,192,255,247,1,241,254,190,251,159,9,170,255,115,252,198,253,19,5,206,251,56,247,89,255,64,7,235,248,233,5,12,3,113,4,4,247},
  {32,255,200,5,237,0,96,4,25,0,145,255,113,9,106,1,63,250,93,252,0,252,116,9,165,1,134,7,19,4,203,251,25,6,183,5,42,0,129,249,216,9,3,9,48,246,129,251,117,251,119,254,63,248,131,7,15,3,224,251,83,5,199,254,69,6,113,250,240,0,87,8,135,9,23,246,205,253,159,1,130,0,187,250,79,255,239,6,147,247,20,8,122,251,14,4,162,252,148,254,187,6,153,254,141,3,83,2,3,248,50,4,102,5,98,4,53,9,221,246,205,2,198,249,0,249,72,3,21,3,118,251,176,249,129,6,223,8,18,248,114,248,60,2,61,249,41,5,83,253,151,2,233,247,173,253,127,247,199,3,96,7,25,250,92,7,44,252,195,249,63,253,78,253,37,251,144,0,51,249,89,255,0,2,17,1,1,246,114,9,242,252,20,247,45,7,101,247,89,2,242,7,122,251,61,8,28,9,137,253,45,7,211,3,147,248,37,2,35,2,220,253,92,8,38,253,95,4,2,255,34,246,91,1,201,5,233,246,164,253,241,6,79,250,79,7,222,2,1,255,97,247,31,1,209,248,9,6,145,2,97,252,234,0,241,254,18,7,90,249,202,249,170,5,28,249,103,251,109,246,92,3,34,250,64,248,28,8,104,246,1,0,39,254,92,254,107,248,117,0,34,248,61,248,173,0,31,7,152,4,173,255,26,3,184,248,66,3,95,3,20,8,243,9,152,255,93,249,177,247,97,247,44,253,238,255,90,3,183,9,218,248,106,4,93,249,184,9,14,3,246,252,70,0,219,249,228,4,115,249,154,255,47,249,77,2,141,250,33,248,105,0,170,5,16,247,185,252,112,246,37,5,142,8,12,6,254,8,128,5,225,253,191,1,191,6,242,247,213,250,199,247,233,252,233,3,185,2,200,4,253,247,48,2,101,247,135,249,187,250,139,4,38,252,203,1,133,0,8,251,238,249,68,246,122,7,129,255,86,2,72,5,144,246,110,5,69,6,182,5,206,254,123,3,39,2,140,8,66,248,78,249,79,7,144,7,176,1,19,250,110,246,0,251,237,254,191,255,101,253,194,5,224,4,158,247,212,4,234,247,136,2,216,4,128,3,75,6,79,247,171,251,4,1,250,5,184,248,247,250,183,2,234,255,225,6,166,249,217,8,239,7,39,246,3,4,34,3,126,3,129,3,188,3,198,9,222,248,70,252,65,251,122,9,117,2,11,247,96,5,101,8,242,1,21,3,4,10,22,248,107,5,141,250,172,3,240,246,215,250,225,1,53,249,181,250,195,252,105,5,244,8,30,247,177,6,235,4,154,251,90,247,56,8,139,250,51,5,194,6,114,5,44,250,137,246,82,4,199,7,233,9,220,252,156,4,18,0,188,2,116,246,135,4,45,254,40,253,51,3,158,9,104,252,215,251,81,4,174,246,222,246,69,255,203,249,198,246,41,5,251,5,145,3,142,4,68,0,150,253,253,6,220,249,192,252,236,250,163,251,249,249,238,9,186,7,66,5,221,0,125,2,226,3,181,4,237,1,159,1,202,8,63,255,182,6,142,5,107,2,131,3,84,255,25,249,11,4,36,0,34,247,241,8,211,253,33,7,197,252,244,8,45,5,94,2,225,249,134,249,241,4,127,6,59,3,92,247,40,4,238,0,92,3,145,250,172,250,118,5,69,3,229,248,207,8,117,249,78,247,90,254,26,3,165,254,117,7,201,252,14,252,138,0,94,250,117,5,79,248,237,251,200,2,195,254,211,248,39,7,37,9,236,4,200,251,25,6,197,255,234,2,34,254,89,6,2,252,182,248,168,249,179,250,81,2,41,4,79,2,97,251,132,250,185,3,79,1,97,249,31,1,26,8,233,253,82,1,209,252,13,252,228,4,64,3,88,253,10,10,159,250,219,254,45,9,99,250,167,255,13,254,253,255,91,0,242,4,196,250,76,246,101,248,123,255,37,2,110,248,189,247,237,247,203,249,139,6,138,9,144,2,183,0,69,1,89,8,213,247,218,249,120,9,117,5,107,8,163,9,22,249,93,0,222,253,56,1,120,255,51,248,61,252,142,1,86,254,215,252,95,247,146,252,132,252,189,4,26,247,28,252,127,3,207,9,248,5,110,5,67,255,227,255,165,250,88,254,57,251,178,3,82,6,80,255,252,1,33,251,230,255,164,9,206,3,142,253,112,9,207,255,81,250,189,8,235,255,7,9,237,255,153,248,243,245,138,3,104,4,247,247,135,4,247,1,179,254,119,248,124,0,194,249,142,248,135,1,199,255,244,0,85,248,253,8,207,250,201,254,24,252,43,252,70,8,243,249,75,3,140,5,219,250,19,253,63,252,194,4,104,3,79,254,73,252,17,246,123,5,44,248,45,247,67,6,150,252,140,250,20,253,234,254,243,246,41,1,47,4,183,4,131,246,217,251,84,255,190,2,177,247,185,0,72,1,195,248,96,250,13,250,97,246,191,4,42,254,164,252,15,253,15,246,240,250,118,249,63,253,230,5,92,253,67,0,10,255,42,248,90,7,220,250,48,255,106,253,216,251,144,6,94,7,29,1,218,255,11,254,33,250,140,255,164,7,133,9,177,251,219,0,32,7,129,0,66,250,99,1,158,7,133,249,255,3,157,254,60,254,247,247,12,254,80,253,123,9,176,249,161,248,148,2,161,252,162,246,105,251,189,253,3,3,9,7,214,248,95,249,47,246,88,251,126,249,57,1,217,255,158,250,16,1,230,249,63,9,243,254,240,4,135,255,174,254,81,4,64,254,19,251,127,2,247,4,158,253,158,4,192,3,207,249,15,251,16,248,206,250,227,4,131,252,194,8,6,2,133,250,2,2,224,0,22,5,230,254,231,0,177,9,105,249,225,249,190,248,51,2,170,0,153,7,137,253,121,2,195,9,155,0,100,6,44,4,254,251,99,249,84,249,232,255,172,5,84,6,223,5,61,7,82,0,74,254,242,246,62,252,1,254,146,255,49,1,81,8,97,248,140,255,72,3,193,2,232,1,3,1,146,248,23,3,60,0,243,250,138,249,35,1,227,250,220,248,220,253,169,251,207,0,69,1,184,247,254,7,125,249,205,7,83,252,125,2,222,5,96,255,186,2,204,3,247,247,239,9,165,4,216,6,46,4,100,4,200,9,7,7,32,9,46,4,103,6,135,254,240,1,53,252,142,4,204,254,32,246,97,248,73,2,205,247,188,251,3,249,129,4,242,253,121,8,149,252,170,252,189,8,106,250,123,3,246,249,113,251,231,4,193,247,96,246,151,2,228,248,113,7,145,249,54,3,235,6,38,8,187,2,189,8,64,247,190,253,87,254,97,5,97,246,219,8,80,254,154,8,141,251,27,1,131,251,230,7,1,10,47,250,110,248,96,247,255,2,241,1,216,252,220,6,236,1,9,2,242,4,181,1,0,251,66,253,81,248,202,246,111,2,115,246,16,5,9,249,217,3,145,246,133,253,211,248,111,8,158,7,183,1,178,6,241,3,54,7,204,4,221,7,26,253,195,255,97,254,52,2,91,1,38,248,14,5,182,4,61,249,146,246,88,2,80,0,194,255,250,8,81,252,100,1,141,248,83,7,67,9,229,246,89,8,43,246,186,8,50,246,22,247,80,1,32,247,189,1,229,247,200,246,67,4,32,9,244,254,226,0,109,8,2,247,126,9,56,6,240,248,32,5,139,9,251,5,214,5,27,2,118,246,232,248,198,255,177,4,148,248,242,251,24,2,4,1,57,255,0,255,144,2,210,2,115,246,46,254,140,9,18,6,171,2,228,253,55,6,186,246,225,2,24,8,230,254,196,2,72,252,216,2,65,248,176,5},
  {66,5,169,253,190,246,19,3,187,3,76,0,33,4,103,253,29,250,41,1,200,1,185,254,159,6,64,254,161,5,169,253,208,6,206,255,200,0,151,6,240,253,240,252,237,6,78,248,169,1,17,246,73,255,204,246,138,250,113,255,131,247,1,6,160,4,173,2,61,252,62,9,34,253,28,8,59,0,128,249,101,247,177,250,127,6,243,1,28,246,218,3,226,5,246,7,239,255,152,253,200,247,212,1,69,250,109,7,222,248,245,6,78,1,20,252,129,251,250,1,137,3,4,246,88,0,164,249,126,252,15,4,178,0,153,249,98,247,15,246,241,251,142,6,102,249,188,1,146,8,79,7,4,254,248,253,0,0,215,9,83,6,75,3,248,4,64,5,240,249,64,3,22,250,89,9,87,0,106,3,240,1,82,246,91,1,117,248,46,1,92,2,16,248,53,249,109,249,199,8,233,253,143,246,131,6,226,246,115,254,198,255,49,254,171,247,86,247,71,250,151,5,186,252,23,254,82,7,179,0,74,2,128,251,33,255,33,248,161,5,0,251,216,250,213,5,239,5,175,3,89,247,3,1,2,253,68,1,121,248,248,6,106,8,208,1,64,7,146,7,223,8,241,245,33,7,126,246,29,254,100,7,13,248,253,5,117,0,169,6,234,249,170,247,201,255,63,246,122,9,233,255,177,5,152,9,55,5,58,250,35,0,177,248,249,254,19,0,115,248,161,246,238,3,114,4,217,4,44,246,205,8,21,251,160,252,214,2,196,2,86,2,11,253,51,1,197,2,222,5,198,254,244,251,16,246,11,9,154,254,40,2,231,249,198,249,216,9,112,4,160,0,187,252,79,9,35,253,31,248,90,2,151,250,126,255,31,250,210,9,151,6,45,249,213,255,219,7,185,1,52,3,109,3,190,5,134,246,187,254,181,4,92,4,141,253,52,251,2,7,58,5,241,247,189,0,57,5,149,254,192,0,103,248,115,2,255,250,46,247,16,250,188,7,60,249,109,0,121,5,198,4,125,251,10,255,122,249,21,254,160,254,30,250,195,9,97,254,64,9,194,254,80,252,194,255,236,245,57,254,169,4,191,3,209,9,166,3,216,9,183,249,208,9,31,3,47,7,237,253,85,2,20,250,128,1,160,2,33,255,185,8,47,2,237,254,100,246,51,252,113,0,47,3,22,247,107,4,4,250,91,255,130,8,237,253,15,249,84,3,86,246,46,7,234,4,239,248,91,253,40,3,176,250,78,252,101,3,147,248,201,248,133,7,58,9,76,247,175,253,250,7,52,248,183,8,5,247,235,245,197,251,106,1,14,255,132,254,151,0,65,4,254,6,133,250,148,0,193,1,128,254,245,8,46,2,4,10,4,7,183,7,209,4,56,253,199,1,115,9,48,250,41,5,203,2,96,247,213,6,222,9,222,254,228,246,89,0,188,6,32,3,153,8,53,254,57,7,246,5,246,247,123,250,170,254,80,246,60,2,137,8,42,2,107,9,204,255,147,1,223,250,135,253,251,255,228,247,108,0,130,1,144,246,230,248,89,254,251,245,130,246,86,249,196,8,221,5,48,247,88,3,23,4,61,247,145,9,92,7,238,255,16,1,90,9,98,251,42,7,121,1,179,252,4,6,1,2,13,246,244,252,148,249,95,9,124,252,209,3,221,3,235,249,21,253,178,251,80,1,128,247,144,1,106,5,62,254,64,252,7,10,179,254,4,249,152,2,189,250,18,3,126,246,29,4,88,8,156,251,224,8,87,8,254,4,242,4,224,6,237,250,127,254,179,255,225,248,105,7,250,248,214,248,89,7,52,3,233,252,162,2,205,2,79,3,28,6,186,2,95,0,228,1,22,255,54,253,22,250,116,2,96,252,214,252,8,247,3,247,236,4,93,254,161,255,81,7,231,253,241,246,78,1,137,255,18,251,57,5,93,4,196,4,90,251,217,5,247,6,89,251,127,252,166,255,32,8,117,1,4,254,57,5,241,250,160,1,100,246,135,255,161,0,183,248,208,246,123,251,185,249,79,4,99,249,38,5,22,2,203,4,162,251,244,5,80,5,218,9,226,251,193,255,34,4,35,8,7,2,116,255,49,251,243,2,56,253,212,7,69,2,234,252,11,10,9,250,80,6,7,2,211,251,198,252,221,252,178,255,111,8,216,254,131,8,105,9,233,247,147,4,14,8,249,2,137,250,167,4,144,251,68,246,223,3,97,250,245,4,110,255,242,2,153,3,101,251,95,7,239,247,142,5,53,251,94,2,74,3,196,247,247,247,21,3,144,255,245,7,41,252,91,5,232,1,30,8,139,1,9,1,201,9,198,255,192,0,209,7,158,3,53,4,66,252,60,7,171,247,1,6,137,249,101,251,184,248,145,5,140,250,215,2,231,5,75,247,18,9,61,249,29,7,91,9,182,253,173,251,178,4,245,1,97,5,95,253,68,250,251,8,130,5,142,254,101,7,40,8,44,249,233,251,162,248,7,3,67,253,244,249,253,245,50,252,17,248,104,255,104,253,32,5,90,2,34,247,35,2,183,3,173,1,163,7,246,3,76,5,126,253,47,9,156,255,79,0,219,254,47,255,144,4,36,9,245,0,148,1,206,7,245,1,166,255,136,8,117,253,225,2,0,7,138,246,164,247,111,6,41,251,41,5,195,1,50,252,211,246,29,249,84,248,48,253,19,4,36,1,13,0,64,9,108,248,13,7,49,246,177,3,210,7,183,252,180,253,225,255,42,253,72,6,151,6,177,253,245,9,136,3,234,0,131,254,39,248,6,2,177,250,108,8,123,9,128,250,49,253,145,249,33,7,112,4,152,253,146,0,58,2,141,250,79,6,179,8,140,255,116,249,250,247,36,2,182,4,2,5,24,248,216,1,10,2,21,248,159,9,229,255,202,246,197,4,20,5,192,252,121,253,93,249,224,8,212,9,47,6,88,0,135,247,139,254,31,248,182,253,7,2,189,248,45,2,171,2,186,248,153,250,238,9,193,252,50,6,209,252,153,249,185,7,168,6,221,253,2,248,200,7,251,3,234,0,218,246,153,9,84,0,161,249,175,254,95,252,195,7,97,7,110,4,118,246,134,7,226,247,247,4,16,9,102,253,72,249,208,249,144,3,160,2,222,4,164,0,165,1,3,247,22,3,43,3,170,3,123,255,65,9,51,253,134,246,32,5,67,247,30,251,73,255,134,3,85,254,7,4,113,8,61,246,39,2,72,2,28,5,48,3,16,251,15,3,30,5,76,7,84,9,91,253,156,248,146,246,183,2,255,0,75,251,160,2,185,254,222,249,110,0,244,8,14,5,250,252,105,254,148,5,234,7,93,252,214,7,72,255,111,0,136,255,240,253,109,5,192,253,77,4,126,247,85,246,61,0,89,6,224,4,23,2,117,9,150,7,242,9,182,252,137,2,103,5,129,251,5,6,185,249,122,1,211,8,218,6,209,0,193,5,88,6,38,9,164,248,46,248,174,8,192,7,19,252,243,0,244,0,69,253,138,252,110,5,69,9,72,5,90,4,223,9,103,250,68,5,66,1,37,249,234,8,122,248,128,8,157,250,73,247,244,252,154,246,109,251,131,6,160,255,136,8,111,246,37,248,151,246,35,250,253,253,186,6,247,9,119,0,70,253,192,6,161,247,222,254,98,248,91,253,28,255,245,7,95,255,74,5,126,250,167,252,105,251,46,6,161,251,199,1,232,9,65,4,197,252,187,2,170,246,121,246,27,8,215,2,227,248,244,255,173,251,5,247,253,250,118,2,139,250,148,0,129,8,203,6,227,0,205,9,141,8,62,3,147,6,61,249,52,6,247,2,202,249,208,7,229,0,187,250,84,2},
  {104,247,14,251,202,246,218,1,16,5,152,3,219,252,7,5,3,4,203,247,248,246,116,248,24,246,168,6,127,253,128,0,105,4,78,248,12,246,168,251,103,252,186,2,83,8,25,253,50,255,87,3,19,249,77,251,46,249,254,1,63,251,99,253,250,4,129,7,219,254,134,3,187,5,31,250,100,255,178,4,222,5,103,249,210,8,46,8,15,254,92,251,103,3,255,252,201,246,18,2,57,7,7,255,214,247,71,249,60,3,32,248,126,248,122,0,175,246,153,251,240,246,11,253,0,7,38,4,9,6,142,2,160,9,214,251,224,248,220,250,140,4,221,248,40,2,192,4,244,250,199,8,221,7,94,247,149,6,51,248,220,2,120,252,50,5,10,6,78,252,37,7,145,0,57,1,29,3,21,251,19,255,126,250,139,252,187,9,93,254,109,3,63,9,69,246,50,252,246,5,202,1,85,6,99,6,98,9,176,247,253,4,5,255,217,0,156,4,86,251,235,251,201,8,228,246,14,9,39,251,148,255,105,246,215,252,18,6,180,9,209,3,5,10,236,248,46,4,130,7,106,255,226,253,248,0,217,255,37,4,235,245,168,250,147,248,245,4,170,1,72,2,69,251,171,0,31,252,245,255,69,255,4,250,103,247,138,251,116,9,141,8,92,252,173,254,187,255,25,6,153,9,115,250,231,8,170,7,122,3,119,7,81,249,29,255,196,247,87,251,77,248,46,5,38,253,147,2,101,4,230,8,226,0,161,1,191,8,105,252,16,251,14,255,197,251,199,248,81,247,43,2,116,255,30,254,229,251,119,248,14,7,203,248,160,252,7,252,173,5,174,5,209,250,115,251,198,7,118,0,193,6,55,2,196,8,209,1,17,252,196,251,179,250,54,246,82,4,14,247,38,248,105,247,77,9,208,250,9,0,201,248,96,4,140,5,188,247,155,7,108,7,54,2,10,10,176,4,94,255,196,250,187,254,26,249,28,247,223,251,100,255,248,248,19,250,223,255,123,249,127,5,250,252,187,253,14,247,87,250,50,2,35,254,141,253,62,1,226,248,73,3,6,0,36,3,196,251,251,0,23,0,89,5,220,0,209,252,227,255,161,247,183,8,22,6,11,250,186,6,231,253,194,0,198,2,59,246,148,248,134,3,9,255,204,252,151,250,79,5,99,1,194,8,55,7,184,255,26,255,91,248,207,2,243,2,144,249,61,250,149,248,202,248,42,250,163,9,108,249,193,252,157,247,23,252,138,1,119,252,46,6,104,253,101,255,169,0,58,248,87,9,0,248,251,254,70,8,64,248,82,6,224,0,16,246,11,5,183,255,234,251,43,253,201,252,118,254,35,246,138,254,2,1,202,6,23,254,194,9,160,2,191,6,9,252,63,9,29,7,254,245,165,246,57,254,241,246,182,254,87,249,18,3,74,254,86,2,192,8,189,0,75,9,31,9,238,245,171,251,252,255,11,9,121,9,151,251,206,4,195,253,143,253,87,8,110,6,72,253,168,1,14,3,10,247,198,1,56,253,112,9,225,253,253,8,88,9,146,6,44,6,198,254,118,254,4,1,77,255,212,5,198,7,186,250,66,246,111,4,177,255,241,255,252,0,186,8,40,6,147,255,253,246,230,6,34,249,175,247,247,248,86,9,237,6,196,1,114,6,129,3,226,5,174,4,2,248,152,7,21,253,17,254,194,5,110,248,63,250,16,254,167,1,231,9,37,249,20,3,134,8,202,6,251,251,151,8,194,1,122,248,90,8,28,3,7,253,27,7,55,246,221,1,149,253,206,252,13,248,174,6,181,5,253,251,244,6,120,250,36,8,149,249,241,5,115,253,252,247,117,248,8,5,152,3,237,253,118,1,209,253,209,249,129,249,35,0,208,0,5,9,11,1,26,246,111,254,122,2,191,246,84,6,115,3,207,3,21,3,104,249,18,10,14,7,107,255,143,9,25,8,108,255,173,2,8,248,89,250,89,252,101,248,185,250,2,252,216,254,65,4,156,254,189,8,80,0,67,9,74,6,197,247,171,255,222,9,223,254,23,0,115,248,28,9,6,250,140,7,202,5,195,251,163,255,39,6,159,9,251,6,93,251,53,6,205,9,118,5,127,254,204,254,96,7,207,253,34,5,68,1,125,246,234,245,140,7,47,250,200,5,236,9,24,249,48,3,70,8,188,254,6,251,237,254,72,248,108,250,190,253,237,245,174,9,100,1,224,249,131,6,214,249,22,250,191,247,84,5,42,5,198,255,14,248,152,249,6,5,134,253,143,5,91,254,73,254,191,0,214,7,130,7,61,8,100,8,138,250,17,248,24,0,214,251,4,251,190,9,48,250,251,1,222,246,162,9,235,247,236,2,238,4,233,6,169,253,181,9,250,251,142,253,63,250,5,254,0,1,234,253,176,9,229,3,66,4,109,4,95,253,116,246,100,9,196,248,165,1,42,6,189,254,16,255,166,246,215,6,244,5,244,254,112,9,84,251,227,0,193,2,192,4,88,9,170,248,4,3,175,1,231,252,245,252,47,9,202,0,83,253,101,7,30,249,68,5,98,250,63,254,150,253,214,250,250,5,99,246,77,249,233,4,229,5,138,3,125,4,216,3,200,251,92,8,202,252,26,3,98,7,129,9,122,8,219,248,211,250,47,254,114,252,182,7,247,249,111,253,85,255,65,250,67,8,233,252,137,0,72,0,61,7,212,255,136,6,242,247,15,7,145,251,97,6,197,4,159,252,15,8,182,252,20,255,89,4,63,250,28,6,217,252,126,2,57,246,64,3,86,6,159,248,157,1,197,247,12,246,84,252,135,7,23,255,7,4,207,0,27,8,235,9,105,255,19,8,208,7,211,5,11,4,203,4,63,254,115,2,75,254,57,1,140,1,41,250,216,6,233,247,143,254,27,250,216,251,210,253,125,251,167,2,245,250,220,5,45,1,133,254,49,7,19,1,22,0,111,9,42,254,179,0,91,254,86,249,79,0,234,250,170,254,175,253,123,6,59,7,216,4,101,0,113,255,36,1,247,3,53,255,110,248,96,4,141,2,119,249,204,5,65,251,63,7,25,7,240,255,250,249,155,253,98,6,225,2,174,8,218,9,21,251,156,252,198,2,195,250,236,250,118,0,10,254,182,2,75,8,197,251,110,2,14,248,238,1,48,252,0,1,233,9,207,4,38,2,22,0,109,8,5,251,1,252,113,5,184,1,146,0,6,4,137,248,249,1,21,0,120,7,153,254,186,4,217,6,162,3,115,251,249,0,24,9,155,7,41,2,56,246,159,6,192,3,77,6,78,4,12,4,18,0,129,0,45,249,66,250,201,250,158,254,1,249,123,1,1,250,85,8,14,251,208,2,12,2,82,254,176,9,215,254,112,0,152,249,60,4,179,6,245,254,247,6,245,245,22,5,36,3,60,251,87,5,26,7,58,2,4,255,76,247,241,6,96,246,234,2,176,4,253,247,110,247,3,6,37,3,156,255,201,7,9,252,113,255,111,247,59,250,250,8,175,254,133,248,7,250,179,2,7,6,81,2,133,246,79,255,219,249,40,252,239,253,29,4,222,6,61,246,167,1,223,255,239,249,227,7,237,245,175,8,137,7,147,250,184,1,17,6,18,254,245,8,94,254,223,253,109,4,206,5,115,4,227,4,126,7,219,9,119,251,241,0,88,2,160,247,253,1,135,4,213,2,255,9,91,247,104,4,102,6,94,250,90,247,101,253,145,254,172,7,74,4,230,6,217,255,158,248,245,2,167,250,245,248,75,6,32,254,118,255,43,246,44,4,73,248,141,253,140,9,3,1,232,5,128,254,56,249,2,248,159,3,125,7,136,248,47,255,55,5},
} ;

static const unsigned char precomputed_core_multsntrup857_n[precomputed_core_multsntrup857_NUM][crypto_core_INPUTBYTES] = {
  {170,229,233,140,9,186,137,148,227,111,99,242,192,140,45,220,124,35,16,179,43,37,238,25,61,108,26,73,31,229,170,1,216,64,187,7,51,28,119,158,194,13,190,183,55,234,151,111,174,124,171,85,3,167,122,45,151,188,180,53,232,234,85,98,120,34,74,138,30,133,85,106,109,61,151,10,229,144,83,78,25,18,200,127,227,250,110,4,68,1,37,15,49,151,75,50,139,155,98,191,171,112,103,210,170,84,17,163,229,1,11,40,19,48,124,226,168,51,170,186,136,13,49,219,201,31,86,163,137,245,159,183,10,32,170,5,64,17,1,99,112,165,225,88,158,55,11,159,69,160,77,186,83,58,74,134,74,118,207,175,47,105,73,48,54,163,178,228,88,3,160,187,209,224,190,155,236,27,247,155,48,18,203,130,190,7,156,75,47,219,54,5,152,193,42,13,137,174,36,63,67,228,81,68,89,248,68,98,131,159,74,6,175,39,101,200,173,147,71,183,138,156,57,11,11,151,141,37,176,201,251,64,174,12,232,86,74,206,189,120,139,59,168,30,160,129,14,145,115,218,42,139,98,79,68,184,156,137,209,176,228,54,51,248,29,131,234,107,235,178,139,183,232,89,56,0,27,236,16,118,46,23,217,235,80,142,44,16,68,222,232,34,22,201,165,163,23,123,12,27,236,232,48,248,96,66,8,124,101,38,234,233,103,248,164,50,138,32,114,217,122,9,137,30,44,57,150,182,50,49,168,232,131,13,44,139,235,224,203,77,255,73,248,51,174,76,75,107,12,82,39,49,31,81,224,120,172,86,205,130,57,15,246,208,199,201,124,2,181,114,145,213,247,112,38,123,131,79,171,122,165,252,54,40,208,105,80,38,3,45,20,4,115,18,120,220,98,70,225,97,17,37,47,8,36,191,51,30,205,106,161,42,194,203,216,30,40,182,39,52,47,134,135,205,222,154,54,29,150,6,226,239,13,93,97,210,87,45,196,74,94,25,98,233,61,79,51,137,61,154,162,18,98,140,221,139,222,33,149,120,255,169,83,157,65,33,192,239,1,244,134,117,96,81,71,77,93,140,172,187,176,11,196,255,225,18,39,69,175,220,191,233,208,136,2,98,196,79,253,152,159,197,247,212,144,186,169,152,171,210,122,98,92,147,6,36,216,239,227,99,17,61,91,85,126,57,217,154,136,137,236,3,104,177,119,143,108,17,183,42,236,69,184,165,186,9,193,177,91,97,165,14,63,33,100,144,210,246,153,165,134,67,213,179,164,9,95,239,180,150,213,107,239,238,129,70,33,70,139,32,49,59,132,127,88,56,93,159,1,81,137,162,10,160,81,105,91,5,166,56,154,128,157,66,135,206,130,50,72,4,7,126,152,231,224,98,195,149,109,100,212,48,241,176,126,52,32,8,1,49,130,137,23,92,181,97,151,160,163,199,148,54,79,18,196,248,161,27,107,46,116,189,246,64,56,99,32,39,213,171,242,250,193,227,47,169,137,81,10,138,49,125,14,177,172,29,132,140,2,67,251,26,215,14,19,17,155,86,198,42,137,171,133,176,76,29,197,206,56,224,12,213,250,255,1,33,165,254,63,217,239,255,8,144,178,253,180,137,96,195,91,145,200,22,51,229,93,0,236,43,131,164,176,17,10,75,22,246,192,206,74,213,110,25,141,27,215,22,168,202,105,10,241,28,214,75,105,130,166,250,229,230,194,145,91,50,24,220,15,183,179,183,90,133,92,117,239,223,248,74,38,193,170,94,230,48,103,194,231,255,213,236,227,191,102,88,242,148,34,53,238,13,57,14,131,165,216,230,196,29,133,224,152,170,160,36,234,154,227,159,187,65,49,161,9,36,67,58,235,9,124,127,229,85,230,28,152,19,220,193,249,83,7,69,65,50,164,203,97,44,6,58,176,209,23,54,64,252,148,111,116,99,126,38,149,192,143,156,100,104,41,15,40,60,68,64,4,170,192,244,135,160,198,1,38,218,172,28,200,55,189,205,5,139,59,21,166,176,255,174,68,215,21,189,109,68,243,34,31,240,62,145,215,189,48,27,80,237,190,192,104,38,147,91,87,121,201,69,52,238,227,10,25,206,172,111,208,79,88,145,185,89,187,119,225,137,246,179,47,68,47,243,247,91,12,240,186,13,0,86,21,148,163,19,190,108,139,104,239,194,96,239,198,165,162,118,200,16,202,209,130,36,189,53,250,182,104,76,174,250,232,117,136,169,71,248,155,130,226,253,212,78,231,187,189,233,253,80,53,165,74,6,84,158,108,145,188,115,50,43,95,192,66,29,49,199,242,21,215,239,194,231,127,213,112,168,205,192,25,172,136,218,114,223,126,142,52,105,153,181,244,2,174,98,69,215,209,207,45,85,237,27,160,80,201,181,138,9,221,152,101,184,71,88,163,140,167,128,66,233,191,197,193,18,27,106,159,63,218,177,211,22,133,125,252,70,100,52,75,149,35,25,66,249,56,48,18,208,223,70,60,180,241,43,237,227,242,240,177,5,163,244,244,164,101,112,8,133,203,147,150,222,69,235,75,204,231,63,104,165,203,160,183,15,112,37,84,212,120,199,159,156,178,120,221,203,65,191,247,22,107,141,133,72,251,190,25,36,248,74,223,169,178,220,163,117,117,105,236,226,55,201,217,101,138,202,86,205,45,44,161,72,191,181,192,237,109,20,227,176,58,156,17,68,61,244,23,82,40,60,79,12,65,90,242,139,157,226,146,117,104,99,162,226,167,253,190,5,129,234,38,92,31,201,213,86,138,22,160,176,91,51,155,130,247,38,104,100,163,7,221,238,7,166,168,130,217,235,219,8,142,210,162,192,175,127,120,13,225,19,174,58,174,183,210,215,215,184,89,192,9,39,228,53,46,227,93,250,167,248,78,209,43,110,74,224,245,98,111,190,30,62,18,86,120,69,104,161,93,121,54,116,81,236,12,164,156,78,252,181,214,34,229,26,190,231,147,72,80,92,93,23,6,209,20,204,199,126,235,237,105,64,62,210,159,210,249,56,28,123,235,47,72,206,148,208,150,188,205,224,33,46,203,50,56,226,55,181,16,134,130,127,80,159,188,141,103,112,105,126,175,68,229,116,191,5,219,4,35,2,139,10,126,121,147,98,42,43,37,17,50,211,111,74,70,101,82,157,147,76,157,185,161,152,254,176,22,6,169,48,221,190,50,49,237,1,160,88,120,28,44,141,5,137,196,217,89,27,119,213,51,95,143,163,53,45,195,112,247,95,157,55,241,31,99,230,175,91,65,8,126,98,199,223,1,19,178,56,111,56,150,45,88,55,182,133,108,222,161,230,173,145,147,212,145,168,82,54,44,55,142,119,151,205,207,115,157,69,164,181,184,249,22,22,172,145,185,15,252,63,60,43,211,138,170,245,220,16,79,166,138,156,32,55,233,214,167,183,154,169,139,176,233,142,47,73,234,227,199,148,20,249,221,181,211,241,43,211,9,54,109,51,201,137,20,127,200,14,130,67,142,14,68,198,5,88,164,41,104,119,179,58,15,60,201,191,50,74,19,59,222,45,112,251,192,42,179,170,191,78,128,167,255,113,30,21,103,216,212,84,120,95,241,187,14,10,0,160,176,6,75,175,40,60,75,59,191,146,254,203,42,161,195,78,105,210,214,162,250,63,119,56,244,105,86,175,144,42,172,235,182,17,196,83,212,42,217,244,124,136,152,60,217,127,44,116,117,190,62,165,143,203,7,10,107,124,216,156,25,38,162,51,91,200,94,165,235,128,17,54,184,242,138,252,127,150,183,112,181,4,209,165,199,141,65,134,82,52,198,69,129,62,231,244,50,0,158,202,121,20,116,3,90,86},
  {247,20,158,35,13,250,37,43,98,30,219,91,18,189,211,223,217,82,41,95,115,219,161,143,86,40,168,217,136,230,180,196,175,240,31,176,117,172,2,236,32,41,14,238,43,4,216,164,249,224,231,128,20,13,38,52,75,163,220,168,208,52,6,62,89,104,215,174,175,39,228,7,6,4,223,29,128,131,66,119,37,100,113,186,59,224,4,155,70,209,27,137,198,41,97,68,104,92,215,221,112,50,27,162,24,93,183,78,170,135,103,216,218,164,19,159,85,60,116,150,47,138,115,78,227,181,169,169,153,210,71,119,161,169,60,160,231,51,34,152,195,155,139,66,172,92,213,11,82,163,93,25,241,151,172,114,170,204,131,52,142,8,41,184,148,226,204,112,65,31,126,38,87,134,162,52,208,91,14,221,250,240,200,135,181,138,51,28,15,214,142,156,188,203,3,112,174,134,12,105,34,49,107,62,199,56,153,32,205,242,89,63,39,85,255,20,45,136,142,183,90,238,81,84,132,153,164,90,118,85,225,253,24,246,109,21,60,243,171,165,206,43,232,197,10,23,187,191,77,229,202,128,241,85,45,1,245,122,168,117,109,171,19,108,159,128,214,164,238,191,10,21,106,95,157,50,100,251,180,243,177,0,242,182,232,37,227,12,60,165,186,191,89,214,87,29,93,60,198,221,26,76,150,165,158,109,172,68,203,109,15,120,117,66,83,97,106,227,124,3,124,195,52,81,1,92,150,116,77,222,5,79,81,226,218,162,204,81,13,139,200,210,129,192,50,56,56,195,147,137,177,62,160,150,26,254,212,207,37,26,155,104,155,33,82,93,15,108,171,117,160,51,68,133,174,4,70,125,172,143,7,84,201,68,217,230,123,133,241,92,58,253,248,250,232,42,199,5,96,126,120,152,247,65,177,132,178,80,81,72,126,165,73,28,234,252,114,172,136,66,203,9,157,198,25,52,104,250,150,120,118,157,145,78,158,229,34,99,248,54,221,35,83,97,220,162,80,69,186,65,1,26,135,148,88,6,110,181,36,236,129,86,234,50,122,65,208,92,202,168,113,14,177,10,198,165,97,104,25,115,254,96,232,99,180,157,238,30,80,190,225,140,122,93,155,250,27,25,86,237,209,184,126,185,72,144,151,185,13,254,180,137,192,79,226,235,194,225,134,8,247,9,98,17,63,205,216,120,206,230,13,133,45,88,81,94,122,174,2,163,116,130,254,31,58,66,40,230,98,168,123,101,207,213,130,31,35,208,104,122,232,23,113,195,102,165,248,159,130,142,51,76,246,128,200,109,32,229,117,113,12,19,230,168,62,228,63,238,27,19,96,180,67,247,75,7,12,205,50,189,166,113,61,56,135,184,67,43,99,48,117,231,142,186,186,54,255,153,73,249,15,251,27,246,145,145,239,108,125,187,141,73,127,93,131,92,149,15,37,194,72,27,86,41,111,5,255,62,171,255,54,188,176,45,167,132,140,187,152,76,161,224,27,218,30,148,175,16,80,70,226,235,188,229,20,4,203,4,137,127,136,195,166,22,17,255,153,179,51,43,191,242,4,15,177,184,5,121,152,159,220,232,104,15,162,36,250,182,36,74,162,60,184,2,194,85,52,22,72,86,151,172,30,143,145,63,56,184,58,202,127,140,72,165,236,50,6,173,8,255,0,61,84,97,219,227,101,37,233,210,217,152,200,204,139,177,134,108,155,69,185,87,249,180,174,180,52,70,124,35,52,247,18,66,133,24,159,75,148,160,230,183,156,16,63,222,163,116,166,60,228,239,89,3,162,112,113,143,2,22,135,216,251,69,78,93,254,166,146,54,160,166,245,35,165,12,39,41,157,200,92,14,15,32,103,119,119,11,248,155,76,203,106,214,45,219,99,136,74,204,41,161,254,176,200,172,51,184,244,134,38,115,72,54,62,203,228,84,223,150,66,156,208,189,245,52,233,222,114,160,36,198,51,9,72,227,44,23,230,177,215,248,156,176,187,44,98,41,130,79,183,247,87,136,118,67,97,181,27,228,206,111,176,70,14,186,170,240,80,105,172,116,76,220,208,185,175,143,54,30,200,172,178,157,144,117,216,223,232,252,206,69,13,98,110,85,78,202,11,185,36,112,157,153,127,241,152,14,101,5,244,8,174,60,103,46,128,143,146,248,186,91,2,157,151,194,137,254,146,69,97,83,22,236,72,204,65,219,107,171,111,21,11,187,88,186,50,50,236,72,88,83,243,133,80,155,89,34,157,191,254,128,88,108,218,224,74,219,36,105,20,79,95,46,200,61,191,200,210,64,80,147,228,157,86,120,173,112,10,39,192,59,236,109,190,166,99,47,49,29,89,126,202,179,210,142,87,241,138,32,66,231,150,41,31,19,123,69,187,255,200,158,54,213,72,139,173,179,18,12,225,87,1,185,68,188,201,2,127,244,20,112,82,121,67,133,146,27,26,69,136,220,68,236,75,153,96,138,226,19,92,143,51,252,102,85,254,3,89,45,227,218,145,80,204,141,79,200,55,202,149,83,128,146,38,157,2,71,206,187,24,66,187,245,72,141,169,229,102,195,197,76,51,125,202,93,190,213,29,220,18,112,70,115,151,95,28,99,169,23,129,92,5,202,168,212,67,13,118,110,139,72,3,36,84,159,234,87,115,86,227,19,200,103,173,0,20,157,59,25,67,227,8,223,108,47,244,230,54,138,165,23,153,17,89,53,35,192,23,20,92,69,196,142,166,180,244,74,92,235,61,65,233,217,157,12,155,78,53,47,222,174,162,187,105,239,35,70,174,227,121,82,187,140,138,44,44,39,128,168,41,134,77,247,35,92,142,252,30,166,242,136,24,233,183,158,203,36,194,18,191,15,22,166,89,85,69,244,131,175,178,50,217,50,168,44,160,221,216,80,95,54,99,113,187,104,224,213,8,151,82,121,253,225,187,80,169,226,157,165,123,204,96,13,68,38,226,154,63,170,51,128,197,215,252,203,92,110,191,71,78,115,24,59,174,34,191,118,60,26,113,68,74,216,74,194,153,99,9,68,214,127,116,204,150,234,53,223,236,132,99,113,182,88,126,190,52,123,232,117,37,97,210,101,1,35,38,252,185,220,9,168,214,26,84,185,39,26,242,32,192,115,210,227,123,87,54,73,227,61,212,200,185,161,113,202,28,42,34,22,149,73,57,3,227,170,25,126,95,101,12,227,21,93,49,32,245,16,158,151,12,188,25,138,142,113,68,168,162,194,62,46,71,193,91,41,107,236,7,138,79,80,71,118,130,255,155,163,67,53,167,10,91,216,153,151,221,125,199,56,239,46,181,113,25,218,205,109,19,90,120,201,126,248,239,225,212,118,119,13,225,32,156,23,112,31,189,6,176,55,252,251,180,73,189,129,158,233,44,155,202,63,168,9,45,129,58,158,89,14,61,239,45,165,58,54,160,65,221,74,155,102,72,73,148,136,129,204,171,28,7,71,215,52,85,50,194,171,223,196,201,216,8,182,221,69,159,130,61,58,167,114,23,92,169,224,219,7,161,37,93,162,189,218,195,119,146,138,139,79,110,204,36,251,245,231,15,144,48,121,81,169,205,104,118,2,234,186,91,170,112,17,153,38,44,13,136,131,3,168,171,210,15,154,151,3,191,29,169,46,94,119,60,230,226,15,43,174,240,2,68,24,102,226,74,109,0,162,163,125,20,127,94,247,183,236,50,109,152,145,143,251,123,81,14,237,224,28,200,82,69,20,67,103,189,134,218,129,182,190,73,22,199,114,181,230,142,79,175,181,118,222,34,179,156,176,40,66,83,214,198,1,118,155,19,152,168,211,210,255,216,152,16,5,27,132,151,73,160,72,178,222,135,22},
  {16,44,65,224,61,179,27,180,23,117,227,2,42,193,124,233,5,3,123,71,144,217,225,99,5,21,82,60,9,151,224,57,125,89,167,55,229,50,230,205,131,177,11,19,144,227,230,122,147,171,144,5,52,22,150,110,204,25,114,30,252,167,184,212,163,101,92,5,207,224,181,167,212,242,194,180,80,178,224,118,41,115,248,69,48,131,64,200,126,159,254,147,133,79,148,92,214,126,35,238,184,19,179,143,32,32,56,183,218,44,59,250,149,238,62,210,97,75,183,205,34,140,177,34,31,92,97,169,21,89,125,190,237,61,26,175,110,225,39,102,175,202,129,129,47,199,6,217,88,113,81,77,56,193,247,164,121,8,179,5,227,229,5,247,207,102,230,40,23,85,79,56,170,10,224,240,21,38,236,88,71,128,244,196,120,142,177,146,228,170,7,108,44,6,236,249,51,147,159,136,182,116,64,45,193,156,94,131,158,138,100,48,97,67,62,211,137,26,69,222,43,13,194,80,187,240,120,210,119,16,164,35,45,47,66,153,116,41,15,46,233,164,18,15,7,255,131,150,242,149,163,161,191,134,141,255,65,19,37,60,62,218,182,32,24,42,236,202,153,177,242,106,239,38,39,141,254,85,248,135,197,13,111,81,205,34,184,103,195,82,35,108,245,244,35,159,226,164,185,35,213,61,217,242,247,129,212,88,78,59,146,125,59,216,253,99,227,252,112,67,58,160,152,191,65,175,79,17,228,69,15,206,0,93,107,54,74,99,32,34,0,33,161,142,90,81,231,131,120,32,170,100,7,229,112,100,34,255,35,210,72,202,199,30,13,89,128,57,145,181,227,98,19,52,51,55,36,160,83,139,21,108,153,38,59,134,252,99,99,128,17,158,165,106,42,1,4,149,199,195,255,25,177,228,26,59,252,218,248,20,122,213,246,92,125,41,177,182,74,127,170,82,12,213,21,67,193,130,33,86,173,209,222,81,9,154,32,92,200,206,209,45,29,213,87,227,97,202,136,130,216,73,47,248,130,90,166,195,163,112,45,94,63,249,167,197,144,155,196,127,209,185,121,117,46,147,52,29,159,138,168,155,48,96,109,26,194,21,34,54,108,90,203,136,236,36,183,138,11,108,161,102,117,126,166,192,84,172,59,129,123,122,78,41,199,208,198,44,135,151,150,157,120,171,25,20,24,50,113,114,97,101,223,213,127,148,222,240,58,135,88,247,170,79,18,144,58,13,39,115,29,62,203,160,53,68,218,163,127,22,194,97,77,80,157,8,65,163,178,59,16,124,124,33,8,128,111,53,137,30,65,60,235,10,53,29,166,51,178,212,102,233,89,15,83,123,223,100,117,116,62,206,218,124,101,51,30,232,137,178,46,81,182,36,47,35,74,14,104,249,192,222,132,193,246,237,210,176,163,255,193,34,231,124,47,10,209,236,80,8,23,247,219,84,187,75,254,202,43,30,57,89,252,152,67,173,205,146,167,70,199,84,99,215,169,255,199,89,210,21,33,32,121,190,166,173,174,61,102,102,57,219,209,131,205,198,223,221,223,54,185,19,77,222,5,54,68,163,120,245,132,8,27,174,173,149,205,28,122,197,39,62,201,132,121,81,148,238,161,79,26,88,61,142,217,220,197,101,224,141,191,233,70,124,136,114,34,88,157,235,143,8,170,247,32,15,185,36,16,192,213,99,42,250,148,130,30,144,103,222,63,85,216,94,253,92,148,3,226,157,174,32,32,18,28,249,39,229,207,181,187,86,223,68,253,254,196,193,105,194,93,20,202,139,51,65,82,97,147,188,203,137,127,114,192,58,81,110,84,1,209,26,36,166,142,85,213,169,3,211,104,121,167,225,146,98,159,78,192,125,227,79,80,206,254,21,146,158,56,234,109,2,124,155,189,33,101,20,128,192,39,54,106,231,171,47,236,4,85,20,211,103,31,146,29,175,115,161,75,0,92,130,60,230,2,220,9,105,113,42,197,153,22,219,161,202,43,91,88,2,116,57,201,233,41,229,225,18,30,227,107,222,29,2,122,130,85,39,192,180,181,231,21,109,86,150,23,40,122,20,111,16,67,58,117,139,112,10,42,36,165,186,32,222,49,155,225,151,39,11,202,182,64,247,75,185,120,222,227,253,171,12,252,195,86,232,231,59,188,254,233,122,239,167,113,158,89,130,250,228,213,183,236,167,226,7,97,135,71,11,154,119,65,27,242,249,239,126,65,238,215,65,64,213,63,173,220,102,18,59,236,17,171,4,131,167,105,252,141,121,6,108,58,198,93,95,64,12,180,176,183,250,184,2,188,182,91,209,247,233,198,216,62,25,142,93,136,146,111,181,206,148,83,33,227,42,89,195,6,195,185,130,80,172,115,49,8,51,191,34,16,46,6,215,68,241,81,80,244,222,197,47,234,166,28,125,253,117,39,180,248,154,147,34,241,184,15,49,132,102,240,248,97,56,88,74,20,233,152,94,6,58,134,231,254,53,175,157,220,22,91,208,160,239,233,180,234,117,129,168,162,13,57,163,138,184,82,187,203,236,208,36,57,68,85,193,207,17,254,77,201,189,134,249,135,196,87,195,64,208,4,147,30,161,228,55,27,17,207,145,128,237,25,199,161,239,128,11,160,169,166,228,114,152,207,139,235,55,161,171,57,214,201,104,109,4,249,47,50,174,173,35,241,188,200,243,24,96,240,193,213,157,244,144,62,74,48,57,249,109,9,177,12,209,254,151,39,227,231,31,55,2,87,146,145,74,185,200,50,127,202,166,182,195,123,142,179,36,176,176,145,233,65,76,82,202,168,183,106,227,83,53,148,235,79,166,242,221,213,128,146,150,164,235,65,73,213,122,106,48,120,248,194,179,251,190,96,15,254,227,15,11,103,42,108,224,78,179,14,214,202,247,165,59,117,252,144,216,23,148,219,159,51,70,30,127,67,107,200,104,44,172,191,248,200,74,109,196,132,73,14,168,169,24,35,105,182,147,68,61,205,248,32,62,217,150,31,174,194,193,111,88,44,151,16,255,32,227,212,76,33,124,202,27,179,96,149,141,169,138,141,242,125,113,210,175,233,248,36,133,136,32,51,176,92,86,113,76,165,1,19,140,147,81,81,240,34,181,222,197,25,108,234,2,180,29,13,94,246,32,158,162,10,190,142,16,87,206,179,88,149,97,19,3,138,165,228,116,142,166,75,175,121,116,115,188,113,236,251,144,22,211,156,104,131,39,88,95,18,227,36,225,210,206,43,248,249,68,99,143,184,177,109,21,197,138,183,100,10,196,236,247,29,74,73,127,143,23,161,129,94,36,134,251,156,65,77,56,115,134,9,215,100,237,228,19,240,153,143,37,61,249,88,147,81,204,253,136,251,213,162,119,176,237,46,92,94,199,250,175,61,150,38,187,34,153,171,190,234,47,219,49,161,18,247,103,148,86,150,14,151,204,7,190,76,233,214,92,242,68,42,48,76,102,209,104,30,67,165,57,170,168,19,149,19,137,202,236,199,128,25,166,68,49,32,39,193,239,174,193,241,70,157,147,11,249,195,231,196,97,180,58,177,129,131,155,143,182,188,241,110,132,90,138,78,216,231,5,121,55,252,59,226,230,128,154,128,23,230,205,228,150,251,56,10,8,187,169,34,44,11,131,193,157,71,56,14,222,179,38,150,18,211,110,90,93,237,65,242,110,60,73,45,103,111,85,2,31,34,104,238,110,237,106,7,246,39,234,37,26,11,13,138,212,50,206,228,51,192,97,10,50,62,134,87,22,176,67,133,102,213,179,155,212,142,190,52,103,237,191,79,76,84,95,54,169,114,227,71,102,142,187,167,91,209,80,127,76,147,172,173,47,89,46},
  {193,107,196,200,46,188,177,29,211,184,218,230,228,209,52,242,64,50,13,53,177,52,236,5,163,138,215,9,119,44,161,4,152,132,12,240,109,99,16,126,152,228,132,150,137,229,107,131,214,68,189,24,223,126,196,79,225,105,63,83,189,127,235,116,184,36,223,154,4,139,136,76,40,212,190,35,108,208,0,222,195,115,35,192,107,164,40,174,118,194,20,18,42,63,28,2,108,190,160,46,38,158,254,215,175,254,246,107,224,239,151,27,176,8,229,140,198,184,254,107,208,146,250,155,156,19,57,184,153,169,244,68,55,101,206,106,166,249,176,192,67,50,212,224,71,172,113,122,202,75,17,19,213,179,234,190,80,51,22,187,169,94,82,227,63,39,42,88,122,165,140,234,234,31,31,109,80,247,132,144,7,246,5,189,247,165,226,132,135,73,194,250,163,104,6,43,211,59,232,101,79,138,169,126,125,179,249,241,57,201,51,79,215,107,19,185,114,161,227,185,246,10,23,53,58,36,55,27,241,12,150,96,85,205,10,229,20,60,145,68,185,249,148,123,252,36,187,77,44,76,5,233,70,220,236,219,215,88,166,154,37,193,108,18,114,237,20,210,190,190,235,107,47,73,16,128,90,212,86,176,181,44,87,39,207,155,17,52,250,182,36,65,89,6,166,223,93,227,145,149,214,50,186,137,225,159,87,56,161,226,202,44,216,228,64,154,80,43,1,17,93,221,16,216,220,151,36,48,119,143,172,242,126,211,174,124,99,108,254,225,197,138,123,24,246,103,252,152,244,238,210,223,255,249,211,15,97,254,246,112,190,222,89,251,222,207,16,150,51,85,111,149,117,140,14,57,110,57,87,191,215,68,179,203,187,71,53,218,241,205,217,179,111,165,232,204,254,80,216,114,5,196,136,223,99,194,204,129,99,209,69,15,210,177,153,137,111,71,243,1,20,131,13,216,232,241,195,149,11,230,39,232,199,117,184,84,133,123,241,78,226,250,216,43,38,172,60,44,226,133,197,69,131,208,18,44,70,115,135,138,52,193,70,196,15,235,134,76,144,187,45,252,232,8,236,236,240,217,132,80,45,223,45,212,209,245,146,17,243,42,227,99,216,4,27,123,133,111,83,11,191,211,112,73,14,5,247,55,81,60,107,86,229,19,166,156,147,14,210,0,79,224,15,71,128,146,240,8,185,173,132,172,59,172,194,107,95,170,178,239,227,239,199,210,35,127,176,221,108,154,98,180,161,211,28,179,136,161,120,224,27,213,149,121,142,202,79,29,84,244,46,19,11,208,252,232,129,160,75,203,222,158,169,180,233,175,126,103,237,159,68,135,13,167,166,4,91,85,128,87,90,37,192,6,96,106,205,41,193,27,123,2,45,8,220,53,170,149,127,19,90,40,225,226,125,161,0,126,77,91,255,19,221,56,243,2,233,26,203,24,206,43,9,202,224,223,130,174,0,241,113,197,117,224,149,181,177,188,175,66,224,89,64,40,29,243,10,208,0,161,239,68,19,40,28,67,210,144,231,14,130,235,117,202,81,116,250,131,18,69,143,181,17,88,77,137,139,109,3,110,192,197,232,171,35,186,196,76,160,11,34,80,145,151,228,244,8,195,42,44,208,182,77,74,240,10,167,186,38,151,254,100,3,252,201,201,106,100,63,96,65,39,193,201,71,204,232,67,177,220,5,118,218,206,112,167,92,248,19,112,200,153,142,134,76,247,39,92,62,11,14,128,121,72,9,163,107,0,192,167,25,154,132,82,93,104,85,207,212,2,137,31,17,11,99,90,255,144,199,60,174,116,67,138,242,45,245,28,125,196,152,167,161,129,7,244,119,94,190,71,78,199,236,209,81,92,45,49,231,181,181,207,221,222,156,5,123,121,158,119,218,237,134,207,226,26,48,57,176,22,144,138,27,195,124,10,113,127,70,48,221,112,72,228,254,92,216,46,125,0,46,102,51,245,7,241,223,87,47,239,253,64,38,173,32,143,247,100,249,202,110,232,51,27,209,181,181,109,197,202,6,252,12,144,125,130,36,47,35,120,60,82,147,153,177,187,221,222,10,145,68,200,231,166,249,167,233,55,219,186,77,72,26,215,164,103,238,143,109,92,231,202,171,14,255,39,121,20,15,66,53,203,240,34,137,179,167,156,84,98,141,227,244,72,38,144,36,57,89,252,184,107,20,115,235,20,247,104,16,163,164,177,217,225,244,98,72,51,12,29,78,91,148,206,0,185,234,171,23,64,48,126,150,102,8,102,54,236,134,118,83,29,247,134,53,110,100,55,180,56,185,166,237,179,74,204,233,243,9,24,132,181,197,3,73,96,112,87,80,244,128,81,198,238,201,230,119,223,61,250,186,165,220,231,7,102,79,173,14,79,23,228,22,107,218,138,146,3,45,180,164,224,252,120,120,197,94,244,220,95,130,206,169,209,42,13,17,227,79,228,231,233,11,73,214,128,50,42,198,181,43,222,163,99,140,50,43,170,105,74,149,241,194,116,48,39,99,211,42,170,108,159,183,123,247,12,202,218,132,250,180,137,139,110,71,62,94,170,206,179,11,164,50,4,87,100,153,180,254,192,193,228,234,110,218,65,87,143,19,209,154,137,85,85,96,197,8,181,54,136,132,30,238,210,141,34,174,191,210,67,47,253,237,192,157,164,157,64,196,208,102,152,213,251,174,98,242,48,23,128,175,122,171,197,178,252,239,213,44,214,199,164,147,187,162,180,197,255,84,227,27,103,107,213,190,238,159,51,91,153,37,65,52,244,175,121,109,215,164,255,73,96,41,80,251,46,37,177,141,142,46,37,127,141,143,21,179,53,191,43,216,85,212,182,248,197,38,214,137,2,10,241,155,38,16,31,193,200,36,139,36,128,241,77,224,33,126,250,181,25,193,40,132,170,254,146,100,79,24,95,139,74,28,224,95,108,0,150,171,165,76,135,125,199,202,247,36,135,126,19,77,65,234,148,42,36,61,137,241,151,102,55,227,57,175,164,146,11,252,79,77,93,17,72,44,131,146,208,149,250,28,247,147,178,35,214,105,10,229,96,203,123,178,156,75,241,92,106,155,63,229,144,101,170,110,239,43,214,74,177,194,26,181,49,168,190,165,39,64,135,72,120,156,165,235,30,46,195,74,17,68,14,125,44,146,40,65,188,140,141,22,45,74,127,93,254,178,160,37,218,136,145,18,155,177,0,46,247,21,70,211,101,168,126,205,213,25,172,72,217,40,219,61,160,103,43,203,33,103,100,36,69,186,76,136,8,89,62,124,189,101,80,84,168,249,131,66,37,8,11,193,121,126,134,140,130,171,64,59,17,63,246,85,20,172,193,191,210,117,4,17,81,159,77,9,180,11,170,218,103,185,101,14,220,57,94,136,238,42,252,203,159,168,54,36,1,16,27,217,113,154,84,250,23,196,154,110,22,91,63,111,148,44,222,99,115,59,85,239,185,131,82,224,105,90,187,191,119,40,188,94,175,148,26,39,129,29,53,14,102,174,69,183,144,25,101,117,153,145,196,106,59,124,29,224,123,224,158,144,177,175,62,83,33,9,209,60,123,177,83,215,99,49,24,99,168,83,177,5,13,119,43,4,97,125,217,83,159,231,141,137,84,23,71,86,132,77,109,236,48,97,30,86,94,203,201,143,182,211,111,166,48,87,168,193,177,170,149,149,196,6,114,114,222,232,105,32,250,240,26,195,130,212,56,2,104,199,250,21,142,35,111,150,171,54,123,61,87,32,41,206,152,63,23,206,226,221,138,191,128,8,245,48,181,225,14,233,78,84,99,90,213,133,254,175,133,147,235,38,209,243,163,68,158,60,39,106,228,44,126,143,20,93,189},
} ;

static const unsigned char precomputed_core_multsntrup857_k[precomputed_core_multsntrup857_NUM][crypto_core_KEYBYTES] = {
  {0,0,-1,-1,0,-1,-1,0,1,-1,0,1,-1,0,0,1,0,-1,-1,1,-1,1,1,-1,-1,-1,0,0,1,1,-1,1,1,0,1,1,0,-1,-1,1,1,0,-1,0,-1,-1,1,0,0,0,0,0,0,1,0,0,0,0,-1,0,1,1,0,0,-1,1,-1,-1,-1,0,0,0,-1,0,0,1,1,0,0,0,1,-1,-1,1,0,1,0,1,0,0,1,-1,0,1,1,-1,-1,1,1,0,0,1,1,0,1,-1,1,0,0,0,0,1,-1,-1,1,0,0,0,0,0,0,-1,0,1,1,0,0,-1,0,-1,0,-1,0,0,0,1,-1,0,-1,-1,-1,-1,-1,0,-1,0,0,0,-1,1,0,0,1,0,0,1,0,-1,0,1,-1,0,-1,1,0,0,0,0,-1,0,0,0,1,1,-1,0,0,0,0,0,0,1,-1,0,1,0,0,-1,0,-1,1,-1,1,0,-1,0,0,-1,0,0,-1,0,-1,-1,0,1,1,-1,-1,-1,1,0,0,0,0,0,1,0,1,0,-1,-1,-1,1,1,0,1,0,1,1,-1,0,0,0,1,1,0,-1,-1,0,-1,0,-1,1,0,-1,0,0,-1,1,-1,0,0,0,0,0,-1,0,0,-1,0,1,0,0,0,0,-1,1,1,0,1,0,0,1,-1,1,0,-1,0,-1,0,-1,0,0,0,-1,-1,-1,-1,0,0,0,1,0,-1,1,1,-1,0,0,1,-1,1,-1,1,-1,0,1,-1,0,0,-1,-1,0,0,1,0,0,0,0,-1,1,1,0,1,1,0,0,-1,1,-1,-1,0,-1,-1,1,0,-1,0,0,1,0,1,-1,0,0,-1,1,-1,1,1,1,-1,-1,1,0,0,-1,0,0,0,1,1,0,0,0,0,0,-1,0,1,0,1,0,0,0,-1,0,0,0,0,-1,-1,1,-1,-1,0,0,0,-1,0,1,0,1,0,-1,1,0,1,0,0,1,-1,1,1,-1,0,-1,1,0,0,-1,-1,0,0,1,1,-1,0,1,0,1,-1,-1,0,1,0,1,1,-1,0,0,0,1,0,0,-1,1,0,1,0,0,0,1,1,-1,0,1,0,0,1,-1,0,1,0,-1,1,1,-1,0,0,0,-1,-1,1,0,0,0,0,-1,-1,0,0,1,0,-1,1,0,1,0,0,0,-1,-1,1,0,-1,0,0,0,1,-1,-1,-1,1,1,-1,1,1,1,0,-1,-1,-1,0,1,0,0,-1,1,0,-1,-1,1,0,-1,0,-1,1,0,1,0,0,0,-1,1,1,-1,1,-1,-1,-1,0,-1,0,0,0,1,1,0,-1,-1,-1,1,0,-1,-1,-1,-1,1,0,0,1,-1,0,1,0,-1,-1,0,1,-1,1,0,-1,1,-1,1,1,1,0,0,-1,-1,1,1,0,0,0,0,0,-1,-1,1,0,1,1,0,0,-1,-1,0,1,1,0,0,0,0,0,1,-1,1,0,0,0,0,1,1,-1,0,0,-1,1,-1,-1,-1,1,-1,1,0,0,-1,-1,-1,0,1,0,0,-1,-1,0,0,-1,-1,0,1,1,0,0,0,-1,-1,-1,0,0,-1,1,1,0,0,0,1,0,-1,0,0,1,1,-1,-1,1,1,1,0,0,1,1,0,-1,-1,1,-1,0,-1,1,0,0,1,-1,-1,0,0,-1,0,0,1,0,-1,-1,1,-1,0,-1,-1,0,0,0,-1,0,-1,0,1,-1,0,0,0,0,0,-1,-1,-1,0,0,1,-1,1,0,-1,1,0,0,1,-1,-1,0,1,-1,1,0,0,0,0,0,-1,-1,-1,1,0,0,1,0,0,-1,1,-1,0,0,0,0,0,-1,0,1,0,1,1,-1,-1,0,1,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,-1,0,0,1,-1,-1,0,-1,0,-1,-1,-1,1,1,0,1,0,0,0,1,0,0,1,-1,0,1,0,0,0,-1,0,0,1,-1,0,0,0,1,1,0,0,-1,0,-1,-1,0,0,0,1,-1,-1,1,-1,1,0,1,-1,-1,1,1,0,0,1,0,-1,-1,0,1,1,0,0,-1,-1,1,0,0,1,1,0,-1,0,0},
  {0,0,-1,0,1,1,-1,1,0,1,-1,-1,-1,1,1,-1,0,0,0,0,1,1,0,0,0,0,1,0,-1,1,0,1,-1,0,-1,0,1,1,1,-1,0,1,0,0,0,0,-1,1,1,0,1,-1,0,0,0,0,1,0,1,0,0,-1,0,0,-1,-1,0,0,0,0,0,0,1,0,-1,-1,-1,0,-1,1,0,0,0,0,-1,0,1,0,0,0,-1,0,0,1,0,1,0,-1,0,0,0,0,0,0,0,0,1,1,-1,0,1,0,1,1,1,0,-1,-1,0,0,0,0,1,0,-1,-1,-1,1,0,0,1,-1,0,0,1,0,-1,1,1,0,1,1,0,0,-1,0,0,0,0,0,-1,-1,0,1,1,1,0,-1,-1,-1,0,1,-1,0,1,1,0,0,1,0,1,-1,0,0,0,0,0,1,0,-1,1,0,-1,-1,1,1,0,0,1,0,0,0,-1,0,0,-1,-1,-1,0,0,1,0,0,0,0,0,0,1,0,-1,0,-1,-1,0,1,0,0,1,-1,1,0,0,0,1,0,-1,0,-1,0,1,0,-1,1,0,-1,0,1,0,0,-1,0,1,0,1,1,1,0,-1,0,0,0,0,-1,1,-1,0,-1,0,-1,1,-1,-1,0,0,0,1,1,0,1,0,1,1,-1,1,1,0,-1,1,-1,1,1,-1,1,0,0,0,1,1,0,1,1,1,0,0,0,-1,0,1,1,1,0,-1,0,0,0,1,0,-1,0,0,0,1,0,-1,0,0,-1,1,0,0,0,0,1,0,0,0,0,-1,1,1,0,1,0,-1,0,-1,0,1,0,0,-1,-1,1,-1,1,0,0,-1,0,-1,0,-1,1,1,-1,1,0,0,0,-1,0,-1,-1,0,0,0,1,1,-1,0,0,-1,1,0,1,0,1,-1,1,0,1,-1,0,1,-1,0,0,-1,0,0,0,0,1,0,1,-1,1,0,-1,0,0,1,0,1,0,0,0,0,1,-1,-1,1,-1,-1,0,-1,1,0,0,0,-1,0,0,0,1,1,-1,-1,0,1,-1,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,-1,-1,0,-1,0,0,-1,1,-1,-1,0,0,-1,1,-1,-1,1,-1,0,0,0,-1,0,0,0,-1,0,0,-1,0,0,-1,0,-1,1,0,1,0,0,0,0,0,0,-1,-1,0,1,1,-1,0,0,-1,0,0,-1,1,0,1,0,0,-1,1,1,0,0,0,0,0,-1,0,0,1,1,-1,-1,-1,0,1,0,-1,1,0,0,0,0,-1,0,0,1,-1,0,1,1,0,0,-1,0,1,-1,0,-1,0,0,0,1,0,0,1,0,1,-1,0,0,0,-1,-1,0,0,0,0,1,0,-1,0,0,1,-1,-1,0,0,0,-1,0,1,-1,-1,1,1,0,0,0,1,-1,0,1,0,0,-1,0,1,0,0,1,0,0,0,-1,-1,0,1,0,0,1,1,0,0,0,0,-1,-1,1,0,0,1,-1,-1,0,-1,-1,1,0,0,0,-1,0,0,0,-1,1,0,0,0,0,0,-1,0,0,-1,1,0,-1,0,-1,1,0,1,0,0,1,-1,1,0,0,0,0,0,0,-1,-1,0,0,-1,1,1,1,0,0,0,0,-1,0,0,-1,1,-1,0,-1,-1,0,-1,1,-1,1,-1,0,0,0,-1,-1,0,1,-1,0,0,0,0,1,1,0,-1,0,-1,1,-1,0,0,0,1,1,-1,-1,1,0,-1,0,0,1,0,1,0,-1,0,0,1,0,0,0,-1,0,0,-1,0,0,0,1,0,0,-1,-1,0,1,-1,0,0,0,0,0,0,1,0,0,1,1,0,-1,1,-1,0,1,0,0,1,-1,0,-1,1,1,0,0,0,0,1,1,0,1,0,0,0,-1,0,0,0,0,0,-1,1,1,-1,-1,0,0,-1,0,0,1,0,-1,1,0,-1,0,0,1,0,-1,-1,1,-1,1,0,0,-1,0,0,1,1,0,-1,1,-1,-1,-1,1,0,1,-1,-1,0,-1,1,0,-1,0,-1,1,0,-1,0,0,-1,-1,1,0,0,-1,1,0,0},
  {0,0,0,0,-1,-1,0,-1,0,0,-1,0,1,0,0,1,-1,0,1,-1,-1,0,0,1,-1,0,0,1,0,0,-1,0,0,-1,-1,0,1,0,0,-1,1,1,1,0,1,1,-1,0,0,0,1,-1,1,1,-1,-1,0,0,0,0,0,0,-1,0,0,0,0,1,1,1,-1,0,0,-1,-1,1,0,0,0,0,-1,1,1,0,1,1,0,0,0,-1,0,0,-1,0,0,1,0,0,0,0,-1,1,1,0,1,1,0,0,0,-1,1,0,0,1,-1,0,0,0,0,-1,1,0,0,-1,-1,1,1,-1,1,0,0,-1,1,-1,1,0,1,-1,1,0,-1,-1,0,1,-1,-1,0,-1,1,0,1,0,-1,-1,1,-1,0,0,1,0,-1,1,0,0,1,0,-1,0,-1,0,-1,0,0,1,-1,1,0,-1,1,0,0,0,1,0,1,0,1,-1,-1,0,0,0,0,0,0,0,1,1,0,-1,0,1,0,0,1,0,0,-1,-1,0,0,-1,-1,0,1,0,1,0,0,1,1,-1,1,0,-1,0,0,0,0,0,0,0,0,0,-1,0,1,-1,-1,-1,-1,0,0,0,1,0,1,0,1,0,-1,-1,1,0,1,0,0,1,1,0,-1,1,-1,-1,0,0,0,-1,1,1,0,0,-1,0,0,1,-1,-1,1,0,0,0,0,-1,0,0,-1,0,-1,0,1,1,0,0,-1,-1,0,-1,1,0,0,0,-1,1,0,1,0,-1,0,-1,1,-1,0,0,-1,-1,-1,-1,-1,0,1,-1,0,0,0,0,-1,0,1,0,-1,0,0,-1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,-1,0,0,0,0,0,-1,0,1,0,0,0,1,0,1,0,0,0,0,0,0,1,-1,-1,0,0,0,-1,0,0,0,1,0,-1,0,0,0,1,-1,1,0,0,-1,0,0,-1,0,0,0,-1,0,0,0,0,0,-1,1,0,-1,1,-1,0,0,1,1,-1,0,1,0,1,-1,1,-1,0,0,0,0,0,-1,0,1,1,1,0,0,0,1,1,0,1,0,1,-1,-1,-1,0,1,1,-1,-1,0,0,-1,-1,1,0,0,-1,0,-1,-1,0,0,-1,0,0,0,1,0,1,-1,-1,0,0,0,0,0,0,0,1,1,1,0,-1,0,0,0,1,0,1,-1,-1,1,1,-1,0,0,-1,1,1,1,0,0,0,1,1,0,0,1,1,0,0,-1,-1,0,-1,-1,-1,-1,0,-1,-1,0,-1,0,0,0,-1,0,0,0,0,0,0,1,1,0,1,1,-1,0,1,0,-1,1,1,1,1,0,-1,0,0,0,1,0,0,-1,0,-1,0,-1,0,1,0,0,0,-1,0,1,0,0,0,1,0,0,0,0,1,-1,-1,0,1,0,0,0,0,0,0,1,-1,1,1,-1,0,0,0,-1,0,-1,0,0,0,0,-1,-1,0,-1,1,0,1,1,1,-1,-1,-1,-1,1,-1,-1,0,-1,0,0,-1,0,-1,1,1,1,0,-1,-1,0,-1,-1,0,-1,0,0,1,0,1,0,1,1,1,0,0,0,0,-1,-1,-1,0,-1,1,1,1,1,1,-1,0,0,1,1,-1,1,-1,0,1,-1,0,1,0,1,0,0,0,0,-1,0,1,-1,1,-1,1,0,0,0,0,1,1,0,0,-1,-1,0,1,-1,0,-1,0,0,0,1,0,1,-1,-1,1,0,0,1,0,1,1,0,0,-1,-1,0,0,1,1,1,0,0,0,1,0,1,-1,-1,0,1,1,0,-1,0,1,1,1,0,1,0,0,0,1,0,1,0,0,-1,-1,0,0,0,1,1,0,0,-1,1,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,-1,0,0,0,1,-1,1,0,0,1,1,0,1,1,0,1,0,0,-1,-1,1,0,-1,1,-1,0,0,1,-1,0,0,1,0,-1,1,0,0,1,0,1,0,0,1,-1,1,0,0,0,1,1,-1,1,0,1,0,1,0,0,0,0,0,1,-1,0,0,0,0,1},
  {1,1,-1,1,0,0,-1,1,0,-1,0,0,-1,-1,-1,-1,0,1,0,-1,1,0,-1,0,1,0,-1,1,0,1,-1,-1,-1,0,0,-1,1,1,-1,-1,0,1,0,-1,0,0,0,0,0,0,1,-1,-1,-1,0,0,-1,1,-1,0,-1,1,0,-1,0,-1,0,1,0,-1,-1,-1,1,1,1,-1,-1,1,0,0,0,1,0,1,-1,1,0,0,-1,-1,1,-1,0,0,1,1,0,0,1,-1,1,1,1,-1,0,0,1,0,0,-1,0,1,0,-1,1,0,-1,0,-1,-1,-1,-1,0,0,-1,0,1,0,0,0,-1,0,0,0,0,0,-1,0,1,0,0,1,0,-1,-1,-1,-1,1,1,0,1,1,-1,1,1,0,1,0,0,0,1,0,-1,0,-1,-1,1,1,0,-1,0,0,-1,-1,1,0,0,1,-1,1,1,0,0,0,0,-1,1,1,1,0,1,1,-1,0,-1,0,0,-1,-1,-1,-1,-1,0,1,1,0,-1,0,0,-1,1,0,-1,-1,0,0,0,-1,-1,0,0,-1,0,-1,0,1,1,1,-1,1,1,1,1,0,1,0,-1,1,0,0,0,-1,1,1,-1,-1,1,1,0,0,0,1,-1,-1,0,-1,-1,0,1,-1,0,0,1,0,0,0,0,0,-1,0,-1,-1,0,-1,0,0,0,-1,-1,-1,0,1,0,0,-1,0,0,1,1,0,1,0,0,0,1,0,0,1,0,1,0,0,-1,0,0,1,1,1,0,-1,0,1,-1,0,-1,1,-1,1,0,1,0,-1,-1,0,0,1,-1,-1,1,-1,1,-1,0,1,-1,0,-1,-1,0,0,1,0,-1,0,0,1,0,0,0,1,-1,-1,1,0,1,1,0,0,0,1,0,1,0,1,-1,-1,-1,0,0,1,0,0,1,0,1,1,0,1,0,1,0,0,0,1,1,-1,-1,1,-1,0,1,-1,0,0,0,-1,1,0,1,0,0,0,0,0,1,1,1,1,1,0,-1,0,0,1,0,-1,1,-1,0,0,1,1,-1,0,0,0,0,-1,1,0,-1,1,1,0,0,-1,0,0,1,1,-1,1,0,-1,1,1,0,1,0,1,0,-1,0,-1,0,1,0,1,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,-1,0,0,0,0,1,0,1,1,0,1,0,0,0,0,1,0,-1,-1,0,0,0,0,0,-1,0,0,0,0,1,-1,0,-1,1,1,0,1,1,1,1,0,0,-1,0,0,0,0,0,1,1,1,-1,1,0,0,0,1,0,0,-1,-1,0,0,-1,0,-1,0,-1,0,0,0,-1,0,0,1,-1,1,1,1,0,1,0,1,1,-1,-1,0,-1,0,0,0,0,1,0,1,0,0,0,1,0,1,0,0,-1,0,-1,0,0,0,-1,-1,1,-1,1,0,0,1,0,0,-1,0,1,0,0,1,0,0,-1,0,1,0,1,0,0,0,-1,1,0,-1,1,0,1,0,-1,-1,1,0,-1,0,0,0,0,1,1,1,0,0,-1,1,-1,1,0,-1,1,-1,-1,1,1,0,1,0,1,-1,-1,1,1,0,0,0,0,-1,0,-1,1,-1,0,0,-1,0,0,-1,-1,1,0,1,0,-1,0,1,0,0,1,-1,0,-1,-1,-1,0,0,-1,0,0,-1,-1,-1,0,-1,1,1,-1,0,0,0,1,1,0,0,1,0,1,-1,0,-1,1,-1,1,0,0,0,0,0,0,1,-1,-1,0,0,-1,1,0,-1,1,-1,1,1,0,-1,0,0,0,-1,0,1,-1,0,0,1,1,0,0,-1,1,0,0,1,0,1,0,-1,-1,-1,0,-1,0,0,-1,0,-1,-1,-1,-1,1,1,-1,0,0,-1,-1,1,0,0,0,0,0,-1,0,0,0,-1,1,1,1,0,1,-1,-1,-1,0,0,1,0,0,0,1,-1,0,0,0,0,-1,0,-1,0,1,0,-1,0,0,1,0,1,0,0,-1,1,0,0,-1,0,0,0,0,1,0,0,0,-1,0,-1,-1,-1,0,1,-1,0,1,0,0,1,0,0,0,1,1,0,-1,1,0,-1,0,1,1,-1,1},
} ;

static const unsigned char precomputed_core_multsntrup857_c[precomputed_core_multsntrup857_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_multsntrup857_impl(long long impl)
{
  unsigned char *h = test_core_multsntrup857_h;
  unsigned char *n = test_core_multsntrup857_n;
  unsigned char *k = test_core_multsntrup857_k;
  unsigned char *c = test_core_multsntrup857_c;
  unsigned char *h2 = test_core_multsntrup857_h2;
  unsigned char *n2 = test_core_multsntrup857_n2;
  unsigned char *k2 = test_core_multsntrup857_k2;
  unsigned char *c2 = test_core_multsntrup857_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_multsntrup857_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_multsntrup857(impl);
    printf("core_multsntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup857_implementation(impl),ntruprime_dispatch_core_multsntrup857_compiler(impl));
  } else {
    crypto_core = ntruprime_core_multsntrup857;
    printf("core_multsntrup857 selected implementation %s compiler %s\n",ntruprime_core_multsntrup857_implementation(),ntruprime_core_multsntrup857_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_multsntrup857_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_multsntrup857_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_multsntrup857_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_multsntrup857_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_multsntrup857_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_multsntrup857_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_multsntrup857_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_multsntrup857_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_multsntrup857_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_multsntrup857_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_multsntrup857(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup857")) return;
  storage_core_multsntrup857_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_multsntrup857_h = aligned(storage_core_multsntrup857_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_multsntrup857_n = callocplus(crypto_core_INPUTBYTES);
  test_core_multsntrup857_n = aligned(storage_core_multsntrup857_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_multsntrup857_k = callocplus(crypto_core_KEYBYTES);
  test_core_multsntrup857_k = aligned(storage_core_multsntrup857_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_multsntrup857_c = callocplus(crypto_core_CONSTBYTES);
  test_core_multsntrup857_c = aligned(storage_core_multsntrup857_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_multsntrup857_h2 = callocplus(maxalloc);
  test_core_multsntrup857_h2 = aligned(storage_core_multsntrup857_h2,crypto_core_OUTPUTBYTES);
  storage_core_multsntrup857_n2 = callocplus(maxalloc);
  test_core_multsntrup857_n2 = aligned(storage_core_multsntrup857_n2,crypto_core_INPUTBYTES);
  storage_core_multsntrup857_k2 = callocplus(maxalloc);
  test_core_multsntrup857_k2 = aligned(storage_core_multsntrup857_k2,crypto_core_KEYBYTES);
  storage_core_multsntrup857_c2 = callocplus(maxalloc);
  test_core_multsntrup857_c2 = aligned(storage_core_multsntrup857_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_multsntrup857 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup857();++impl)
      forked(test_core_multsntrup857_impl,impl);
    ++test_core_multsntrup857_h;
    ++test_core_multsntrup857_n;
    ++test_core_multsntrup857_k;
    ++test_core_multsntrup857_c;
    ++test_core_multsntrup857_h2;
    ++test_core_multsntrup857_n2;
    ++test_core_multsntrup857_k2;
    ++test_core_multsntrup857_c2;
  }
  free(storage_core_multsntrup857_c2);
  free(storage_core_multsntrup857_k2);
  free(storage_core_multsntrup857_n2);
  free(storage_core_multsntrup857_h2);
  free(storage_core_multsntrup857_c);
  free(storage_core_multsntrup857_k);
  free(storage_core_multsntrup857_n);
  free(storage_core_multsntrup857_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

