/*******************************************************************************/
/* Permission is hereby granted, free of charge, to any person or organization */
/* obtaining a copy of the software and accompanying documentation covered by  */
/* this license (the "Software") to use, reproduce, display, distribute,       */
/* execute, and transmit the Software, and to prepare derivative works of the  */
/* Software, and to permit third-parties to whom the Software is furnished to  */
/* do so, all subject to the following:                                        */
/*                                                                             */
/* The copyright notices in the Software and this entire statement, including  */
/* the above license grant, this restriction and the following disclaimer,     */
/* must be included in all copies of the Software, in whole or in part, and    */
/* all derivative works of the Software, unless such copies or derivative      */
/* works are solely in the form of machine-executable object code generated by */
/* a source language processor.                                                */
/*                                                                             */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  */
/* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    */
/* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT   */
/* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE   */
/* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, */
/* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER */
/* DEALINGS IN THE SOFTWARE.                                                   */
/*******************************************************************************/

#if !defined(_LFP_INTERNAL_AUX_INLINES_H_)
# define _LFP_INTERNAL_AUX_INLINES_H_

#include <sys/types.h>
#include <sys/time.h>
#include <stdint.h>
#include <errno.h>
#if defined(__APPLE__)
# include <mach/mach.h>
#endif

static inline
void _lfp_timespec_to_timeval(const struct timespec *ts, struct timeval *tv)
{
    tv->tv_sec  = ts->tv_sec;
    // Syscalls often have special code paths for null timeouts
    // so set this to 1 microsecond
    if(ts->tv_sec == 0 && ts->tv_nsec > 0 && ts->tv_nsec <= 1000)
        tv->tv_usec = 1;
    else
        tv->tv_usec = ts->tv_nsec / 1000;
}

#if defined(__APPLE__)
static inline
void _lfp_mach_timespec_t_to_timespec(const mach_timespec_t *mts,
                                      struct timespec *ts)
{
    ts->tv_sec  = mts->tv_sec;
    ts->tv_nsec = mts->tv_nsec;
}
#endif

/* xorshift rng from Marsaglia */
static inline uint32_t
_xorshift(uint32_t y)
{
    if (y == 0) return 1; /* 0 is a degenerate case
                             we won't reach this unless
                             stores to uint32_t are non-atomic
                             for thread-safety we need this.
                          */
    y ^= y << 13;
    y ^= y >> 17;
    return (y ^ (y << 5));
}

#endif /* _LFP_INTERNAL_AUX_INLINES_H_ */
