/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__LISTEVENTS_HPP)
#include <ListEvents.hpp>
#endif

#if   !defined(__LISTMEDIATOR_HPP)
#include <ListMediator.hpp>
#endif

#if   !defined(__LISTCOLLEAGUE_HPP)
#include <ListColleague.hpp>
#endif

#if   !defined(__EDITCOLLEAGUE_HPP)
#include <EditColleague.hpp>
#endif

#if   !defined(__SELECTCOLLEAGUE_HPP)
#include <SelectColleague.hpp>
#endif

#if   !defined(__CORELINUXASSOCIATIVEITERATOR_HPP)
#include <corelinux/CoreLinuxAssociativeIterator.hpp>
#endif

using namespace corelinux;

// Constructor

ListMediator::ListMediator( void )
   :
   Mediator(),
   theList( NULLPTR ),
   theEditor( NULLPTR ),
   theSelection( NULLPTR ),
   theInterestedMap()
{
   theList = new ListColleague( this );
   theEditor = new EditColleague( this );
   theSelection = new SelectColleague( this );

   colleagueCreated( theList );
   colleagueCreated( theEditor );
   colleagueCreated( theSelection );
}

// Destructor

ListMediator::~ListMediator( void )
{
   theInterestedMap.clear();

   if( theList != NULLPTR )
   {
      delete theList;
      theList = NULLPTR;
   }
   else
   {
      ;  // do nothing
   }

   if( theEditor != NULLPTR )
   {
      delete theEditor;
      theEditor = NULLPTR;
   }
   else
   {
      ;  // do nothing
   }

   if( theSelection != NULLPTR )
   {
      delete theSelection;
      theSelection = NULLPTR;
   }
   else
   {
      ;  // do nothing
   }
}

// Invoke system

void  ListMediator::run( void )
{
   theList->initialize();
   do
   {

   } while( theSelection->getSelection() == true );

}

// Gather information from Colleague

void  ListMediator::colleagueCreated( ColleaguePtr aColleague ) 
{
   EventIdentifiers  aEvId;

   //
   // We only get the events that the Colleague is interested
   // in as it will tell us what we need to know. For discovery
   // implementations, the list of events generated by a Colleague
   // may be useful, but not here.
   //

   aColleague->getInterestedEvents( aEvId );

   //
   // Loop through looking for entries to perform
   // the link with, or create a new one
   //

   for( EventIdentifiersIterator aItr = aEvId.begin() ;
       aItr != aEvId.end() ; ++aItr )
   {
      DwordIdentifierRef      aDRef = dynamic_cast<DwordIdentifierRef>(*(*aItr));
      InterestedMapIterator   aFItr( theInterestedMap.find( aDRef ) );

      if( aFItr == theInterestedMap.end() )
      {
         theInterestedMap[aDRef] =  aColleague ;
      }
      else
      {
         NEVER_GET_HERE;
      }
   }
}

// Create a iterator over the interested parties

Iterator<ColleaguePtr>  *ListMediator::createIterator( Event<Identifier> *anId ) 
{
   Iterator<ColleaguePtr>  *pList(NULLPTR);
   ListEventPtr            anEvent( dynamic_cast<ListEventPtr>(anId) );

   DwordIdentifierRef      aDI( *DwordIdentifierPtr(*anEvent) );

   pList = new CoreLinuxAssociativeIterator<InterestedMapIterator,DwordIdentifier,ColleaguePtr>
      ( 
         theInterestedMap.lower_bound(aDI),
         theInterestedMap.upper_bound(aDI)
      );

   ENSURE( pList != NULLPTR );
   return pList;
}

// Destroy the iterator

void  ListMediator::destroyIterator( Iterator<ColleaguePtr> *aPtr ) 
{
   REQUIRE( aPtr != NULLPTR );
   delete aPtr;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 03:46:00 $
   $Locker:  $
*/


