#!/usr/bin/python3

import os
import re
import posixpath
from glob import glob

from distutils.core import setup
from setuptools import setup

from distutils.command.install_data import install_data
#from DistUtilsExtra.command.build_extra import build_extra
from DistUtilsExtra.command.build_i18n import build_i18n

def changelog_version(changelog="debian/changelog"):
    version = "dev"
    if posixpath.exists(changelog):
        head=open(changelog).readline()
        match = re.compile(".*\((.*)\).*").match(head)
        if match:
            version = match.group(1)

    return version

class example_content_install_data(install_data, object):

    def finalize_options(self):
        """Add wildcard support for filenames."""
        super(example_content_install_data, self).finalize_options()

        for f in self.data_files:
            if type(f) != str:
                files = f[1]
                i = 0
                while i < len(files):
                    if "*" in files[i]:
                        for e in glob(files[i]):
                            files.append(e)
                        files.pop(i)
                        i -= 1
                    i += 1

    def run(self):
        """Run substitutions on files."""
        super(example_content_install_data, self).run()
        # Causes Lintian warning
        ## os.chmod("etc/skel/examples.desktop", 755)
        return

setup(
    name = "example-content",
    version = changelog_version(),
    author = "Timo Jyrinki",
    author_email = "timo.jyrinki@iki.fi",
    license = "GPL",
    description = "Example Content I18N",
    long_description = """
Python is only used for I18N of the .desktop entry.
""",
    data_files = [
    ("share/example-content/", ["main/*"]),
    ("share/example-content/Ubuntu_Free_Culture_Showcase/", ["Ubuntu_Free_Culture_Showcase/*"]),
                 ],
    cmdclass = {
        "install_data": example_content_install_data,
#        "build" : build_extra,
        "build_i18n" :  build_i18n }
)

