
#include "SDL_opengl.h"

#include "sphere.h"

namespace el3 {

void Sphere::dldraw() {
   static GLuint dl=0;

   if (dl!=0) {
      glCallList(dl);
      return;
   }

   dl = glGenLists(1);

   glNewList(dl,GL_COMPILE_AND_EXECUTE);

	draw();
	glEndList();
}

void Sphere::draw() {
const float vertices[114][3]={
	{0.38268343,0.92387953,0.0000000e+0},
	{0.35355339,0.92387953,0.14644661},
	{0.27059805,0.92387953,0.27059805},
	{0.14644661,0.92387953,0.35355339},
	{2.3431828e-17,0.92387953,0.38268343},
	{-0.14644661,0.92387953,0.35355339},
	{-0.27059805,0.92387953,0.27059805},
	{-0.35355339,0.92387953,0.14644661},
	{-0.38268343,0.92387953,4.6863656e-17},
	{-0.35355339,0.92387953,-0.14644661},
	{-0.27059805,0.92387953,-0.27059805},
	{-0.14644661,0.92387953,-0.35355339},
	{-7.0295484e-17,0.92387953,-0.38268343},
	{0.14644661,0.92387953,-0.35355339},
	{0.27059805,0.92387953,-0.27059805},
	{0.35355339,0.92387953,-0.14644661},
	{0.70710678,0.70710678,0.0000000e+0},
	{0.65328148,0.70710678,0.27059805},
	{0.50000000,0.70710678,0.50000000},
	{0.27059805,0.70710678,0.65328148},
	{4.3296373e-17,0.70710678,0.70710678},
	{-0.27059805,0.70710678,0.65328148},
	{-0.50000000,0.70710678,0.50000000},
	{-0.65328148,0.70710678,0.27059805},
	{-0.70710678,0.70710678,8.6592746e-17},
	{-0.65328148,0.70710678,-0.27059805},
	{-0.50000000,0.70710678,-0.50000000},
	{-0.27059805,0.70710678,-0.65328148},
	{-1.2988912e-16,0.70710678,-0.70710678},
	{0.27059805,0.70710678,-0.65328148},
	{0.50000000,0.70710678,-0.50000000},
	{0.65328148,0.70710678,-0.27059805},
	{0.92387953,0.38268343,0.0000000e+0},
	{0.85355339,0.38268343,0.35355339},
	{0.65328148,0.38268343,0.65328148},
	{0.35355339,0.38268343,0.85355339},
	{5.6569437e-17,0.38268343,0.92387953},
	{-0.35355339,0.38268343,0.85355339},
	{-0.65328148,0.38268343,0.65328148},
	{-0.85355339,0.38268343,0.35355339},
	{-0.92387953,0.38268343,1.1313887e-16},
	{-0.85355339,0.38268343,-0.35355339},
	{-0.65328148,0.38268343,-0.65328148},
	{-0.35355339,0.38268343,-0.85355339},
	{-1.6970831e-16,0.38268343,-0.92387953},
	{0.35355339,0.38268343,-0.85355339},
	{0.65328148,0.38268343,-0.65328148},
	{0.85355339,0.38268343,-0.35355339},
	{1.00000000,6.1230318e-17,0.0000000e+0},
	{0.92387953,6.1230318e-17,0.38268343},
	{0.70710678,6.1230318e-17,0.70710678},
	{0.38268343,6.1230318e-17,0.92387953},
	{6.1230318e-17,6.1230318e-17,1.00000000},
	{-0.38268343,6.1230318e-17,0.92387953},
	{-0.70710678,6.1230318e-17,0.70710678},
	{-0.92387953,6.1230318e-17,0.38268343},
	{-1.00000000,6.1230318e-17,1.2246064e-16},
	{-0.92387953,6.1230318e-17,-0.38268343},
	{-0.70710678,6.1230318e-17,-0.70710678},
	{-0.38268343,6.1230318e-17,-0.92387953},
	{-1.8369095e-16,6.1230318e-17,-1.00000000},
	{0.38268343,6.1230318e-17,-0.92387953},
	{0.70710678,6.1230318e-17,-0.70710678},
	{0.92387953,6.1230318e-17,-0.38268343},
	{0.92387953,-0.38268343,0.0000000e+0},
	{0.85355339,-0.38268343,0.35355339},
	{0.65328148,-0.38268343,0.65328148},
	{0.35355339,-0.38268343,0.85355339},
	{5.6569437e-17,-0.38268343,0.92387953},
	{-0.35355339,-0.38268343,0.85355339},
	{-0.65328148,-0.38268343,0.65328148},
	{-0.85355339,-0.38268343,0.35355339},
	{-0.92387953,-0.38268343,1.1313887e-16},
	{-0.85355339,-0.38268343,-0.35355339},
	{-0.65328148,-0.38268343,-0.65328148},
	{-0.35355339,-0.38268343,-0.85355339},
	{-1.6970831e-16,-0.38268343,-0.92387953},
	{0.35355339,-0.38268343,-0.85355339},
	{0.65328148,-0.38268343,-0.65328148},
	{0.85355339,-0.38268343,-0.35355339},
	{0.70710678,-0.70710678,0.0000000e+0},
	{0.65328148,-0.70710678,0.27059805},
	{0.50000000,-0.70710678,0.50000000},
	{0.27059805,-0.70710678,0.65328148},
	{4.3296373e-17,-0.70710678,0.70710678},
	{-0.27059805,-0.70710678,0.65328148},
	{-0.50000000,-0.70710678,0.50000000},
	{-0.65328148,-0.70710678,0.27059805},
	{-0.70710678,-0.70710678,8.6592746e-17},
	{-0.65328148,-0.70710678,-0.27059805},
	{-0.50000000,-0.70710678,-0.50000000},
	{-0.27059805,-0.70710678,-0.65328148},
	{-1.2988912e-16,-0.70710678,-0.70710678},
	{0.27059805,-0.70710678,-0.65328148},
	{0.50000000,-0.70710678,-0.50000000},
	{0.65328148,-0.70710678,-0.27059805},
	{0.38268343,-0.92387953,0.0000000e+0},
	{0.35355339,-0.92387953,0.14644661},
	{0.27059805,-0.92387953,0.27059805},
	{0.14644661,-0.92387953,0.35355339},
	{2.3431828e-17,-0.92387953,0.38268343},
	{-0.14644661,-0.92387953,0.35355339},
	{-0.27059805,-0.92387953,0.27059805},
	{-0.35355339,-0.92387953,0.14644661},
	{-0.38268343,-0.92387953,4.6863656e-17},
	{-0.35355339,-0.92387953,-0.14644661},
	{-0.27059805,-0.92387953,-0.27059805},
	{-0.14644661,-0.92387953,-0.35355339},
	{-7.0295484e-17,-0.92387953,-0.38268343},
	{0.14644661,-0.92387953,-0.35355339},
	{0.27059805,-0.92387953,-0.27059805},
	{0.35355339,-0.92387953,-0.14644661},
	{0.0000000e+0,1.00000000,0.0000000e+0},
	{0.0000000e+0,-1.00000000,0.0000000e+0},
};
const float normals[114][3]={
	{0.38219484,0.92408176,-1.1358369e-16},
	{0.35310199,0.92408176,0.14625963},
	{0.27025256,0.92408176,0.27025256},
	{0.14625963,0.92408176,0.35310199},
	{-4.6143376e-17,0.92408176,0.38219484},
	{-0.14625963,0.92408176,0.35310199},
	{-0.27025256,0.92408176,0.27025256},
	{-0.35310199,0.92408176,0.14625963},
	{-0.38219484,0.92408176,1.0648471e-17},
	{-0.35310199,0.92408176,-0.14625963},
	{-0.27025256,0.92408176,-0.27025256},
	{-0.14625963,0.92408176,-0.35310199},
	{-6.3890828e-17,0.92408176,-0.38219484},
	{0.14625963,0.92408176,-0.35310199},
	{0.27025256,0.92408176,-0.27025256},
	{0.35310199,0.92408176,-0.14625963},
	{0.70658450,0.70762868,-3.5721617e-17},
	{0.65279895,0.70762868,0.27039818},
	{0.49963069,0.70762868,0.49963069},
	{0.27039818,0.70762868,0.65279895},
	{-4.2865941e-17,0.70762868,0.70658450},
	{-0.27039818,0.70762868,0.65279895},
	{-0.49963069,0.70762868,0.49963069},
	{-0.65279895,0.70762868,0.27039818},
	{-0.70658450,0.70762868,1.3574215e-16},
	{-0.65279895,0.70762868,-0.27039818},
	{-0.49963069,0.70762868,-0.49963069},
	{-0.27039818,0.70762868,-0.65279895},
	{-7.8587558e-17,0.70762868,-0.70658450},
	{0.27039818,0.70762868,-0.65279895},
	{0.49963069,0.70762868,-0.49963069},
	{0.65279895,0.70762868,-0.27039818},
	{0.92368212,0.38315969,-1.0784293e-16},
	{0.85337100,0.38315969,0.35347784},
	{0.65314189,0.38315969,0.65314189},
	{0.35347784,0.38315969,0.85337100},
	{0.0000000e+0,0.38315969,0.92368212},
	{-0.35347784,0.38315969,0.85337100},
	{-0.65314189,0.38315969,0.65314189},
	{-0.85337100,0.38315969,0.35347784},
	{-0.92368212,0.38315969,1.2222199e-16},
	{-0.85337100,0.38315969,-0.35347784},
	{-0.65314189,0.38315969,-0.65314189},
	{-0.35347784,0.38315969,-0.85337100},
	{-1.2222199e-16,0.38315969,-0.92368212},
	{0.35347784,0.38315969,-0.85337100},
	{0.65314189,0.38315969,-0.65314189},
	{0.85337100,0.38315969,-0.35347784},
	{1.00000000,7.2082126e-18,-2.1624638e-16},
	{0.92387953,1.4416425e-17,0.38268343},
	{0.70710678,2.8832850e-17,0.70710678},
	{0.38268343,7.9290338e-17,0.92387953},
	{0.0000000e+0,1.0091498e-16,1.00000000},
	{-0.38268343,8.6498551e-17,0.92387953},
	{-0.70710678,5.0457488e-17,0.70710678},
	{-0.92387953,-1.4416425e-17,0.38268343},
	{-1.00000000,-1.4416425e-17,1.4416425e-17},
	{-0.92387953,2.1624638e-17,-0.38268343},
	{-0.70710678,6.4873913e-17,-0.70710678},
	{-0.38268343,5.0457488e-17,-0.92387953},
	{-1.5858068e-16,1.0091498e-16,-1.00000000},
	{0.38268343,1.5137246e-16,-0.92387953},
	{0.70710678,4.3249275e-17,-0.70710678},
	{0.92387953,-7.2082126e-18,-0.38268343},
	{0.92368212,-0.38315969,-1.6535916e-16},
	{0.85337100,-0.38315969,0.35347784},
	{0.65314189,-0.38315969,0.65314189},
	{0.35347784,-0.38315969,0.85337100},
	{-7.1895288e-18,-0.38315969,0.92368212},
	{-0.35347784,-0.38315969,0.85337100},
	{-0.65314189,-0.38315969,0.65314189},
	{-0.85337100,-0.38315969,0.35347784},
	{-0.92368212,-0.38315969,1.3660105e-16},
	{-0.85337100,-0.38315969,-0.35347784},
	{-0.65314189,-0.38315969,-0.65314189},
	{-0.35347784,-0.38315969,-0.85337100},
	{-1.2941152e-16,-0.38315969,-0.92368212},
	{0.35347784,-0.38315969,-0.85337100},
	{0.65314189,-0.38315969,-0.65314189},
	{0.85337100,-0.38315969,-0.35347784},
	{0.70658450,-0.70762868,-9.6448367e-17},
	{0.65279895,-0.70762868,0.27039818},
	{0.49963069,-0.70762868,0.49963069},
	{0.27039818,-0.70762868,0.65279895},
	{4.6438103e-17,-0.70762868,0.70658450},
	{-0.27039818,-0.70762868,0.65279895},
	{-0.49963069,-0.70762868,0.49963069},
	{-0.65279895,-0.70762868,0.27039818},
	{-0.70658450,-0.70762868,1.6074728e-16},
	{-0.65279895,-0.70762868,-0.27039818},
	{-0.49963069,-0.70762868,-0.49963069},
	{-0.27039818,-0.70762868,-0.65279895},
	{-4.6438103e-17,-0.70762868,-0.70658450},
	{0.27039818,-0.70762868,-0.65279895},
	{0.49963069,-0.70762868,-0.49963069},
	{0.65279895,-0.70762868,-0.27039818},
	{0.38219484,-0.92408176,4.4013681e-16},
	{0.35310199,-0.92408176,0.14625963},
	{0.27025256,-0.92408176,0.27025256},
	{0.14625963,-0.92408176,0.35310199},
	{5.3242356e-17,-0.92408176,0.38219484},
	{-0.14625963,-0.92408176,0.35310199},
	{-0.27025256,-0.92408176,0.27025256},
	{-0.35310199,-0.92408176,0.14625963},
	{-0.38219484,-0.92408176,9.9385732e-17},
	{-0.35310199,-0.92408176,-0.14625963},
	{-0.27025256,-0.92408176,-0.27025256},
	{-0.14625963,-0.92408176,-0.35310199},
	{-7.0989809e-18,-0.92408176,-0.38219484},
	{0.14625963,-0.92408176,-0.35310199},
	{0.27025256,-0.92408176,-0.27025256},
	{0.35310199,-0.92408176,-0.14625963},
	{-7.0801599e-18,1.00000000,-4.3365979e-17},
	{-8.8501998e-18,-1.00000000,-6.2393909e-17},
};
//o sphere1
//material(mtl_sphere::m_default);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
glEnd();
}

std::ostream& operator<<(std::ostream&s, Sphere sk) {
	return s;
}

} //namespace
