C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      INTEGER FUNCTION IGLREV (PMAT, KCOL, KROW, KDIR, KPR, KERR)
C
C---->
C**** *IGLREV*
C
C     PURPOSE
C     _______
C
C     This routine reverses either the rows or the columns of a
C     rectangular matrix.
C
C     INTERFACE
C     _________
C
C     IERR = IGLREV (PMAT, KCOL, KROW, KDIR, KPR, KERR)
C
C     Input parameters
C     ________________
C
C     PMAT       - The input matrix of dimension (KCOL, KROW).
C
C     KCOL       - The length of the first dimension of PMAT.
C
C     KROW       - The length of the second dimension of PMAT.
C
C     KDIR       - 1    Reverses the order in each column.
C                       West-East reversal for meteorological fields.
C                  2    Reverses the order in each row.
C                       North-South reversal for meteorological fields.
C
C     KPR        - The debug print switch.
C                  0  , No debugging output.
C                  1  , Produce debugging output.
C
C     KERR       - The error control flag.
C                  -ve, No error message. Return error code.
C                  0  , Hard failure with error message.
C                  +ve, Print error message. Return error code.
C
C     Output parameters
C     ________________
C
C     PMAT       - The transformed matrix.
C
C     Return value
C     ____________
C
C     The error indicator (INTEGER).
C
C     Error and Warning Return Values
C     _______________________________
C
C     None
C
C     Common block usage
C     __________________
C
C     None
C
C     EXTERNALS
C     _________
C
C     INTLOG     - Logs messages.
C
C     METHOD
C     ______
C
C     KDIR = 1 is implemented by swapping elements within each column
C              of the matrix.
C
C     KDIR = 2 is implemented by reversing the order of the columns.
C
C     REFERENCE
C     _________
C
C     None
C
C     COMMENTS
C     ________
C
C     Program contains sections 0 to 3 and 9
C
C     AUTHOR
C     ______
C
C     K. Fielding      *ECMWF*      Jan 1994
C
C     MODIFICATIONS
C     _____________
C
C     None
C
C----<
C     _______________________________________________________
C
C
C*    Section 0. Definition of variables.
C     _______________________________________________________
C
C*    Prefix conventions for variable names
C
C     Logical      L (but not LP), global or common.
C                  O, dummy argument
C                  G, local variable
C                  LP, parameter.
C     Character    C, global or common.
C                  H, dummy argument
C                  Y (but not YP), local variable
C                  YP, parameter.
C     Integer      M and N, global or common.
C                  K, dummy argument
C                  I, local variable
C                  J (but not JP), loop control
C                  JP, parameter.
C     REAL         A to F and Q to X, global or common.
C                  P (but not PP), dummy argument
C                  Z, local variable
C                  PP, parameter.
C
C     Implicit statement to force declarations
C
      IMPLICIT NONE
C
#include "parim.h"
C
C     Dummy arguments
C
      INTEGER KCOL, KROW, KDIR, KPR, KERR
C
      REAL PMAT (KCOL, KROW)
C
C     Local variables
C
      INTEGER IHALF
C
      INTEGER JSTEP, JMOVE
C
      REAL ZTEMP
C
      INTEGER JPROUTINE
C
      PARAMETER (JPROUTINE = 7300)
C
C     External functions
C
C
C     _______________________________________________________
C
C
C*    Section 1. Initialisation
C     _______________________________________________________
C
  100 CONTINUE
C
      IF (KPR .GE. 1) CALL INTLOG(JP_DEBUG,'IGLREV: Section 1.',JPQUIET)
C
      IGLREV = 0
C
      IF (KPR .GE. 1) THEN
        CALL INTLOG(JP_DEBUG,'IRSCAN: Input parameters.',JPQUIET)
        CALL INTLOG(JP_DEBUG,'IRSCAN: First matrix dimension is ',KCOL)
        CALL INTLOG(JP_DEBUG,'IRSCAN: Second matrix dimension is ',KROW)
        CALL INTLOG(JP_DEBUG,'IRSCAN: Direction value is ',KDIR)
        CALL INTLOG(JP_DEBUG,'IRSCAN: Input parameters.',JPQUIET)
      ENDIF
C
C     _______________________________________________________
C
C
C*    Section 2. Matrix COLUMN reversal (Field row interchange - WE)
C     _______________________________________________________
C
  200 CONTINUE
C
      IF (KPR .GE. 1) CALL INTLOG(JP_DEBUG,'IGLREV: Section 2.',JPQUIET)
C
      IF (KDIR .EQ. 1) THEN
C
         IHALF = KCOL / 2
C
         DO 220 JMOVE = 1, IHALF
C
            DO 210 JSTEP = 1, KROW
C
               ZTEMP = PMAT (KCOL + 1 - JMOVE, JSTEP)
               PMAT (KCOL + 1 - JMOVE, JSTEP) = PMAT (JMOVE, JSTEP)
               PMAT (JMOVE, JSTEP) = ZTEMP
C
  210       CONTINUE
C
  220    CONTINUE
C
      ELSE
C
C     _______________________________________________________
C
C
C*    Section 3. Matrix ROW reversal (Field column interchange - NS)
C     _______________________________________________________
C
  300 CONTINUE
C
      IF (KPR .GE. 1) CALL INTLOG(JP_DEBUG,'IGLREV: Section 3.',JPQUIET)
C
         IHALF = KROW / 2
C
         DO 320 JMOVE = 1, IHALF
C
            DO 310 JSTEP = 1, KCOL
C
               ZTEMP = PMAT (JSTEP, KROW + 1 - JMOVE)
               PMAT (JSTEP, KROW + 1 - JMOVE) = PMAT (JSTEP, JMOVE)
               PMAT (JSTEP, JMOVE) = ZTEMP
C
  310       CONTINUE
C
  320    CONTINUE
C
      ENDIF
C
C     _______________________________________________________
C
C
C*    Section 9. Return to calling routine. Format statements
C     _______________________________________________________
C
  900 CONTINUE
C
      IF (KPR .GE. 1) CALL INTLOG(JP_DEBUG,'IGLREV: Section 9.',JPQUIET)
C
      RETURN
      END
