/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.util;

import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.InternalErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericObjectFactory<I> {
    public I newInstance(String className) throws CliCommandoException {
        I classObject = null;
        try {
            classObject = (I)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new InternalErrorException("Failed to load '" + className + "' - probably can't find it. Full msg:\n" + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new InternalErrorException("Failed to instantiate object for: " + className, e);
        }
        catch (Exception e) {
            throw new InternalErrorException("Failed to load " + className + ": \n Reason: " + e.getMessage(), e);
        }
        if (classObject == null) {
            throw new InternalErrorException("Failed to load object for: " + className + " null object returned");
        }
        return classObject;
    }
}

