#ifndef PARTITIONINGITEM_H
#define PARTITIONINGITEM_H

#include <dataItem.h>
#include <inputDataItem.h>

namespace BALL
{
	namespace VIEW
	{
		class InputPartitionItem;
		
		class PartitioningItem : public DataItem
		{
			public:
				PartitioningItem(InputDataItem* input, DataItemView* miv, unsigned int folds, double& fraction, int ID=-1);
				~PartitioningItem();

				bool execute();

				enum { Type = UserType + 128 };
				int type() const { return Type; }
	
				void addToPipeline();
				void removeFromPipeline();
				
				InputDataItem* getInputItem();
				
				double getValFraction();
				unsigned int getNoFolds();
				unsigned int getID();
				
				/** Set the ID. Neccessary only after restoring a PartitioningItem from a config-file. */
				void setID(unsigned int ID);
				
				/** Adds a new external validation fold (pair of \<training-partition,test-partition\>) whose data is to be generated by this object. */
				void addFold(std::pair<InputPartitionItem*,InputPartitionItem*> fold);
				
				/** Removes the fold (== _both_ training- and test-partition) of the given partition  */
				void removePartition(InputPartitionItem* partition);
				
				/** checks whether all partitions have already been created */
				bool isDone();
				
				void setInput(InputDataItem* new_input);
				

			private:
				
				BALL::String getMouseOverText();
				
				InputDataItem* input_;
				
				unsigned int no_folds_;
				
				/** the fraction of compounds of the input data set that is to be used as validation set */
				double val_fraction_;
				
				/** the ID of this PartitioningItem with regard to its InputDataItem.
				It is only used during writing the config-file. */
				unsigned int id_;
				
				/** all external validation folds whose data is to be generated by this item as pairs of \<training-partition,test-partition\> */
				std::list<std::pair<InputPartitionItem*,InputPartitionItem*> > folds_;
				
				
			friend class DataItemScene;
			friend class InputDataItemIO;

		};
	}
}

#endif
