# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os

from apache_openid.utils.mock import MockUtil
from apache_openid.utils.modpython import ModPythonUtil

__all__ = ['FieldStorage', 'Session',
    'DONE', 'HTTP_FORBIDDEN', 'HTTP_MOVED_TEMPORARILY', 'OK', 'SERVER_RETURN',
    'add_cookie', 'get_cookies', 'log_error']

if 'APACHE_OPENID_MOCK' in os.environ:
    utils_obj = MockUtil()
else:
    utils_obj = ModPythonUtil()

# Class definitions
FieldStorage = utils_obj.cls_field_storage()
Session = utils_obj.cls_session()

# Const definitions
DONE = utils_obj.const_done()
HTTP_FORBIDDEN = utils_obj.const_http_forbidden()
HTTP_MOVED_TEMPORARILY = utils_obj.const_http_moved_temporarily()
OK = utils_obj.const_ok()
SERVER_RETURN = utils_obj.const_server_return()

# Function definitions
add_cookie = utils_obj.func_add_cookie()
get_cookies = utils_obj.func_get_cookies()
log_error = utils_obj.func_log_error()
