//
// This file is part of the aMule AdunanzA Project (mod of official aMule)
//
// Copyright (c) 2003-2012 aMule AdunanzA Team ( http://www.adunanza.net )
//
// Any parts of this program derived from the xMule, lMule, eMule or aMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#if !defined(CLIENT_GUI) && !defined(AMULE_DAEMON)

#include "AdunanzAStreaming.h"
#include "PartFile.h"
#include "GuiEvents.h" // needed for CoreNotify_PartFile_XXXXXXX
#include "OtherFunctions.h" // needed for ftVideo, GetFiletype...
#include "DownloadQueue.h"  // needed for CDownloadQueue methods
#include "amule.h" // needed for theApp
#include "muuli_wdr.h" // needed for ID_BUTTON_FAST
#include "MuleTextCtrl.h"  // needed for CMuleTextCtrl

void CAdunanzAStreaming::resumeAllSuspended()
{
	for (std::list<CPartFile*>::iterator it = m_suspendedDownloads.begin(); it != m_suspendedDownloads.end(); ++it) {
		CPartFile* pFile = *it;
		if (!pFile) continue;
		// std::clog << "(Mr Hyde DBG) resume of " pFile->GetFileName().GetPrintable();
		CoreNotify_PartFile_Resume(pFile);
	}
	m_suspendedDownloads.clear();
}

void CAdunanzAStreaming::stop()
{
	// ripristino la priorita' originale del target
	if (m_originalTargetPriority == PR_AUTO) {
		CoreNotify_PartFile_PrioAuto(m_pTargetFile, true);
	} else {
		CoreNotify_PartFile_PrioAuto(m_pTargetFile, false);
		CoreNotify_PartFile_PrioSet(m_pTargetFile, m_originalTargetPriority, true);
	}
	
	m_lastConsecutiveCompletePart = 0;
	m_requiredParts = 0; 
	// azzero il puntatore del target
	m_pTargetFile = 0;

	// PRIMA faccio il resume
	resumeAllSuspended();
	// POI faccio il reset dello stato
	m_status = CAdunanzAStreaming::None;
	
	m_originalTargetPriority = PR_AUTO; 
	m_lastConsecutiveCompletePart = 0;
	m_requiredParts = 0;

	// riabilito FastEd2kLinks
	CAdunanzAStreaming::enableFastEd2kLinks(true); 
}


bool CAdunanzAStreaming::start()
{
	if (!canStart()) return false;
	m_status = CAdunanzAStreaming::Started;
	return true;
}

bool CAdunanzAStreaming::canRequest(const CPartFile* pCandidateTarget) const
{
	// request is allowed only when no other request are pending/running
	if (m_status != CAdunanzAStreaming::None) {
		return false;
	}
	if (!pCandidateTarget) return false; // NULL pointer not allowed

	if (GetFiletype(pCandidateTarget->GetFileName()) != ftVideo) return false; // not video

	if (pCandidateTarget->IsCompleted()) {
		// already completed
		return false;
	}

	if (m_pTargetFile) return false; // ho gia' un target

	// poi dovrei controllare anche la dimensione gia' scaricata, lo stato del file...

	// per ora restituisco true
	return true;
}

// static
void CAdunanzAStreaming::enableFastEd2kLinks(bool bEnable)
{
	// abilito/disabilito il tasto "Commit" e il relativo campo 
	CMuleTextCtrl* /*wxTextCtrl* */ pTextField = dynamic_cast<CMuleTextCtrl* /*wxTextCtrl* */>(wxWindow::FindWindowByName( wxT("FastEd2kLinks"), NULL));
	if (pTextField) {
		pTextField->Clear();
		if (!bEnable) {
			wxString theText = CFormat(_("ACTIVE STREAMING: %s")) %  theApp->m_AdunanzAStreaming.m_pTargetFile->GetFileName().GetPrintable();
			wxTextAttr attr(wxNullColour, *wxRED, wxNullFont, wxTEXT_ALIGNMENT_CENTRE);
			pTextField->SetDefaultStyle(attr);
			// pTextField->ChangeValue(theText);
			pTextField->AppendText(theText);
		}

		pTextField->Enable(bEnable);
	}
	wxButton* pButton = dynamic_cast<wxButton*>(wxWindow::FindWindowById(ID_BUTTON_FAST));
	if (pButton) {
		pButton->Enable(bEnable);
	}
	
}

bool CAdunanzAStreaming::request(CPartFile* pTarget, std::list<CPartFile*>& downloadingList)
{
	// request is allowed only when no other request are pending/running
	if (!canRequest(pTarget)) {
		std::clog << "Cannot request streaming - another one is running" << std::endl;
		return false;
	}

	// ok, "SIIIII.... PUOOOOOO..... FAREEEEEEE!!!!!!!"  ("It could work", Frankenstein Junior)

	// imposto a Requesting
	m_status = CAdunanzAStreaming::Requesting;

	// salvo il target
	m_pTargetFile = pTarget;

	// salvo la priorita' originale
	m_originalTargetPriority = m_pTargetFile->IsAutoDownPriority() ? PR_AUTO : m_pTargetFile->GetDownPriority();

	// disabilio il tasto "Commit" e il relativo campo
	CAdunanzAStreaming::enableFastEd2kLinks(false); 

	// metto tutti gli altri in PAUSA
	for (std::list<CPartFile*>::iterator it = downloadingList.begin(); it != downloadingList.end(); ++it) {
		CPartFile* pFile = *it;
		if (!pFile) continue;
		if (pFile == m_pTargetFile) continue;
		CoreNotify_PartFile_Pause(pFile);			
		m_suspendedDownloads.push_back(pFile);
	}

	// imposto il target per il download sequenziale

	// metto la priorita' di download al massimo sul target
	CoreNotify_PartFile_PrioAuto(m_pTargetFile, false );
	CoreNotify_PartFile_PrioSet(m_pTargetFile, PR_HIGH, true ); // notare che in aMule _NON_ esiste PR_VERYHIGH per i file in down (c'e' solo per quelli in upload)

	// sposto gli A4F su questo file
	CoreNotify_PartFile_Swap_A4AF(m_pTargetFile);

	m_status = CAdunanzAStreaming::Requested;

	return true;
}

bool CAdunanzAStreaming::request(CPartFile* pTarget)
{
	std::list<CPartFile*> downloadingList;
	theApp->downloadqueue->GetCopyOfDownloadingList(downloadingList);
	return request(pTarget, downloadingList);
}

void CAdunanzAStreaming::updateLastConsecutiveCompletePart()
{
	if (m_status <= CAdunanzAStreaming::Requesting) return;
	if (!m_pTargetFile) return;

	const uint16 partCount = m_pTargetFile->GetPartCount();
	for (register uint16 pc = m_lastConsecutiveCompletePart+1; pc < partCount; pc++) {
		if (!m_pTargetFile->IsComplete(pc)) break; // stop on first NON complete part!
		m_lastConsecutiveCompletePart = pc;
	}
}


void CAdunanzAStreaming::checkForReady()
{
	if (m_status != CAdunanzAStreaming::Requested) return;

	if (!m_pTargetFile) return;

	// non so ancora che controllo posso fare
	// su eMuleAdunanzA e' una cosa del tipo
	//
	// 	if(IsReadyForPreview() && GetPercentCompleted() > thePrefs.m_BufferStreaming)

	if (!m_pTargetFile->PreviewAvailable()) return; 
/*
	if (m_pTargetFile->PreviewAvailable() && 
		(m_pTargetFile->GetPercentCompleted() > thePrefs::ADU_GetBufferStreamingPercentageThreshold())) {
		m_status = CAdunanzAStreaming::Ready;
	}
*/
	// devo avere ALMENO tanti chunck consecutivi (dall'inizio) quanti corrispondenti alla percentuale delle preferenze
	m_requiredParts = 1 + (uint16) (0.01f * thePrefs::ADU_GetBufferStreamingPercentageThreshold() * m_pTargetFile->GetPartCount());

	if (getLastConsecutiveCompletePart() >= m_requiredParts) {
		m_status = CAdunanzAStreaming::Ready;
	}	
		
}


void CAdunanzAStreaming::checkForStop()
{
	// se il file ha terminato il download allora devo fare lo stop
	if ((m_status == CAdunanzAStreaming::None) || !m_pTargetFile) return;

	if (m_pTargetFile->IsCompleted()) {
		stop();
	}
}

#endif


