/*******************************************************************************
 *  PROJECT: Palette parser
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2006 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/
#ifndef __PP_UTIL_H
#define __PP_UTIL_H

#include <glibmm/ustring.h>
#include <cstddef>
 
namespace pp
{

    // General tool to strip spaces from both ends of a string
    // from Bruce Eckel's "Thinking in C++" book
    inline Glib::ustring trim(const Glib::ustring& s) {
        const Glib::ustring whitespace(" \a\b\f\n\r\t\v");
        if(s.length() == 0)
            return s;
        std::size_t beg = s.find_first_not_of(whitespace);
        std::size_t end = s.find_last_not_of(whitespace);
        if(beg == Glib::ustring::npos) // No non-spaces
            return "";
        return Glib::ustring(s, beg, end - beg + 1);
    }

} // namespace pp

#endif // __PP_UTIL_H
