# -*- Autoconf -*-
#
# Copyright (c) 2005-2007 The ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-extlibs on 2007/04/03 07:12:02 +0000

#
# Command-line options for the "configure" script
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-extlibs
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# ABI_EXTLIB_BIGDFT()
# -------------------
#
# Sets all variables needed to handle the BIGDFT external library.
#
AC_DEFUN([ABI_EXTLIB_BIGDFT],
[dnl Initial setup
 bigdft_include=""
 bigdft_ldflags=""

 dnl Define variables needed to build the library
 if test -z "${CPPFLAGS_BIGDFT}"; then
  CPPFLAGS_BIGDFT="${CPPFLAGS}"
 fi
 AC_SUBST(CPPFLAGS_BIGDFT)
 if test -z "${CFLAGS_BIGDFT}"; then
  CFLAGS_BIGDFT="${CFLAGS}"
 fi
 AC_SUBST(CFLAGS_BIGDFT)
 if test -z "${CXXFLAGS_BIGDFT}"; then
  CXXFLAGS_BIGDFT="${CXXFLAGS}"
 fi
 AC_SUBST(CXXFLAGS_BIGDFT)
 if test -z "${FCFLAGS_BIGDFT}"; then
  FCFLAGS_BIGDFT="${FCFLAGS}"
 fi
 AC_SUBST(FCFLAGS_BIGDFT)

 dnl Add optimizations for Fortran flags
 FCFLAGS_BIGDFT="${FCFLAGS_BIGDFT} ${FCFLAGS_OPT}"

 dnl Output library status
 AC_MSG_CHECKING([whether to use the BIGDFT library])
 AC_MSG_RESULT([${enable_bigdft}])

 dnl Determine what to do
 if test "${enable_bigdft}" = "yes"; then
  AC_DEFINE([HAVE_BIGDFT],1,[Define to 1 if you want to use the BIGDFT bindings])

  if test "${with_bigdft_include}" = "" -o "${with_bigdft_ldflags}" = "" -o           "${enable_extlibs}" = "no"; then
   bigdft_include="-I\$(abinit_builddir)/lib/bigdft"
   bigdft_ldflags="-L\$(abinit_builddir)/lib/bigdft -lbigdft"
   build_bigdft="yes"

   if test "${enable_tricks}" = "yes"; then
    ABI_TRICKS_BIGDFT()
    if test "${bigdft_tricks_bypass}" = "yes"; then
     build_bigdft="no"
    fi
   fi
  else
   bigdft_include="${with_bigdft_include}"
   bigdft_ldflags="${with_bigdft_ldflags}"
   build_bigdft="no"
  fi
 else
  build_bigdft="no"
 fi

 dnl Output result
 AC_MSG_CHECKING([whether to build the BIGDFT library])
 AC_MSG_RESULT([${build_bigdft}])

 dnl Substitute variables needed for the use of the library
 AC_SUBST(bigdft_include)
 AC_SUBST(bigdft_ldflags)
 AC_SUBST(build_bigdft)

 dnl Inform Automake
 AM_CONDITIONAL(DO_BUILD_BIGDFT,test "${build_bigdft}" = "yes")
 AM_CONDITIONAL(DO_ENABLE_BIGDFT,test "${enable_bigdft}" = "yes")
]) # ABI_EXTLIB_BIGDFT



# ABI_EXTLIB_LINALG()
# -------------------
#
# Sets all variables needed to handle the LINALG external library.
#
AC_DEFUN([ABI_EXTLIB_LINALG],
[dnl Initial setup
 linalg_include=""
 linalg_ldflags=""

 dnl Define variables needed to build the library
 if test -z "${CPPFLAGS_LINALG}"; then
  CPPFLAGS_LINALG="${CPPFLAGS}"
 fi
 AC_SUBST(CPPFLAGS_LINALG)
 if test -z "${CFLAGS_LINALG}"; then
  CFLAGS_LINALG="${CFLAGS}"
 fi
 AC_SUBST(CFLAGS_LINALG)
 if test -z "${CXXFLAGS_LINALG}"; then
  CXXFLAGS_LINALG="${CXXFLAGS}"
 fi
 AC_SUBST(CXXFLAGS_LINALG)
 if test -z "${FCFLAGS_LINALG}"; then
  FCFLAGS_LINALG="${FCFLAGS}"
 fi
 AC_SUBST(FCFLAGS_LINALG)

 dnl Add optimizations for Fortran flags
 FCFLAGS_LINALG="${FCFLAGS_LINALG} ${FCFLAGS_OPT}"

 dnl Output library status
 AC_MSG_CHECKING([whether to use the LINALG library])
 AC_MSG_RESULT([${enable_linalg}])

 dnl Determine what to do
 if test "${enable_linalg}" = "yes"; then
  AC_DEFINE([HAVE_LINALG],1,[Define to 1 if you want to use the LINALG bindings])

  if test "${with_linalg_ldflags}" = "" -o "${enable_extlibs}" = "no"; then
   linalg_ldflags="-L\$(abinit_builddir)/lib/linalg -llinalg"
   build_linalg="yes"

   if test "${enable_tricks}" = "yes"; then
    ABI_TRICKS_LINALG(${linalg_type})
    if test "${linalg_tricks_bypass}" = "yes"; then
     build_linalg="no"
    fi
   fi
  else
   linalg_ldflags="${with_linalg_ldflags}"
   build_linalg="no"
  fi
 else
  build_linalg="no"
 fi

 dnl Output result
 AC_MSG_CHECKING([whether to build the LINALG library])
 AC_MSG_RESULT([${build_linalg}])

 dnl Substitute variables needed for the use of the library
 AC_SUBST(linalg_include)
 AC_SUBST(linalg_ldflags)
 AC_SUBST(build_linalg)

 dnl Inform Automake
 AM_CONDITIONAL(DO_BUILD_LINALG,test "${build_linalg}" = "yes")
 AM_CONDITIONAL(DO_ENABLE_LINALG,test "${enable_linalg}" = "yes")
]) # ABI_EXTLIB_LINALG



# ABI_EXTLIB_NETCDF()
# -------------------
#
# Sets all variables needed to handle the NETCDF external library.
#
AC_DEFUN([ABI_EXTLIB_NETCDF],
[dnl Initial setup
 netcdf_include=""
 netcdf_ldflags=""

 dnl Define variables needed to build the library
 if test -z "${CPPFLAGS_NETCDF}"; then
  CPPFLAGS_NETCDF="${CPPFLAGS}"
 fi
 AC_SUBST(CPPFLAGS_NETCDF)
 if test -z "${CFLAGS_NETCDF}"; then
  CFLAGS_NETCDF="${CFLAGS}"
 fi
 AC_SUBST(CFLAGS_NETCDF)
 if test -z "${CXXFLAGS_NETCDF}"; then
  CXXFLAGS_NETCDF="${CXXFLAGS}"
 fi
 AC_SUBST(CXXFLAGS_NETCDF)
 if test -z "${FCFLAGS_NETCDF}"; then
  FCFLAGS_NETCDF="${FCFLAGS}"
 fi
 AC_SUBST(FCFLAGS_NETCDF)

 dnl Add optimizations for Fortran flags
 FCFLAGS_NETCDF="${FCFLAGS_NETCDF} ${FCFLAGS_OPT}"

 dnl Output library status
 AC_MSG_CHECKING([whether to use the NETCDF library])
 AC_MSG_RESULT([${enable_netcdf}])

 dnl Determine what to do
 if test "${enable_netcdf}" = "yes"; then
  AC_DEFINE([HAVE_NETCDF],1,[Define to 1 if you want to use the NETCDF bindings])

  if test "${with_netcdf_include}" = "" -o "${with_netcdf_ldflags}" = "" -o           "${enable_extlibs}" = "no"; then
   netcdf_include="-I\$(abinit_builddir)/lib/netcdf"
   netcdf_ldflags="-L\$(abinit_builddir)/lib/netcdf -lnetcdf"
   build_netcdf="yes"

   if test "${enable_tricks}" = "yes"; then
    ABI_TRICKS_NETCDF(${fc_type},${fc_version})
    if test "${netcdf_tricks_bypass}" = "yes"; then
     build_netcdf="no"
    fi
   fi
  else
   netcdf_include="${with_netcdf_include}"
   netcdf_ldflags="${with_netcdf_ldflags}"
   build_netcdf="no"
  fi
 else
  build_netcdf="no"
 fi

 dnl Output result
 AC_MSG_CHECKING([whether to build the NETCDF library])
 AC_MSG_RESULT([${build_netcdf}])

 dnl Substitute variables needed for the use of the library
 AC_SUBST(netcdf_include)
 AC_SUBST(netcdf_ldflags)
 AC_SUBST(build_netcdf)

 dnl Inform Automake
 AM_CONDITIONAL(DO_BUILD_NETCDF,test "${build_netcdf}" = "yes")
 AM_CONDITIONAL(DO_ENABLE_NETCDF,test "${enable_netcdf}" = "yes")
]) # ABI_EXTLIB_NETCDF



# ABI_EXTLIB_ETSF_IO()
# --------------------
#
# Sets all variables needed to handle the ETSF_IO external library.
#
AC_DEFUN([ABI_EXTLIB_ETSF_IO],
[dnl Initial setup
 etsf_io_include=""
 etsf_io_ldflags=""

 dnl Define variables needed to build the library
 if test -z "${CPPFLAGS_ETSF_IO}"; then
  CPPFLAGS_ETSF_IO="${CPPFLAGS}"
 fi
 AC_SUBST(CPPFLAGS_ETSF_IO)
 if test -z "${CFLAGS_ETSF_IO}"; then
  CFLAGS_ETSF_IO="${CFLAGS}"
 fi
 AC_SUBST(CFLAGS_ETSF_IO)
 if test -z "${CXXFLAGS_ETSF_IO}"; then
  CXXFLAGS_ETSF_IO="${CXXFLAGS}"
 fi
 AC_SUBST(CXXFLAGS_ETSF_IO)
 if test -z "${FCFLAGS_ETSF_IO}"; then
  FCFLAGS_ETSF_IO="${FCFLAGS}"
 fi
 AC_SUBST(FCFLAGS_ETSF_IO)

 dnl Add optimizations for Fortran flags
 FCFLAGS_ETSF_IO="${FCFLAGS_ETSF_IO} ${FCFLAGS_OPT}"

 dnl Output library status
 AC_MSG_CHECKING([whether to use the ETSF_IO library])
 AC_MSG_RESULT([${enable_etsf_io}])

 dnl Determine what to do
 if test "${enable_etsf_io}" = "yes"; then
  AC_DEFINE([HAVE_ETSF_IO],1,[Define to 1 if you want to use the ETSF_IO bindings])

  if test "${with_etsf_io_include}" = "" -o "${with_etsf_io_ldflags}" = "" -o           "${enable_extlibs}" = "no"; then
   etsf_io_include="-I\$(abinit_builddir)/lib/etsf_io"
   etsf_io_ldflags="-L\$(abinit_builddir)/lib/etsf_io -letsf_io"
   build_etsf_io="yes"

   if test "${enable_tricks}" = "yes"; then
    ABI_TRICKS_ETSF_IO()
    if test "${etsf_io_tricks_bypass}" = "yes"; then
     build_etsf_io="no"
    fi
   fi
  else
   etsf_io_include="${with_etsf_io_include}"
   etsf_io_ldflags="${with_etsf_io_ldflags}"
   build_etsf_io="no"
  fi
 else
  build_etsf_io="no"
 fi

 dnl Output result
 AC_MSG_CHECKING([whether to build the ETSF_IO library])
 AC_MSG_RESULT([${build_etsf_io}])

 dnl Substitute variables needed for the use of the library
 AC_SUBST(etsf_io_include)
 AC_SUBST(etsf_io_ldflags)
 AC_SUBST(build_etsf_io)

 dnl Inform Automake
 AM_CONDITIONAL(DO_BUILD_ETSF_IO,test "${build_etsf_io}" = "yes")
 AM_CONDITIONAL(DO_ENABLE_ETSF_IO,test "${enable_etsf_io}" = "yes")
]) # ABI_EXTLIB_ETSF_IO



# ABI_EXTLIB_ETSF_XC()
# --------------------
#
# Sets all variables needed to handle the ETSF_XC external library.
#
AC_DEFUN([ABI_EXTLIB_ETSF_XC],
[dnl Initial setup
 etsf_xc_include=""
 etsf_xc_ldflags=""

 dnl Define variables needed to build the library
 if test -z "${CPPFLAGS_ETSF_XC}"; then
  CPPFLAGS_ETSF_XC="${CPPFLAGS}"
 fi
 AC_SUBST(CPPFLAGS_ETSF_XC)
 if test -z "${CFLAGS_ETSF_XC}"; then
  CFLAGS_ETSF_XC="${CFLAGS}"
 fi
 AC_SUBST(CFLAGS_ETSF_XC)
 if test -z "${CXXFLAGS_ETSF_XC}"; then
  CXXFLAGS_ETSF_XC="${CXXFLAGS}"
 fi
 AC_SUBST(CXXFLAGS_ETSF_XC)
 if test -z "${FCFLAGS_ETSF_XC}"; then
  FCFLAGS_ETSF_XC="${FCFLAGS}"
 fi
 AC_SUBST(FCFLAGS_ETSF_XC)

 dnl Add optimizations for Fortran flags
 FCFLAGS_ETSF_XC="${FCFLAGS_ETSF_XC} ${FCFLAGS_OPT}"

 dnl Output library status
 AC_MSG_CHECKING([whether to use the ETSF_XC library])
 AC_MSG_RESULT([${enable_etsf_xc}])

 dnl Determine what to do
 if test "${enable_etsf_xc}" = "yes"; then
  AC_DEFINE([HAVE_ETSF_XC],1,[Define to 1 if you want to use the ETSF_XC bindings])

  if test "${with_etsf_xc_include}" = "" -o "${with_etsf_xc_ldflags}" = "" -o           "${enable_extlibs}" = "no"; then
   etsf_xc_include="-I\$(abinit_builddir)/lib/etsf_xc"
   etsf_xc_ldflags="-L\$(abinit_builddir)/lib/etsf_xc -letsf_xc"
   build_etsf_xc="yes"

   if test "${enable_tricks}" = "yes"; then
    ABI_TRICKS_ETSF_XC()
    if test "${etsf_xc_tricks_bypass}" = "yes"; then
     build_etsf_xc="no"
    fi
   fi
  else
   etsf_xc_include="${with_etsf_xc_include}"
   etsf_xc_ldflags="${with_etsf_xc_ldflags}"
   build_etsf_xc="no"
  fi
 else
  build_etsf_xc="no"
 fi

 dnl Output result
 AC_MSG_CHECKING([whether to build the ETSF_XC library])
 AC_MSG_RESULT([${build_etsf_xc}])

 dnl Substitute variables needed for the use of the library
 AC_SUBST(etsf_xc_include)
 AC_SUBST(etsf_xc_ldflags)
 AC_SUBST(build_etsf_xc)

 dnl Inform Automake
 AM_CONDITIONAL(DO_BUILD_ETSF_XC,test "${build_etsf_xc}" = "yes")
 AM_CONDITIONAL(DO_ENABLE_ETSF_XC,test "${enable_etsf_xc}" = "yes")
]) # ABI_EXTLIB_ETSF_XC



# ABI_EXTLIB_XMLF90()
# -------------------
#
# Sets all variables needed to handle the XMLF90 external library.
#
AC_DEFUN([ABI_EXTLIB_XMLF90],
[dnl Initial setup
 xmlf90_include=""
 xmlf90_ldflags=""

 dnl Define variables needed to build the library
 if test -z "${CPPFLAGS_XMLF90}"; then
  CPPFLAGS_XMLF90="${CPPFLAGS}"
 fi
 AC_SUBST(CPPFLAGS_XMLF90)
 if test -z "${CFLAGS_XMLF90}"; then
  CFLAGS_XMLF90="${CFLAGS}"
 fi
 AC_SUBST(CFLAGS_XMLF90)
 if test -z "${CXXFLAGS_XMLF90}"; then
  CXXFLAGS_XMLF90="${CXXFLAGS}"
 fi
 AC_SUBST(CXXFLAGS_XMLF90)
 if test -z "${FCFLAGS_XMLF90}"; then
  FCFLAGS_XMLF90="${FCFLAGS}"
 fi
 AC_SUBST(FCFLAGS_XMLF90)

 dnl Add optimizations for Fortran flags
 FCFLAGS_XMLF90="${FCFLAGS_XMLF90} ${FCFLAGS_OPT}"

 dnl Output library status
 AC_MSG_CHECKING([whether to use the XMLF90 library])
 AC_MSG_RESULT([${enable_xmlf90}])

 dnl Determine what to do
 if test "${enable_xmlf90}" = "yes"; then
  AC_DEFINE([HAVE_XMLF90],1,[Define to 1 if you want to use the XMLF90 bindings])

  if test "${with_xmlf90_include}" = "" -o "${with_xmlf90_ldflags}" = "" -o           "${enable_extlibs}" = "no"; then
   xmlf90_include="-I\$(abinit_builddir)/lib/xmlf90"
   xmlf90_ldflags="-L\$(abinit_builddir)/lib/xmlf90 -lxmlf90"
   build_xmlf90="yes"

   if test "${enable_tricks}" = "yes"; then
    ABI_TRICKS_XMLF90()
    if test "${xmlf90_tricks_bypass}" = "yes"; then
     build_xmlf90="no"
    fi
   fi
  else
   xmlf90_include="${with_xmlf90_include}"
   xmlf90_ldflags="${with_xmlf90_ldflags}"
   build_xmlf90="no"
  fi
 else
  build_xmlf90="no"
 fi

 dnl Output result
 AC_MSG_CHECKING([whether to build the XMLF90 library])
 AC_MSG_RESULT([${build_xmlf90}])

 dnl Substitute variables needed for the use of the library
 AC_SUBST(xmlf90_include)
 AC_SUBST(xmlf90_ldflags)
 AC_SUBST(build_xmlf90)

 dnl Inform Automake
 AM_CONDITIONAL(DO_BUILD_XMLF90,test "${build_xmlf90}" = "yes")
 AM_CONDITIONAL(DO_ENABLE_XMLF90,test "${enable_xmlf90}" = "yes")
]) # ABI_EXTLIB_XMLF90
